<?php if ($this->previewMode): ?>
    <div class="form-control">
        <pre><?= e($value) ?></pre>
    </div>
<?php else: ?>
    <div
        id="<?= $this->getId() ?>"
        class="field-codeeditor size-<?= $size ?> <?= $stretch?'layout-relative':'' ?>"
        data-control="codeeditor"
        data-font-size="<?= $fontSize ?>"
        data-word-wrap="<?= $wordWrap ?>"
        data-code-folding="<?= $codeFolding ?>"
        data-auto-close-tags="<?= $autoClosing ?>"
        data-tab-size="<?= $tabSize ?>"
        data-theme="<?= $theme ?>"
        data-show-invisibles="<?= $showInvisibles ?>"
        data-autocompletion="<?= $autocompletion ?>"
        data-enable-snippets="<?= $enableSnippets ?>"
        data-display-indent-guides="<?= $displayIndentGuides ?>"
        data-show-print-margin="<?= $showPrintMargin ?>"
        data-highlight-active-line="<?= $highlightActiveLine ?>"
        data-use-soft-tabs="<?= $useSoftTabs ?>"
        data-show-gutter="<?= $showGutter ? 'true' : 'false' ?>"
        data-read-only="<?= $readOnly ? 'true' : 'false' ?>"
        data-language="<?= $language ?>"
        data-margin="<?= $margin ?>"
        data-vendor-path="<?= Url::asset('/modules/backend/formwidgets/codeeditor/assets/vendor/ace') ?>"
        <?= $this->formField->getAttributes() ?>>
        <div class="editor-toolbar">
            <ul>
                <li class="searchbox-enable">
                    <a href="javascript:;">
                        <i class="icon-search"></i>
                        <abbr title="ctrl+f"><?= e(trans('cms::lang.editor.open_searchbox')) ?></abbr>
                    </a>
                </li>
                <li class="replacebox-enable">
                    <a href="javascript:;">
                        <i class="icon-random"></i>
                        <abbr title="ctrl+h"><?= e(trans('cms::lang.editor.open_replacebox')) ?></abbr>
                    </a>
                </li>
                <li class="fullscreen-enable">
                    <a href="javascript:;">
                        <i class="icon-desktop"></i>
                        <abbr title="ctrl+shift+f"><?= e(trans('cms::lang.editor.enter_fullscreen')) ?></abbr>
                    </a>
                </li>
                <li class="fullscreen-disable">
                    <a href="javascript:;">
                        <i class="icon-desktop"></i>
                        <abbr title="ctrl+shift+f or esc"><?= e(trans('cms::lang.editor.exit_fullscreen')) ?></abbr>
                    </a>
                </li>
            </ul>
        </div>
        <textarea name="<?= $name ?>" id="<?= $this->getId('textarea') ?>"><?= e($value) ?></textarea>
    </div>
<?php endif ?>
