<?php
namespace MajorMedia\Project;

use MajorMedia\ToolBox\Models\Country;
use RainLab\User\Models\User;
use RainLab\User\Controllers\Users as UsersController;
use System\Classes\PluginBase;
use MajorMedia\Project\Models\Project;
use Event;
/**
 * Plugin class
 */
class Plugin extends PluginBase
{

    public $require = ['MajorMedia.UserPlus', 'MajorMedia.Toolbox'];

    /**
     * register method, called when the plugin is first registered.
     */
    public function register()
    {
    }

    /**
     * boot method, called right before the request route.
     */
    public function boot()
    {
        $this->extendUserModel();
        $this->extendCountryModel();
        $this->extendProjectModel();

        $this->extendUserFormFieldsModel();

        // Add CORS headers to all responses
        $this->app['Illuminate\Contracts\Http\Kernel']->pushMiddleware(\App\Middleware\CorsMiddleware::class);
    }

    /**
     * registerComponents used by the frontend.
     */
    public function registerComponents()
    {
    }

    /**
     * registerSettings used by the backend.
     */
    public function registerSettings()
    {
    }


    public function extendUserModel()
    {
        User::extend(function ($model) {
            $model->hasOne['project'] = [Project::class];
        });
    }

    public function extendCountryModel()
    {
        Country::extend(function ($model) {
            $model->hasMany['projects'] = Project::class;
        });
    }

    public function extendProjectModel()
    {
        Project::extend(function ($model) {
            $model->belongsTo['country'] = Country::class;
        });
    }

    /**
     * extend list columns
     */

    /**
     * extend Form Fields
     */
    public function extendUserFormFieldsModel()
    {
        Event::listen('backend.form.extendFields', function ($widget) {
            // Only for the Users controller
            if (!$widget->getController() instanceof UsersController) {
                return;
            }

            // Only for the User model
            if (!$widget->model instanceof User) {
                return;
            }

            $widget->addTabFields([
                'project' => [
                    'label' => 'Project',
                    'tab' => 'Project',
                    'type' => 'partial',
                    'path' => '$/majormedia/userplus/config/_project.htm',
                ],
            ]);
        });
    }

}
