<?php
namespace Majormedia\Project\Updates;

use Schema;
use October\Rain\Database\Schema\Blueprint;
use October\Rain\Database\Updates\Migration;

/**
 * CreateProjectTable Migration
 *
 * @link https://docs.octobercms.com/3.x/extend/database/structure.html
 */
return new class extends Migration {
    /**
     * up builds the migration
     */
    public function up()
    {
        Schema::create('majormedia_project_quotes', function (Blueprint $table) {

            $table->bigIncrements('id');
            $table->unsignedBigInteger('project_id')->nullable()->index('fk_project_id');
            $table->unsignedBigInteger('environment_id')->nullable()->index('fk_environment_id');
            $table->unsignedBigInteger('front_design_id')->nullable()->index('fk_front_design_id');

            $table->string('reference')->nullable()->index('index_reference');
            $table->string('client_name')->nullable()->index('index_client_name');
            $table->decimal('recomanded_amount',9,6)->nullable()->index('index_recomanded_amount');
            $table->decimal('final_amount',9,6)->nullable()->index('index_final_amount');
            $table->timestamp('quote_date')->nullable()->index('index_quote_date');

            $table->foreign('project_id', 'fk_quotes_project_id')->references('id')->on('majormedia_project_projects')->onDelete('set null')->onUpdate('cascade');
            $table->foreign('environment_id', 'fk_quotes_environment_id')->references('id')->on('majormedia_project_environments')->onDelete('set null')->onUpdate('cascade');
            $table->foreign('front_design_id', 'fk_quotes_front_design_id')->references('id')->on('majormedia_project_front_designs')->onDelete('set null')->onUpdate('cascade');

            $table->boolean('is_active')->default(1)->index('index_is_active');
            $table->boolean('is_pinned')->default(0)->index('index_is_pinned');
            $table->integer('sort_order')->default(1)->index('index_sort_order');
            $table->timestamp('created_at')->nullable()->index('index_created_at');
            $table->timestamp('updated_at')->nullable()->index('index_updated_at');
        });
    }

    /**
     * down reverses the migration
     */
    public function down()
    {
        Schema::dropIfExists('majormedia_project_quotes');
    }
};
