<?php
namespace Majormedia\Project\Updates;

use Schema;
use October\Rain\Database\Schema\Blueprint;
use October\Rain\Database\Updates\Migration;

/**
 * CreateProjectSocialTable Migration
 *
 * @link https://docs.octobercms.com/3.x/extend/database/structure.html
 */
return new class extends Migration {
    /**
     * up builds the migration
     */
    public function up()
    {
        Schema::create('majormedia_project_type_designs', function (Blueprint $table) {

            $table->bigIncrements('id');

            $table->unsignedBigInteger('project_type_id')->nullable()->index('fk_project_type_id');
            $table->unsignedBigInteger('front_design_id')->nullable()->index('fk_front_design_id');
            $table->decimal('initial_price', 10, 2)->nullable()->index('index_initial_price');

            $table->foreign('project_type_id', 'fk_design_project_type_id')->references('id')->on('majormedia_project_project_types')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('front_design_id', 'fk_type_front_design_id')->references('id')->on('majormedia_project_front_designs')->onDelete('cascade')->onUpdate('cascade');

            $table->boolean('is_active')->default(1)->index('index_is_active');
            $table->boolean('is_pinned')->default(0)->index('index_is_pinned');
            $table->integer('sort_order')->default(1)->index('index_sort_order');
            $table->timestamp('created_at')->nullable()->index('index_created_at');
            $table->timestamp('updated_at')->nullable()->index('index_updated_at');
        });
    }

    /**
     * down reverses the migration
     */
    public function down()
    {
        Schema::dropIfExists('majormedia_project_type_designs');
    }
};
