<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="utf-8"/>
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <title>Devis Professionnel - Major Media</title>
    <script src="https://cdn.tailwindcss.com?plugins=forms,typography"></script>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700;800&family=Material+Icons&display=swap" rel="stylesheet"/>
    <script>
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        primary: "#30009C",
                        accent: "#00E5FF",
                    },
                    fontFamily: {
                        display: ["Montserrat", "sans-serif"],
                    },
                },
            },
        };
    </script>
    <style>
        @page {
            size: A4;
            margin: 0;
        }

        body {
            font-family: 'Montserrat', sans-serif;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
            margin: 0;
            padding: 0;
        }

        .page-container {
            width: 210mm;
            min-height: 297mm;
            margin: 0 auto;
            background: white;
            position: relative;
            box-sizing: border-box;
        }

        .gradient-header {
            background: linear-gradient(90deg, #00D2D3 0%, #30009C 100%);
        }

        .list-bullet::before {
            content: "•";
            color: currentColor;
            display: inline-block;
            width: 1em;
            margin-left: -1em;
        }

        /* Material Icons fix for PDF */
        .material-icons {
            font-family: 'Material Icons';
            font-weight: normal;
            font-style: normal;
            font-size: 24px;
            display: inline-block;
            line-height: 1;
            text-transform: none;
            letter-spacing: normal;
            word-wrap: normal;
            white-space: nowrap;
            direction: ltr;
            -webkit-font-smoothing: antialiased;
            text-rendering: optimizeLegibility;
        }

        @media print {
            .page-container {
                margin: 0;
                box-shadow: none;
            }
        }
    </style>
</head>
<body class="bg-gray-50">
    <div class="page-container">
        <!-- Header -->
        <header class="relative px-10 pt-8 pb-10 overflow-hidden">
            <div class="absolute top-0 left-0 w-full h-full gradient-header opacity-10"></div>
            <div class="relative z-10 flex justify-between items-start">
                <!-- Logo -->
                <div class="flex items-center space-x-3">
                    <div class="bg-primary p-2.5 rounded">
                        <span class="text-white font-black text-3xl leading-none">M</span>
                    </div>
                    <div>
                        <h1 class="text-2xl font-black text-primary leading-none">MAJOR</h1>
                        <p class="text-xl font-bold text-accent leading-none mt-0.5">MEDIA</p>
                    </div>
                </div>

                <!-- Right side -->
                <div class="text-right">
                    <p class="text-[9px] font-semibold text-primary tracking-tight mb-3 leading-tight">
                        Marketing Digital | Branding | DEV & IT | Événementiel | Relations Presse
                    </p>
                    <div class="flex justify-end items-center space-x-2.5 text-primary">
                        <span class="material-icons text-lg">whatsapp</span>
                        <span class="material-icons text-lg">public</span>
                        <span class="material-icons text-lg">camera_alt</span>
                        <span class="material-icons text-lg">facebook</span>
                        <span class="font-bold text-sm ml-1.5">MAJORMEDIA</span>
                    </div>
                </div>
            </div>
        </header>

        <!-- Content -->
        <div class="px-10">
            @yield('content')
        </div>

        <!-- Footer -->
        <footer class="mt-10">
            <div class="px-10 pb-6">
                <div class="grid grid-cols-3 gap-6 border-t border-gray-200 pt-6">
                    <!-- Location -->
                    <div class="flex items-start space-x-2.5">
                        <div class="bg-accent p-1.5 rounded-full flex-shrink-0">
                            <span class="material-icons text-primary text-base">location_on</span>
                        </div>
                        <div class="text-[9px] text-gray-700 font-medium leading-tight">
                            <div class="font-bold">Borj Dlalate, Immeuble F,</div>
                            <div>4 ème et 5 ème étage</div>
                            <div>Rue Chair al-Hamra Mohammed</div>
                            <div>ben Brahim, Agadir 80000</div>
                        </div>
                    </div>

                    <!-- Phone -->
                    <div class="flex items-start space-x-2.5">
                        <div class="bg-accent p-1.5 rounded-full flex-shrink-0">
                            <span class="material-icons text-primary text-base">phone</span>
                        </div>
                        <div class="text-[10px] text-gray-700 font-bold leading-tight pt-0.5">
                            +212 6 64 71 30 37
                        </div>
                    </div>

                    <!-- Email -->
                    <div class="flex items-start space-x-2.5">
                        <div class="bg-accent p-1.5 rounded-full flex-shrink-0">
                            <span class="material-icons text-primary text-base">email</span>
                        </div>
                        <div class="text-[9px] text-gray-700 font-medium leading-tight">
                            <div class="font-bold">contact@majormedia.ma</div>
                            <div>www.majormedia.ma</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Bottom bar -->
            <div class="bg-primary text-white py-3.5 px-10 text-center">
                <p class="text-[8px] font-medium leading-relaxed opacity-95">
                    Sté MAJOR MEDIA SARL au capital de 100 000 Dhs – Siège : co chez ste jm domiciliation appt 3 lot 510 haut founty<br/>
                    agadir M. Annexe: Immeuble Borj Dlalat, Bâtiment F, bureau numéro 4 & 5 èm Etage, 80 000 – Agadir - Maroc
                </p>
            </div>

            <!-- Accent bar -->
            <div class="h-2 w-full bg-accent"></div>
        </footer>
    </div>
</body>
</html>
