<?php
namespace Majormedia\Reference\Http;

use Backend\Classes\Controller;
use MajorMedia\Reference\Models\Category;
use MajorMedia\Reference\Models\Industry;
use MajorMedia\Reference\Models\PrestationType;
use MajorMedia\ToolBox\Traits\JsonAbort;
use MajorMedia\ToolBox\Traits\RetrieveUser;
use Majormedia\ToolBox\Traits\GetFileFromBase64;
use MajorMedia\ToolBox\Traits\GetValidatedInput;
use MajorMedia\ToolBox\Utility\ErrorCodes;
/**
 * Industries Back-end Controller
 */
class Industries extends Controller
{
    use RetrieveUser, GetValidatedInput, JsonAbort, GetFileFromBase64;
    public $implement = [
        'MajorMedia.ToolBox.Behaviors.RestController'
    ];

    public $restConfig = 'config_rest.yaml';

    public function extendModel($model)
    {
        return $model;
    }


}
