<?php
namespace MajorMedia\Reference\Models;

use Model;
use MajorMedia\Reference\Models\Reference;
use October\Rain\Database\Traits\Validation;
use MajorMedia\Reference\Models\PrestationType;

/**
 * Category Model
 */
class Category extends Model
{
    use Validation;

    public $table = 'majormedia_reference_categories';

    public $rules = [];

    protected $fillable = ['name'];
    protected $visible = ['id', 'name'];
    public $belongsTo = [
        'prestationType' => [PrestationType::class,'key'=>'prestation_id']
    ];

    public $hasMany = [
        'references' => [Reference::class]
    ];
}