<?php
namespace Majormedia\Reference\Updates;

use Schema;
use October\Rain\Database\Schema\Blueprint;
use October\Rain\Database\Updates\Migration;

/**
 * CreateCategoriesTable Migration
 */
return new class extends Migration {
    public function up()
    {
        Schema::create('majormedia_reference_categories', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name')->unique();
            $table->unsignedBigInteger('prestation_id')->nullable()->index('fk_prestation_id');
            $table->foreign('prestation_id', 'fk_references_prestation_id')->references('id')->on('majormedia_reference_prestation_types')->onDelete('CASCADE')->onUpdate('CASCADE');

            $table->boolean('is_active')->default(1)->index('index_is_active');
            $table->boolean('is_pinned')->default(0)->index('index_is_pinned');
            $table->integer('sort_order')->default(1)->index('index_sort_order');
            $table->timestamp('created_at')->nullable()->index('index_created_at');
            $table->timestamp('updated_at')->nullable()->index('index_updated_at');

        });
    }

    public function down()
    {
        Schema::dropIfExists('majormedia_reference_categories');
    }
};