<?php
namespace Majormedia\Reference\Updates;

use Schema;
use October\Rain\Database\Schema\Blueprint;
use October\Rain\Database\Updates\Migration;

/**
 * CreateReferencesTable Migration
 */
return new class extends Migration {
    public function up()
    {
        Schema::create('majormedia_reference_references', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('title')->index('index_title');
            $table->string('slug')->index('index_slug');
            $table->text('description')->nullable();
            $table->string('image')->nullable();
            $table->string('url')->nullable();
            $table->string('client_name')->nullable()->index('index_client_name');
            $table->unsignedBigInteger('industry_id')->nullable()->index('fk_industry_id');
            $table->unsignedBigInteger('prestation_id')->nullable()->index('fk_prestation_id');
            $table->unsignedBigInteger('category_id')->nullable()->index('fk_category_id');

            $table->foreign('industry_id', 'fk_references_industry_id')->references('id')->on('majormedia_reference_industries')->onDelete('CASCADE')->onUpdate('CASCADE');
            $table->foreign('prestation_id', 'fk_references_prestation_id_new')->references('id')->on('majormedia_reference_prestation_types')->onDelete('CASCADE')->onUpdate('CASCADE');
            $table->foreign('category_id', 'fk_references_category_id')->references('id')->on('majormedia_reference_categories')->onDelete('CASCADE')->onUpdate('CASCADE');

            // $table->enum('status', ['published', 'draft'])->default('published');
            $table->smallInteger('status')->default(1);

            $table->boolean('is_active')->default(1)->index('index_is_active');
            $table->boolean('is_pinned')->default(0)->index('index_is_pinned');
            $table->integer('sort_order')->default(1)->index('index_sort_order');
            $table->timestamp('created_at')->nullable()->index('index_created_at');
            $table->timestamp('updated_at')->nullable()->index('index_updated_at');
        });
    }

    public function down()
    {
        Schema::dropIfExists('majormedia_reference_references');
    }
};