<?php
namespace MajorMedia\Structure\Models;

use Model;
use Illuminate\Support\Facades\Session;
use October\Rain\Database\Traits\Validation;
use MajorMedia\ToolBox\Traits\RetrieveUser;
/**
 * Model
 */
class Field extends Model
{
    use Validation, RetrieveUser;


    /**
     * @var string table in the database used by the model.
     */
    public $table = 'majormedia_structure_fields';

    /**
     * @var array rules for validation.
     */
    public $rules = [
    ];

    protected $fillable = [
        'name',
        'type',
        'char_from',
        'char_to',
        'explanation',
        'order',
        'is_active',
        'sort_order',
    ];

    protected $visible = [
        'id',
        'name',
        'type',
        'char_from',
        'char_to',
        'order',
        'pivot',
    ];
    public $belongsToMany = [
        'sitemap_sections' => [
            Field::class,
            'table' => 'majormedia_structure_sitemaps',
            'otherKey' => 'section_id',
            'key' => 'field_id',
            'pivot' => ['content']
        ]
    ];
}
