<?php namespace MajorMedia\Structure\Models;

use Model;
use MajorMedia\Project\Models\ProjectType;

/**
 * Model
 */
class PageSection extends Model
{
    use \October\Rain\Database\Traits\Validation;


    /**
     * @var string table in the database used by the model.
     */
    public $table = 'majormedia_structure_page_sections';

    /**
     * @var array rules for validation.
     */
    public $rules = [
    ];

    protected $fillable = ['section_id', 'page_id', 'project_type_id', 'is_required', 'is_primary', 'order'];

    public $belongsTo = [
        'section' => [Section::class, 'key' => 'section_id'],
        'page' => [Page::class, 'key' => 'page_id'],
        'projectType' => [ProjectType::class, 'key' => 'project_type_id']
    ];

}
