<?php
namespace MajorMedia\Structure\Models;

use Model;
use System\Models\File;
use MajorMedia\Structure\Models\Page;
use MajorMedia\Structure\Models\Field;
use MajorMedia\Structure\Models\SiteMap;
use MajorMedia\Project\Models\ProjectType;

/**
 * Model
 */
class Section extends Model
{
    use \October\Rain\Database\Traits\Validation;


    /**
     * @var string table in the database used by the model.
     */
    public $table = 'majormedia_structure_sections';

    /**
     * @var array rules for validation.
     */
    public $rules = [
    ];

    protected $fillable = [
        'project_id',
        'name',
        'description',
        'explanation',
        'char_from',
        'char_to',
        'is_active',
        'sort_order',
    ];

    // Fields that should be visible in array/JSON responses
    protected $visible = [
        'id',
        'name',
        'description',
        'explanation',
        'char_from',
        'char_to',
        'is_repeater',
        'sitemap_page_id',
        'fields',
        'sitemap_fields',
        'pivot'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'char_from' => 'integer',
        'char_to' => 'integer',
    ];
    public $belongsToMany = [
        'fields' => [
            Field::class,
            'table' => 'majormedia_structure_section_fields',
            'key' => 'section_id',
            'otherKey' => 'field_id',
        ],
        'sitemap_fields' => [
            Field::class,
            'table' => 'majormedia_structure_sitemaps',
            'key' => 'section_id',
            'otherKey' => 'field_id',
            'pivot' => ['page_id', 'section_id', 'field_id', 'content']
        ],
        'sitemap_section_pages' => [
            Page::class,
            'table' => 'majormedia_structure_sitemaps',
            'key' => 'section_id',
            'otherKey' => 'page_id',
            'pivot' => ['project_id']
        ],
        'pages' => [
            Page::class,
            'table' => 'majormedia_structure_page_sections',
            'key' => 'section_id',
            'otherKey' => 'page_id',
            'pivot' => ['project_type_id', 'is_required', 'is_primary', 'order']
        ],
        'projectTypes' => [
            ProjectType::class,
            'table' => 'majormedia_structure_page_sections',
            'key' => 'section_id',
            'otherKey' => 'project_type_id',
            'pivot' => ['project_type_id']
        ]
    ];
    public $hasMany = [
        'siteMaps' => [SiteMap::class, 'key' => 'section_id'],
        'pageSections' => [PageSection::class, 'key' => 'section_id']
    ];
    public $attachOne = [
        'explanation_file' => [File::class]
    ];

}
