<?php
namespace MajorMedia\Structure\Updates;

use Schema;
use October\Rain\Database\Updates\Migration;

class CreateMajorMediaStructureSections extends Migration
{
    public function up()
    {
        Schema::create('majormedia_structure_sections', function ($table) {
            $table->engine = 'InnoDB';
            $table->bigIncrements('id');
            $table->unsignedBigInteger('project_id')->nullable()->index('fk_project_id');
            $table->string('name')->nullable()->unique('unique_name');
            $table->integer('char_from')->default(0)->index('index_char_from');
            $table->integer('char_to')->default(0)->index('index_char_to');
            $table->longText('description')->nullable();
            $table->boolean('explanation')->default(0)->index('index_explanation');
            $table->boolean('is_active')->default(1)->index('index_is_active');
            $table->integer('sort_order')->default(1)->index('index_sort_order');
            $table->timestamp('created_at')->nullable()->index('index_created_at');
            $table->timestamp('updated_at')->nullable()->index('index_updated_at');

            $table->foreign('project_id', 'fk_sections_project_id')->references('id')->on('majormedia_project_projects')->onDelete('set null')->onUpdate('cascade');
        });
    }

    public function down()
    {
        \DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        Schema::dropIfExists('majormedia_structure_sections');
        \DB::statement('SET FOREIGN_KEY_CHECKS = 1');
    }
}
