<?php namespace MajorMedia\ToolBox\Console;

use ApplicationException;
use Illuminate\Console\Command;
use MajorMedia\ToolBox\Models\City;
use MajorMedia\ToolBox\Models\Country;
use MajorMedia\ToolBox\Models\State;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputOption;

class ToolsCoreCommand extends Command
{
  /**
   * @var string The console command name.
   */
  protected $name = 'tools:seed';

  /**
   * @var string The console command description.
   */
  protected $description = "A quick way to manage tools & core of majormedia's plugins.";

  protected $countries = [
    array('code' => 'AU', 'name' => 'Australia', 'slug' => 'australia', 'is_active' => '1'),
    array('code' => 'CA', 'name' => 'Canada', 'slug' => 'canada', 'is_active' => '1'),
    array('code' => 'GB', 'name' => 'United Kingdom', 'slug' => 'united-kingdom', 'is_active' => '1'),
    array('code' => 'US', 'name' => 'United States', 'slug' => 'united-states', 'is_active' => '1'),
    array('code' => 'AF', 'name' => 'Afghanistan', 'slug' => 'afghanistan', 'is_active' => '1'),
    array('code' => 'AX', 'name' => 'Aland Islands ', 'slug' => 'aland-islands', 'is_active' => '1'),
    array('code' => 'AL', 'name' => 'Albania', 'slug' => 'albania', 'is_active' => '1'),
    array('code' => 'DZ', 'name' => 'Algérie', 'slug' => 'algeria', 'is_active' => '1'),
    array('code' => 'AS', 'name' => 'American Samoa', 'slug' => 'american-samoa', 'is_active' => '1'),
    array('code' => 'AD', 'name' => 'Andorra', 'slug' => 'andorra', 'is_active' => '1'),
    array('code' => 'AO', 'name' => 'Angola', 'slug' => 'angola', 'is_active' => '1'),
    array('code' => 'AI', 'name' => 'Anguilla', 'slug' => 'anguilla', 'is_active' => '1'),
    array('code' => 'AQ', 'name' => 'Antarctica', 'slug' => 'antarctica', 'is_active' => '1'),
    array('code' => 'AG', 'name' => 'Antigua and Barbuda', 'slug' => 'antigua-and-barbuda', 'is_active' => '1'),
    array('code' => 'AR', 'name' => 'Argentina', 'slug' => 'argentina', 'is_active' => '1'),
    array('code' => 'AM', 'name' => 'Armenia', 'slug' => 'armenia', 'is_active' => '1'),
    array('code' => 'AW', 'name' => 'Aruba', 'slug' => 'aruba', 'is_active' => '1'),
    array('code' => 'AT', 'name' => 'Austria', 'slug' => 'austria', 'is_active' => '1'),
    array('code' => 'AZ', 'name' => 'Azerbaijan', 'slug' => 'azerbaijan', 'is_active' => '1'),
    array('code' => 'BS', 'name' => 'Bahamas', 'slug' => 'bahamas', 'is_active' => '1'),
    array('code' => 'BH', 'name' => 'Bahrain', 'slug' => 'bahrain', 'is_active' => '1'),
    array('code' => 'BD', 'name' => 'Bangladesh', 'slug' => 'bangladesh', 'is_active' => '1'),
    array('code' => 'BB', 'name' => 'Barbados', 'slug' => 'barbados', 'is_active' => '1'),
    array('code' => 'BY', 'name' => 'Belarus', 'slug' => 'belarus', 'is_active' => '1'),
    array('code' => 'BE', 'name' => 'Belgique', 'slug' => 'belgium', 'is_active' => '1'),
    array('code' => 'BZ', 'name' => 'Belize', 'slug' => 'belize', 'is_active' => '1'),
    array('code' => 'BJ', 'name' => 'Benin', 'slug' => 'benin', 'is_active' => '1'),
    array('code' => 'BM', 'name' => 'Bermuda', 'slug' => 'bermuda', 'is_active' => '1'),
    array('code' => 'BT', 'name' => 'Bhutan', 'slug' => 'bhutan', 'is_active' => '1'),
    array('code' => 'BO', 'name' => 'Bolivia, Plurinational State of', 'slug' => 'bolivia-plurinational-state-of', 'is_active' => '1'),
    array('code' => 'BQ', 'name' => 'Bonaire, Sint Eustatius and Saba', 'slug' => 'bonaire-sint-eustatius-and-saba', 'is_active' => '1'),
    array('code' => 'BA', 'name' => 'Bosnia and Herzegovina', 'slug' => 'bosnia-and-herzegovina', 'is_active' => '1'),
    array('code' => 'BW', 'name' => 'Botswana', 'slug' => 'botswana', 'is_active' => '1'),
    array('code' => 'BV', 'name' => 'Bouvet Island', 'slug' => 'bouvet-island', 'is_active' => '1'),
    array('code' => 'BR', 'name' => 'Brazil', 'slug' => 'brazil', 'is_active' => '1'),
    array('code' => 'IO', 'name' => 'British Indian Ocean Territory', 'slug' => 'british-indian-ocean-territory', 'is_active' => '1'),
    array('code' => 'BN', 'name' => 'Brunei Darussalam', 'slug' => 'brunei-darussalam', 'is_active' => '1'),
    array('code' => 'BG', 'name' => 'Bulgaria', 'slug' => 'bulgaria', 'is_active' => '1'),
    array('code' => 'BF', 'name' => 'Burkina Faso', 'slug' => 'burkina-faso', 'is_active' => '1'),
    array('code' => 'BI', 'name' => 'Burundi', 'slug' => 'burundi', 'is_active' => '1'),
    array('code' => 'KH', 'name' => 'Cambodia', 'slug' => 'cambodia', 'is_active' => '1'),
    array('code' => 'CM', 'name' => 'Cameroon', 'slug' => 'cameroon', 'is_active' => '1'),
    array('code' => 'CV', 'name' => 'Cape Verde', 'slug' => 'cape-verde', 'is_active' => '1'),
    array('code' => 'KY', 'name' => 'Cayman Islands', 'slug' => 'cayman-islands', 'is_active' => '1'),
    array('code' => 'CF', 'name' => 'Central African Republic', 'slug' => 'central-african-republic', 'is_active' => '1'),
    array('code' => 'TD', 'name' => 'Chad', 'slug' => 'chad', 'is_active' => '1'),
    array('code' => 'CL', 'name' => 'Chile', 'slug' => 'chile', 'is_active' => '1'),
    array('code' => 'CN', 'name' => 'China', 'slug' => 'china', 'is_active' => '1'),
    array('code' => 'CX', 'name' => 'Christmas Island', 'slug' => 'christmas-island', 'is_active' => '1'),
    array('code' => 'CC', 'name' => 'Cocos (Keeling) Islands', 'slug' => 'cocos-keeling-islands', 'is_active' => '1'),
    array('code' => 'CO', 'name' => 'Colombia', 'slug' => 'colombia', 'is_active' => '1'),
    array('code' => 'KM', 'name' => 'Comoros', 'slug' => 'comoros', 'is_active' => '1'),
    array('code' => 'CG', 'name' => 'Congo', 'slug' => 'congo', 'is_active' => '1'),
    array('code' => 'CD', 'name' => 'Congo, the Democratic Republic of the', 'slug' => 'congo-the-democratic-republic-of-the', 'is_active' => '1'),
    array('code' => 'CK', 'name' => 'Cook Islands', 'slug' => 'cook-islands', 'is_active' => '1'),
    array('code' => 'CR', 'name' => 'Costa Rica', 'slug' => 'costa-rica', 'is_active' => '1'),
    array('code' => 'CI', 'name' => 'Cote d\'Ivoire', 'slug' => 'cote-divoire', 'is_active' => '1'),
    array('code' => 'HR', 'name' => 'Croatia', 'slug' => 'croatia', 'is_active' => '1'),
    array('code' => 'CU', 'name' => 'Cuba', 'slug' => 'cuba', 'is_active' => '1'),
    array('code' => 'CW', 'name' => 'Curaçao', 'slug' => 'curacao', 'is_active' => '1'),
    array('code' => 'CY', 'name' => 'Cyprus', 'slug' => 'cyprus', 'is_active' => '1'),
    array('code' => 'CZ', 'name' => 'Czech Republic', 'slug' => 'czech-republic', 'is_active' => '1'),
    array('code' => 'DK', 'name' => 'Denmark', 'slug' => 'denmark', 'is_active' => '1'),
    array('code' => 'DJ', 'name' => 'Djibouti', 'slug' => 'djibouti', 'is_active' => '1'),
    array('code' => 'DM', 'name' => 'Dominica', 'slug' => 'dominica', 'is_active' => '1'),
    array('code' => 'DO', 'name' => 'Dominican Republic', 'slug' => 'dominican-republic', 'is_active' => '1'),
    array('code' => 'EC', 'name' => 'Ecuador', 'slug' => 'ecuador', 'is_active' => '1'),
    array('code' => 'EG', 'name' => 'Egypt', 'slug' => 'egypt', 'is_active' => '1'),
    array('code' => 'SV', 'name' => 'El Salvador', 'slug' => 'el-salvador', 'is_active' => '1'),
    array('code' => 'GQ', 'name' => 'Equatorial Guinea', 'slug' => 'equatorial-guinea', 'is_active' => '1'),
    array('code' => 'ER', 'name' => 'Eritrea', 'slug' => 'eritrea', 'is_active' => '1'),
    array('code' => 'EE', 'name' => 'Estonia', 'slug' => 'estonia', 'is_active' => '1'),
    array('code' => 'ET', 'name' => 'Ethiopia', 'slug' => 'ethiopia', 'is_active' => '1'),
    array('code' => 'FK', 'name' => 'Falkland Islands (Malvinas)', 'slug' => 'falkland-islands-malvinas', 'is_active' => '1'),
    array('code' => 'FO', 'name' => 'Faroe Islands', 'slug' => 'faroe-islands', 'is_active' => '1'),
    array('code' => 'FI', 'name' => 'Finland', 'slug' => 'finland', 'is_active' => '1'),
    array('code' => 'FJ', 'name' => 'Fiji', 'slug' => 'fiji', 'is_active' => '1'),
    array('code' => 'FR', 'name' => 'France', 'slug' => 'france', 'is_active' => '1'),
    array('code' => 'GF', 'name' => 'French Guiana', 'slug' => 'french-guiana', 'is_active' => '1'),
    array('code' => 'PF', 'name' => 'French Polynesia', 'slug' => 'french-polynesia', 'is_active' => '1'),
    array('code' => 'TF', 'name' => 'French Southern Territories', 'slug' => 'french-southern-territories', 'is_active' => '1'),
    array('code' => 'GA', 'name' => 'Gabon', 'slug' => 'gabon', 'is_active' => '1'),
    array('code' => 'GM', 'name' => 'Gambia', 'slug' => 'gambia', 'is_active' => '1'),
    array('code' => 'GE', 'name' => 'Georgia', 'slug' => 'georgia', 'is_active' => '1'),
    array('code' => 'DE', 'name' => 'Germany', 'slug' => 'germany', 'is_active' => '1'),
    array('code' => 'GH', 'name' => 'Ghana', 'slug' => 'ghana', 'is_active' => '1'),
    array('code' => 'GI', 'name' => 'Gibraltar', 'slug' => 'gibraltar', 'is_active' => '1'),
    array('code' => 'GR', 'name' => 'Greece', 'slug' => 'greece', 'is_active' => '1'),
    array('code' => 'GL', 'name' => 'Greenland', 'slug' => 'greenland', 'is_active' => '1'),
    array('code' => 'GD', 'name' => 'Grenada', 'slug' => 'grenada', 'is_active' => '1'),
    array('code' => 'GP', 'name' => 'Guadeloupe', 'slug' => 'guadeloupe', 'is_active' => '1'),
    array('code' => 'GU', 'name' => 'Guam', 'slug' => 'guam', 'is_active' => '1'),
    array('code' => 'GT', 'name' => 'Guatemala', 'slug' => 'guatemala', 'is_active' => '1'),
    array('code' => 'GG', 'name' => 'Guernsey', 'slug' => 'guernsey', 'is_active' => '1'),
    array('code' => 'GN', 'name' => 'Guinea', 'slug' => 'guinea', 'is_active' => '1'),
    array('code' => 'GW', 'name' => 'Guinea-Bissau', 'slug' => 'guinea-bissau', 'is_active' => '1'),
    array('code' => 'GY', 'name' => 'Guyana', 'slug' => 'guyana', 'is_active' => '1'),
    array('code' => 'HT', 'name' => 'Haiti', 'slug' => 'haiti', 'is_active' => '1'),
    array('code' => 'HM', 'name' => 'Heard Island and McDonald Islands', 'slug' => 'heard-island-and-mcdonald-islands', 'is_active' => '1'),
    array('code' => 'VA', 'name' => 'Holy See (Vatican City State)', 'slug' => 'holy-see-vatican-city-state', 'is_active' => '1'),
    array('code' => 'HN', 'name' => 'Honduras', 'slug' => 'honduras', 'is_active' => '1'),
    array('code' => 'HK', 'name' => 'Hong Kong', 'slug' => 'hong-kong', 'is_active' => '1'),
    array('code' => 'HU', 'name' => 'Hungary', 'slug' => 'hungary', 'is_active' => '1'),
    array('code' => 'IS', 'name' => 'Iceland', 'slug' => 'iceland', 'is_active' => '1'),
    array('code' => 'IN', 'name' => 'India', 'slug' => 'india', 'is_active' => '1'),
    array('code' => 'ID', 'name' => 'Indonesia', 'slug' => 'indonesia', 'is_active' => '1'),
    array('code' => 'IR', 'name' => 'Iran, Islamic Republic of', 'slug' => 'iran-islamic-republic-of', 'is_active' => '1'),
    array('code' => 'IQ', 'name' => 'Iraq', 'slug' => 'iraq', 'is_active' => '1'),
    array('code' => 'IE', 'name' => 'Ireland', 'slug' => 'ireland', 'is_active' => '1'),
    array('code' => 'IM', 'name' => 'Isle of Man', 'slug' => 'isle-of-man', 'is_active' => '1'),
    array('code' => 'IL', 'name' => 'Israel', 'slug' => 'israel', 'is_active' => '1'),
    array('code' => 'IT', 'name' => 'Italy', 'slug' => 'italy', 'is_active' => '1'),
    array('code' => 'JM', 'name' => 'Jamaica', 'slug' => 'jamaica', 'is_active' => '1'),
    array('code' => 'JP', 'name' => 'Japan', 'slug' => 'japan', 'is_active' => '1'),
    array('code' => 'JE', 'name' => 'Jersey', 'slug' => 'jersey', 'is_active' => '1'),
    array('code' => 'JO', 'name' => 'Jordan', 'slug' => 'jordan', 'is_active' => '1'),
    array('code' => 'KZ', 'name' => 'Kazakhstan', 'slug' => 'kazakhstan', 'is_active' => '1'),
    array('code' => 'KE', 'name' => 'Kenya', 'slug' => 'kenya', 'is_active' => '1'),
    array('code' => 'KI', 'name' => 'Kiribati', 'slug' => 'kiribati', 'is_active' => '1'),
    array('code' => 'KP', 'name' => 'Korea, Democratic People\'s Republic of', 'slug' => 'korea-democratic-peoples-republic-of', 'is_active' => '1'),
    array('code' => 'KR', 'name' => 'Korea, Republic of', 'slug' => 'korea-republic-of', 'is_active' => '1'),
    array('code' => 'KW', 'name' => 'Kuwait', 'slug' => 'kuwait', 'is_active' => '1'),
    array('code' => 'KG', 'name' => 'Kyrgyzstan', 'slug' => 'kyrgyzstan', 'is_active' => '1'),
    array('code' => 'LA', 'name' => 'Lao People\'s Democratic Republic', 'slug' => 'lao-peoples-democratic-republic', 'is_active' => '1'),
    array('code' => 'LV', 'name' => 'Latvia', 'slug' => 'latvia', 'is_active' => '1'),
    array('code' => 'LB', 'name' => 'Lebanon', 'slug' => 'lebanon', 'is_active' => '1'),
    array('code' => 'LS', 'name' => 'Lesotho', 'slug' => 'lesotho', 'is_active' => '1'),
    array('code' => 'LR', 'name' => 'Liberia', 'slug' => 'liberia', 'is_active' => '1'),
    array('code' => 'LY', 'name' => 'Libyan Arab Jamahiriya', 'slug' => 'libyan-arab-jamahiriya', 'is_active' => '1'),
    array('code' => 'LI', 'name' => 'Liechtenstein', 'slug' => 'liechtenstein', 'is_active' => '1'),
    array('code' => 'LT', 'name' => 'Lithuania', 'slug' => 'lithuania', 'is_active' => '1'),
    array('code' => 'LU', 'name' => 'Luxembourg', 'slug' => 'luxembourg', 'is_active' => '1'),
    array('code' => 'MO', 'name' => 'Macao', 'slug' => 'macao', 'is_active' => '1'),
    array('code' => 'MK', 'name' => 'Macedonia', 'slug' => 'macedonia', 'is_active' => '1'),
    array('code' => 'MG', 'name' => 'Madagascar', 'slug' => 'madagascar', 'is_active' => '1'),
    array('code' => 'MW', 'name' => 'Malawi', 'slug' => 'malawi', 'is_active' => '1'),
    array('code' => 'MY', 'name' => 'Malaysia', 'slug' => 'malaysia', 'is_active' => '1'),
    array('code' => 'MV', 'name' => 'Maldives', 'slug' => 'maldives', 'is_active' => '1'),
    array('code' => 'ML', 'name' => 'Mali', 'slug' => 'mali', 'is_active' => '1'),
    array('code' => 'MT', 'name' => 'Malta', 'slug' => 'malta', 'is_active' => '1'),
    array('code' => 'MH', 'name' => 'Marshall Islands', 'slug' => 'marshall-islands', 'is_active' => '1'),
    array('code' => 'MQ', 'name' => 'Martinique', 'slug' => 'martinique', 'is_active' => '1'),
    array('code' => 'MR', 'name' => 'Mauritania', 'slug' => 'mauritania', 'is_active' => '1'),
    array('code' => 'MU', 'name' => 'Mauritius', 'slug' => 'mauritius', 'is_active' => '1'),
    array('code' => 'YT', 'name' => 'Mayotte', 'slug' => 'mayotte', 'is_active' => '1'),
    array('code' => 'MX', 'name' => 'Mexico', 'slug' => 'mexico', 'is_active' => '1'),
    array('code' => 'FM', 'name' => 'Micronesia, Federated States of', 'slug' => 'micronesia-federated-states-of', 'is_active' => '1'),
    array('code' => 'MD', 'name' => 'Moldova, Republic of', 'slug' => 'moldova-republic-of', 'is_active' => '1'),
    array('code' => 'MC', 'name' => 'Monaco', 'slug' => 'monaco', 'is_active' => '1'),
    array('code' => 'MN', 'name' => 'Mongolia', 'slug' => 'mongolia', 'is_active' => '1'),
    array('code' => 'ME', 'name' => 'Montenegro', 'slug' => 'montenegro', 'is_active' => '1'),
    array('code' => 'MS', 'name' => 'Montserrat', 'slug' => 'montserrat', 'is_active' => '1'),
    array('code' => 'MA', 'name' => 'Maroc', 'slug' => 'morocco', 'is_active' => '1'),
    array('code' => 'MZ', 'name' => 'Mozambique', 'slug' => 'mozambique', 'is_active' => '1'),
    array('code' => 'MM', 'name' => 'Myanmar', 'slug' => 'myanmar', 'is_active' => '1'),
    array('code' => 'NA', 'name' => 'Namibia', 'slug' => 'namibia', 'is_active' => '1'),
    array('code' => 'NR', 'name' => 'Nauru', 'slug' => 'nauru', 'is_active' => '1'),
    array('code' => 'NP', 'name' => 'Nepal', 'slug' => 'nepal', 'is_active' => '1'),
    array('code' => 'NL', 'name' => 'Netherlands', 'slug' => 'netherlands', 'is_active' => '1'),
    array('code' => 'NC', 'name' => 'New Caledonia', 'slug' => 'new-caledonia', 'is_active' => '1'),
    array('code' => 'NZ', 'name' => 'New Zealand', 'slug' => 'new-zealand', 'is_active' => '1'),
    array('code' => 'NI', 'name' => 'Nicaragua', 'slug' => 'nicaragua', 'is_active' => '1'),
    array('code' => 'NE', 'name' => 'Niger', 'slug' => 'niger', 'is_active' => '1'),
    array('code' => 'NG', 'name' => 'Nigeria', 'slug' => 'nigeria', 'is_active' => '1'),
    array('code' => 'NU', 'name' => 'Niue', 'slug' => 'niue', 'is_active' => '1'),
    array('code' => 'NF', 'name' => 'Norfolk Island', 'slug' => 'norfolk-island', 'is_active' => '1'),
    array('code' => 'MP', 'name' => 'Northern Mariana Islands', 'slug' => 'northern-mariana-islands', 'is_active' => '1'),
    array('code' => 'NO', 'name' => 'Norway', 'slug' => 'norway', 'is_active' => '1'),
    array('code' => 'OM', 'name' => 'Oman', 'slug' => 'oman', 'is_active' => '1'),
    array('code' => 'PK', 'name' => 'Pakistan', 'slug' => 'pakistan', 'is_active' => '1'),
    array('code' => 'PW', 'name' => 'Palau', 'slug' => 'palau', 'is_active' => '1'),
    array('code' => 'PS', 'name' => 'Palestine', 'slug' => 'palestine', 'is_active' => '1'),
    array('code' => 'PA', 'name' => 'Panama', 'slug' => 'panama', 'is_active' => '1'),
    array('code' => 'PG', 'name' => 'Papua New Guinea', 'slug' => 'papua-new-guinea', 'is_active' => '1'),
    array('code' => 'PY', 'name' => 'Paraguay', 'slug' => 'paraguay', 'is_active' => '1'),
    array('code' => 'PE', 'name' => 'Peru', 'slug' => 'peru', 'is_active' => '1'),
    array('code' => 'PH', 'name' => 'Philippines', 'slug' => 'philippines', 'is_active' => '1'),
    array('code' => 'PN', 'name' => 'Pitcairn', 'slug' => 'pitcairn', 'is_active' => '1'),
    array('code' => 'PL', 'name' => 'Poland', 'slug' => 'poland', 'is_active' => '1'),
    array('code' => 'PT', 'name' => 'Portugal', 'slug' => 'portugal', 'is_active' => '1'),
    array('code' => 'PR', 'name' => 'Puerto Rico', 'slug' => 'puerto-rico', 'is_active' => '1'),
    array('code' => 'QA', 'name' => 'Qatar', 'slug' => 'qatar', 'is_active' => '1'),
    array('code' => 'RE', 'name' => 'Reunion', 'slug' => 'reunion', 'is_active' => '1'),
    array('code' => 'RO', 'name' => 'Romania', 'slug' => 'romania', 'is_active' => '1'),
    array('code' => 'RU', 'name' => 'Russian Federation', 'slug' => 'russian-federation', 'is_active' => '1'),
    array('code' => 'RW', 'name' => 'Rwanda', 'slug' => 'rwanda', 'is_active' => '1'),
    array('code' => 'BL', 'name' => 'Saint Barthélemy', 'slug' => 'saint-barthelemy', 'is_active' => '1'),
    array('code' => 'SH', 'name' => 'Saint Helena', 'slug' => 'saint-helena', 'is_active' => '1'),
    array('code' => 'KN', 'name' => 'Saint Kitts and Nevis', 'slug' => 'saint-kitts-and-nevis', 'is_active' => '1'),
    array('code' => 'LC', 'name' => 'Saint Lucia', 'slug' => 'saint-lucia', 'is_active' => '1'),
    array('code' => 'MF', 'name' => 'Saint Martin (French part)', 'slug' => 'saint-martin-french-part', 'is_active' => '1'),
    array('code' => 'PM', 'name' => 'Saint Pierre and Miquelon', 'slug' => 'saint-pierre-and-miquelon', 'is_active' => '1'),
    array('code' => 'VC', 'name' => 'Saint Vincent and the Grenadines', 'slug' => 'saint-vincent-and-the-grenadines', 'is_active' => '1'),
    array('code' => 'WS', 'name' => 'Samoa', 'slug' => 'samoa', 'is_active' => '1'),
    array('code' => 'SM', 'name' => 'San Marino', 'slug' => 'san-marino', 'is_active' => '1'),
    array('code' => 'ST', 'name' => 'Sao Tome and Principe', 'slug' => 'sao-tome-and-principe', 'is_active' => '1'),
    array('code' => 'SA', 'name' => 'Saudi Arabia', 'slug' => 'saudi-arabia', 'is_active' => '1'),
    array('code' => 'SN', 'name' => 'Senegal', 'slug' => 'senegal', 'is_active' => '1'),
    array('code' => 'RS', 'name' => 'Serbia', 'slug' => 'serbia', 'is_active' => '1'),
    array('code' => 'SC', 'name' => 'Seychelles', 'slug' => 'seychelles', 'is_active' => '1'),
    array('code' => 'SL', 'name' => 'Sierra Leone', 'slug' => 'sierra-leone', 'is_active' => '1'),
    array('code' => 'SG', 'name' => 'Singapore', 'slug' => 'singapore', 'is_active' => '1'),
    array('code' => 'SX', 'name' => 'Sint Maarten (Dutch part)', 'slug' => 'sint-maarten-dutch-part', 'is_active' => '1'),
    array('code' => 'SK', 'name' => 'Slovakia', 'slug' => 'slovakia', 'is_active' => '1'),
    array('code' => 'SI', 'name' => 'Slovenia', 'slug' => 'slovenia', 'is_active' => '1'),
    array('code' => 'SB', 'name' => 'Solomon Islands', 'slug' => 'solomon-islands', 'is_active' => '1'),
    array('code' => 'SO', 'name' => 'Somalia', 'slug' => 'somalia', 'is_active' => '1'),
    array('code' => 'ZA', 'name' => 'South Africa', 'slug' => 'south-africa', 'is_active' => '1'),
    array('code' => 'GS', 'name' => 'South Georgia and the South Sandwich Islands', 'slug' => 'south-georgia-and-the-south-sandwich-islands', 'is_active' => '1'),
    array('code' => 'ES', 'name' => 'Spain', 'slug' => 'spain', 'is_active' => '1'),
    array('code' => 'LK', 'name' => 'Sri Lanka', 'slug' => 'sri-lanka', 'is_active' => '1'),
    array('code' => 'SD', 'name' => 'Sudan', 'slug' => 'sudan', 'is_active' => '1'),
    array('code' => 'SR', 'name' => 'Suriname', 'slug' => 'suriname', 'is_active' => '1'),
    array('code' => 'SJ', 'name' => 'Svalbard and Jan Mayen', 'slug' => 'svalbard-and-jan-mayen', 'is_active' => '1'),
    array('code' => 'SZ', 'name' => 'Swaziland', 'slug' => 'swaziland', 'is_active' => '1'),
    array('code' => 'SE', 'name' => 'Sweden', 'slug' => 'sweden', 'is_active' => '1'),
    array('code' => 'CH', 'name' => 'Switzerland', 'slug' => 'switzerland', 'is_active' => '1'),
    array('code' => 'SY', 'name' => 'Syrian Arab Republic', 'slug' => 'syrian-arab-republic', 'is_active' => '1'),
    array('code' => 'TW', 'name' => 'Taiwan, Province of China', 'slug' => 'taiwan-province-of-china', 'is_active' => '1'),
    array('code' => 'TJ', 'name' => 'Tajikistan', 'slug' => 'tajikistan', 'is_active' => '1'),
    array('code' => 'TZ', 'name' => 'Tanzania, United Republic of', 'slug' => 'tanzania-united-republic-of', 'is_active' => '1'),
    array('code' => 'TH', 'name' => 'Thailand', 'slug' => 'thailand', 'is_active' => '1'),
    array('code' => 'TL', 'name' => 'Timor-Leste', 'slug' => 'timor-leste', 'is_active' => '1'),
    array('code' => 'TG', 'name' => 'Togo', 'slug' => 'togo', 'is_active' => '1'),
    array('code' => 'TK', 'name' => 'Tokelau', 'slug' => 'tokelau', 'is_active' => '1'),
    array('code' => 'TO', 'name' => 'Tonga', 'slug' => 'tonga', 'is_active' => '1'),
    array('code' => 'TT', 'name' => 'Trinidad and Tobago', 'slug' => 'trinidad-and-tobago', 'is_active' => '1'),
    array('code' => 'TN', 'name' => 'Tunisia', 'slug' => 'tunisia', 'is_active' => '1'),
    array('code' => 'TR', 'name' => 'Turkey', 'slug' => 'turkey', 'is_active' => '1'),
    array('code' => 'TM', 'name' => 'Turkmenistan', 'slug' => 'turkmenistan', 'is_active' => '1'),
    array('code' => 'TC', 'name' => 'Turks and Caicos Islands', 'slug' => 'turks-and-caicos-islands', 'is_active' => '1'),
    array('code' => 'TV', 'name' => 'Tuvalu', 'slug' => 'tuvalu', 'is_active' => '1'),
    array('code' => 'UG', 'name' => 'Uganda', 'slug' => 'uganda', 'is_active' => '1'),
    array('code' => 'UA', 'name' => 'Ukraine', 'slug' => 'ukraine', 'is_active' => '1'),
    array('code' => 'AE', 'name' => 'United Arab Emirates', 'slug' => 'united-arab-emirates', 'is_active' => '1'),
    array('code' => 'UM', 'name' => 'United States Minor Outlying Islands', 'slug' => 'united-states-minor-outlying-islands', 'is_active' => '1'),
    array('code' => 'UY', 'name' => 'Uruguay', 'slug' => 'uruguay', 'is_active' => '1'),
    array('code' => 'UZ', 'name' => 'Uzbekistan', 'slug' => 'uzbekistan', 'is_active' => '1'),
    array('code' => 'VU', 'name' => 'Vanuatu', 'slug' => 'vanuatu', 'is_active' => '1'),
    array('code' => 'VE', 'name' => 'Venezuela, Bolivarian Republic of', 'slug' => 'venezuela-bolivarian-republic-of', 'is_active' => '1'),
    array('code' => 'VN', 'name' => 'Viet Nam', 'slug' => 'viet-nam', 'is_active' => '1'),
    array('code' => 'VG', 'name' => 'Virgin Islands, British', 'slug' => 'virgin-islands-british', 'is_active' => '1'),
    array('code' => 'VI', 'name' => 'Virgin Islands, U.S.', 'slug' => 'virgin-islands-us', 'is_active' => '1'),
    array('code' => 'WF', 'name' => 'Wallis and Futuna', 'slug' => 'wallis-and-futuna', 'is_active' => '1'),
    array('code' => 'YE', 'name' => 'Yemen', 'slug' => 'yemen', 'is_active' => '1'),
    array('code' => 'ZM', 'name' => 'Zambia', 'slug' => 'zambia', 'is_active' => '1'),
    array('code' => 'ZW', 'name' => 'Zimbabwe', 'slug' => 'zimbabwe', 'is_active' => '1')
  ];
  protected $states = [
    'US' => [
      ['code' => 'AL', 'name' => 'Alabama'],
      ['code' => 'AK', 'name' => 'Alaska'],
      ['code' => 'AS', 'name' => 'American Samoa'],
      ['code' => 'AZ', 'name' => 'Arizona'],
      ['code' => 'AR', 'name' => 'Arkansas'],
      ['code' => 'CA', 'name' => 'California'],
      ['code' => 'CO', 'name' => 'Colorado'],
      ['code' => 'CT', 'name' => 'Connecticut'],
      ['code' => 'DE', 'name' => 'Delaware'],
      ['code' => 'DC', 'name' => 'Dist. of Columbia'],
      ['code' => 'FL', 'name' => 'Florida'],
      ['code' => 'GA', 'name' => 'Georgia'],
      ['code' => 'GU', 'name' => 'Guam'],
      ['code' => 'HI', 'name' => 'Hawaii'],
      ['code' => 'ID', 'name' => 'Idaho'],
      ['code' => 'IL', 'name' => 'Illinois'],
      ['code' => 'IN', 'name' => 'Indiana'],
      ['code' => 'IA', 'name' => 'Iowa'],
      ['code' => 'KS', 'name' => 'Kansas'],
      ['code' => 'KY', 'name' => 'Kentucky'],
      ['code' => 'LA', 'name' => 'Louisiana'],
      ['code' => 'ME', 'name' => 'Maine'],
      ['code' => 'MD', 'name' => 'Maryland'],
      ['code' => 'MH', 'name' => 'Marshall Islands'],
      ['code' => 'MA', 'name' => 'Massachusetts'],
      ['code' => 'MI', 'name' => 'Michigan'],
      ['code' => 'FM', 'name' => 'Micronesia'],
      ['code' => 'MN', 'name' => 'Minnesota'],
      ['code' => 'MS', 'name' => 'Mississippi'],
      ['code' => 'MO', 'name' => 'Missouri'],
      ['code' => 'MT', 'name' => 'Montana'],
      ['code' => 'NE', 'name' => 'Nebraska'],
      ['code' => 'NV', 'name' => 'Nevada'],
      ['code' => 'NH', 'name' => 'New Hampshire'],
      ['code' => 'NJ', 'name' => 'New Jersey'],
      ['code' => 'NM', 'name' => 'New Mexico'],
      ['code' => 'NY', 'name' => 'New York'],
      ['code' => 'NC', 'name' => 'North Carolina'],
      ['code' => 'ND', 'name' => 'North Dakota'],
      ['code' => 'MP', 'name' => 'Northern Marianas'],
      ['code' => 'OH', 'name' => 'Ohio'],
      ['code' => 'OK', 'name' => 'Oklahoma'],
      ['code' => 'OR', 'name' => 'Oregon'],
      ['code' => 'PW', 'name' => 'Palau'],
      ['code' => 'PA', 'name' => 'Pennsylvania'],
      ['code' => 'PR', 'name' => 'Puerto Rico'],
      ['code' => 'RI', 'name' => 'Rhode Island'],
      ['code' => 'SC', 'name' => 'South Carolina'],
      ['code' => 'SD', 'name' => 'South Dakota'],
      ['code' => 'TN', 'name' => 'Tennessee'],
      ['code' => 'TX', 'name' => 'Texas'],
      ['code' => 'UT', 'name' => 'Utah'],
      ['code' => 'VT', 'name' => 'Vermont'],
      ['code' => 'VA', 'name' => 'Virginia'],
      ['code' => 'VI', 'name' => 'Virgin Islands'],
      ['code' => 'WA', 'name' => 'Washington'],
      ['code' => 'WV', 'name' => 'West Virginia'],
      ['code' => 'WI', 'name' => 'Wisconsin'],
      ['code' => 'WY', 'name' => 'Wyoming']
    ],
    'BR' => [
      ['code' => 'AC', 'name' => 'Acre'],
      ['code' => 'AL', 'name' => 'Alagoas'],
      ['code' => 'AP', 'name' => 'Amapá'],
      ['code' => 'AM', 'name' => 'Amazonas'],
      ['code' => 'BA', 'name' => 'Bahia'],
      ['code' => 'CE', 'name' => 'Ceará'],
      ['code' => 'DF', 'name' => 'Distrito Federal'],
      ['code' => 'ES', 'name' => 'Espírito Santo'],
      ['code' => 'GO', 'name' => 'Goiás'],
      ['code' => 'MA', 'name' => 'Maranhão'],
      ['code' => 'MT', 'name' => 'Mato Grosso'],
      ['code' => 'MS', 'name' => 'Mato Grosso do Sul'],
      ['code' => 'MG', 'name' => 'Minas Gerais'],
      ['code' => 'PA', 'name' => 'Pará'],
      ['code' => 'PB', 'name' => 'Paraíba'],
      ['code' => 'PR', 'name' => 'Paraná'],
      ['code' => 'PE', 'name' => 'Pernambuco'],
      ['code' => 'PI', 'name' => 'Piauí'],
      ['code' => 'RJ', 'name' => 'Rio de Janeiro'],
      ['code' => 'RN', 'name' => 'Rio Grande do Norte'],
      ['code' => 'RS', 'name' => 'Rio Grande do Sul'],
      ['code' => 'RO', 'name' => 'Rondônia'],
      ['code' => 'RR', 'name' => 'Roraima'],
      ['code' => 'SC', 'name' => 'Santa Catarina'],
      ['code' => 'SP', 'name' => 'São Paulo'],
      ['code' => 'SE', 'name' => 'Sergipe'],
      ['code' => 'TO', 'name' => 'Tocantins']
    ],
    'CA' => [
      ['code' => 'AB', 'name' => 'Alberta'],
      ['code' => 'BC', 'name' => 'British Columbia'],
      ['code' => 'MB', 'name' => 'Manitoba'],
      ['code' => 'NB', 'name' => 'New Brunswick'],
      ['code' => 'NL', 'name' => 'Newfoundland and Labrador'],
      ['code' => 'NT', 'name' => 'Northwest Territories'],
      ['code' => 'NS', 'name' => 'Nova Scotia'],
      ['code' => 'NU', 'name' => 'Nunavut'],
      ['code' => 'ON', 'name' => 'Ontario'],
      ['code' => 'PE', 'name' => 'Prince Edward Island'],
      ['code' => 'QC', 'name' => 'Quebec'],
      ['code' => 'SK', 'name' => 'Saskatchewan'],
      ['code' => 'YT', 'name' => 'Yukon']
    ],
    'CH' => [
      ['code' => 'AG', 'name' => 'Aargau'],
      ['code' => 'AI', 'name' => 'Appenzell Innerrhoden'],
      ['code' => 'AR', 'name' => 'Appenzell Ausserrhoden'],
      ['code' => 'BE', 'name' => 'Bern'],
      ['code' => 'BL', 'name' => 'Basel-Landschaft'],
      ['code' => 'BS', 'name' => 'Basel-Stadt'],
      ['code' => 'FR', 'name' => 'Fribourg'],
      ['code' => 'GE', 'name' => 'Genève'],
      ['code' => 'GL', 'name' => 'Glarus'],
      ['code' => 'GR', 'name' => 'Graubünden'],
      ['code' => 'JU', 'name' => 'Jura'],
      ['code' => 'LU', 'name' => 'Luzern'],
      ['code' => 'NE', 'name' => 'Neuchâtel'],
      ['code' => 'NW', 'name' => 'Nidwalden'],
      ['code' => 'OW', 'name' => 'Obwalden'],
      ['code' => 'SG', 'name' => 'St. Gallen'],
      ['code' => 'SO', 'name' => 'Solothurn'],
      ['code' => 'SZ', 'name' => 'Schwyz'],
      ['code' => 'TG', 'name' => 'Thurgau'],
      ['code' => 'TI', 'name' => 'Ticino'],
      ['code' => 'UR', 'name' => 'Uri'],
      ['code' => 'VD', 'name' => 'Vaud'],
      ['code' => 'VS', 'name' => 'Valais'],
      ['code' => 'ZG', 'name' => 'Zug'],
      ['code' => 'ZH', 'name' => 'Zürich']
    ],
    'AU' => [
      ['code' => 'NSW', 'name' => 'New South Wales'],
      ['code' => 'QLD', 'name' => 'Queensland'],
      ['code' => 'SA', 'name' => 'South Australia'],
      ['code' => 'TAS', 'name' => 'Tasmania'],
      ['code' => 'VIC', 'name' => 'Victoria'],
      ['code' => 'WA', 'name' => 'Western Australia'],
      ['code' => 'NT', 'name' => 'Northern Territory'],
      ['code' => 'ACT', 'name' => 'Australian Capital Territory']
    ],
    'DE' => [
      ['code' => 'BW', 'name' => 'Baden-Württemberg'],
      ['code' => 'BY', 'name' => 'Bavaria'],
      ['code' => 'BE', 'name' => 'Berlin'],
      ['code' => 'BB', 'name' => 'Brandenburg'],
      ['code' => 'HB', 'name' => 'Bremen'],
      ['code' => 'HH', 'name' => 'Hamburg'],
      ['code' => 'HE', 'name' => 'Hesse'],
      ['code' => 'MV', 'name' => 'Mecklenburg-Vorpommern'],
      ['code' => 'NI', 'name' => 'Lower Saxony'],
      ['code' => 'NW', 'name' => 'North Rhine-Westphalia'],
      ['code' => 'RP', 'name' => 'Rhineland-Palatinate'],
      ['code' => 'SL', 'name' => 'Saarland'],
      ['code' => 'SN', 'name' => 'Saxony'],
      ['code' => 'ST', 'name' => 'Saxony-Anhalt'],
      ['code' => 'SH', 'name' => 'Schleswig-Holstein'],
      ['code' => 'TH', 'name' => 'Thuringia']
    ],
    'EE' => [
      ['code' => 'HA', 'name' => 'Harju'],
      ['code' => 'HI', 'name' => 'Hiiu'],
      ['code' => 'IV', 'name' => 'Ida-Viru'],
      ['code' => 'JR', 'name' => 'Jõgeva'],
      ['code' => 'JN', 'name' => 'Järva'],
      ['code' => 'LN', 'name' => 'Lääne'],
      ['code' => 'LV', 'name' => 'Lääne-Viru'],
      ['code' => 'PL', 'name' => 'Põlva'],
      ['code' => 'PR', 'name' => 'Pärnu'],
      ['code' => 'RA', 'name' => 'Rapla'],
      ['code' => 'SA', 'name' => 'Saare'],
      ['code' => 'TA', 'name' => 'Tartu'],
      ['code' => 'VG', 'name' => 'Valga'],
      ['code' => 'VD', 'name' => 'Viljandi'],
      ['code' => 'VR', 'name' => 'Võru']
    ],
    'IE' => [
      ['code' => 'D', 'name' => 'Dublin'],
      ['code' => 'WW', 'name' => 'Wicklow'],
      ['code' => 'WX', 'name' => 'Wexford'],
      ['code' => 'CW', 'name' => 'Carlow'],
      ['code' => 'KE', 'name' => 'Kildare'],
      ['code' => 'MH', 'name' => 'Meath'],
      ['code' => 'LH', 'name' => 'Louth'],
      ['code' => 'MN', 'name' => 'Monaghan'],
      ['code' => 'CN', 'name' => 'Cavan'],
      ['code' => 'LD', 'name' => 'Longford'],
      ['code' => 'WH', 'name' => 'Westmeath'],
      ['code' => 'OY', 'name' => 'Offaly'],
      ['code' => 'LS', 'name' => 'Laois'],
      ['code' => 'KK', 'name' => 'Kilkenny'],
      ['code' => 'WD', 'name' => 'Waterford'],
      ['code' => 'C', 'name' => 'Cork'],
      ['code' => 'KY', 'name' => 'Kerry'],
      ['code' => 'LK', 'name' => 'Limerick'],
      ['code' => 'TN', 'name' => 'North Tipperary'],
      ['code' => 'TS', 'name' => 'South Tipperary'],
      ['code' => 'CE', 'name' => 'Clare'],
      ['code' => 'G', 'name' => 'Galway'],
      ['code' => 'MO', 'name' => 'Mayo'],
      ['code' => 'RN', 'name' => 'Roscommon'],
      ['code' => 'SO', 'name' => 'Sligo'],
      ['code' => 'LM', 'name' => 'Leitrim'],
      ['code' => 'DL', 'name' => 'Donegal']
    ],
    'NL' => [
      ['code' => 'DR', 'name' => 'Drenthe'],
      ['code' => 'FL', 'name' => 'Flevoland'],
      ['code' => 'FR', 'name' => 'Friesland'],
      ['code' => 'GE', 'name' => 'Gelderland'],
      ['code' => 'GR', 'name' => 'Groningen'],
      ['code' => 'LI', 'name' => 'Limburg'],
      ['code' => 'NB', 'name' => 'Noord-Brabant'],
      ['code' => 'NH', 'name' => 'Noord-Holland'],
      ['code' => 'OV', 'name' => 'Overijssel'],
      ['code' => 'UT', 'name' => 'Utrecht'],
      ['code' => 'ZE', 'name' => 'Zeeland'],
      ['code' => 'ZH', 'name' => 'Zuid-Holland']
    ],
    'GB' => [
      ['code' => 'ABE', 'name' => 'Aberdeenshire'],
      ['code' => 'ALY', 'name' => 'Anglesey'],
      ['code' => 'ANG', 'name' => 'Angus'],
      ['code' => 'ARG', 'name' => 'Argyll'],
      ['code' => 'AYR', 'name' => 'Ayrshire'],
      ['code' => 'BAN', 'name' => 'Banffshire'],
      ['code' => 'BED', 'name' => 'Bedfordshire'],
      ['code' => 'BER', 'name' => 'Berkshire'],
      ['code' => 'BWS', 'name' => 'Berwickshire'],
      ['code' => 'BRE', 'name' => 'Brecknockshire'],
      ['code' => 'BUC', 'name' => 'Buckinghamshire'],
      ['code' => 'BUT', 'name' => 'Bute'],
      ['code' => 'CAE', 'name' => 'Caernarfonshire'],
      ['code' => 'CAI', 'name' => 'Caithness'],
      ['code' => 'CAM', 'name' => 'Cambridgeshire'],
      ['code' => 'CAR', 'name' => 'Cardiganshire'],
      ['code' => 'CMS', 'name' => 'Carmarthenshire'],
      ['code' => 'CHE', 'name' => 'Cheshire'],
      ['code' => 'CLA', 'name' => 'Clackmannanshire'],
      ['code' => 'CLE', 'name' => 'Cleveland'],
      ['code' => 'COR', 'name' => 'Cornwall'],
      ['code' => 'CRO', 'name' => 'Cromartyshire'],
      ['code' => 'CBR', 'name' => 'Cumberland'],
      ['code' => 'CUM', 'name' => 'Cumbria'],
      ['code' => 'DEN', 'name' => 'Denbighshire'],
      ['code' => 'DER', 'name' => 'Derbyshire'],
      ['code' => 'DEV', 'name' => 'Devon'],
      ['code' => 'DOR', 'name' => 'Dorset'],
      ['code' => 'DBS', 'name' => 'Dumbartonshire'],
      ['code' => 'DUM', 'name' => 'Dumfriesshire'],
      ['code' => 'DUR', 'name' => 'Durham'],
      ['code' => 'ELO', 'name' => 'East Lothian'],
      ['code' => 'ESS', 'name' => 'Essex'],
      ['code' => 'FLI', 'name' => 'Flintshire'],
      ['code' => 'FIF', 'name' => 'Fife'],
      ['code' => 'GLA', 'name' => 'Glamorgan'],
      ['code' => 'GLO', 'name' => 'Gloucestershire'],
      ['code' => 'HAM', 'name' => 'Hampshire'],
      ['code' => 'HER', 'name' => 'Herefordshire'],
      ['code' => 'HTF', 'name' => 'Hertfordshire'],
      ['code' => 'HUN', 'name' => 'Huntingdonshire'],
      ['code' => 'INV', 'name' => 'Inverness'],
      ['code' => 'KEN', 'name' => 'Kent'],
      ['code' => 'KCD', 'name' => 'Kincardineshire'],
      ['code' => 'KIN', 'name' => 'Kinross-shire'],
      ['code' => 'KIR', 'name' => 'Kirkcudbrightshire'],
      ['code' => 'LKS', 'name' => 'Lanarkshire'],
      ['code' => 'LAN', 'name' => 'Lancashire'],
      ['code' => 'LEI', 'name' => 'Leicestershire'],
      ['code' => 'LIN', 'name' => 'Lincolnshire'],
      ['code' => 'LON', 'name' => 'London'],
      ['code' => 'MAN', 'name' => 'Manchester'],
      ['code' => 'MER', 'name' => 'Merionethshire'],
      ['code' => 'MSY', 'name' => 'Merseyside'],
      ['code' => 'MDX', 'name' => 'Middlesex'],
      ['code' => 'MID', 'name' => 'Midlands'],
      ['code' => 'MLT', 'name' => 'Midlothian'],
      ['code' => 'MON', 'name' => 'Monmouthshire'],
      ['code' => 'MGY', 'name' => 'Montgomeryshire'],
      ['code' => 'MOR', 'name' => 'Moray'],
      ['code' => 'NAI', 'name' => 'Nairnshire'],
      ['code' => 'NOR', 'name' => 'Norfolk'],
      ['code' => 'NMP', 'name' => 'Northamptonshire'],
      ['code' => 'NUM', 'name' => 'Northumberland'],
      ['code' => 'NOT', 'name' => 'Nottinghamshire'],
      ['code' => 'ORK', 'name' => 'Orkney'],
      ['code' => 'OXF', 'name' => 'Oxfordshire'],
      ['code' => 'PEE', 'name' => 'Peebleshire'],
      ['code' => 'PEM', 'name' => 'Pembrokeshire'],
      ['code' => 'PER', 'name' => 'Perthshire'],
      ['code' => 'RAD', 'name' => 'Radnorshire'],
      ['code' => 'REN', 'name' => 'Renfrewshire'],
      ['code' => 'ROS', 'name' => 'Ross & Cromarty'],
      ['code' => 'ROX', 'name' => 'Roxburghshire'],
      ['code' => 'RUT', 'name' => 'Rutland'],
      ['code' => 'SEL', 'name' => 'Selkirkshire'],
      ['code' => 'SHE', 'name' => 'Shetland'],
      ['code' => 'SHR', 'name' => 'Shropshire'],
      ['code' => 'SOM', 'name' => 'Somerset'],
      ['code' => 'STA', 'name' => 'Staffordshire'],
      ['code' => 'STI', 'name' => 'Stirlingshire'],
      ['code' => 'SUF', 'name' => 'Suffolk'],
      ['code' => 'SUR', 'name' => 'Surrey'],
      ['code' => 'SUS', 'name' => 'Sussex'],
      ['code' => 'SUT', 'name' => 'Sutherland'],
      ['code' => 'TYN', 'name' => 'Tyne & Wear'],
      ['code' => 'WAR', 'name' => 'Warwickshire'],
      ['code' => 'WLO', 'name' => 'West Lothian'],
      ['code' => 'WES', 'name' => 'Westmorland'],
      ['code' => 'WIG', 'name' => 'Wigtownshire'],
      ['code' => 'WIL', 'name' => 'Wiltshire'],
      ['code' => 'WOR', 'name' => 'Worcestershire'],
      ['code' => 'YOR', 'name' => 'Yorkshire']
    ],
    'RO' => [
      ['code' => 'AB', 'name' => 'Alba'],
      ['code' => 'AR', 'name' => 'Arad'],
      ['code' => 'AG', 'name' => 'Arges'],
      ['code' => 'BC', 'name' => 'Bacău'],
      ['code' => 'BH', 'name' => 'Bihor'],
      ['code' => 'BN', 'name' => 'Bistrita - Nasaud Bistrita'],
      ['code' => 'BT', 'name' => 'Botosani'],
      ['code' => 'BV', 'name' => 'Brasov'],
      ['code' => 'BR', 'name' => 'Braila'],
      ['code' => 'B', 'name' => 'Bucuresti'],
      ['code' => 'BZ', 'name' => 'Buzau'],
      ['code' => 'CS', 'name' => 'Caras - Severin'],
      ['code' => 'CL', 'name' => 'Calarasi'],
      ['code' => 'CJ', 'name' => 'Cluj'],
      ['code' => 'CT', 'name' => 'Constanta'],
      ['code' => 'CV', 'name' => 'Covasna Sfantu Gheorghe'],
      ['code' => 'DB', 'name' => 'Dambovita'],
      ['code' => 'DJ', 'name' => 'Dolj'],
      ['code' => 'GL', 'name' => 'Galati'],
      ['code' => 'GR', 'name' => 'Giurgiu'],
      ['code' => 'GJ', 'name' => 'Gorj'],
      ['code' => 'HR', 'name' => 'Harghita'],
      ['code' => 'HD', 'name' => 'Hunedoara'],
      ['code' => 'IL', 'name' => 'Ialomita'],
      ['code' => 'IS', 'name' => 'Iasi'],
      ['code' => 'IF', 'name' => 'Ilfov'],
      ['code' => 'MM', 'name' => 'Maramures'],
      ['code' => 'MH', 'name' => 'Mehedinti'],
      ['code' => 'MS', 'name' => 'Mures'],
      ['code' => 'NT', 'name' => 'Neamt'],
      ['code' => 'OT', 'name' => 'Olt'],
      ['code' => 'PH', 'name' => 'Prahova Ploiesti'],
      ['code' => 'SM', 'name' => 'Satu Mare'],
      ['code' => 'SJ', 'name' => 'Salaj'],
      ['code' => 'SB', 'name' => 'Sibiu'],
      ['code' => 'SV', 'name' => 'Suceava'],
      ['code' => 'TR', 'name' => 'Teleorman'],
      ['code' => 'TM', 'name' => 'Timis'],
      ['code' => 'TL', 'name' => 'Tulcea'],
      ['code' => 'VS', 'name' => 'Vaslui'],
      ['code' => 'VL', 'name' => 'Valcea'],
      ['code' => 'VN', 'name' => 'Vrancea']
    ],
    'HU' => [
      ['code' => 'BUD', 'name' => 'Budapest'],
      ['code' => 'BAR', 'name' => 'Baranya'],
      ['code' => 'BKM', 'name' => 'Bács-Kiskun'],
      ['code' => 'BEK', 'name' => 'Békés'],
      ['code' => 'BAZ', 'name' => 'Borsod-Abaúj-Zemplén'],
      ['code' => 'CSO', 'name' => 'Csongrád'],
      ['code' => 'FEJ', 'name' => 'Fejér'],
      ['code' => 'GMS', 'name' => 'Győr-Moson-Sopron'],
      ['code' => 'HBM', 'name' => 'Hajdú-Bihar'],
      ['code' => 'HEV', 'name' => 'Heves'],
      ['code' => 'JNS', 'name' => 'Jász-Nagykun-Szolnok'],
      ['code' => 'KEM', 'name' => 'Komárom-Esztergom'],
      ['code' => 'NOG', 'name' => 'Nógrád'],
      ['code' => 'PES', 'name' => 'Pest'],
      ['code' => 'SOM', 'name' => 'Somogy'],
      ['code' => 'SSB', 'name' => 'Szabolcs-Szatmár-Bereg'],
      ['code' => 'TOL', 'name' => 'Tolna'],
      ['code' => 'VAS', 'name' => 'Vas'],
      ['code' => 'VES', 'name' => 'Veszprém'],
      ['code' => 'ZAL', 'name' => 'Zala']
    ],
    'IN' => [
      ['code' => 'AP', 'name' => 'Andhra Pradesh'],
      ['code' => 'AR', 'name' => 'Arunachal Pradesh'],
      ['code' => 'AS', 'name' => 'Assam'],
      ['code' => 'BR', 'name' => 'Bihar'],
      ['code' => 'CT', 'name' => 'Chhattisgarh'],
      ['code' => 'GA', 'name' => 'Goa'],
      ['code' => 'GJ', 'name' => 'Gujarat'],
      ['code' => 'HR', 'name' => 'Haryana'],
      ['code' => 'HP', 'name' => 'Himachal Pradesh'],
      ['code' => 'JK', 'name' => 'Jammu and Kashmir'],
      ['code' => 'JH', 'name' => 'Jharkhand'],
      ['code' => 'KA', 'name' => 'Karnataka'],
      ['code' => 'KL', 'name' => 'Kerala'],
      ['code' => 'MP', 'name' => 'Madhya Pradesh'],
      ['code' => 'MH', 'name' => 'Maharashtra'],
      ['code' => 'MN', 'name' => 'Manipur'],
      ['code' => 'ML', 'name' => 'Meghalaya'],
      ['code' => 'MZ', 'name' => 'Mizoram'],
      ['code' => 'NL', 'name' => 'Nagaland'],
      ['code' => 'OR', 'name' => 'Odisha'],
      ['code' => 'PB', 'name' => 'Punjab'],
      ['code' => 'RJ', 'name' => 'Rajasthan'],
      ['code' => 'SK', 'name' => 'Sikkim'],
      ['code' => 'TN', 'name' => 'Tamil Nadu'],
      ['code' => 'TG', 'name' => 'Telangana'],
      ['code' => 'TR', 'name' => 'Tripura'],
      ['code' => 'UT', 'name' => 'Uttarakhand'],
      ['code' => 'UP', 'name' => 'Uttar Pradesh'],
      ['code' => 'WB', 'name' => 'West Bengal'],
      ['code' => 'AN', 'name' => 'Andaman and Nicobar Islands'],
      ['code' => 'CH', 'name' => 'Chandigarh'],
      ['code' => 'DN', 'name' => 'Dadra and Nagar Haveli'],
      ['code' => 'DD', 'name' => 'Daman and Diu'],
      ['code' => 'DL', 'name' => 'Delhi'],
      ['code' => 'LD', 'name' => 'Lakshadweep'],
      ['code' => 'PY', 'name' => 'Puducherry']
    ],
    'NZ' => [
      ['code' => 'NTL', 'name' => "Northland"],
      ['code' => 'AUK', 'name' => "Auckland"],
      ['code' => 'WKO', 'name' => "Waikato"],
      ['code' => 'BOP', 'name' => "Bay of Plenty"],
      ['code' => 'GIS', 'name' => "Gisborne"],
      ['code' => 'HKB', 'name' => "Hawke's Bay"],
      ['code' => 'TKI', 'name' => "Taranaki"],
      ['code' => 'MWT', 'name' => "Manawatu-Wanganui"],
      ['code' => 'WGN', 'name' => "Wellington"],
      ['code' => 'TAS', 'name' => "Tasman"],
      ['code' => 'NSN', 'name' => "Nelson"],
      ['code' => 'MBH', 'name' => "Marlborough"],
      ['code' => 'WTC', 'name' => "West Coast"],
      ['code' => 'CAN', 'name' => "Canterbury"],
      ['code' => 'OTA', 'name' => "Otago Otago"],
      ['code' => 'STL', 'name' => "Southland"],
    ],
    'ES' => [
      ['code' => 'ES-C', 'name' => "A Coruña (gl) [La Coruña]"],
      ['code' => 'ES-VI', 'name' => "Araba (eu)"],
      ['code' => 'ES-AB', 'name' => "Albacete"],
      ['code' => 'ES-A', 'name' => "Alacant (ca)"],
      ['code' => 'ES-AL', 'name' => "Almería"],
      ['code' => 'ES-O', 'name' => "Asturias"],
      ['code' => 'ES-AV', 'name' => "Ávila"],
      ['code' => 'ES-BA', 'name' => "Badajoz"],
      ['code' => 'ES-PM', 'name' => "Balears (ca) [Baleares]"],
      ['code' => 'ES-B', 'name' => "Barcelona [Barcelona]"],
      ['code' => 'ES-BU', 'name' => "Burgos"],
      ['code' => 'ES-CC', 'name' => "Cáceres"],
      ['code' => 'ES-CA', 'name' => "Cádiz"],
      ['code' => 'ES-S', 'name' => "Cantabria"],
      ['code' => 'ES-CS', 'name' => "Castelló (ca)"],
      ['code' => 'ES-CR', 'name' => "Ciudad Real"],
      ['code' => 'ES-CO', 'name' => "Córdoba"],
      ['code' => 'ES-CU', 'name' => "Cuenca"],
      ['code' => 'ES-GI', 'name' => "Girona (ca) [Gerona]"],
      ['code' => 'ES-GR', 'name' => "Granada"],
      ['code' => 'ES-GU', 'name' => "Guadalajara"],
      ['code' => 'ES-SS', 'name' => "Gipuzkoa (eu)"],
      ['code' => 'ES-H', 'name' => "Huelva"],
      ['code' => 'ES-HU', 'name' => "Huesca"],
      ['code' => 'ES-J', 'name' => "Jaén"],
      ['code' => 'ES-LO', 'name' => "La Rioja"],
      ['code' => 'ES-GC', 'name' => "Las Palmas"],
      ['code' => 'ES-LE', 'name' => "León"],
      ['code' => 'ES-L', 'name' => "Lleida (ca) [Lérida]"],
      ['code' => 'ES-LU', 'name' => "Lugo (gl) [Lugo]"],
      ['code' => 'ES-M', 'name' => "Madrid"],
      ['code' => 'ES-MA', 'name' => "Málaga"],
      ['code' => 'ES-MU', 'name' => "Murcia"],
      ['code' => 'ES-NA', 'name' => "Nafarroa (eu)"],
      ['code' => 'ES-OR', 'name' => "Ourense (gl) [Orense]"],
      ['code' => 'ES-P', 'name' => "Palencia"],
      ['code' => 'ES-PO', 'name' => "Pontevedra (gl) [Pontevedra]"],
      ['code' => 'ES-SA', 'name' => "Salamanca"],
      ['code' => 'ES-TF', 'name' => "Santa Cruz de Tenerife"],
      ['code' => 'ES-SG', 'name' => "Segovia"],
      ['code' => 'ES-SE', 'name' => "Sevilla"],
      ['code' => 'ES-SO', 'name' => "Soria"],
      ['code' => 'ES-T', 'name' => "Tarragona (ca) [Tarragona]"],
      ['code' => 'ES-TE', 'name' => "Teruel"],
      ['code' => 'ES-TO', 'name' => "Toledo"],
      ['code' => 'ES-V', 'name' => "València (ca)"],
      ['code' => 'ES-VA', 'name' => "Valladolid"],
      ['code' => 'ES-BI', 'name' => "Bizkaia (eu)"],
      ['code' => 'ES-ZA', 'name' => "Zamora"],
      ['code' => 'ES-Z', 'name' => "Zaragoza"],
    ],
    'MX' => [
      ["code" => "MX-AGU", "name" => "Aguascalientes"],
      ["code" => "MX-BCN", "name" => "Baja California"],
      ["code" => "MX-BCS", "name" => "Baja California Sur"],
      ["code" => "MX-CAM", "name" => "Campeche"],
      ["code" => "MX-CHP", "name" => "Chiapas"],
      ["code" => "MX-CHH", "name" => "Chihuahua"],
      ["code" => "MX-COA", "name" => "Coahuila"],
      ["code" => "MX-COL", "name" => "Colima"],
      ["code" => "MX-CMX", "name" => "Ciudad de México"],
      ["code" => "MX-DUR", "name" => "Durango"],
      ["code" => "MX-GUA", "name" => "Guanajuato"],
      ["code" => "MX-GRO", "name" => "Guerrero"],
      ["code" => "MX-HID", "name" => "Hidalgo"],
      ["code" => "MX-JAL", "name" => "Jalisco"],
      ["code" => "MX-MEX", "name" => "Estado de México"],
      ["code" => "MX-MIC", "name" => "Michoacán"],
      ["code" => "MX-MOR", "name" => "Morelos"],
      ["code" => "MX-NAY", "name" => "Nayarit"],
      ["code" => "MX-NLE", "name" => "Nuevo León"],
      ["code" => "MX-OAX", "name" => "Oaxaca"],
      ["code" => "MX-PUE", "name" => "Puebla"],
      ["code" => "MX-QUE", "name" => "Querétaro"],
      ["code" => "MX-ROO", "name" => "Quintana Roo"],
      ["code" => "MX-SLP", "name" => "San Luis Potosí"],
      ["code" => "MX-SIN", "name" => "Sinaloa"],
      ["code" => "MX-SON", "name" => "Sonora"],
      ["code" => "MX-TAB", "name" => "Tabasco"],
      ["code" => "MX-TAM", "name" => "Tamaulipas"],
      ["code" => "MX-TLA", "name" => "Tlaxcala"],
      ["code" => "MX-VER", "name" => "Veracruz"],
      ["code" => "MX-YUC", "name" => "Yucatán"],
      ["code" => "MX-ZAC", "name" => "Zacatecas"]
    ],
    'MA' => array(
      array('name' => 'Tanger-Tetouan-Al Hoceima', 'code' => 'tanger-tetouan-al-hoceima', 'lat' => '35.206466', 'lng' => '-5.507075'),
      array('name' => 'Oriental', 'code' => 'oriental', 'lat' => '34.643564', 'lng' => '-2.878440'),
      array('name' => 'Fes-Meknes', 'code' => 'fes-meknes', 'lat' => '33.916910', 'lng' => '-4.868812'),
      array('name' => 'Rabat-Salé-Kenitra', 'code' => 'rabat-sale-kenitra', 'lat' => '34.485209', 'lng' => '-6.196617'),
      array('name' => 'Beni Mellal-Khenifra', 'code' => 'beni-mellal-khenifra', 'lat' => '32.342443', 'lng' => '-6.375799'),
      array('name' => 'Casablanca-Settat', 'code' => 'casablanca-settat', 'lat' => '33.278561', 'lng' => '-7.776502'),
      array('name' => 'Marrakech-Safi', 'code' => 'marrakech-safi', 'lat' => '31.763962', 'lng' => '-8.566692'),
      array('name' => 'Drâa‐Tafilalet', 'code' => 'draatafilalet', 'lat' => '31.823711', 'lng' => '-4.849561'),
      array('name' => 'Sous-Massa', 'code' => 'sous-massa', 'lat' => '30.028170', 'lng' => '-8.826997'),
      array('name' => 'Guelmim-Oued Noun', 'code' => 'guelmim-oued-noun', 'lat' => '28.612718', 'lng' => '-10.270442'),
      array('name' => 'Laâyoune‐Saguia al Hamra', 'code' => 'laayounesaguia-al-hamra', 'lat' => '27.075006', 'lng' => '-12.092444'),
      array('name' => 'Ed Dakhla‐Oued ed Dahab', 'code' => 'ed-dakhlaoued-ed-dahab', 'lat' => '23.235782', 'lng' => '-14.416212')
    ),
    'LU' => array(
      array('lat' => '49.5877', 'lng' => '5.9782', 'name' => 'Capellen', 'code' => 'LU-CA'),
      array('lat' => '50.0605', 'lng' => '6.0243', 'name' => 'Clervaux', 'code' => 'LU-CL'),
      array('lat' => '49.8629', 'lng' => '6.1571', 'name' => 'Diekirch', 'code' => 'LU-DI'),
      array('lat' => '49.8368', 'lng' => '6.2874', 'name' => 'Echternach', 'code' => 'LU-EC'),
      array('lat' => '49.5133', 'lng' => '6.1139', 'name' => 'Esch-sur-Alzette', 'code' => 'LU-ES'),
      array('lat' => '49.6686', 'lng' => '6.3027', 'name' => 'Grevenmacher', 'code' => 'LU-GR'),
      array('lat' => '49.6146', 'lng' => '6.0454', 'name' => 'Luxembourg', 'code' => 'LU-LU'),
      array('lat' => '49.8127', 'lng' => '6.0975', 'name' => 'Mersch', 'code' => 'LU-ME'),
      array('lat' => '49.7576', 'lng' => '5.8253', 'name' => 'Redange', 'code' => 'LU-RD'),
      array('lat' => '49.5453', 'lng' => '6.2557', 'name' => 'Remich', 'code' => 'LU-RM'),
      array('lat' => '49.9391', 'lng' => '6.2072', 'name' => 'Vianden', 'code' => 'LU-VD'),
      array('lat' => '49.9687', 'lng' => '5.9304', 'name' => 'Wiltz', 'code' => 'LU-WI'),
    ),
    'FR' => array(
      array('lat' => '41.9189', 'lng' => '8.7381', 'name' => 'Corse', 'code' => '20R'),
      array('lat' => '48.8534', 'lng' => '2.3488', 'name' => 'Île-de-France', 'code' => 'IDF'),
      array('lat' => '47.0833', 'lng' => '2.4000', 'name' => 'Centre-Val de Loire', 'code' => 'CVL'),
      array('lat' => '47.3167', 'lng' => '5.0167', 'name' => 'Bourgogne-Franche-Comté', 'code' => 'BFC'),
      array('lat' => '49.1859', 'lng' => '-0.3591', 'name' => 'Normandie', 'code' => 'NOR'),
      array('lat' => '49.5378', 'lng' => '3.5540', 'name' => 'Hauts-de-France', 'code' => 'HDF'),
      array('lat' => '48.2152', 'lng' => '5.9195', 'name' => 'Grand Est', 'code' => 'GES'),
      array('lat' => '47.2173', 'lng' => '-1.5534', 'name' => 'Pays de la Loire', 'code' => 'PDL'),
      array('lat' => '48.5151', 'lng' => '-2.7684', 'name' => 'Bretagne', 'code' => 'BRE'),
      array('lat' => '45.6500', 'lng' => '0.1500', 'name' => 'Nouvelle-Aquitaine', 'code' => 'NAQ'),
      array('lat' => '43.0128', 'lng' => '1.5416', 'name' => 'Occitanie', 'code' => 'OCC'),
      array('lat' => '46.0901', 'lng' => '6.5000', 'name' => 'Auvergne-Rhône-Alpes', 'code' => 'ARA'),
      array('lat' => '44.0461', 'lng' => '6.2666', 'name' => 'Provence-Alpes-Côte-d’Azur', 'code' => 'PAC'),
    ),
    'BE' => array(
      array('lat' => '50.8428', 'lng' => '4.3515', 'name' => 'Vlaams-Brabant', 'code' => 'VBR'),
      array('lat' => '50.6935', 'lng' => '4.5733', 'name' => 'Waals-Brabant', 'code' => 'WBR'),
      array('lat' => '51.2199', 'lng' => '4.4011', 'name' => 'Antwerpen', 'code' => 'VAN'),
      array('lat' => '50.9215', 'lng' => '5.3447', 'name' => 'Limburg', 'code' => 'VLI'),
      array('lat' => '50.6479', 'lng' => '5.5436', 'name' => 'Luik', 'code' => 'WLG'),
      array('lat' => '50.4687', 'lng' => '4.9118', 'name' => 'namen', 'code' => 'WNA'),
      array('lat' => '50.4109', 'lng' => '4.4447', 'name' => 'Henegouwen', 'code' => 'WHT'),
      array('lat' => '50.0006', 'lng' => '5.7153', 'name' => 'Luxemburg', 'code' => 'WLX'),
      array('lat' => '51.2093', 'lng' => '3.2247', 'name' => 'West-Vlaanderen', 'code' => 'VWV'),
      array('lat' => '51.0678', 'lng' => '3.7291', 'name' => 'Oost-Vlaanderen', 'code' => 'VOV'),
    ),
  ];
  protected $cities = [

    // Maroc
    'tanger-tetouan-al-hoceima' => [
      array('name' => 'Tanger', 'slug' => 'tanger', 'is_pinned' => '1', 'lat' => '35.759465', 'lng' => '-5.833954'),
      array('name' => 'Tetouan', 'slug' => 'tetouan', 'is_pinned' => '1', 'lat' => '35.588899', 'lng' => '-5.362552'),
      array('name' => 'Al Hoceïma', 'slug' => 'al-hoceima', 'is_pinned' => '0', 'lat' => '35.244559', 'lng' => '-3.931747'),
      array('name' => 'Ksar El Kebir', 'slug' => 'ksar-el-kebir', 'is_pinned' => '0', 'lat' => '35.003531', 'lng' => '-5.915537'),
      array('name' => 'Larache', 'slug' => 'larache', 'is_pinned' => '0', 'lat' => '35.174427', 'lng' => '-6.147396'),
      array('name' => 'Fnideq', 'slug' => 'fnideq', 'is_pinned' => '0', 'lat' => '35.843277', 'lng' => '-5.361035'),
      array('name' => 'M\'diq', 'slug' => 'mdiq', 'is_pinned' => '0', 'lat' => '35.680583', 'lng' => '-5.323321'),
      array('name' => 'Martil', 'slug' => 'martil', 'is_pinned' => '0', 'lat' => '35.619626', 'lng' => '-5.284118'),
      array('name' => 'Assilah', 'slug' => 'assilah', 'is_pinned' => '0', 'lat' => '35.464613', 'lng' => '-6.030865'),
      array('name' => 'Ouezzane', 'slug' => 'ouezzane', 'is_pinned' => '0', 'lat' => '34.795373', 'lng' => '-5.567558'),
      array('name' => 'Chefchaouen', 'slug' => 'chefchaouen', 'is_pinned' => '0', 'lat' => '35.168796', 'lng' => '-5.268364'),
      array('name' => 'Ksar Sghir', 'slug' => 'ksar-sghir', 'is_pinned' => '0', 'lat' => '35.836045', 'lng' => '-5.556478'),
    ],
    'oriental' => [
      array('name' => 'Oujda', 'slug' => 'oujda', 'is_pinned' => '1', 'lat' => '34.681962', 'lng' => '-1.900155'),
      array('name' => 'Nador', 'slug' => 'nador', 'is_pinned' => '1', 'lat' => '35.168616', 'lng' => '-2.927584'),
      array('name' => 'Berkane', 'slug' => 'berkane', 'is_pinned' => '1', 'lat' => '34.917728', 'lng' => '-2.312303'),
      array('name' => 'Taourirt', 'slug' => 'taourirt', 'is_pinned' => '0', 'lat' => '34.398372', 'lng' => '-2.893503'),
      array('name' => 'Guercif', 'slug' => 'guercif', 'is_pinned' => '0', 'lat' => '34.229939', 'lng' => '-3.348967'),
      array('name' => 'Jerada', 'slug' => 'jerada', 'is_pinned' => '0', 'lat' => '34.306179', 'lng' => '-2.179414'),
      array('name' => 'Beni Ensar', 'slug' => 'beni-ensar', 'is_pinned' => '0', 'lat' => '35.265301', 'lng' => '-2.932191'),
      array('name' => 'Zeghanghane', 'slug' => 'zeghanghane', 'is_pinned' => '0', 'lat' => '35.158609', 'lng' => '-3.000060'),
      array('name' => 'Al Aaroui', 'slug' => 'al-aaroui', 'is_pinned' => '0', 'lat' => '35.012709', 'lng' => '-3.007564'),
      array('name' => 'Driouch', 'slug' => 'driouch', 'is_pinned' => '0', 'lat' => '34.979253', 'lng' => '-3.398304'),
      array('name' => 'Bouarfa', 'slug' => 'bouarfa', 'is_pinned' => '0', 'lat' => '32.527518', 'lng' => '-1.973474'),
      array('name' => 'Figuig', 'slug' => 'figuig', 'is_pinned' => '0', 'lat' => '32.109261', 'lng' => '-1.229806'),
      array('name' => 'Saïdia', 'slug' => 'saidia', 'is_pinned' => '0', 'lat' => '35.099883', 'lng' => '-2.287665'),
    ],
    'fes-meknes' => [
      array('name' => 'Meknes', 'slug' => 'meknes', 'is_pinned' => '1', 'lat' => '33.873016', 'lng' => '-5.540730'),
      array('name' => 'Fes', 'slug' => 'fes', 'is_pinned' => '1', 'lat' => '34.018125', 'lng' => '-5.007845'),
      array('name' => 'Taza', 'slug' => 'taza', 'is_pinned' => '1', 'lat' => '34.210560', 'lng' => '-3.998048'),
      array('name' => 'Sefrou', 'slug' => 'sefrou', 'is_pinned' => '0', 'lat' => '33.830524', 'lng' => '-4.835315'),
      array('name' => 'Azrou', 'slug' => 'azrou', 'is_pinned' => '0', 'lat' => '33.434731', 'lng' => '-5.231888'),
      array('name' => 'Ifrane', 'slug' => 'ifrane', 'is_pinned' => '0', 'lat' => '33.522806', 'lng' => '-5.110955'),
      array('name' => 'El Hajeb', 'slug' => 'el-hajeb', 'is_pinned' => '0', 'lat' => '33.685735', 'lng' => '-5.367784'),
      array('name' => 'Taounate', 'slug' => 'taounate', 'is_pinned' => '0', 'lat' => '34.536917', 'lng' => '-4.639869'),
      array('name' => 'Missour', 'slug' => 'missour', 'is_pinned' => '0', 'lat' => '33.046081', 'lng' => '-3.995497'),
      array('name' => 'Outat El Haj', 'slug' => 'outat-el-haj', 'is_pinned' => '0', 'lat' => '33.343342', 'lng' => '-3.728277'),
      array('name' => 'Ain Taoujtat', 'slug' => 'ain-taoujdate', 'is_pinned' => '0', 'lat' => '', 'lng' => ''),
    ],
    'rabat-sale-kenitra' => [
      array('name' => 'Rabat', 'slug' => 'rabat', 'is_pinned' => '1', 'lat' => '33.971590', 'lng' => '-6.849813'),
      array('name' => 'Salé', 'slug' => 'sale', 'is_pinned' => '1', 'lat' => '34.033697', 'lng' => '-6.770814'),
      array('name' => 'Kenitra', 'slug' => 'kenitra', 'is_pinned' => '1', 'lat' => '34.254050', 'lng' => '-6.589017'),
      array('name' => 'Temara', 'slug' => 'temara', 'is_pinned' => '1', 'lat' => '33.920327', 'lng' => '-6.927397'),
      array('name' => 'Sala Al-Jadida', 'slug' => 'sala-al-jadida', 'is_pinned' => '0', 'lat' => '33.994013', 'lng' => '-6.736019'),
      array('name' => 'Skhirate', 'slug' => 'skhirate', 'is_pinned' => '0', 'lat' => '33.850948', 'lng' => '-7.060600'),
      array('name' => 'Khemisset', 'slug' => 'khemisset', 'is_pinned' => '0', 'lat' => '33.822763', 'lng' => '-6.073747'),
      array('name' => 'Tiflet', 'slug' => 'tiflet', 'is_pinned' => '0', 'lat' => '33.895480', 'lng' => '-6.320715'),
      array('name' => 'Sidi Kacem', 'slug' => 'sidi-kacem', 'is_pinned' => '0', 'lat' => '34.226017', 'lng' => '-5.712916'),
      array('name' => 'Sidi Slimane', 'slug' => 'sidi-slimane', 'is_pinned' => '0', 'lat' => '34.262296', 'lng' => '-5.923975'),
      array('name' => 'Mechra Bel Ksiri', 'slug' => 'mechra-bel-ksiri', 'is_pinned' => '0', 'lat' => '34.573993', 'lng' => '-5.951540'),
    ],
    'beni-mellal-khenifra' => [
      array('name' => 'Khouribga', 'slug' => 'khouribga', 'is_pinned' => '1', 'lat' => '32.886023', 'lng' => '-6.920865'),
      array('name' => 'Beni-Mellal', 'slug' => 'beni-mellal', 'is_pinned' => '1', 'lat' => '32.342443', 'lng' => '-6.375799'),
      array('name' => 'Khenifra', 'slug' => 'khenifra', 'is_pinned' => '0', 'lat' => '32.934047', 'lng' => '-5.661571'),
      array('name' => 'Oued Zem', 'slug' => 'oued-zem', 'is_pinned' => '0', 'lat' => '32.850150', 'lng' => '-6.577519'),
      array('name' => 'Fquih Ben Salah', 'slug' => 'fquih-ben-salah', 'is_pinned' => '0', 'lat' => '32.500922', 'lng' => '-6.690546'),
      array('name' => 'Kasba Tadla', 'slug' => 'kasba-tadla', 'is_pinned' => '0', 'lat' => '32.595828', 'lng' => '-6.269461'),
      array('name' => 'Bejaâd', 'slug' => 'bejaad', 'is_pinned' => '0', 'lat' => '32.769197', 'lng' => '-6.393222'),
      array('name' => 'M\'rirt', 'slug' => 'mrirt', 'is_pinned' => '0', 'lat' => '33.162714', 'lng' => '-5.566979'),
      array('name' => 'Azilal', 'slug' => 'azilal', 'is_pinned' => '0', 'lat' => '31.964911', 'lng' => '-6.573000'),
    ],
    'casablanca-settat' => [
      array('name' => 'Casablanca', 'slug' => 'casablanca', 'is_pinned' => '1', 'lat' => '33.573110', 'lng' => '-7.589843'),
      array('name' => 'Mohammedia', 'slug' => 'mohammedia', 'is_pinned' => '1', 'lat' => '33.683509', 'lng' => '-7.384855'),
      array('name' => 'Bouskoura', 'slug' => 'bouskoura', 'is_pinned' => '0', 'lat' => '33.449754', 'lng' => '-7.633113'),
      array('name' => 'Ain Harrouda', 'slug' => 'ain-harrouda', 'is_pinned' => '0', 'lat' => '33.635310', 'lng' => '-7.450383'),
      array('name' => 'Settat', 'slug' => 'settat', 'is_pinned' => '0', 'lat' => '32.992424', 'lng' => '-7.622267'),
      array('name' => 'Berrechid', 'slug' => 'berrechid', 'is_pinned' => '0', 'lat' => '33.268687', 'lng' => '-7.584317'),
      array('name' => 'El Jadida', 'slug' => 'el-jadida', 'is_pinned' => '1', 'lat' => '33.231633', 'lng' => '-8.500712'),
      array('name' => 'Azemmour', 'slug' => 'azemmour', 'is_pinned' => '0', 'lat' => '33.286667', 'lng' => '-8.347178'),
      array('name' => 'Sidi Bouzid', 'slug' => 'sidi-bouzid', 'is_pinned' => '0', 'lat' => '33.231214', 'lng' => '-8.547382'),
      array('name' => 'Benslimane', 'slug' => 'benslimane', 'is_pinned' => '0', 'lat' => '33.618970', 'lng' => '-7.130554'),
      array('name' => 'Bouznika', 'slug' => 'bouznika', 'is_pinned' => '0', 'lat' => '33.773434', 'lng' => '-7.159942'),
      array('name' => 'Sidi Bennour', 'slug' => 'sidi-bennour', 'is_pinned' => '0', 'lat' => '32.652162', 'lng' => '-8.426647'),
      array('name' => 'Had Soualem', 'slug' => 'had-soualem', 'is_pinned' => '0', 'lat' => '33.421256', 'lng' => '-7.846998'),
      array('name' => 'Nouaceur', 'slug' => 'nouaceur', 'is_pinned' => '0', 'lat' => '33.367039', 'lng' => '-7.573254'),
    ],
    'marrakech-safi' => [
      array('name' => 'Marrakech', 'slug' => 'marrakech', 'is_pinned' => '1', 'lat' => '31.629472', 'lng' => '-7.981084'),
      array('name' => 'Kelaat Es-sraghna', 'slug' => 'kelaat-es-sraghna', 'is_pinned' => '0', 'lat' => '32.055096', 'lng' => '-7.400287'),
      array('name' => 'Safi', 'slug' => 'safi', 'is_pinned' => '1', 'lat' => '32.300815', 'lng' => '-9.227203'),
      array('name' => 'Essaouira', 'slug' => 'essaouira', 'is_pinned' => '0', 'lat' => '31.508493', 'lng' => '-9.759504'),
      array('name' => 'Ben Guerir', 'slug' => 'ben-guerir', 'is_pinned' => '0', 'lat' => '32.235936', 'lng' => '-7.953838'),
      array('name' => 'Youssoufia', 'slug' => 'youssoufia', 'is_pinned' => '0', 'lat' => '32.243843', 'lng' => '-8.522671'),
      array('name' => 'Ait Ourir', 'slug' => 'ait-ourir', 'is_pinned' => '0', 'lat' => '31.563434', 'lng' => '-7.671089'),
      array('name' => 'Echemaïa', 'slug' => 'echemaia', 'is_pinned' => '0', 'lat' => '32.089535', 'lng' => '-8.607393'),
      array('name' => 'Chichaoua', 'slug' => 'chichaoua', 'is_pinned' => '0', 'lat' => '31.538358', 'lng' => '-8.764639'),
    ],
    'draatafilalet' => [
      array('name' => 'Ouarzazate', 'slug' => 'ouarzazate', 'is_pinned' => '0', 'lat' => '30.933544', 'lng' => '-6.937016'),
      array('name' => 'Errachidia', 'slug' => 'errachidia', 'is_pinned' => '0', 'lat' => '31.927236', 'lng' => '-4.428498'),
      array('name' => 'Midelt', 'slug' => 'midelt', 'is_pinned' => '0', 'lat' => '32.679942', 'lng' => '-4.732927'),
      array('name' => 'Tinghir', 'slug' => 'tinghir', 'is_pinned' => '0', 'lat' => '31.520463', 'lng' => '-5.530234'),
      array('name' => 'Zagora', 'slug' => 'zagora', 'is_pinned' => '0', 'lat' => '30.345900', 'lng' => '-5.840659'),
      array('name' => 'Tinejdad', 'slug' => 'tinejdad', 'is_pinned' => '0', 'lat' => '31.512853', 'lng' => '-5.023447'),
      array('name' => 'Goulmima', 'slug' => 'goulmima', 'is_pinned' => '0', 'lat' => '31.689175', 'lng' => '-4.957495'),
    ],
    'sous-massa' => [
      array('name' => 'Agadir', 'slug' => 'agadir', 'is_pinned' => '1', 'lat' => '30.427755', 'lng' => '-9.598107'),
      array('name' => 'Inezgane', 'slug' => 'inezgane', 'is_pinned' => '0', 'lat' => '30.352311', 'lng' => '-9.551496'),
      array('name' => 'Ait Melloul', 'slug' => 'ait-melloul', 'is_pinned' => '0', 'lat' => '30.337928', 'lng' => '-9.504025'),
      array('name' => 'Taroudant', 'slug' => 'taroudant', 'is_pinned' => '0', 'lat' => '30.472713', 'lng' => '-8.874877'),
      array('name' => 'Tiznit', 'slug' => 'tiznit', 'is_pinned' => '0', 'lat' => '29.693392', 'lng' => '-9.732157'),
      array('name' => 'Biougra', 'slug' => 'biougra', 'is_pinned' => '0', 'lat' => '30.220658', 'lng' => '-9.372859'),
      array('name' => 'Dchira', 'slug' => 'dchira', 'is_pinned' => '0', 'lat' => '30.369373', 'lng' => '-9.528413'),
      array('name' => 'Tata', 'slug' => 'tata', 'is_pinned' => '0', 'lat' => '29.750877', 'lng' => '-7.975634'),
    ],
    'guelmim-oued-noun' => [
      array('name' => 'Guelmim', 'slug' => 'guelmim', 'is_pinned' => '0', 'lat' => '28.988366', 'lng' => '-10.052750'),
      array('name' => 'Tan-Tan', 'slug' => 'tan-tan', 'is_pinned' => '0', 'lat' => '28.438041', 'lng' => '-11.098737'),
      array('name' => 'Sidi Ifni', 'slug' => 'sidi-ifni', 'is_pinned' => '0', 'lat' => '29.370112', 'lng' => '-10.175929'),
      array('name' => 'Zag', 'slug' => 'zag', 'is_pinned' => '0', 'lat' => '28.025087', 'lng' => '-9.295192'),
    ],
    'laayounesaguia-al-hamra' => [
      array('name' => 'Laayoune', 'slug' => 'laayoune', 'is_pinned' => '0', 'lat' => '27.150038', 'lng' => '-13.199076'),
      array('name' => 'Es-Semara', 'slug' => 'es-semara', 'is_pinned' => '0', 'lat' => '26.741856', 'lng' => '-11.678367'),
      array('name' => 'Boujdour', 'slug' => 'boujdour', 'is_pinned' => '0', 'lat' => '26.125249', 'lng' => '-14.484735'),
      array('name' => 'Tarfaya', 'slug' => 'tarfaya', 'is_pinned' => '0', 'lat' => '27.937538', 'lng' => '-12.926285'),
    ],
    'ed-dakhlaoued-ed-dahab' => [
      array('name' => 'Dakhla', 'slug' => 'dakhla', 'is_pinned' => '0', 'lat' => '23.722111', 'lng' => '-15.934738'),
      array('name' => 'Aousserd', 'slug' => 'aousserd', 'is_pinned' => '0', 'lat' => '22.552154', 'lng' => '-14.329735'),
    ],

    // Luxembourg
    'LU-CA' => [
      array('lat' => '49.5881', 'lng' => '5.9896', 'postal_code' => 'L-4973', 'name' => 'Dippach'),
      array('lat' => '49.5849', 'lng' => '5.9658', 'postal_code' => 'L-4994', 'name' => 'Sprinkange'),
      array('lat' => '49.5859', 'lng' => '5.9553', 'postal_code' => 'L-4997', 'name' => 'Schouweiler'),
      array('lat' => '49.5762', 'lng' => '5.9869', 'postal_code' => 'L-4977', 'name' => 'Bettange-sur-Mess'),
      array('lat' => '49.6051', 'lng' => '5.9285', 'postal_code' => 'L-8369', 'name' => 'Hivange'),
      array('lat' => '49.5977', 'lng' => '5.9446', 'postal_code' => 'L-8351', 'name' => 'Dahlem'),
      array('lat' => '49.6326', 'lng' => '5.9166', 'postal_code' => 'L-8376', 'name' => 'Kahler'),
      array('lat' => '49.6179', 'lng' => '5.9536', 'postal_code' => 'L-8350', 'name' => 'Garnich'),
      array('lat' => '49.6952', 'lng' => '5.9166', 'postal_code' => 'L-8370', 'name' => 'Hobscheid'),
      array('lat' => '49.6828', 'lng' => '5.8793', 'postal_code' => 'L-8476', 'name' => 'Eischen'),
      array('lat' => '49.6890', 'lng' => '6.0311', 'postal_code' => 'L-7423', 'name' => 'Dondelange'),
      array('lat' => '49.6914', 'lng' => '6.0699', 'postal_code' => 'L-8294', 'name' => 'Keispelt'),
      array('lat' => '49.6903', 'lng' => '6.0577', 'postal_code' => 'L-8291', 'name' => 'Meispelt'),
      array('lat' => '49.6784', 'lng' => '6.0437', 'postal_code' => 'L-8295', 'name' => 'Kehlen'),
      array('lat' => '49.6733', 'lng' => '6.0135', 'postal_code' => 'L-8390', 'name' => 'Nospelt'),
      array('lat' => '49.6576', 'lng' => '6.0007', 'postal_code' => 'L-8394', 'name' => 'Olm'),
      array('lat' => '49.6479', 'lng' => '5.9584', 'postal_code' => 'L-8399', 'name' => 'Windhof (Koerich)'),
      array('lat' => '49.6588', 'lng' => '5.9811', 'postal_code' => 'L-8360', 'name' => 'Goetzingen'),
      array('lat' => '49.6698', 'lng' => '5.9664', 'postal_code' => 'L-8358', 'name' => 'Goeblange'),
      array('lat' => '49.6681', 'lng' => '5.9507', 'postal_code' => 'L-8385', 'name' => 'Koerich'),
      array('lat' => '49.6598', 'lng' => '6.0876', 'postal_code' => 'L-8154', 'name' => 'Bridel'),
      array('lat' => '49.6637', 'lng' => '6.0745', 'postal_code' => 'L-8191', 'name' => 'Kopstal'),
      array('lat' => '49.6307', 'lng' => '6.0347', 'postal_code' => 'L-8273', 'name' => 'Mamer'),
      array('lat' => '49.6357', 'lng' => '5.9703', 'postal_code' => 'L-8309', 'name' => 'Holzem'),
      array('lat' => '49.7100', 'lng' => '5.9875', 'postal_code' => 'L-8363', 'name' => 'Greisch'),
      array('lat' => '49.7051', 'lng' => '5.9821', 'postal_code' => 'L-8363', 'name' => 'Leesbach'),
      array('lat' => '49.6447', 'lng' => '5.9825', 'postal_code' => 'L-8348', 'name' => 'Capellen'),
      array('lat' => '49.6942', 'lng' => '5.9852', 'postal_code' => 'L-8363', 'name' => 'Simmerschmelz'),
      array('lat' => '49.6962', 'lng' => '5.9872', 'postal_code' => 'L-8363', 'name' => 'Simmerfarm'),
      array('lat' => '49.6930', 'lng' => '6.0006', 'postal_code' => 'L-8398', 'name' => 'RoodtEisch'),
      array('lat' => '49.6478', 'lng' => '5.9175', 'postal_code' => 'L-8381', 'name' => 'Kleinbettingen'),
      array('lat' => '49.6348', 'lng' => '5.8923', 'postal_code' => 'L-8389', 'name' => 'Grass'),
      array('lat' => '49.6626', 'lng' => '5.9215', 'postal_code' => 'L-8448', 'name' => 'Steinfort'),
      array('lat' => '49.5627', 'lng' => '5.8798', 'postal_code' => 'L-4798', 'name' => 'Linger'),
      array('lat' => '49.5618', 'lng' => '5.9309', 'postal_code' => 'L-4959', 'name' => 'Bascharage'),
      array('lat' => '49.5754', 'lng' => '5.9045', 'postal_code' => 'L-4969', 'name' => 'Hautcharage'),
      array('lat' => '49.5991', 'lng' => '5.8715', 'postal_code' => 'L-4965', 'name' => 'Clemency'),
      array('lat' => '49.6018', 'lng' => '5.9041', 'postal_code' => 'L-4979', 'name' => 'Fingig'),
    ],
    'LU-CL' => [
      array('lat' => '50.0466', 'lng' => '5.9306', 'postal_code' => 'L-9740', 'name' => 'Boevange'),
      array('lat' => '50.0355', 'lng' => '5.8743', 'postal_code' => 'L-9631', 'name' => 'Allerborn'),
      array('lat' => '50.0095', 'lng' => '5.8499', 'postal_code' => 'L-9684', 'name' => 'Schimpach'),
      array('lat' => '50.0204', 'lng' => '5.9099', 'postal_code' => 'L-9641', 'name' => 'Brachtenbach'),
      array('lat' => '50.0153', 'lng' => '5.8613', 'postal_code' => 'L-9673', 'name' => 'Oberwampach'),
      array('lat' => '50.0611', 'lng' => '5.9564', 'postal_code' => 'L-9745', 'name' => 'Doennange'),
      array('lat' => '50.0832', 'lng' => '5.9895', 'postal_code' => 'L-9741', 'name' => 'Boxhorn'),
      array('lat' => '50.0098', 'lng' => '5.8418', 'postal_code' => 'L-9672', 'name' => 'Niederwampach'),
      array('lat' => '50.0124', 'lng' => '5.8857', 'postal_code' => 'L-9645', 'name' => 'Derenbach'),
      array('lat' => '50.0567', 'lng' => '5.8968', 'postal_code' => 'L-9743', 'name' => 'Crendal'),
      array('lat' => '50.0456', 'lng' => '5.9002', 'postal_code' => 'L-9752', 'name' => 'Hamiville'),
      array('lat' => '50.0655', 'lng' => '5.9625', 'postal_code' => 'L-9744', 'name' => 'Deiffelt'),
      array('lat' => '50.0598', 'lng' => '5.9397', 'postal_code' => 'L-9762', 'name' => 'Lullange'),
      array('lat' => '50.0568', 'lng' => '5.8637', 'postal_code' => 'L-9754', 'name' => 'Hinterhassel'),
      array('lat' => '50.0636', 'lng' => '5.8826', 'postal_code' => 'L-9772', 'name' => 'Troine'),
      array('lat' => '50.0457', 'lng' => '5.8787', 'postal_code' => 'L-9773', 'name' => 'Troine-Route'),
      array('lat' => '50.0777', 'lng' => '5.9572', 'postal_code' => 'L-9771', 'name' => 'Stockem'),
      array('lat' => '50.0533', 'lng' => '5.9168', 'postal_code' => 'L-9780', 'name' => 'Wincrange'),
      array('lat' => '50.1065', 'lng' => '6.0068', 'postal_code' => 'L-9902', 'name' => 'Cinqfontaines'),
      array('lat' => '50.0793', 'lng' => '5.9738', 'postal_code' => 'L-9770', 'name' => 'Rumlange'),
      array('lat' => '50.0966', 'lng' => '5.9709', 'postal_code' => 'L-9940', 'name' => 'Asselborn'),
      array('lat' => '50.0991', 'lng' => '5.9954', 'postal_code' => 'L-9976', 'name' => 'Sassel'),
      array('lat' => '50.1074', 'lng' => '5.9225', 'postal_code' => 'L-9956', 'name' => 'Hachiville'),
      array('lat' => '50.0643', 'lng' => '5.9835', 'postal_code' => 'L-9779', 'name' => 'Lentzweiler'),
      array('lat' => '50.0939', 'lng' => '6.0256', 'postal_code' => 'L-9974', 'name' => 'Maulusmuhle'),
      array('lat' => '50.0990', 'lng' => '5.9208', 'postal_code' => 'L-9960', 'name' => 'Hoffelt'),
      array('lat' => '50.0829', 'lng' => '6.0590', 'postal_code' => 'L-9751', 'name' => 'Grindhausen'),
      array('lat' => '50.0539', 'lng' => '6.0317', 'postal_code' => 'L-9715', 'name' => 'Clervaux'),
      array('lat' => '50.0945', 'lng' => '6.0871', 'postal_code' => 'L-9753', 'name' => 'Heinerscheid'),
      array('lat' => '50.0168', 'lng' => '6.0045', 'postal_code' => 'L-9746', 'name' => 'Drauffelt'),
      array('lat' => '50.0953', 'lng' => '6.0579', 'postal_code' => 'L-9755', 'name' => 'Hupperdange'),
      array('lat' => '50.1019', 'lng' => '6.1116', 'postal_code' => 'L-9757', 'name' => 'Kalborn'),
      array('lat' => '50.0938', 'lng' => '6.1259', 'postal_code' => 'L-9758', 'name' => 'Tintesmuhle'),
      array('lat' => '50.0288', 'lng' => '5.9728', 'postal_code' => 'L-9759', 'name' => 'Kirelshof'),
      array('lat' => '50.0557', 'lng' => '6.0649', 'postal_code' => 'L-9764', 'name' => 'Marnach'),
      array('lat' => '50.0415', 'lng' => '6.0168', 'postal_code' => 'L-9765', 'name' => 'Mecher'),
      array('lat' => '50.0335', 'lng' => '6.0086', 'postal_code' => 'L-9765', 'name' => 'Wirtgensmuhle'),
      array('lat' => '50.0337', 'lng' => '6.0373', 'postal_code' => 'L-9766', 'name' => 'Munshausen'),
      array('lat' => '50.0749', 'lng' => '6.0456', 'postal_code' => 'L-9774', 'name' => 'Urspelt'),
      array('lat' => '50.0566', 'lng' => '6.0358', 'postal_code' => 'L-9768', 'name' => 'Reuler'),
      array('lat' => '50.0379', 'lng' => '5.9873', 'postal_code' => 'L-9775', 'name' => 'Weicherdange'),
      array('lat' => '50.0290', 'lng' => '6.0001', 'postal_code' => 'L-9765', 'name' => 'Kaaspelterhof'),
      array('lat' => '50.0644', 'lng' => '5.9889', 'postal_code' => 'L-9779', 'name' => 'Eselborn'),
      array('lat' => '50.1245', 'lng' => '6.1090', 'postal_code' => 'L-9972', 'name' => 'Lieler'),
      array('lat' => '50.0553', 'lng' => '6.0823', 'postal_code' => 'L-9769', 'name' => 'Roder'),
      array('lat' => '50.1134', 'lng' => '6.0904', 'postal_code' => 'L-9968', 'name' => 'Fossenhof'),
      array('lat' => '50.1179', 'lng' => '6.0830', 'postal_code' => 'L-9968', 'name' => 'Lausdorn'),
      array('lat' => '50.0101', 'lng' => '6.0255', 'postal_code' => 'L-9840', 'name' => 'Siebenaler'),
      array('lat' => '50.1331', 'lng' => '6.0145', 'postal_code' => 'L-9952', 'name' => 'Drinklange'),
      array('lat' => '50.1637', 'lng' => '6.0881', 'postal_code' => 'L-9944', 'name' => 'Beiler'),
      array('lat' => '50.1438', 'lng' => '5.9834', 'postal_code' => 'L-9942', 'name' => 'Basbellain'),
      array('lat' => '50.1646', 'lng' => '6.0147', 'postal_code' => 'L-9964', 'name' => 'Huldange'),
      array('lat' => '50.1182', 'lng' => '5.9819', 'postal_code' => 'L-9948', 'name' => 'Biwisch'),
      array('lat' => '50.1404', 'lng' => '6.0222', 'postal_code' => 'L-9980', 'name' => 'Wilwerdange'),
      array('lat' => '50.1559', 'lng' => '6.0790', 'postal_code' => 'L-9966', 'name' => 'Kaesfurt'),
      array('lat' => '50.1215', 'lng' => '6.0033', 'postal_code' => 'L-9912', 'name' => 'Troisvierges'),
      array('lat' => '50.1470', 'lng' => '6.0135', 'postal_code' => 'L-9954', 'name' => 'Goedange'),
      array('lat' => '50.1232', 'lng' => '6.0622', 'postal_code' => 'L-9950', 'name' => 'Breidfeld'),
      array('lat' => '50.1233', 'lng' => '6.0474', 'postal_code' => 'L-9962', 'name' => 'Holler'),
      array('lat' => '50.1550', 'lng' => '5.9768', 'postal_code' => 'L-9943', 'name' => 'Hautbellain'),
      array('lat' => '50.1069', 'lng' => '6.0427', 'postal_code' => 'L-9968', 'name' => 'Kleemuhle'),
      array('lat' => '50.1190', 'lng' => '6.0377', 'postal_code' => 'L-9946', 'name' => 'Binsfeld'),
      array('lat' => '50.1168', 'lng' => '6.0519', 'postal_code' => 'L-9968', 'name' => 'Hollermuhle'),
      array('lat' => '50.1106', 'lng' => '6.0460', 'postal_code' => 'L-9968', 'name' => 'Rossmuhle'),
      array('lat' => '50.1601', 'lng' => '6.1078', 'postal_code' => 'L-9970', 'name' => 'Leithum'),
      array('lat' => '49.9348', 'lng' => '6.0705', 'postal_code' => 'L-9183', 'name' => 'Unterschlinder'),
      array('lat' => '50.1542', 'lng' => '6.0526', 'postal_code' => 'L-9999', 'name' => 'Wemperhardt'),
      array('lat' => '50.1373', 'lng' => '6.0797', 'postal_code' => 'L-9993', 'name' => 'Weiswampach'),
      array('lat' => '49.9539', 'lng' => '6.0640', 'postal_code' => 'L-9183', 'name' => 'Oberschlinder'),
      array('lat' => '49.9471', 'lng' => '6.0815', 'postal_code' => 'L-9376', 'name' => 'Hoscheid'),
      array('lat' => '50.0117', 'lng' => '6.0516', 'postal_code' => 'L-9830', 'name' => 'Bockholtz'),
      array('lat' => '49.9727', 'lng' => '6.0529', 'postal_code' => 'L-9831', 'name' => 'Consthum'),
      array('lat' => '49.9856', 'lng' => '6.0743', 'postal_code' => 'L-9834', 'name' => 'Holzthum'),
      array('lat' => '49.9940', 'lng' => '6.0989', 'postal_code' => 'L-9836', 'name' => 'Hosingen'),
      array('lat' => '50.0369', 'lng' => '6.0730', 'postal_code' => 'L-9833', 'name' => 'Dorscheid'),
      array('lat' => '49.9724', 'lng' => '6.0904', 'postal_code' => 'L-9835', 'name' => 'Hoscheid-Dickt'),
      array('lat' => '50.0043', 'lng' => '6.1439', 'postal_code' => 'L-9838', 'name' => 'Eisenbach'),
      array('lat' => '50.0277', 'lng' => '6.0645', 'postal_code' => 'L-9837', 'name' => 'Neidhausen'),
      array('lat' => '50.0392', 'lng' => '6.1292', 'postal_code' => 'L-9839', 'name' => 'Rodershausen'),
      array('lat' => '49.9834', 'lng' => '6.1177', 'postal_code' => 'L-9841', 'name' => 'Wahlhausen'),
      array('lat' => '49.9182', 'lng' => '6.0352', 'postal_code' => 'L-9153', 'name' => 'Dirbach'),
      array('lat' => '49.8672', 'lng' => '6.1833', 'postal_code' => 'L-9371', 'name' => 'Gilsdorf'),
      array('lat' => '49.8688', 'lng' => '6.2405', 'postal_code' => 'L-9381', 'name' => 'Moestroff'),
      array('lat' => '49.9101', 'lng' => '6.0861', 'postal_code' => 'L-9164', 'name' => 'Bourscheid-Moulin'),
      array('lat' => '49.9210', 'lng' => '6.0549', 'postal_code' => 'L-9153', 'name' => 'Goebelsmuhle'),
      array('lat' => '49.8868', 'lng' => '6.0647', 'postal_code' => 'L-9191', 'name' => 'Welscheid'),
      array('lat' => '49.8997', 'lng' => '6.0367', 'postal_code' => 'L-9163', 'name' => 'Kehmen'),
      array('lat' => '49.9090', 'lng' => '6.0792', 'postal_code' => 'L-9164', 'name' => 'Bourscheid-Plage'),
      array('lat' => '49.8930', 'lng' => '6.0424', 'postal_code' => 'L-9182', 'name' => 'Scheidel'),
      array('lat' => '49.8950', 'lng' => '6.0965', 'postal_code' => 'L-9172', 'name' => 'Michelau'),
      array('lat' => '49.9503', 'lng' => '6.0558', 'postal_code' => 'L-9183', 'name' => 'Friedbusch'),
      array('lat' => '49.9321', 'lng' => '6.0609', 'postal_code' => 'L-9183', 'name' => 'Schlindermanderscheid'),
      array('lat' => '49.9260', 'lng' => '6.0899', 'postal_code' => 'L-9378', 'name' => 'Lipperscheid'),
      array('lat' => '49.9120', 'lng' => '6.1141', 'postal_code' => 'L-9378', 'name' => 'Enteschbach'),
      array('lat' => '49.9101', 'lng' => '6.1077', 'postal_code' => 'L-9378', 'name' => 'Flebour'),
      array('lat' => '49.9017', 'lng' => '6.1225', 'postal_code' => 'L-9378', 'name' => 'Closdelt'),
      array('lat' => '49.8696', 'lng' => '6.1606', 'postal_code' => 'L-9292', 'name' => 'Diekirch'),
      array('lat' => '49.8922', 'lng' => '6.0941', 'postal_code' => 'L-9172', 'name' => 'Burden'),
      array('lat' => '49.8513', 'lng' => '6.1324', 'postal_code' => 'L-9161', 'name' => 'Ingeldorf'),
      array('lat' => '49.8735', 'lng' => '6.1276', 'postal_code' => 'L-9378', 'name' => 'Erpeldange-sur-Sûre'),
      array('lat' => '49.8573', 'lng' => '6.0882', 'postal_code' => 'L-9090', 'name' => 'Warken'),
      array('lat' => '49.8460', 'lng' => '6.0997', 'postal_code' => 'L-9087', 'name' => 'Ettelbruck'),
      array('lat' => '49.8517', 'lng' => '6.0500', 'postal_code' => 'L-9177', 'name' => 'Niederfeulen'),
      array('lat' => '49.8153', 'lng' => '6.1015', 'postal_code' => 'L-7738', 'name' => 'Colmar-Pont'),
      array('lat' => '49.8721', 'lng' => '6.2873', 'postal_code' => 'L-9392', 'name' => 'Wallendorf-Pont'),
      array('lat' => '49.8600', 'lng' => '6.2872', 'postal_code' => 'L-6340', 'name' => 'Bigelbach'),
      array('lat' => '49.8468', 'lng' => '6.0322', 'postal_code' => 'L-9180', 'name' => 'Oberfeulen'),
      array('lat' => '49.8829', 'lng' => '6.2565', 'postal_code' => 'L-9456', 'name' => 'Hoesdorf'),
      array('lat' => '49.8253', 'lng' => '6.0913', 'postal_code' => 'L-7758', 'name' => 'Birtrange'),
      array('lat' => '49.8321', 'lng' => '6.0015', 'postal_code' => 'L-9168', 'name' => 'Mertzig'),
      array('lat' => '49.8672', 'lng' => '6.2648', 'postal_code' => 'L-9391', 'name' => 'Reisdorf'),
      array('lat' => '49.8365', 'lng' => '6.0980', 'postal_code' => 'L-9134', 'name' => 'Schieren'),
      array('lat' => '49.8117', 'lng' => '6.2531', 'postal_code' => 'L-6380', 'name' => 'Savelborn'),
      array('lat' => '49.8491', 'lng' => '6.2320', 'postal_code' => 'L-9364', 'name' => 'Keiwelbach'),
      array('lat' => '49.8283', 'lng' => '6.1725', 'postal_code' => 'L-9186', 'name' => 'Stegen'),
      array('lat' => '49.8300', 'lng' => '6.2208', 'postal_code' => 'L-9366', 'name' => 'Ermsdorf'),
      array('lat' => '49.8105', 'lng' => '6.2177', 'postal_code' => 'L-7660', 'name' => 'Medernach'),
      array('lat' => '49.8448', 'lng' => '6.2479', 'postal_code' => 'L-9365', 'name' => 'Eppeldorf'),
      array('lat' => '49.8421', 'lng' => '6.2031', 'postal_code' => 'L-9368', 'name' => 'Folkendange'),
      array('lat' => '49.7555', 'lng' => '6.3280', 'postal_code' => 'L-6225', 'name' => 'Hersberg'),
      array('lat' => '49.8337', 'lng' => '6.3272', 'postal_code' => 'L-6360', 'name' => 'Grundhof'),
      array('lat' => '49.7408', 'lng' => '6.3349', 'postal_code' => 'L-6243', 'name' => 'Hemstal'),
      array('lat' => '49.8014', 'lng' => '6.3541', 'postal_code' => 'L-6214', 'name' => 'Kalkesbach (Berdorf)'),
      array('lat' => '49.7560', 'lng' => '6.3055', 'postal_code' => 'L-6225', 'name' => 'Kobenbour'),
      array('lat' => '49.7448', 'lng' => '6.2659', 'postal_code' => 'L-7639', 'name' => 'Blumenthal'),
      array('lat' => '49.7523', 'lng' => '6.3598', 'postal_code' => 'L-6230', 'name' => 'Bech'),
      array('lat' => '49.7662', 'lng' => '6.3865', 'postal_code' => 'L-6251', 'name' => 'Geyershof'),
      array('lat' => '49.7408', 'lng' => '6.3167', 'postal_code' => 'L-6246', 'name' => 'Rippig'),
      array('lat' => '49.7500', 'lng' => '6.3255', 'postal_code' => 'L-6225', 'name' => 'Altrier'),
      array('lat' => '49.8499', 'lng' => '6.3185', 'postal_code' => 'L-6350', 'name' => 'Dillingen'),
      array('lat' => '49.8305', 'lng' => '6.3305', 'postal_code' => 'L-6360', 'name' => 'Grundhof (Berdorf)'),
      array('lat' => '49.7447', 'lng' => '6.3444', 'postal_code' => 'L-6255', 'name' => 'Zittig'),
      array('lat' => '49.7777', 'lng' => '6.3059', 'postal_code' => 'L-6238', 'name' => 'Breidweiler'),
      array('lat' => '49.8372', 'lng' => '6.3783', 'postal_code' => 'L-6590', 'name' => 'Weilerbach'),
      array('lat' => '49.8132', 'lng' => '6.3803', 'postal_code' => 'L-6562', 'name' => 'Berdorf'),
      array('lat' => '49.8004', 'lng' => '6.3533', 'postal_code' => 'L-6214', 'name' => 'Kalkesbach (Consdorf)'),
      array('lat' => '49.7686', 'lng' => '6.3027', 'postal_code' => 'L-6239', 'name' => 'Colbette'),
      array('lat' => '49.8489', 'lng' => '6.3566', 'postal_code' => 'L-6555', 'name' => 'Bollendorf-Pont'),
      array('lat' => '49.7633', 'lng' => '6.2844', 'postal_code' => 'L-6239', 'name' => 'Marscherwald'),
      array('lat' => '49.7870', 'lng' => '6.3567', 'postal_code' => 'L-6250', 'name' => 'Consdorf'),
      array('lat' => '49.7637', 'lng' => '6.3521', 'postal_code' => 'L-6252', 'name' => 'Wolper'),
      array('lat' => '49.7784', 'lng' => '6.3635', 'postal_code' => 'L-6251', 'name' => 'Scheidgen'),
      array('lat' => '49.7482', 'lng' => '6.4797', 'postal_code' => 'L-6666', 'name' => 'Givenich'),
      array('lat' => '49.7735', 'lng' => '6.5001', 'postal_code' => 'L-6559', 'name' => 'Girst'),
      array('lat' => '49.7472', 'lng' => '6.4272', 'postal_code' => 'L-6665', 'name' => 'Herborn'),
      array('lat' => '49.7647', 'lng' => '6.4780', 'postal_code' => 'L-6663', 'name' => 'Boursdorf'),
      array('lat' => '49.7589', 'lng' => '6.5109', 'postal_code' => 'L-6660', 'name' => 'Born'),
      array('lat' => '49.7542', 'lng' => '6.3956', 'postal_code' => 'L-6231', 'name' => 'Lilien'),
      array('lat' => '49.7844', 'lng' => '6.4706', 'postal_code' => 'L-6557', 'name' => 'Dickweiler'),
      array('lat' => '49.7836', 'lng' => '6.5139', 'postal_code' => 'L-6560', 'name' => 'Hinkel'),
      array('lat' => '49.7911', 'lng' => '6.4245', 'postal_code' => 'L-6572', 'name' => 'Echternach'),
      array('lat' => '49.7850', 'lng' => '6.4984', 'postal_code' => 'L-6558', 'name' => 'Girsterklaus'),
      array('lat' => '49.7518', 'lng' => '6.4638', 'postal_code' => 'L-6695', 'name' => 'Mompach'),
      array('lat' => '49.7425', 'lng' => '6.5003', 'postal_code' => 'L-6692', 'name' => 'Moersdorf'),
      array('lat' => '49.7855', 'lng' => '6.4384', 'postal_code' => 'L-6572', 'name' => 'Osweiler'),
      array('lat' => '49.8098', 'lng' => '6.2542', 'postal_code' => 'L-6380', 'name' => 'Savelborn (Waldbillig)'),
      array('lat' => '49.7904', 'lng' => '6.3071', 'postal_code' => 'L-6245', 'name' => 'Mullerthal'),
      array('lat' => '49.8192', 'lng' => '6.2806', 'postal_code' => 'L-6370', 'name' => 'Haller'),
      array('lat' => '49.8072', 'lng' => '6.5023', 'postal_code' => 'L-6579', 'name' => 'Rosport'),
      array('lat' => '49.8171', 'lng' => '6.4772', 'postal_code' => 'L-6587', 'name' => 'Steinheim'),
      array('lat' => '49.7972', 'lng' => '6.2825', 'postal_code' => 'L-7680', 'name' => 'Waldbillig'),
      array('lat' => '49.7995', 'lng' => '6.2596', 'postal_code' => 'L-7649', 'name' => 'Freckeisen'),
      array('lat' => '49.7894', 'lng' => '6.2732', 'postal_code' => 'L-7641', 'name' => 'Christnach'),
      array('lat' => '49.5183', 'lng' => '6.0626', 'postal_code' => 'L-3340', 'name' => 'Huncherange'),
      array('lat' => '49.5198', 'lng' => '6.0789', 'postal_code' => 'L-3332', 'name' => 'Fennange'),
      array('lat' => '49.5335', 'lng' => '6.0784', 'postal_code' => 'L-3311', 'name' => 'Abweiler'),
      array('lat' => '49.5154', 'lng' => '6.1143', 'postal_code' => 'L-3287', 'name' => 'Bettembourg'),
      array('lat' => '49.5075', 'lng' => '6.0581', 'postal_code' => 'L-3386', 'name' => 'Noertzange'),
      array('lat' => '49.5268', 'lng' => '5.8898', 'postal_code' => 'L-4686', 'name' => 'Niederkorn'),
      array('lat' => '49.5238', 'lng' => '5.8364', 'postal_code' => 'L-4698', 'name' => 'Lasauvage'),
      array('lat' => '49.5088', 'lng' => '5.8923', 'postal_code' => 'L-4685', 'name' => 'Oberkorn'),
      array('lat' => '49.5189', 'lng' => '5.9056', 'postal_code' => 'L-4687', 'name' => 'Differdange'),
      array('lat' => '49.4835', 'lng' => '6.0749', 'postal_code' => 'L-3591', 'name' => 'Dudelange'),
      array('lat' => '49.5023', 'lng' => '5.9437', 'postal_code' => 'L-4374', 'name' => 'Esch-sur-Alzette'),
      array('lat' => '49.5117', 'lng' => '6.1532', 'postal_code' => 'L-3336', 'name' => 'Hellange'),
      array('lat' => '49.5137', 'lng' => '6.1856', 'postal_code' => 'L-5753', 'name' => 'Frisange'),
      array('lat' => '49.5241', 'lng' => '6.2278', 'postal_code' => 'L-5719', 'name' => 'Aspelt'),
      array('lat' => '49.4803', 'lng' => '6.0376', 'postal_code' => 'L-3781', 'name' => 'Kayl'),
      array('lat' => '49.4722', 'lng' => '6.0449', 'postal_code' => 'L-3790', 'name' => 'Tétange'),
      array('lat' => '49.5814', 'lng' => '6.0593', 'postal_code' => 'L-3375', 'name' => 'Leudelange'),
      array('lat' => '49.5205', 'lng' => '6.0456', 'postal_code' => 'L-3318', 'name' => 'Bergem'),
      array('lat' => '49.5302', 'lng' => '6.0128', 'postal_code' => 'L-3899', 'name' => 'Foetz'),
      array('lat' => '49.5208', 'lng' => '5.9857', 'postal_code' => 'L-3944', 'name' => 'Mondercange'),
      array('lat' => '49.5462', 'lng' => '5.8459', 'postal_code' => 'L-4853', 'name' => 'Rodange'),
      array('lat' => '49.5539', 'lng' => '5.8861', 'postal_code' => 'L-4908', 'name' => 'Pétange'),
      array('lat' => '49.5736', 'lng' => '6.0340', 'postal_code' => 'L-3392', 'name' => 'Roedgen'),
      array('lat' => '49.5462', 'lng' => '6.0171', 'postal_code' => 'L-3960', 'name' => 'Ehlange'),
      array('lat' => '49.5408', 'lng' => '6.0214', 'postal_code' => 'L-3980', 'name' => 'Wickrange'),
      array('lat' => '49.5456', 'lng' => '5.8577', 'postal_code' => 'L-4895', 'name' => 'Lamadelaine'),
      array('lat' => '49.5489', 'lng' => '6.0013', 'postal_code' => 'L-3985', 'name' => 'Pissange'),
      array('lat' => '49.5635', 'lng' => '6.0119', 'postal_code' => 'L-4982', 'name' => 'Reckange-sur-Mess'),
      array('lat' => '49.5583', 'lng' => '5.9791', 'postal_code' => 'L-4499', 'name' => 'Limpach'),
      array('lat' => '49.5599', 'lng' => '6.1116', 'postal_code' => 'L-1898', 'name' => 'Kockelscheuer'),
      array('lat' => '49.5427', 'lng' => '6.1356', 'postal_code' => 'L-3322', 'name' => 'Bivange'),
      array('lat' => '49.5313', 'lng' => '6.1048', 'postal_code' => 'L-3381', 'name' => 'Livange'),
      array('lat' => '49.5258', 'lng' => '6.1319', 'postal_code' => 'L-3390', 'name' => 'Peppange'),
      array('lat' => '49.5359', 'lng' => '6.1515', 'postal_code' => 'L-3329', 'name' => 'Crauthem'),
      array('lat' => '49.5466', 'lng' => '6.1507', 'postal_code' => 'L-3397', 'name' => 'Roeser'),
      array('lat' => '49.4604', 'lng' => '6.0282', 'postal_code' => 'L-3755', 'name' => 'Rumelange'),
      array('lat' => '49.5181', 'lng' => '5.9700', 'postal_code' => 'L-4384', 'name' => 'Ehlerange'),
      array('lat' => '49.5047', 'lng' => '5.9311', 'postal_code' => 'L-4490', 'name' => 'Belvaux'),
      array('lat' => '49.5194', 'lng' => '5.9288', 'postal_code' => 'L-4492', 'name' => 'Soleuvre'),
      array('lat' => '49.5507', 'lng' => '5.9341', 'postal_code' => 'L-4993', 'name' => 'Sanem'),
      array('lat' => '49.5054', 'lng' => '6.0205', 'postal_code' => 'L-3883', 'name' => 'Schifflange'),
    ],
    'LU-DI' => [
      array('lat' => '49.9182', 'lng' => '6.0352', 'postal_code' => 'L-9153', 'name' => 'Dirbach'),
      array('lat' => '49.8672', 'lng' => '6.1833', 'postal_code' => 'L-9371', 'name' => 'Gilsdorf'),
      array('lat' => '49.8688', 'lng' => '6.2405', 'postal_code' => 'L-9381', 'name' => 'Moestroff'),
      array('lat' => '49.9101', 'lng' => '6.0861', 'postal_code' => 'L-9164', 'name' => 'Bourscheid-Moulin'),
      array('lat' => '49.9210', 'lng' => '6.0549', 'postal_code' => 'L-9153', 'name' => 'Goebelsmühle'),
      array('lat' => '49.8868', 'lng' => '6.0647', 'postal_code' => 'L-9191', 'name' => 'Welscheid'),
      array('lat' => '49.8997', 'lng' => '6.0367', 'postal_code' => 'L-9163', 'name' => 'Kehmen'),
      array('lat' => '49.9090', 'lng' => '6.0792', 'postal_code' => 'L-9164', 'name' => 'Bourscheid-Plage'),
      array('lat' => '49.8930', 'lng' => '6.0424', 'postal_code' => 'L-9182', 'name' => 'Scheidel'),
      array('lat' => '49.8950', 'lng' => '6.0965', 'postal_code' => 'L-9172', 'name' => 'Michelau'),
      array('lat' => '49.9503', 'lng' => '6.0558', 'postal_code' => 'L-9183', 'name' => 'Friedbusch'),
      array('lat' => '49.9321', 'lng' => '6.0609', 'postal_code' => 'L-9183', 'name' => 'Schlindermanderscheid'),
      array('lat' => '49.9260', 'lng' => '6.0899', 'postal_code' => 'L-9378', 'name' => 'Lipperscheid'),
      array('lat' => '49.9120', 'lng' => '6.1141', 'postal_code' => 'L-9378', 'name' => 'Enteschbach'),
      array('lat' => '49.9101', 'lng' => '6.1077', 'postal_code' => 'L-9378', 'name' => 'Flebour'),
      array('lat' => '49.9017', 'lng' => '6.1225', 'postal_code' => 'L-9378', 'name' => 'Closdelt'),
      array('lat' => '49.8696', 'lng' => '6.1606', 'postal_code' => 'L-9292', 'name' => 'Diekirch'),
      array('lat' => '49.8922', 'lng' => '6.0941', 'postal_code' => 'L-9172', 'name' => 'Burden'),
      array('lat' => '49.8513', 'lng' => '6.1324', 'postal_code' => 'L-9161', 'name' => 'Ingeldorf'),
      array('lat' => '49.8735', 'lng' => '6.1276', 'postal_code' => 'L-9378', 'name' => 'Erpeldange-sur-Sûre'),
      array('lat' => '49.8573', 'lng' => '6.0882', 'postal_code' => 'L-9090', 'name' => 'Warken'),
      array('lat' => '49.8460', 'lng' => '6.0997', 'postal_code' => 'L-9087', 'name' => 'Ettelbruck'),
      array('lat' => '49.8517', 'lng' => '6.0500', 'postal_code' => 'L-9177', 'name' => 'Niederfeulen'),
      array('lat' => '49.8153', 'lng' => '6.1015', 'postal_code' => 'L-7738', 'name' => 'Colmar-Pont'),
      array('lat' => '49.8721', 'lng' => '6.2873', 'postal_code' => 'L-9392', 'name' => 'Wallendorf-Pont'),
      array('lat' => '49.8600', 'lng' => '6.2872', 'postal_code' => 'L-6340', 'name' => 'Bigelbach'),
      array('lat' => '49.8468', 'lng' => '6.0322', 'postal_code' => 'L-9180', 'name' => 'Oberfeulen'),
      array('lat' => '49.8829', 'lng' => '6.2565', 'postal_code' => 'L-9456', 'name' => 'Hoesdorf'),
      array('lat' => '49.8253', 'lng' => '6.0913', 'postal_code' => 'L-7758', 'name' => 'Birtrange'),
      array('lat' => '49.8321', 'lng' => '6.0015', 'postal_code' => 'L-9168', 'name' => 'Mertzig'),
      array('lat' => '49.8672', 'lng' => '6.2648', 'postal_code' => 'L-9391', 'name' => 'Reisdorf'),
      array('lat' => '49.8365', 'lng' => '6.0980', 'postal_code' => 'L-9134', 'name' => 'Schieren'),
      array('lat' => '49.8117', 'lng' => '6.2531', 'postal_code' => 'L-6380', 'name' => 'Savelborn'),
      array('lat' => '49.8491', 'lng' => '6.2320', 'postal_code' => 'L-9364', 'name' => 'Keiwelbach'),
      array('lat' => '49.8283', 'lng' => '6.1725', 'postal_code' => 'L-9186', 'name' => 'Stegen'),
      array('lat' => '49.8300', 'lng' => '6.2208', 'postal_code' => 'L-9366', 'name' => 'Ermsdorf'),
      array('lat' => '49.8105', 'lng' => '6.2177', 'postal_code' => 'L-7660', 'name' => 'Medernach'),
      array('lat' => '49.8448', 'lng' => '6.2479', 'postal_code' => 'L-9365', 'name' => 'Eppeldorf'),
      array('lat' => '49.8421', 'lng' => '6.2031', 'postal_code' => 'L-9368', 'name' => 'Folkendange'),
    ],
    'LU-EC' => [
      array('lat' => '49.7555', 'lng' => '6.3280', 'postal_code' => 'L-6225', 'name' => 'Hersberg'),
      array('lat' => '49.8337', 'lng' => '6.3272', 'postal_code' => 'L-6360', 'name' => 'Grundhof'),
      array('lat' => '49.7408', 'lng' => '6.3349', 'postal_code' => 'L-6243', 'name' => 'Hemstal'),
      array('lat' => '49.8014', 'lng' => '6.3541', 'postal_code' => 'L-6214', 'name' => 'Kalkesbach (Berdorf)'),
      array('lat' => '49.7560', 'lng' => '6.3055', 'postal_code' => 'L-6225', 'name' => 'Kobenbour'),
      array('lat' => '49.7448', 'lng' => '6.2659', 'postal_code' => 'L-7639', 'name' => 'Blumenthal'),
      array('lat' => '49.7523', 'lng' => '6.3598', 'postal_code' => 'L-6230', 'name' => 'Bech'),
      array('lat' => '49.7662', 'lng' => '6.3865', 'postal_code' => 'L-6251', 'name' => 'Geyershof'),
      array('lat' => '49.7408', 'lng' => '6.3167', 'postal_code' => 'L-6246', 'name' => 'Rippig'),
      array('lat' => '49.7500', 'lng' => '6.3255', 'postal_code' => 'L-6225', 'name' => 'Altrier'),
      array('lat' => '49.8499', 'lng' => '6.3185', 'postal_code' => 'L-6350', 'name' => 'Dillingen'),
      array('lat' => '49.8305', 'lng' => '6.3305', 'postal_code' => 'L-6360', 'name' => 'Grundhof (Berdorf)'),
      array('lat' => '49.7447', 'lng' => '6.3444', 'postal_code' => 'L-6255', 'name' => 'Zittig'),
      array('lat' => '49.7777', 'lng' => '6.3059', 'postal_code' => 'L-6238', 'name' => 'Breidweiler'),
      array('lat' => '49.8372', 'lng' => '6.3783', 'postal_code' => 'L-6590', 'name' => 'Weilerbach'),
      array('lat' => '49.8132', 'lng' => '6.3803', 'postal_code' => 'L-6562', 'name' => 'Berdorf'),
      array('lat' => '49.8004', 'lng' => '6.3533', 'postal_code' => 'L-6214', 'name' => 'Kalkesbach (Consdorf)'),
      array('lat' => '49.7686', 'lng' => '6.3027', 'postal_code' => 'L-6239', 'name' => 'Colbette'),
      array('lat' => '49.8489', 'lng' => '6.3566', 'postal_code' => 'L-6555', 'name' => 'Bollendorf-Pont'),
      array('lat' => '49.7633', 'lng' => '6.2844', 'postal_code' => 'L-6239', 'name' => 'Marscherwald'),
      array('lat' => '49.7870', 'lng' => '6.3567', 'postal_code' => 'L-6250', 'name' => 'Consdorf'),
      array('lat' => '49.7637', 'lng' => '6.3521', 'postal_code' => 'L-6252', 'name' => 'Wolper'),
      array('lat' => '49.7784', 'lng' => '6.3635', 'postal_code' => 'L-6251', 'name' => 'Scheidgen'),
      array('lat' => '49.7482', 'lng' => '6.4797', 'postal_code' => 'L-6666', 'name' => 'Givenich'),
      array('lat' => '49.7735', 'lng' => '6.5001', 'postal_code' => 'L-6559', 'name' => 'Girst'),
      array('lat' => '49.7472', 'lng' => '6.4272', 'postal_code' => 'L-6665', 'name' => 'Herborn'),
      array('lat' => '49.7647', 'lng' => '6.4780', 'postal_code' => 'L-6663', 'name' => 'Boursdorf'),
      array('lat' => '49.7589', 'lng' => '6.5109', 'postal_code' => 'L-6660', 'name' => 'Born'),
      array('lat' => '49.7542', 'lng' => '6.3956', 'postal_code' => 'L-6231', 'name' => 'Lilien'),
      array('lat' => '49.7844', 'lng' => '6.4706', 'postal_code' => 'L-6557', 'name' => 'Dickweiler'),
      array('lat' => '49.7836', 'lng' => '6.5139', 'postal_code' => 'L-6560', 'name' => 'Hinkel'),
      array('lat' => '49.7911', 'lng' => '6.4245', 'postal_code' => 'L-6572', 'name' => 'Echternach'),
      array('lat' => '49.7850', 'lng' => '6.4984', 'postal_code' => 'L-6558', 'name' => 'Girsterklaus'),
      array('lat' => '49.7518', 'lng' => '6.4638', 'postal_code' => 'L-6695', 'name' => 'Mompach'),
      array('lat' => '49.7425', 'lng' => '6.5003', 'postal_code' => 'L-6692', 'name' => 'Moersdorf'),
      array('lat' => '49.7855', 'lng' => '6.4384', 'postal_code' => 'L-6572', 'name' => 'Osweiler'),
      array('lat' => '49.8098', 'lng' => '6.2542', 'postal_code' => 'L-6380', 'name' => 'Savelborn (Waldbillig)'),
      array('lat' => '49.7904', 'lng' => '6.3071', 'postal_code' => 'L-6245', 'name' => 'Mullerthal'),
      array('lat' => '49.8192', 'lng' => '6.2806', 'postal_code' => 'L-6370', 'name' => 'Haller'),
      array('lat' => '49.8072', 'lng' => '6.5023', 'postal_code' => 'L-6579', 'name' => 'Rosport'),
      array('lat' => '49.8171', 'lng' => '6.4772', 'postal_code' => 'L-6587', 'name' => 'Steinheim'),
      array('lat' => '49.7972', 'lng' => '6.2825', 'postal_code' => 'L-7680', 'name' => 'Waldbillig'),
      array('lat' => '49.7995', 'lng' => '6.2596', 'postal_code' => 'L-7649', 'name' => 'Freckeisen'),
      array('lat' => '49.7894', 'lng' => '6.2732', 'postal_code' => 'L-7641', 'name' => 'Christnach')
    ],
    'LU-ES' => [
      array('lat' => '49.5183', 'lng' => '6.0626', 'postal_code' => 'L-3340', 'name' => 'Huncherange'),
      array('lat' => '49.5198', 'lng' => '6.0789', 'postal_code' => 'L-3332', 'name' => 'Fennange'),
      array('lat' => '49.5335', 'lng' => '6.0784', 'postal_code' => 'L-3311', 'name' => 'Abweiler'),
      array('lat' => '49.5154', 'lng' => '6.1143', 'postal_code' => 'L-3287', 'name' => 'Bettembourg'),
      array('lat' => '49.5075', 'lng' => '6.0581', 'postal_code' => 'L-3386', 'name' => 'Noertzange'),
      array('lat' => '49.5268', 'lng' => '5.8898', 'postal_code' => 'L-4686', 'name' => 'Niederkorn'),
      array('lat' => '49.5238', 'lng' => '5.8364', 'postal_code' => 'L-4698', 'name' => 'Lasauvage'),
      array('lat' => '49.5088', 'lng' => '5.8923', 'postal_code' => 'L-4685', 'name' => 'Oberkorn'),
      array('lat' => '49.5189', 'lng' => '5.9056', 'postal_code' => 'L-4687', 'name' => 'Differdange'),
      array('lat' => '49.4835', 'lng' => '6.0749', 'postal_code' => 'L-3591', 'name' => 'Dudelange'),
      array('lat' => '49.5023', 'lng' => '5.9437', 'postal_code' => 'L-4374', 'name' => 'Esch-sur-Alzette'),
      array('lat' => '49.5117', 'lng' => '6.1532', 'postal_code' => 'L-3336', 'name' => 'Hellange'),
      array('lat' => '49.5137', 'lng' => '6.1856', 'postal_code' => 'L-5753', 'name' => 'Frisange'),
      array('lat' => '49.5241', 'lng' => '6.2278', 'postal_code' => 'L-5719', 'name' => 'Aspelt'),
      array('lat' => '49.4803', 'lng' => '6.0376', 'postal_code' => 'L-3781', 'name' => 'Kayl'),
      array('lat' => '49.4722', 'lng' => '6.0449', 'postal_code' => 'L-3790', 'name' => 'Tétange'),
      array('lat' => '49.5814', 'lng' => '6.0593', 'postal_code' => 'L-3375', 'name' => 'Leudelange'),
      array('lat' => '49.5205', 'lng' => '6.0456', 'postal_code' => 'L-3318', 'name' => 'Bergem'),
      array('lat' => '49.5302', 'lng' => '6.0128', 'postal_code' => 'L-3899', 'name' => 'Foetz'),
      array('lat' => '49.5208', 'lng' => '5.9857', 'postal_code' => 'L-3944', 'name' => 'Mondercange'),
      array('lat' => '49.5462', 'lng' => '5.8459', 'postal_code' => 'L-4853', 'name' => 'Rodange'),
      array('lat' => '49.5539', 'lng' => '5.8861', 'postal_code' => 'L-4908', 'name' => 'Pétange'),
      array('lat' => '49.5736', 'lng' => '6.0340', 'postal_code' => 'L-3392', 'name' => 'Roedgen'),
      array('lat' => '49.5462', 'lng' => '6.0171', 'postal_code' => 'L-3960', 'name' => 'Ehlange'),
      array('lat' => '49.5408', 'lng' => '6.0214', 'postal_code' => 'L-3980', 'name' => 'Wickrange'),
      array('lat' => '49.5456', 'lng' => '5.8577', 'postal_code' => 'L-4895', 'name' => 'Lamadelaine'),
      array('lat' => '49.5489', 'lng' => '6.0013', 'postal_code' => 'L-3985', 'name' => 'Pissange'),
      array('lat' => '49.5635', 'lng' => '6.0119', 'postal_code' => 'L-4982', 'name' => 'Reckange-sur-Mess'),
      array('lat' => '49.5583', 'lng' => '5.9791', 'postal_code' => 'L-4499', 'name' => 'Limpach'),
      array('lat' => '49.5599', 'lng' => '6.1116', 'postal_code' => 'L-1898', 'name' => 'Kockelscheuer'),
      array('lat' => '49.5427', 'lng' => '6.1356', 'postal_code' => 'L-3322', 'name' => 'Bivange'),
      array('lat' => '49.5313', 'lng' => '6.1048', 'postal_code' => 'L-3381', 'name' => 'Livange'),
      array('lat' => '49.5258', 'lng' => '6.1319', 'postal_code' => 'L-3390', 'name' => 'Peppange'),
      array('lat' => '49.5359', 'lng' => '6.1515', 'postal_code' => 'L-3329', 'name' => 'Crauthem'),
      array('lat' => '49.5466', 'lng' => '6.1507', 'postal_code' => 'L-3397', 'name' => 'Roeser'),
      array('lat' => '49.4604', 'lng' => '6.0282', 'postal_code' => 'L-3755', 'name' => 'Rumelange'),
      array('lat' => '49.5181', 'lng' => '5.9700', 'postal_code' => 'L-4384', 'name' => 'Ehlerange'),
      array('lat' => '49.5047', 'lng' => '5.9311', 'postal_code' => 'L-4490', 'name' => 'Belvaux'),
      array('lat' => '49.5194', 'lng' => '5.9288', 'postal_code' => 'L-4492', 'name' => 'Soleuvre'),
      array('lat' => '49.5507', 'lng' => '5.9341', 'postal_code' => 'L-4993', 'name' => 'Sanem'),
      array('lat' => '49.5054', 'lng' => '6.0205', 'postal_code' => 'L-3883', 'name' => 'Schifflange')
    ],
    'LU-GR' => [
      array('lat' => '49.6881', 'lng' => '6.3484', 'postal_code' => 'L-6832', 'name' => 'Betzdorf'),
      array('lat' => '49.6710', 'lng' => '6.3008', 'postal_code' => 'L-6917', 'name' => 'Roodt-sur-Syre'),
      array('lat' => '49.6924', 'lng' => '6.3634', 'postal_code' => 'L-6838', 'name' => 'Hagelsdorf'),
      array('lat' => '49.7122', 'lng' => '6.3386', 'postal_code' => 'L-6836', 'name' => 'Breinert'),
      array('lat' => '49.6806', 'lng' => '6.3108', 'postal_code' => 'L-6950', 'name' => 'Olingen'),
      array('lat' => '49.7030', 'lng' => '6.3747', 'postal_code' => 'L-6833', 'name' => 'Biwer'),
      array('lat' => '49.7225', 'lng' => '6.3534', 'postal_code' => 'L-6835', 'name' => 'Boudler'),
      array('lat' => '49.7286', 'lng' => '6.3402', 'postal_code' => 'L-6837', 'name' => 'Brouch (Wecker)'),
      array('lat' => '49.6560', 'lng' => '6.3048', 'postal_code' => 'L-6934', 'name' => 'Mensdorf'),
      array('lat' => '49.7178', 'lng' => '6.3514', 'postal_code' => 'L-6835', 'name' => 'Boudlerbach'),
      array('lat' => '49.7117', 'lng' => '6.3657', 'postal_code' => 'L-6834', 'name' => 'Biwerbach'),
      array('lat' => '49.7025', 'lng' => '6.3977', 'postal_code' => 'L-6852', 'name' => 'Wecker-Gare'),
      array('lat' => '49.6959', 'lng' => '6.3826', 'postal_code' => 'L-6871', 'name' => 'Wecker'),
      array('lat' => '49.6495', 'lng' => '6.3996', 'postal_code' => 'L-5435', 'name' => 'Oberdonven'),
      array('lat' => '49.6302', 'lng' => '6.3359', 'postal_code' => 'L-5410', 'name' => 'Beyren'),
      array('lat' => '49.6642', 'lng' => '6.3457', 'postal_code' => 'L-6925', 'name' => 'Flaxweiler'),
      array('lat' => '49.6212', 'lng' => '6.3528', 'postal_code' => 'L-5425', 'name' => 'Gostingen'),
      array('lat' => '49.7168', 'lng' => '6.3298', 'postal_code' => 'L-6880', 'name' => 'Weydig'),
      array('lat' => '49.6372', 'lng' => '6.4074', 'postal_code' => 'L-5434', 'name' => 'Niederdonven'),
      array('lat' => '49.6854', 'lng' => '6.4409', 'postal_code' => 'L-6796', 'name' => 'Grevenmacher'),
      array('lat' => '49.7076', 'lng' => '6.2517', 'postal_code' => 'L-6146', 'name' => 'Junglinster'),
      array('lat' => '49.7217', 'lng' => '6.2169', 'postal_code' => 'L-6150', 'name' => 'Altlinster'),
      array('lat' => '49.7000', 'lng' => '6.1939', 'postal_code' => 'L-6195', 'name' => 'Imbringen'),
      array('lat' => '49.7029', 'lng' => '6.2200', 'postal_code' => 'L-6161', 'name' => 'Bourglinster'),
      array('lat' => '49.7336', 'lng' => '6.2324', 'postal_code' => 'L-6170', 'name' => 'Godbrange'),
      array('lat' => '49.6952', 'lng' => '6.2436', 'postal_code' => 'L-6182', 'name' => 'Gonderange'),
      array('lat' => '49.7386', 'lng' => '6.2867', 'postal_code' => 'L-6240', 'name' => 'Graulinster'),
      array('lat' => '49.7287', 'lng' => '6.3006', 'postal_code' => 'L-6235', 'name' => 'Beidweiler'),
      array('lat' => '49.7214', 'lng' => '6.4346', 'postal_code' => 'L-6839', 'name' => 'Lellig'),
      array('lat' => '49.6993', 'lng' => '6.4415', 'postal_code' => 'L-6858', 'name' => 'Munschecker'),
      array('lat' => '49.7074', 'lng' => '6.4240', 'postal_code' => 'L-6850', 'name' => 'Manternach'),
      array('lat' => '49.6874', 'lng' => '6.2896', 'postal_code' => 'L-6955', 'name' => 'Rodenbourg'),
      array('lat' => '49.6925', 'lng' => '6.1826', 'postal_code' => 'L-6197', 'name' => 'Eisenborn'),
      array('lat' => '49.7314', 'lng' => '6.3933', 'postal_code' => 'L-6830', 'name' => 'Berbourg'),
      array('lat' => '49.7146', 'lng' => '6.4977', 'postal_code' => 'L-6651', 'name' => 'Wasserbillig'),
      array('lat' => '49.6277', 'lng' => '6.4214', 'postal_code' => 'L-5401', 'name' => 'Ahn'),
      array('lat' => '49.7053', 'lng' => '6.4833', 'postal_code' => 'L-6693', 'name' => 'Mertert'),
      array('lat' => '49.6379', 'lng' => '6.3553', 'postal_code' => 'L-5432', 'name' => 'Kapenacker'),
      array('lat' => '49.6104', 'lng' => '6.3990', 'postal_code' => 'L-5485', 'name' => 'Wormeldange-Haut'),
      array('lat' => '49.6100', 'lng' => '6.4054', 'postal_code' => 'L-5481', 'name' => 'Wormeldange'),
      array('lat' => '49.6015', 'lng' => '6.3869', 'postal_code' => 'L-5417', 'name' => 'Ehnen'),
      array('lat' => '49.6582', 'lng' => '6.4350', 'postal_code' => 'L-6842', 'name' => 'Machtum'),
      array('lat' => '49.5825', 'lng' => '6.2289', 'postal_code' => 'L-5322', 'name' => 'Contern'),
      array('lat' => '49.5755', 'lng' => '6.2479', 'postal_code' => 'L-5328', 'name' => 'Medingen'),
      array('lat' => '49.5862', 'lng' => '6.2567', 'postal_code' => 'L-5335', 'name' => 'Moutfort'),
      array('lat' => '49.5981', 'lng' => '6.2595', 'postal_code' => 'L-5355', 'name' => 'Oetrange'),
      array('lat' => '49.5852', 'lng' => '6.1453', 'postal_code' => 'L-5885', 'name' => 'Howald'),
      array('lat' => '49.5729', 'lng' => '6.1487', 'postal_code' => 'L-5893', 'name' => 'Hesperange'),
      array('lat' => '49.5670', 'lng' => '6.1543', 'postal_code' => 'L-5891', 'name' => 'Fentange'),
      array('lat' => '49.5738', 'lng' => '6.1652', 'postal_code' => 'L-5896', 'name' => 'Alzingen'),
      array('lat' => '49.5871', 'lng' => '6.1782', 'postal_code' => 'L-5978', 'name' => 'Itzig'),
      array('lat' => '49.6800', 'lng' => '6.2455', 'postal_code' => 'L-6166', 'name' => 'Ernster'),
      array('lat' => '49.6508', 'lng' => '6.2356', 'postal_code' => 'L-2434', 'name' => 'Senningerberg'),
      array('lat' => '49.6492', 'lng' => '6.2432', 'postal_code' => 'L-6960', 'name' => 'Senningen'),
      array('lat' => '49.6475', 'lng' => '6.2571', 'postal_code' => 'L-6948', 'name' => 'Niederanven'),
      array('lat' => '49.6614', 'lng' => '6.2357', 'postal_code' => 'L-6996', 'name' => 'Rameldange'),
      array('lat' => '49.6591', 'lng' => '6.2384', 'postal_code' => 'L-6997', 'name' => 'Oberanven'),
      array('lat' => '49.6316', 'lng' => '6.2067', 'postal_code' => 'L-1748', 'name' => 'Findel'),
      array('lat' => '49.6172', 'lng' => '6.2215', 'postal_code' => 'L-5256', 'name' => 'Sandweiler'),
      array('lat' => '49.6246', 'lng' => '6.2331', 'postal_code' => 'L-5291', 'name' => 'Neuhaeusgen'),
      array('lat' => '49.6087', 'lng' => '6.2581', 'postal_code' => 'L-5360', 'name' => 'Schrassig'),
      array('lat' => '49.6331', 'lng' => '6.2803', 'postal_code' => 'L-5380', 'name' => 'Uebersyren'),
      array('lat' => '49.6321', 'lng' => '6.2624', 'postal_code' => 'L-5374', 'name' => 'Munsbach'),
      array('lat' => '49.6182', 'lng' => '6.2589', 'postal_code' => 'L-5381', 'name' => 'Schuttrange'),
      array('lat' => '49.6812', 'lng' => '6.1229', 'postal_code' => 'L-7346', 'name' => 'Mullendorf'),
      array('lat' => '49.6757', 'lng' => '6.1259', 'postal_code' => 'L-7347', 'name' => 'Steinsel'),
      array('lat' => '49.6707', 'lng' => '6.1339', 'postal_code' => 'L-7349', 'name' => 'Heisdorf'),
      array('lat' => '49.6234', 'lng' => '6.0735', 'postal_code' => 'L-8112', 'name' => 'Strassen'),
      array('lat' => '49.6675', 'lng' => '6.1318', 'postal_code' => 'L-7263', 'name' => 'Helmsange'),
      array('lat' => '49.5531', 'lng' => '6.2064', 'postal_code' => 'L-5762', 'name' => 'Hassel'),
      array('lat' => '49.6567', 'lng' => '6.1167', 'postal_code' => 'L-7268', 'name' => 'Bereldange'),
      array('lat' => '49.6556', 'lng' => '6.1363', 'postal_code' => 'L-7274', 'name' => 'Walferdange'),
      array('lat' => '49.5440', 'lng' => '6.2018', 'postal_code' => 'L-5772', 'name' => 'Weiler-la-Tour'),
      array('lat' => '49.5653', 'lng' => '6.2192', 'postal_code' => 'L-5898', 'name' => 'Syren'),
      array('lat' => '49.6116', 'lng' => '6.1173', 'postal_code' => 'L-2740', 'name' => 'Luxembourg'),
      array('lat' => '49.8183', 'lng' => '6.0915', 'postal_code' => 'L-7713', 'name' => 'Welsdorf'),
      array('lat' => '49.7863', 'lng' => '6.0943', 'postal_code' => 'L-7759', 'name' => 'Roost (Bissen)'),
      array('lat' => '49.8120', 'lng' => '6.0884', 'postal_code' => 'L-7739', 'name' => 'Colmar-Berg'),
      array('lat' => '49.7375', 'lng' => '6.0271', 'postal_code' => 'L-7415', 'name' => 'Brouch'),
      array('lat' => '49.7831', 'lng' => '6.0706', 'postal_code' => 'L-7796', 'name' => 'Bissen'),
      array('lat' => '49.7639', 'lng' => '6.0399', 'postal_code' => 'L-7425', 'name' => 'Bill'),
      array('lat' => '49.7501', 'lng' => '6.0066', 'postal_code' => 'L-7418', 'name' => 'Buschdorf'),
      array('lat' => '49.7522', 'lng' => '6.0356', 'postal_code' => 'L-7425', 'name' => 'Openthalt'),
      array('lat' => '49.7584', 'lng' => '6.0396', 'postal_code' => 'L-7425', 'name' => 'Finsterthal'),
      array('lat' => '49.7631', 'lng' => '6.0321', 'postal_code' => 'L-7433', 'name' => 'Grevenknapp'),
      array('lat' => '49.7715', 'lng' => '6.0199', 'postal_code' => 'L-8711', 'name' => 'Boevange-sur-Attert'),
      array('lat' => '49.7256', 'lng' => '6.1880', 'postal_code' => 'L-6155', 'name' => 'Stuppicht'),
      array('lat' => '49.7639', 'lng' => '6.1598', 'postal_code' => 'L-7410', 'name' => 'Angelsberg'),
      array('lat' => '49.7348', 'lng' => '6.2085', 'postal_code' => 'L-6155', 'name' => 'Koedange'),
      array('lat' => '49.7385', 'lng' => '6.2214', 'postal_code' => 'L-6175', 'name' => 'Schiltzberg'),
      array('lat' => '49.7463', 'lng' => '6.1894', 'postal_code' => 'L-7430', 'name' => 'Fischbach'),
      array('lat' => '49.7506', 'lng' => '6.1686', 'postal_code' => 'L-7475', 'name' => 'Schoos'),
      array('lat' => '49.7686', 'lng' => '6.2291', 'postal_code' => 'L-7673', 'name' => 'Heffingen'),
      array('lat' => '49.7244', 'lng' => '6.1153', 'postal_code' => 'L-7432', 'name' => 'Gosseldange'),
      array('lat' => '49.7842', 'lng' => '6.2187', 'postal_code' => 'L-7627', 'name' => 'Larochette'),
      array('lat' => '49.7713', 'lng' => '6.2144', 'postal_code' => 'L-7636', 'name' => 'Ernzen'),
      array('lat' => '49.7172', 'lng' => '6.1189', 'postal_code' => 'L-7460', 'name' => 'Prettingen'),
      array('lat' => '49.7239', 'lng' => '6.1274', 'postal_code' => 'L-7453', 'name' => 'Lintgen'),
      array('lat' => '49.6936', 'lng' => '6.1428', 'postal_code' => 'L-7382', 'name' => 'Helmdange'),
      array('lat' => '49.6906', 'lng' => '6.1730', 'postal_code' => 'L-7392', 'name' => 'Asselscheuer'),
      array('lat' => '49.6887', 'lng' => '6.1376', 'postal_code' => 'L-7378', 'name' => 'Bofferdange'),
      array('lat' => '49.7019', 'lng' => '6.1503', 'postal_code' => 'L-7383', 'name' => 'Lorentzweiler'),
      array('lat' => '49.6975', 'lng' => '6.1286', 'postal_code' => 'L-7396', 'name' => 'Hunsdorf'),
      array('lat' => '49.6977', 'lng' => '6.1673', 'postal_code' => 'L-7392', 'name' => 'Blaschette'),
      array('lat' => '49.6930', 'lng' => '6.1683', 'postal_code' => 'L-7392', 'name' => 'Klingelscheuer'),
      array('lat' => '49.7181', 'lng' => '6.0909', 'postal_code' => 'L-7473', 'name' => 'Schoenfels'),
      array('lat' => '49.7697', 'lng' => '6.1075', 'postal_code' => 'L-7463', 'name' => 'Pettingen'),
      array('lat' => '49.7689', 'lng' => '6.1137', 'postal_code' => 'L-7463', 'name' => 'Moesdorf'),
      array('lat' => '49.7393', 'lng' => '6.1130', 'postal_code' => 'L-7567', 'name' => 'Rollingen'),
      array('lat' => '49.7829', 'lng' => '6.0980', 'postal_code' => 'L-7759', 'name' => 'Essingen'),
      array('lat' => '49.7475', 'lng' => '6.0773', 'postal_code' => 'L-7597', 'name' => 'Reckange'),
      array('lat' => '49.7285', 'lng' => '6.0806', 'postal_code' => 'L-7599', 'name' => 'Mersch'),
      array('lat' => '49.7923', 'lng' => '6.1542', 'postal_code' => 'L-7431', 'name' => 'Niederglabach'),
      array('lat' => '49.7850', 'lng' => '6.1497', 'postal_code' => 'L-7431', 'name' => 'Oberglabach'),
      array('lat' => '49.7989', 'lng' => '6.1317', 'postal_code' => 'L-7421', 'name' => 'Cruchten'),
      array('lat' => '49.7946', 'lng' => '6.1748', 'postal_code' => 'L-7465', 'name' => 'Nommern'),
      array('lat' => '49.7144', 'lng' => '6.0816', 'postal_code' => 'L-8293', 'name' => 'Claushof'),
      array('lat' => '49.8058', 'lng' => '6.1551', 'postal_code' => 'L-9184', 'name' => 'Schrondweiler'),
      array('lat' => '49.6999', 'lng' => '6.0160', 'postal_code' => 'L-7412', 'name' => 'Bour'),
      array('lat' => '49.7132', 'lng' => '6.0487', 'postal_code' => 'L-7435', 'name' => 'Hollenfels'),
      array('lat' => '49.7077', 'lng' => '6.0668', 'postal_code' => 'L-7411', 'name' => 'Marienthal'),
      array('lat' => '49.7017', 'lng' => '6.0414', 'postal_code' => 'L-7411', 'name' => 'Ansembourg'),
      array('lat' => '49.7163', 'lng' => '6.0082', 'postal_code' => 'L-7480', 'name' => 'Tuntange'),
      array('lat' => '49.7225', 'lng' => '5.9072', 'postal_code' => 'L-8538', 'name' => 'Hovelange'),
      array('lat' => '49.7354', 'lng' => '5.8970', 'postal_code' => 'L-8539', 'name' => 'Huttange'),
      array('lat' => '49.7379', 'lng' => '5.8563', 'postal_code' => 'L-8543', 'name' => 'Levelange'),
      array('lat' => '49.7319', 'lng' => '5.8826', 'postal_code' => 'L-8523', 'name' => 'Beckerich'),
      array('lat' => '49.7672', 'lng' => '5.8198', 'postal_code' => 'L-8528', 'name' => 'Colpach-Haut'),
      array('lat' => '49.7417', 'lng' => '5.9223', 'postal_code' => 'L-8551', 'name' => 'Noerdange'),
      array('lat' => '49.7222', 'lng' => '5.9249', 'postal_code' => 'L-8562', 'name' => 'Schweich'),
      array('lat' => '49.7294', 'lng' => '5.8412', 'postal_code' => 'L-8552', 'name' => 'Oberpallen'),
      array('lat' => '49.7576', 'lng' => '5.8253', 'postal_code' => 'L-8526', 'name' => 'Colpach-Bas'),
      array('lat' => '49.7955', 'lng' => '5.8211', 'postal_code' => 'L-8560', 'name' => 'Roodt (Ell)'),
      array('lat' => '49.7624', 'lng' => '5.8577', 'postal_code' => 'L-8530', 'name' => 'Ell'),
      array('lat' => '49.7792', 'lng' => '5.8098', 'postal_code' => 'L-8557', 'name' => 'Petit-Nobressart'),
      array('lat' => '49.8566', 'lng' => '5.8241', 'postal_code' => 'L-8811', 'name' => 'Bilsdorf'),
      array('lat' => '49.8212', 'lng' => '5.8550', 'postal_code' => 'L-8805', 'name' => 'Hostert'),
      array('lat' => '49.8600', 'lng' => '5.8412', 'postal_code' => 'L-8809', 'name' => 'Arsdorf'),
      array('lat' => '49.8289', 'lng' => '5.8473', 'postal_code' => 'L-8805', 'name' => 'Rambrouch'),
      array('lat' => '49.8355', 'lng' => '5.7876', 'postal_code' => 'L-8812', 'name' => 'Flatzbour'),
      array('lat' => '49.8066', 'lng' => '5.7927', 'postal_code' => 'L-8820', 'name' => 'Holtz'),
      array('lat' => '49.8383', 'lng' => '5.7832', 'postal_code' => 'L-8812', 'name' => 'Bigonville-Poteau'),
      array('lat' => '49.8231', 'lng' => '5.8871', 'postal_code' => 'L-8817', 'name' => 'Eschette'),
      array('lat' => '49.8512', 'lng' => '5.7935', 'postal_code' => 'L-8813', 'name' => 'Bigonville'),
      array('lat' => '49.8382', 'lng' => '5.8391', 'postal_code' => 'L-8821', 'name' => 'Koetschette'),
      array('lat' => '49.8576', 'lng' => '5.9433', 'postal_code' => 'L-9144', 'name' => 'Lehrhof'),
      array('lat' => '49.8397', 'lng' => '5.8147', 'postal_code' => 'L-8821', 'name' => 'Riesenhof'),
      array('lat' => '49.8237', 'lng' => '5.7488', 'postal_code' => 'L-8823', 'name' => 'Haut-Martelange'),
      array('lat' => '49.8085', 'lng' => '5.7669', 'postal_code' => 'L-8826', 'name' => 'Perlé'),
      array('lat' => '49.8334', 'lng' => '5.7433', 'postal_code' => 'L-8832', 'name' => 'Rombach-Martelange'),
      array('lat' => '49.8587', 'lng' => '5.9588', 'postal_code' => 'L-9144', 'name' => 'Dellen'),
      array('lat' => '49.8130', 'lng' => '5.8769', 'postal_code' => 'L-8835', 'name' => 'Folschette'),
      array('lat' => '49.8291', 'lng' => '5.7664', 'postal_code' => 'L-8833', 'name' => 'Wolwelange'),
      array('lat' => '49.8505', 'lng' => '5.9171', 'postal_code' => 'L-8818', 'name' => 'Grevels (Grosbous)'),
      array('lat' => '49.8251', 'lng' => '5.9662', 'postal_code' => 'L-9155', 'name' => 'Grosbous'),
      array('lat' => '49.7777', 'lng' => '5.8937', 'postal_code' => 'L-8540', 'name' => 'Eltz'),
      array('lat' => '49.7735', 'lng' => '5.9259', 'postal_code' => 'L-8558', 'name' => 'Reichlange'),
      array('lat' => '49.7559', 'lng' => '5.9097', 'postal_code' => 'L-8545', 'name' => 'Niederpallen'),
      array('lat' => '49.7668', 'lng' => '5.8917', 'postal_code' => 'L-8508', 'name' => 'Redange/Attert'),
      array('lat' => '49.7880', 'lng' => '5.8574', 'postal_code' => 'L-8544', 'name' => 'Nagem'),
      array('lat' => '49.7825', 'lng' => '5.9035', 'postal_code' => 'L-8540', 'name' => 'Ospern'),
      array('lat' => '49.7900', 'lng' => '5.8381', 'postal_code' => 'L-8542', 'name' => 'Lannen'),
      array('lat' => '49.7258', 'lng' => '5.9830', 'postal_code' => 'L-7471', 'name' => 'Saeul'),
      array('lat' => '49.7457', 'lng' => '5.9708', 'postal_code' => 'L-8561', 'name' => 'Schwebach'),
      array('lat' => '49.7391', 'lng' => '5.9684', 'postal_code' => 'L-8541', 'name' => 'Kapweiler'),
      array('lat' => '49.7252', 'lng' => '5.9635', 'postal_code' => 'L-8525', 'name' => 'Calmus'),
      array('lat' => '49.7172', 'lng' => '5.9496', 'postal_code' => 'L-8529', 'name' => 'Ehner'),
      array('lat' => '49.7918', 'lng' => '5.9753', 'postal_code' => 'L-8620', 'name' => 'Schandel'),
      array('lat' => '49.7756', 'lng' => '5.9529', 'postal_code' => 'L-8715', 'name' => 'Everlange'),
      array('lat' => '49.7724', 'lng' => '5.9821', 'postal_code' => 'L-8708', 'name' => 'Useldange'),
      array('lat' => '49.7508', 'lng' => '5.9551', 'postal_code' => 'L-8720', 'name' => 'Rippweiler'),
      array('lat' => '49.8193', 'lng' => '6.0190', 'postal_code' => 'L-9173', 'name' => 'Michelbouch'),
      array('lat' => '49.8264', 'lng' => '5.9346', 'postal_code' => 'L-8610', 'name' => 'Buschrodt'),
      array('lat' => '49.8035', 'lng' => '6.0012', 'postal_code' => 'L-9189', 'name' => 'Vichten'),
      array('lat' => '49.8522', 'lng' => '5.9141', 'postal_code' => 'L-8818', 'name' => 'Grevels'),
      array('lat' => '49.8547', 'lng' => '5.9019', 'postal_code' => 'L-8816', 'name' => 'Brattert'),
      array('lat' => '49.8689', 'lng' => '5.9023', 'postal_code' => 'L-8822', 'name' => 'Kuborn'),
      array('lat' => '49.8496', 'lng' => '5.9000', 'postal_code' => 'L-8831', 'name' => 'Rindschleiden'),
      array('lat' => '49.8541', 'lng' => '5.8825', 'postal_code' => 'L-8819', 'name' => 'Heispelt'),
      array('lat' => '49.8368', 'lng' => '5.9061', 'postal_code' => 'L-8838', 'name' => 'Wahl'),
      array('lat' => '49.7889', 'lng' => '5.9382', 'postal_code' => 'L-8615', 'name' => 'Platen'),
      array('lat' => '49.7974', 'lng' => '5.9533', 'postal_code' => 'L-8614', 'name' => 'Reimberg'),
      array('lat' => '49.5503', 'lng' => '6.3161', 'postal_code' => 'L-5443', 'name' => 'Rolling'),
      array('lat' => '49.5543', 'lng' => '6.3148', 'postal_code' => 'L-5402', 'name' => 'Assel'),
      array('lat' => '49.5559', 'lng' => '6.3256', 'postal_code' => 'L-5407', 'name' => 'Bous'),
      array('lat' => '49.5399', 'lng' => '6.2848', 'postal_code' => 'L-5698', 'name' => 'Welfrange'),
      array('lat' => '49.5483', 'lng' => '6.2616', 'postal_code' => 'L-5684', 'name' => 'Dalheim'),
      array('lat' => '49.5337', 'lng' => '6.2460', 'postal_code' => 'L-5740', 'name' => 'Filsdorf'),
      array('lat' => '49.6016', 'lng' => '6.3662', 'postal_code' => 'L-5431', 'name' => 'Lenningen'),
      array('lat' => '49.6116', 'lng' => '6.3275', 'postal_code' => 'L-5414', 'name' => 'Canach'),
      array('lat' => '49.5128', 'lng' => '6.3019', 'postal_code' => 'L-5691', 'name' => 'Ellange'),
      array('lat' => '49.5051', 'lng' => '6.2705', 'postal_code' => 'L-5658', 'name' => 'Mondorf-les-Bains'),
      array('lat' => '49.5093', 'lng' => '6.2553', 'postal_code' => 'L-5670', 'name' => 'Altwies'),
      array('lat' => '49.4874', 'lng' => '6.2903', 'postal_code' => 'L-5695', 'name' => 'Emerange'),
      array('lat' => '49.5014', 'lng' => '6.3511', 'postal_code' => 'L-5495', 'name' => 'Wintrange'),
      array('lat' => '49.4872', 'lng' => '6.3502', 'postal_code' => 'L-5441', 'name' => 'Remerschen'),
      array('lat' => '49.5106', 'lng' => '6.3568', 'postal_code' => 'L-5447', 'name' => 'Schwebsingen'),
      array('lat' => '49.4691', 'lng' => '6.3594', 'postal_code' => 'L-5444', 'name' => 'Schengen'),
      array('lat' => '49.5324', 'lng' => '6.3380', 'postal_code' => 'L-5422', 'name' => 'Bech-Kleinmacher'),
      array('lat' => '49.5242', 'lng' => '6.3400', 'postal_code' => 'L-5470', 'name' => 'Wellenstein'),
      array('lat' => '49.4852', 'lng' => '6.3217', 'postal_code' => 'L-5675', 'name' => 'Burmerange'),
      array('lat' => '49.5868', 'lng' => '6.3737', 'postal_code' => 'L-5429', 'name' => 'Huettermuehle'),
      array('lat' => '49.5702', 'lng' => '6.2841', 'postal_code' => 'L-5442', 'name' => 'Roedt'),
      array('lat' => '49.5867', 'lng' => '6.3658', 'postal_code' => 'L-5427', 'name' => 'Greiveldange'),
      array('lat' => '49.5711', 'lng' => '6.2800', 'postal_code' => 'L-5460', 'name' => 'Trintange'),
      array('lat' => '49.5458', 'lng' => '6.3703', 'postal_code' => 'L-5577', 'name' => 'Remich'),
      array('lat' => '49.5763', 'lng' => '6.2758', 'postal_code' => 'L-5423', 'name' => 'Ersange'),
      array('lat' => '49.5563', 'lng' => '6.2864', 'postal_code' => 'L-5465', 'name' => 'Waldbredimus'),
      array('lat' => '49.5634', 'lng' => '6.3626', 'postal_code' => 'L-5451', 'name' => 'Stadtbredimus'),
      array('lat' => '49.8751', 'lng' => '6.1868', 'postal_code' => 'L-9359', 'name' => 'Bastendorf'),
      array('lat' => '49.8985', 'lng' => '6.1828', 'postal_code' => 'L-9395', 'name' => 'Tandel'),
      array('lat' => '49.9034', 'lng' => '6.1339', 'postal_code' => 'L-9378', 'name' => 'Këppenhaff'),
      array('lat' => '49.9179', 'lng' => '6.2253', 'postal_code' => 'L-9451', 'name' => 'Bettel'),
      array('lat' => '49.9124', 'lng' => '6.1967', 'postal_code' => 'L-9454', 'name' => 'Fouhren'),
      array('lat' => '49.9332', 'lng' => '6.1571', 'postal_code' => 'L-9458', 'name' => 'Brandenbourg'),
      array('lat' => '49.9589', 'lng' => '6.1916', 'postal_code' => 'L-9453', 'name' => 'Bivels'),
      array('lat' => '49.8984', 'lng' => '6.2064', 'postal_code' => 'L-9459', 'name' => 'Longsdorf'),
      array('lat' => '49.9361', 'lng' => '6.1564', 'postal_code' => 'L-9458', 'name' => 'Hoscheidterhof'),
      array('lat' => '49.9342', 'lng' => '6.1463', 'postal_code' => 'L-9458', 'name' => 'Landscheid'),
      array('lat' => '49.9252', 'lng' => '6.1721', 'postal_code' => 'L-9465', 'name' => 'Walsdorf'),
      array('lat' => '49.9582', 'lng' => '6.1384', 'postal_code' => 'L-9462', 'name' => 'Putscheid'),
      array('lat' => '49.9470', 'lng' => '6.1340', 'postal_code' => 'L-9461', 'name' => 'Nachtmanderscheid'),
      array('lat' => '49.9362', 'lng' => '6.1011', 'postal_code' => 'L-9375', 'name' => 'Gralingen'),
      array('lat' => '49.9630', 'lng' => '6.1241', 'postal_code' => 'L-9466', 'name' => 'Weiler'),
      array('lat' => '49.9664', 'lng' => '6.1657', 'postal_code' => 'L-9464', 'name' => 'Stolzembourg'),
      array('lat' => '49.9355', 'lng' => '6.2073', 'postal_code' => 'L-9425', 'name' => 'Vianden'),
      array('lat' => '49.9106', 'lng' => '5.9935', 'postal_code' => 'L-9181', 'name' => 'Tadler'),
      array('lat' => '49.8979', 'lng' => '5.8180', 'postal_code' => 'L-9633', 'name' => 'Baschleiden'),
      array('lat' => '49.9023', 'lng' => '5.7785', 'postal_code' => 'L-9687', 'name' => 'Surré'),
      array('lat' => '49.8856', 'lng' => '5.9326', 'postal_code' => 'L-9151', 'name' => 'Eschdorf'),
      array('lat' => '49.8728', 'lng' => '5.9298', 'postal_code' => 'L-9144', 'name' => 'Hierheck'),
      array('lat' => '49.8715', 'lng' => '5.9685', 'postal_code' => 'L-9165', 'name' => 'Merscheid'),
      array('lat' => '49.8863', 'lng' => '5.8114', 'postal_code' => 'L-9640', 'name' => 'Boulaide'),
      array('lat' => '49.9160', 'lng' => '6.0111', 'postal_code' => 'L-9181', 'name' => 'Ringel'),
      array('lat' => '49.8883', 'lng' => '5.9781', 'postal_code' => 'L-9157', 'name' => 'Heiderscheid'),
      array('lat' => '49.9033', 'lng' => '5.9605', 'postal_code' => 'L-9659', 'name' => 'Heiderscheidergrund'),
      array('lat' => '49.9108', 'lng' => '5.9347', 'postal_code' => 'L-9650', 'name' => 'Esch-sur-Sûre'),
      array('lat' => '49.9249', 'lng' => '6.0483', 'postal_code' => 'L-9153', 'name' => 'Goebelsmuehle'),
      array('lat' => '49.9092', 'lng' => '5.8905', 'postal_code' => 'L-9666', 'name' => 'Lultzhausen'),
      array('lat' => '49.9235', 'lng' => '5.9987', 'postal_code' => 'L-9637', 'name' => 'Bockholtz (Goesdorf)'),
      array('lat' => '49.9003', 'lng' => '5.8816', 'postal_code' => 'L-9660', 'name' => 'Insenborn'),
      array('lat' => '49.9206', 'lng' => '6.0348', 'postal_code' => 'L-9153', 'name' => 'Dirbach (Goesdorf)'),
      array('lat' => '49.8763', 'lng' => '5.8842', 'postal_code' => 'L-9671', 'name' => 'Neunhausen'),
      array('lat' => '49.9332', 'lng' => '5.9382', 'postal_code' => 'L-9643', 'name' => 'Buederscheid'),
      array('lat' => '49.9472', 'lng' => '5.9635', 'postal_code' => 'L-9674', 'name' => 'Nocher-Route'),
      array('lat' => '49.9210', 'lng' => '5.9675', 'postal_code' => 'L-9653', 'name' => 'Goesdorf'),
      array('lat' => '49.9349', 'lng' => '5.9753', 'postal_code' => 'L-9644', 'name' => 'Dahl'),
      array('lat' => '49.9464', 'lng' => '5.9768', 'postal_code' => 'L-9674', 'name' => 'Nocher'),
      array('lat' => '49.9211', 'lng' => '5.9016', 'postal_code' => 'L-9662', 'name' => 'Kaundorf'),
      array('lat' => '49.9318', 'lng' => '6.0285', 'postal_code' => 'L-9668', 'name' => 'Masseler'),
      array('lat' => '49.9302', 'lng' => '5.7834', 'postal_code' => 'L-9657', 'name' => 'Harlange'),
      array('lat' => '49.9218', 'lng' => '5.8471', 'postal_code' => 'L-9635', 'name' => 'Bavigne'),
      array('lat' => '49.9509', 'lng' => '5.7962', 'postal_code' => 'L-9689', 'name' => 'Tarchamps'),
      array('lat' => '49.9224', 'lng' => '5.8724', 'postal_code' => 'L-9669', 'name' => 'Mecher (Haute-Sûre)'),
      array('lat' => '49.9404', 'lng' => '5.8812', 'postal_code' => 'L-9678', 'name' => 'Nothum'),
      array('lat' => '49.9104', 'lng' => '5.8768', 'postal_code' => 'L-9665', 'name' => 'Liefrange'),
      array('lat' => '49.9446', 'lng' => '5.7872', 'postal_code' => 'L-9690', 'name' => 'Watrange'),
      array('lat' => '49.9741', 'lng' => '5.9433', 'postal_code' => 'L-9579', 'name' => 'Weidingen'),
      array('lat' => '49.9783', 'lng' => '5.9464', 'postal_code' => 'L-9648', 'name' => 'Erpeldange'),
      array('lat' => '49.9974', 'lng' => '5.9480', 'postal_code' => 'L-9651', 'name' => 'Eschweiler'),
      array('lat' => '49.9603', 'lng' => '5.8597', 'postal_code' => 'L-9638', 'name' => 'Pommerloch'),
      array('lat' => '49.9717', 'lng' => '5.8397', 'postal_code' => 'L-9647', 'name' => 'Doncols'),
      array('lat' => '50.0161', 'lng' => '5.9655', 'postal_code' => 'L-9759', 'name' => 'Knaphoscheid'),
      array('lat' => '49.9522', 'lng' => '5.8567', 'postal_code' => 'L-9636', 'name' => 'Berlé'),
      array('lat' => '49.9562', 'lng' => '5.9217', 'postal_code' => 'L-9681', 'name' => 'Roullingen'),
      array('lat' => '50.0181', 'lng' => '5.9474', 'postal_code' => 'L-9682', 'name' => 'Selscheid'),
      array('lat' => '49.9798', 'lng' => '5.9077', 'postal_code' => 'L-9676', 'name' => 'Noertrange'),
      array('lat' => '49.9643', 'lng' => '5.8238', 'postal_code' => 'L-9647', 'name' => 'Sonlez'),
      array('lat' => '49.9674', 'lng' => '5.8889', 'postal_code' => 'L-9696', 'name' => 'Winseler'),
      array('lat' => '49.9893', 'lng' => '5.8569', 'postal_code' => 'L-9654', 'name' => 'Schleif'),
      array('lat' => '49.9639', 'lng' => '5.9044', 'postal_code' => 'L-9696', 'name' => 'Wiltz'),
      array('lat' => '49.9847', 'lng' => '5.8723', 'postal_code' => 'L-9654', 'name' => 'Gruemelscheid'),
      array('lat' => '49.9623', 'lng' => '5.9795', 'postal_code' => 'L-9670', 'name' => 'Merkholtz'),
      array('lat' => '49.9696', 'lng' => '6.0079', 'postal_code' => 'L-9632', 'name' => 'Alscheid'),
      array('lat' => '49.9991', 'lng' => '5.9905', 'postal_code' => 'L-9747', 'name' => 'Enscherange'),
      array('lat' => '49.9526', 'lng' => '6.0191', 'postal_code' => 'L-9663', 'name' => 'Kautenbach'),
      array('lat' => '49.9848', 'lng' => '6.0113', 'postal_code' => 'L-9760', 'name' => 'Lellingen'),
      array('lat' => '49.9932', 'lng' => '6.0091', 'postal_code' => 'L-9767', 'name' => 'Pintsch'),
      array('lat' => '49.9892', 'lng' => '5.9989', 'postal_code' => 'L-9776', 'name' => 'Wilwerwiltz'),

    ],

    'LU-LU' => [
      array('lat' => '49.5825', 'lng' => '6.2289', 'postal_code' => 'L-5322', 'name' => 'Contern'),
      array('lat' => '49.5755', 'lng' => '6.2479', 'postal_code' => 'L-5328', 'name' => 'Medingen'),
      array('lat' => '49.5862', 'lng' => '6.2567', 'postal_code' => 'L-5335', 'name' => 'Moutfort'),
      array('lat' => '49.5981', 'lng' => '6.2595', 'postal_code' => 'L-5355', 'name' => 'Oetrange'),
      array('lat' => '49.5852', 'lng' => '6.1453', 'postal_code' => 'L-5885', 'name' => 'Howald'),
      array('lat' => '49.5729', 'lng' => '6.1487', 'postal_code' => 'L-5893', 'name' => 'Hesperange'),
      array('lat' => '49.5670', 'lng' => '6.1543', 'postal_code' => 'L-5891', 'name' => 'Fentange'),
      array('lat' => '49.5738', 'lng' => '6.1652', 'postal_code' => 'L-5896', 'name' => 'Alzingen'),
      array('lat' => '49.5871', 'lng' => '6.1782', 'postal_code' => 'L-5978', 'name' => 'Itzig'),
      array('lat' => '49.6800', 'lng' => '6.2455', 'postal_code' => 'L-6166', 'name' => 'Ernster'),
      array('lat' => '49.6508', 'lng' => '6.2356', 'postal_code' => 'L-2434', 'name' => 'Senningerberg'),
      array('lat' => '49.6492', 'lng' => '6.2432', 'postal_code' => 'L-6960', 'name' => 'Senningen'),
      array('lat' => '49.6475', 'lng' => '6.2571', 'postal_code' => 'L-6948', 'name' => 'Niederanven'),
      array('lat' => '49.6614', 'lng' => '6.2357', 'postal_code' => 'L-6996', 'name' => 'Rameldange'),
      array('lat' => '49.6591', 'lng' => '6.2384', 'postal_code' => 'L-6997', 'name' => 'Oberanven'),
      array('lat' => '49.6316', 'lng' => '6.2067', 'postal_code' => 'L-1748', 'name' => 'Findel'),
      array('lat' => '49.6172', 'lng' => '6.2215', 'postal_code' => 'L-5256', 'name' => 'Sandweiler'),
      array('lat' => '49.6246', 'lng' => '6.2331', 'postal_code' => 'L-5291', 'name' => 'Neuhaeusgen'),
      array('lat' => '49.6087', 'lng' => '6.2581', 'postal_code' => 'L-5360', 'name' => 'Schrassig'),
      array('lat' => '49.6331', 'lng' => '6.2803', 'postal_code' => 'L-5380', 'name' => 'Uebersyren'),
      array('lat' => '49.6321', 'lng' => '6.2624', 'postal_code' => 'L-5374', 'name' => 'Munsbach'),
      array('lat' => '49.6182', 'lng' => '6.2589', 'postal_code' => 'L-5381', 'name' => 'Schuttrange'),
      array('lat' => '49.6812', 'lng' => '6.1229', 'postal_code' => 'L-7346', 'name' => 'Mullendorf'),
      array('lat' => '49.6757', 'lng' => '6.1259', 'postal_code' => 'L-7347', 'name' => 'Steinsel'),
      array('lat' => '49.6707', 'lng' => '6.1339', 'postal_code' => 'L-7349', 'name' => 'Heisdorf'),
      array('lat' => '49.6234', 'lng' => '6.0735', 'postal_code' => 'L-8112', 'name' => 'Strassen'),
      array('lat' => '49.6675', 'lng' => '6.1318', 'postal_code' => 'L-7263', 'name' => 'Helmsange'),
      array('lat' => '49.5531', 'lng' => '6.2064', 'postal_code' => 'L-5762', 'name' => 'Hassel'),
      array('lat' => '49.6567', 'lng' => '6.1167', 'postal_code' => 'L-7268', 'name' => 'Bereldange'),
      array('lat' => '49.6556', 'lng' => '6.1363', 'postal_code' => 'L-7274', 'name' => 'Walferdange'),
      array('lat' => '49.5440', 'lng' => '6.2018', 'postal_code' => 'L-5772', 'name' => 'Weiler-la-Tour'),
      array('lat' => '49.5653', 'lng' => '6.2192', 'postal_code' => 'L-5898', 'name' => 'Syren'),
      array('lat' => '49.6116', 'lng' => '6.1173', 'postal_code' => 'L-2740', 'name' => 'Luxembourg')
    ],
    'LU-ME' => [
      array('lat' => '49.8183', 'lng' => '6.0915', 'postal_code' => 'L-7713', 'name' => 'Welsdorf'),
      array('lat' => '49.7863', 'lng' => '6.0943', 'postal_code' => 'L-7759', 'name' => 'Roost (Bissen)'),
      array('lat' => '49.8120', 'lng' => '6.0884', 'postal_code' => 'L-7739', 'name' => 'Colmar-Berg'),
      array('lat' => '49.7375', 'lng' => '6.0271', 'postal_code' => 'L-7415', 'name' => 'Brouch'),
      array('lat' => '49.7831', 'lng' => '6.0706', 'postal_code' => 'L-7796', 'name' => 'Bissen'),
      array('lat' => '49.7639', 'lng' => '6.0399', 'postal_code' => 'L-7425', 'name' => 'Bill'),
      array('lat' => '49.7501', 'lng' => '6.0066', 'postal_code' => 'L-7418', 'name' => 'Buschdorf'),
      array('lat' => '49.7522', 'lng' => '6.0356', 'postal_code' => 'L-7425', 'name' => 'Openthalt'),
      array('lat' => '49.7584', 'lng' => '6.0396', 'postal_code' => 'L-7425', 'name' => 'Finsterthal'),
      array('lat' => '49.7631', 'lng' => '6.0321', 'postal_code' => 'L-7433', 'name' => 'Grevenknapp'),
      array('lat' => '49.7715', 'lng' => '6.0199', 'postal_code' => 'L-8711', 'name' => 'Boevange-sur-Attert'),
      array('lat' => '49.7256', 'lng' => '6.1880', 'postal_code' => 'L-6155', 'name' => 'Stuppicht'),
      array('lat' => '49.7639', 'lng' => '6.1598', 'postal_code' => 'L-7410', 'name' => 'Angelsberg'),
      array('lat' => '49.7348', 'lng' => '6.2085', 'postal_code' => 'L-6155', 'name' => 'Koedange'),
      array('lat' => '49.7385', 'lng' => '6.2214', 'postal_code' => 'L-6175', 'name' => 'Schiltzberg'),
      array('lat' => '49.7463', 'lng' => '6.1894', 'postal_code' => 'L-7430', 'name' => 'Fischbach'),
      array('lat' => '49.7506', 'lng' => '6.1686', 'postal_code' => 'L-7475', 'name' => 'Schoos'),
      array('lat' => '49.7686', 'lng' => '6.2291', 'postal_code' => 'L-7673', 'name' => 'Heffingen'),
      array('lat' => '49.7244', 'lng' => '6.1153', 'postal_code' => 'L-7432', 'name' => 'Gosseldange'),
      array('lat' => '49.7842', 'lng' => '6.2187', 'postal_code' => 'L-7627', 'name' => 'Larochette'),
      array('lat' => '49.7713', 'lng' => '6.2144', 'postal_code' => 'L-7636', 'name' => 'Ernzen'),
      array('lat' => '49.7172', 'lng' => '6.1189', 'postal_code' => 'L-7460', 'name' => 'Prettingen'),
      array('lat' => '49.7239', 'lng' => '6.1274', 'postal_code' => 'L-7453', 'name' => 'Lintgen'),
      array('lat' => '49.6936', 'lng' => '6.1428', 'postal_code' => 'L-7382', 'name' => 'Helmdange'),
      array('lat' => '49.6906', 'lng' => '6.1730', 'postal_code' => 'L-7392', 'name' => 'Asselscheuer'),
      array('lat' => '49.6887', 'lng' => '6.1376', 'postal_code' => 'L-7378', 'name' => 'Bofferdange'),
      array('lat' => '49.7019', 'lng' => '6.1503', 'postal_code' => 'L-7383', 'name' => 'Lorentzweiler'),
      array('lat' => '49.6975', 'lng' => '6.1286', 'postal_code' => 'L-7396', 'name' => 'Hunsdorf'),
      array('lat' => '49.6977', 'lng' => '6.1673', 'postal_code' => 'L-7392', 'name' => 'Blaschette'),
      array('lat' => '49.6930', 'lng' => '6.1683', 'postal_code' => 'L-7392', 'name' => 'Klingelscheuer'),
      array('lat' => '49.7181', 'lng' => '6.0909', 'postal_code' => 'L-7473', 'name' => 'Schoenfels'),
      array('lat' => '49.7697', 'lng' => '6.1075', 'postal_code' => 'L-7463', 'name' => 'Pettingen'),
      array('lat' => '49.7689', 'lng' => '6.1137', 'postal_code' => 'L-7463', 'name' => 'Moesdorf'),
      array('lat' => '49.7393', 'lng' => '6.1130', 'postal_code' => 'L-7567', 'name' => 'Rollingen'),
      array('lat' => '49.7829', 'lng' => '6.0980', 'postal_code' => 'L-7759', 'name' => 'Essingen'),
      array('lat' => '49.7475', 'lng' => '6.0773', 'postal_code' => 'L-7597', 'name' => 'Reckange'),
      array('lat' => '49.7285', 'lng' => '6.0806', 'postal_code' => 'L-7599', 'name' => 'Mersch'),
      array('lat' => '49.7923', 'lng' => '6.1542', 'postal_code' => 'L-7431', 'name' => 'Niederglabach'),
      array('lat' => '49.7850', 'lng' => '6.1497', 'postal_code' => 'L-7431', 'name' => 'Oberglabach'),
      array('lat' => '49.7989', 'lng' => '6.1317', 'postal_code' => 'L-7421', 'name' => 'Cruchten'),
      array('lat' => '49.7946', 'lng' => '6.1748', 'postal_code' => 'L-7465', 'name' => 'Nommern'),
      array('lat' => '49.7144', 'lng' => '6.0816', 'postal_code' => 'L-8293', 'name' => 'Claushof'),
      array('lat' => '49.8058', 'lng' => '6.1551', 'postal_code' => 'L-9184', 'name' => 'Schrondweiler'),
      array('lat' => '49.6999', 'lng' => '6.0160', 'postal_code' => 'L-7412', 'name' => 'Bour'),
      array('lat' => '49.7132', 'lng' => '6.0487', 'postal_code' => 'L-7435', 'name' => 'Hollenfels'),
      array('lat' => '49.7077', 'lng' => '6.0668', 'postal_code' => 'L-7411', 'name' => 'Marienthal'),
      array('lat' => '49.7017', 'lng' => '6.0414', 'postal_code' => 'L-7411', 'name' => 'Ansembourg'),
      array('lat' => '49.7163', 'lng' => '6.0082', 'postal_code' => 'L-7480', 'name' => 'Tuntange')
    ],
    'LU-RD' => [
      array('lat' => '49.7225', 'lng' => '5.9072', 'postal_code' => 'L-8538', 'name' => 'Hovelange'),
      array('lat' => '49.7354', 'lng' => '5.8970', 'postal_code' => 'L-8539', 'name' => 'Huttange'),
      array('lat' => '49.7379', 'lng' => '5.8563', 'postal_code' => 'L-8543', 'name' => 'Levelange'),
      array('lat' => '49.7319', 'lng' => '5.8826', 'postal_code' => 'L-8523', 'name' => 'Beckerich'),
      array('lat' => '49.7672', 'lng' => '5.8198', 'postal_code' => 'L-8528', 'name' => 'Colpach-Haut'),
      array('lat' => '49.7417', 'lng' => '5.9223', 'postal_code' => 'L-8551', 'name' => 'Noerdange'),
      array('lat' => '49.7222', 'lng' => '5.9249', 'postal_code' => 'L-8562', 'name' => 'Schweich'),
      array('lat' => '49.7294', 'lng' => '5.8412', 'postal_code' => 'L-8552', 'name' => 'Oberpallen'),
      array('lat' => '49.7576', 'lng' => '5.8253', 'postal_code' => 'L-8526', 'name' => 'Colpach-Bas'),
      array('lat' => '49.7955', 'lng' => '5.8211', 'postal_code' => 'L-8560', 'name' => 'Roodt (Ell)'),
      array('lat' => '49.7624', 'lng' => '5.8577', 'postal_code' => 'L-8530', 'name' => 'Ell'),
      array('lat' => '49.7792', 'lng' => '5.8098', 'postal_code' => 'L-8557', 'name' => 'Petit-Nobressart'),
      array('lat' => '49.8566', 'lng' => '5.8241', 'postal_code' => 'L-8811', 'name' => 'Bilsdorf'),
      array('lat' => '49.8212', 'lng' => '5.8550', 'postal_code' => 'L-8805', 'name' => 'Hostert'),
      array('lat' => '49.8600', 'lng' => '5.8412', 'postal_code' => 'L-8809', 'name' => 'Arsdorf'),
      array('lat' => '49.8289', 'lng' => '5.8473', 'postal_code' => 'L-8805', 'name' => 'Rambrouch'),
      array('lat' => '49.8355', 'lng' => '5.7876', 'postal_code' => 'L-8812', 'name' => 'Flatzbour'),
      array('lat' => '49.8066', 'lng' => '5.7927', 'postal_code' => 'L-8820', 'name' => 'Holtz'),
      array('lat' => '49.8383', 'lng' => '5.7832', 'postal_code' => 'L-8812', 'name' => 'Bigonville-Poteau'),
      array('lat' => '49.8231', 'lng' => '5.8871', 'postal_code' => 'L-8817', 'name' => 'Eschette'),
      array('lat' => '49.8512', 'lng' => '5.7935', 'postal_code' => 'L-8813', 'name' => 'Bigonville'),
      array('lat' => '49.8382', 'lng' => '5.8391', 'postal_code' => 'L-8821', 'name' => 'Koetschette'),
      array('lat' => '49.8576', 'lng' => '5.9433', 'postal_code' => 'L-9144', 'name' => 'Lehrhof'),
      array('lat' => '49.8397', 'lng' => '5.8147', 'postal_code' => 'L-8821', 'name' => 'Riesenhof'),
      array('lat' => '49.8237', 'lng' => '5.7488', 'postal_code' => 'L-8823', 'name' => 'Haut-Martelange'),
      array('lat' => '49.8085', 'lng' => '5.7669', 'postal_code' => 'L-8826', 'name' => 'Perlé'),
      array('lat' => '49.8334', 'lng' => '5.7433', 'postal_code' => 'L-8832', 'name' => 'Rombach-Martelange'),
      array('lat' => '49.8587', 'lng' => '5.9588', 'postal_code' => 'L-9144', 'name' => 'Dellen'),
      array('lat' => '49.8130', 'lng' => '5.8769', 'postal_code' => 'L-8835', 'name' => 'Folschette'),
      array('lat' => '49.8291', 'lng' => '5.7664', 'postal_code' => 'L-8833', 'name' => 'Wolwelange'),
      array('lat' => '49.8505', 'lng' => '5.9171', 'postal_code' => 'L-8818', 'name' => 'Grevels (Grosbous)'),
      array('lat' => '49.8251', 'lng' => '5.9662', 'postal_code' => 'L-9155', 'name' => 'Grosbous'),
      array('lat' => '49.7777', 'lng' => '5.8937', 'postal_code' => 'L-8540', 'name' => 'Eltz'),
      array('lat' => '49.7735', 'lng' => '5.9259', 'postal_code' => 'L-8558', 'name' => 'Reichlange'),
      array('lat' => '49.7559', 'lng' => '5.9097', 'postal_code' => 'L-8545', 'name' => 'Niederpallen'),
      array('lat' => '49.7668', 'lng' => '5.8917', 'postal_code' => 'L-8508', 'name' => 'Redange/Attert'),
      array('lat' => '49.7880', 'lng' => '5.8574', 'postal_code' => 'L-8544', 'name' => 'Nagem'),
      array('lat' => '49.7825', 'lng' => '5.9035', 'postal_code' => 'L-8540', 'name' => 'Ospern'),
      array('lat' => '49.7900', 'lng' => '5.8381', 'postal_code' => 'L-8542', 'name' => 'Lannen'),
      array('lat' => '49.7258', 'lng' => '5.9830', 'postal_code' => 'L-7471', 'name' => 'Saeul'),
      array('lat' => '49.7457', 'lng' => '5.9708', 'postal_code' => 'L-8561', 'name' => 'Schwebach'),
      array('lat' => '49.7391', 'lng' => '5.9684', 'postal_code' => 'L-8541', 'name' => 'Kapweiler'),
      array('lat' => '49.7252', 'lng' => '5.9635', 'postal_code' => 'L-8525', 'name' => 'Calmus'),
      array('lat' => '49.7172', 'lng' => '5.9496', 'postal_code' => 'L-8529', 'name' => 'Ehner'),
      array('lat' => '49.7918', 'lng' => '5.9753', 'postal_code' => 'L-8620', 'name' => 'Schandel'),
      array('lat' => '49.7756', 'lng' => '5.9529', 'postal_code' => 'L-8715', 'name' => 'Everlange'),
      array('lat' => '49.7724', 'lng' => '5.9821', 'postal_code' => 'L-8708', 'name' => 'Useldange'),
      array('lat' => '49.7508', 'lng' => '5.9551', 'postal_code' => 'L-8720', 'name' => 'Rippweiler'),
      array('lat' => '49.8193', 'lng' => '6.0190', 'postal_code' => 'L-9173', 'name' => 'Michelbouch'),
      array('lat' => '49.8264', 'lng' => '5.9346', 'postal_code' => 'L-8610', 'name' => 'Buschrodt'),
      array('lat' => '49.8035', 'lng' => '6.0012', 'postal_code' => 'L-9189', 'name' => 'Vichten'),
      array('lat' => '49.8522', 'lng' => '5.9141', 'postal_code' => 'L-8818', 'name' => 'Grevels'),
      array('lat' => '49.8547', 'lng' => '5.9019', 'postal_code' => 'L-8816', 'name' => 'Brattert'),
      array('lat' => '49.8689', 'lng' => '5.9023', 'postal_code' => 'L-8822', 'name' => 'Kuborn'),
      array('lat' => '49.8496', 'lng' => '5.9000', 'postal_code' => 'L-8831', 'name' => 'Rindschleiden'),
      array('lat' => '49.8541', 'lng' => '5.8825', 'postal_code' => 'L-8819', 'name' => 'Heispelt'),
      array('lat' => '49.8368', 'lng' => '5.9061', 'postal_code' => 'L-8838', 'name' => 'Wahl'),
      array('lat' => '49.7889', 'lng' => '5.9382', 'postal_code' => 'L-8615', 'name' => 'Platen'),
      array('lat' => '49.7974', 'lng' => '5.9533', 'postal_code' => 'L-8614', 'name' => 'Reimberg')
    ],
    'LU-RM' => [
      array('lat' => '49.5503', 'lng' => '6.3161', 'postal_code' => 'L-5443', 'name' => 'Rolling', 'state_id' => '10'),
      array('lat' => '49.5543', 'lng' => '6.3148', 'postal_code' => 'L-5402', 'name' => 'Assel', 'state_id' => '10'),
      array('lat' => '49.5559', 'lng' => '6.3256', 'postal_code' => 'L-5407', 'name' => 'Bous', 'state_id' => '10'),
      array('lat' => '49.5399', 'lng' => '6.2848', 'postal_code' => 'L-5698', 'name' => 'Welfrange', 'state_id' => '10'),
      array('lat' => '49.5483', 'lng' => '6.2616', 'postal_code' => 'L-5684', 'name' => 'Dalheim', 'state_id' => '10'),
      array('lat' => '49.5337', 'lng' => '6.2460', 'postal_code' => 'L-5740', 'name' => 'Filsdorf', 'state_id' => '10'),
      array('lat' => '49.6016', 'lng' => '6.3662', 'postal_code' => 'L-5431', 'name' => 'Lenningen', 'state_id' => '10'),
      array('lat' => '49.6116', 'lng' => '6.3275', 'postal_code' => 'L-5414', 'name' => 'Canach', 'state_id' => '10'),
      array('lat' => '49.5128', 'lng' => '6.3019', 'postal_code' => 'L-5691', 'name' => 'Ellange', 'state_id' => '10'),
      array('lat' => '49.5051', 'lng' => '6.2705', 'postal_code' => 'L-5658', 'name' => 'Mondorf-les-Bains', 'state_id' => '10'),
      array('lat' => '49.5093', 'lng' => '6.2553', 'postal_code' => 'L-5670', 'name' => 'Altwies', 'state_id' => '10'),
      array('lat' => '49.4874', 'lng' => '6.2903', 'postal_code' => 'L-5695', 'name' => 'Emerange', 'state_id' => '10'),
      array('lat' => '49.5014', 'lng' => '6.3511', 'postal_code' => 'L-5495', 'name' => 'Wintrange', 'state_id' => '10'),
      array('lat' => '49.4872', 'lng' => '6.3502', 'postal_code' => 'L-5441', 'name' => 'Remerschen', 'state_id' => '10'),
      array('lat' => '49.5106', 'lng' => '6.3568', 'postal_code' => 'L-5447', 'name' => 'Schwebsingen', 'state_id' => '10'),
      array('lat' => '49.4691', 'lng' => '6.3594', 'postal_code' => 'L-5444', 'name' => 'Schengen', 'state_id' => '10'),
      array('lat' => '49.5324', 'lng' => '6.3380', 'postal_code' => 'L-5422', 'name' => 'Bech-Kleinmacher', 'state_id' => '10'),
      array('lat' => '49.5242', 'lng' => '6.3400', 'postal_code' => 'L-5470', 'name' => 'Wellenstein', 'state_id' => '10'),
      array('lat' => '49.4852', 'lng' => '6.3217', 'postal_code' => 'L-5675', 'name' => 'Burmerange', 'state_id' => '10'),
      array('lat' => '49.5868', 'lng' => '6.3737', 'postal_code' => 'L-5429', 'name' => 'Huettermuehle', 'state_id' => '10'),
      array('lat' => '49.5702', 'lng' => '6.2841', 'postal_code' => 'L-5442', 'name' => 'Roedt', 'state_id' => '10'),
      array('lat' => '49.5867', 'lng' => '6.3658', 'postal_code' => 'L-5427', 'name' => 'Greiveldange', 'state_id' => '10'),
      array('lat' => '49.5711', 'lng' => '6.2800', 'postal_code' => 'L-5460', 'name' => 'Trintange', 'state_id' => '10'),
      array('lat' => '49.5458', 'lng' => '6.3703', 'postal_code' => 'L-5577', 'name' => 'Remich', 'state_id' => '10'),
      array('lat' => '49.5763', 'lng' => '6.2758', 'postal_code' => 'L-5423', 'name' => 'Ersange', 'state_id' => '10'),
      array('lat' => '49.5563', 'lng' => '6.2864', 'postal_code' => 'L-5465', 'name' => 'Waldbredimus', 'state_id' => '10'),
      array('lat' => '49.5634', 'lng' => '6.3626', 'postal_code' => 'L-5451', 'name' => 'Stadtbredimus', 'state_id' => '10')
    ],
    'LU-VD' => [
      array('lat' => '49.8751', 'lng' => '6.1868', 'postal_code' => 'L-9359', 'name' => 'Bastendorf'),
      array('lat' => '49.8985', 'lng' => '6.1828', 'postal_code' => 'L-9395', 'name' => 'Tandel'),
      array('lat' => '49.9034', 'lng' => '6.1339', 'postal_code' => 'L-9378', 'name' => 'Këppenhaff'),
      array('lat' => '49.9179', 'lng' => '6.2253', 'postal_code' => 'L-9451', 'name' => 'Bettel'),
      array('lat' => '49.9124', 'lng' => '6.1967', 'postal_code' => 'L-9454', 'name' => 'Fouhren'),
      array('lat' => '49.9332', 'lng' => '6.1571', 'postal_code' => 'L-9458', 'name' => 'Brandenbourg'),
      array('lat' => '49.9589', 'lng' => '6.1916', 'postal_code' => 'L-9453', 'name' => 'Bivels'),
      array('lat' => '49.8984', 'lng' => '6.2064', 'postal_code' => 'L-9459', 'name' => 'Longsdorf'),
      array('lat' => '49.9361', 'lng' => '6.1564', 'postal_code' => 'L-9458', 'name' => 'Hoscheidterhof'),
      array('lat' => '49.9342', 'lng' => '6.1463', 'postal_code' => 'L-9458', 'name' => 'Landscheid'),
      array('lat' => '49.9252', 'lng' => '6.1721', 'postal_code' => 'L-9465', 'name' => 'Walsdorf'),
      array('lat' => '49.9582', 'lng' => '6.1384', 'postal_code' => 'L-9462', 'name' => 'Putscheid'),
      array('lat' => '49.9470', 'lng' => '6.1340', 'postal_code' => 'L-9461', 'name' => 'Nachtmanderscheid'),
      array('lat' => '49.9362', 'lng' => '6.1011', 'postal_code' => 'L-9375', 'name' => 'Gralingen'),
      array('lat' => '49.9630', 'lng' => '6.1241', 'postal_code' => 'L-9466', 'name' => 'Weiler'),
      array('lat' => '49.9664', 'lng' => '6.1657', 'postal_code' => 'L-9464', 'name' => 'Stolzembourg'),
      array('lat' => '49.9355', 'lng' => '6.2073', 'postal_code' => 'L-9425', 'name' => 'Vianden')
    ],
    'LU-WI' => [
      array('lat' => '49.9106', 'lng' => '5.9935', 'postal_code' => 'L-9181', 'name' => 'Tadler'),
      array('lat' => '49.8979', 'lng' => '5.8180', 'postal_code' => 'L-9633', 'name' => 'Baschleiden'),
      array('lat' => '49.9023', 'lng' => '5.7785', 'postal_code' => 'L-9687', 'name' => 'Surré'),
      array('lat' => '49.8856', 'lng' => '5.9326', 'postal_code' => 'L-9151', 'name' => 'Eschdorf'),
      array('lat' => '49.8728', 'lng' => '5.9298', 'postal_code' => 'L-9144', 'name' => 'Hierheck'),
      array('lat' => '49.8715', 'lng' => '5.9685', 'postal_code' => 'L-9165', 'name' => 'Merscheid'),
      array('lat' => '49.8863', 'lng' => '5.8114', 'postal_code' => 'L-9640', 'name' => 'Boulaide'),
      array('lat' => '49.9160', 'lng' => '6.0111', 'postal_code' => 'L-9181', 'name' => 'Ringel'),
      array('lat' => '49.8883', 'lng' => '5.9781', 'postal_code' => 'L-9157', 'name' => 'Heiderscheid'),
      array('lat' => '49.9033', 'lng' => '5.9605', 'postal_code' => 'L-9659', 'name' => 'Heiderscheidergrund'),
      array('lat' => '49.9108', 'lng' => '5.9347', 'postal_code' => 'L-9650', 'name' => 'Esch-sur-Sûre'),
      array('lat' => '49.9249', 'lng' => '6.0483', 'postal_code' => 'L-9153', 'name' => 'Goebelsmuehle'),
      array('lat' => '49.9092', 'lng' => '5.8905', 'postal_code' => 'L-9666', 'name' => 'Lultzhausen'),
      array('lat' => '49.9235', 'lng' => '5.9987', 'postal_code' => 'L-9637', 'name' => 'Bockholtz (Goesdorf)'),
      array('lat' => '49.9003', 'lng' => '5.8816', 'postal_code' => 'L-9660', 'name' => 'Insenborn'),
      array('lat' => '49.9206', 'lng' => '6.0348', 'postal_code' => 'L-9153', 'name' => 'Dirbach (Goesdorf)'),
      array('lat' => '49.8763', 'lng' => '5.8842', 'postal_code' => 'L-9671', 'name' => 'Neunhausen'),
      array('lat' => '49.9332', 'lng' => '5.9382', 'postal_code' => 'L-9643', 'name' => 'Buederscheid'),
      array('lat' => '49.9472', 'lng' => '5.9635', 'postal_code' => 'L-9674', 'name' => 'Nocher-Route'),
      array('lat' => '49.9210', 'lng' => '5.9675', 'postal_code' => 'L-9653', 'name' => 'Goesdorf'),
      array('lat' => '49.9349', 'lng' => '5.9753', 'postal_code' => 'L-9644', 'name' => 'Dahl'),
      array('lat' => '49.9464', 'lng' => '5.9768', 'postal_code' => 'L-9674', 'name' => 'Nocher'),
      array('lat' => '49.9211', 'lng' => '5.9016', 'postal_code' => 'L-9662', 'name' => 'Kaundorf'),
      array('lat' => '49.9318', 'lng' => '6.0285', 'postal_code' => 'L-9668', 'name' => 'Masseler'),
      array('lat' => '49.9302', 'lng' => '5.7834', 'postal_code' => 'L-9657', 'name' => 'Harlange'),
      array('lat' => '49.9218', 'lng' => '5.8471', 'postal_code' => 'L-9635', 'name' => 'Bavigne'),
      array('lat' => '49.9509', 'lng' => '5.7962', 'postal_code' => 'L-9689', 'name' => 'Tarchamps'),
      array('lat' => '49.9224', 'lng' => '5.8724', 'postal_code' => 'L-9669', 'name' => 'Mecher (Haute-Sûre)'),
      array('lat' => '49.9404', 'lng' => '5.8812', 'postal_code' => 'L-9678', 'name' => 'Nothum'),
      array('lat' => '49.9104', 'lng' => '5.8768', 'postal_code' => 'L-9665', 'name' => 'Liefrange'),
      array('lat' => '49.9446', 'lng' => '5.7872', 'postal_code' => 'L-9690', 'name' => 'Watrange'),
      array('lat' => '49.9741', 'lng' => '5.9433', 'postal_code' => 'L-9579', 'name' => 'Weidingen'),
      array('lat' => '49.9783', 'lng' => '5.9464', 'postal_code' => 'L-9648', 'name' => 'Erpeldange'),
      array('lat' => '49.9974', 'lng' => '5.9480', 'postal_code' => 'L-9651', 'name' => 'Eschweiler'),
      array('lat' => '49.9603', 'lng' => '5.8597', 'postal_code' => 'L-9638', 'name' => 'Pommerloch'),
      array('lat' => '49.9717', 'lng' => '5.8397', 'postal_code' => 'L-9647', 'name' => 'Doncols'),
      array('lat' => '50.0161', 'lng' => '5.9655', 'postal_code' => 'L-9759', 'name' => 'Knaphoscheid'),
      array('lat' => '49.9522', 'lng' => '5.8567', 'postal_code' => 'L-9636', 'name' => 'Berlé'),
      array('lat' => '49.9562', 'lng' => '5.9217', 'postal_code' => 'L-9681', 'name' => 'Roullingen'),
      array('lat' => '50.0181', 'lng' => '5.9474', 'postal_code' => 'L-9682', 'name' => 'Selscheid'),
      array('lat' => '49.9798', 'lng' => '5.9077', 'postal_code' => 'L-9676', 'name' => 'Noertrange'),
      array('lat' => '49.9643', 'lng' => '5.8238', 'postal_code' => 'L-9647', 'name' => 'Sonlez'),
      array('lat' => '49.9674', 'lng' => '5.8889', 'postal_code' => 'L-9696', 'name' => 'Winseler'),
      array('lat' => '49.9893', 'lng' => '5.8569', 'postal_code' => 'L-9654', 'name' => 'Schleif'),
      array('lat' => '49.9639', 'lng' => '5.9044', 'postal_code' => 'L-9696', 'name' => 'Wiltz'),
      array('lat' => '49.9847', 'lng' => '5.8723', 'postal_code' => 'L-9654', 'name' => 'Gruemelscheid'),
      array('lat' => '49.9623', 'lng' => '5.9795', 'postal_code' => 'L-9670', 'name' => 'Merkholtz'),
      array('lat' => '49.9696', 'lng' => '6.0079', 'postal_code' => 'L-9632', 'name' => 'Alscheid'),
      array('lat' => '49.9991', 'lng' => '5.9905', 'postal_code' => 'L-9747', 'name' => 'Enscherange'),
      array('lat' => '49.9526', 'lng' => '6.0191', 'postal_code' => 'L-9663', 'name' => 'Kautenbach'),
      array('lat' => '49.9848', 'lng' => '6.0113', 'postal_code' => 'L-9760', 'name' => 'Lellingen'),
      array('lat' => '49.9932', 'lng' => '6.0091', 'postal_code' => 'L-9767', 'name' => 'Pintsch'),
      array('lat' => '49.9892', 'lng' => '5.9989', 'postal_code' => 'L-9776', 'name' => 'Wilwerwiltz')
    ],

    // Belgique
    'VBR' => [
      array('lat' => '50.8428', 'lng' => '4.3515', 'postal_code' => '1000', 'name' => 'Brussel'),
      array('lat' => '50.8842', 'lng' => '4.3580', 'postal_code' => '1020', 'name' => 'Laken'),
      array('lat' => '50.8674', 'lng' => '4.3773', 'postal_code' => '1030', 'name' => 'Schaarbeek'),
      array('lat' => '50.8326', 'lng' => '4.3890', 'postal_code' => '1040', 'name' => 'Etterbeek'),
      array('lat' => '50.8271', 'lng' => '4.3723', 'postal_code' => '1050', 'name' => 'Elsene'),
      array('lat' => '50.8301', 'lng' => '4.3402', 'postal_code' => '1060', 'name' => 'Sint-Gillis'),
      array('lat' => '50.8366', 'lng' => '4.3082', 'postal_code' => '1070', 'name' => 'Anderlecht'),
      array('lat' => '50.8522', 'lng' => '4.3303', 'postal_code' => '1080', 'name' => 'Sint-Jans-Molenbeek'),
      array('lat' => '50.8634', 'lng' => '4.3303', 'postal_code' => '1081', 'name' => 'Koekelberg'),
      array('lat' => '50.8658', 'lng' => '4.2926', 'postal_code' => '1082', 'name' => 'Sint-Agatha-Berchem'),
      array('lat' => '50.8711', 'lng' => '4.3025', 'postal_code' => '1083', 'name' => 'Ganshoren'),
      array('lat' => '50.8809', 'lng' => '4.3228', 'postal_code' => '1090', 'name' => 'Jette'),
      array('lat' => '50.8962', 'lng' => '4.3719', 'postal_code' => '1120', 'name' => 'Neder-Over-Heembeek'),
      array('lat' => '50.8739', 'lng' => '4.4009', 'postal_code' => '1140', 'name' => 'Evere'),
      array('lat' => '50.8300', 'lng' => '4.4335', 'postal_code' => '1150', 'name' => 'Sint-Pieters-Woluwe'),
      array('lat' => '50.8164', 'lng' => '4.4265', 'postal_code' => '1160', 'name' => 'Oudergem'),
      array('lat' => '50.7882', 'lng' => '4.4180', 'postal_code' => '1170', 'name' => 'Watermaal-Bosvoorde'),
      array('lat' => '50.8024', 'lng' => '4.3407', 'postal_code' => '1180', 'name' => 'Ukkel'),
      array('lat' => '50.8489', 'lng' => '4.4321', 'postal_code' => '1200', 'name' => 'Sint-Lambrechts-Woluwe'),
      array('lat' => '50.8538', 'lng' => '4.3705', 'postal_code' => '1210', 'name' => 'Sint-Joost-Ten-Noode'),
      array('lat' => '50.7414', 'lng' => '4.2500', 'postal_code' => '1501', 'name' => 'Buizingen'),
      array('lat' => '50.7141', 'lng' => '4.2200', 'postal_code' => '1502', 'name' => 'Lembeek'),
      array('lat' => '50.7478', 'lng' => '4.0999', 'postal_code' => '1540', 'name' => 'Herfelingen'),
      array('lat' => '50.7233', 'lng' => '4.0537', 'postal_code' => '1540', 'name' => 'Herne'),
      array('lat' => '50.7170', 'lng' => '3.9407', 'postal_code' => '1547', 'name' => 'Bever'),
      array('lat' => '50.7675', 'lng' => '4.4740', 'postal_code' => '1560', 'name' => 'Hoeilaart'),
      array('lat' => '50.7529', 'lng' => '3.9709', 'postal_code' => '1570', 'name' => 'Galmaarden'),
      array('lat' => '50.7411', 'lng' => '4.0068', 'postal_code' => '1570', 'name' => 'Tollembeek'),
      array('lat' => '50.7607', 'lng' => '4.0253', 'postal_code' => '1570', 'name' => 'Vollezele'),
      array('lat' => '50.7807', 'lng' => '4.1994', 'postal_code' => '1600', 'name' => 'Oudenaken'),
      array('lat' => '50.7868', 'lng' => '4.1994', 'postal_code' => '1600', 'name' => 'Sint-Laureins-Berchem'),
      array('lat' => '50.7842', 'lng' => '4.2427', 'postal_code' => '1600', 'name' => 'Sint-Pieters-Leeuw'),
      array('lat' => '50.8079', 'lng' => '4.2321', 'postal_code' => '1602', 'name' => 'Vlezenbeek'),
      array('lat' => '50.7875', 'lng' => '4.3165', 'postal_code' => '1620', 'name' => 'Drogenbos'),
      array('lat' => '50.7660', 'lng' => '4.3456', 'postal_code' => '1630', 'name' => 'Linkebeek'),
      array('lat' => '50.7459', 'lng' => '4.3575', 'postal_code' => '1640', 'name' => 'Sint-Genesius-Rode'),
      array('lat' => '50.7687', 'lng' => '4.3120', 'postal_code' => '1650', 'name' => 'Beersel'),
      array('lat' => '50.7678', 'lng' => '4.2771', 'postal_code' => '1651', 'name' => 'Lot'),
      array('lat' => '50.7416', 'lng' => '4.3361', 'postal_code' => '1652', 'name' => 'Alsemberg'),
      array('lat' => '50.7295', 'lng' => '4.3011', 'postal_code' => '1653', 'name' => 'Dworp'),
      array('lat' => '50.7466', 'lng' => '4.2737', 'postal_code' => '1654', 'name' => 'Huizingen'),
      array('lat' => '50.7400', 'lng' => '4.1363', 'postal_code' => '1670', 'name' => 'Bogaarden'),
      array('lat' => '50.7350', 'lng' => '4.1121', 'postal_code' => '1670', 'name' => 'Heikruis'),
      array('lat' => '50.7360', 'lng' => '4.1361', 'postal_code' => '1670', 'name' => 'Pepingen'),
      array('lat' => '50.7793', 'lng' => '4.1712', 'postal_code' => '1671', 'name' => 'Elingen'),
      array('lat' => '50.7410', 'lng' => '4.1818', 'postal_code' => '1673', 'name' => 'Beert'),
      array('lat' => '50.7408', 'lng' => '4.1540', 'postal_code' => '1674', 'name' => 'Bellingen'),
      array('lat' => '50.8465', 'lng' => '4.2621', 'postal_code' => '1700', 'name' => 'Dilbeek'),
      array('lat' => '50.8615', 'lng' => '4.2129', 'postal_code' => '1700', 'name' => 'Sint-Martens-Bodegem'),
      array('lat' => '50.8790', 'lng' => '4.2182', 'postal_code' => '1700', 'name' => 'Sint-Ulriks-Kapelle'),
      array('lat' => '50.8381', 'lng' => '4.2501', 'postal_code' => '1701', 'name' => 'Itterbeek'),
      array('lat' => '50.8719', 'lng' => '4.2500', 'postal_code' => '1702', 'name' => 'Groot-Bijgaarden'),
      array('lat' => '50.8383', 'lng' => '4.1958', 'postal_code' => '1703', 'name' => 'Schepdaal'),
      array('lat' => '50.9055', 'lng' => '4.2049', 'postal_code' => '1730', 'name' => 'Asse'),
      array('lat' => '50.8852', 'lng' => '4.2380', 'postal_code' => '1730', 'name' => 'Bekkerzeel'),
      array('lat' => '50.9086', 'lng' => '4.2510', 'postal_code' => '1730', 'name' => 'Kobbegem'),
      array('lat' => '50.9313', 'lng' => '4.2264', 'postal_code' => '1730', 'name' => 'Mollem'),
      array('lat' => '50.8991', 'lng' => '4.2770', 'postal_code' => '1731', 'name' => 'Relegem'),
      array('lat' => '50.8845', 'lng' => '4.2740', 'postal_code' => '1731', 'name' => 'Zellik'),
      array('lat' => '50.8985', 'lng' => '4.2186', 'postal_code' => '1733', 'name' => 'Highco Data'),
      array('lat' => '50.8698', 'lng' => '4.1808', 'postal_code' => '1740', 'name' => 'Ternat'),
      array('lat' => '50.8532', 'lng' => '4.1628', 'postal_code' => '1741', 'name' => 'Wambeek'),
      array('lat' => '50.8733', 'lng' => '4.1560', 'postal_code' => '1742', 'name' => 'Sint-Katherina-Lombeek'),
      array('lat' => '50.9428', 'lng' => '4.1712', 'postal_code' => '1745', 'name' => 'Mazenzele'),
      array('lat' => '50.9716', 'lng' => '4.1869', 'postal_code' => '1745', 'name' => 'Opwijk'),
      array('lat' => '50.7999', 'lng' => '4.1889', 'postal_code' => '1750', 'name' => 'Gaasbeek'),
      array('lat' => '50.8087', 'lng' => '4.1614', 'postal_code' => '1750', 'name' => 'Lennik'),
      array('lat' => '50.8042', 'lng' => '4.1548', 'postal_code' => '1750', 'name' => 'Sint-Kwintens-Lennik'),
      array('lat' => '50.8127', 'lng' => '4.1686', 'postal_code' => '1750', 'name' => 'Sint-Martens-Lennik'),
      array('lat' => '50.7953', 'lng' => '4.1180', 'postal_code' => '1755', 'name' => 'Gooik'),
      array('lat' => '50.7643', 'lng' => '4.1194', 'postal_code' => '1755', 'name' => 'Kester'),
      array('lat' => '50.7779', 'lng' => '4.1194', 'postal_code' => '1755', 'name' => 'Leerbeek'),
      array('lat' => '50.7735', 'lng' => '4.0631', 'postal_code' => '1755', 'name' => 'Oetingen'),
      array('lat' => '50.8198', 'lng' => '4.1102', 'postal_code' => '1760', 'name' => 'Onze-Lieve-Vrouw-Lombeek'),
      array('lat' => '50.8450', 'lng' => '4.0710', 'postal_code' => '1760', 'name' => 'Pamel'),
      array('lat' => '50.8314', 'lng' => '4.0880', 'postal_code' => '1760', 'name' => 'Roosdaal'),
      array('lat' => '50.8413', 'lng' => '4.1174', 'postal_code' => '1760', 'name' => 'Strijtem'),
      array('lat' => '50.8475', 'lng' => '4.1398', 'postal_code' => '1761', 'name' => 'Borchtlombeek'),
      array('lat' => '50.8689', 'lng' => '4.0873', 'postal_code' => '1770', 'name' => 'Liedekerke'),
      array('lat' => '50.9103', 'lng' => '4.3010', 'postal_code' => '1780', 'name' => 'Wemmel'),
      array('lat' => '50.9257', 'lng' => '4.2661', 'postal_code' => '1785', 'name' => 'Brussegem'),
      array('lat' => '50.9584', 'lng' => '4.2324', 'postal_code' => '1785', 'name' => 'Merchtem'),
      array('lat' => '50.9084', 'lng' => '4.1128', 'postal_code' => '1790', 'name' => 'Affligem'),
      array('lat' => '50.9016', 'lng' => '4.1364', 'postal_code' => '1790', 'name' => 'Essene'),
      array('lat' => '50.9072', 'lng' => '4.1085', 'postal_code' => '1790', 'name' => 'Hekelgem'),
      array('lat' => '50.8923', 'lng' => '4.0987', 'postal_code' => '1790', 'name' => 'Teralfene'),
      array('lat' => '50.9274', 'lng' => '4.4554', 'postal_code' => '1800', 'name' => 'Peutie'),
      array('lat' => '50.9273', 'lng' => '4.4258', 'postal_code' => '1800', 'name' => 'Vilvoorde'),
      array('lat' => '50.9473', 'lng' => '4.4273', 'postal_code' => '1804', 'name' => 'Cargovil'),
      array('lat' => '50.9136', 'lng' => '4.3981', 'postal_code' => '1818', 'name' => 'Vtm'),
      array('lat' => '50.9154', 'lng' => '4.4787', 'postal_code' => '1820', 'name' => 'Melsbroek'),
      array('lat' => '50.9349', 'lng' => '4.4959', 'postal_code' => '1820', 'name' => 'Perk'),
      array('lat' => '50.9079', 'lng' => '4.5135', 'postal_code' => '1820', 'name' => 'Steenokkerzeel'),
      array('lat' => '50.8940', 'lng' => '4.4363', 'postal_code' => '1831', 'name' => 'Diegem'),
      array('lat' => '51.0031', 'lng' => '4.3026', 'postal_code' => '1840', 'name' => 'Londerzeel'),
      array('lat' => '51.0203', 'lng' => '4.2463', 'postal_code' => '1840', 'name' => 'Malderen'),
      array('lat' => '50.9958', 'lng' => '4.2672', 'postal_code' => '1840', 'name' => 'Steenhuffel'),
      array('lat' => '50.9356', 'lng' => '4.3786', 'postal_code' => '1850', 'name' => 'Grimbergen'),
      array('lat' => '50.9672', 'lng' => '4.3795', 'postal_code' => '1851', 'name' => 'Humbeek'),
      array('lat' => '50.9528', 'lng' => '4.3661', 'postal_code' => '1852', 'name' => 'Beigem'),
      array('lat' => '50.9105', 'lng' => '4.3578', 'postal_code' => '1853', 'name' => 'Strombeek-Bever'),
      array('lat' => '50.9479', 'lng' => '4.3303', 'postal_code' => '1860', 'name' => 'Meise'),
      array('lat' => '50.9509', 'lng' => '4.3093', 'postal_code' => '1861', 'name' => 'Wolvertem'),
      array('lat' => '51.0132', 'lng' => '4.3554', 'postal_code' => '1880', 'name' => 'Kapelle-Op-Den-Bos'),
      array('lat' => '50.9786', 'lng' => '4.3523', 'postal_code' => '1880', 'name' => 'Nieuwenrode'),
      array('lat' => '51.0148', 'lng' => '4.3352', 'postal_code' => '1880', 'name' => 'Ramsdonk'),
      array('lat' => '50.9403', 'lng' => '4.6169', 'postal_code' => '1910', 'name' => 'Buken'),
      array('lat' => '50.9339', 'lng' => '4.5605', 'postal_code' => '1910', 'name' => 'Kampenhout'),
      array('lat' => '50.9220', 'lng' => '4.5633', 'postal_code' => '1910', 'name' => 'Nederokkerzeel'),
      array('lat' => '50.8782', 'lng' => '4.5075', 'postal_code' => '1930', 'name' => 'Nossegem'),
      array('lat' => '50.8795', 'lng' => '4.4826', 'postal_code' => '1930', 'name' => 'Zaventem'),
      array('lat' => '50.9033', 'lng' => '4.4522', 'postal_code' => '1931', 'name' => 'Brucargo'),
      array('lat' => '50.8692', 'lng' => '4.4502', 'postal_code' => '1932', 'name' => 'Sint-Stevens-Woluwe'),
      array('lat' => '50.8654', 'lng' => '4.4726', 'postal_code' => '1933', 'name' => 'Sterrebeek'),
      array('lat' => '50.8969', 'lng' => '4.4843', 'postal_code' => '1934', 'name' => 'Office Exchange Brussels Airport Remailing'),
      array('lat' => '50.8899', 'lng' => '4.4580', 'postal_code' => '1935', 'name' => 'Corporate Village'),
      array('lat' => '50.8611', 'lng' => '4.4593', 'postal_code' => '1950', 'name' => 'Kraainem'),
      array('lat' => '50.8509', 'lng' => '4.4874', 'postal_code' => '1970', 'name' => 'Wezembeek-Oppem'),
      array('lat' => '50.9621', 'lng' => '4.4544', 'postal_code' => '1980', 'name' => 'Eppegem'),
      array('lat' => '50.9855', 'lng' => '4.4558', 'postal_code' => '1980', 'name' => 'Zemst'),
      array('lat' => '50.9619', 'lng' => '4.4965', 'postal_code' => '1982', 'name' => 'Elewijt'),
      array('lat' => '50.9722', 'lng' => '4.4793', 'postal_code' => '1982', 'name' => 'Weerde'),
      array('lat' => '50.8815', 'lng' => '4.6968', 'postal_code' => '3000', 'name' => 'Leuven'),
      array('lat' => '50.8639', 'lng' => '4.6959', 'postal_code' => '3001', 'name' => 'Heverlee'),
      array('lat' => '50.8851', 'lng' => '4.7357', 'postal_code' => '3010', 'name' => 'Kessel Lo'),
      array('lat' => '50.8905', 'lng' => '4.6945', 'postal_code' => '3012', 'name' => 'Wilsele'),
      array('lat' => '50.9262', 'lng' => '4.7020', 'postal_code' => '3018', 'name' => 'Wijgmaal'),
      array('lat' => '50.9092', 'lng' => '4.6769', 'postal_code' => '3020', 'name' => 'Herent'),
      array('lat' => '50.9063', 'lng' => '4.6208', 'postal_code' => '3020', 'name' => 'Veltem-Beisem'),
      array('lat' => '50.8975', 'lng' => '4.6435', 'postal_code' => '3020', 'name' => 'Winksele'),
      array('lat' => '50.7886', 'lng' => '4.5881', 'postal_code' => '3040', 'name' => 'Huldenberg'),
      array('lat' => '50.8097', 'lng' => '4.6103', 'postal_code' => '3040', 'name' => 'Loonbeek'),
      array('lat' => '50.8174', 'lng' => '4.6235', 'postal_code' => '3040', 'name' => 'Neerijse'),
      array('lat' => '50.7520', 'lng' => '4.6158', 'postal_code' => '3040', 'name' => 'Ottenburg'),
      array('lat' => '50.7856', 'lng' => '4.6341', 'postal_code' => '3040', 'name' => 'Sint-Agatha-Rode'),
      array('lat' => '50.8283', 'lng' => '4.6595', 'postal_code' => '3050', 'name' => 'Oud-Heverlee'),
      array('lat' => '50.8028', 'lng' => '4.6529', 'postal_code' => '3051', 'name' => 'Sint-Joris-Weert'),
      array('lat' => '50.8256', 'lng' => '4.7092', 'postal_code' => '3052', 'name' => 'Blanden'),
      array('lat' => '50.8316', 'lng' => '4.7299', 'postal_code' => '3053', 'name' => 'Haasrode'),
      array('lat' => '50.8255', 'lng' => '4.6894', 'postal_code' => '3054', 'name' => 'Vaalbeek'),
      array('lat' => '50.8633', 'lng' => '4.6308', 'postal_code' => '3060', 'name' => 'Bertem'),
      array('lat' => '50.8381', 'lng' => '4.6382', 'postal_code' => '3060', 'name' => 'Korbeek-Dijle'),
      array('lat' => '50.8487', 'lng' => '4.5939', 'postal_code' => '3061', 'name' => 'Leefdaal'),
      array('lat' => '50.8856', 'lng' => '4.5375', 'postal_code' => '3070', 'name' => 'Kortenberg'),
      array('lat' => '50.9006', 'lng' => '4.5608', 'postal_code' => '3071', 'name' => 'Erps-Kwerps'),
      array('lat' => '50.8788', 'lng' => '4.5712', 'postal_code' => '3078', 'name' => 'Everberg'),
      array('lat' => '50.8819', 'lng' => '4.5893', 'postal_code' => '3078', 'name' => 'Meerbeek'),
      array('lat' => '50.8157', 'lng' => '4.5518', 'postal_code' => '3080', 'name' => 'Duisburg'),
      array('lat' => '50.8259', 'lng' => '4.5078', 'postal_code' => '3080', 'name' => 'Tervuren'),
      array('lat' => '50.8358', 'lng' => '4.5603', 'postal_code' => '3080', 'name' => 'Vossem'),
      array('lat' => '50.7681', 'lng' => '4.5336', 'postal_code' => '3090', 'name' => 'Overijse'),
      array('lat' => '50.9536', 'lng' => '4.7215', 'postal_code' => '3110', 'name' => 'Rotselaar'),
      array('lat' => '50.9482', 'lng' => '4.7554', 'postal_code' => '3111', 'name' => 'Wezemaal'),
      array('lat' => '50.9728', 'lng' => '4.7001', 'postal_code' => '3118', 'name' => 'Werchter'),
      array('lat' => '50.9956', 'lng' => '4.7160', 'postal_code' => '3120', 'name' => 'Tremelo'),
      array('lat' => '50.9956', 'lng' => '4.7530', 'postal_code' => '3128', 'name' => 'Baal'),
      array('lat' => '51.0188', 'lng' => '4.7826', 'postal_code' => '3130', 'name' => 'Begijnendijk'),
      array('lat' => '50.9857', 'lng' => '4.7817', 'postal_code' => '3130', 'name' => 'Betekom'),
      array('lat' => '51.0058', 'lng' => '4.6320', 'postal_code' => '3140', 'name' => 'Keerbergen'),
      array('lat' => '50.9789', 'lng' => '4.6413', 'postal_code' => '3150', 'name' => 'Haacht'),
      array('lat' => '50.9433', 'lng' => '4.6445', 'postal_code' => '3150', 'name' => 'Tildonk'),
      array('lat' => '50.9599', 'lng' => '4.6388', 'postal_code' => '3150', 'name' => 'Wespelaar'),
      array('lat' => '50.9803', 'lng' => '4.5744', 'postal_code' => '3190', 'name' => 'Boortmeerbeek'),
      array('lat' => '50.9950', 'lng' => '4.5514', 'postal_code' => '3191', 'name' => 'Hever'),
      array('lat' => '50.9806', 'lng' => '4.8274', 'postal_code' => '3200', 'name' => 'Aarschot'),
      array('lat' => '50.9655', 'lng' => '4.8027', 'postal_code' => '3200', 'name' => 'Gelrode'),
      array('lat' => '50.9953', 'lng' => '4.8708', 'postal_code' => '3201', 'name' => 'Langdorp'),
      array('lat' => '50.9744', 'lng' => '4.8942', 'postal_code' => '3202', 'name' => 'Rillaar'),
      array('lat' => '50.8939', 'lng' => '4.7722', 'postal_code' => '3210', 'name' => 'Linden'),
      array('lat' => '50.8813', 'lng' => '4.8292', 'postal_code' => '3210', 'name' => 'Lubbeek'),
      array('lat' => '50.8712', 'lng' => '4.8844', 'postal_code' => '3211', 'name' => 'Binkom'),
      array('lat' => '50.8715', 'lng' => '4.7938', 'postal_code' => '3212', 'name' => 'Pellenberg'),
      array('lat' => '50.9801', 'lng' => '4.9754', 'postal_code' => '3270', 'name' => 'Scherpenheuvel'),
      array('lat' => '50.9743', 'lng' => '4.9786', 'postal_code' => '3270', 'name' => 'Scherpenheuvel-Zichem'),
      array('lat' => '51.0305', 'lng' => '4.9775', 'postal_code' => '3271', 'name' => 'Averbode'),
      array('lat' => '51.0007', 'lng' => '4.9830', 'postal_code' => '3271', 'name' => 'Zichem'),
      array('lat' => '50.9933', 'lng' => '4.9275', 'postal_code' => '3272', 'name' => 'Messelbroek'),
      array('lat' => '51.0169', 'lng' => '4.9549', 'postal_code' => '3272', 'name' => 'Testelt'),
      array('lat' => '51.0394', 'lng' => '5.0965', 'postal_code' => '3290', 'name' => 'Deurne'),
      array('lat' => '51.0010', 'lng' => '5.0852', 'postal_code' => '3290', 'name' => 'Diest'),
      array('lat' => '50.9998', 'lng' => '5.0848', 'postal_code' => '3290', 'name' => 'Schaffen'),
      array('lat' => '50.9723', 'lng' => '5.0720', 'postal_code' => '3290', 'name' => 'Webbekom'),
      array('lat' => '50.9794', 'lng' => '5.0190', 'postal_code' => '3293', 'name' => 'Kaggevinne'),
      array('lat' => '51.0038', 'lng' => '5.0135', 'postal_code' => '3294', 'name' => 'Molenstede'),
      array('lat' => '50.7884', 'lng' => '4.9406', 'postal_code' => '3300', 'name' => 'Bost'),
      array('lat' => '50.7678', 'lng' => '4.9511', 'postal_code' => '3300', 'name' => 'Goetsenhoven'),
      array('lat' => '50.7971', 'lng' => '4.9853', 'postal_code' => '3300', 'name' => 'Hakendover'),
      array('lat' => '50.8225', 'lng' => '4.8874', 'postal_code' => '3300', 'name' => 'Kumtich'),
      array('lat' => '50.7981', 'lng' => '4.8924', 'postal_code' => '3300', 'name' => 'Oorbeek'),
      array('lat' => '50.8292', 'lng' => '4.9876', 'postal_code' => '3300', 'name' => 'Oplinter'),
      array('lat' => '50.8106', 'lng' => '4.9362', 'postal_code' => '3300', 'name' => 'Tienen'),
      array('lat' => '50.8377', 'lng' => '4.9048', 'postal_code' => '3300', 'name' => 'Vissenaken'),
      array('lat' => '50.7806', 'lng' => '4.8686', 'postal_code' => '3320', 'name' => 'Hoegaarden'),
      array('lat' => '50.7652', 'lng' => '4.9179', 'postal_code' => '3321', 'name' => 'Outgaarden'),
      array('lat' => '50.8461', 'lng' => '5.0505', 'postal_code' => '3350', 'name' => 'Drieslinter'),
      array('lat' => '50.8415', 'lng' => '5.0366', 'postal_code' => '3350', 'name' => 'Linter'),
      array('lat' => '50.8253', 'lng' => '5.0614', 'postal_code' => '3350', 'name' => 'Melkwezer'),
      array('lat' => '50.7918', 'lng' => '5.0549', 'postal_code' => '3350', 'name' => 'Neerhespen'),
      array('lat' => '50.8398', 'lng' => '5.0222', 'postal_code' => '3350', 'name' => 'Neerlinter'),
      array('lat' => '50.8033', 'lng' => '5.0621', 'postal_code' => '3350', 'name' => 'Orsmaal-Gussenhoven'),
      array('lat' => '50.7954', 'lng' => '5.0361', 'postal_code' => '3350', 'name' => 'Overhespen'),
      array('lat' => '50.8134', 'lng' => '5.0180', 'postal_code' => '3350', 'name' => 'Wommersom'),
      array('lat' => '50.8279', 'lng' => '4.7598', 'postal_code' => '3360', 'name' => 'Bierbeek'),
      array('lat' => '50.8602', 'lng' => '4.7627', 'postal_code' => '3360', 'name' => 'Korbeek-Lo'),
      array('lat' => '50.8581', 'lng' => '4.7815', 'postal_code' => '3360', 'name' => 'Lovenjoel'),
      array('lat' => '50.8101', 'lng' => '4.7933', 'postal_code' => '3360', 'name' => 'Opvelp'),
      array('lat' => '50.8411', 'lng' => '4.8347', 'postal_code' => '3370', 'name' => 'Boutersem'),
      array('lat' => '50.8552', 'lng' => '4.8745', 'postal_code' => '3370', 'name' => 'Kerkom'),
      array('lat' => '50.8210', 'lng' => '4.8081', 'postal_code' => '3370', 'name' => 'Neervelp'),
      array('lat' => '50.8356', 'lng' => '4.8623', 'postal_code' => '3370', 'name' => 'Roosbeek'),
      array('lat' => '50.8298', 'lng' => '4.8346', 'postal_code' => '3370', 'name' => 'Vertrijk'),
      array('lat' => '50.8128', 'lng' => '4.8449', 'postal_code' => '3370', 'name' => 'Willebringen'),
      array('lat' => '50.8422', 'lng' => '4.9426', 'postal_code' => '3380', 'name' => 'Bunsbeek'),
      array('lat' => '50.8603', 'lng' => '4.9583', 'postal_code' => '3380', 'name' => 'Glabbeek'),
      array('lat' => '50.8853', 'lng' => '4.9502', 'postal_code' => '3381', 'name' => 'Kapellen'),
      array('lat' => '50.8771', 'lng' => '4.9243', 'postal_code' => '3384', 'name' => 'Attenrode'),
      array('lat' => '50.9328', 'lng' => '4.8581', 'postal_code' => '3390', 'name' => 'Houwaart'),
      array('lat' => '50.9077', 'lng' => '4.8768', 'postal_code' => '3390', 'name' => 'Sint-Joris-Winge'),
      array('lat' => '50.9207', 'lng' => '4.8867', 'postal_code' => '3390', 'name' => 'Tielt-Winge'),
      array('lat' => '50.8965', 'lng' => '4.9258', 'postal_code' => '3391', 'name' => 'Meensel-Kiezegem'),
      array('lat' => '50.7849', 'lng' => '5.0097', 'postal_code' => '3400', 'name' => 'Eliksem'),
      array('lat' => '50.7761', 'lng' => '5.0002', 'postal_code' => '3400', 'name' => 'Ezemaal'),
      array('lat' => '50.7716', 'lng' => '5.0257', 'postal_code' => '3400', 'name' => 'Laar'),
      array('lat' => '50.7629', 'lng' => '5.0421', 'postal_code' => '3400', 'name' => 'Landen'),
      array('lat' => '50.7662', 'lng' => '5.0443', 'postal_code' => '3400', 'name' => 'Neerwinden'),
      array('lat' => '50.7532', 'lng' => '5.0489', 'postal_code' => '3400', 'name' => 'Overwinden'),
      array('lat' => '50.7662', 'lng' => '5.0762', 'postal_code' => '3400', 'name' => 'Rumsdorp'),
      array('lat' => '50.7860', 'lng' => '5.0318', 'postal_code' => '3400', 'name' => 'Wange'),
      array('lat' => '50.7272', 'lng' => '5.0623', 'postal_code' => '3401', 'name' => 'Waasmont'),
      array('lat' => '50.7372', 'lng' => '5.0853', 'postal_code' => '3401', 'name' => 'Walsbets'),
      array('lat' => '50.7237', 'lng' => '5.0955', 'postal_code' => '3401', 'name' => 'Walshoutem'),
      array('lat' => '50.7301', 'lng' => '5.1049', 'postal_code' => '3401', 'name' => 'Wezeren'),
      array('lat' => '50.7665', 'lng' => '5.0931', 'postal_code' => '3404', 'name' => 'Attenhoven'),
      array('lat' => '50.7781', 'lng' => '5.0790', 'postal_code' => '3404', 'name' => 'Neerlanden'),
      array('lat' => '50.8654', 'lng' => '5.0981', 'postal_code' => '3440', 'name' => 'Budingen'),
      array('lat' => '50.8072', 'lng' => '5.0985', 'postal_code' => '3440', 'name' => 'Dormaal'),
      array('lat' => '50.8048', 'lng' => '5.1117', 'postal_code' => '3440', 'name' => 'Halle-Booienhoven'),
      array('lat' => '50.8182', 'lng' => '5.0822', 'postal_code' => '3440', 'name' => 'Helen-Bos'),
      array('lat' => '50.8323', 'lng' => '5.1044', 'postal_code' => '3440', 'name' => 'Zoutleeuw'),
      array('lat' => '50.8903', 'lng' => '5.1096', 'postal_code' => '3450', 'name' => 'Geetbets'),
      array('lat' => '50.8752', 'lng' => '5.1308', 'postal_code' => '3450', 'name' => 'Grazen'),
      array('lat' => '50.8889', 'lng' => '5.1656', 'postal_code' => '3454', 'name' => 'Rummen'),
      array('lat' => '50.9526', 'lng' => '5.0159', 'postal_code' => '3460', 'name' => 'Assent'),
      array('lat' => '50.9426', 'lng' => '4.9856', 'postal_code' => '3460', 'name' => 'Bekkevoort'),
      array('lat' => '50.9185', 'lng' => '4.9415', 'postal_code' => '3461', 'name' => 'Molenbeek-Wersbeek'),
      array('lat' => '50.8974', 'lng' => '5.0664', 'postal_code' => '3470', 'name' => 'Kortenaken'),
      array('lat' => '50.8744', 'lng' => '5.0378', 'postal_code' => '3470', 'name' => 'Ransberg'),
      array('lat' => '50.8128', 'lng' => '3.2791', 'postal_code' => '3470', 'name' => 'Sint-Margriete-Houtem'),
      array('lat' => '50.8682', 'lng' => '4.9869', 'postal_code' => '3471', 'name' => 'Hoeleden'),
      array('lat' => '50.8858', 'lng' => '4.9958', 'postal_code' => '3472', 'name' => 'Kersbeek-Miskom'),
      array('lat' => '50.9162', 'lng' => '5.0047', 'postal_code' => '3473', 'name' => 'Waanrode'),
      array('lat' => '50.6935', 'lng' => '4.5733', 'postal_code' => '1300', 'name' => 'Limal'),
      array('lat' => '50.7159', 'lng' => '4.6128', 'postal_code' => '1300', 'name' => 'Wavre'),
      array('lat' => '50.7114', 'lng' => '4.5872', 'postal_code' => '1301', 'name' => 'Bierges'),
      array('lat' => '50.7310', 'lng' => '4.4857', 'postal_code' => '1310', 'name' => 'La Hulpe'),
      array('lat' => '50.6796', 'lng' => '4.8377', 'postal_code' => '1315', 'name' => 'Glimes'),
      array('lat' => '50.6919', 'lng' => '4.7966', 'postal_code' => '1315', 'name' => 'Incourt'),
      array('lat' => '50.6795', 'lng' => '4.7982', 'postal_code' => '1315', 'name' => 'Opprebais'),
      array('lat' => '50.7280', 'lng' => '4.7638', 'postal_code' => '1315', 'name' => 'Piètrebais'),
      array('lat' => '50.7081', 'lng' => '4.7851', 'postal_code' => '1315', 'name' => 'Roux-Miroir'),
      array('lat' => '50.7586', 'lng' => '4.7683', 'postal_code' => '1320', 'name' => 'Beauvechain'),
      array('lat' => '50.7795', 'lng' => '4.7169', 'postal_code' => '1320', 'name' => 'Hamme-Mille'),
      array('lat' => '50.7718', 'lng' => '4.8318', 'postal_code' => '1320', 'name' => 'L\'ecluse'),
      array('lat' => '50.7732', 'lng' => '4.7356', 'postal_code' => '1320', 'name' => 'Nodebais'),
      array('lat' => '50.7828', 'lng' => '4.7445', 'postal_code' => '1320', 'name' => 'Tourinnes-La-Grosse'),
      array('lat' => '50.7019', 'lng' => '4.6895', 'postal_code' => '1325', 'name' => 'Bonlez'),
      array('lat' => '50.6769', 'lng' => '4.7194', 'postal_code' => '1325', 'name' => 'Chaumont-Gistoux'),
      array('lat' => '50.6621', 'lng' => '4.6746', 'postal_code' => '1325', 'name' => 'Corroy-Le-Grand'),
      array('lat' => '50.6975', 'lng' => '4.6588', 'postal_code' => '1325', 'name' => 'Dion-Valmont'),
      array('lat' => '50.7023', 'lng' => '4.7401', 'postal_code' => '1325', 'name' => 'Longueville'),
      array('lat' => '50.7110', 'lng' => '4.5306', 'postal_code' => '1330', 'name' => 'Rixensart'),
      array('lat' => '50.7302', 'lng' => '4.5444', 'postal_code' => '1331', 'name' => 'Rosières'),
      array('lat' => '50.7211', 'lng' => '4.4939', 'postal_code' => '1332', 'name' => 'Genval'),
      array('lat' => '50.6655', 'lng' => '4.5669', 'postal_code' => '1340', 'name' => 'Ottignies'),
      array('lat' => '50.6672', 'lng' => '4.5860', 'postal_code' => '1340', 'name' => 'Ottignies-Louvain-La-Neuve'),
      array('lat' => '50.6604', 'lng' => '4.5205', 'postal_code' => '1341', 'name' => 'Céroux-Mousty'),
      array('lat' => '50.6703', 'lng' => '4.5660', 'postal_code' => '1342', 'name' => 'Limelette'),
      array('lat' => '50.6681', 'lng' => '4.6118', 'postal_code' => '1348', 'name' => 'Louvain-La-Neuve'),
      array('lat' => '50.6937', 'lng' => '4.9266', 'postal_code' => '1350', 'name' => 'Enines'),
      array('lat' => '50.6604', 'lng' => '4.9376', 'postal_code' => '1350', 'name' => 'Folx-Les-Caves'),
      array('lat' => '50.6737', 'lng' => '4.9797', 'postal_code' => '1350', 'name' => 'Jandrain-Jandrenouille'),
      array('lat' => '50.6830', 'lng' => '4.9547', 'postal_code' => '1350', 'name' => 'Jauche'),
      array('lat' => '50.7072', 'lng' => '4.9527', 'postal_code' => '1350', 'name' => 'Marilles'),
      array('lat' => '50.7296', 'lng' => '4.9638', 'postal_code' => '1350', 'name' => 'Noduwez'),
      array('lat' => '50.6830', 'lng' => '4.9547', 'postal_code' => '1350', 'name' => 'Orp-Jauche'),
      array('lat' => '50.7038', 'lng' => '4.9907', 'postal_code' => '1350', 'name' => 'Orp-Le-Grand'),
      array('lat' => '50.7498', 'lng' => '4.9829', 'postal_code' => '1357', 'name' => 'HÉlÉcine'),
      array('lat' => '50.7336', 'lng' => '5.0030', 'postal_code' => '1357', 'name' => 'Linsmeau'),
      array('lat' => '50.7552', 'lng' => '4.9872', 'postal_code' => '1357', 'name' => 'Neerheylissem'),
      array('lat' => '50.7477', 'lng' => '4.9775', 'postal_code' => '1357', 'name' => 'Opheylissem'),
      array('lat' => '50.6550', 'lng' => '4.7794', 'postal_code' => '1360', 'name' => 'Malèves-Sainte-Marie-Wastines'),
      array('lat' => '50.6376', 'lng' => '4.7632', 'postal_code' => '1360', 'name' => 'Orbais'),
      array('lat' => '50.6240', 'lng' => '4.8150', 'postal_code' => '1360', 'name' => 'Perwez'),
      array('lat' => '50.6580', 'lng' => '4.8173', 'postal_code' => '1360', 'name' => 'Thorembais-Les-Béguines'),
      array('lat' => '50.6347', 'lng' => '4.7865', 'postal_code' => '1360', 'name' => 'Thorembais-Saint-Trond'),
      array('lat' => '50.6693', 'lng' => '4.9038', 'postal_code' => '1367', 'name' => 'Autre-Eglise'),
      array('lat' => '50.6711', 'lng' => '4.8733', 'postal_code' => '1367', 'name' => 'Bomal'),
      array('lat' => '50.6409', 'lng' => '4.8574', 'postal_code' => '1367', 'name' => 'Geest-Gérompont-Petit-Rosière'),
      array('lat' => '50.6485', 'lng' => '4.8817', 'postal_code' => '1367', 'name' => 'Gérompont'),
      array('lat' => '50.6320', 'lng' => '4.8662', 'postal_code' => '1367', 'name' => 'Grand-Rosière-Hottomont'),
      array('lat' => '50.6935', 'lng' => '4.8938', 'postal_code' => '1367', 'name' => 'Huppaye'),
      array('lat' => '50.6552', 'lng' => '4.8645', 'postal_code' => '1367', 'name' => 'Mont-Saint-André'),
      array('lat' => '50.6368', 'lng' => '4.9145', 'postal_code' => '1367', 'name' => 'Ramillies'),
      array('lat' => '50.7034', 'lng' => '4.8201', 'postal_code' => '1370', 'name' => 'Dongelberg'),
      array('lat' => '50.6863', 'lng' => '4.8436', 'postal_code' => '1370', 'name' => 'Jauchelette'),
      array('lat' => '50.7234', 'lng' => '4.8712', 'postal_code' => '1370', 'name' => 'Jodoigne'),
      array('lat' => '50.7090', 'lng' => '4.8368', 'postal_code' => '1370', 'name' => 'Jodoigne-Souveraine'),
      array('lat' => '50.7237', 'lng' => '4.8261', 'postal_code' => '1370', 'name' => 'Lathuy'),
      array('lat' => '50.7398', 'lng' => '4.8285', 'postal_code' => '1370', 'name' => 'Mélin'),
      array('lat' => '50.7248', 'lng' => '4.9207', 'postal_code' => '1370', 'name' => 'Piétrain'),
      array('lat' => '50.7396', 'lng' => '4.8955', 'postal_code' => '1370', 'name' => 'Saint-Jean-Geest'),
      array('lat' => '50.7464', 'lng' => '4.8602', 'postal_code' => '1370', 'name' => 'Saint-Remy-Geest'),
      array('lat' => '50.7579', 'lng' => '4.8859', 'postal_code' => '1370', 'name' => 'Zétrud-Lumay'),
      array('lat' => '50.6750', 'lng' => '4.4725', 'postal_code' => '1380', 'name' => 'Couture-Saint-Germain'),
      array('lat' => '50.6874', 'lng' => '4.4814', 'postal_code' => '1380', 'name' => 'Lasne'),
      array('lat' => '50.6919', 'lng' => '4.5021', 'postal_code' => '1380', 'name' => 'Lasne-Chapelle-Saint-Lambert'),
      array('lat' => '50.6595', 'lng' => '4.4675', 'postal_code' => '1380', 'name' => 'Maransart'),
      array('lat' => '50.6991', 'lng' => '4.4692', 'postal_code' => '1380', 'name' => 'Ohain'),
      array('lat' => '50.6620', 'lng' => '4.4286', 'postal_code' => '1380', 'name' => 'Plancenoit'),
      array('lat' => '50.7525', 'lng' => '4.6699', 'postal_code' => '1390', 'name' => 'Archennes'),
      array('lat' => '50.7267', 'lng' => '4.7020', 'postal_code' => '1390', 'name' => 'Biez'),
      array('lat' => '50.7613', 'lng' => '4.6941', 'postal_code' => '1390', 'name' => 'Bossut-Gottechain'),
      array('lat' => '50.7386', 'lng' => '4.6973', 'postal_code' => '1390', 'name' => 'Grez-Doiceau'),
      array('lat' => '50.7838', 'lng' => '4.6741', 'postal_code' => '1390', 'name' => 'Nethen'),
      array('lat' => '50.5980', 'lng' => '4.2888', 'postal_code' => '1400', 'name' => 'Monstreux'),
      array('lat' => '50.5887', 'lng' => '4.3309', 'postal_code' => '1400', 'name' => 'Nivelles'),
      array('lat' => '50.6134', 'lng' => '4.3539', 'postal_code' => '1401', 'name' => 'Baulers'),
      array('lat' => '50.5973', 'lng' => '4.3685', 'postal_code' => '1402', 'name' => 'Thines'),
      array('lat' => '50.6012', 'lng' => '4.2763', 'postal_code' => '1404', 'name' => 'Bornival'),
      array('lat' => '50.7147', 'lng' => '4.3991', 'postal_code' => '1410', 'name' => 'Waterloo'),
      array('lat' => '50.6969', 'lng' => '4.3538', 'postal_code' => '1420', 'name' => 'Braine-L\'alleud'),
      array('lat' => '50.6664', 'lng' => '4.3489', 'postal_code' => '1421', 'name' => 'Ophain-Bois-Seigneur-Isaac'),
      array('lat' => '50.6457', 'lng' => '4.3671', 'postal_code' => '1428', 'name' => 'Lillois-Witterzée'),
      array('lat' => '50.6957', 'lng' => '4.1195', 'postal_code' => '1430', 'name' => 'Bierghes'),
      array('lat' => '50.6729', 'lng' => '4.1573', 'postal_code' => '1430', 'name' => 'Quenast'),
      array('lat' => '50.6658', 'lng' => '4.1326', 'postal_code' => '1430', 'name' => 'Rebecq'),
      array('lat' => '50.6659', 'lng' => '4.1327', 'postal_code' => '1430', 'name' => 'Rebecq-Rognon'),
      array('lat' => '50.6463', 'lng' => '4.6554', 'postal_code' => '1435', 'name' => 'Corbais'),
      array('lat' => '50.6216', 'lng' => '4.6155', 'postal_code' => '1435', 'name' => 'Hévillers'),
      array('lat' => '50.6347', 'lng' => '4.6106', 'postal_code' => '1435', 'name' => 'Mont-Saint-Guibert'),
      array('lat' => '50.6803', 'lng' => '4.2689', 'postal_code' => '1440', 'name' => 'Braine-Le-ChÂteau'),
      array('lat' => '50.6812', 'lng' => '4.2981', 'postal_code' => '1440', 'name' => 'Wauthier-Braine'),
      array('lat' => '50.6081', 'lng' => '4.6357', 'postal_code' => '1450', 'name' => 'Chastre'),
      array('lat' => '50.6000', 'lng' => '4.6170', 'postal_code' => '1450', 'name' => 'Chastre-Villeroux-Blanmont'),
      array('lat' => '50.5814', 'lng' => '4.6428', 'postal_code' => '1450', 'name' => 'Cortil-Noirmont'),
      array('lat' => '50.5817', 'lng' => '4.6012', 'postal_code' => '1450', 'name' => 'Gentinnes'),
      array('lat' => '50.5805', 'lng' => '4.6124', 'postal_code' => '1450', 'name' => 'Saint-Géry'),
      array('lat' => '50.6421', 'lng' => '4.6798', 'postal_code' => '1457', 'name' => 'Nil-Saint-Vincent-Saint-Martin'),
      array('lat' => '50.6393', 'lng' => '4.7239', 'postal_code' => '1457', 'name' => 'Tourinnes-Saint-Lambert'),
      array('lat' => '50.6165', 'lng' => '4.6955', 'postal_code' => '1457', 'name' => 'Walhain'),
      array('lat' => '50.6328', 'lng' => '4.7026', 'postal_code' => '1457', 'name' => 'Walhain-Saint-Paul'),
      array('lat' => '50.6327', 'lng' => '4.2632', 'postal_code' => '1460', 'name' => 'Ittre'),
      array('lat' => '50.6398', 'lng' => '4.2059', 'postal_code' => '1460', 'name' => 'Virginal-Samme'),
      array('lat' => '50.6536', 'lng' => '4.2983', 'postal_code' => '1461', 'name' => 'Haut-Ittre'),
      array('lat' => '50.5970', 'lng' => '4.4761', 'postal_code' => '1470', 'name' => 'Baisy-Thy'),
      array('lat' => '50.6149', 'lng' => '4.5051', 'postal_code' => '1470', 'name' => 'Bousval'),
      array('lat' => '50.6108', 'lng' => '4.4504', 'postal_code' => '1470', 'name' => 'Genappe'),
      array('lat' => '50.5978', 'lng' => '4.4446', 'postal_code' => '1471', 'name' => 'Loupoigne'),
      array('lat' => '50.6083', 'lng' => '4.4406', 'postal_code' => '1472', 'name' => 'Vieux-Genappe'),
      array('lat' => '50.6303', 'lng' => '4.4533', 'postal_code' => '1473', 'name' => 'Glabais'),
      array('lat' => '50.6104', 'lng' => '4.4645', 'postal_code' => '1474', 'name' => 'Ways'),
      array('lat' => '50.5830', 'lng' => '4.4114', 'postal_code' => '1476', 'name' => 'Houtain-Le-Val'),
      array('lat' => '50.6921', 'lng' => '4.2216', 'postal_code' => '1480', 'name' => 'Clabecq'),
      array('lat' => '50.6699', 'lng' => '4.2199', 'postal_code' => '1480', 'name' => 'Oisquercq'),
      array('lat' => '50.7062', 'lng' => '4.1582', 'postal_code' => '1480', 'name' => 'Saintes'),
      array('lat' => '50.6905', 'lng' => '4.2026', 'postal_code' => '1480', 'name' => 'Tubize'),
      array('lat' => '50.6423', 'lng' => '4.5681', 'postal_code' => '1490', 'name' => 'Court-Saint-Etienne'),
      array('lat' => '50.5464', 'lng' => '4.5351', 'postal_code' => '1495', 'name' => 'Marbais'),
      array('lat' => '50.5817', 'lng' => '4.5689', 'postal_code' => '1495', 'name' => 'Mellery'),
      array('lat' => '50.5685', 'lng' => '4.4917', 'postal_code' => '1495', 'name' => 'Sart-Dames-Avelines'),
      array('lat' => '50.5614', 'lng' => '4.5490', 'postal_code' => '1495', 'name' => 'Tilly'),
      array('lat' => '50.5792', 'lng' => '4.5345', 'postal_code' => '1495', 'name' => 'Villers-La-Ville'),
    ],
    'WBR' => [
      array('lat' => '50.6948', 'lng' => '4.5754', 'postal_code' => '1300', 'name' => 'Limal'),
      array('lat' => '50.7114', 'lng' => '4.5866', 'postal_code' => '1301', 'name' => 'Bierges'),
      array('lat' => '50.7086', 'lng' => '4.7827', 'postal_code' => '1315', 'name' => 'Roux-Miroir'),
      array('lat' => '50.7309', 'lng' => '4.4858', 'postal_code' => '1310', 'name' => 'La Hulpe'),
      array('lat' => '50.6800', 'lng' => '4.7978', 'postal_code' => '1315', 'name' => 'Opprebais'),
      array('lat' => '50.7172', 'lng' => '4.6014', 'postal_code' => '1300', 'name' => 'Wavre'),
      array('lat' => '50.6800', 'lng' => '4.8371', 'postal_code' => '1315', 'name' => 'Glimes'),
      array('lat' => '50.6915', 'lng' => '4.7982', 'postal_code' => '1315', 'name' => 'Incourt'),
      array('lat' => '50.7830', 'lng' => '4.7444', 'postal_code' => '1320', 'name' => 'Tourinnes-La-Grosse'),
      array('lat' => '50.7728', 'lng' => '4.7369', 'postal_code' => '1320', 'name' => 'Nodebais'),
      array('lat' => '50.7820', 'lng' => '4.7718', 'postal_code' => '1320', 'name' => 'Beauvechain'),
      array('lat' => '50.7082', 'lng' => '4.6677', 'postal_code' => '1325', 'name' => 'Dion-Valmont'),
      array('lat' => '50.7730', 'lng' => '4.8314', 'postal_code' => '1320', 'name' => 'L\'Ecluse'),
      array('lat' => '50.6631', 'lng' => '4.6740', 'postal_code' => '1325', 'name' => 'Corroy-Le-Grand'),
      array('lat' => '50.7802', 'lng' => '4.7173', 'postal_code' => '1320', 'name' => 'Hamme-Mille'),
      array('lat' => '50.6775', 'lng' => '4.7212', 'postal_code' => '1325', 'name' => 'Chaumont-Gistoux'),
      array('lat' => '50.7024', 'lng' => '4.7401', 'postal_code' => '1325', 'name' => 'Longueville'),
      array('lat' => '50.7123', 'lng' => '4.5253', 'postal_code' => '1330', 'name' => 'Rixensart'),
      array('lat' => '50.7021', 'lng' => '4.6886', 'postal_code' => '1325', 'name' => 'Bonlez'),
      array('lat' => '50.7216', 'lng' => '4.4938', 'postal_code' => '1332', 'name' => 'Genval'),
      array('lat' => '50.7310', 'lng' => '4.5447', 'postal_code' => '1331', 'name' => 'Rosières'),
      array('lat' => '50.6671', 'lng' => '4.5502', 'postal_code' => '1340', 'name' => 'Ottignies-Louvain-La-Neuve'),
      array('lat' => '50.6609', 'lng' => '4.5207', 'postal_code' => '1341', 'name' => 'Céroux-Mousty'),
      array('lat' => '50.6653', 'lng' => '4.5668', 'postal_code' => '1340', 'name' => 'Ottignies'),
      array('lat' => '50.6683', 'lng' => '4.6144', 'postal_code' => '1348', 'name' => 'Louvain-La-Neuve'),
      array('lat' => '50.7033', 'lng' => '4.9891', 'postal_code' => '1350', 'name' => 'Orp-Le-Grand'),
      array('lat' => '50.6843', 'lng' => '4.5719', 'postal_code' => '1342', 'name' => 'Limelette'),
      array('lat' => '50.6612', 'lng' => '4.9378', 'postal_code' => '1350', 'name' => 'Folx-Les-Caves'),
      array('lat' => '50.7278', 'lng' => '4.7645', 'postal_code' => '1315', 'name' => 'Piétrebais'),
      array('lat' => '50.6718', 'lng' => '4.9780', 'postal_code' => '1350', 'name' => 'Jandrain-Jandrenouille'),
      array('lat' => '50.7286', 'lng' => '4.9678', 'postal_code' => '1350', 'name' => 'Noduwez'),
      array('lat' => '50.6839', 'lng' => '4.9493', 'postal_code' => '1350', 'name' => 'Orp-Jauche'),
      array('lat' => '50.7390', 'lng' => '4.6983', 'postal_code' => '1357', 'name' => 'Hélécine'),
      array('lat' => '50.7584', 'lng' => '4.9883', 'postal_code' => '1357', 'name' => 'Neerheylissem'),
      array('lat' => '50.7471', 'lng' => '4.9769', 'postal_code' => '1357', 'name' => 'Opheylissem'),
      array('lat' => '50.6943', 'lng' => '4.9269', 'postal_code' => '1350', 'name' => 'Enines'),
      array('lat' => '50.7072', 'lng' => '4.9527', 'postal_code' => '1350', 'name' => 'Marilles'),
      array('lat' => '50.7356', 'lng' => '4.9998', 'postal_code' => '1357', 'name' => 'Linsmeau'),
      array('lat' => '50.6388', 'lng' => '4.7947', 'postal_code' => '1360', 'name' => 'Malèves-Sainte-Marie-Wastinnes'),
      array('lat' => '50.6380', 'lng' => '4.7635', 'postal_code' => '1360', 'name' => 'Orbais'),
      array('lat' => '50.6243', 'lng' => '4.8135', 'postal_code' => '1360', 'name' => 'Perwez'),
      array('lat' => '50.6701', 'lng' => '4.8732', 'postal_code' => '1367', 'name' => 'Bomal'),
      array('lat' => '50.6814', 'lng' => '4.9556', 'postal_code' => '1350', 'name' => 'Jauche'),
      array('lat' => '50.6349', 'lng' => '4.7841', 'postal_code' => '1360', 'name' => 'Thorembais-Saint-Trond'),
      array('lat' => '50.6319', 'lng' => '4.8656', 'postal_code' => '1367', 'name' => 'Grand-Rosière-Hottomont'),
      array('lat' => '50.6582', 'lng' => '4.8175', 'postal_code' => '1360', 'name' => 'Thorembais-Les-Béguines'),
      array('lat' => '50.6563', 'lng' => '4.8661', 'postal_code' => '1367', 'name' => 'Mont-Saint-André'),
      array('lat' => '50.7246', 'lng' => '4.8262', 'postal_code' => '1370', 'name' => 'Lathuy'),
      array('lat' => '50.6692', 'lng' => '4.9038', 'postal_code' => '1367', 'name' => 'Autre-Eglise'),
      array('lat' => '50.6339', 'lng' => '4.9012', 'postal_code' => '1367', 'name' => 'Ramillies'),
      array('lat' => '50.6936', 'lng' => '4.8942', 'postal_code' => '1367', 'name' => 'Huppaye'),
      array('lat' => '50.6404', 'lng' => '4.8587', 'postal_code' => '1367', 'name' => 'Geest-Gérompont-Petit-Rosière'),
      array('lat' => '50.6481', 'lng' => '4.8814', 'postal_code' => '1367', 'name' => 'Gérompont'),
      array('lat' => '50.7400', 'lng' => '4.8288', 'postal_code' => '1370', 'name' => 'Mélin'),
      array('lat' => '50.7094', 'lng' => '4.8376', 'postal_code' => '1370', 'name' => 'Jodoigne-Souveraine'),
      array('lat' => '50.7236', 'lng' => '4.8691', 'postal_code' => '1370', 'name' => 'Jodoigne'),
      array('lat' => '50.6867', 'lng' => '4.8436', 'postal_code' => '1370', 'name' => 'Jauchelette'),
      array('lat' => '50.7469', 'lng' => '4.8585', 'postal_code' => '1370', 'name' => 'Saint-Remy-Geest'),
      array('lat' => '50.7401', 'lng' => '4.8965', 'postal_code' => '1370', 'name' => 'Saint-Jean-Geest'),
      array('lat' => '50.7253', 'lng' => '4.9203', 'postal_code' => '1370', 'name' => 'Piétrain'),
      array('lat' => '50.7571', 'lng' => '4.8871', 'postal_code' => '1370', 'name' => 'Zétrud-Lumay'),
      array('lat' => '50.7034', 'lng' => '4.8200', 'postal_code' => '1370', 'name' => 'Dongelberg'),
      array('lat' => '50.6930', 'lng' => '4.5010', 'postal_code' => '1380', 'name' => 'Lasne-Chapelle-Saint-Lambert'),
      array('lat' => '50.6875', 'lng' => '4.4816', 'postal_code' => '1380', 'name' => 'Lasne'),
      array('lat' => '50.6623', 'lng' => '4.4283', 'postal_code' => '1380', 'name' => 'Plancenoit'),
      array('lat' => '50.6597', 'lng' => '4.4669', 'postal_code' => '1380', 'name' => 'Maransart'),
      array('lat' => '50.7390', 'lng' => '4.6983', 'postal_code' => '1390', 'name' => 'Grez-Doiceau'),
      array('lat' => '50.6748', 'lng' => '4.4726', 'postal_code' => '1380', 'name' => 'Couture-Saint-Germain'),
      array('lat' => '50.7832', 'lng' => '4.6750', 'postal_code' => '1390', 'name' => 'Nethen'),
      array('lat' => '50.7237', 'lng' => '4.7136', 'postal_code' => '1390', 'name' => 'Biez'),
      array('lat' => '50.5982', 'lng' => '4.2894', 'postal_code' => '1400', 'name' => 'Monstreux'),
      array('lat' => '50.6988', 'lng' => '4.4698', 'postal_code' => '1380', 'name' => 'Ohain'),
      array('lat' => '50.5983', 'lng' => '4.3285', 'postal_code' => '1400', 'name' => 'Nivelles'),
      array('lat' => '50.7582', 'lng' => '4.6951', 'postal_code' => '1390', 'name' => 'Bossut-Gottechain'),
      array('lat' => '50.7526', 'lng' => '4.6696', 'postal_code' => '1390', 'name' => 'Archennes'),
      array('lat' => '50.7147', 'lng' => '4.3991', 'postal_code' => '1410', 'name' => 'Waterloo'),
      array('lat' => '50.6133', 'lng' => '4.3528', 'postal_code' => '1401', 'name' => 'Baulers'),
      array('lat' => '50.5968', 'lng' => '4.3690', 'postal_code' => '1402', 'name' => 'Thines'),
      array('lat' => '50.6836', 'lng' => '4.3678', 'postal_code' => '1420', 'name' => 'Braine-L\'Alleud'),
      array('lat' => '50.6665', 'lng' => '4.3487', 'postal_code' => '1421', 'name' => 'Ophain-Bois-Seigneur-Isaac'),
      array('lat' => '50.6019', 'lng' => '4.2765', 'postal_code' => '1404', 'name' => 'Bornival'),
      array('lat' => '50.6455', 'lng' => '4.3668', 'postal_code' => '1428', 'name' => 'Lillois-Witterzée'),
      array('lat' => '50.6696', 'lng' => '4.1566', 'postal_code' => '1430', 'name' => 'Quenast'),
      array('lat' => '50.6515', 'lng' => '4.1068', 'postal_code' => '1430', 'name' => 'Rebecq-Rognon'),
      array('lat' => '50.6343', 'lng' => '4.6106', 'postal_code' => '1435', 'name' => 'Mont-Saint-Guibert'),
      array('lat' => '50.6461', 'lng' => '4.6559', 'postal_code' => '1435', 'name' => 'Corbais'),
      array('lat' => '50.6233', 'lng' => '4.6173', 'postal_code' => '1435', 'name' => 'Hévillers'),
      array('lat' => '50.6818', 'lng' => '4.2985', 'postal_code' => '1440', 'name' => 'Wauthier-Braine'),
      array('lat' => '50.6660', 'lng' => '4.1320', 'postal_code' => '1430', 'name' => 'Rebecq'),
      array('lat' => '50.5784', 'lng' => '4.6070', 'postal_code' => '1450', 'name' => 'Gentinnes'),
      array('lat' => '50.5811', 'lng' => '4.6434', 'postal_code' => '1450', 'name' => 'Cortil-Noirmont'),
      array('lat' => '50.6799', 'lng' => '4.2739', 'postal_code' => '1440', 'name' => 'Braine-Le-Château'),
      array('lat' => '50.6086', 'lng' => '4.6420', 'postal_code' => '1450', 'name' => 'Chastre-Villeroux-Blanmont'),
      array('lat' => '50.6007', 'lng' => '4.6340', 'postal_code' => '1450', 'name' => 'Chastre'),
      array('lat' => '50.6958', 'lng' => '4.1192', 'postal_code' => '1430', 'name' => 'Bierghes'),
      array('lat' => '50.6402', 'lng' => '4.7236', 'postal_code' => '1457', 'name' => 'Tourinnes-Saint-Lambert'),
      array('lat' => '50.6263', 'lng' => '4.6984', 'postal_code' => '1457', 'name' => 'Walhain-Saint-Paul'),
      array('lat' => '50.5813', 'lng' => '4.6136', 'postal_code' => '1450', 'name' => 'Saint-Géry'),
      array('lat' => '50.6168', 'lng' => '4.6948', 'postal_code' => '1457', 'name' => 'Walhain'),
      array('lat' => '50.6404', 'lng' => '4.2058', 'postal_code' => '1460', 'name' => 'Virginal-Samme')
    ],
    'VAN' => [
      array('lat' => '51.3429', 'lng' => '4.3141', 'postal_code' => '2040', 'name' => 'Berendrecht'),
      array('lat' => '51.3044', 'lng' => '4.2803', 'postal_code' => '2040', 'name' => 'Lillo'),
      array('lat' => '51.3597', 'lng' => '4.3072', 'postal_code' => '2040', 'name' => 'Zandvliet'),
      array('lat' => '51.2269', 'lng' => '4.4276', 'postal_code' => '2060', 'name' => 'Antwerpen'),
      array('lat' => '51.2037', 'lng' => '4.3415', 'postal_code' => '2070', 'name' => 'Burcht'),
      array('lat' => '51.2164', 'lng' => '4.3336', 'postal_code' => '2070', 'name' => 'Zwijndrecht'),
      array('lat' => '51.2083', 'lng' => '4.4112', 'postal_code' => '2099', 'name' => 'Antwerpen X'),
      array('lat' => '51.2298', 'lng' => '4.5109', 'postal_code' => '2110', 'name' => 'Wijnegem'),
      array('lat' => '51.2143', 'lng' => '4.4349', 'postal_code' => '2140', 'name' => 'Borgerhout'),
      array('lat' => '51.1967', 'lng' => '4.4856', 'postal_code' => '2150', 'name' => 'Borsbeek'),
      array('lat' => '51.2022', 'lng' => '4.5220', 'postal_code' => '2160', 'name' => 'Wommelgem'),
      array('lat' => '51.2513', 'lng' => '4.4485', 'postal_code' => '2170', 'name' => 'Merksem'),
      array('lat' => '51.2807', 'lng' => '4.4184', 'postal_code' => '2180', 'name' => 'Ekeren'),
      array('lat' => '51.1769', 'lng' => '4.8356', 'postal_code' => '2200', 'name' => 'Herentals'),
      array('lat' => '51.1201', 'lng' => '4.8207', 'postal_code' => '2200', 'name' => 'Morkhoven'),
      array('lat' => '51.1394', 'lng' => '4.8388', 'postal_code' => '2200', 'name' => 'Noorderwijk'),
      array('lat' => '51.0846', 'lng' => '4.7329', 'postal_code' => '2220', 'name' => 'Hallaar'),
      array('lat' => '51.0634', 'lng' => '4.7211', 'postal_code' => '2220', 'name' => 'Heist-Op-Den-Berg'),
      array('lat' => '51.0515', 'lng' => '4.7752', 'postal_code' => '2221', 'name' => 'Booischot'),
      array('lat' => '51.1032', 'lng' => '4.7293', 'postal_code' => '2222', 'name' => 'Itegem'),
      array('lat' => '51.1091', 'lng' => '4.7945', 'postal_code' => '2222', 'name' => 'Wiekevorst'),
      array('lat' => '51.0275', 'lng' => '4.6927', 'postal_code' => '2223', 'name' => 'Schriek'),
      array('lat' => '51.0524', 'lng' => '4.8807', 'postal_code' => '2230', 'name' => 'Herselt'),
      array('lat' => '51.0321', 'lng' => '4.8328', 'postal_code' => '2230', 'name' => 'Ramsel'),
      array('lat' => '51.0421', 'lng' => '4.8089', 'postal_code' => '2235', 'name' => 'Houtvenne'),
      array('lat' => '51.0647', 'lng' => '4.8165', 'postal_code' => '2235', 'name' => 'Hulshout'),
      array('lat' => '51.0603', 'lng' => '4.8351', 'postal_code' => '2235', 'name' => 'Westmeerbeek'),
      array('lat' => '51.1986', 'lng' => '4.6364', 'postal_code' => '2240', 'name' => 'Massenhoven'),
      array('lat' => '51.1890', 'lng' => '4.6523', 'postal_code' => '2240', 'name' => 'Viersel'),
      array('lat' => '51.2022', 'lng' => '4.6554', 'postal_code' => '2240', 'name' => 'Zandhoven'),
      array('lat' => '51.2166', 'lng' => '4.6919', 'postal_code' => '2242', 'name' => 'Pulderbos'),
      array('lat' => '51.2033', 'lng' => '4.7137', 'postal_code' => '2243', 'name' => 'Pulle'),
      array('lat' => '51.1440', 'lng' => '4.8599', 'postal_code' => '2250', 'name' => 'Olen'),
      array('lat' => '51.1387', 'lng' => '4.9043', 'postal_code' => '2260', 'name' => 'Oevel'),
      array('lat' => '51.0900', 'lng' => '4.9143', 'postal_code' => '2260', 'name' => 'Westerlo'),
      array('lat' => '51.0888', 'lng' => '4.8689', 'postal_code' => '2260', 'name' => 'Zoerle-Parwijs'),
      array('lat' => '51.1395', 'lng' => '4.7565', 'postal_code' => '2270', 'name' => 'Herenthout'),
      array('lat' => '51.2672', 'lng' => '4.8677', 'postal_code' => '2275', 'name' => 'Gierle'),
      array('lat' => '51.2420', 'lng' => '4.8232', 'postal_code' => '2275', 'name' => 'Lille'),
      array('lat' => '51.2263', 'lng' => '4.8353', 'postal_code' => '2275', 'name' => 'Poederlee'),
      array('lat' => '51.2645', 'lng' => '4.7999', 'postal_code' => '2275', 'name' => 'Wechelderzande'),
      array('lat' => '51.1833', 'lng' => '4.7350', 'postal_code' => '2280', 'name' => 'Grobbendonk'),
      array('lat' => '51.1720', 'lng' => '4.7421', 'postal_code' => '2288', 'name' => 'Bouwel'),
      array('lat' => '51.2025', 'lng' => '4.7709', 'postal_code' => '2290', 'name' => 'Vorselaar'),
      array('lat' => '51.3217', 'lng' => '4.9376', 'postal_code' => '2300', 'name' => 'Turnhout'),
      array('lat' => '51.3481', 'lng' => '4.7605', 'postal_code' => '2310', 'name' => 'Rijkevorsel'),
      array('lat' => '51.4033', 'lng' => '4.7468', 'postal_code' => '2320', 'name' => 'Hoogstraten'),
      array('lat' => '51.4456', 'lng' => '4.7383', 'postal_code' => '2321', 'name' => 'Meer'),
      array('lat' => '51.4165', 'lng' => '4.7634', 'postal_code' => '2322', 'name' => 'Minderhout'),
      array('lat' => '51.3975', 'lng' => '4.7948', 'postal_code' => '2323', 'name' => 'Wortel'),
      array('lat' => '51.4734', 'lng' => '4.8038', 'postal_code' => '2328', 'name' => 'Meerle'),
      array('lat' => '51.3582', 'lng' => '4.8636', 'postal_code' => '2330', 'name' => 'Merksplas'),
      array('lat' => '51.3195', 'lng' => '4.8548', 'postal_code' => '2340', 'name' => 'Beerse'),
      array('lat' => '51.2971', 'lng' => '4.7820', 'postal_code' => '2340', 'name' => 'Vlimmeren'),
      array('lat' => '51.3031', 'lng' => '4.8834', 'postal_code' => '2350', 'name' => 'Vosselaar'),
      array('lat' => '51.3178', 'lng' => '4.9828', 'postal_code' => '2360', 'name' => 'Oud-Turnhout'),
      array('lat' => '51.3220', 'lng' => '5.0863', 'postal_code' => '2370', 'name' => 'Arendonk'),
      array('lat' => '51.3762', 'lng' => '5.0186', 'postal_code' => '2380', 'name' => 'Ravels'),
      array('lat' => '51.4068', 'lng' => '4.9908', 'postal_code' => '2381', 'name' => 'Weelde'),
      array('lat' => '51.4472', 'lng' => '5.0432', 'postal_code' => '2382', 'name' => 'Poppel'),
      array('lat' => '51.4418', 'lng' => '4.9317', 'postal_code' => '2387', 'name' => 'Baarle-Hertog'),
      array('lat' => '51.2968', 'lng' => '4.6943', 'postal_code' => '2390', 'name' => 'Malle'),
      array('lat' => '51.3011', 'lng' => '4.7338', 'postal_code' => '2390', 'name' => 'Oostmalle'),
      array('lat' => '51.2968', 'lng' => '4.6943', 'postal_code' => '2390', 'name' => 'Westmalle'),
      array('lat' => '51.1911', 'lng' => '5.1171', 'postal_code' => '2400', 'name' => 'Mol'),
      array('lat' => '51.1033', 'lng' => '4.9997', 'postal_code' => '2430', 'name' => 'Eindhout'),
      array('lat' => '51.0874', 'lng' => '5.0243', 'postal_code' => '2430', 'name' => 'Laakdal'),
      array('lat' => '51.0797', 'lng' => '5.0202', 'postal_code' => '2430', 'name' => 'Vorst'),
      array('lat' => '51.0840', 'lng' => '4.9513', 'postal_code' => '2431', 'name' => 'Varendonk'),
      array('lat' => '51.0699', 'lng' => '4.9872', 'postal_code' => '2431', 'name' => 'Veerle'),
      array('lat' => '51.1626', 'lng' => '4.9908', 'postal_code' => '2440', 'name' => 'Geel'),
      array('lat' => '51.1322', 'lng' => '5.0771', 'postal_code' => '2450', 'name' => 'Meerhout'),
      array('lat' => '51.2405', 'lng' => '4.9674', 'postal_code' => '2460', 'name' => 'Kasterlee'),
      array('lat' => '51.2197', 'lng' => '4.9108', 'postal_code' => '2460', 'name' => 'Lichtaart'),
      array('lat' => '51.2435', 'lng' => '4.8977', 'postal_code' => '2460', 'name' => 'Tielen'),
      array('lat' => '51.2670', 'lng' => '5.0843', 'postal_code' => '2470', 'name' => 'Retie'),
      array('lat' => '51.2399', 'lng' => '5.1127', 'postal_code' => '2480', 'name' => 'Dessel'),
      array('lat' => '51.1578', 'lng' => '5.2101', 'postal_code' => '2490', 'name' => 'Balen'),
      array('lat' => '51.1421', 'lng' => '5.1507', 'postal_code' => '2491', 'name' => 'Olmen'),
      array('lat' => '51.0952', 'lng' => '4.6101', 'postal_code' => '2500', 'name' => 'Koningshooikt'),
      array('lat' => '51.1302', 'lng' => '4.5715', 'postal_code' => '2500', 'name' => 'Lier'),
      array('lat' => '51.1813', 'lng' => '4.6020', 'postal_code' => '2520', 'name' => 'Broechem'),
      array('lat' => '51.1620', 'lng' => '4.6051', 'postal_code' => '2520', 'name' => 'Emblem'),
      array('lat' => '51.2130', 'lng' => '4.5997', 'postal_code' => '2520', 'name' => 'Oelegem'),
      array('lat' => '51.1891', 'lng' => '4.5609', 'postal_code' => '2520', 'name' => 'Ranst'),
      array('lat' => '51.1664', 'lng' => '4.4972', 'postal_code' => '2530', 'name' => 'Boechout'),
      array('lat' => '51.1749', 'lng' => '4.5231', 'postal_code' => '2531', 'name' => 'Vremde'),
      array('lat' => '51.1540', 'lng' => '4.4712', 'postal_code' => '2540', 'name' => 'Hove'),
      array('lat' => '51.1272', 'lng' => '4.4967', 'postal_code' => '2547', 'name' => 'Lint'),
      array('lat' => '51.1352', 'lng' => '4.4448', 'postal_code' => '2550', 'name' => 'Kontich'),
      array('lat' => '51.1051', 'lng' => '4.4547', 'postal_code' => '2550', 'name' => 'Waarloos'),
      array('lat' => '51.1377', 'lng' => '4.6804', 'postal_code' => '2560', 'name' => 'Bevel'),
      array('lat' => '51.1392', 'lng' => '4.6297', 'postal_code' => '2560', 'name' => 'Kessel'),
      array('lat' => '51.1614', 'lng' => '4.6706', 'postal_code' => '2560', 'name' => 'Nijlen'),
      array('lat' => '51.0954', 'lng' => '4.5052', 'postal_code' => '2570', 'name' => 'Duffel'),
      array('lat' => '51.0579', 'lng' => '4.6676', 'postal_code' => '2580', 'name' => 'Beerzel'),
      array('lat' => '51.0548', 'lng' => '4.6287', 'postal_code' => '2580', 'name' => 'Putte'),
      array('lat' => '51.1180', 'lng' => '4.6575', 'postal_code' => '2590', 'name' => 'Berlaar'),
      array('lat' => '51.1284', 'lng' => '4.6732', 'postal_code' => '2590', 'name' => 'Gestel'),
      array('lat' => '51.1683', 'lng' => '4.3943', 'postal_code' => '2610', 'name' => 'Wilrijk'),
      array('lat' => '51.1452', 'lng' => '4.3383', 'postal_code' => '2620', 'name' => 'Hemiksem'),
      array('lat' => '51.1269', 'lng' => '4.3388', 'postal_code' => '2627', 'name' => 'Schelle'),
      array('lat' => '51.1341', 'lng' => '4.3845', 'postal_code' => '2630', 'name' => 'Aartselaar'),
      array('lat' => '51.1729', 'lng' => '4.4665', 'postal_code' => '2640', 'name' => 'Mortsel'),
      array('lat' => '51.1560', 'lng' => '4.4319', 'postal_code' => '2650', 'name' => 'Edegem'),
      array('lat' => '51.1776', 'lng' => '4.3499', 'postal_code' => '2660', 'name' => 'Hoboken'),
      array('lat' => '51.0259', 'lng' => '4.4775', 'postal_code' => '2800', 'name' => 'Mechelen'),
      array('lat' => '51.0677', 'lng' => '4.4572', 'postal_code' => '2800', 'name' => 'Walem'),
      array('lat' => '51.0469', 'lng' => '4.4137', 'postal_code' => '2801', 'name' => 'Heffen'),
      array('lat' => '51.0144', 'lng' => '4.4428', 'postal_code' => '2811', 'name' => 'Hombeek'),
      array('lat' => '51.0329', 'lng' => '4.4177', 'postal_code' => '2811', 'name' => 'Leest'),
      array('lat' => '51.0222', 'lng' => '4.5480', 'postal_code' => '2820', 'name' => 'Bonheiden'),
      array('lat' => '51.0038', 'lng' => '4.5903', 'postal_code' => '2820', 'name' => 'Rijmenam'),
      array('lat' => '51.0558', 'lng' => '4.3772', 'postal_code' => '2830', 'name' => 'Blaasveld'),
      array('lat' => '51.0673', 'lng' => '4.4076', 'postal_code' => '2830', 'name' => 'Heindonk'),
      array('lat' => '51.0344', 'lng' => '4.3572', 'postal_code' => '2830', 'name' => 'Tisselt'),
      array('lat' => '51.0598', 'lng' => '4.3641', 'postal_code' => '2830', 'name' => 'Willebroek'),
      array('lat' => '51.1011', 'lng' => '4.4126', 'postal_code' => '2840', 'name' => 'Reet'),
      array('lat' => '51.0804', 'lng' => '4.4218', 'postal_code' => '2840', 'name' => 'Rumst'),
      array('lat' => '51.0792', 'lng' => '4.3993', 'postal_code' => '2840', 'name' => 'Terhagen'),
      array('lat' => '51.1106', 'lng' => '4.3321', 'postal_code' => '2845', 'name' => 'Niel'),
      array('lat' => '51.0861', 'lng' => '4.3663', 'postal_code' => '2850', 'name' => 'Boom'),
      array('lat' => '51.0614', 'lng' => '4.5056', 'postal_code' => '2860', 'name' => 'Sint-Katelijne-Waver'),
      array('lat' => '51.0619', 'lng' => '4.5787', 'postal_code' => '2861', 'name' => 'Onze-Lieve-Vrouw-Waver'),
      array('lat' => '51.0431', 'lng' => '4.3220', 'postal_code' => '2870', 'name' => 'Breendonk'),
      array('lat' => '51.0608', 'lng' => '4.2802', 'postal_code' => '2870', 'name' => 'Liezele'),
      array('lat' => '51.0556', 'lng' => '4.2539', 'postal_code' => '2870,2890', 'name' => 'Puurs-Sint-Amands'),
      array('lat' => '51.0880', 'lng' => '4.3311', 'postal_code' => '2870', 'name' => 'Ruisbroek'),
      array('lat' => '51.0996', 'lng' => '4.2405', 'postal_code' => '2880', 'name' => 'Bornem'),
      array('lat' => '51.1033', 'lng' => '4.2688', 'postal_code' => '2880', 'name' => 'Hingene'),
      array('lat' => '51.0635', 'lng' => '4.1923', 'postal_code' => '2880', 'name' => 'Mariekerke'),
      array('lat' => '51.1034', 'lng' => '4.1901', 'postal_code' => '2880', 'name' => 'Weert'),
      array('lat' => '51.0422', 'lng' => '4.2586', 'postal_code' => '2890', 'name' => 'Lippelo'),
      array('lat' => '51.0661', 'lng' => '4.2420', 'postal_code' => '2890', 'name' => 'Oppuurs'),
      array('lat' => '51.2498', 'lng' => '4.4977', 'postal_code' => '2900', 'name' => 'Schoten'),
      array('lat' => '51.4678', 'lng' => '4.4684', 'postal_code' => '2910', 'name' => 'Essen'),
      array('lat' => '51.3830', 'lng' => '4.4752', 'postal_code' => '2920', 'name' => 'Kalmthout'),
      array('lat' => '51.2923', 'lng' => '4.4942', 'postal_code' => '2930', 'name' => 'Brasschaat'),
      array('lat' => '51.3062', 'lng' => '4.4047', 'postal_code' => '2940', 'name' => 'Hoevenen'),
      array('lat' => '51.3347', 'lng' => '4.3717', 'postal_code' => '2940', 'name' => 'Stabroek'),
      array('lat' => '51.3497', 'lng' => '4.6377', 'postal_code' => '2960', 'name' => 'Brecht'),
      array('lat' => '51.2983', 'lng' => '4.5732', 'postal_code' => '2960', 'name' => 'Sint-Job-In-\'t-Goor'),
      array('lat' => '51.3487', 'lng' => '4.6770', 'postal_code' => '2960', 'name' => 'Sint-Lenaarts'),
      array('lat' => '51.2629', 'lng' => '4.5610', 'postal_code' => '2970', 'name' => '\'s Gravenwezel'),
      array('lat' => '51.2407', 'lng' => '4.5834', 'postal_code' => '2970', 'name' => 'Schilde'),
      array('lat' => '51.2398', 'lng' => '4.6465', 'postal_code' => '2980', 'name' => 'Halle'),
      array('lat' => '51.2682', 'lng' => '4.7126', 'postal_code' => '2980', 'name' => 'Zoersel'),
      array('lat' => '51.3990', 'lng' => '4.6432', 'postal_code' => '2990', 'name' => 'Loenhout'),
      array('lat' => '51.3894', 'lng' => '4.5912', 'postal_code' => '2990', 'name' => 'Wuustwezel'),
    ],
    'VLI' => [
      array('lat' => '50.9215', 'lng' => '5.3447', 'postal_code' => '3500', 'name' => 'Hasselt'),
      array('lat' => '50.8984', 'lng' => '5.3074', 'postal_code' => '3500', 'name' => 'Sint-Lambrechts-Herk'),
      array('lat' => '50.8832', 'lng' => '5.3526', 'postal_code' => '3501', 'name' => 'Wimmertingen'),
      array('lat' => '50.9477', 'lng' => '5.2468', 'postal_code' => '3510', 'name' => 'Kermt'),
      array('lat' => '50.9487', 'lng' => '5.2247', 'postal_code' => '3510', 'name' => 'Spalbeek'),
      array('lat' => '50.9439', 'lng' => '5.2979', 'postal_code' => '3511', 'name' => 'Kuringen'),
      array('lat' => '50.9662', 'lng' => '5.2813', 'postal_code' => '3511', 'name' => 'Stokrooie'),
      array('lat' => '50.9183', 'lng' => '5.2532', 'postal_code' => '3512', 'name' => 'Stevoort'),
      array('lat' => '50.9871', 'lng' => '5.3672', 'postal_code' => '3520', 'name' => 'Zonhoven'),
      array('lat' => '51.0566', 'lng' => '5.3827', 'postal_code' => '3530', 'name' => 'Helchteren'),
      array('lat' => '51.0315', 'lng' => '5.3764', 'postal_code' => '3530', 'name' => 'Houthalen'),
      array('lat' => '51.0312', 'lng' => '5.3765', 'postal_code' => '3530', 'name' => 'Houthalen-Helchteren'),
      array('lat' => '50.9503', 'lng' => '5.2083', 'postal_code' => '3540', 'name' => 'Berbroek'),
      array('lat' => '50.9382', 'lng' => '5.1344', 'postal_code' => '3540', 'name' => 'Donk'),
      array('lat' => '50.9392', 'lng' => '5.1671', 'postal_code' => '3540', 'name' => 'Herk-De-Stad'),
      array('lat' => '50.9600', 'lng' => '5.1905', 'postal_code' => '3540', 'name' => 'Schulen'),
      array('lat' => '50.9485', 'lng' => '5.1112', 'postal_code' => '3545', 'name' => 'Halen'),
      array('lat' => '50.9343', 'lng' => '5.0696', 'postal_code' => '3545', 'name' => 'Loksbergen'),
      array('lat' => '50.9782', 'lng' => '5.1058', 'postal_code' => '3545', 'name' => 'Zelem'),
      array('lat' => '51.0385', 'lng' => '5.2904', 'postal_code' => '3550', 'name' => 'Heusden-Zolder'),
      array('lat' => '51.0230', 'lng' => '5.3097', 'postal_code' => '3550', 'name' => 'Zolder'),
      array('lat' => '50.9681', 'lng' => '5.1369', 'postal_code' => '3560', 'name' => 'Linkhout'),
      array('lat' => '50.9876', 'lng' => '5.1951', 'postal_code' => '3560', 'name' => 'Lummen'),
      array('lat' => '50.8761', 'lng' => '5.3077', 'postal_code' => '3570', 'name' => 'Alken'),
      array('lat' => '51.0473', 'lng' => '5.2215', 'postal_code' => '3580', 'name' => 'Beringen'),
      array('lat' => '51.0873', 'lng' => '5.2190', 'postal_code' => '3581', 'name' => 'Beverlo'),
      array('lat' => '51.0584', 'lng' => '5.2718', 'postal_code' => '3582', 'name' => 'Koersel'),
      array('lat' => '51.0395', 'lng' => '5.1717', 'postal_code' => '3583', 'name' => 'Paal'),
      array('lat' => '50.9108', 'lng' => '5.4134', 'postal_code' => '3590', 'name' => 'Diepenbeek'),
      array('lat' => '50.9661', 'lng' => '5.5021', 'postal_code' => '3600', 'name' => 'Genk'),
      array('lat' => '50.8839', 'lng' => '5.6103', 'postal_code' => '3620', 'name' => 'Gellik'),
      array('lat' => '50.8920', 'lng' => '5.6399', 'postal_code' => '3620', 'name' => 'Lanaken'),
      array('lat' => '50.9089', 'lng' => '5.6808', 'postal_code' => '3620', 'name' => 'Neerharen'),
      array('lat' => '50.8678', 'lng' => '5.6306', 'postal_code' => '3620', 'name' => 'Veldwezelt'),
      array('lat' => '50.9225', 'lng' => '5.6957', 'postal_code' => '3621', 'name' => 'Rekem'),
      array('lat' => '50.9855', 'lng' => '5.7141', 'postal_code' => '3630', 'name' => 'Eisden'),
      array('lat' => '50.9900', 'lng' => '5.7351', 'postal_code' => '3630', 'name' => 'Leut'),
      array('lat' => '50.9693', 'lng' => '5.6619', 'postal_code' => '3630', 'name' => 'Maasmechelen'),
      array('lat' => '50.9798', 'lng' => '5.7019', 'postal_code' => '3630', 'name' => 'Mechelen-Aan-De-Maas'),
      array('lat' => '50.9995', 'lng' => '5.7497', 'postal_code' => '3630', 'name' => 'Meeswijk'),
      array('lat' => '50.9433', 'lng' => '5.6810', 'postal_code' => '3630', 'name' => 'Opgrimbie'),
      array('lat' => '50.9787', 'lng' => '5.7107', 'postal_code' => '3630', 'name' => 'Vucht'),
      array('lat' => '50.9408', 'lng' => '5.7198', 'postal_code' => '3631', 'name' => 'Boorsem'),
      array('lat' => '50.9237', 'lng' => '5.7183', 'postal_code' => '3631', 'name' => 'Uikhoven'),
      array('lat' => '51.1514', 'lng' => '5.8230', 'postal_code' => '3640', 'name' => 'Kessenich'),
      array('lat' => '51.1455', 'lng' => '5.7411', 'postal_code' => '3640', 'name' => 'Kinrooi'),
      array('lat' => '51.1700', 'lng' => '5.7376', 'postal_code' => '3640', 'name' => 'Molenbeersel'),
      array('lat' => '51.1256', 'lng' => '5.8020', 'postal_code' => '3640', 'name' => 'Ophoven'),
      array('lat' => '51.0375', 'lng' => '5.7222', 'postal_code' => '3650', 'name' => 'Dilsen'),
      array('lat' => '51.0302', 'lng' => '5.7001', 'postal_code' => '3650', 'name' => 'Dilsen-Stokkem'),
      array('lat' => '51.0666', 'lng' => '5.7508', 'postal_code' => '3650', 'name' => 'Elen'),
      array('lat' => '51.0188', 'lng' => '5.7262', 'postal_code' => '3650', 'name' => 'Lanklaar'),
      array('lat' => '51.0530', 'lng' => '5.7412', 'postal_code' => '3650', 'name' => 'Rotem'),
      array('lat' => '51.0236', 'lng' => '5.7442', 'postal_code' => '3650', 'name' => 'Stokkem'),
      array('lat' => '51.0500', 'lng' => '5.6000', 'postal_code' => '3660,3670', 'name' => 'Oudsbergen'),
      array('lat' => '50.9998', 'lng' => '5.5715', 'postal_code' => '3665', 'name' => 'As'),
      array('lat' => '51.0176', 'lng' => '5.6045', 'postal_code' => '3668', 'name' => 'Niel-Bij-As'),
      array('lat' => '51.1272', 'lng' => '5.5237', 'postal_code' => '3670', 'name' => 'Ellikom'),
      array('lat' => '51.0987', 'lng' => '5.5205', 'postal_code' => '3670', 'name' => 'Meeuwen'),
      array('lat' => '51.0950', 'lng' => '5.5478', 'postal_code' => '3670', 'name' => 'Meeuwen-Gruitrode'),
      array('lat' => '51.0914', 'lng' => '5.6168', 'postal_code' => '3670', 'name' => 'Neerglabbeek'),
      array('lat' => '51.1046', 'lng' => '5.5588', 'postal_code' => '3670', 'name' => 'Wijshagen'),
      array('lat' => '51.0984', 'lng' => '5.7838', 'postal_code' => '3680', 'name' => 'Maaseik'),
      array('lat' => '51.0918', 'lng' => '5.6995', 'postal_code' => '3680', 'name' => 'Neeroeteren'),
      array('lat' => '51.0676', 'lng' => '5.6594', 'postal_code' => '3680', 'name' => 'Opoeteren'),
      array('lat' => '50.9320', 'lng' => '5.5723', 'postal_code' => '3690', 'name' => 'Zutendaal'),
      array('lat' => '50.8089', 'lng' => '5.5033', 'postal_code' => '3700', 'name' => '\'s Herenelderen'),
      array('lat' => '50.7918', 'lng' => '5.4949', 'postal_code' => '3700', 'name' => 'Berg'),
      array('lat' => '50.7453', 'lng' => '5.4828', 'postal_code' => '3700', 'name' => 'Diets-Heur'),
      array('lat' => '50.7992', 'lng' => '5.4712', 'postal_code' => '3700', 'name' => 'Henis'),
      array('lat' => '50.7653', 'lng' => '5.4400', 'postal_code' => '3700', 'name' => 'Koninksem'),
      array('lat' => '50.7392', 'lng' => '5.4149', 'postal_code' => '3700', 'name' => 'Lauw'),
      array('lat' => '50.7685', 'lng' => '5.5215', 'postal_code' => '3700', 'name' => 'Mal'),
      array('lat' => '50.8110', 'lng' => '5.4442', 'postal_code' => '3700', 'name' => 'Neerrepen'),
      array('lat' => '50.7650', 'lng' => '5.5105', 'postal_code' => '3700', 'name' => 'Nerem'),
      array('lat' => '50.8070', 'lng' => '5.4316', 'postal_code' => '3700', 'name' => 'Overrepen'),
      array('lat' => '50.7864', 'lng' => '5.4179', 'postal_code' => '3700', 'name' => 'Piringen'),
      array('lat' => '50.8051', 'lng' => '5.4633', 'postal_code' => '3700', 'name' => 'Riksingen'),
      array('lat' => '50.7479', 'lng' => '5.4424', 'postal_code' => '3700', 'name' => 'Rutten'),
      array('lat' => '50.7653', 'lng' => '5.5314', 'postal_code' => '3700', 'name' => 'Sluizen'),
      array('lat' => '50.7842', 'lng' => '5.4745', 'postal_code' => '3700', 'name' => 'Tongeren'),
      array('lat' => '50.7516', 'lng' => '5.4975', 'postal_code' => '3700', 'name' => 'Vreren'),
      array('lat' => '50.7714', 'lng' => '5.4084', 'postal_code' => '3700', 'name' => 'Widooie'),
      array('lat' => '50.7265', 'lng' => '5.4260', 'postal_code' => '3717', 'name' => 'Herstappe'),
      array('lat' => '50.8626', 'lng' => '5.3781', 'postal_code' => '3720', 'name' => 'Kortessem'),
      array('lat' => '50.8638', 'lng' => '5.4240', 'postal_code' => '3721', 'name' => 'Vliermaalroot'),
      array('lat' => '50.8526', 'lng' => '5.4197', 'postal_code' => '3722', 'name' => 'Wintershoven'),
      array('lat' => '50.8391', 'lng' => '5.3992', 'postal_code' => '3723', 'name' => 'Guigoven'),
      array('lat' => '50.8395', 'lng' => '5.4289', 'postal_code' => '3724', 'name' => 'Vliermaal'),
      array('lat' => '50.8497', 'lng' => '5.4911', 'postal_code' => '3730', 'name' => 'Hoeselt'),
      array('lat' => '50.8560', 'lng' => '5.4599', 'postal_code' => '3730', 'name' => 'Romershoven'),
      array('lat' => '50.8299', 'lng' => '5.4492', 'postal_code' => '3730', 'name' => 'Sint-Huibrechts-Hern'),
      array('lat' => '50.8328', 'lng' => '5.4803', 'postal_code' => '3730', 'name' => 'Werm'),
      array('lat' => '50.8414', 'lng' => '5.4496', 'postal_code' => '3732', 'name' => 'Schalkhoven'),
      array('lat' => '50.8902', 'lng' => '5.4752', 'postal_code' => '3740', 'name' => 'Beverst'),
      array('lat' => '50.8719', 'lng' => '5.5166', 'postal_code' => '3740', 'name' => 'Bilzen'),
      array('lat' => '50.8746', 'lng' => '5.5746', 'postal_code' => '3740', 'name' => 'Eigenbilzen'),
      array('lat' => '50.8316', 'lng' => '5.5520', 'postal_code' => '3740', 'name' => 'Grote-Spouwen'),
      array('lat' => '50.8466', 'lng' => '5.6094', 'postal_code' => '3740', 'name' => 'Hees'),
      array('lat' => '50.8381', 'lng' => '5.5484', 'postal_code' => '3740', 'name' => 'Kleine-Spouwen'),
      array('lat' => '50.8606', 'lng' => '5.5756', 'postal_code' => '3740', 'name' => 'Mopertingen'),
      array('lat' => '50.8897', 'lng' => '5.5262', 'postal_code' => '3740', 'name' => 'Munsterbilzen'),
      array('lat' => '50.8330', 'lng' => '5.5151', 'postal_code' => '3740', 'name' => 'Rijkhoven'),
      array('lat' => '50.8457', 'lng' => '5.5806', 'postal_code' => '3740', 'name' => 'Rosmeer'),
      array('lat' => '50.8658', 'lng' => '5.5442', 'postal_code' => '3740', 'name' => 'Waltwilder'),
      array('lat' => '50.8566', 'lng' => '5.5332', 'postal_code' => '3742', 'name' => 'Martenslinde'),
      array('lat' => '50.8719', 'lng' => '5.5565', 'postal_code' => '3746', 'name' => 'Hoelbeek'),
      array('lat' => '50.8030', 'lng' => '5.5388', 'postal_code' => '3770', 'name' => 'Genoelselderen'),
      array('lat' => '50.8066', 'lng' => '5.5723', 'postal_code' => '3770', 'name' => 'Herderen'),
      array('lat' => '50.8141', 'lng' => '5.6693', 'postal_code' => '3770', 'name' => 'Kanne'),
      array('lat' => '50.8142', 'lng' => '5.5343', 'postal_code' => '3770', 'name' => 'Membruggen'),
      array('lat' => '50.7856', 'lng' => '5.5561', 'postal_code' => '3770', 'name' => 'Millen'),
      array('lat' => '50.8090', 'lng' => '5.6012', 'postal_code' => '3770', 'name' => 'Riemst'),
      array('lat' => '50.7862', 'lng' => '5.5963', 'postal_code' => '3770', 'name' => 'Val-Meer'),
      array('lat' => '50.8321', 'lng' => '5.5843', 'postal_code' => '3770', 'name' => 'Vlijtingen'),
      array('lat' => '50.8263', 'lng' => '5.6400', 'postal_code' => '3770', 'name' => 'Vroenhoven'),
      array('lat' => '50.7933', 'lng' => '5.6246', 'postal_code' => '3770', 'name' => 'Zichen-Zussen-Bolder'),
      array('lat' => '50.7570', 'lng' => '5.7135', 'postal_code' => '3790', 'name' => 'Moelingen'),
      array('lat' => '50.7485', 'lng' => '5.8122', 'postal_code' => '3790', 'name' => 'Sint-Martens-Voeren'),
      array('lat' => '50.7464', 'lng' => '5.8409', 'postal_code' => '3790', 'name' => 'Voeren'),
      array('lat' => '50.7315', 'lng' => '5.8808', 'postal_code' => '3791', 'name' => 'Remersdaal'),
      array('lat' => '50.7384', 'lng' => '5.8227', 'postal_code' => '3792', 'name' => 'Sint-Pieters-Voeren'),
      array('lat' => '50.7518', 'lng' => '5.8760', 'postal_code' => '3793', 'name' => 'Teuven'),
      array('lat' => '50.7588', 'lng' => '5.7612', 'postal_code' => '3798', 'name' => 'S Gravenvoeren'),
      array('lat' => '50.8057', 'lng' => '5.2219', 'postal_code' => '3800', 'name' => 'Brustem'),
      array('lat' => '50.7713', 'lng' => '5.2509', 'postal_code' => '3800', 'name' => 'Engelmanshoven'),
      array('lat' => '50.7655', 'lng' => '5.2609', 'postal_code' => '3800', 'name' => 'Gelinden'),
      array('lat' => '50.7853', 'lng' => '5.2630', 'postal_code' => '3800', 'name' => 'Groot-Gelmen'),
      array('lat' => '50.8059', 'lng' => '5.1557', 'postal_code' => '3800', 'name' => 'Halmaal'),
      array('lat' => '50.7743', 'lng' => '5.1779', 'postal_code' => '3800', 'name' => 'Kerkom-Bij-Sint-Truiden'),
      array('lat' => '50.8129', 'lng' => '5.2352', 'postal_code' => '3800', 'name' => 'Ordingen'),
      array('lat' => '50.8019', 'lng' => '5.2203', 'postal_code' => '3800', 'name' => 'Sint-Truiden'),
      array('lat' => '50.8212', 'lng' => '5.2477', 'postal_code' => '3800', 'name' => 'Zepperen'),
      array('lat' => '50.8355', 'lng' => '5.1464', 'postal_code' => '3803', 'name' => 'Duras'),
      array('lat' => '50.8348', 'lng' => '5.1620', 'postal_code' => '3803', 'name' => 'Gorsem'),
      array('lat' => '50.8468', 'lng' => '5.1509', 'postal_code' => '3803', 'name' => 'Runkelen'),
      array('lat' => '50.8159', 'lng' => '5.1414', 'postal_code' => '3803', 'name' => 'Wilderen'),
      array('lat' => '50.7793', 'lng' => '5.1316', 'postal_code' => '3806', 'name' => 'Velm'),
      array('lat' => '50.8197', 'lng' => '5.3112', 'postal_code' => '3830', 'name' => 'Berlingen'),
      array('lat' => '50.8436', 'lng' => '5.3362', 'postal_code' => '3830', 'name' => 'Wellen'),
      array('lat' => '50.8321', 'lng' => '5.3321', 'postal_code' => '3831', 'name' => 'Herten'),
      array('lat' => '50.8438', 'lng' => '5.3047', 'postal_code' => '3832', 'name' => 'Ulbeek'),
      array('lat' => '50.7880', 'lng' => '5.3790', 'postal_code' => '3840', 'name' => 'Bommershoven'),
      array('lat' => '50.8061', 'lng' => '5.3430', 'postal_code' => '3840', 'name' => 'Borgloon'),
      array('lat' => '50.7824', 'lng' => '5.3318', 'postal_code' => '3840', 'name' => 'Broekom'),
      array('lat' => '50.8234', 'lng' => '5.3967', 'postal_code' => '3840', 'name' => 'Gors-Opleeuw'),
      array('lat' => '50.8052', 'lng' => '5.3135', 'postal_code' => '3840', 'name' => 'Gotem'),
      array('lat' => '50.7925', 'lng' => '5.3634', 'postal_code' => '3840', 'name' => 'Groot-Loon'),
      array('lat' => '50.7927', 'lng' => '5.3995', 'postal_code' => '3840', 'name' => 'Haren'),
      array('lat' => '50.7989', 'lng' => '5.3281', 'postal_code' => '3840', 'name' => 'Hendrieken'),
      array('lat' => '50.8124', 'lng' => '5.2837', 'postal_code' => '3840', 'name' => 'Hoepertingen'),
      array('lat' => '50.8059', 'lng' => '5.3899', 'postal_code' => '3840', 'name' => 'Jesseren'),
      array('lat' => '50.8163', 'lng' => '5.3637', 'postal_code' => '3840', 'name' => 'Kerniel'),
      array('lat' => '50.8031', 'lng' => '5.4231', 'postal_code' => '3840', 'name' => 'Kolmont'),
      array('lat' => '50.8090', 'lng' => '5.3260', 'postal_code' => '3840', 'name' => 'Kuttekoven'),
      array('lat' => '50.8099', 'lng' => '5.2608', 'postal_code' => '3840', 'name' => 'Rijkel'),
      array('lat' => '50.7948', 'lng' => '5.3197', 'postal_code' => '3840', 'name' => 'Voort'),
      array('lat' => '50.8608', 'lng' => '5.1648', 'postal_code' => '3850', 'name' => 'Binderveld'),
      array('lat' => '50.8750', 'lng' => '5.2399', 'postal_code' => '3850', 'name' => 'Kozen'),
      array('lat' => '50.8984', 'lng' => '5.2239', 'postal_code' => '3850', 'name' => 'Wijer'),
      array('lat' => '50.7386', 'lng' => '5.2813', 'postal_code' => '3870', 'name' => 'Batsheers'),
      array('lat' => '50.7375', 'lng' => '5.2600', 'postal_code' => '3870', 'name' => 'Bovelingen'),
      array('lat' => '50.7739', 'lng' => '5.3171', 'postal_code' => '3870', 'name' => 'Gutshoven'),
      array('lat' => '50.7537', 'lng' => '5.3021', 'postal_code' => '3870', 'name' => 'Heers'),
      array('lat' => '50.7701', 'lng' => '5.3575', 'postal_code' => '3870', 'name' => 'Heks'),
      array('lat' => '50.7605', 'lng' => '5.3357', 'postal_code' => '3870', 'name' => 'Horpmaal'),
      array('lat' => '50.7698', 'lng' => '5.2769', 'postal_code' => '3870', 'name' => 'Klein-Gelmen'),
      array('lat' => '50.7405', 'lng' => '5.2605', 'postal_code' => '3870', 'name' => 'Mechelen-Bovelingen'),
      array('lat' => '50.7810', 'lng' => '5.2906', 'postal_code' => '3870', 'name' => 'Mettekoven'),
      array('lat' => '50.7397', 'lng' => '5.2977', 'postal_code' => '3870', 'name' => 'Opheers'),
      array('lat' => '50.7278', 'lng' => '5.2544', 'postal_code' => '3870', 'name' => 'Rukkelingen-Loon'),
      array('lat' => '50.7614', 'lng' => '5.3747', 'postal_code' => '3870', 'name' => 'Vechmaal'),
      array('lat' => '50.7637', 'lng' => '5.3058', 'postal_code' => '3870', 'name' => 'Veulen'),
      array('lat' => '50.7457', 'lng' => '5.2335', 'postal_code' => '3890', 'name' => 'Boekhout'),
      array('lat' => '50.7499', 'lng' => '5.1332', 'postal_code' => '3890', 'name' => 'Gingelom'),
      array('lat' => '50.7343', 'lng' => '5.2097', 'postal_code' => '3890', 'name' => 'Jeuk'),
      array('lat' => '50.7075', 'lng' => '5.1494', 'postal_code' => '3890', 'name' => 'Kortijs'),
      array('lat' => '50.7210', 'lng' => '5.1272', 'postal_code' => '3890', 'name' => 'Montenaken'),
      array('lat' => '50.7422', 'lng' => '5.1421', 'postal_code' => '3890', 'name' => 'Niel-Bij-Sint-Truiden'),
      array('lat' => '50.7039', 'lng' => '5.1686', 'postal_code' => '3890', 'name' => 'Vorsen'),
      array('lat' => '50.7422', 'lng' => '5.1814', 'postal_code' => '3891', 'name' => 'Borlo'),
      array('lat' => '50.7529', 'lng' => '5.1777', 'postal_code' => '3891', 'name' => 'Buvingen'),
      array('lat' => '50.7554', 'lng' => '5.2150', 'postal_code' => '3891', 'name' => 'Mielen-Boven-Aalst'),
      array('lat' => '50.7602', 'lng' => '5.1794', 'postal_code' => '3891', 'name' => 'Muizen'),
      array('lat' => '51.2333', 'lng' => '5.4333', 'postal_code' => '3900,3910', 'name' => 'Pelt'),
      array('lat' => '51.2225', 'lng' => '5.4958', 'postal_code' => '3910', 'name' => 'Sint-Huibrechts-Lille'),
      array('lat' => '51.2304', 'lng' => '5.3110', 'postal_code' => '3920', 'name' => 'Lommel'),
      array('lat' => '51.2522', 'lng' => '5.4795', 'postal_code' => '3930', 'name' => 'Achel'),
      array('lat' => '51.2527', 'lng' => '5.5495', 'postal_code' => '3930', 'name' => 'Hamont'),
      array('lat' => '51.2698', 'lng' => '5.5154', 'postal_code' => '3930', 'name' => 'Hamont-Achel'),
      array('lat' => '51.1252', 'lng' => '5.3661', 'postal_code' => '3940', 'name' => 'Hechtel'),
      array('lat' => '51.1105', 'lng' => '5.3296', 'postal_code' => '3940', 'name' => 'Hechtel-Eksel'),
      array('lat' => '51.1546', 'lng' => '5.3944', 'postal_code' => '3941', 'name' => 'Eksel'),
      array('lat' => '51.1038', 'lng' => '5.1777', 'postal_code' => '3945', 'name' => 'Ham'),
      array('lat' => '51.1007', 'lng' => '5.1442', 'postal_code' => '3945', 'name' => 'Kwaadmechelen'),
      array('lat' => '51.1037', 'lng' => '5.1802', 'postal_code' => '3945', 'name' => 'Oostham'),
      array('lat' => '51.1729', 'lng' => '5.5790', 'postal_code' => '3950', 'name' => 'Bocholt'),
      array('lat' => '51.1872', 'lng' => '5.5257', 'postal_code' => '3950', 'name' => 'Kaulille'),
      array('lat' => '51.1551', 'lng' => '5.5631', 'postal_code' => '3950', 'name' => 'Reppel'),
      array('lat' => '51.1558', 'lng' => '5.6036', 'postal_code' => '3960', 'name' => 'Beek'),
      array('lat' => '51.1410', 'lng' => '5.5980', 'postal_code' => '3960', 'name' => 'Bree'),
      array('lat' => '51.1480', 'lng' => '5.5802', 'postal_code' => '3960', 'name' => 'Gerdingen'),
      array('lat' => '51.1166', 'lng' => '5.6497', 'postal_code' => '3960', 'name' => 'Opitter'),
      array('lat' => '51.1286', 'lng' => '5.6615', 'postal_code' => '3960', 'name' => 'Tongerlo'),
      array('lat' => '51.1184', 'lng' => '5.2507', 'postal_code' => '3970', 'name' => 'Leopoldsburg'),
      array('lat' => '51.1089', 'lng' => '5.2286', 'postal_code' => '3971', 'name' => 'Heppen'),
      array('lat' => '51.0643', 'lng' => '5.0882', 'postal_code' => '3980', 'name' => 'Tessenderlo'),
      array('lat' => '51.1544', 'lng' => '5.5084', 'postal_code' => '3990', 'name' => 'Grote-Brogel'),
      array('lat' => '51.1726', 'lng' => '5.4502', 'postal_code' => '3990', 'name' => 'Kleine-Brogel'),
      array('lat' => '51.1329', 'lng' => '5.4536', 'postal_code' => '3990', 'name' => 'Peer'),
      array('lat' => '51.1356', 'lng' => '5.4131', 'postal_code' => '3990', 'name' => 'Wijchmaal'),
    ],
    'WLG' => [
      array('lat' => '50.6479', 'lng' => '5.5436', 'postal_code' => '4000', 'name' => 'Glain'),
      array('lat' => '50.6759', 'lng' => '5.5458', 'postal_code' => '4000', 'name' => 'Rocourt'),
      array('lat' => '50.6399', 'lng' => '5.6059', 'postal_code' => '4020', 'name' => 'Bressoux'),
      array('lat' => '50.6455', 'lng' => '5.6349', 'postal_code' => '4020', 'name' => 'Jupille-Sur-Meuse'),
      array('lat' => '50.6424', 'lng' => '5.6279', 'postal_code' => '4020', 'name' => 'LiÈge'),
      array('lat' => '50.6672', 'lng' => '5.6588', 'postal_code' => '4020', 'name' => 'Wandre'),
      array('lat' => '50.6216', 'lng' => '5.6107', 'postal_code' => '4030', 'name' => 'Grivegnee'),
      array('lat' => '50.6114', 'lng' => '5.5994', 'postal_code' => '4031', 'name' => 'Angleur'),
      array('lat' => '50.6122', 'lng' => '5.6137', 'postal_code' => '4032', 'name' => 'Chênee'),
      array('lat' => '50.6787', 'lng' => '5.6289', 'postal_code' => '4040', 'name' => 'Herstal'),
      array('lat' => '50.6904', 'lng' => '5.5922', 'postal_code' => '4041', 'name' => 'Milmort'),
      array('lat' => '50.6710', 'lng' => '5.5785', 'postal_code' => '4041', 'name' => 'Vottem'),
      array('lat' => '50.6936', 'lng' => '5.5638', 'postal_code' => '4042', 'name' => 'Liers'),
      array('lat' => '50.5896', 'lng' => '5.6428', 'postal_code' => '4050', 'name' => 'Chaudfontaine'),
      array('lat' => '50.6011', 'lng' => '5.6319', 'postal_code' => '4051', 'name' => 'Vaux-Sous-Chèvremont'),
      array('lat' => '50.5587', 'lng' => '5.6388', 'postal_code' => '4052', 'name' => 'Beaufays'),
      array('lat' => '50.5903', 'lng' => '5.6069', 'postal_code' => '4053', 'name' => 'Embourg'),
      array('lat' => '50.5858', 'lng' => '5.6411', 'postal_code' => '4075', 'name' => 'Csm Liege X'),
      array('lat' => '50.5709', 'lng' => '5.5365', 'postal_code' => '4100', 'name' => 'Boncelles'),
      array('lat' => '50.5839', 'lng' => '5.4996', 'postal_code' => '4100', 'name' => 'Seraing'),
      array('lat' => '50.6176', 'lng' => '5.4952', 'postal_code' => '4101', 'name' => 'Jemeppe-Sur-Meuse'),
      array('lat' => '50.6012', 'lng' => '5.5443', 'postal_code' => '4102', 'name' => 'Ougrée'),
      array('lat' => '50.5327', 'lng' => '5.4761', 'postal_code' => '4120', 'name' => 'NeuprÉ'),
      array('lat' => '50.5347', 'lng' => '5.4811', 'postal_code' => '4120', 'name' => 'Rotheux-Rimière'),
      array('lat' => '50.5525', 'lng' => '5.4512', 'postal_code' => '4121', 'name' => 'Neuville-En-Condroz'),
      array('lat' => '50.5453', 'lng' => '5.5243', 'postal_code' => '4122', 'name' => 'Plainevaux'),
      array('lat' => '50.5350', 'lng' => '5.5684', 'postal_code' => '4130', 'name' => 'Esneux'),
      array('lat' => '50.5641', 'lng' => '5.5760', 'postal_code' => '4130', 'name' => 'Tilff'),
      array('lat' => '50.5361', 'lng' => '5.6329', 'postal_code' => '4140', 'name' => 'Dolembreux'),
      array('lat' => '50.5474', 'lng' => '5.6897', 'postal_code' => '4140', 'name' => 'Gomzé-Andoumont'),
      array('lat' => '50.4897', 'lng' => '5.6502', 'postal_code' => '4140', 'name' => 'Rouvreux'),
      array('lat' => '50.5116', 'lng' => '5.6461', 'postal_code' => '4140', 'name' => 'Sprimont'),
      array('lat' => '50.4821', 'lng' => '5.5195', 'postal_code' => '4160', 'name' => 'Anthisnes'),
      array('lat' => '50.4979', 'lng' => '5.5162', 'postal_code' => '4161', 'name' => 'Villers-Aux-Tours'),
      array('lat' => '50.4865', 'lng' => '5.5039', 'postal_code' => '4162', 'name' => 'Hody'),
      array('lat' => '50.4963', 'lng' => '5.4706', 'postal_code' => '4163', 'name' => 'Tavier'),
      array('lat' => '50.4741', 'lng' => '5.5626', 'postal_code' => '4170', 'name' => 'Comblain-Au-Pont'),
      array('lat' => '50.5087', 'lng' => '5.5786', 'postal_code' => '4171', 'name' => 'Poulseur'),
      array('lat' => '50.4467', 'lng' => '5.5473', 'postal_code' => '4180', 'name' => 'Comblain-Fairon'),
      array('lat' => '50.4543', 'lng' => '5.5717', 'postal_code' => '4180', 'name' => 'Comblain-La-Tour'),
      array('lat' => '50.4384', 'lng' => '5.5492', 'postal_code' => '4180', 'name' => 'Hamoir'),
      array('lat' => '50.4265', 'lng' => '5.5668', 'postal_code' => '4181', 'name' => 'Filot'),
      array('lat' => '50.4003', 'lng' => '5.6056', 'postal_code' => '4190', 'name' => 'FerriÈres'),
      array('lat' => '50.4054', 'lng' => '5.5734', 'postal_code' => '4190', 'name' => 'My'),
      array('lat' => '50.3938', 'lng' => '5.5496', 'postal_code' => '4190', 'name' => 'Vieuxville'),
      array('lat' => '50.3804', 'lng' => '5.6840', 'postal_code' => '4190', 'name' => 'Werbomont'),
      array('lat' => '50.4455', 'lng' => '5.6044', 'postal_code' => '4190', 'name' => 'Xhoris'),
      array('lat' => '50.5841', 'lng' => '5.0764', 'postal_code' => '4210', 'name' => 'Burdinne'),
      array('lat' => '50.5779', 'lng' => '5.0479', 'postal_code' => '4210', 'name' => 'Hannêche'),
      array('lat' => '50.5844', 'lng' => '5.0925', 'postal_code' => '4210', 'name' => 'Lamontzée'),
      array('lat' => '50.5804', 'lng' => '5.1467', 'postal_code' => '4210', 'name' => 'Marneffe'),
      array('lat' => '50.5805', 'lng' => '5.1266', 'postal_code' => '4210', 'name' => 'Oteppe'),
      array('lat' => '50.5527', 'lng' => '5.0923', 'postal_code' => '4217', 'name' => 'HÉron'),
      array('lat' => '50.5503', 'lng' => '5.1196', 'postal_code' => '4217', 'name' => 'Lavoir'),
      array('lat' => '50.5485', 'lng' => '5.0612', 'postal_code' => '4217', 'name' => 'Waret-L\'evêque'),
      array('lat' => '50.5315', 'lng' => '5.1225', 'postal_code' => '4218', 'name' => 'Couthuin'),
      array('lat' => '50.5928', 'lng' => '5.0466', 'postal_code' => '4219', 'name' => 'Acosse'),
      array('lat' => '50.6305', 'lng' => '5.0306', 'postal_code' => '4219', 'name' => 'Ambresin'),
      array('lat' => '50.6075', 'lng' => '5.0182', 'postal_code' => '4219', 'name' => 'Meeffe'),
      array('lat' => '50.6175', 'lng' => '5.0016', 'postal_code' => '4219', 'name' => 'Wasseiges'),
      array('lat' => '50.6821', 'lng' => '5.1665', 'postal_code' => '4250', 'name' => 'Boëlhe'),
      array('lat' => '50.6702', 'lng' => '5.1828', 'postal_code' => '4250', 'name' => 'Geer'),
      array('lat' => '50.6766', 'lng' => '5.2054', 'postal_code' => '4250', 'name' => 'Hollogne-Sur-Geer'),
      array('lat' => '50.6636', 'lng' => '5.1559', 'postal_code' => '4250', 'name' => 'Lens-Saint-Servais'),
      array('lat' => '50.6558', 'lng' => '5.1994', 'postal_code' => '4252', 'name' => 'Omal'),
      array('lat' => '50.6646', 'lng' => '5.1865', 'postal_code' => '4253', 'name' => 'Darion'),
      array('lat' => '50.6615', 'lng' => '5.1823', 'postal_code' => '4254', 'name' => 'Ligney'),
      array('lat' => '50.6988', 'lng' => '5.2127', 'postal_code' => '4257', 'name' => 'Berloz'),
      array('lat' => '50.7108', 'lng' => '5.2132', 'postal_code' => '4257', 'name' => 'Corswarem'),
      array('lat' => '50.7074', 'lng' => '5.1895', 'postal_code' => '4257', 'name' => 'Rosoux-Crenwick'),
      array('lat' => '50.6295', 'lng' => '5.1128', 'postal_code' => '4260', 'name' => 'Avennes'),
      array('lat' => '50.6282', 'lng' => '5.1488', 'postal_code' => '4260', 'name' => 'Braives'),
      array('lat' => '50.6183', 'lng' => '5.0927', 'postal_code' => '4260', 'name' => 'Ciplet'),
      array('lat' => '50.6102', 'lng' => '5.1704', 'postal_code' => '4260', 'name' => 'Fallais'),
      array('lat' => '50.5866', 'lng' => '5.1831', 'postal_code' => '4260', 'name' => 'Fumal'),
      array('lat' => '50.6158', 'lng' => '5.1159', 'postal_code' => '4260', 'name' => 'Ville-En-Hesbaye'),
      array('lat' => '50.6248', 'lng' => '5.1640', 'postal_code' => '4261', 'name' => 'Latinne'),
      array('lat' => '50.6390', 'lng' => '5.1746', 'postal_code' => '4263', 'name' => 'Tourinne'),
      array('lat' => '50.6730', 'lng' => '5.1489', 'postal_code' => '4280', 'name' => 'Abolens'),
      array('lat' => '50.6943', 'lng' => '5.0786', 'postal_code' => '4280', 'name' => 'Avernas-Le-Bauduin'),
      array('lat' => '50.6222', 'lng' => '5.0693', 'postal_code' => '4280', 'name' => 'Avin'),
      array('lat' => '50.6952', 'lng' => '5.0913', 'postal_code' => '4280', 'name' => 'Bertrée'),
      array('lat' => '50.6643', 'lng' => '5.1226', 'postal_code' => '4280', 'name' => 'Blehen'),
      array('lat' => '50.6973', 'lng' => '5.1236', 'postal_code' => '4280', 'name' => 'Cras-Avernas'),
      array('lat' => '50.6599', 'lng' => '5.0634', 'postal_code' => '4280', 'name' => 'Crehen'),
      array('lat' => '50.6956', 'lng' => '5.0322', 'postal_code' => '4280', 'name' => 'Grand-Hallet'),
      array('lat' => '50.6722', 'lng' => '5.0778', 'postal_code' => '4280', 'name' => 'Hannut'),
      array('lat' => '50.6544', 'lng' => '5.1331', 'postal_code' => '4280', 'name' => 'Lens-Saint-Remy'),
      array('lat' => '50.6483', 'lng' => '5.0004', 'postal_code' => '4280', 'name' => 'Merdorp'),
      array('lat' => '50.6306', 'lng' => '5.0835', 'postal_code' => '4280', 'name' => 'Moxhe'),
      array('lat' => '50.6876', 'lng' => '5.0172', 'postal_code' => '4280', 'name' => 'Petit-Hallet'),
      array('lat' => '50.6759', 'lng' => '5.1165', 'postal_code' => '4280', 'name' => 'Poucet'),
      array('lat' => '50.6658', 'lng' => '5.0468', 'postal_code' => '4280', 'name' => 'Thisnes'),
      array('lat' => '50.6873', 'lng' => '5.1248', 'postal_code' => '4280', 'name' => 'Trognée'),
      array('lat' => '50.6562', 'lng' => '5.0958', 'postal_code' => '4280', 'name' => 'Villers-Le-Peuplier'),
      array('lat' => '50.6790', 'lng' => '5.0190', 'postal_code' => '4280', 'name' => 'Wansin'),
      array('lat' => '50.7129', 'lng' => '5.0306', 'postal_code' => '4287', 'name' => 'Lincent'),
      array('lat' => '50.7257', 'lng' => '5.0071', 'postal_code' => '4287', 'name' => 'Pellaines'),
      array('lat' => '50.7396', 'lng' => '5.0289', 'postal_code' => '4287', 'name' => 'Racour'),
      array('lat' => '50.7125', 'lng' => '5.2358', 'postal_code' => '4300', 'name' => 'Bettincourt'),
      array('lat' => '50.6893', 'lng' => '5.2873', 'postal_code' => '4300', 'name' => 'Bleret'),
      array('lat' => '50.6678', 'lng' => '5.2839', 'postal_code' => '4300', 'name' => 'Bovenistier'),
      array('lat' => '50.6806', 'lng' => '5.2296', 'postal_code' => '4300', 'name' => 'Grand-Axhe'),
      array('lat' => '50.7117', 'lng' => '5.2956', 'postal_code' => '4300', 'name' => 'Lantremange'),
      array('lat' => '50.7138', 'lng' => '5.2811', 'postal_code' => '4300', 'name' => 'Oleye'),
      array('lat' => '50.6976', 'lng' => '5.2555', 'postal_code' => '4300', 'name' => 'Waremme'),
      array('lat' => '50.6256', 'lng' => '5.2575', 'postal_code' => '4317', 'name' => 'Aineffe'),
      array('lat' => '50.6333', 'lng' => '5.2433', 'postal_code' => '4317', 'name' => 'Borlez'),
      array('lat' => '50.6618', 'lng' => '5.2601', 'postal_code' => '4317', 'name' => 'Faimes'),
      array('lat' => '50.6378', 'lng' => '5.2233', 'postal_code' => '4317', 'name' => 'Les Waleffes'),
      array('lat' => '50.6468', 'lng' => '5.2722', 'postal_code' => '4317', 'name' => 'Viemme'),
      array('lat' => '50.6669', 'lng' => '5.4629', 'postal_code' => '4340', 'name' => 'Awans'),
      array('lat' => '50.6760', 'lng' => '5.4359', 'postal_code' => '4340', 'name' => 'Fooz'),
      array('lat' => '50.7157', 'lng' => '5.4671', 'postal_code' => '4340', 'name' => 'Othée'),
      array('lat' => '50.7044', 'lng' => '5.4395', 'postal_code' => '4340', 'name' => 'Villers-L\'evêque'),
      array('lat' => '50.6814', 'lng' => '5.4543', 'postal_code' => '4342', 'name' => 'Hognoul'),
      array('lat' => '50.6653', 'lng' => '5.3995', 'postal_code' => '4347', 'name' => 'Fexhe-Le-Haut-Clocher'),
      array('lat' => '50.6805', 'lng' => '5.4066', 'postal_code' => '4347', 'name' => 'Freloux'),
      array('lat' => '50.6511', 'lng' => '5.3974', 'postal_code' => '4347', 'name' => 'Roloux'),
      array('lat' => '50.6548', 'lng' => '5.4291', 'postal_code' => '4347', 'name' => 'Voroux-Goreux'),
      array('lat' => '50.6891', 'lng' => '5.3347', 'postal_code' => '4350', 'name' => 'Lamine'),
      array('lat' => '50.6857', 'lng' => '5.3758', 'postal_code' => '4350', 'name' => 'Momalle'),
      array('lat' => '50.6948', 'lng' => '5.3042', 'postal_code' => '4350', 'name' => 'Pousset'),
      array('lat' => '50.6802', 'lng' => '5.3284', 'postal_code' => '4350', 'name' => 'Remicourt'),
      array('lat' => '50.6961', 'lng' => '5.3417', 'postal_code' => '4351', 'name' => 'Hodeige'),
      array('lat' => '50.6458', 'lng' => '5.3214', 'postal_code' => '4357', 'name' => 'Donceel'),
      array('lat' => '50.6379', 'lng' => '5.3205', 'postal_code' => '4357', 'name' => 'Haneffe'),
      array('lat' => '50.6606', 'lng' => '5.3114', 'postal_code' => '4357', 'name' => 'Limont'),
      array('lat' => '50.7154', 'lng' => '5.3290', 'postal_code' => '4360', 'name' => 'Bergilers'),
      array('lat' => '50.7234', 'lng' => '5.3388', 'postal_code' => '4360', 'name' => 'Grandville'),
      array('lat' => '50.7211', 'lng' => '5.3510', 'postal_code' => '4360', 'name' => 'Lens-Sur-Geer'),
      array('lat' => '50.7318', 'lng' => '5.3577', 'postal_code' => '4360', 'name' => 'Oreye'),
      array('lat' => '50.7360', 'lng' => '5.3786', 'postal_code' => '4360', 'name' => 'Otrange'),
      array('lat' => '50.7174', 'lng' => '5.3977', 'postal_code' => '4367', 'name' => 'CrisnÉe'),
      array('lat' => '50.7024', 'lng' => '5.3856', 'postal_code' => '4367', 'name' => 'Fize-Le-Marsal'),
      array('lat' => '50.6974', 'lng' => '5.4075', 'postal_code' => '4367', 'name' => 'Kemexhe'),
      array('lat' => '50.7065', 'lng' => '5.4164', 'postal_code' => '4367', 'name' => 'Odeur'),
      array('lat' => '50.7225', 'lng' => '5.3904', 'postal_code' => '4367', 'name' => 'Thys'),
      array('lat' => '50.5999', 'lng' => '5.4061', 'postal_code' => '4400', 'name' => 'Awirs'),
      array('lat' => '50.5911', 'lng' => '5.4419', 'postal_code' => '4400', 'name' => 'Chokier'),
      array('lat' => '50.6019', 'lng' => '5.4434', 'postal_code' => '4400', 'name' => 'FlÉmalle'),
      array('lat' => '50.6088', 'lng' => '5.4765', 'postal_code' => '4400', 'name' => 'Flémalle-Grande'),
      array('lat' => '50.6002', 'lng' => '5.4460', 'postal_code' => '4400', 'name' => 'Flémalle-Haute'),
      array('lat' => '50.6130', 'lng' => '5.3894', 'postal_code' => '4400', 'name' => 'Gleixhe'),
      array('lat' => '50.5884', 'lng' => '5.4639', 'postal_code' => '4400', 'name' => 'Ivoz-Ramet'),
      array('lat' => '50.6234', 'lng' => '5.4559', 'postal_code' => '4400', 'name' => 'Mons-Lez-Liège'),
      array('lat' => '50.6453', 'lng' => '5.5141', 'postal_code' => '4420', 'name' => 'Montegnée'),
      array('lat' => '50.6292', 'lng' => '5.5322', 'postal_code' => '4420', 'name' => 'Saint-Nicolas'),
      array('lat' => '50.6195', 'lng' => '5.5202', 'postal_code' => '4420', 'name' => 'Tilleur'),
      array('lat' => '50.6602', 'lng' => '5.5266', 'postal_code' => '4430', 'name' => 'Ans'),
      array('lat' => '50.6662', 'lng' => '5.5052', 'postal_code' => '4431', 'name' => 'Loncin'),
      array('lat' => '50.6743', 'lng' => '5.5134', 'postal_code' => '4432', 'name' => 'Alleur'),
      array('lat' => '50.7050', 'lng' => '5.4831', 'postal_code' => '4432', 'name' => 'Xhendremael'),
      array('lat' => '50.7096', 'lng' => '5.5268', 'postal_code' => '4450', 'name' => 'Juprelle'),
      array('lat' => '50.6885', 'lng' => '5.5246', 'postal_code' => '4450', 'name' => 'Lantin'),
      array('lat' => '50.7277', 'lng' => '5.5638', 'postal_code' => '4450', 'name' => 'Slins'),
      array('lat' => '50.6876', 'lng' => '5.5549', 'postal_code' => '4451', 'name' => 'Voroux-Lez-Liers'),
      array('lat' => '50.7283', 'lng' => '5.5249', 'postal_code' => '4452', 'name' => 'Paifve'),
      array('lat' => '50.7271', 'lng' => '5.5067', 'postal_code' => '4452', 'name' => 'Wihogne'),
      array('lat' => '50.7111', 'lng' => '5.5388', 'postal_code' => '4453', 'name' => 'Villers-Saint-Siméon'),
      array('lat' => '50.7200', 'lng' => '5.5695', 'postal_code' => '4458', 'name' => 'Fexhe-Slins'),
      array('lat' => '50.6550', 'lng' => '5.4509', 'postal_code' => '4460', 'name' => 'Bierset'),
      array('lat' => '50.6400', 'lng' => '5.5019', 'postal_code' => '4460', 'name' => 'Grâce-Berleur'),
      array('lat' => '50.6341', 'lng' => '5.4757', 'postal_code' => '4460', 'name' => 'GrÂce-Hollogne'),
      array('lat' => '50.6403', 'lng' => '5.4708', 'postal_code' => '4460', 'name' => 'Hollogne-Aux-Pierres'),
      array('lat' => '50.6283', 'lng' => '5.3796', 'postal_code' => '4460', 'name' => 'Horion-Hozémont'),
      array('lat' => '50.6429', 'lng' => '5.4244', 'postal_code' => '4460', 'name' => 'Velroux'),
      array('lat' => '50.6001', 'lng' => '5.3576', 'postal_code' => '4470', 'name' => 'Saint-Georges-Sur-Meuse'),
      array('lat' => '50.5694', 'lng' => '5.3918', 'postal_code' => '4480', 'name' => 'Clermont-Sous-Huy'),
      array('lat' => '50.2998', 'lng' => '6.1266', 'postal_code' => '4480', 'name' => 'Ehein'),
      array('lat' => '50.5832', 'lng' => '5.4037', 'postal_code' => '4480', 'name' => 'Engis'),
      array('lat' => '50.5591', 'lng' => '5.3619', 'postal_code' => '4480', 'name' => 'Hermalle-Sous-Huy'),
      array('lat' => '50.5020', 'lng' => '5.1852', 'postal_code' => '4500', 'name' => 'Ben-Ahin'),
      array('lat' => '50.5187', 'lng' => '5.2397', 'postal_code' => '4500', 'name' => 'Huy'),
      array('lat' => '50.5297', 'lng' => '5.2615', 'postal_code' => '4500', 'name' => 'Tihange'),
      array('lat' => '50.5490', 'lng' => '5.2404', 'postal_code' => '4520', 'name' => 'Antheit'),
      array('lat' => '50.5263', 'lng' => '5.1909', 'postal_code' => '4520', 'name' => 'Bas-Oha'),
      array('lat' => '50.5673', 'lng' => '5.1655', 'postal_code' => '4520', 'name' => 'Huccorgne'),
      array('lat' => '50.5477', 'lng' => '5.1862', 'postal_code' => '4520', 'name' => 'Moha'),
      array('lat' => '50.5631', 'lng' => '5.2307', 'postal_code' => '4520', 'name' => 'Vinalmont'),
      array('lat' => '50.5345', 'lng' => '5.2141', 'postal_code' => '4520', 'name' => 'Wanze'),
      array('lat' => '50.5851', 'lng' => '5.2830', 'postal_code' => '4530', 'name' => 'Fize-Fontaine'),
      array('lat' => '50.6133', 'lng' => '5.2321', 'postal_code' => '4530', 'name' => 'Vaux-Et-Borset'),
      array('lat' => '50.6161', 'lng' => '5.2038', 'postal_code' => '4530', 'name' => 'Vieux-Waleffe'),
      array('lat' => '50.5700', 'lng' => '5.2663', 'postal_code' => '4530', 'name' => 'Villers-Le-Bouillet'),
      array('lat' => '50.5952', 'lng' => '5.2275', 'postal_code' => '4530', 'name' => 'Warnant-Dreye'),
      array('lat' => '50.5859', 'lng' => '5.3037', 'postal_code' => '4537', 'name' => 'Bodegnée'),
      array('lat' => '50.6084', 'lng' => '5.2690', 'postal_code' => '4537', 'name' => 'Chapon-Seraing'),
      array('lat' => '50.6213', 'lng' => '5.2983', 'postal_code' => '4537', 'name' => 'Seraing-Le-Château'),
      array('lat' => '50.6063', 'lng' => '5.3173', 'postal_code' => '4537', 'name' => 'Verlaine'),
      array('lat' => '50.5483', 'lng' => '5.3097', 'postal_code' => '4540', 'name' => 'Amay'),
      array('lat' => '50.5414', 'lng' => '5.2781', 'postal_code' => '4540', 'name' => 'Ampsin'),
      array('lat' => '50.5576', 'lng' => '5.3360', 'postal_code' => '4540', 'name' => 'Flône'),
      array('lat' => '50.5725', 'lng' => '5.3247', 'postal_code' => '4540', 'name' => 'Jehay'),
      array('lat' => '50.5422', 'lng' => '5.3332', 'postal_code' => '4540', 'name' => 'Ombret'),
      array('lat' => '50.5072', 'lng' => '5.4199', 'postal_code' => '4550', 'name' => 'Nandrin'),
      array('lat' => '50.5298', 'lng' => '5.4112', 'postal_code' => '4550', 'name' => 'Saint-Séverin'),
      array('lat' => '50.5173', 'lng' => '5.3595', 'postal_code' => '4550', 'name' => 'Villers-Le-Temple'),
      array('lat' => '50.5291', 'lng' => '5.3839', 'postal_code' => '4550', 'name' => 'Yernée-Fraineux'),
      array('lat' => '50.4731', 'lng' => '5.3565', 'postal_code' => '4557', 'name' => 'Abée'),
      array('lat' => '50.4784', 'lng' => '5.4195', 'postal_code' => '4557', 'name' => 'Fraiture'),
      array('lat' => '50.4670', 'lng' => '5.3332', 'postal_code' => '4557', 'name' => 'Ramelot'),
      array('lat' => '50.4590', 'lng' => '5.4016', 'postal_code' => '4557', 'name' => 'Seny'),
      array('lat' => '50.4834', 'lng' => '5.3886', 'postal_code' => '4557', 'name' => 'Soheit-Tinlot'),
      array('lat' => '50.4777', 'lng' => '5.3788', 'postal_code' => '4557', 'name' => 'Tinlot'),
      array('lat' => '50.3893', 'lng' => '5.3228', 'postal_code' => '4560', 'name' => 'Bois-Et-Borsu'),
      array('lat' => '50.4115', 'lng' => '5.3635', 'postal_code' => '4560', 'name' => 'Clavier'),
      array('lat' => '50.4161', 'lng' => '5.3016', 'postal_code' => '4560', 'name' => 'Les Avins'),
      array('lat' => '50.3956', 'lng' => '5.3937', 'postal_code' => '4560', 'name' => 'Ocquier'),
      array('lat' => '50.4228', 'lng' => '5.2582', 'postal_code' => '4560', 'name' => 'Pailhe'),
      array('lat' => '50.4443', 'lng' => '5.3483', 'postal_code' => '4560', 'name' => 'Terwagne'),
      array('lat' => '50.4652', 'lng' => '5.2420', 'postal_code' => '4570', 'name' => 'Marchin'),
      array('lat' => '50.4445', 'lng' => '5.2615', 'postal_code' => '4570', 'name' => 'Vyle-Et-Tharoul'),
      array('lat' => '50.4424', 'lng' => '5.3007', 'postal_code' => '4577', 'name' => 'Modave'),
      array('lat' => '50.5033', 'lng' => '5.3346', 'postal_code' => '4577', 'name' => 'Outrelouxhe'),
      array('lat' => '50.4932', 'lng' => '5.3219', 'postal_code' => '4577', 'name' => 'Strée-Lez-Huy'),
      array('lat' => '50.4834', 'lng' => '5.2977', 'postal_code' => '4577', 'name' => 'Vierset-Barse'),
      array('lat' => '50.4675', 'lng' => '5.4443', 'postal_code' => '4590', 'name' => 'Ellemelle'),
      array('lat' => '50.4381', 'lng' => '5.4654', 'postal_code' => '4590', 'name' => 'Ouffet'),
      array('lat' => '50.4493', 'lng' => '5.4283', 'postal_code' => '4590', 'name' => 'Warzée'),
      array('lat' => '50.7817', 'lng' => '5.6945', 'postal_code' => '4600', 'name' => 'Lanaye'),
      array('lat' => '50.7568', 'lng' => '5.6793', 'postal_code' => '4600', 'name' => 'Lixhe'),
      array('lat' => '50.7136', 'lng' => '5.6953', 'postal_code' => '4600', 'name' => 'Richelle'),
      array('lat' => '50.7436', 'lng' => '5.6867', 'postal_code' => '4600', 'name' => 'VisÉ'),
      array('lat' => '50.6962', 'lng' => '5.6876', 'postal_code' => '4601', 'name' => 'Argenteau'),
      array('lat' => '50.6837', 'lng' => '5.6708', 'postal_code' => '4602', 'name' => 'Cheratte'),
      array('lat' => '50.6957', 'lng' => '5.7531', 'postal_code' => '4606', 'name' => 'Saint-André'),
      array('lat' => '50.7427', 'lng' => '5.7306', 'postal_code' => '4607', 'name' => 'Berneau'),
      array('lat' => '50.7307', 'lng' => '5.7449', 'postal_code' => '4607', 'name' => 'Bombaye'),
      array('lat' => '50.7205', 'lng' => '5.7331', 'postal_code' => '4607', 'name' => 'Dalhem'),
      array('lat' => '50.7043', 'lng' => '5.7149', 'postal_code' => '4607', 'name' => 'Feneur'),
      array('lat' => '50.7115', 'lng' => '5.7537', 'postal_code' => '4607', 'name' => 'Mortroux'),
      array('lat' => '50.7355', 'lng' => '5.7691', 'postal_code' => '4608', 'name' => 'Warsage'),
      array('lat' => '50.6450', 'lng' => '5.6654', 'postal_code' => '4610', 'name' => 'Bellaire'),
      array('lat' => '50.6216', 'lng' => '5.6559', 'postal_code' => '4610', 'name' => 'Beyne-Heusay'),
      array('lat' => '50.6374', 'lng' => '5.6789', 'postal_code' => '4610', 'name' => 'Queue-Du-Bois'),
      array('lat' => '50.6180', 'lng' => '5.6845', 'postal_code' => '4620', 'name' => 'FlÉron'),
      array('lat' => '50.6301', 'lng' => '5.6972', 'postal_code' => '4621', 'name' => 'Retinne'),
      array('lat' => '50.5997', 'lng' => '5.6884', 'postal_code' => '4623', 'name' => 'Magnée'),
      array('lat' => '50.6106', 'lng' => '5.6645', 'postal_code' => '4624', 'name' => 'Romsée'),
      array('lat' => '50.6078', 'lng' => '5.7168', 'postal_code' => '4630', 'name' => 'Ayeneux'),
      array('lat' => '50.6265', 'lng' => '5.7212', 'postal_code' => '4630', 'name' => 'Micheroux'),
      array('lat' => '50.6162', 'lng' => '5.7373', 'postal_code' => '4630', 'name' => 'Soumagne'),
      array('lat' => '50.6513', 'lng' => '5.7020', 'postal_code' => '4630', 'name' => 'Tignée'),
      array('lat' => '50.6422', 'lng' => '5.7088', 'postal_code' => '4631', 'name' => 'Evegnée'),
      array('lat' => '50.6541', 'lng' => '5.7265', 'postal_code' => '4632', 'name' => 'Cérexhe-Heuseux'),
      array('lat' => '50.6460', 'lng' => '5.7360', 'postal_code' => '4633', 'name' => 'Melen'),
      array('lat' => '50.6317', 'lng' => '5.8344', 'postal_code' => '4650', 'name' => 'Chaineux'),
      array('lat' => '50.6074', 'lng' => '5.8100', 'postal_code' => '4650', 'name' => 'Grand-Rechain'),
      array('lat' => '50.6318', 'lng' => '5.8426', 'postal_code' => '4650', 'name' => 'Herve'),
      array('lat' => '50.6860', 'lng' => '5.7714', 'postal_code' => '4650', 'name' => 'Julémont'),
      array('lat' => '50.6475', 'lng' => '5.8207', 'postal_code' => '4651', 'name' => 'Battice'),
      array('lat' => '50.6051', 'lng' => '5.7783', 'postal_code' => '4652', 'name' => 'Xhendelesse'),
      array('lat' => '50.6611', 'lng' => '5.7604', 'postal_code' => '4653', 'name' => 'Bolland'),
      array('lat' => '50.6698', 'lng' => '5.8042', 'postal_code' => '4654', 'name' => 'Charneux'),
      array('lat' => '50.6793', 'lng' => '5.7247', 'postal_code' => '4670', 'name' => 'BlÉgny'),
      array('lat' => '50.6850', 'lng' => '5.7435', 'postal_code' => '4670', 'name' => 'Mortier'),
      array('lat' => '50.6954', 'lng' => '5.7265', 'postal_code' => '4670', 'name' => 'Trembleur'),
      array('lat' => '50.6687', 'lng' => '5.6999', 'postal_code' => '4671', 'name' => 'Barchon'),
      array('lat' => '50.6790', 'lng' => '5.6911', 'postal_code' => '4671', 'name' => 'Housse'),
      array('lat' => '50.6531', 'lng' => '5.6859', 'postal_code' => '4671', 'name' => 'Saive'),
      array('lat' => '50.7079', 'lng' => '5.6185', 'postal_code' => '4680', 'name' => 'Hermée'),
      array('lat' => '50.7127', 'lng' => '5.6262', 'postal_code' => '4680', 'name' => 'Oupeye'),
      array('lat' => '50.7112', 'lng' => '5.6800', 'postal_code' => '4681', 'name' => 'Hermalle-Sous-Argenteau'),
      array('lat' => '50.7314', 'lng' => '5.6333', 'postal_code' => '4682', 'name' => 'Heure-Le-Romain'),
      array('lat' => '50.7399', 'lng' => '5.6118', 'postal_code' => '4682', 'name' => 'Houtain-Saint-Siméon'),
      array('lat' => '50.6948', 'lng' => '5.6467', 'postal_code' => '4683', 'name' => 'Vivegnis'),
      array('lat' => '50.7303', 'lng' => '5.6689', 'postal_code' => '4684', 'name' => 'Haccourt'),
      array('lat' => '50.7591', 'lng' => '5.6101', 'postal_code' => '4690', 'name' => 'Bassenge'),
      array('lat' => '50.7510', 'lng' => '5.5800', 'postal_code' => '4690', 'name' => 'Boirs'),
      array('lat' => '50.7933', 'lng' => '5.6656', 'postal_code' => '4690', 'name' => 'Eben-Emael'),
      array('lat' => '50.7521', 'lng' => '5.5450', 'postal_code' => '4690', 'name' => 'Glons'),
      array('lat' => '50.7569', 'lng' => '5.5954', 'postal_code' => '4690', 'name' => 'Roclenge-Sur-Geer'),
      array('lat' => '50.7669', 'lng' => '5.6359', 'postal_code' => '4690', 'name' => 'Wonck'),
      array('lat' => '50.6133', 'lng' => '6.1011', 'postal_code' => '4700', 'name' => 'Eupen'),
      array('lat' => '50.6473', 'lng' => '6.0469', 'postal_code' => '4701', 'name' => 'Kettenis'),
      array('lat' => '50.6817', 'lng' => '5.9876', 'postal_code' => '4710', 'name' => 'Lontzen'),
      array('lat' => '50.6747', 'lng' => '6.0455', 'postal_code' => '4711', 'name' => 'Walhorn'),
      array('lat' => '50.7194', 'lng' => '6.0118', 'postal_code' => '4720', 'name' => 'La Calamine'),
      array('lat' => '50.7161', 'lng' => '6.0213', 'postal_code' => '4721', 'name' => 'Neu-Moresnet'),
      array('lat' => '50.7090', 'lng' => '6.0314', 'postal_code' => '4728', 'name' => 'Hergenrath'),
      array('lat' => '50.7104', 'lng' => '6.0696', 'postal_code' => '4730', 'name' => 'Hauset'),
      array('lat' => '50.6770', 'lng' => '6.1097', 'postal_code' => '4730', 'name' => 'Raeren'),
      array('lat' => '50.6922', 'lng' => '6.0835', 'postal_code' => '4731', 'name' => 'Eynatten'),
      array('lat' => '50.4266', 'lng' => '6.2043', 'postal_code' => '4750', 'name' => 'Butgenbach'),
      array('lat' => '50.4806', 'lng' => '6.2514', 'postal_code' => '4750', 'name' => 'Elsenborn'),
      array('lat' => '50.3740', 'lng' => '6.3043', 'postal_code' => '4760', 'name' => 'Bullange'),
      array('lat' => '50.3302', 'lng' => '6.3412', 'postal_code' => '4760', 'name' => 'Manderfeld'),
      array('lat' => '50.4365', 'lng' => '6.3006', 'postal_code' => '4761', 'name' => 'Rocherath'),
      array('lat' => '50.3542', 'lng' => '6.1695', 'postal_code' => '4770', 'name' => 'AmblÈve'),
      array('lat' => '50.3180', 'lng' => '6.1897', 'postal_code' => '4770', 'name' => 'Meyerode'),
      array('lat' => '50.3628', 'lng' => '6.2186', 'postal_code' => '4771', 'name' => 'Heppenbach'),
      array('lat' => '50.3341', 'lng' => '6.0431', 'postal_code' => '4780', 'name' => 'Recht'),
      array('lat' => '50.2797', 'lng' => '6.1305', 'postal_code' => '4780', 'name' => 'Saint-Vith'),
      array('lat' => '50.2888', 'lng' => '6.2653', 'postal_code' => '4782', 'name' => 'Schoenberg'),
      array('lat' => '50.2388', 'lng' => '6.1655', 'postal_code' => '4783', 'name' => 'Lommersweiler'),
      array('lat' => '50.2594', 'lng' => '6.0690', 'postal_code' => '4784', 'name' => 'Crombach'),
      array('lat' => '50.1966', 'lng' => '6.1377', 'postal_code' => '4790', 'name' => 'Burg-Reuland'),
      array('lat' => '50.1966', 'lng' => '6.1377', 'postal_code' => '4790', 'name' => 'Reuland'),
      array('lat' => '50.2182', 'lng' => '6.0739', 'postal_code' => '4791', 'name' => 'Thommen'),
      array('lat' => '50.5813', 'lng' => '5.8460', 'postal_code' => '4800', 'name' => 'Ensival'),
      array('lat' => '50.5904', 'lng' => '5.8323', 'postal_code' => '4800', 'name' => 'Lambermont'),
      array('lat' => '50.6144', 'lng' => '5.8345', 'postal_code' => '4800', 'name' => 'Petit-Rechain'),
      array('lat' => '50.5910', 'lng' => '5.8656', 'postal_code' => '4800', 'name' => 'Verviers'),
      array('lat' => '50.5923', 'lng' => '5.8929', 'postal_code' => '4801', 'name' => 'Stembert'),
      array('lat' => '50.5745', 'lng' => '5.8663', 'postal_code' => '4802', 'name' => 'Heusy'),
      array('lat' => '50.6125', 'lng' => '5.8534', 'postal_code' => '4820', 'name' => 'Dison'),
      array('lat' => '50.6140', 'lng' => '5.8845', 'postal_code' => '4821', 'name' => 'Andrimont'),
      array('lat' => '50.6037', 'lng' => '5.9357', 'postal_code' => '4830', 'name' => 'Limbourg'),
      array('lat' => '50.6244', 'lng' => '5.9199', 'postal_code' => '4831', 'name' => 'Bilstain'),
      array('lat' => '50.6062', 'lng' => '5.9568', 'postal_code' => '4834', 'name' => 'Goé'),
      array('lat' => '50.6302', 'lng' => '5.9692', 'postal_code' => '4837', 'name' => 'Baelen'),
      array('lat' => '50.6191', 'lng' => '5.9950', 'postal_code' => '4837', 'name' => 'Membach'),
      array('lat' => '50.6569', 'lng' => '5.9630', 'postal_code' => '4840', 'name' => 'Welkenraedt'),
      array('lat' => '50.6691', 'lng' => '5.9272', 'postal_code' => '4841', 'name' => 'Henri-Chapelle'),
      array('lat' => '50.5588', 'lng' => '5.9663', 'postal_code' => '4845', 'name' => 'Jalhay'),
      array('lat' => '50.5169', 'lng' => '5.9320', 'postal_code' => '4845', 'name' => 'Sart-Lez-Spa'),
      array('lat' => '50.7076', 'lng' => '5.9619', 'postal_code' => '4850', 'name' => 'Montzen'),
      array('lat' => '50.7211', 'lng' => '5.9890', 'postal_code' => '4850', 'name' => 'Moresnet'),
      array('lat' => '50.7194', 'lng' => '5.9635', 'postal_code' => '4850', 'name' => 'PlombiÈres'),
      array('lat' => '50.7453', 'lng' => '5.9944', 'postal_code' => '4851', 'name' => 'Gemmenich'),
      array('lat' => '50.7507', 'lng' => '5.9337', 'postal_code' => '4851', 'name' => 'Sippenaeken'),
      array('lat' => '50.7233', 'lng' => '5.9212', 'postal_code' => '4852', 'name' => 'Hombourg'),
      array('lat' => '50.5723', 'lng' => '5.7956', 'postal_code' => '4860', 'name' => 'Cornesse'),
      array('lat' => '50.5683', 'lng' => '5.8033', 'postal_code' => '4860', 'name' => 'Pepinster'),
      array('lat' => '50.5792', 'lng' => '5.8167', 'postal_code' => '4860', 'name' => 'Wegnez'),
      array('lat' => '50.5918', 'lng' => '5.7904', 'postal_code' => '4861', 'name' => 'Soiron'),
      array('lat' => '50.5836', 'lng' => '5.6999', 'postal_code' => '4870', 'name' => 'Forêt'),
      array('lat' => '50.5656', 'lng' => '5.7238', 'postal_code' => '4870', 'name' => 'Fraipont'),
      array('lat' => '50.5729', 'lng' => '5.7370', 'postal_code' => '4870', 'name' => 'Nessonvaux'),
      array('lat' => '50.5787', 'lng' => '5.6731', 'postal_code' => '4870', 'name' => 'Trooz'),
      array('lat' => '50.5901', 'lng' => '5.7466', 'postal_code' => '4877', 'name' => 'Olne'),
      array('lat' => '50.7021', 'lng' => '5.8592', 'postal_code' => '4880', 'name' => 'Aubel'),
      array('lat' => '50.6542', 'lng' => '5.8640', 'postal_code' => '4890', 'name' => 'Thimister'),
      array('lat' => '50.6542', 'lng' => '5.8640', 'postal_code' => '4890', 'name' => 'Thimister-Clermont'),
      array('lat' => '50.4924', 'lng' => '5.8643', 'postal_code' => '4900', 'name' => 'Spa'),
      array('lat' => '50.4894', 'lng' => '5.7906', 'postal_code' => '4910', 'name' => 'La Reid'),
      array('lat' => '50.5390', 'lng' => '5.8807', 'postal_code' => '4910', 'name' => 'Polleur'),
      array('lat' => '50.5351', 'lng' => '5.8142', 'postal_code' => '4910', 'name' => 'Theux'),
      array('lat' => '50.4732', 'lng' => '5.6758', 'postal_code' => '4920', 'name' => 'Aywaille'),
      array('lat' => '50.4034', 'lng' => '5.6663', 'postal_code' => '4920', 'name' => 'Ernonheid'),
      array('lat' => '50.4410', 'lng' => '5.6665', 'postal_code' => '4920', 'name' => 'Harzé'),
      array('lat' => '50.4840', 'lng' => '5.7175', 'postal_code' => '4920', 'name' => 'Louveigné'),
      array('lat' => '50.4799', 'lng' => '5.7119', 'postal_code' => '4920', 'name' => 'Sougné-Remouchamps'),
      array('lat' => '50.4027', 'lng' => '6.1409', 'postal_code' => '4950', 'name' => 'Faymonville'),
      array('lat' => '50.4545', 'lng' => '6.1221', 'postal_code' => '4950', 'name' => 'Robertville'),
      array('lat' => '50.4790', 'lng' => '6.1118', 'postal_code' => '4950', 'name' => 'Sourbrodt'),
      array('lat' => '50.4149', 'lng' => '6.1116', 'postal_code' => '4950', 'name' => 'Waimes'),
      array('lat' => '50.3907', 'lng' => '6.0058', 'postal_code' => '4960', 'name' => 'Bellevaux-Ligneuville'),
      array('lat' => '50.4409', 'lng' => '6.0357', 'postal_code' => '4960', 'name' => 'Bevercé'),
      array('lat' => '50.4246', 'lng' => '6.0283', 'postal_code' => '4960', 'name' => 'Malmedy'),
      array('lat' => '50.4543', 'lng' => '5.9522', 'postal_code' => '4970', 'name' => 'Francorchamps'),
      array('lat' => '50.3941', 'lng' => '5.9304', 'postal_code' => '4970', 'name' => 'Stavelot'),
      array('lat' => '50.3412', 'lng' => '5.8412', 'postal_code' => '4980', 'name' => 'Fosse'),
      array('lat' => '50.3529', 'lng' => '5.9177', 'postal_code' => '4980', 'name' => 'Trois-Ponts'),
      array('lat' => '50.3550', 'lng' => '5.9217', 'postal_code' => '4980', 'name' => 'Wanne'),
      array('lat' => '50.3566', 'lng' => '5.8305', 'postal_code' => '4983', 'name' => 'Basse-Bodeux'),
      array('lat' => '50.3803', 'lng' => '5.7325', 'postal_code' => '4987', 'name' => 'Chevron'),
      array('lat' => '50.4113', 'lng' => '5.8492', 'postal_code' => '4987', 'name' => 'La Gleize'),
      array('lat' => '50.4163', 'lng' => '5.7350', 'postal_code' => '4987', 'name' => 'Lorcé'),
      array('lat' => '50.3849', 'lng' => '5.7808', 'postal_code' => '4987', 'name' => 'Rahier'),
      array('lat' => '50.4068', 'lng' => '5.8086', 'postal_code' => '4987', 'name' => 'Stoumont'),
      array('lat' => '50.3028', 'lng' => '5.8354', 'postal_code' => '4990', 'name' => 'Arbrefontaine'),
      array('lat' => '50.3234', 'lng' => '5.7323', 'postal_code' => '4990', 'name' => 'Bra'),
      array('lat' => '50.2848', 'lng' => '5.7950', 'postal_code' => '4990', 'name' => 'Lierneux')
    ],
    'WNA' => [
      array('lat' => '50.4687', 'lng' => '4.9118', 'postal_code' => '5000', 'name' => 'Beez'),
      array('lat' => '50.4593', 'lng' => '4.8505', 'postal_code' => '5000', 'name' => 'Namur'),
      array('lat' => '50.4707', 'lng' => '4.8256', 'postal_code' => '5001', 'name' => 'Belgrade'),
      array('lat' => '50.4766', 'lng' => '4.8345', 'postal_code' => '5002', 'name' => 'Saint-Servais'),
      array('lat' => '50.4915', 'lng' => '4.8473', 'postal_code' => '5003', 'name' => 'Saint-Marc'),
      array('lat' => '50.4720', 'lng' => '4.8915', 'postal_code' => '5004', 'name' => 'Bouge'),
      array('lat' => '50.4609', 'lng' => '4.8679', 'postal_code' => '5012', 'name' => 'Parlement Wallon'),
      array('lat' => '50.4958', 'lng' => '4.9016', 'postal_code' => '5020', 'name' => 'Champion'),
      array('lat' => '50.5182', 'lng' => '4.8886', 'postal_code' => '5020', 'name' => 'Daussoulx'),
      array('lat' => '50.4574', 'lng' => '4.8110', 'postal_code' => '5020', 'name' => 'Flawinne'),
      array('lat' => '50.4390', 'lng' => '4.7957', 'postal_code' => '5020', 'name' => 'Malonne'),
      array('lat' => '50.4820', 'lng' => '4.7789', 'postal_code' => '5020', 'name' => 'Suarlée'),
      array('lat' => '50.4853', 'lng' => '4.7543', 'postal_code' => '5020', 'name' => 'Temploux'),
      array('lat' => '50.5022', 'lng' => '4.8761', 'postal_code' => '5020', 'name' => 'Vedrin'),
      array('lat' => '50.4954', 'lng' => '4.9325', 'postal_code' => '5021', 'name' => 'Boninne'),
      array('lat' => '50.5148', 'lng' => '4.9071', 'postal_code' => '5022', 'name' => 'Cognelée'),
      array('lat' => '50.5055', 'lng' => '4.9561', 'postal_code' => '5024', 'name' => 'Gelbressée'),
      array('lat' => '50.4863', 'lng' => '4.9603', 'postal_code' => '5024', 'name' => 'Marche-Les-Dames'),
      array('lat' => '50.5339', 'lng' => '4.7458', 'postal_code' => '5030', 'name' => 'Beuzet'),
      array('lat' => '50.5924', 'lng' => '4.6719', 'postal_code' => '5030', 'name' => 'Ernage'),
      array('lat' => '50.5743', 'lng' => '4.7017', 'postal_code' => '5030', 'name' => 'Gembloux'),
      array('lat' => '50.5571', 'lng' => '4.6755', 'postal_code' => '5030', 'name' => 'Grand-Manil'),
      array('lat' => '50.5530', 'lng' => '4.7264', 'postal_code' => '5030', 'name' => 'Lonzée'),
      array('lat' => '50.5807', 'lng' => '4.7235', 'postal_code' => '5030', 'name' => 'Sauvenière'),
      array('lat' => '50.5837', 'lng' => '4.7747', 'postal_code' => '5031', 'name' => 'Grand-Leez'),
      array('lat' => '50.5180', 'lng' => '4.6958', 'postal_code' => '5032', 'name' => 'Bossière'),
      array('lat' => '50.5204', 'lng' => '4.6489', 'postal_code' => '5032', 'name' => 'Bothey'),
      array('lat' => '50.5388', 'lng' => '4.6628', 'postal_code' => '5032', 'name' => 'Corroy-Le-Château'),
      array('lat' => '50.5060', 'lng' => '4.7283', 'postal_code' => '5032', 'name' => 'Isnes'),
      array('lat' => '50.5105', 'lng' => '4.6726', 'postal_code' => '5032', 'name' => 'Mazy'),
      array('lat' => '50.4285', 'lng' => '4.6388', 'postal_code' => '5060', 'name' => 'Arsimont'),
      array('lat' => '50.4494', 'lng' => '4.6302', 'postal_code' => '5060', 'name' => 'Auvelais'),
      array('lat' => '50.4178', 'lng' => '4.6209', 'postal_code' => '5060', 'name' => 'Falisolle'),
      array('lat' => '50.4526', 'lng' => '4.5960', 'postal_code' => '5060', 'name' => 'Keumiée'),
      array('lat' => '50.4454', 'lng' => '4.5846', 'postal_code' => '5060', 'name' => 'Moignelée'),
      array('lat' => '50.4467', 'lng' => '4.6307', 'postal_code' => '5060', 'name' => 'Sambreville'),
      array('lat' => '50.4335', 'lng' => '4.6082', 'postal_code' => '5060', 'name' => 'Tamines'),
      array('lat' => '50.4674', 'lng' => '4.6140', 'postal_code' => '5060', 'name' => 'Velaine-Sur-Sambre'),
      array('lat' => '50.4050', 'lng' => '4.6521', 'postal_code' => '5070', 'name' => 'Aisemont'),
      array('lat' => '50.3946', 'lng' => '4.6962', 'postal_code' => '5070', 'name' => 'Fosses-La-Ville'),
      array('lat' => '50.3890', 'lng' => '4.6240', 'postal_code' => '5070', 'name' => 'Le Roux'),
      array('lat' => '50.3754', 'lng' => '4.6026', 'postal_code' => '5070', 'name' => 'Sart-Eustache'),
      array('lat' => '50.4022', 'lng' => '4.7417', 'postal_code' => '5070', 'name' => 'Sart-Saint-Laurent'),
      array('lat' => '50.3986', 'lng' => '4.6596', 'postal_code' => '5070', 'name' => 'Vitrival'),
      array('lat' => '50.5121', 'lng' => '4.8447', 'postal_code' => '5080', 'name' => 'Emines'),
      array('lat' => '50.5074', 'lng' => '4.8151', 'postal_code' => '5080', 'name' => 'La BruyÈre'),
      array('lat' => '50.5063', 'lng' => '4.8057', 'postal_code' => '5080', 'name' => 'Rhisnes'),
      array('lat' => '50.5300', 'lng' => '4.8456', 'postal_code' => '5080', 'name' => 'Villers-Lez-Heest'),
      array('lat' => '50.5366', 'lng' => '4.8666', 'postal_code' => '5080', 'name' => 'Warisoulx'),
      array('lat' => '50.5192', 'lng' => '4.7806', 'postal_code' => '5081', 'name' => 'Bovesse'),
      array('lat' => '50.5520', 'lng' => '4.8010', 'postal_code' => '5081', 'name' => 'Meux'),
      array('lat' => '50.5353', 'lng' => '4.7819', 'postal_code' => '5081', 'name' => 'Saint-Denis-Bovesse'),
      array('lat' => '50.4144', 'lng' => '4.8878', 'postal_code' => '5100', 'name' => 'Dave'),
      array('lat' => '50.4564', 'lng' => '4.8719', 'postal_code' => '5100', 'name' => 'Jambes'),
      array('lat' => '50.4186', 'lng' => '4.9239', 'postal_code' => '5100', 'name' => 'Naninne'),
      array('lat' => '50.4212', 'lng' => '4.8633', 'postal_code' => '5100', 'name' => 'Wépion'),
      array('lat' => '50.4260', 'lng' => '4.9510', 'postal_code' => '5100', 'name' => 'Wierde'),
      array('lat' => '50.4516', 'lng' => '4.9050', 'postal_code' => '5101', 'name' => 'Erpent'),
      array('lat' => '50.4655', 'lng' => '4.9241', 'postal_code' => '5101', 'name' => 'Lives-Sur-Meuse'),
      array('lat' => '50.4629', 'lng' => '4.9518', 'postal_code' => '5101', 'name' => 'Loyers'),
      array('lat' => '50.5002', 'lng' => '4.6094', 'postal_code' => '5140', 'name' => 'Boignée'),
      array('lat' => '50.5123', 'lng' => '4.5770', 'postal_code' => '5140', 'name' => 'Ligny'),
      array('lat' => '50.5287', 'lng' => '4.5884', 'postal_code' => '5140', 'name' => 'Sombreffe'),
      array('lat' => '50.5155', 'lng' => '4.6253', 'postal_code' => '5140', 'name' => 'Tongrinne'),
      array('lat' => '50.4341', 'lng' => '4.7592', 'postal_code' => '5150', 'name' => 'Floreffe'),
      array('lat' => '50.4520', 'lng' => '4.7716', 'postal_code' => '5150', 'name' => 'Floriffoux'),
      array('lat' => '50.4359', 'lng' => '4.7328', 'postal_code' => '5150', 'name' => 'Franière'),
      array('lat' => '50.4494', 'lng' => '4.7304', 'postal_code' => '5150', 'name' => 'Soye'),
      array('lat' => '50.3902', 'lng' => '4.8241', 'postal_code' => '5170', 'name' => 'Bois-De-Villers'),
      array('lat' => '50.3769', 'lng' => '4.7779', 'postal_code' => '5170', 'name' => 'Lesve'),
      array('lat' => '50.3783', 'lng' => '4.8988', 'postal_code' => '5170', 'name' => 'Lustin'),
      array('lat' => '50.3757', 'lng' => '4.8674', 'postal_code' => '5170', 'name' => 'Profondeville'),
      array('lat' => '50.3566', 'lng' => '4.8745', 'postal_code' => '5170', 'name' => 'Rivière'),
      array('lat' => '50.5003', 'lng' => '4.6396', 'postal_code' => '5190', 'name' => 'Balâtre'),
      array('lat' => '50.4427', 'lng' => '4.6735', 'postal_code' => '5190', 'name' => 'Ham-Sur-Sambre'),
      array('lat' => '50.4631', 'lng' => '4.6787', 'postal_code' => '5190', 'name' => 'Jemeppe-Sur-Sambre'),
      array('lat' => '50.4564', 'lng' => '4.7043', 'postal_code' => '5190', 'name' => 'Mornimont'),
      array('lat' => '50.4569', 'lng' => '4.6944', 'postal_code' => '5190', 'name' => 'Moustier-Sur-Sambre'),
      array('lat' => '50.4920', 'lng' => '4.6697', 'postal_code' => '5190', 'name' => 'Onoz'),
      array('lat' => '50.5019', 'lng' => '4.6473', 'postal_code' => '5190', 'name' => 'Saint-Martin'),
      array('lat' => '50.4797', 'lng' => '4.7042', 'postal_code' => '5190', 'name' => 'Spy'),
      array('lat' => '50.4912', 'lng' => '5.0965', 'postal_code' => '5300', 'name' => 'Andenne'),
      array('lat' => '50.4720', 'lng' => '5.0370', 'postal_code' => '5300', 'name' => 'Bonneville'),
      array('lat' => '50.4630', 'lng' => '5.1167', 'postal_code' => '5300', 'name' => 'Coutisse'),
      array('lat' => '50.5150', 'lng' => '5.0670', 'postal_code' => '5300', 'name' => 'Landenne'),
      array('lat' => '50.4596', 'lng' => '4.9790', 'postal_code' => '5300', 'name' => 'Maizeret'),
      array('lat' => '50.4720', 'lng' => '4.9946', 'postal_code' => '5300', 'name' => 'Namêche'),
      array('lat' => '50.4896', 'lng' => '5.0277', 'postal_code' => '5300', 'name' => 'Sclayn'),
      array('lat' => '50.5002', 'lng' => '5.0931', 'postal_code' => '5300', 'name' => 'Seilles'),
      array('lat' => '50.4634', 'lng' => '5.0146', 'postal_code' => '5300', 'name' => 'Thon'),
      array('lat' => '50.4958', 'lng' => '5.0088', 'postal_code' => '5300', 'name' => 'Vezin'),
      array('lat' => '50.5995', 'lng' => '4.8382', 'postal_code' => '5310', 'name' => 'Aische-En-Refail'),
      array('lat' => '50.6008', 'lng' => '4.9294', 'postal_code' => '5310', 'name' => 'Bolinne'),
      array('lat' => '50.6251', 'lng' => '4.9551', 'postal_code' => '5310', 'name' => 'Boneffe'),
      array('lat' => '50.6291', 'lng' => '4.9711', 'postal_code' => '5310', 'name' => 'Branchon'),
      array('lat' => '50.5596', 'lng' => '4.8593', 'postal_code' => '5310', 'name' => 'Dhuy'),
      array('lat' => '50.5927', 'lng' => '4.9037', 'postal_code' => '5310', 'name' => 'EghezÉe'),
      array('lat' => '50.5809', 'lng' => '4.9477', 'postal_code' => '5310', 'name' => 'Hanret'),
      array('lat' => '50.5460', 'lng' => '4.9062', 'postal_code' => '5310', 'name' => 'Leuze'),
      array('lat' => '50.5837', 'lng' => '4.8308', 'postal_code' => '5310', 'name' => 'Liernu'),
      array('lat' => '50.5944', 'lng' => '4.8761', 'postal_code' => '5310', 'name' => 'Mehaigne'),
      array('lat' => '50.6092', 'lng' => '4.8931', 'postal_code' => '5310', 'name' => 'Noville-Sur-Méhaigne'),
      array('lat' => '50.5727', 'lng' => '4.8422', 'postal_code' => '5310', 'name' => 'Saint-Germain'),
      array('lat' => '50.6173', 'lng' => '4.9315', 'postal_code' => '5310', 'name' => 'Taviers'),
      array('lat' => '50.5716', 'lng' => '4.8722', 'postal_code' => '5310', 'name' => 'Upigny'),
      array('lat' => '50.5428', 'lng' => '4.9264', 'postal_code' => '5310', 'name' => 'Waret-La-Chaussée'),
      array('lat' => '50.3777', 'lng' => '4.9422', 'postal_code' => '5330', 'name' => 'Assesse'),
      array('lat' => '50.3772', 'lng' => '4.9707', 'postal_code' => '5330', 'name' => 'Maillen'),
      array('lat' => '50.4024', 'lng' => '4.9631', 'postal_code' => '5330', 'name' => 'Sart-Bernard'),
      array('lat' => '50.3501', 'lng' => '4.9612', 'postal_code' => '5332', 'name' => 'Crupet'),
      array('lat' => '50.3893', 'lng' => '5.0255', 'postal_code' => '5333', 'name' => 'Sorinne-La-Longue'),
      array('lat' => '50.3742', 'lng' => '5.0689', 'postal_code' => '5334', 'name' => 'Florée'),
      array('lat' => '50.3799', 'lng' => '4.9853', 'postal_code' => '5336', 'name' => 'Courrière'),
      array('lat' => '50.4269', 'lng' => '5.0209', 'postal_code' => '5340', 'name' => 'Faulx-Les-Tombes'),
      array('lat' => '50.4025', 'lng' => '5.0756', 'postal_code' => '5340', 'name' => 'Gesves'),
      array('lat' => '50.4511', 'lng' => '5.0750', 'postal_code' => '5340', 'name' => 'Haltinne'),
      array('lat' => '50.4443', 'lng' => '4.9854', 'postal_code' => '5340', 'name' => 'Mozet'),
      array('lat' => '50.3974', 'lng' => '5.1200', 'postal_code' => '5340', 'name' => 'Sorée'),
      array('lat' => '50.4119', 'lng' => '5.1736', 'postal_code' => '5350', 'name' => 'Evelette'),
      array('lat' => '50.4145', 'lng' => '5.1674', 'postal_code' => '5350', 'name' => 'Ohey'),
      array('lat' => '50.4422', 'lng' => '5.1542', 'postal_code' => '5351', 'name' => 'Haillot'),
      array('lat' => '50.4521', 'lng' => '5.1717', 'postal_code' => '5352', 'name' => 'Perwez-Haillot'),
      array('lat' => '50.4400', 'lng' => '5.2209', 'postal_code' => '5353', 'name' => 'Goesnes'),
      array('lat' => '50.4433', 'lng' => '5.1834', 'postal_code' => '5354', 'name' => 'Jallet'),
      array('lat' => '50.3454', 'lng' => '5.0922', 'postal_code' => '5360', 'name' => 'Hamois'),
      array('lat' => '50.3430', 'lng' => '5.0580', 'postal_code' => '5360', 'name' => 'Natoye'),
      array('lat' => '50.3181', 'lng' => '5.1924', 'postal_code' => '5361', 'name' => 'Mohiville'),
      array('lat' => '50.3048', 'lng' => '5.2072', 'postal_code' => '5361', 'name' => 'Scy'),
      array('lat' => '50.3330', 'lng' => '5.1749', 'postal_code' => '5362', 'name' => 'Achet'),
      array('lat' => '50.3254', 'lng' => '5.1231', 'postal_code' => '5363', 'name' => 'Emptinne'),
      array('lat' => '50.3589', 'lng' => '5.1245', 'postal_code' => '5364', 'name' => 'Schaltin'),
      array('lat' => '50.3289', 'lng' => '5.2609', 'postal_code' => '5370', 'name' => 'Barvaux-Condroz'),
      array('lat' => '50.3889', 'lng' => '5.1839', 'postal_code' => '5370', 'name' => 'Flostoy'),
      array('lat' => '50.3647', 'lng' => '5.2396', 'postal_code' => '5370', 'name' => 'Havelange'),
      array('lat' => '50.3541', 'lng' => '5.2401', 'postal_code' => '5370', 'name' => 'Jeneffe'),
      array('lat' => '50.3678', 'lng' => '5.2794', 'postal_code' => '5370', 'name' => 'Verlée'),
      array('lat' => '50.3632', 'lng' => '5.3363', 'postal_code' => '5372', 'name' => 'Méan'),
      array('lat' => '50.3535', 'lng' => '5.3114', 'postal_code' => '5374', 'name' => 'Maffe'),
      array('lat' => '50.3669', 'lng' => '5.2486', 'postal_code' => '5376', 'name' => 'Miécret'),
      array('lat' => '50.2899', 'lng' => '5.3387', 'postal_code' => '5377', 'name' => 'Baillonville'),
      array('lat' => '50.3740', 'lng' => '5.3826', 'postal_code' => '5377', 'name' => 'Bonsin'),
      array('lat' => '50.2942', 'lng' => '5.2964', 'postal_code' => '5377', 'name' => 'Heure'),
      array('lat' => '50.2491', 'lng' => '5.2798', 'postal_code' => '5377', 'name' => 'Hogne'),
      array('lat' => '50.2908', 'lng' => '5.2588', 'postal_code' => '5377', 'name' => 'Nettinne'),
      array('lat' => '50.2991', 'lng' => '5.3746', 'postal_code' => '5377', 'name' => 'Noiseux'),
      array('lat' => '50.2749', 'lng' => '5.2548', 'postal_code' => '5377', 'name' => 'Sinsin'),
      array('lat' => '50.3399', 'lng' => '5.3701', 'postal_code' => '5377', 'name' => 'Somme-Leuze'),
      array('lat' => '50.2604', 'lng' => '5.3045', 'postal_code' => '5377', 'name' => 'Waillet'),
      array('lat' => '50.5558', 'lng' => '5.0363', 'postal_code' => '5380', 'name' => 'Bierwart'),
      array('lat' => '50.5677', 'lng' => '4.9569', 'postal_code' => '5380', 'name' => 'Cortil-Wodon'),
      array('lat' => '50.5521', 'lng' => '4.9855', 'postal_code' => '5380', 'name' => 'Fernelmont'),
      array('lat' => '50.5739', 'lng' => '4.9983', 'postal_code' => '5380', 'name' => 'Forville'),
      array('lat' => '50.5208', 'lng' => '4.9814', 'postal_code' => '5380', 'name' => 'Franc-Waret'),
      array('lat' => '50.6033', 'lng' => '4.9884', 'postal_code' => '5380', 'name' => 'Hemptinne'),
      array('lat' => '50.5255', 'lng' => '5.0069', 'postal_code' => '5380', 'name' => 'Hingeon'),
      array('lat' => '50.5229', 'lng' => '4.9415', 'postal_code' => '5380', 'name' => 'Marchovelette'),
      array('lat' => '50.5568', 'lng' => '4.9842', 'postal_code' => '5380', 'name' => 'Noville-Les-Bois'),
      array('lat' => '50.5491', 'lng' => '5.0210', 'postal_code' => '5380', 'name' => 'Pontillas'),
      array('lat' => '50.5446', 'lng' => '4.9458', 'postal_code' => '5380', 'name' => 'Tillier'),
      array('lat' => '50.2396', 'lng' => '4.8995', 'postal_code' => '5500', 'name' => 'Anseremme'),
      array('lat' => '50.2721', 'lng' => '4.8993', 'postal_code' => '5500', 'name' => 'Bouvignes-Sur-Meuse'),
      array('lat' => '50.2340', 'lng' => '4.9169', 'postal_code' => '5500', 'name' => 'Dinant'),
      array('lat' => '50.2370', 'lng' => '4.9441', 'postal_code' => '5500', 'name' => 'Dréhance'),
      array('lat' => '50.2000', 'lng' => '4.8978', 'postal_code' => '5500', 'name' => 'Falmagne'),
      array('lat' => '50.2054', 'lng' => '4.8927', 'postal_code' => '5500', 'name' => 'Falmignoul'),
      array('lat' => '50.2239', 'lng' => '4.9588', 'postal_code' => '5500', 'name' => 'Furfooz'),
      array('lat' => '50.2809', 'lng' => '4.9711', 'postal_code' => '5501', 'name' => 'Lisogne'),
      array('lat' => '50.2796', 'lng' => '4.9872', 'postal_code' => '5502', 'name' => 'Thynes'),
      array('lat' => '50.2592', 'lng' => '4.9789', 'postal_code' => '5503', 'name' => 'Sorinnes'),
      array('lat' => '50.2470', 'lng' => '4.9899', 'postal_code' => '5504', 'name' => 'Foy-Notre-Dame'),
      array('lat' => '50.2400', 'lng' => '4.7612', 'postal_code' => '5520', 'name' => 'Anthée'),
      array('lat' => '50.2425', 'lng' => '4.8379', 'postal_code' => '5520', 'name' => 'Onhaye'),
      array('lat' => '50.2501', 'lng' => '4.7806', 'postal_code' => '5521', 'name' => 'Serville'),
      array('lat' => '50.2790', 'lng' => '4.7936', 'postal_code' => '5522', 'name' => 'Falaen'),
      array('lat' => '50.2738', 'lng' => '4.8428', 'postal_code' => '5523', 'name' => 'Sommière'),
      array('lat' => '50.2606', 'lng' => '4.8251', 'postal_code' => '5523', 'name' => 'Weillen'),
      array('lat' => '50.2461', 'lng' => '4.8162', 'postal_code' => '5524', 'name' => 'Gerin'),
      array('lat' => '50.3150', 'lng' => '4.9759', 'postal_code' => '5530', 'name' => 'Dorinne'),
      array('lat' => '50.3363', 'lng' => '4.9866', 'postal_code' => '5530', 'name' => 'Durnal'),
      array('lat' => '50.3205', 'lng' => '4.9121', 'postal_code' => '5530', 'name' => 'Evrehailles'),
      array('lat' => '50.3479', 'lng' => '4.8733', 'postal_code' => '5530', 'name' => 'Godinne'),
      array('lat' => '50.3017', 'lng' => '4.8983', 'postal_code' => '5530', 'name' => 'Houx'),
      array('lat' => '50.3122', 'lng' => '4.9440', 'postal_code' => '5530', 'name' => 'Purnode'),
      array('lat' => '50.3223', 'lng' => '5.0058', 'postal_code' => '5530', 'name' => 'Spontin'),
      array('lat' => '50.3270', 'lng' => '4.8779', 'postal_code' => '5530', 'name' => 'Yvoir'),
      array('lat' => '50.3106', 'lng' => '4.8783', 'postal_code' => '5537', 'name' => 'AnhÉe'),
      array('lat' => '50.3474', 'lng' => '4.8488', 'postal_code' => '5537', 'name' => 'Annevoie-Rouillon'),
      array('lat' => '50.3311', 'lng' => '4.7961', 'postal_code' => '5537', 'name' => 'Bioul'),
      array('lat' => '50.3186', 'lng' => '4.7522', 'postal_code' => '5537', 'name' => 'Denée'),
      array('lat' => '50.3060', 'lng' => '4.8429', 'postal_code' => '5537', 'name' => 'Haut-Le-Wastia'),
      array('lat' => '50.2952', 'lng' => '4.7818', 'postal_code' => '5537', 'name' => 'Sosoye'),
      array('lat' => '50.3228', 'lng' => '4.8444', 'postal_code' => '5537', 'name' => 'Warnant'),
      array('lat' => '50.2128', 'lng' => '4.8081', 'postal_code' => '5540', 'name' => 'HastiÈre'),
      array('lat' => '50.2183', 'lng' => '4.8246', 'postal_code' => '5540', 'name' => 'Hastière-Lavaux'),
      array('lat' => '50.1978', 'lng' => '4.8167', 'postal_code' => '5540', 'name' => 'Hermeton-Sur-Meuse'),
      array('lat' => '50.2036', 'lng' => '4.8662', 'postal_code' => '5540', 'name' => 'Waulsort'),
      array('lat' => '50.2148', 'lng' => '4.8290', 'postal_code' => '5541', 'name' => 'Hastière-Par-Delà'),
      array('lat' => '50.1920', 'lng' => '4.8430', 'postal_code' => '5542', 'name' => 'Blaimont'),
      array('lat' => '50.1635', 'lng' => '4.8321', 'postal_code' => '5543', 'name' => 'Heer'),
      array('lat' => '50.1657', 'lng' => '4.7959', 'postal_code' => '5544', 'name' => 'Agimont'),
      array('lat' => '49.8420', 'lng' => '4.9697', 'postal_code' => '5550', 'name' => 'Alle'),
      array('lat' => '49.8242', 'lng' => '4.8752', 'postal_code' => '5550', 'name' => 'Bagimont'),
      array('lat' => '49.8635', 'lng' => '4.8853', 'postal_code' => '5550', 'name' => 'Bohan'),
      array('lat' => '49.8620', 'lng' => '4.9512', 'postal_code' => '5550', 'name' => 'Chairière'),
      array('lat' => '49.8632', 'lng' => '4.9300', 'postal_code' => '5550', 'name' => 'Laforet'),
      array('lat' => '49.8657', 'lng' => '4.9019', 'postal_code' => '5550', 'name' => 'Membre'),
      array('lat' => '49.8538', 'lng' => '4.9632', 'postal_code' => '5550', 'name' => 'Mouzaive'),
      array('lat' => '49.9109', 'lng' => '4.9174', 'postal_code' => '5550', 'name' => 'Nafraiture'),
      array('lat' => '49.8936', 'lng' => '4.9282', 'postal_code' => '5550', 'name' => 'Orchimont'),
      array('lat' => '49.8113', 'lng' => '4.8684', 'postal_code' => '5550', 'name' => 'Pussemange'),
      array('lat' => '49.8144', 'lng' => '4.9019', 'postal_code' => '5550', 'name' => 'Sugny'),
      array('lat' => '49.8726', 'lng' => '4.9327', 'postal_code' => '5550', 'name' => 'Vresse-Sur-Semois'),
      array('lat' => '49.8994', 'lng' => '5.0264', 'postal_code' => '5555', 'name' => 'Baillamont'),
      array('lat' => '49.9414', 'lng' => '5.0166', 'postal_code' => '5555', 'name' => 'BiÈvre'),
      array('lat' => '49.8622', 'lng' => '4.9984', 'postal_code' => '5555', 'name' => 'Cornimont'),
      array('lat' => '49.9515', 'lng' => '5.0661', 'postal_code' => '5555', 'name' => 'Graide'),
      array('lat' => '49.8704', 'lng' => '4.9831', 'postal_code' => '5555', 'name' => 'Gros-Fays'),
      array('lat' => '49.9058', 'lng' => '4.9878', 'postal_code' => '5555', 'name' => 'Monceau-En-Ardenne'),
      array('lat' => '49.9221', 'lng' => '5.0893', 'postal_code' => '5555', 'name' => 'Naomé'),
      array('lat' => '49.8936', 'lng' => '5.0092', 'postal_code' => '5555', 'name' => 'Oizy'),
      array('lat' => '49.9021', 'lng' => '4.9687', 'postal_code' => '5555', 'name' => 'Petit-Fays'),
      array('lat' => '50.1676', 'lng' => '5.0882', 'postal_code' => '5560', 'name' => 'Ciergnon'),
      array('lat' => '50.1580', 'lng' => '4.9441', 'postal_code' => '5560', 'name' => 'Finnevaux'),
      array('lat' => '50.1694', 'lng' => '4.9799', 'postal_code' => '5560', 'name' => 'Houyet'),
      array('lat' => '50.2013', 'lng' => '4.9465', 'postal_code' => '5560', 'name' => 'Hulsonniaux'),
      array('lat' => '50.1649', 'lng' => '4.9635', 'postal_code' => '5560', 'name' => 'Mesnil-Eglise'),
      array('lat' => '50.1688', 'lng' => '4.8851', 'postal_code' => '5560', 'name' => 'Mesnil-Saint-Blaise'),
      array('lat' => '50.2110', 'lng' => '5.0491', 'postal_code' => '5562', 'name' => 'Custinne'),
      array('lat' => '50.1617', 'lng' => '5.0404', 'postal_code' => '5563', 'name' => 'Hour'),
      array('lat' => '50.1595', 'lng' => '5.0620', 'postal_code' => '5564', 'name' => 'Wanlin'),
      array('lat' => '50.1271', 'lng' => '4.9444', 'postal_code' => '5570', 'name' => 'Baronville'),
      array('lat' => '50.1004', 'lng' => '4.9060', 'postal_code' => '5570', 'name' => 'Beauraing'),
      array('lat' => '50.1178', 'lng' => '4.8891', 'postal_code' => '5570', 'name' => 'Dion'),
      array('lat' => '50.0681', 'lng' => '4.8491', 'postal_code' => '5570', 'name' => 'Felenne'),
      array('lat' => '50.1511', 'lng' => '4.9149', 'postal_code' => '5570', 'name' => 'Feschaux'),
      array('lat' => '50.0816', 'lng' => '5.0393', 'postal_code' => '5570', 'name' => 'Honnay'),
      array('lat' => '50.1022', 'lng' => '4.9191', 'postal_code' => '5570', 'name' => 'Javingue'),
      array('lat' => '50.0615', 'lng' => '4.9781', 'postal_code' => '5570', 'name' => 'Vonêche'),
      array('lat' => '50.0917', 'lng' => '4.9616', 'postal_code' => '5570', 'name' => 'Wancennes'),
      array('lat' => '50.0968', 'lng' => '4.8940', 'postal_code' => '5570', 'name' => 'Winenne'),
      array('lat' => '50.1485', 'lng' => '4.9774', 'postal_code' => '5571', 'name' => 'Wiesme'),
      array('lat' => '50.1318', 'lng' => '5.0379', 'postal_code' => '5572', 'name' => 'Focant'),
      array('lat' => '50.1174', 'lng' => '5.0056', 'postal_code' => '5573', 'name' => 'Martouzin-Neuville'),
      array('lat' => '50.0989', 'lng' => '5.0102', 'postal_code' => '5574', 'name' => 'Pondrôme'),
      array('lat' => '50.0249', 'lng' => '4.8549', 'postal_code' => '5575', 'name' => 'Bourseigne-Neuve'),
      array('lat' => '50.0221', 'lng' => '4.8702', 'postal_code' => '5575', 'name' => 'Bourseigne-Vieille'),
      array('lat' => '49.9808', 'lng' => '4.9371', 'postal_code' => '5575', 'name' => 'Gedinne'),
      array('lat' => '49.9415', 'lng' => '4.9443', 'postal_code' => '5575', 'name' => 'Houdremont'),
      array('lat' => '49.9584', 'lng' => '4.9579', 'postal_code' => '5575', 'name' => 'Louette-Saint-Denis'),
      array('lat' => '49.9605', 'lng' => '4.9275', 'postal_code' => '5575', 'name' => 'Louette-Saint-Pierre'),
      array('lat' => '50.0111', 'lng' => '4.9624', 'postal_code' => '5575', 'name' => 'Malvoisin'),
      array('lat' => '50.0000', 'lng' => '4.9513', 'postal_code' => '5575', 'name' => 'Patignies'),
      array('lat' => '49.9924', 'lng' => '4.8845', 'postal_code' => '5575', 'name' => 'Rienne'),
      array('lat' => '50.0015', 'lng' => '4.9168', 'postal_code' => '5575', 'name' => 'Sart-Custinne'),
      array('lat' => '50.0317', 'lng' => '4.9206', 'postal_code' => '5575', 'name' => 'Vencimont'),
      array('lat' => '49.9878', 'lng' => '4.8508', 'postal_code' => '5575', 'name' => 'Willerzie'),
      array('lat' => '50.0596', 'lng' => '4.9997', 'postal_code' => '5576', 'name' => 'Froidfontaine'),
      array('lat' => '50.1127', 'lng' => '5.1425', 'postal_code' => '5580', 'name' => 'Ave-Et-Auffe'),
      array('lat' => '50.2164', 'lng' => '5.2019', 'postal_code' => '5580', 'name' => 'Buissonville'),
      array('lat' => '50.1440', 'lng' => '5.1591', 'postal_code' => '5580', 'name' => 'Eprave'),
      array('lat' => '50.1254', 'lng' => '5.1876', 'postal_code' => '5580', 'name' => 'Han-Sur-Lesse'),
      array('lat' => '50.1153', 'lng' => '5.0933', 'postal_code' => '5580', 'name' => 'Lavaux-Saint-Anne'),
      array('lat' => '50.1392', 'lng' => '5.1466', 'postal_code' => '5580', 'name' => 'Lessive'),
      array('lat' => '50.2103', 'lng' => '5.1227', 'postal_code' => '5580', 'name' => 'Mont-Gauthier'),
      array('lat' => '50.1596', 'lng' => '5.2222', 'postal_code' => '5580', 'name' => 'Rochefort'),
      array('lat' => '50.1535', 'lng' => '5.1137', 'postal_code' => '5580', 'name' => 'Villers-Sur-Lesse'),
      array('lat' => '50.1210', 'lng' => '5.2485', 'postal_code' => '5580', 'name' => 'Wavreille'),
      array('lat' => '50.1358', 'lng' => '5.2796', 'postal_code' => '5589', 'name' => 'Jemelle'),
      array('lat' => '50.2667', 'lng' => '5.0456', 'postal_code' => '5590', 'name' => 'Achêne'),
      array('lat' => '50.3132', 'lng' => '5.0607', 'postal_code' => '5590', 'name' => 'Braibant'),
      array('lat' => '50.2231', 'lng' => '5.1218', 'postal_code' => '5590', 'name' => 'Chevetogne'),
      array('lat' => '50.2957', 'lng' => '5.1008', 'postal_code' => '5590', 'name' => 'Ciney'),
      array('lat' => '50.2501', 'lng' => '5.0596', 'postal_code' => '5590', 'name' => 'Conneux'),
      array('lat' => '50.2492', 'lng' => '5.1957', 'postal_code' => '5590', 'name' => 'Haversin'),
      array('lat' => '50.2677', 'lng' => '5.1099', 'postal_code' => '5590', 'name' => 'Leignon'),
      array('lat' => '50.2831', 'lng' => '5.1710', 'postal_code' => '5590', 'name' => 'Pessoux'),
      array('lat' => '50.2309', 'lng' => '5.2289', 'postal_code' => '5590', 'name' => 'Serinchamps'),
      array('lat' => '50.2965', 'lng' => '5.0364', 'postal_code' => '5590', 'name' => 'Sovet'),
      array('lat' => '50.1049', 'lng' => '4.5608', 'postal_code' => '5600', 'name' => 'Fagnolle'),
      array('lat' => '50.1888', 'lng' => '4.6282', 'postal_code' => '5600', 'name' => 'Franchimont'),
      array('lat' => '50.2173', 'lng' => '4.5308', 'postal_code' => '5600', 'name' => 'Jamagne'),
      array('lat' => '50.2099', 'lng' => '4.5067', 'postal_code' => '5600', 'name' => 'Jamiolle'),
      array('lat' => '50.1765', 'lng' => '4.6111', 'postal_code' => '5600', 'name' => 'Merlemont'),
      array('lat' => '50.1725', 'lng' => '4.5145', 'postal_code' => '5600', 'name' => 'Neuville'),
      array('lat' => '50.1927', 'lng' => '4.7017', 'postal_code' => '5600', 'name' => 'Omezée'),
      array('lat' => '50.1958', 'lng' => '4.5430', 'postal_code' => '5600', 'name' => 'Philippeville'),
      array('lat' => '50.1359', 'lng' => '4.5374', 'postal_code' => '5600', 'name' => 'Roly'),
      array('lat' => '50.1711', 'lng' => '4.6987', 'postal_code' => '5600', 'name' => 'Romedenne'),
      array('lat' => '50.1782', 'lng' => '4.5342', 'postal_code' => '5600', 'name' => 'Samart'),
      array('lat' => '50.1587', 'lng' => '4.6220', 'postal_code' => '5600', 'name' => 'Sart-En-Fagne'),
      array('lat' => '50.1702', 'lng' => '4.5604', 'postal_code' => '5600', 'name' => 'Sautour'),
      array('lat' => '50.1825', 'lng' => '4.7002', 'postal_code' => '5600', 'name' => 'Surice'),
      array('lat' => '50.1472', 'lng' => '4.5857', 'postal_code' => '5600', 'name' => 'Villers-En-Fagne'),
      array('lat' => '50.1913', 'lng' => '4.6094', 'postal_code' => '5600', 'name' => 'Villers-Le-Gambon'),
      array('lat' => '50.1980', 'lng' => '4.5931', 'postal_code' => '5600', 'name' => 'Vodecée'),
      array('lat' => '50.2523', 'lng' => '4.6802', 'postal_code' => '5620', 'name' => 'Corenne'),
      array('lat' => '50.2496', 'lng' => '4.7182', 'postal_code' => '5620', 'name' => 'Flavion'),
      array('lat' => '50.2451', 'lng' => '4.6469', 'postal_code' => '5620', 'name' => 'Florennes'),
      array('lat' => '50.2451', 'lng' => '4.6469', 'postal_code' => '5620', 'name' => 'Hemptinne-Lez-Florennes'),
      array('lat' => '50.2305', 'lng' => '4.7419', 'postal_code' => '5620', 'name' => 'Morville'),
      array('lat' => '50.2331', 'lng' => '4.6896', 'postal_code' => '5620', 'name' => 'Rosée'),
      array('lat' => '50.2485', 'lng' => '4.5766', 'postal_code' => '5620', 'name' => 'Saint-Aubin'),
      array('lat' => '50.2957', 'lng' => '4.5599', 'postal_code' => '5621', 'name' => 'Hanzinelle'),
      array('lat' => '50.3129', 'lng' => '4.5455', 'postal_code' => '5621', 'name' => 'Hanzinne'),
      array('lat' => '50.2750', 'lng' => '4.5659', 'postal_code' => '5621', 'name' => 'Morialmé'),
      array('lat' => '50.2962', 'lng' => '4.5230', 'postal_code' => '5621', 'name' => 'Thy-Le-Baudouin'),
      array('lat' => '50.1514', 'lng' => '4.3847', 'postal_code' => '5630', 'name' => 'Cerfontaine'),
      array('lat' => '50.2195', 'lng' => '4.4564', 'postal_code' => '5630', 'name' => 'Daussois'),
      array('lat' => '50.1768', 'lng' => '4.4646', 'postal_code' => '5630', 'name' => 'Senzeille'),
      array('lat' => '50.2246', 'lng' => '4.4122', 'postal_code' => '5630', 'name' => 'Silenrieux'),
      array('lat' => '50.1899', 'lng' => '4.4382', 'postal_code' => '5630', 'name' => 'Soumoy'),
      array('lat' => '50.1899', 'lng' => '4.4824', 'postal_code' => '5630', 'name' => 'Villers-Deux-Eglises'),
      array('lat' => '50.3399', 'lng' => '4.6102', 'postal_code' => '5640', 'name' => 'Biesme'),
      array('lat' => '50.2974', 'lng' => '4.6801', 'postal_code' => '5640', 'name' => 'Biesmerée'),
      array('lat' => '50.3250', 'lng' => '4.7197', 'postal_code' => '5640', 'name' => 'Graux'),
      array('lat' => '50.3175', 'lng' => '4.6465', 'postal_code' => '5640', 'name' => 'Mettet'),
      array('lat' => '50.3021', 'lng' => '4.6157', 'postal_code' => '5640', 'name' => 'Oret'),
      array('lat' => '50.3460', 'lng' => '4.7407', 'postal_code' => '5640', 'name' => 'Saint-Gérard'),
      array('lat' => '50.3080', 'lng' => '4.7050', 'postal_code' => '5641', 'name' => 'Furnaux'),
      array('lat' => '50.2969', 'lng' => '4.7191', 'postal_code' => '5644', 'name' => 'Ermeton-Sur-Biert'),
      array('lat' => '50.2800', 'lng' => '4.6592', 'postal_code' => '5646', 'name' => 'Stave'),
      array('lat' => '50.2467', 'lng' => '4.3524', 'postal_code' => '5650', 'name' => 'Castillon'),
      array('lat' => '50.2680', 'lng' => '4.4597', 'postal_code' => '5650', 'name' => 'Chastrès'),
      array('lat' => '50.2603', 'lng' => '4.3171', 'postal_code' => '5650', 'name' => 'Clermont'),
      array('lat' => '50.2480', 'lng' => '4.3837', 'postal_code' => '5650', 'name' => 'Fontenelle'),
      array('lat' => '50.2597', 'lng' => '4.5085', 'postal_code' => '5650', 'name' => 'Fraire'),
      array('lat' => '50.2710', 'lng' => '4.4304', 'postal_code' => '5650', 'name' => 'Pry'),
      array('lat' => '50.2404', 'lng' => '4.4526', 'postal_code' => '5650', 'name' => 'Vogenée'),
      array('lat' => '50.2537', 'lng' => '4.4267', 'postal_code' => '5650', 'name' => 'Walcourt'),
      array('lat' => '50.2391', 'lng' => '4.4936', 'postal_code' => '5650', 'name' => 'Yves-Gomezée'),
      array('lat' => '50.2887', 'lng' => '4.4015', 'postal_code' => '5651', 'name' => 'Berzée'),
      array('lat' => '50.2900', 'lng' => '4.4578', 'postal_code' => '5651', 'name' => 'Gourdinne'),
      array('lat' => '50.2774', 'lng' => '4.4909', 'postal_code' => '5651', 'name' => 'Laneffe'),
      array('lat' => '50.2671', 'lng' => '4.3901', 'postal_code' => '5651', 'name' => 'Rognée'),
      array('lat' => '50.2952', 'lng' => '4.4834', 'postal_code' => '5651', 'name' => 'Somzée'),
      array('lat' => '50.3116', 'lng' => '4.4964', 'postal_code' => '5651', 'name' => 'Tarcienne'),
      array('lat' => '50.2808', 'lng' => '4.4327', 'postal_code' => '5651', 'name' => 'Thy-Le-Château'),
      array('lat' => '50.0683', 'lng' => '4.4087', 'postal_code' => '5660', 'name' => 'Aublain'),
      array('lat' => '50.0759', 'lng' => '4.4714', 'postal_code' => '5660', 'name' => 'Boussu-En-Fagne'),
      array('lat' => '49.9687', 'lng' => '4.5276', 'postal_code' => '5660', 'name' => 'Brûly'),
      array('lat' => '50.0017', 'lng' => '4.4650', 'postal_code' => '5660', 'name' => 'Brûly-De-Pesche'),
      array('lat' => '50.0520', 'lng' => '4.4946', 'postal_code' => '5660', 'name' => 'Couvin'),
      array('lat' => '49.9626', 'lng' => '4.4548', 'postal_code' => '5660', 'name' => 'Cul-Des-Sarts'),
      array('lat' => '50.0579', 'lng' => '4.4360', 'postal_code' => '5660', 'name' => 'Dailly'),
      array('lat' => '50.0773', 'lng' => '4.5088', 'postal_code' => '5660', 'name' => 'Frasnes'),
      array('lat' => '50.0362', 'lng' => '4.4262', 'postal_code' => '5660', 'name' => 'Gonrieux'),
      array('lat' => '50.0948', 'lng' => '4.5218', 'postal_code' => '5660', 'name' => 'Mariembourg'),
      array('lat' => '50.0423', 'lng' => '4.4586', 'postal_code' => '5660', 'name' => 'Pesche'),
      array('lat' => '50.0587', 'lng' => '4.5319', 'postal_code' => '5660', 'name' => 'Petigny'),
      array('lat' => '49.9500', 'lng' => '4.5090', 'postal_code' => '5660', 'name' => 'Petite-Chapelle'),
      array('lat' => '50.0249', 'lng' => '4.4197', 'postal_code' => '5660', 'name' => 'Presgaux'),
      array('lat' => '50.0916', 'lng' => '4.5919', 'postal_code' => '5670', 'name' => 'Dourbes'),
      array('lat' => '50.0314', 'lng' => '4.6716', 'postal_code' => '5670', 'name' => 'Le Mesnil'),
      array('lat' => '50.1011', 'lng' => '4.6958', 'postal_code' => '5670', 'name' => 'Mazée'),
      array('lat' => '50.0748', 'lng' => '4.5483', 'postal_code' => '5670', 'name' => 'Nismes'),
      array('lat' => '50.0239', 'lng' => '4.6393', 'postal_code' => '5670', 'name' => 'Oignies-En-Thiérache'),
      array('lat' => '50.0720', 'lng' => '4.6075', 'postal_code' => '5670', 'name' => 'Olloy-Sur-Viroin'),
      array('lat' => '50.0927', 'lng' => '4.6708', 'postal_code' => '5670', 'name' => 'Treignes'),
      array('lat' => '50.0803', 'lng' => '4.6353', 'postal_code' => '5670', 'name' => 'Vierves-Sur-Viroin'),
      array('lat' => '50.0715', 'lng' => '4.6060', 'postal_code' => '5670', 'name' => 'Viroinval'),
      array('lat' => '50.1362', 'lng' => '4.7461', 'postal_code' => '5680', 'name' => 'Doische'),
      array('lat' => '50.1315', 'lng' => '4.7093', 'postal_code' => '5680', 'name' => 'Gimnée'),
      array('lat' => '50.1839', 'lng' => '4.7599', 'postal_code' => '5680', 'name' => 'Gochenée'),
      array('lat' => '50.1208', 'lng' => '4.6115', 'postal_code' => '5680', 'name' => 'Matagne-La-Grande'),
      array('lat' => '50.1168', 'lng' => '4.6380', 'postal_code' => '5680', 'name' => 'Matagne-La-Petite'),
      array('lat' => '50.1181', 'lng' => '4.6999', 'postal_code' => '5680', 'name' => 'Niverlée'),
      array('lat' => '50.1359', 'lng' => '4.6754', 'postal_code' => '5680', 'name' => 'Romerée'),
      array('lat' => '50.1887', 'lng' => '4.7374', 'postal_code' => '5680', 'name' => 'Soulme'),
      array('lat' => '50.1129', 'lng' => '4.7435', 'postal_code' => '5680', 'name' => 'Vaucelles'),
      array('lat' => '50.1725', 'lng' => '4.7323', 'postal_code' => '5680', 'name' => 'Vodelée'),
    ],
    'WHT' => [
      array('lat' => '50.4109', 'lng' => '4.4447', 'postal_code' => '6000', 'name' => 'Charleroi'),
      array('lat' => '50.4001', 'lng' => '4.4330', 'postal_code' => '6001', 'name' => 'Marcinelle'),
      array('lat' => '50.3914', 'lng' => '4.4589', 'postal_code' => '6010', 'name' => 'Couillet'),
      array('lat' => '50.4171', 'lng' => '4.4308', 'postal_code' => '6020', 'name' => 'Dampremy'),
      array('lat' => '50.4068', 'lng' => '4.3607', 'postal_code' => '6030', 'name' => 'Goutroux'),
      array('lat' => '50.4055', 'lng' => '4.3957', 'postal_code' => '6030', 'name' => 'Marchienne-Au-Pont'),
      array('lat' => '50.4166', 'lng' => '4.3764', 'postal_code' => '6031', 'name' => 'Monceau-Sur-Sambre'),
      array('lat' => '50.3887', 'lng' => '4.4055', 'postal_code' => '6032', 'name' => 'Mont-Sur-Marchienne'),
      array('lat' => '50.4427', 'lng' => '4.4370', 'postal_code' => '6040', 'name' => 'Jumet'),
      array('lat' => '50.4690', 'lng' => '4.4322', 'postal_code' => '6041', 'name' => 'Gosselies'),
      array('lat' => '50.4315', 'lng' => '4.4472', 'postal_code' => '6042', 'name' => 'Lodelinsart'),
      array('lat' => '50.4617', 'lng' => '4.4760', 'postal_code' => '6043', 'name' => 'Ransart'),
      array('lat' => '50.4412', 'lng' => '4.3860', 'postal_code' => '6044', 'name' => 'Roux'),
      array('lat' => '50.4240', 'lng' => '4.4786', 'postal_code' => '6060', 'name' => 'Gilly'),
      array('lat' => '50.4019', 'lng' => '4.4778', 'postal_code' => '6061', 'name' => 'Montignies-Sur-Sambre'),
      array('lat' => '50.3845', 'lng' => '4.4636', 'postal_code' => '6099', 'name' => 'Charleroi X'),
      array('lat' => '50.3744', 'lng' => '4.3780', 'postal_code' => '6110', 'name' => 'Montigny-Le-Tilleul'),
      array('lat' => '50.3798', 'lng' => '4.3508', 'postal_code' => '6111', 'name' => 'Landelies'),
      array('lat' => '50.3002', 'lng' => '4.3895', 'postal_code' => '6120', 'name' => 'Cour-Sur-Heure'),
      array('lat' => '50.3221', 'lng' => '4.3881', 'postal_code' => '6120', 'name' => 'Ham-Sur-Heure'),
      array('lat' => '50.3528', 'lng' => '4.4128', 'postal_code' => '6120', 'name' => 'Jamioulx'),
      array('lat' => '50.3299', 'lng' => '4.3698', 'postal_code' => '6120', 'name' => 'Marbaix'),
      array('lat' => '50.3241', 'lng' => '4.4465', 'postal_code' => '6120', 'name' => 'Nalinnes'),
      array('lat' => '50.4101', 'lng' => '4.3250', 'postal_code' => '6140', 'name' => 'Fontaine-L\'evÊque'),
      array('lat' => '50.4366', 'lng' => '4.3204', 'postal_code' => '6141', 'name' => 'Forchies-La-Marche'),
      array('lat' => '50.3982', 'lng' => '4.3322', 'postal_code' => '6142', 'name' => 'Leernes'),
      array('lat' => '50.4060', 'lng' => '4.2839', 'postal_code' => '6150', 'name' => 'Anderlues'),
      array('lat' => '50.4577', 'lng' => '4.3663', 'postal_code' => '6180', 'name' => 'Courcelles'),
      array('lat' => '50.4908', 'lng' => '4.3343', 'postal_code' => '6181', 'name' => 'Gouy-Lez-Piéton'),
      array('lat' => '50.4506', 'lng' => '4.3497', 'postal_code' => '6182', 'name' => 'Souvret'),
      array('lat' => '50.4627', 'lng' => '4.3302', 'postal_code' => '6183', 'name' => 'Trazegnies'),
      array('lat' => '50.3907', 'lng' => '4.5164', 'postal_code' => '6200', 'name' => 'Bouffioulx'),
      array('lat' => '50.4061', 'lng' => '4.5279', 'postal_code' => '6200', 'name' => 'ChÂtelet'),
      array('lat' => '50.4153', 'lng' => '4.5199', 'postal_code' => '6200', 'name' => 'Châtelineau'),
      array('lat' => '50.5315', 'lng' => '4.4462', 'postal_code' => '6210', 'name' => 'Frasnes-Lez-Gosselies'),
      array('lat' => '50.5427', 'lng' => '4.4477', 'postal_code' => '6210', 'name' => 'Les Bons Villers'),
      array('lat' => '50.5378', 'lng' => '4.4145', 'postal_code' => '6210', 'name' => 'Rèves'),
      array('lat' => '50.5263', 'lng' => '4.4780', 'postal_code' => '6210', 'name' => 'Villers-Perwin'),
      array('lat' => '50.4899', 'lng' => '4.4736', 'postal_code' => '6210', 'name' => 'Wayaux'),
      array('lat' => '50.5050', 'lng' => '4.4851', 'postal_code' => '6211', 'name' => 'Mellet'),
      array('lat' => '50.4771', 'lng' => '4.5364', 'postal_code' => '6220', 'name' => 'Fleurus'),
      array('lat' => '50.4845', 'lng' => '4.4958', 'postal_code' => '6220', 'name' => 'Heppignies'),
      array('lat' => '50.4545', 'lng' => '4.5533', 'postal_code' => '6220', 'name' => 'Lambusart'),
      array('lat' => '50.4796', 'lng' => '4.5199', 'postal_code' => '6220', 'name' => 'Wangenies'),
      array('lat' => '50.5064', 'lng' => '4.5499', 'postal_code' => '6221', 'name' => 'Saint-Amand'),
      array('lat' => '50.5240', 'lng' => '4.5581', 'postal_code' => '6222', 'name' => 'Brye'),
      array('lat' => '50.5230', 'lng' => '4.5337', 'postal_code' => '6223', 'name' => 'Wagnelée'),
      array('lat' => '50.4727', 'lng' => '4.5878', 'postal_code' => '6224', 'name' => 'Wanfercée-Baulet'),
      array('lat' => '50.5381', 'lng' => '4.3667', 'postal_code' => '6230', 'name' => 'Buzet'),
      array('lat' => '50.5425', 'lng' => '4.3176', 'postal_code' => '6230', 'name' => 'Obaix'),
      array('lat' => '50.5136', 'lng' => '4.3582', 'postal_code' => '6230', 'name' => 'Pont-À-Celles'),
      array('lat' => '50.4853', 'lng' => '4.4298', 'postal_code' => '6230', 'name' => 'Thiméon'),
      array('lat' => '50.4897', 'lng' => '4.4088', 'postal_code' => '6230', 'name' => 'Viesville'),
      array('lat' => '50.5138', 'lng' => '4.4215', 'postal_code' => '6238', 'name' => 'Liberchies'),
      array('lat' => '50.5098', 'lng' => '4.3915', 'postal_code' => '6238', 'name' => 'Luttre'),
      array('lat' => '50.4299', 'lng' => '4.5415', 'postal_code' => '6240', 'name' => 'Farciennes'),
      array('lat' => '50.4325', 'lng' => '4.5364', 'postal_code' => '6240', 'name' => 'Pironchamps'),
      array('lat' => '50.4111', 'lng' => '4.5864', 'postal_code' => '6250', 'name' => 'Aiseau'),
      array('lat' => '50.4100', 'lng' => '4.5867', 'postal_code' => '6250', 'name' => 'Aiseau-Presles'),
      array('lat' => '50.4162', 'lng' => '4.5455', 'postal_code' => '6250', 'name' => 'Pont-De-Loup'),
      array('lat' => '50.3839', 'lng' => '4.5787', 'postal_code' => '6250', 'name' => 'Presles'),
      array('lat' => '50.4298', 'lng' => '4.5718', 'postal_code' => '6250', 'name' => 'Roselies'),
      array('lat' => '50.3586', 'lng' => '4.5339', 'postal_code' => '6280', 'name' => 'Acoz'),
      array('lat' => '50.3373', 'lng' => '4.5278', 'postal_code' => '6280', 'name' => 'Gerpinnes'),
      array('lat' => '50.3552', 'lng' => '4.5753', 'postal_code' => '6280', 'name' => 'Gougnies'),
      array('lat' => '50.3534', 'lng' => '4.5133', 'postal_code' => '6280', 'name' => 'Joncret'),
      array('lat' => '50.3747', 'lng' => '4.4737', 'postal_code' => '6280', 'name' => 'Loverval'),
      array('lat' => '50.3536', 'lng' => '4.5491', 'postal_code' => '6280', 'name' => 'Villers-Poterie'),
      array('lat' => '50.2279', 'lng' => '4.3781', 'postal_code' => '6440', 'name' => 'Boussu-Lez-Walcourt'),
      array('lat' => '50.1637', 'lng' => '4.3108', 'postal_code' => '6440', 'name' => 'Fourbechies'),
      array('lat' => '50.1500', 'lng' => '4.3282', 'postal_code' => '6440', 'name' => 'Froidchapelle'),
      array('lat' => '50.1988', 'lng' => '4.3048', 'postal_code' => '6440', 'name' => 'Vergnies'),
      array('lat' => '50.2115', 'lng' => '4.3556', 'postal_code' => '6441', 'name' => 'Erpion'),
      array('lat' => '50.0692', 'lng' => '4.2384', 'postal_code' => '6460', 'name' => 'Bailièvre'),
      array('lat' => '50.0845', 'lng' => '4.2660', 'postal_code' => '6460', 'name' => 'Chimay'),
      array('lat' => '50.0728', 'lng' => '4.2773', 'postal_code' => '6460', 'name' => 'Robechies'),
      array('lat' => '50.0454', 'lng' => '4.2919', 'postal_code' => '6460', 'name' => 'Saint-Remy'),
      array('lat' => '50.0554', 'lng' => '4.2446', 'postal_code' => '6460', 'name' => 'Salles'),
      array('lat' => '50.0360', 'lng' => '4.2613', 'postal_code' => '6460', 'name' => 'Villers-La-Tour'),
      array('lat' => '50.0658', 'lng' => '4.3353', 'postal_code' => '6461', 'name' => 'Virelles'),
      array('lat' => '50.0612', 'lng' => '4.3649', 'postal_code' => '6462', 'name' => 'Vaulx-Lez-Chimay'),
      array('lat' => '50.0641', 'lng' => '4.3784', 'postal_code' => '6463', 'name' => 'Lompret'),
      array('lat' => '50.0287', 'lng' => '4.3761', 'postal_code' => '6464', 'name' => 'Baileux'),
      array('lat' => '50.0272', 'lng' => '4.3410', 'postal_code' => '6464', 'name' => 'Bourlers'),
      array('lat' => '50.0258', 'lng' => '4.3279', 'postal_code' => '6464', 'name' => 'Forges'),
      array('lat' => '49.9454', 'lng' => '4.4310', 'postal_code' => '6464', 'name' => 'L\'escaillère'),
      array('lat' => '49.9591', 'lng' => '4.3689', 'postal_code' => '6464', 'name' => 'Rièzes'),
      array('lat' => '50.2008', 'lng' => '4.1720', 'postal_code' => '6470', 'name' => 'Grandrieu'),
      array('lat' => '50.1345', 'lng' => '4.2241', 'postal_code' => '6470', 'name' => 'Montbliart'),
      array('lat' => '50.1434', 'lng' => '4.2691', 'postal_code' => '6470', 'name' => 'Rance'),
      array('lat' => '50.1636', 'lng' => '4.2258', 'postal_code' => '6470', 'name' => 'Sautin'),
      array('lat' => '50.1660', 'lng' => '4.1821', 'postal_code' => '6470', 'name' => 'Sivry'),
      array('lat' => '50.1700', 'lng' => '4.1814', 'postal_code' => '6470', 'name' => 'Sivry-Rance'),
      array('lat' => '50.2216', 'lng' => '4.2844', 'postal_code' => '6500', 'name' => 'Barbençon'),
      array('lat' => '50.2190', 'lng' => '4.2498', 'postal_code' => '6500', 'name' => 'Beaumont'),
      array('lat' => '50.2230', 'lng' => '4.1975', 'postal_code' => '6500', 'name' => 'Leugnies'),
      array('lat' => '50.2355', 'lng' => '4.2095', 'postal_code' => '6500', 'name' => 'Leval-Chaudeville'),
      array('lat' => '50.1914', 'lng' => '4.2664', 'postal_code' => '6500', 'name' => 'Renlies'),
      array('lat' => '50.2151', 'lng' => '4.2439', 'postal_code' => '6500', 'name' => 'Solre-Saint-Géry'),
      array('lat' => '50.2612', 'lng' => '4.2357', 'postal_code' => '6500', 'name' => 'Thirimont'),
      array('lat' => '50.2750', 'lng' => '4.2888', 'postal_code' => '6511', 'name' => 'Strée'),
      array('lat' => '50.3044', 'lng' => '4.2458', 'postal_code' => '6530', 'name' => 'Leers-Et-Fosteau'),
      array('lat' => '50.3414', 'lng' => '4.2929', 'postal_code' => '6530', 'name' => 'Thuin'),
      array('lat' => '50.3220', 'lng' => '4.3088', 'postal_code' => '6531', 'name' => 'Biesme-Sous-Thuin'),
      array('lat' => '50.3086', 'lng' => '4.2842', 'postal_code' => '6532', 'name' => 'Ragnies'),
      array('lat' => '50.3245', 'lng' => '4.2595', 'postal_code' => '6533', 'name' => 'Biercée'),
      array('lat' => '50.3335', 'lng' => '4.3516', 'postal_code' => '6534', 'name' => 'Gozée'),
      array('lat' => '50.2864', 'lng' => '4.3121', 'postal_code' => '6536', 'name' => 'Donstiennes'),
      array('lat' => '50.3003', 'lng' => '4.3310', 'postal_code' => '6536', 'name' => 'Thuillies'),
      array('lat' => '50.3682', 'lng' => '4.2663', 'postal_code' => '6540', 'name' => 'Lobbes'),
      array('lat' => '50.3723', 'lng' => '4.2365', 'postal_code' => '6540', 'name' => 'Mont-Sainte-Geneviève'),
      array('lat' => '50.3397', 'lng' => '4.2098', 'postal_code' => '6542', 'name' => 'Sars-La-Buissière'),
      array('lat' => '50.3522', 'lng' => '4.2162', 'postal_code' => '6543', 'name' => 'Bienne-Lez-Happart'),
      array('lat' => '50.2630', 'lng' => '4.1491', 'postal_code' => '6560', 'name' => 'Bersillies-L\'abbaye'),
      array('lat' => '50.3074', 'lng' => '4.1114', 'postal_code' => '6560', 'name' => 'Erquelinnes'),
      array('lat' => '50.3307', 'lng' => '4.0748', 'postal_code' => '6560', 'name' => 'Grand-Reng'),
      array('lat' => '50.3053', 'lng' => '4.1779', 'postal_code' => '6560', 'name' => 'Hantes-Wihéries'),
      array('lat' => '50.2822', 'lng' => '4.1915', 'postal_code' => '6560', 'name' => 'Montignies-Saint-Christophe'),
      array('lat' => '50.3072', 'lng' => '4.1579', 'postal_code' => '6560', 'name' => 'Solre-Sur-Sambre'),
      array('lat' => '50.3180', 'lng' => '4.2155', 'postal_code' => '6567', 'name' => 'Fontaine-Valmont'),
      array('lat' => '50.3159', 'lng' => '4.1854', 'postal_code' => '6567', 'name' => 'Labuissière'),
      array('lat' => '50.3244', 'lng' => '4.1645', 'postal_code' => '6567', 'name' => 'Merbes-Le-ChÂteau'),
      array('lat' => '50.3558', 'lng' => '4.1709', 'postal_code' => '6567', 'name' => 'Merbes-Sainte-Marie'),
      array('lat' => '50.0310', 'lng' => '4.1790', 'postal_code' => '6590', 'name' => 'Momignies'),
      array('lat' => '50.0506', 'lng' => '4.2091', 'postal_code' => '6591', 'name' => 'Macon'),
      array('lat' => '50.0380', 'lng' => '4.2277', 'postal_code' => '6592', 'name' => 'Monceau-Imbrechies'),
      array('lat' => '49.9756', 'lng' => '4.1786', 'postal_code' => '6593', 'name' => 'Macquenoise'),
      array('lat' => '50.0140', 'lng' => '4.1565', 'postal_code' => '6594', 'name' => 'Beauwelz'),
      array('lat' => '49.9669', 'lng' => '4.2530', 'postal_code' => '6596', 'name' => 'Forge-Philippe'),
      array('lat' => '50.0153', 'lng' => '4.2561', 'postal_code' => '6596', 'name' => 'Seloignes'),
      array('lat' => '50.4542', 'lng' => '3.9567', 'postal_code' => '7000', 'name' => 'Mons'),
      array('lat' => '50.4970', 'lng' => '3.9821', 'postal_code' => '7010', 'name' => 'Shape'),
      array('lat' => '50.4643', 'lng' => '3.8877', 'postal_code' => '7011', 'name' => 'Ghlin'),
      array('lat' => '50.4337', 'lng' => '3.8890', 'postal_code' => '7012', 'name' => 'Flénu'),
      array('lat' => '50.4479', 'lng' => '3.8991', 'postal_code' => '7012', 'name' => 'Jemappes'),
      array('lat' => '50.4886', 'lng' => '3.9653', 'postal_code' => '7020', 'name' => 'Maisières'),
      array('lat' => '50.4766', 'lng' => '3.9553', 'postal_code' => '7020', 'name' => 'Nimy'),
      array('lat' => '50.4639', 'lng' => '4.0453', 'postal_code' => '7021', 'name' => 'Havre'),
      array('lat' => '50.4060', 'lng' => '4.0175', 'postal_code' => '7022', 'name' => 'Harmignies'),
      array('lat' => '50.3946', 'lng' => '3.9871', 'postal_code' => '7022', 'name' => 'Harveng'),
      array('lat' => '50.4396', 'lng' => '3.9607', 'postal_code' => '7022', 'name' => 'Hyon'),
      array('lat' => '50.4260', 'lng' => '3.9583', 'postal_code' => '7022', 'name' => 'Mesvin'),
      array('lat' => '50.4104', 'lng' => '3.9671', 'postal_code' => '7022', 'name' => 'Nouvelles'),
      array('lat' => '50.4220', 'lng' => '3.9462', 'postal_code' => '7024', 'name' => 'Ciply'),
      array('lat' => '50.4379', 'lng' => '4.0118', 'postal_code' => '7030', 'name' => 'Saint-Symphorien'),
      array('lat' => '50.4321', 'lng' => '4.0409', 'postal_code' => '7031', 'name' => 'Villers-Saint-Ghislain'),
      array('lat' => '50.4252', 'lng' => '3.9893', 'postal_code' => '7032', 'name' => 'Spiennes'),
      array('lat' => '50.4362', 'lng' => '3.9241', 'postal_code' => '7033', 'name' => 'Cuesmes'),
      array('lat' => '50.4742', 'lng' => '4.0091', 'postal_code' => '7034', 'name' => 'Obourg'),
      array('lat' => '50.4910', 'lng' => '4.0193', 'postal_code' => '7034', 'name' => 'Saint-Denis'),
      array('lat' => '50.4007', 'lng' => '3.9545', 'postal_code' => '7040', 'name' => 'Asquillies'),
      array('lat' => '50.3405', 'lng' => '3.9020', 'postal_code' => '7040', 'name' => 'Aulnois'),
      array('lat' => '50.3572', 'lng' => '3.8970', 'postal_code' => '7040', 'name' => 'Blaregnies'),
      array('lat' => '50.3869', 'lng' => '3.9386', 'postal_code' => '7040', 'name' => 'Bougnies'),
      array('lat' => '50.3910', 'lng' => '3.9122', 'postal_code' => '7040', 'name' => 'Genly'),
      array('lat' => '50.3424', 'lng' => '3.9469', 'postal_code' => '7040', 'name' => 'Goegnies-Chaussée'),
      array('lat' => '50.3543', 'lng' => '3.9274', 'postal_code' => '7040', 'name' => 'QuÉvy'),
      array('lat' => '50.3607', 'lng' => '3.9472', 'postal_code' => '7040', 'name' => 'Quévy-Le-Grand'),
      array('lat' => '50.3685', 'lng' => '3.9335', 'postal_code' => '7040', 'name' => 'Quévy-Le-Petit'),
      array('lat' => '50.3794', 'lng' => '4.0358', 'postal_code' => '7041', 'name' => 'Givry'),
      array('lat' => '50.3616', 'lng' => '3.9834', 'postal_code' => '7041', 'name' => 'Havay'),
      array('lat' => '50.5329', 'lng' => '3.8842', 'postal_code' => '7050', 'name' => 'Erbaut'),
      array('lat' => '50.5161', 'lng' => '3.8966', 'postal_code' => '7050', 'name' => 'Erbisoeul'),
      array('lat' => '50.5275', 'lng' => '3.8576', 'postal_code' => '7050', 'name' => 'Herchies'),
      array('lat' => '50.5329', 'lng' => '3.9107', 'postal_code' => '7050', 'name' => 'Jurbise'),
      array('lat' => '50.5310', 'lng' => '3.9451', 'postal_code' => '7050', 'name' => 'Masnuy-Saint-Jean'),
      array('lat' => '50.5365', 'lng' => '3.9609', 'postal_code' => '7050', 'name' => 'Masnuy-Saint-Pierre'),
      array('lat' => '50.6085', 'lng' => '4.0427', 'postal_code' => '7060', 'name' => 'Horrues'),
      array('lat' => '50.5777', 'lng' => '4.0573', 'postal_code' => '7060', 'name' => 'Soignies'),
      array('lat' => '50.5159', 'lng' => '4.0133', 'postal_code' => '7061', 'name' => 'Casteau'),
      array('lat' => '50.5152', 'lng' => '4.0483', 'postal_code' => '7061', 'name' => 'Thieusies'),
      array('lat' => '50.5544', 'lng' => '4.0991', 'postal_code' => '7062', 'name' => 'Naast'),
      array('lat' => '50.5927', 'lng' => '3.9983', 'postal_code' => '7063', 'name' => 'Chaussée-Notre-Dame-Louvignies'),
      array('lat' => '50.5685', 'lng' => '4.0027', 'postal_code' => '7063', 'name' => 'Neufvilles'),
      array('lat' => '50.4966', 'lng' => '4.0603', 'postal_code' => '7070', 'name' => 'Gottignies'),
      array('lat' => '50.5029', 'lng' => '4.1087', 'postal_code' => '7070', 'name' => 'Le Roeulx'),
      array('lat' => '50.5280', 'lng' => '4.1531', 'postal_code' => '7070', 'name' => 'Mignault'),
      array('lat' => '50.4736', 'lng' => '4.0915', 'postal_code' => '7070', 'name' => 'Thieu'),
      array('lat' => '50.4753', 'lng' => '4.0691', 'postal_code' => '7070', 'name' => 'Ville-Sur-Haine'),
      array('lat' => '50.3902', 'lng' => '3.8878', 'postal_code' => '7080', 'name' => 'Eugies'),
      array('lat' => '50.4109', 'lng' => '3.8955', 'postal_code' => '7080', 'name' => 'Frameries'),
      array('lat' => '50.4109', 'lng' => '3.8719', 'postal_code' => '7080', 'name' => 'La Bouverie'),
      array('lat' => '50.4018', 'lng' => '3.9322', 'postal_code' => '7080', 'name' => 'Noirchain'),
      array('lat' => '50.3725', 'lng' => '3.8761', 'postal_code' => '7080', 'name' => 'Sars-La-Bruyère'),
      array('lat' => '50.6094', 'lng' => '4.1348', 'postal_code' => '7090', 'name' => 'Braine-Le-Comte'),
      array('lat' => '50.6384', 'lng' => '4.1696', 'postal_code' => '7090', 'name' => 'Hennuyères'),
      array('lat' => '50.5993', 'lng' => '4.1854', 'postal_code' => '7090', 'name' => 'Henripont'),
      array('lat' => '50.6254', 'lng' => '4.0886', 'postal_code' => '7090', 'name' => 'Petit-Roeulx-Lez-Braine'),
      array('lat' => '50.6079', 'lng' => '4.2209', 'postal_code' => '7090', 'name' => 'Ronquières'),
      array('lat' => '50.6433', 'lng' => '4.0692', 'postal_code' => '7090', 'name' => 'Steenkerque'),
      array('lat' => '50.4531', 'lng' => '4.1913', 'postal_code' => '7100', 'name' => 'Haine-Saint-Paul'),
      array('lat' => '50.4541', 'lng' => '4.1996', 'postal_code' => '7100', 'name' => 'Haine-Saint-Pierre'),
      array('lat' => '50.4694', 'lng' => '4.1892', 'postal_code' => '7100', 'name' => 'La LouviÈre'),
      array('lat' => '50.4543', 'lng' => '4.1604', 'postal_code' => '7100', 'name' => 'Saint-Vaast'),
      array('lat' => '50.4504', 'lng' => '4.1480', 'postal_code' => '7100', 'name' => 'Trivières'),
      array('lat' => '50.4602', 'lng' => '4.0778', 'postal_code' => '7110', 'name' => 'Boussoit'),
      array('lat' => '50.4858', 'lng' => '4.1446', 'postal_code' => '7110', 'name' => 'Houdeng-Aimeries'),
      array('lat' => '50.4882', 'lng' => '4.1543', 'postal_code' => '7110', 'name' => 'Houdeng-Goegnies'),
      array('lat' => '50.4567', 'lng' => '4.0993', 'postal_code' => '7110', 'name' => 'Maurage'),
      array('lat' => '50.4806', 'lng' => '4.1200', 'postal_code' => '7110', 'name' => 'Strépy-Bracquegnies'),
      array('lat' => '50.3615', 'lng' => '4.0769', 'postal_code' => '7120', 'name' => 'Croix-Lez-Rouveroy'),
      array('lat' => '50.4038', 'lng' => '4.1041', 'postal_code' => '7120', 'name' => 'Estinnes'),
      array('lat' => '50.3965', 'lng' => '4.0962', 'postal_code' => '7120', 'name' => 'Estinnes-Au-Mont'),
      array('lat' => '50.4112', 'lng' => '4.1041', 'postal_code' => '7120', 'name' => 'Estinnes-Au-Val'),
      array('lat' => '50.3702', 'lng' => '4.1104', 'postal_code' => '7120', 'name' => 'Fauroeulx'),
      array('lat' => '50.3843', 'lng' => '4.0819', 'postal_code' => '7120', 'name' => 'Haulchin'),
      array('lat' => '50.3511', 'lng' => '4.1202', 'postal_code' => '7120', 'name' => 'Peissant'),
      array('lat' => '50.3554', 'lng' => '4.0621', 'postal_code' => '7120', 'name' => 'Rouveroy'),
      array('lat' => '50.4020', 'lng' => '4.0585', 'postal_code' => '7120', 'name' => 'Vellereille-Le-Sec'),
      array('lat' => '50.3793', 'lng' => '4.1520', 'postal_code' => '7120', 'name' => 'Vellereille-Les-Brayeux'),
      array('lat' => '50.4169', 'lng' => '4.1689', 'postal_code' => '7130', 'name' => 'Battignies'),
      array('lat' => '50.4279', 'lng' => '4.1185', 'postal_code' => '7130', 'name' => 'Binche'),
      array('lat' => '50.4316', 'lng' => '4.1054', 'postal_code' => '7130', 'name' => 'Bray'),
      array('lat' => '50.4133', 'lng' => '4.1495', 'postal_code' => '7131', 'name' => 'Waudrez'),
      array('lat' => '50.3887', 'lng' => '4.2052', 'postal_code' => '7133', 'name' => 'Buvrinnes'),
      array('lat' => '50.4056', 'lng' => '4.2073', 'postal_code' => '7134', 'name' => 'Epinois'),
      array('lat' => '50.4165', 'lng' => '4.2177', 'postal_code' => '7134', 'name' => 'Leval-Trahegnies'),
      array('lat' => '50.4372', 'lng' => '4.1487', 'postal_code' => '7134', 'name' => 'Péronnes-Lez-Binche'),
      array('lat' => '50.4219', 'lng' => '4.1948', 'postal_code' => '7134', 'name' => 'Ressaix'),
      array('lat' => '50.4524', 'lng' => '4.2298', 'postal_code' => '7140', 'name' => 'Morlanwelz'),
      array('lat' => '50.4581', 'lng' => '4.2474', 'postal_code' => '7140', 'name' => 'Morlanwelz-Mariemont'),
      array('lat' => '50.4414', 'lng' => '4.2549', 'postal_code' => '7141', 'name' => 'Carnières'),
      array('lat' => '50.4306', 'lng' => '4.2335', 'postal_code' => '7141', 'name' => 'Mont-Sainte-Aldegonde'),
      array('lat' => '50.4712', 'lng' => '4.2808', 'postal_code' => '7160', 'name' => 'Chapelle-Lez-Herlaimont'),
      array('lat' => '50.4963', 'lng' => '4.2884', 'postal_code' => '7160', 'name' => 'Godarville'),
      array('lat' => '50.4375', 'lng' => '4.2962', 'postal_code' => '7160', 'name' => 'Piéton'),
      array('lat' => '50.4831', 'lng' => '4.2544', 'postal_code' => '7170', 'name' => 'Bellecourt'),
      array('lat' => '50.5041', 'lng' => '4.2211', 'postal_code' => '7170', 'name' => 'Bois-D\'haine'),
      array('lat' => '50.4871', 'lng' => '4.2276', 'postal_code' => '7170', 'name' => 'Fayt-Lez-Manage'),
      array('lat' => '50.4759', 'lng' => '4.2300', 'postal_code' => '7170', 'name' => 'La Hestre'),
      array('lat' => '50.5030', 'lng' => '4.2353', 'postal_code' => '7170', 'name' => 'Manage'),
      array('lat' => '50.5286', 'lng' => '4.2721', 'postal_code' => '7180', 'name' => 'Seneffe'),
      array('lat' => '50.5678', 'lng' => '4.2749', 'postal_code' => '7181', 'name' => 'Arquennes'),
      array('lat' => '50.5229', 'lng' => '4.2111', 'postal_code' => '7181', 'name' => 'Familleureux'),
      array('lat' => '50.5622', 'lng' => '4.2503', 'postal_code' => '7181', 'name' => 'Feluy'),
      array('lat' => '50.5548', 'lng' => '4.3108', 'postal_code' => '7181', 'name' => 'Petit-Roeulx-Lez-Nivelles'),
      array('lat' => '50.5606', 'lng' => '4.1724', 'postal_code' => '7190', 'name' => 'Ecaussinnes'),
      array('lat' => '50.5609', 'lng' => '4.1539', 'postal_code' => '7190', 'name' => 'Ecaussinnes-D\'enghien'),
      array('lat' => '50.5469', 'lng' => '4.1819', 'postal_code' => '7190', 'name' => 'Marche-Lez-Ecaussinnes'),
      array('lat' => '50.5701', 'lng' => '4.1775', 'postal_code' => '7191', 'name' => 'Ecaussinnes-Lalaing'),
      array('lat' => '50.4259', 'lng' => '3.7970', 'postal_code' => '7300', 'name' => 'Boussu'),
      array('lat' => '50.4363', 'lng' => '3.8263', 'postal_code' => '7301', 'name' => 'Hornu'),
      array('lat' => '50.4825', 'lng' => '3.6459', 'postal_code' => '7320', 'name' => 'Bernissart'),
      array('lat' => '50.4993', 'lng' => '3.6598', 'postal_code' => '7321', 'name' => 'Blaton'),
      array('lat' => '50.4803', 'lng' => '3.6947', 'postal_code' => '7321', 'name' => 'Harchies'),
      array('lat' => '50.4623', 'lng' => '3.7130', 'postal_code' => '7322', 'name' => 'Pommeroeul'),
      array('lat' => '50.4708', 'lng' => '3.7293', 'postal_code' => '7322', 'name' => 'Ville-Pommeroeul'),
      array('lat' => '50.4491', 'lng' => '3.8184', 'postal_code' => '7330', 'name' => 'Saint-Ghislain'),
      array('lat' => '50.4833', 'lng' => '3.8377', 'postal_code' => '7331', 'name' => 'Baudour'),
      array('lat' => '50.5294', 'lng' => '3.7937', 'postal_code' => '7332', 'name' => 'Neufmaison'),
      array('lat' => '50.5042', 'lng' => '3.7899', 'postal_code' => '7332', 'name' => 'Sirault'),
      array('lat' => '50.4668', 'lng' => '3.8119', 'postal_code' => '7333', 'name' => 'Tertre'),
      array('lat' => '50.4792', 'lng' => '3.7660', 'postal_code' => '7334', 'name' => 'Hautrage'),
      array('lat' => '50.4866', 'lng' => '3.7906', 'postal_code' => '7334', 'name' => 'Villerot'),
      array('lat' => '50.4142', 'lng' => '3.8460', 'postal_code' => '7340', 'name' => 'Colfontaine'),
      array('lat' => '50.4048', 'lng' => '3.8383', 'postal_code' => '7340', 'name' => 'Paturages'),
      array('lat' => '50.4011', 'lng' => '3.8217', 'postal_code' => '7340', 'name' => 'Warquignies'),
      array('lat' => '50.4220', 'lng' => '3.8450', 'postal_code' => '7340', 'name' => 'Wasmes'),
      array('lat' => '50.4307', 'lng' => '3.7657', 'postal_code' => '7350', 'name' => 'Hainin'),
      array('lat' => '50.4324', 'lng' => '3.6844', 'postal_code' => '7350', 'name' => 'Hensies'),
      array('lat' => '50.4355', 'lng' => '3.7039', 'postal_code' => '7350', 'name' => 'Montroeul-Sur-Haine'),
      array('lat' => '50.4290', 'lng' => '3.7392', 'postal_code' => '7350', 'name' => 'Thulin'),
      array('lat' => '50.3720', 'lng' => '3.8058', 'postal_code' => '7370', 'name' => 'Blaugies'),
      array('lat' => '50.4000', 'lng' => '3.7828', 'postal_code' => '7370', 'name' => 'Dour'),
      array('lat' => '50.4026', 'lng' => '3.7523', 'postal_code' => '7370', 'name' => 'Elouges'),
      array('lat' => '50.3855', 'lng' => '3.7525', 'postal_code' => '7370', 'name' => 'Wihéries'),
      array('lat' => '50.3906', 'lng' => '3.6975', 'postal_code' => '7380', 'name' => 'Baisieux'),
      array('lat' => '50.4034', 'lng' => '3.6904', 'postal_code' => '7380', 'name' => 'QuiÉvrain'),
      array('lat' => '50.3831', 'lng' => '3.7176', 'postal_code' => '7382', 'name' => 'Audregnies'),
      array('lat' => '50.3684', 'lng' => '3.6981', 'postal_code' => '7387', 'name' => 'Angre'),
      array('lat' => '50.3506', 'lng' => '3.6908', 'postal_code' => '7387', 'name' => 'Angreau'),
      array('lat' => '50.3656', 'lng' => '3.7781', 'postal_code' => '7387', 'name' => 'Athis'),
      array('lat' => '50.3491', 'lng' => '3.7344', 'postal_code' => '7387', 'name' => 'Autreppe'),
      array('lat' => '50.3594', 'lng' => '3.7935', 'postal_code' => '7387', 'name' => 'Erquennes'),
      array('lat' => '50.3581', 'lng' => '3.7713', 'postal_code' => '7387', 'name' => 'Fayt-Le-Franc'),
      array('lat' => '50.3666', 'lng' => '3.6943', 'postal_code' => '7387', 'name' => 'Honnelles'),
      array('lat' => '50.3751', 'lng' => '3.6726', 'postal_code' => '7387', 'name' => 'Marchipont'),
      array('lat' => '50.3684', 'lng' => '3.7361', 'postal_code' => '7387', 'name' => 'Montignies-Sur-Roc'),
      array('lat' => '50.3632', 'lng' => '3.7165', 'postal_code' => '7387', 'name' => 'Onnezies'),
      array('lat' => '50.3331', 'lng' => '3.6935', 'postal_code' => '7387', 'name' => 'Roisin'),
      array('lat' => '50.4444', 'lng' => '3.8646', 'postal_code' => '7390', 'name' => 'Quaregnon'),
      array('lat' => '50.4456', 'lng' => '3.8454', 'postal_code' => '7390', 'name' => 'Wasmuel'),
      array('lat' => '50.5809', 'lng' => '3.3684', 'postal_code' => '7500', 'name' => 'Ere'),
      array('lat' => '50.5727', 'lng' => '3.3945', 'postal_code' => '7500', 'name' => 'Saint-Maur'),
      array('lat' => '50.6056', 'lng' => '3.3880', 'postal_code' => '7500', 'name' => 'Tournai'),
      array('lat' => '50.6050', 'lng' => '3.3492', 'postal_code' => '7501', 'name' => 'Orcq'),
      array('lat' => '50.5737', 'lng' => '3.3040', 'postal_code' => '7502', 'name' => 'Esplechin'),
      array('lat' => '50.6229', 'lng' => '3.3471', 'postal_code' => '7503', 'name' => 'Froyennes'),
      array('lat' => '50.5784', 'lng' => '3.3280', 'postal_code' => '7504', 'name' => 'Froidmont'),
      array('lat' => '50.5735', 'lng' => '3.3491', 'postal_code' => '7506', 'name' => 'Willemeau'),
      array('lat' => '50.6514', 'lng' => '3.3369', 'postal_code' => '7520', 'name' => 'Ramegnies-Chin'),
      array('lat' => '50.6448', 'lng' => '3.2832', 'postal_code' => '7520', 'name' => 'Templeuve'),
      array('lat' => '50.5895', 'lng' => '3.4220', 'postal_code' => '7521', 'name' => 'Chercq'),
      array('lat' => '50.6251', 'lng' => '3.3038', 'postal_code' => '7522', 'name' => 'Blandain'),
      array('lat' => '50.6135', 'lng' => '3.2896', 'postal_code' => '7522', 'name' => 'Hertain'),
      array('lat' => '50.6007', 'lng' => '3.2922', 'postal_code' => '7522', 'name' => 'Lamain'),
      array('lat' => '50.6042', 'lng' => '3.3226', 'postal_code' => '7522', 'name' => 'Marquain'),
      array('lat' => '50.5939', 'lng' => '3.4893', 'postal_code' => '7530', 'name' => 'Gaurain-Ramecroix'),
      array('lat' => '50.6157', 'lng' => '3.4635', 'postal_code' => '7531', 'name' => 'Havinnes'),
      array('lat' => '50.6209', 'lng' => '3.5047', 'postal_code' => '7532', 'name' => 'Beclers'),
      array('lat' => '50.6345', 'lng' => '3.5097', 'postal_code' => '7533', 'name' => 'Thimougies'),
      array('lat' => '50.5849', 'lng' => '3.5416', 'postal_code' => '7534', 'name' => 'Barry'),
      array('lat' => '50.6165', 'lng' => '3.5480', 'postal_code' => '7534', 'name' => 'Maulde'),
      array('lat' => '50.5904', 'lng' => '3.4335', 'postal_code' => '7536', 'name' => 'Vaulx'),
      array('lat' => '50.5719', 'lng' => '3.5003', 'postal_code' => '7538', 'name' => 'Vezon'),
      array('lat' => '50.6380', 'lng' => '3.3788', 'postal_code' => '7540', 'name' => 'Kain'),
      array('lat' => '50.6466', 'lng' => '3.4827', 'postal_code' => '7540', 'name' => 'Melles'),
      array('lat' => '50.6494', 'lng' => '3.5131', 'postal_code' => '7540', 'name' => 'Quartes'),
      array('lat' => '50.6199', 'lng' => '3.4368', 'postal_code' => '7540', 'name' => 'Rumillies'),
      array('lat' => '50.6548', 'lng' => '3.4040', 'postal_code' => '7542', 'name' => 'Mont-Saint-Aubert'),
      array('lat' => '50.6531', 'lng' => '3.4443', 'postal_code' => '7543', 'name' => 'Mourcourt'),
      array('lat' => '50.6103', 'lng' => '3.4233', 'postal_code' => '7548', 'name' => 'Warchin'),
      array('lat' => '50.5149', 'lng' => '3.6014', 'postal_code' => '7600', 'name' => 'PÉruwelz'),
      array('lat' => '50.5292', 'lng' => '3.5871', 'postal_code' => '7601', 'name' => 'Roucourt'),
      array('lat' => '50.5425', 'lng' => '3.5935', 'postal_code' => '7602', 'name' => 'Bury'),
      array('lat' => '50.4975', 'lng' => '3.6073', 'postal_code' => '7603', 'name' => 'Bon-Secours'),
      array('lat' => '50.5615', 'lng' => '3.5518', 'postal_code' => '7604', 'name' => 'Baugnies'),
      array('lat' => '50.5522', 'lng' => '3.5820', 'postal_code' => '7604', 'name' => 'Braffe'),
      array('lat' => '50.5415', 'lng' => '3.5469', 'postal_code' => '7604', 'name' => 'Brasmenil'),
      array('lat' => '50.5313', 'lng' => '3.5244', 'postal_code' => '7604', 'name' => 'Callenelle'),
      array('lat' => '50.5512', 'lng' => '3.5359', 'postal_code' => '7604', 'name' => 'Wasmes-Audemez-Briffoeil'),
      array('lat' => '50.5084', 'lng' => '3.5328', 'postal_code' => '7608', 'name' => 'Wiers'),
      array('lat' => '50.5549', 'lng' => '3.3022', 'postal_code' => '7610', 'name' => 'Rumes'),
      array('lat' => '50.5323', 'lng' => '3.3059', 'postal_code' => '7611', 'name' => 'La Glanerie'),
      array('lat' => '50.5467', 'lng' => '3.3404', 'postal_code' => '7618', 'name' => 'Taintignies'),
      array('lat' => '50.5130', 'lng' => '3.4148', 'postal_code' => '7620', 'name' => 'Bléharies'),
      array('lat' => '50.5418', 'lng' => '3.3978', 'postal_code' => '7620', 'name' => 'Brunehaut'),
      array('lat' => '50.5473', 'lng' => '3.3670', 'postal_code' => '7620', 'name' => 'Guignies'),
      array('lat' => '50.5443', 'lng' => '3.4273', 'postal_code' => '7620', 'name' => 'Hollain'),
      array('lat' => '50.5391', 'lng' => '3.4040', 'postal_code' => '7620', 'name' => 'Jollain-Merlin'),
      array('lat' => '50.5478', 'lng' => '3.3890', 'postal_code' => '7620', 'name' => 'Wez-Velvain'),
      array('lat' => '50.5205', 'lng' => '3.3892', 'postal_code' => '7621', 'name' => 'Lesdain'),
      array('lat' => '50.5208', 'lng' => '3.4470', 'postal_code' => '7622', 'name' => 'Laplaigne'),
      array('lat' => '50.5084', 'lng' => '3.3912', 'postal_code' => '7623', 'name' => 'Rongy'),
      array('lat' => '50.5061', 'lng' => '3.3559', 'postal_code' => '7624', 'name' => 'Howardries'),
      array('lat' => '50.5503', 'lng' => '3.4597', 'postal_code' => '7640', 'name' => 'Antoing'),
      array('lat' => '50.5512', 'lng' => '3.4999', 'postal_code' => '7640', 'name' => 'Maubray'),
      array('lat' => '50.5503', 'lng' => '3.4542', 'postal_code' => '7640', 'name' => 'Péronnes-Lez-Antoing'),
      array('lat' => '50.5574', 'lng' => '3.4276', 'postal_code' => '7641', 'name' => 'Bruyelle'),
      array('lat' => '50.5780', 'lng' => '3.4365', 'postal_code' => '7642', 'name' => 'Calonne'),
      array('lat' => '50.5677', 'lng' => '3.4736', 'postal_code' => '7643', 'name' => 'Fontenoy'),
      array('lat' => '50.7384', 'lng' => '3.2337', 'postal_code' => '7700', 'name' => 'Luingne'),
      array('lat' => '50.7459', 'lng' => '3.2193', 'postal_code' => '7700', 'name' => 'Moeskroen'),
      array('lat' => '50.7282', 'lng' => '3.3049', 'postal_code' => '7711', 'name' => 'Dottenijs'),
      array('lat' => '50.7226', 'lng' => '3.2326', 'postal_code' => '7712', 'name' => 'Herseaux'),
      array('lat' => '50.6698', 'lng' => '3.3187', 'postal_code' => '7730', 'name' => 'Bailleul'),
      array('lat' => '50.6803', 'lng' => '3.3098', 'postal_code' => '7730', 'name' => 'Estaimbourg'),
      array('lat' => '50.7062', 'lng' => '3.2650', 'postal_code' => '7730', 'name' => 'Estaimpuis'),
      array('lat' => '50.7129', 'lng' => '3.2866', 'postal_code' => '7730', 'name' => 'Evregnies'),
      array('lat' => '50.6877', 'lng' => '3.2718', 'postal_code' => '7730', 'name' => 'Leers-Nord'),
      array('lat' => '50.6670', 'lng' => '3.2691', 'postal_code' => '7730', 'name' => 'Néchin'),
      array('lat' => '50.7068', 'lng' => '3.3184', 'postal_code' => '7730', 'name' => 'Saint-Léger'),
      array('lat' => '50.6994', 'lng' => '3.3315', 'postal_code' => '7740', 'name' => 'Pecq'),
      array('lat' => '50.7044', 'lng' => '3.3440', 'postal_code' => '7740', 'name' => 'Warcoing'),
      array('lat' => '50.7013', 'lng' => '3.3633', 'postal_code' => '7742', 'name' => 'Hérinnes-Lez-Pecq'),
      array('lat' => '50.6656', 'lng' => '3.3479', 'postal_code' => '7743', 'name' => 'Esquelmes'),
      array('lat' => '50.6619', 'lng' => '3.3640', 'postal_code' => '7743', 'name' => 'Obigies'),
      array('lat' => '50.7443', 'lng' => '3.5068', 'postal_code' => '7750', 'name' => 'Amougies'),
      array('lat' => '50.7270', 'lng' => '3.5213', 'postal_code' => '7750', 'name' => 'Anseroeul'),
      array('lat' => '50.7403', 'lng' => '3.5053', 'postal_code' => '7750', 'name' => 'Mont-De-L\'enclus'),
      array('lat' => '50.7486', 'lng' => '3.4795', 'postal_code' => '7750', 'name' => 'Orroir'),
      array('lat' => '50.7446', 'lng' => '3.5308', 'postal_code' => '7750', 'name' => 'Russeignies'),
      array('lat' => '50.7121', 'lng' => '3.4575', 'postal_code' => '7760', 'name' => 'Celles'),
      array('lat' => '50.7537', 'lng' => '3.4480', 'postal_code' => '7760', 'name' => 'Escanaffles'),
      array('lat' => '50.6933', 'lng' => '3.4300', 'postal_code' => '7760', 'name' => 'Molenbaix'),
      array('lat' => '50.6625', 'lng' => '3.5188', 'postal_code' => '7760', 'name' => 'Popuelles'),
      array('lat' => '50.7312', 'lng' => '3.4064', 'postal_code' => '7760', 'name' => 'Pottes'),
      array('lat' => '50.6698', 'lng' => '3.4867', 'postal_code' => '7760', 'name' => 'Velaines'),
      array('lat' => '50.7687', 'lng' => '2.9997', 'postal_code' => '7780', 'name' => 'Komen'),
      array('lat' => '50.7811', 'lng' => '2.9998', 'postal_code' => '7780', 'name' => 'Komen-Waasten'),
      array('lat' => '50.7868', 'lng' => '2.9642', 'postal_code' => '7781', 'name' => 'Houthem'),
      array('lat' => '50.7266', 'lng' => '2.8806', 'postal_code' => '7782', 'name' => 'Ploegsteert'),
      array('lat' => '50.7083', 'lng' => '2.8930', 'postal_code' => '7783', 'name' => 'Bizet'),
      array('lat' => '50.7591', 'lng' => '2.9610', 'postal_code' => '7784', 'name' => 'Neerwaasten'),
      array('lat' => '50.7528', 'lng' => '2.9488', 'postal_code' => '7784', 'name' => 'Waasten'),
      array('lat' => '50.6335', 'lng' => '3.7883', 'postal_code' => '7800', 'name' => 'Ath'),
      array('lat' => '50.6533', 'lng' => '3.8065', 'postal_code' => '7800', 'name' => 'Lanquesaint'),
      array('lat' => '50.6180', 'lng' => '3.7591', 'postal_code' => '7801', 'name' => 'Irchonwelz'),
      array('lat' => '50.5946', 'lng' => '3.7511', 'postal_code' => '7802', 'name' => 'Ormeignies'),
      array('lat' => '50.6467', 'lng' => '3.7665', 'postal_code' => '7803', 'name' => 'Bouvignies'),
      array('lat' => '50.6785', 'lng' => '3.7591', 'postal_code' => '7804', 'name' => 'Ostiches'),
      array('lat' => '50.6604', 'lng' => '3.7835', 'postal_code' => '7804', 'name' => 'Rebaix'),
      array('lat' => '50.6170', 'lng' => '3.8058', 'postal_code' => '7810', 'name' => 'Maffle'),
      array('lat' => '50.6124', 'lng' => '3.8165', 'postal_code' => '7811', 'name' => 'Arbre'),
      array('lat' => '50.6405', 'lng' => '3.6791', 'postal_code' => '7812', 'name' => 'Houtaing'),
      array('lat' => '50.6216', 'lng' => '3.7046', 'postal_code' => '7812', 'name' => 'Ligne'),
      array('lat' => '50.6491', 'lng' => '3.7168', 'postal_code' => '7812', 'name' => 'Mainvault'),
      array('lat' => '50.6016', 'lng' => '3.7157', 'postal_code' => '7812', 'name' => 'Moulbaix'),
      array('lat' => '50.6169', 'lng' => '3.7362', 'postal_code' => '7812', 'name' => 'Villers-Notre-Dame'),
      array('lat' => '50.6228', 'lng' => '3.7289', 'postal_code' => '7812', 'name' => 'Villers-Saint-Amand'),
      array('lat' => '50.6565', 'lng' => '3.8774', 'postal_code' => '7822', 'name' => 'Ghislenghien'),
      array('lat' => '50.6654', 'lng' => '3.8177', 'postal_code' => '7822', 'name' => 'Isières'),
      array('lat' => '50.6494', 'lng' => '3.8474', 'postal_code' => '7822', 'name' => 'Meslin-L\'evêque'),
      array('lat' => '50.6383', 'lng' => '3.8879', 'postal_code' => '7823', 'name' => 'Gibecq'),
      array('lat' => '50.6768', 'lng' => '3.9337', 'postal_code' => '7830', 'name' => 'Bassilly'),
      array('lat' => '50.6182', 'lng' => '3.9278', 'postal_code' => '7830', 'name' => 'Fouleng'),
      array('lat' => '50.6273', 'lng' => '3.9119', 'postal_code' => '7830', 'name' => 'Gondregnies'),
      array('lat' => '50.6320', 'lng' => '3.9960', 'postal_code' => '7830', 'name' => 'Graty'),
      array('lat' => '50.6634', 'lng' => '3.8883', 'postal_code' => '7830', 'name' => 'Hellebecq'),
      array('lat' => '50.6708', 'lng' => '4.0357', 'postal_code' => '7830', 'name' => 'Hoves'),
      array('lat' => '50.6489', 'lng' => '3.9236', 'postal_code' => '7830', 'name' => 'Silly'),
      array('lat' => '50.6101', 'lng' => '3.9498', 'postal_code' => '7830', 'name' => 'Thoricourt'),
      array('lat' => '50.6947', 'lng' => '4.0419', 'postal_code' => '7850', 'name' => 'Edingen'),
      array('lat' => '50.6914', 'lng' => '4.0830', 'postal_code' => '7850', 'name' => 'Lettelingen'),
      array('lat' => '50.6914', 'lng' => '4.0154', 'postal_code' => '7850', 'name' => 'Mark'),
      array('lat' => '50.7047', 'lng' => '3.8349', 'postal_code' => '7860', 'name' => 'Lessines'),
      array('lat' => '50.6864', 'lng' => '3.8166', 'postal_code' => '7861', 'name' => 'Papignies'),
      array('lat' => '50.6944', 'lng' => '3.7997', 'postal_code' => '7861', 'name' => 'Wannebecq'),
      array('lat' => '50.7207', 'lng' => '3.7807', 'postal_code' => '7862', 'name' => 'Ogy'),
      array('lat' => '50.7299', 'lng' => '3.8103', 'postal_code' => '7863', 'name' => 'Ghoy'),
      array('lat' => '50.7289', 'lng' => '3.8540', 'postal_code' => '7864', 'name' => 'Deux-Acren'),
      array('lat' => '50.6969', 'lng' => '3.8882', 'postal_code' => '7866', 'name' => 'Bois-De-Lessines'),
      array('lat' => '50.6847', 'lng' => '3.8592', 'postal_code' => '7866', 'name' => 'Ollignies'),
      array('lat' => '50.5699', 'lng' => '3.8531', 'postal_code' => '7870', 'name' => 'Bauffe'),
      array('lat' => '50.5819', 'lng' => '3.9171', 'postal_code' => '7870', 'name' => 'Cambron-Saint-Vincent'),
      array('lat' => '50.5566', 'lng' => '3.9006', 'postal_code' => '7870', 'name' => 'Lens'),
      array('lat' => '50.5997', 'lng' => '3.9394', 'postal_code' => '7870', 'name' => 'Lombise'),
      array('lat' => '50.5643', 'lng' => '3.9441', 'postal_code' => '7870', 'name' => 'Montignies-Lez-Lens'),
      array('lat' => '50.7367', 'lng' => '3.7385', 'postal_code' => '7880', 'name' => 'Vloesberg'),
      array('lat' => '50.7338', 'lng' => '3.6799', 'postal_code' => '7890', 'name' => 'Ellezelles'),
      array('lat' => '50.6949', 'lng' => '3.7250', 'postal_code' => '7890', 'name' => 'Lahamaide'),
      array('lat' => '50.7185', 'lng' => '3.7468', 'postal_code' => '7890', 'name' => 'Wodecq'),
      array('lat' => '50.6231', 'lng' => '3.6311', 'postal_code' => '7900', 'name' => 'Grandmetz'),
      array('lat' => '50.5972', 'lng' => '3.6242', 'postal_code' => '7900', 'name' => 'Leuze-En-Hainaut'),
      array('lat' => '50.6179', 'lng' => '3.6052', 'postal_code' => '7901', 'name' => 'Thieulain'),
      array('lat' => '50.5872', 'lng' => '3.6916', 'postal_code' => '7903', 'name' => 'Blicquy'),
      array('lat' => '50.5966', 'lng' => '3.6707', 'postal_code' => '7903', 'name' => 'Chapelle-À-Oie'),
      array('lat' => '50.6121', 'lng' => '3.6525', 'postal_code' => '7903', 'name' => 'Chapelle-À-Wattines'),
      array('lat' => '50.5837', 'lng' => '3.5788', 'postal_code' => '7904', 'name' => 'Pipaix'),
      array('lat' => '50.5711', 'lng' => '3.6548', 'postal_code' => '7904', 'name' => 'Tourpes'),
      array('lat' => '50.5667', 'lng' => '3.6033', 'postal_code' => '7904', 'name' => 'Willaupuis'),
      array('lat' => '50.6053', 'lng' => '3.5739', 'postal_code' => '7906', 'name' => 'Gallaix'),
      array('lat' => '50.6828', 'lng' => '3.5610', 'postal_code' => '7910', 'name' => 'Anvaing'),
      array('lat' => '50.7022', 'lng' => '3.5470', 'postal_code' => '7910', 'name' => 'Arc-Ainières'),
      array('lat' => '50.7287', 'lng' => '3.5480', 'postal_code' => '7910', 'name' => 'Arc-Wattripont'),
      array('lat' => '50.6885', 'lng' => '3.5329', 'postal_code' => '7910', 'name' => 'Cordes'),
      array('lat' => '50.6747', 'lng' => '3.5906', 'postal_code' => '7910', 'name' => 'Ellignies-Lez-Frasnes'),
      array('lat' => '50.6733', 'lng' => '3.5366', 'postal_code' => '7910', 'name' => 'Forest'),
      array('lat' => '50.6986', 'lng' => '3.5331', 'postal_code' => '7910', 'name' => 'Frasnes-Lez-Anvaing'),
      array('lat' => '50.7287', 'lng' => '3.5480', 'postal_code' => '7910', 'name' => 'Wattripont'),
      array('lat' => '50.6642', 'lng' => '3.6557', 'postal_code' => '7911', 'name' => 'Buissenal'),
      array('lat' => '50.6699', 'lng' => '3.6198', 'postal_code' => '7911', 'name' => 'Frasnes-Lez-Buissenal'),
      array('lat' => '50.6514', 'lng' => '3.5935', 'postal_code' => '7911', 'name' => 'Hacquegnies'),
      array('lat' => '50.6350', 'lng' => '3.5781', 'postal_code' => '7911', 'name' => 'Herquegies'),
      array('lat' => '50.6476', 'lng' => '3.5721', 'postal_code' => '7911', 'name' => 'Montroeul-Au-Bois'),
      array('lat' => '50.6560', 'lng' => '3.6202', 'postal_code' => '7911', 'name' => 'Moustier'),
      array('lat' => '50.6793', 'lng' => '3.7088', 'postal_code' => '7911', 'name' => 'Oeudeghien'),
      array('lat' => '50.7133', 'lng' => '3.5690', 'postal_code' => '7912', 'name' => 'Dergneau'),
      array('lat' => '50.7062', 'lng' => '3.5974', 'postal_code' => '7912', 'name' => 'Saint-Sauveur'),
      array('lat' => '50.5992', 'lng' => '3.8545', 'postal_code' => '7940', 'name' => 'Brugelette'),
      array('lat' => '50.5890', 'lng' => '3.8801', 'postal_code' => '7940', 'name' => 'Cambron-Casteau'),
      array('lat' => '50.6067', 'lng' => '3.8385', 'postal_code' => '7941', 'name' => 'Attre'),
      array('lat' => '50.6073', 'lng' => '3.8525', 'postal_code' => '7942', 'name' => 'Mévergnies-Lez-Lens'),
      array('lat' => '50.6068', 'lng' => '3.8905', 'postal_code' => '7943', 'name' => 'Gages'),
      array('lat' => '50.5860', 'lng' => '3.8061', 'postal_code' => '7950', 'name' => 'ChiÈvres'),
      array('lat' => '50.5447', 'lng' => '3.7564', 'postal_code' => '7950', 'name' => 'Grosage'),
      array('lat' => '50.5648', 'lng' => '3.7541', 'postal_code' => '7950', 'name' => 'Huissignies'),
      array('lat' => '50.5645', 'lng' => '3.7686', 'postal_code' => '7950', 'name' => 'Ladeuze'),
      array('lat' => '50.5869', 'lng' => '3.7888', 'postal_code' => '7950', 'name' => 'Tongre-Saint-Martin'),
      array('lat' => '50.5814', 'lng' => '3.7756', 'postal_code' => '7951', 'name' => 'Tongre-Notre-Dame'),
      array('lat' => '50.5318', 'lng' => '3.7256', 'postal_code' => '7970', 'name' => 'Beloeil'),
      array('lat' => '50.5259', 'lng' => '3.6489', 'postal_code' => '7971', 'name' => 'Basècles'),
      array('lat' => '50.5440', 'lng' => '3.6347', 'postal_code' => '7971', 'name' => 'Ramegnies'),
      array('lat' => '50.5404', 'lng' => '3.6305', 'postal_code' => '7971', 'name' => 'Thumaide'),
      array('lat' => '50.5377', 'lng' => '3.6534', 'postal_code' => '7971', 'name' => 'Wadelincourt'),
      array('lat' => '50.5724', 'lng' => '3.6814', 'postal_code' => '7972', 'name' => 'Aubechies'),
      array('lat' => '50.5628', 'lng' => '3.6770', 'postal_code' => '7972', 'name' => 'Ellignies-Saint-Anne'),
      array('lat' => '50.5187', 'lng' => '3.6801', 'postal_code' => '7972', 'name' => 'Quevaucamps'),
      array('lat' => '50.5053', 'lng' => '3.6942', 'postal_code' => '7973', 'name' => 'Grandglise'),
      array('lat' => '50.5086', 'lng' => '3.7172', 'postal_code' => '7973', 'name' => 'Stambruges'),
    ],
    'WLX' => [
      array('lat' => '50.0006', 'lng' => '5.7153', 'postal_code' => '6600', 'name' => 'Bastogne'),
      array('lat' => '50.0249', 'lng' => '5.8365', 'postal_code' => '6600', 'name' => 'Longvilly'),
      array('lat' => '50.0637', 'lng' => '5.7608', 'postal_code' => '6600', 'name' => 'Noville'),
      array('lat' => '49.9340', 'lng' => '5.7482', 'postal_code' => '6600', 'name' => 'Villers-La-Bonne-Eau'),
      array('lat' => '49.9911', 'lng' => '5.7882', 'postal_code' => '6600', 'name' => 'Wardin'),
      array('lat' => '49.8324', 'lng' => '5.7402', 'postal_code' => '6630', 'name' => 'Martelange'),
      array('lat' => '49.8516', 'lng' => '5.6628', 'postal_code' => '6637', 'name' => 'Fauvillers'),
      array('lat' => '49.9065', 'lng' => '5.6888', 'postal_code' => '6637', 'name' => 'Hollange'),
      array('lat' => '49.8788', 'lng' => '5.7515', 'postal_code' => '6637', 'name' => 'Tintange'),
      array('lat' => '49.9444', 'lng' => '5.6870', 'postal_code' => '6640', 'name' => 'Hompré'),
      array('lat' => '49.9634', 'lng' => '5.5842', 'postal_code' => '6640', 'name' => 'Morhet'),
      array('lat' => '49.9091', 'lng' => '5.6070', 'postal_code' => '6640', 'name' => 'Nives'),
      array('lat' => '49.9707', 'lng' => '5.6342', 'postal_code' => '6640', 'name' => 'Sibret'),
      array('lat' => '49.9125', 'lng' => '5.5677', 'postal_code' => '6640', 'name' => 'Vaux-Lez-Rosières'),
      array('lat' => '49.9445', 'lng' => '5.6203', 'postal_code' => '6640', 'name' => 'Vaux-Sur-SÛre'),
      array('lat' => '49.8797', 'lng' => '5.5493', 'postal_code' => '6642', 'name' => 'Juseret'),
      array('lat' => '50.1419', 'lng' => '5.6912', 'postal_code' => '6660', 'name' => 'Houffalize'),
      array('lat' => '50.1590', 'lng' => '5.6828', 'postal_code' => '6660', 'name' => 'Nadrin'),
      array('lat' => '50.1532', 'lng' => '5.7696', 'postal_code' => '6661', 'name' => 'Mont'),
      array('lat' => '50.2265', 'lng' => '5.7467', 'postal_code' => '6661', 'name' => 'Tailles'),
      array('lat' => '50.1089', 'lng' => '5.8394', 'postal_code' => '6662', 'name' => 'Tavigny'),
      array('lat' => '50.0990', 'lng' => '5.7403', 'postal_code' => '6663', 'name' => 'Mabompré'),
      array('lat' => '50.1661', 'lng' => '5.7175', 'postal_code' => '6666', 'name' => 'Wibrin'),
      array('lat' => '50.1457', 'lng' => '5.9246', 'postal_code' => '6670', 'name' => 'Gouvy'),
      array('lat' => '50.1573', 'lng' => '5.9244', 'postal_code' => '6670', 'name' => 'Limerlé'),
      array('lat' => '50.2251', 'lng' => '5.9191', 'postal_code' => '6671', 'name' => 'Bovigny'),
      array('lat' => '50.2197', 'lng' => '5.9980', 'postal_code' => '6672', 'name' => 'Beho'),
      array('lat' => '50.1805', 'lng' => '5.8653', 'postal_code' => '6673', 'name' => 'Cherain'),
      array('lat' => '50.2121', 'lng' => '5.8376', 'postal_code' => '6674', 'name' => 'Montleban'),
      array('lat' => '50.0317', 'lng' => '5.5296', 'postal_code' => '6680', 'name' => 'Amberloup'),
      array('lat' => '50.0200', 'lng' => '5.5481', 'postal_code' => '6680', 'name' => 'Sainte-Ode'),
      array('lat' => '50.0104', 'lng' => '5.5297', 'postal_code' => '6680', 'name' => 'Tillet'),
      array('lat' => '50.0529', 'lng' => '5.5100', 'postal_code' => '6681', 'name' => 'Lavacherie'),
      array('lat' => '50.0336', 'lng' => '5.6044', 'postal_code' => '6686', 'name' => 'Flamierge'),
      array('lat' => '50.0908', 'lng' => '5.6809', 'postal_code' => '6687', 'name' => 'Bertogne'),
      array('lat' => '50.0536', 'lng' => '5.6908', 'postal_code' => '6688', 'name' => 'Longchamps'),
      array('lat' => '50.2381', 'lng' => '5.8087', 'postal_code' => '6690', 'name' => 'Bihain'),
      array('lat' => '50.2517', 'lng' => '5.8712', 'postal_code' => '6690', 'name' => 'Vielsalm'),
      array('lat' => '50.3078', 'lng' => '5.9676', 'postal_code' => '6692', 'name' => 'Petit-Thier'),
      array('lat' => '50.3260', 'lng' => '5.9066', 'postal_code' => '6698', 'name' => 'Grand-Halleux'),
      array('lat' => '49.6851', 'lng' => '5.8105', 'postal_code' => '6700', 'name' => 'Arlon'),
      array('lat' => '49.7109', 'lng' => '5.8188', 'postal_code' => '6700', 'name' => 'Bonnert'),
      array('lat' => '49.6995', 'lng' => '5.7465', 'postal_code' => '6700', 'name' => 'Heinsch'),
      array('lat' => '49.6525', 'lng' => '5.7791', 'postal_code' => '6700', 'name' => 'Toernich'),
      array('lat' => '49.7099', 'lng' => '5.8286', 'postal_code' => '6704', 'name' => 'Guirsch'),
      array('lat' => '49.6481', 'lng' => '5.8624', 'postal_code' => '6706', 'name' => 'Autelbas'),
      array('lat' => '49.7507', 'lng' => '5.7865', 'postal_code' => '6717', 'name' => 'Attert'),
      array('lat' => '49.7400', 'lng' => '5.7179', 'postal_code' => '6717', 'name' => 'Nobressart'),
      array('lat' => '49.7723', 'lng' => '5.7885', 'postal_code' => '6717', 'name' => 'Nothomb'),
      array('lat' => '49.7154', 'lng' => '5.7308', 'postal_code' => '6717', 'name' => 'Thiaumont'),
      array('lat' => '49.7260', 'lng' => '5.8098', 'postal_code' => '6717', 'name' => 'Tontelange'),
      array('lat' => '49.7267', 'lng' => '5.6635', 'postal_code' => '6720', 'name' => 'Habay'),
      array('lat' => '49.7281', 'lng' => '5.6460', 'postal_code' => '6720', 'name' => 'Habay-La-Neuve'),
      array('lat' => '49.7018', 'lng' => '5.6804', 'postal_code' => '6720', 'name' => 'Hachy'),
      array('lat' => '49.7719', 'lng' => '5.6208', 'postal_code' => '6721', 'name' => 'Anlier'),
      array('lat' => '49.7235', 'lng' => '5.6193', 'postal_code' => '6723', 'name' => 'Habay-La-Vieille'),
      array('lat' => '49.7189', 'lng' => '5.5840', 'postal_code' => '6724', 'name' => 'Houdemont'),
      array('lat' => '49.7185', 'lng' => '5.5596', 'postal_code' => '6724', 'name' => 'Rulles'),
      array('lat' => '49.6639', 'lng' => '5.4965', 'postal_code' => '6730', 'name' => 'Bellefontaine'),
      array('lat' => '49.7175', 'lng' => '5.4857', 'postal_code' => '6730', 'name' => 'Rossignol'),
      array('lat' => '49.6773', 'lng' => '5.4757', 'postal_code' => '6730', 'name' => 'Saint-Vincent'),
      array('lat' => '49.6833', 'lng' => '5.5131', 'postal_code' => '6730', 'name' => 'Tintigny'),
      array('lat' => '49.6694', 'lng' => '5.5780', 'postal_code' => '6740', 'name' => 'Etalle'),
      array('lat' => '49.6712', 'lng' => '5.5636', 'postal_code' => '6740', 'name' => 'Sainte-Marie-Sur-Semois'),
      array('lat' => '49.6984', 'lng' => '5.5599', 'postal_code' => '6740', 'name' => 'Villers-Sur-Semois'),
      array('lat' => '49.6713', 'lng' => '5.6658', 'postal_code' => '6741', 'name' => 'Vance'),
      array('lat' => '49.6529', 'lng' => '5.6527', 'postal_code' => '6742', 'name' => 'Chantemelle'),
      array('lat' => '49.6457', 'lng' => '5.5953', 'postal_code' => '6743', 'name' => 'Buzenol'),
      array('lat' => '49.6248', 'lng' => '5.6966', 'postal_code' => '6747', 'name' => 'Châtillon'),
      array('lat' => '49.6171', 'lng' => '5.7207', 'postal_code' => '6747', 'name' => 'Meix-Le-Tige'),
      array('lat' => '49.5582', 'lng' => '5.7057', 'postal_code' => '6750', 'name' => 'Musson'),
      array('lat' => '49.5707', 'lng' => '5.6620', 'postal_code' => '6750', 'name' => 'Mussy-La-Ville'),
      array('lat' => '49.5522', 'lng' => '5.6381', 'postal_code' => '6750', 'name' => 'Signeulx'),
      array('lat' => '49.5693', 'lng' => '5.6281', 'postal_code' => '6760', 'name' => 'Bleid'),
      array('lat' => '49.5797', 'lng' => '5.5819', 'postal_code' => '6760', 'name' => 'Ethe'),
      array('lat' => '49.5366', 'lng' => '5.5949', 'postal_code' => '6760', 'name' => 'Ruette'),
      array('lat' => '49.5872', 'lng' => '5.5863', 'postal_code' => '6760', 'name' => 'Virton'),
      array('lat' => '49.5575', 'lng' => '5.5706', 'postal_code' => '6761', 'name' => 'Latour'),
      array('lat' => '49.5543', 'lng' => '5.5347', 'postal_code' => '6762', 'name' => 'Saint-Mard'),
      array('lat' => '49.5567', 'lng' => '5.4760', 'postal_code' => '6767', 'name' => 'Dampicourt'),
      array('lat' => '49.5355', 'lng' => '5.4996', 'postal_code' => '6767', 'name' => 'Harnoncourt'),
      array('lat' => '49.5260', 'lng' => '5.4807', 'postal_code' => '6767', 'name' => 'Lamorteau'),
      array('lat' => '49.5381', 'lng' => '5.4919', 'postal_code' => '6767', 'name' => 'Rouvroy'),
      array('lat' => '49.5081', 'lng' => '5.4740', 'postal_code' => '6767', 'name' => 'Torgny'),
      array('lat' => '49.6204', 'lng' => '5.4269', 'postal_code' => '6769', 'name' => 'Gérouville'),
      array('lat' => '49.6056', 'lng' => '5.4780', 'postal_code' => '6769', 'name' => 'Meix-Devant-Virton'),
      array('lat' => '49.5945', 'lng' => '5.5079', 'postal_code' => '6769', 'name' => 'Robelmont'),
      array('lat' => '49.5785', 'lng' => '5.4479', 'postal_code' => '6769', 'name' => 'Sommethonne'),
      array('lat' => '49.5746', 'lng' => '5.4822', 'postal_code' => '6769', 'name' => 'Villers-La-Loue'),
      array('lat' => '49.6334', 'lng' => '5.8363', 'postal_code' => '6780', 'name' => 'Hondelange'),
      array('lat' => '49.6216', 'lng' => '5.8214', 'postal_code' => '6780', 'name' => 'Messancy'),
      array('lat' => '49.6337', 'lng' => '5.7994', 'postal_code' => '6780', 'name' => 'Wolkrange'),
      array('lat' => '49.6094', 'lng' => '5.8467', 'postal_code' => '6781', 'name' => 'Sélange'),
      array('lat' => '49.6143', 'lng' => '5.7596', 'postal_code' => '6782', 'name' => 'Habergy'),
      array('lat' => '49.5609', 'lng' => '5.8089', 'postal_code' => '6790', 'name' => 'Aubange'),
      array('lat' => '49.5629', 'lng' => '5.8347', 'postal_code' => '6791', 'name' => 'Athus'),
      array('lat' => '49.5565', 'lng' => '5.7432', 'postal_code' => '6792', 'name' => 'Halanzy'),
      array('lat' => '49.5912', 'lng' => '5.7267', 'postal_code' => '6792', 'name' => 'Rachecourt'),
      array('lat' => '49.9750', 'lng' => '5.3892', 'postal_code' => '6800', 'name' => 'Bras'),
      array('lat' => '49.9700', 'lng' => '5.4504', 'postal_code' => '6800', 'name' => 'Freux'),
      array('lat' => '49.9184', 'lng' => '5.3746', 'postal_code' => '6800', 'name' => 'Libramont-Chevigny'),
      array('lat' => '49.9896', 'lng' => '5.4695', 'postal_code' => '6800', 'name' => 'Moircy'),
      array('lat' => '49.9111', 'lng' => '5.3603', 'postal_code' => '6800', 'name' => 'Recogne'),
      array('lat' => '49.9766', 'lng' => '5.4944', 'postal_code' => '6800', 'name' => 'Remagne'),
      array('lat' => '49.9037', 'lng' => '5.3880', 'postal_code' => '6800', 'name' => 'Saint-Pierre'),
      array('lat' => '49.9235', 'lng' => '5.4583', 'postal_code' => '6800', 'name' => 'Sainte-Marie-Chevigny'),
      array('lat' => '49.6990', 'lng' => '5.3867', 'postal_code' => '6810', 'name' => 'Chiny'),
      array('lat' => '49.6937', 'lng' => '5.3722', 'postal_code' => '6810', 'name' => 'Izel'),
      array('lat' => '49.6949', 'lng' => '5.4146', 'postal_code' => '6810', 'name' => 'Jamoigne'),
      array('lat' => '49.7042', 'lng' => '5.4239', 'postal_code' => '6811', 'name' => 'Les Bulles'),
      array('lat' => '49.7640', 'lng' => '5.3993', 'postal_code' => '6812', 'name' => 'Suxy'),
      array('lat' => '49.7078', 'lng' => '5.4578', 'postal_code' => '6813', 'name' => 'Termes'),
      array('lat' => '49.7271', 'lng' => '5.2201', 'postal_code' => '6820', 'name' => 'Florenville'),
      array('lat' => '49.7151', 'lng' => '5.2343', 'postal_code' => '6820', 'name' => 'Fontenoille'),
      array('lat' => '49.7164', 'lng' => '5.1751', 'postal_code' => '6820', 'name' => 'Muno'),
      array('lat' => '49.7297', 'lng' => '5.2429', 'postal_code' => '6820', 'name' => 'Sainte-Cécile'),
      array('lat' => '49.7164', 'lng' => '5.3173', 'postal_code' => '6821', 'name' => 'Lacuisine'),
      array('lat' => '49.6196', 'lng' => '5.3314', 'postal_code' => '6823', 'name' => 'Villers-Devant-Orval'),
      array('lat' => '49.7077', 'lng' => '5.2603', 'postal_code' => '6824', 'name' => 'Chassepierre'),
      array('lat' => '49.7892', 'lng' => '5.0905', 'postal_code' => '6830', 'name' => 'Bouillon'),
      array('lat' => '49.8130', 'lng' => '5.1454', 'postal_code' => '6830', 'name' => 'Les Hayons'),
      array('lat' => '49.8115', 'lng' => '5.0028', 'postal_code' => '6830', 'name' => 'Poupehan'),
      array('lat' => '49.8412', 'lng' => '5.0077', 'postal_code' => '6830', 'name' => 'Rochehaut'),
      array('lat' => '49.8202', 'lng' => '5.0943', 'postal_code' => '6831', 'name' => 'Noirfontaine'),
      array('lat' => '49.8245', 'lng' => '5.0762', 'postal_code' => '6832', 'name' => 'Sensenruth'),
      array('lat' => '49.8317', 'lng' => '5.0584', 'postal_code' => '6833', 'name' => 'Ucimont'),
      array('lat' => '49.8669', 'lng' => '5.0384', 'postal_code' => '6833', 'name' => 'Vivy'),
      array('lat' => '49.8406', 'lng' => '5.1101', 'postal_code' => '6834', 'name' => 'Bellevaux'),
      array('lat' => '49.7961', 'lng' => '5.1428', 'postal_code' => '6836', 'name' => 'Dohan'),
      array('lat' => '49.7972', 'lng' => '5.0077', 'postal_code' => '6838', 'name' => 'Corbion'),
      array('lat' => '49.8584', 'lng' => '5.3727', 'postal_code' => '6840', 'name' => 'Grandvoir'),
      array('lat' => '49.8221', 'lng' => '5.4062', 'postal_code' => '6840', 'name' => 'Grapfontaine'),
      array('lat' => '49.8375', 'lng' => '5.4574', 'postal_code' => '6840', 'name' => 'Hamipré'),
      array('lat' => '49.8554', 'lng' => '5.4529', 'postal_code' => '6840', 'name' => 'Longlier'),
      array('lat' => '49.8418', 'lng' => '5.4342', 'postal_code' => '6840', 'name' => 'NeufchÂteau'),
      array('lat' => '49.8547', 'lng' => '5.3977', 'postal_code' => '6840', 'name' => 'Tournay'),
      array('lat' => '49.8947', 'lng' => '5.0822', 'postal_code' => '6850', 'name' => 'Carlsbourg'),
      array('lat' => '49.8862', 'lng' => '5.1750', 'postal_code' => '6850', 'name' => 'Offagne'),
      array('lat' => '49.9037', 'lng' => '5.1346', 'postal_code' => '6850', 'name' => 'Paliseul'),
      array('lat' => '49.8713', 'lng' => '5.1211', 'postal_code' => '6851', 'name' => 'Nollevaux'),
      array('lat' => '49.9647', 'lng' => '5.1791', 'postal_code' => '6852', 'name' => 'Maissin'),
      array('lat' => '49.9356', 'lng' => '5.1196', 'postal_code' => '6852', 'name' => 'Opont'),
      array('lat' => '49.9193', 'lng' => '5.1605', 'postal_code' => '6853', 'name' => 'Framont'),
      array('lat' => '49.8665', 'lng' => '5.1614', 'postal_code' => '6856', 'name' => 'Fays-Les-Veneurs'),
      array('lat' => '49.8015', 'lng' => '5.4651', 'postal_code' => '6860', 'name' => 'Assenois'),
      array('lat' => '49.8531', 'lng' => '5.5404', 'postal_code' => '6860', 'name' => 'Ebly'),
      array('lat' => '49.8000', 'lng' => '5.5376', 'postal_code' => '6860', 'name' => 'LÉglise'),
      array('lat' => '49.7686', 'lng' => '5.5221', 'postal_code' => '6860', 'name' => 'Mellier'),
      array('lat' => '49.8596', 'lng' => '5.6131', 'postal_code' => '6860', 'name' => 'Witry'),
      array('lat' => '50.0324', 'lng' => '5.3193', 'postal_code' => '6870', 'name' => 'Arville'),
      array('lat' => '50.0742', 'lng' => '5.3067', 'postal_code' => '6870', 'name' => 'Awenne'),
      array('lat' => '50.0051', 'lng' => '5.3452', 'postal_code' => '6870', 'name' => 'Hatrival'),
      array('lat' => '50.0565', 'lng' => '5.2638', 'postal_code' => '6870', 'name' => 'Mirwart'),
      array('lat' => '50.0260', 'lng' => '5.3727', 'postal_code' => '6870', 'name' => 'Saint-Hubert'),
      array('lat' => '50.0060', 'lng' => '5.3945', 'postal_code' => '6870', 'name' => 'Vesqueville'),
      array('lat' => '49.8158', 'lng' => '5.1831', 'postal_code' => '6880', 'name' => 'Auby-Sur-Semois'),
      array('lat' => '49.8542', 'lng' => '5.2536', 'postal_code' => '6880', 'name' => 'Bertrix'),
      array('lat' => '49.8023', 'lng' => '5.2026', 'postal_code' => '6880', 'name' => 'Cugnon'),
      array('lat' => '49.9068', 'lng' => '5.2004', 'postal_code' => '6880', 'name' => 'Jehonville'),
      array('lat' => '49.8365', 'lng' => '5.2996', 'postal_code' => '6880', 'name' => 'Orgeo'),
      array('lat' => '49.7810', 'lng' => '5.2376', 'postal_code' => '6887', 'name' => 'Herbeumont'),
      array('lat' => '49.8118', 'lng' => '5.3281', 'postal_code' => '6887', 'name' => 'Saint-Médard'),
      array('lat' => '49.7955', 'lng' => '5.3815', 'postal_code' => '6887', 'name' => 'Straimont'),
      array('lat' => '49.9495', 'lng' => '5.2217', 'postal_code' => '6890', 'name' => 'Anloy'),
      array('lat' => '49.9815', 'lng' => '5.2572', 'postal_code' => '6890', 'name' => 'Libin'),
      array('lat' => '49.9249', 'lng' => '5.2775', 'postal_code' => '6890', 'name' => 'Ochamps'),
      array('lat' => '50.0075', 'lng' => '5.1598', 'postal_code' => '6890', 'name' => 'Redu'),
      array('lat' => '50.0188', 'lng' => '5.2668', 'postal_code' => '6890', 'name' => 'Smuid'),
      array('lat' => '50.0005', 'lng' => '5.2036', 'postal_code' => '6890', 'name' => 'Transinne'),
      array('lat' => '49.9710', 'lng' => '5.2204', 'postal_code' => '6890', 'name' => 'Villance'),
      array('lat' => '50.2249', 'lng' => '5.2970', 'postal_code' => '6900', 'name' => 'Aye'),
      array('lat' => '50.1862', 'lng' => '5.3063', 'postal_code' => '6900', 'name' => 'Hargimont'),
      array('lat' => '50.2050', 'lng' => '5.2566', 'postal_code' => '6900', 'name' => 'Humain'),
      array('lat' => '50.2283', 'lng' => '5.3442', 'postal_code' => '6900', 'name' => 'Marche-En-Famenne'),
      array('lat' => '50.1738', 'lng' => '5.2878', 'postal_code' => '6900', 'name' => 'On'),
      array('lat' => '50.1859', 'lng' => '5.4071', 'postal_code' => '6900', 'name' => 'Roy'),
      array('lat' => '50.2119', 'lng' => '5.3430', 'postal_code' => '6900', 'name' => 'Waha'),
      array('lat' => '50.0683', 'lng' => '5.0678', 'postal_code' => '6920', 'name' => 'Sohier'),
      array('lat' => '50.0575', 'lng' => '5.0650', 'postal_code' => '6920', 'name' => 'Wellin'),
      array('lat' => '50.0796', 'lng' => '5.1541', 'postal_code' => '6921', 'name' => 'Chanly'),
      array('lat' => '50.0757', 'lng' => '5.1363', 'postal_code' => '6922', 'name' => 'Halma'),
      array('lat' => '50.0762', 'lng' => '5.0924', 'postal_code' => '6924', 'name' => 'Lomprez'),
      array('lat' => '50.0884', 'lng' => '5.2595', 'postal_code' => '6927', 'name' => 'Bure'),
      array('lat' => '50.0917', 'lng' => '5.2802', 'postal_code' => '6927', 'name' => 'Grupont'),
      array('lat' => '50.0837', 'lng' => '5.1762', 'postal_code' => '6927', 'name' => 'Resteigne'),
      array('lat' => '50.0834', 'lng' => '5.2208', 'postal_code' => '6927', 'name' => 'Tellin'),
      array('lat' => '50.0203', 'lng' => '5.1182', 'postal_code' => '6929', 'name' => 'Daverdisse'),
      array('lat' => '49.9949', 'lng' => '5.0657', 'postal_code' => '6929', 'name' => 'Gembes'),
      array('lat' => '50.0012', 'lng' => '5.0176', 'postal_code' => '6929', 'name' => 'Haut-Fays'),
      array('lat' => '49.9782', 'lng' => '5.0870', 'postal_code' => '6929', 'name' => 'Porcheresse'),
      array('lat' => '50.3506', 'lng' => '5.4931', 'postal_code' => '6940', 'name' => 'Barvaux-Sur-Ourthe'),
      array('lat' => '50.3351', 'lng' => '5.4346', 'postal_code' => '6940', 'name' => 'Durbuy'),
      array('lat' => '50.3295', 'lng' => '5.4113', 'postal_code' => '6940', 'name' => 'Grandhan'),
      array('lat' => '50.3551', 'lng' => '5.4217', 'postal_code' => '6940', 'name' => 'Septon'),
      array('lat' => '50.3261', 'lng' => '5.5305', 'postal_code' => '6940', 'name' => 'Wéris'),
      array('lat' => '50.4195', 'lng' => '5.4154', 'postal_code' => '6941', 'name' => 'Bende'),
      array('lat' => '50.3790', 'lng' => '5.5235', 'postal_code' => '6941', 'name' => 'Bomal-Sur-Ourthe'),
      array('lat' => '50.3790', 'lng' => '5.4051', 'postal_code' => '6941', 'name' => 'Borlon'),
      array('lat' => '50.3473', 'lng' => '5.5619', 'postal_code' => '6941', 'name' => 'Heyd'),
      array('lat' => '50.3838', 'lng' => '5.5795', 'postal_code' => '6941', 'name' => 'Izier'),
      array('lat' => '50.3798', 'lng' => '5.4801', 'postal_code' => '6941', 'name' => 'Tohogne'),
      array('lat' => '50.3616', 'lng' => '5.5801', 'postal_code' => '6941', 'name' => 'Villers-Sainte-Gertrude'),
      array('lat' => '50.1736', 'lng' => '5.3479', 'postal_code' => '6950', 'name' => 'Harsin'),
      array('lat' => '50.1109', 'lng' => '5.3665', 'postal_code' => '6950', 'name' => 'Nassogne'),
      array('lat' => '50.1670', 'lng' => '5.4155', 'postal_code' => '6951', 'name' => 'Bande'),
      array('lat' => '50.1548', 'lng' => '5.3813', 'postal_code' => '6952', 'name' => 'Grune'),
      array('lat' => '50.1444', 'lng' => '5.3118', 'postal_code' => '6953', 'name' => 'Ambly'),
      array('lat' => '50.1338', 'lng' => '5.2808', 'postal_code' => '6953', 'name' => 'Forrières'),
      array('lat' => '50.1116', 'lng' => '5.2802', 'postal_code' => '6953', 'name' => 'Lesterny'),
      array('lat' => '50.1134', 'lng' => '5.3137', 'postal_code' => '6953', 'name' => 'Masbourg'),
      array('lat' => '50.2328', 'lng' => '5.6234', 'postal_code' => '6960', 'name' => 'Dochamps'),
      array('lat' => '50.2905', 'lng' => '5.6599', 'postal_code' => '6960', 'name' => 'Grandmenil'),
      array('lat' => '50.3506', 'lng' => '5.6562', 'postal_code' => '6960', 'name' => 'Harre'),
      array('lat' => '50.2817', 'lng' => '5.7124', 'postal_code' => '6960', 'name' => 'Malempré'),
      array('lat' => '50.2909', 'lng' => '5.6614', 'postal_code' => '6960', 'name' => 'Manhay'),
      array('lat' => '50.2569', 'lng' => '5.6802', 'postal_code' => '6960', 'name' => 'Odeigne'),
      array('lat' => '50.3048', 'lng' => '5.6912', 'postal_code' => '6960', 'name' => 'Vaux-Chavanne'),
      array('lat' => '50.0859', 'lng' => '5.4613', 'postal_code' => '6970', 'name' => 'Tenneville'),
      array('lat' => '50.1075', 'lng' => '5.5021', 'postal_code' => '6971', 'name' => 'Champlon'),
      array('lat' => '50.1128', 'lng' => '5.5493', 'postal_code' => '6972', 'name' => 'Erneuville'),
      array('lat' => '50.1700', 'lng' => '5.5539', 'postal_code' => '6980', 'name' => 'Beausaint'),
      array('lat' => '50.1846', 'lng' => '5.5556', 'postal_code' => '6980', 'name' => 'La Roche-En-Ardenne'),
      array('lat' => '50.2112', 'lng' => '5.6342', 'postal_code' => '6982', 'name' => 'Samrée'),
      array('lat' => '50.1251', 'lng' => '5.6140', 'postal_code' => '6983', 'name' => 'Ortho'),
      array('lat' => '50.1505', 'lng' => '5.5777', 'postal_code' => '6984', 'name' => 'Hives'),
      array('lat' => '50.1722', 'lng' => '5.5010', 'postal_code' => '6986', 'name' => 'Halleux'),
      array('lat' => '50.2450', 'lng' => '5.5236', 'postal_code' => '6987', 'name' => 'Beffe'),
      array('lat' => '50.1999', 'lng' => '5.4960', 'postal_code' => '6987', 'name' => 'Hodister'),
      array('lat' => '50.2145', 'lng' => '5.5316', 'postal_code' => '6987', 'name' => 'Marcourt'),
      array('lat' => '50.2348', 'lng' => '5.5082', 'postal_code' => '6987', 'name' => 'Rendeux'),
      array('lat' => '50.2945', 'lng' => '5.4221', 'postal_code' => '6990', 'name' => 'Fronville'),
      array('lat' => '50.2587', 'lng' => '5.4704', 'postal_code' => '6990', 'name' => 'Hampteau'),
      array('lat' => '50.2673', 'lng' => '5.4457', 'postal_code' => '6990', 'name' => 'Hotton'),
      array('lat' => '50.2425', 'lng' => '5.4164', 'postal_code' => '6990', 'name' => 'Marenne'),
      array('lat' => '50.2647', 'lng' => '5.5581', 'postal_code' => '6997', 'name' => 'Amonines'),
      array('lat' => '50.2917', 'lng' => '5.5585', 'postal_code' => '6997', 'name' => 'ErezÉe'),
      array('lat' => '50.3255', 'lng' => '5.5930', 'postal_code' => '6997', 'name' => 'Mormont'),
      array('lat' => '50.2856', 'lng' => '5.5111', 'postal_code' => '6997', 'name' => 'Soy'),
    ],
    'VWV' => [
      array('lat' => '51.2093', 'lng' => '3.2247', 'postal_code' => '8000', 'name' => 'Brugge'),
      array('lat' => '51.2403', 'lng' => '3.2481', 'postal_code' => '8000', 'name' => 'Koolkerke'),
      array('lat' => '51.1054', 'lng' => '3.2731', 'postal_code' => '8020', 'name' => 'Hertsberge'),
      array('lat' => '51.1545', 'lng' => '3.2334', 'postal_code' => '8020', 'name' => 'Oostkamp'),
      array('lat' => '51.0959', 'lng' => '3.2065', 'postal_code' => '8020', 'name' => 'Ruddervoorde'),
      array('lat' => '51.1133', 'lng' => '3.2193', 'postal_code' => '8020', 'name' => 'Waardamme'),
      array('lat' => '51.1972', 'lng' => '3.1795', 'postal_code' => '8200', 'name' => 'Sint-Andries'),
      array('lat' => '51.1859', 'lng' => '3.2082', 'postal_code' => '8200', 'name' => 'Sint-Michiels'),
      array('lat' => '51.1559', 'lng' => '3.1959', 'postal_code' => '8210', 'name' => 'Loppem'),
      array('lat' => '51.1045', 'lng' => '3.1595', 'postal_code' => '8210', 'name' => 'Veldegem'),
      array('lat' => '51.1423', 'lng' => '3.1369', 'postal_code' => '8210', 'name' => 'Zedelgem'),
      array('lat' => '51.1192', 'lng' => '3.0901', 'postal_code' => '8211', 'name' => 'Aartrijke'),
      array('lat' => '51.3467', 'lng' => '3.2894', 'postal_code' => '8300', 'name' => 'Knokke'),
      array('lat' => '51.3467', 'lng' => '3.2894', 'postal_code' => '8300', 'name' => 'Knokke-Heist'),
      array('lat' => '51.3157', 'lng' => '3.3029', 'postal_code' => '8300', 'name' => 'Westkapelle'),
      array('lat' => '51.3404', 'lng' => '3.2400', 'postal_code' => '8301', 'name' => 'Heist-Aan-Zee'),
      array('lat' => '51.2020', 'lng' => '3.2551', 'postal_code' => '8310', 'name' => 'Assebroek'),
      array('lat' => '51.2143', 'lng' => '3.2513', 'postal_code' => '8310', 'name' => 'Sint-Kruis'),
      array('lat' => '51.2514', 'lng' => '3.2814', 'postal_code' => '8340', 'name' => 'Damme'),
      array('lat' => '51.2916', 'lng' => '3.3367', 'postal_code' => '8340', 'name' => 'Hoeke'),
      array('lat' => '51.2776', 'lng' => '3.3568', 'postal_code' => '8340', 'name' => 'Lapscheure'),
      array('lat' => '51.2431', 'lng' => '3.3401', 'postal_code' => '8340', 'name' => 'Moerkerke'),
      array('lat' => '51.2016', 'lng' => '3.3212', 'postal_code' => '8340', 'name' => 'Sijsele'),
      array('lat' => '51.3124', 'lng' => '3.1328', 'postal_code' => '8370', 'name' => 'Blankenberge'),
      array('lat' => '51.3033', 'lng' => '3.1429', 'postal_code' => '8370', 'name' => 'Uitkerke'),
      array('lat' => '51.2360', 'lng' => '3.1105', 'postal_code' => '8377', 'name' => 'Houtave'),
      array('lat' => '51.2351', 'lng' => '3.1514', 'postal_code' => '8377', 'name' => 'Meetkerke'),
      array('lat' => '51.2738', 'lng' => '3.0987', 'postal_code' => '8377', 'name' => 'Nieuwmunster'),
      array('lat' => '51.2649', 'lng' => '3.1539', 'postal_code' => '8377', 'name' => 'Zuienkerke'),
      array('lat' => '51.2737', 'lng' => '3.2247', 'postal_code' => '8380', 'name' => 'Dudzele'),
      array('lat' => '51.2941', 'lng' => '3.1923', 'postal_code' => '8380', 'name' => 'Lissewege'),
      array('lat' => '51.3189', 'lng' => '3.2069', 'postal_code' => '8380', 'name' => 'Zeebrugge'),
      array('lat' => '51.2154', 'lng' => '2.9287', 'postal_code' => '8400', 'name' => 'Oostende'),
      array('lat' => '51.2027', 'lng' => '2.9147', 'postal_code' => '8400', 'name' => 'Stene'),
      array('lat' => '51.2500', 'lng' => '3.0381', 'postal_code' => '8420', 'name' => 'De Haan'),
      array('lat' => '51.2434', 'lng' => '3.0230', 'postal_code' => '8420', 'name' => 'Klemskerke'),
      array('lat' => '51.2976', 'lng' => '3.0831', 'postal_code' => '8420', 'name' => 'Wenduine'),
      array('lat' => '51.2535', 'lng' => '3.0571', 'postal_code' => '8421', 'name' => 'Vlissegem'),
      array('lat' => '51.1799', 'lng' => '2.8060', 'postal_code' => '8430', 'name' => 'Middelkerke'),
      array('lat' => '51.1796', 'lng' => '2.8259', 'postal_code' => '8431', 'name' => 'Wilskerke'),
      array('lat' => '51.1757', 'lng' => '2.8771', 'postal_code' => '8432', 'name' => 'Leffinge'),
      array('lat' => '51.1259', 'lng' => '2.8182', 'postal_code' => '8433', 'name' => 'Mannekensvere'),
      array('lat' => '51.1117', 'lng' => '2.8392', 'postal_code' => '8433', 'name' => 'Schore'),
      array('lat' => '51.1262', 'lng' => '2.8759', 'postal_code' => '8433', 'name' => 'Sint-Pieters-Kapelle'),
      array('lat' => '51.1553', 'lng' => '2.8472', 'postal_code' => '8433', 'name' => 'Slijpe'),
      array('lat' => '51.1478', 'lng' => '2.7566', 'postal_code' => '8434', 'name' => 'Lombardsijde'),
      array('lat' => '51.1595', 'lng' => '2.7690', 'postal_code' => '8434', 'name' => 'Westende'),
      array('lat' => '51.2345', 'lng' => '2.9728', 'postal_code' => '8450', 'name' => 'Bredene'),
      array('lat' => '51.1796', 'lng' => '3.0302', 'postal_code' => '8460', 'name' => 'Ettelgem'),
      array('lat' => '51.1837', 'lng' => '3.0069', 'postal_code' => '8460', 'name' => 'Oudenburg'),
      array('lat' => '51.1675', 'lng' => '3.0276', 'postal_code' => '8460', 'name' => 'Roksem'),
      array('lat' => '51.1645', 'lng' => '3.0155', 'postal_code' => '8460', 'name' => 'Westkerke'),
      array('lat' => '51.1563', 'lng' => '2.9676', 'postal_code' => '8470', 'name' => 'Gistel'),
      array('lat' => '51.1226', 'lng' => '2.9559', 'postal_code' => '8470', 'name' => 'Moere'),
      array('lat' => '51.1776', 'lng' => '2.9391', 'postal_code' => '8470', 'name' => 'Snaaskerke'),
      array('lat' => '51.1375', 'lng' => '2.9200', 'postal_code' => '8470', 'name' => 'Zevekote'),
      array('lat' => '51.1597', 'lng' => '3.0454', 'postal_code' => '8480', 'name' => 'Bekegem'),
      array('lat' => '51.1295', 'lng' => '3.0274', 'postal_code' => '8480', 'name' => 'Eernegem'),
      array('lat' => '51.0929', 'lng' => '3.0106', 'postal_code' => '8480', 'name' => 'Ichtegem'),
      array('lat' => '51.1830', 'lng' => '3.0948', 'postal_code' => '8490', 'name' => 'Jabbeke'),
      array('lat' => '51.1690', 'lng' => '3.1231', 'postal_code' => '8490', 'name' => 'Snellegem'),
      array('lat' => '51.2140', 'lng' => '3.0722', 'postal_code' => '8490', 'name' => 'Stalhille'),
      array('lat' => '51.1892', 'lng' => '3.1421', 'postal_code' => '8490', 'name' => 'Varsenare'),
      array('lat' => '51.1665', 'lng' => '3.0693', 'postal_code' => '8490', 'name' => 'Zerkegem'),
      array('lat' => '50.8195', 'lng' => '3.2577', 'postal_code' => '8500', 'name' => 'Kortrijk'),
      array('lat' => '50.8241', 'lng' => '3.2281', 'postal_code' => '8501', 'name' => 'Bissegem'),
      array('lat' => '50.8432', 'lng' => '3.2347', 'postal_code' => '8501', 'name' => 'Heule'),
      array('lat' => '50.7766', 'lng' => '3.2784', 'postal_code' => '8510', 'name' => 'Bellegem'),
      array('lat' => '50.7397', 'lng' => '3.3313', 'postal_code' => '8510', 'name' => 'Kooigem'),
      array('lat' => '50.8070', 'lng' => '3.2336', 'postal_code' => '8510', 'name' => 'Marke'),
      array('lat' => '50.7660', 'lng' => '3.2634', 'postal_code' => '8510', 'name' => 'Rollegem'),
      array('lat' => '50.7784', 'lng' => '3.2299', 'postal_code' => '8511', 'name' => 'Aalbeke'),
      array('lat' => '50.8540', 'lng' => '3.2870', 'postal_code' => '8520', 'name' => 'Kuurne'),
      array('lat' => '50.8456', 'lng' => '3.3121', 'postal_code' => '8530', 'name' => 'Harelbeke'),
      array('lat' => '50.8755', 'lng' => '3.3112', 'postal_code' => '8531', 'name' => 'Bavikhove'),
      array('lat' => '50.8804', 'lng' => '3.2982', 'postal_code' => '8531', 'name' => 'Hulste'),
      array('lat' => '50.8537', 'lng' => '3.3534', 'postal_code' => '8540', 'name' => 'Deerlijk'),
      array('lat' => '50.8080', 'lng' => '3.3505', 'postal_code' => '8550', 'name' => 'Zwevegem'),
      array('lat' => '50.7826', 'lng' => '3.4104', 'postal_code' => '8551', 'name' => 'Heestert'),
      array('lat' => '50.7700', 'lng' => '3.3974', 'postal_code' => '8552', 'name' => 'Moen'),
      array('lat' => '50.8082', 'lng' => '3.4240', 'postal_code' => '8553', 'name' => 'Otegem'),
      array('lat' => '50.7531', 'lng' => '3.3653', 'postal_code' => '8554', 'name' => 'Sint-Denijs'),
      array('lat' => '50.8448', 'lng' => '3.1990', 'postal_code' => '8560', 'name' => 'Gullegem'),
      array('lat' => '50.8406', 'lng' => '3.1646', 'postal_code' => '8560', 'name' => 'Moorsele'),
      array('lat' => '50.8089', 'lng' => '3.1836', 'postal_code' => '8560', 'name' => 'Wevelgem'),
      array('lat' => '50.8335', 'lng' => '3.4789', 'postal_code' => '8570', 'name' => 'Anzegem'),
      array('lat' => '50.8285', 'lng' => '3.5058', 'postal_code' => '8570', 'name' => 'Gijzelbrechtegem'),
      array('lat' => '50.8174', 'lng' => '3.4342', 'postal_code' => '8570', 'name' => 'Ingooigem'),
      array('lat' => '50.8379', 'lng' => '3.4030', 'postal_code' => '8570', 'name' => 'Vichte'),
      array('lat' => '50.8132', 'lng' => '3.4938', 'postal_code' => '8572', 'name' => 'Kaster'),
      array('lat' => '50.8086', 'lng' => '3.4753', 'postal_code' => '8573', 'name' => 'Tiegem'),
      array('lat' => '50.7791', 'lng' => '3.4512', 'postal_code' => '8580', 'name' => 'Avelgem'),
      array('lat' => '50.7984', 'lng' => '3.5006', 'postal_code' => '8581', 'name' => 'Kerkhove'),
      array('lat' => '50.7909', 'lng' => '3.4855', 'postal_code' => '8581', 'name' => 'Waarmaarde'),
      array('lat' => '50.7560', 'lng' => '3.4293', 'postal_code' => '8582', 'name' => 'Outrijve'),
      array('lat' => '50.7481', 'lng' => '3.4073', 'postal_code' => '8583', 'name' => 'Bossuit'),
      array('lat' => '50.7322', 'lng' => '3.3811', 'postal_code' => '8587', 'name' => 'Helkijn'),
      array('lat' => '50.7185', 'lng' => '3.3554', 'postal_code' => '8587', 'name' => 'Spiere'),
      array('lat' => '50.7298', 'lng' => '3.3595', 'postal_code' => '8587', 'name' => 'Spiere-Helkijn'),
      array('lat' => '51.0589', 'lng' => '2.8869', 'postal_code' => '8600', 'name' => 'Beerst'),
      array('lat' => '51.0333', 'lng' => '2.8658', 'postal_code' => '8600', 'name' => 'Diksmuide'),
      array('lat' => '50.7063', 'lng' => '3.9862', 'postal_code' => '8600', 'name' => 'Driekapellen'),
      array('lat' => '51.0294', 'lng' => '2.9021', 'postal_code' => '8600', 'name' => 'Esen'),
      array('lat' => '51.0358', 'lng' => '2.8365', 'postal_code' => '8600', 'name' => 'Kaaskerke'),
      array('lat' => '51.0807', 'lng' => '2.8822', 'postal_code' => '8600', 'name' => 'Keiem'),
      array('lat' => '51.0325', 'lng' => '2.7685', 'postal_code' => '8600', 'name' => 'Lampernisse'),
      array('lat' => '51.1004', 'lng' => '2.8904', 'postal_code' => '8600', 'name' => 'Leke'),
      array('lat' => '50.9994', 'lng' => '2.7999', 'postal_code' => '8600', 'name' => 'Nieuwkapelle'),
      array('lat' => '51.0464', 'lng' => '2.7973', 'postal_code' => '8600', 'name' => 'Oostkerke'),
      array('lat' => '51.0135', 'lng' => '2.8080', 'postal_code' => '8600', 'name' => 'Oudekapelle'),
      array('lat' => '51.0733', 'lng' => '2.7941', 'postal_code' => '8600', 'name' => 'Pervijze'),
      array('lat' => '51.0164', 'lng' => '2.8339', 'postal_code' => '8600', 'name' => 'Sint-Jacobs-Kapelle'),
      array('lat' => '51.0768', 'lng' => '2.8251', 'postal_code' => '8600', 'name' => 'Stuivekenskerke'),
      array('lat' => '51.0464', 'lng' => '2.9163', 'postal_code' => '8600', 'name' => 'Vladslo'),
      array('lat' => '50.9984', 'lng' => '2.8698', 'postal_code' => '8600', 'name' => 'Woumen'),
      array('lat' => '51.0257', 'lng' => '3.0031', 'postal_code' => '8610', 'name' => 'Handzame'),
      array('lat' => '51.0284', 'lng' => '3.0441', 'postal_code' => '8610', 'name' => 'Kortemark'),
      array('lat' => '51.0291', 'lng' => '2.9647', 'postal_code' => '8610', 'name' => 'Werken'),
      array('lat' => '51.0184', 'lng' => '2.9589', 'postal_code' => '8610', 'name' => 'Zarren'),
      array('lat' => '51.1285', 'lng' => '2.7480', 'postal_code' => '8620', 'name' => 'Nieuwpoort'),
      array('lat' => '51.1095', 'lng' => '2.7620', 'postal_code' => '8620', 'name' => 'Ramskapelle'),
      array('lat' => '51.0663', 'lng' => '2.7330', 'postal_code' => '8630', 'name' => 'Avekapelle'),
      array('lat' => '51.0869', 'lng' => '2.7333', 'postal_code' => '8630', 'name' => 'Booitshoeke'),
      array('lat' => '51.0414', 'lng' => '2.6500', 'postal_code' => '8630', 'name' => 'Bulskamp'),
      array('lat' => '51.0417', 'lng' => '2.6006', 'postal_code' => '8630', 'name' => 'De Moeren'),
      array('lat' => '51.0497', 'lng' => '2.7218', 'postal_code' => '8630', 'name' => 'Eggewaartskapelle'),
      array('lat' => '51.0105', 'lng' => '2.6097', 'postal_code' => '8630', 'name' => 'Houtem'),
      array('lat' => '51.0574', 'lng' => '2.6893', 'postal_code' => '8630', 'name' => 'Steenkerke'),
      array('lat' => '51.0732', 'lng' => '2.6680', 'postal_code' => '8630', 'name' => 'Veurne'),
      array('lat' => '51.0162', 'lng' => '2.6629', 'postal_code' => '8630', 'name' => 'Vinkem'),
      array('lat' => '51.0145', 'lng' => '2.6545', 'postal_code' => '8630', 'name' => 'Wulveringem'),
      array('lat' => '51.0486', 'lng' => '2.7508', 'postal_code' => '8630', 'name' => 'Zoutenaaie'),
      array('lat' => '50.9318', 'lng' => '2.7368', 'postal_code' => '8640', 'name' => 'Oostvleteren'),
      array('lat' => '50.9297', 'lng' => '2.7328', 'postal_code' => '8640', 'name' => 'Vleteren'),
      array('lat' => '50.9276', 'lng' => '2.7169', 'postal_code' => '8640', 'name' => 'Westvleteren'),
      array('lat' => '50.9007', 'lng' => '2.7891', 'postal_code' => '8640', 'name' => 'Woesten'),
      array('lat' => '50.9807', 'lng' => '2.7490', 'postal_code' => '8647', 'name' => 'Lo'),
      array('lat' => '50.9688', 'lng' => '2.7819', 'postal_code' => '8647', 'name' => 'Lo-Reninge'),
      array('lat' => '50.9546', 'lng' => '2.8105', 'postal_code' => '8647', 'name' => 'Noordschote'),
      array('lat' => '50.9711', 'lng' => '2.7323', 'postal_code' => '8647', 'name' => 'Pollinkhove'),
      array('lat' => '50.9733', 'lng' => '2.7716', 'postal_code' => '8647', 'name' => 'Reninge'),
      array('lat' => '50.9774', 'lng' => '2.9458', 'postal_code' => '8650', 'name' => 'Houthulst'),
      array('lat' => '50.9980', 'lng' => '2.9042', 'postal_code' => '8650', 'name' => 'Klerken'),
      array('lat' => '50.9528', 'lng' => '2.8524', 'postal_code' => '8650', 'name' => 'Merkem'),
      array('lat' => '51.0751', 'lng' => '2.6034', 'postal_code' => '8660', 'name' => 'Adinkerke'),
      array('lat' => '51.0963', 'lng' => '2.5906', 'postal_code' => '8660', 'name' => 'De Panne'),
      array('lat' => '51.1054', 'lng' => '2.6501', 'postal_code' => '8670', 'name' => 'Koksijde'),
      array('lat' => '51.1158', 'lng' => '2.6825', 'postal_code' => '8670', 'name' => 'Oostduinkerke'),
      array('lat' => '51.1008', 'lng' => '2.6992', 'postal_code' => '8670', 'name' => 'Wulpen'),
      array('lat' => '51.0545', 'lng' => '2.9627', 'postal_code' => '8680', 'name' => 'Bovekerke'),
      array('lat' => '51.0929', 'lng' => '2.9796', 'postal_code' => '8680', 'name' => 'Koekelare'),
      array('lat' => '51.1201', 'lng' => '2.9222', 'postal_code' => '8680', 'name' => 'Zande'),
      array('lat' => '51.0122', 'lng' => '2.7131', 'postal_code' => '8690', 'name' => 'Alveringem'),
      array('lat' => '50.9796', 'lng' => '2.6917', 'postal_code' => '8690', 'name' => 'Hoogstade'),
      array('lat' => '51.0230', 'lng' => '2.7052', 'postal_code' => '8690', 'name' => 'Oeren'),
      array('lat' => '50.9916', 'lng' => '2.6878', 'postal_code' => '8690', 'name' => 'Sint-Rijkers'),
      array('lat' => '50.9392', 'lng' => '2.6398', 'postal_code' => '8691', 'name' => 'Beveren-Aan-De-Ijzer'),
      array('lat' => '50.9761', 'lng' => '2.6726', 'postal_code' => '8691', 'name' => 'Gijverinkhove'),
      array('lat' => '50.9942', 'lng' => '2.6547', 'postal_code' => '8691', 'name' => 'Izenberge'),
      array('lat' => '50.9855', 'lng' => '2.6234', 'postal_code' => '8691', 'name' => 'Leisele'),
      array('lat' => '50.9386', 'lng' => '2.6699', 'postal_code' => '8691', 'name' => 'Stavele'),
      array('lat' => '50.9969', 'lng' => '3.4225', 'postal_code' => '8700', 'name' => 'Aarsele'),
      array('lat' => '51.0134', 'lng' => '3.4033', 'postal_code' => '8700', 'name' => 'Kanegem'),
      array('lat' => '51.0329', 'lng' => '3.3338', 'postal_code' => '8700', 'name' => 'Schuiferskapelle'),
      array('lat' => '51.0002', 'lng' => '3.3264', 'postal_code' => '8700', 'name' => 'Tielt'),
      array('lat' => '50.8934', 'lng' => '3.3365', 'postal_code' => '8710', 'name' => 'Ooigem'),
      array('lat' => '50.9104', 'lng' => '3.3908', 'postal_code' => '8710', 'name' => 'Sint-Baafs-Vijve'),
      array('lat' => '50.9100', 'lng' => '3.3725', 'postal_code' => '8710', 'name' => 'Wielsbeke'),
      array('lat' => '50.9636', 'lng' => '3.4186', 'postal_code' => '8720', 'name' => 'Dentergem'),
      array('lat' => '50.9459', 'lng' => '3.4026', 'postal_code' => '8720', 'name' => 'Markegem'),
      array('lat' => '50.9351', 'lng' => '3.4319', 'postal_code' => '8720', 'name' => 'Oeselgem'),
      array('lat' => '50.9306', 'lng' => '3.3980', 'postal_code' => '8720', 'name' => 'Wakken'),
      array('lat' => '51.1425', 'lng' => '3.3410', 'postal_code' => '8730', 'name' => 'Beernem'),
      array('lat' => '51.1686', 'lng' => '3.3397', 'postal_code' => '8730', 'name' => 'Oedelem'),
      array('lat' => '51.1276', 'lng' => '3.3684', 'postal_code' => '8730', 'name' => 'Sint-Joris'),
      array('lat' => '51.0148', 'lng' => '3.2590', 'postal_code' => '8740', 'name' => 'Egem'),
      array('lat' => '50.9943', 'lng' => '3.2667', 'postal_code' => '8740', 'name' => 'Pittem'),
      array('lat' => '51.0587', 'lng' => '3.2748', 'postal_code' => '8750', 'name' => 'Wingene'),
      array('lat' => '51.0361', 'lng' => '3.2105', 'postal_code' => '8750', 'name' => 'Zwevezele'),
      array('lat' => '51.0413', 'lng' => '3.3971', 'postal_code' => '8755', 'name' => 'Ruiselede'),
      array('lat' => '50.9506', 'lng' => '3.2864', 'postal_code' => '8760', 'name' => 'Meulebeke'),
      array('lat' => '50.9233', 'lng' => '3.2628', 'postal_code' => '8770', 'name' => 'Ingelmunster'),
      array('lat' => '50.9202', 'lng' => '3.3346', 'postal_code' => '8780', 'name' => 'Oostrozebeke'),
      array('lat' => '50.8870', 'lng' => '3.4231', 'postal_code' => '8790', 'name' => 'Waregem'),
      array('lat' => '50.8869', 'lng' => '3.3494', 'postal_code' => '8792', 'name' => 'Desselgem'),
      array('lat' => '50.9035', 'lng' => '3.4099', 'postal_code' => '8793', 'name' => 'Sint-Eloois-Vijve'),
      array('lat' => '50.9685', 'lng' => '3.1443', 'postal_code' => '8800', 'name' => 'Beveren'),
      array('lat' => '50.9203', 'lng' => '3.1610', 'postal_code' => '8800', 'name' => 'Oekene'),
      array('lat' => '50.9499', 'lng' => '3.1294', 'postal_code' => '8800', 'name' => 'Roeselare'),
      array('lat' => '50.9332', 'lng' => '3.1560', 'postal_code' => '8800', 'name' => 'Rumbeke'),
      array('lat' => '51.0277', 'lng' => '3.1439', 'postal_code' => '8810', 'name' => 'Lichtervelde'),
      array('lat' => '51.0650', 'lng' => '3.1016', 'postal_code' => '8820', 'name' => 'Torhout'),
      array('lat' => '50.9970', 'lng' => '3.1000', 'postal_code' => '8830', 'name' => 'Gits'),
      array('lat' => '50.9785', 'lng' => '3.0815', 'postal_code' => '8830', 'name' => 'Hooglede'),
      array('lat' => '50.9424', 'lng' => '3.0643', 'postal_code' => '8840', 'name' => 'Oostnieuwkerke'),
      array('lat' => '50.9746', 'lng' => '3.0145', 'postal_code' => '8840', 'name' => 'Staden'),
      array('lat' => '50.9319', 'lng' => '3.0123', 'postal_code' => '8840', 'name' => 'Westrozebeke'),
      array('lat' => '50.9791', 'lng' => '3.1988', 'postal_code' => '8850', 'name' => 'Ardooie'),
      array('lat' => '51.0019', 'lng' => '3.2118', 'postal_code' => '8851', 'name' => 'Koolskamp'),
      array('lat' => '50.8863', 'lng' => '3.2382', 'postal_code' => '8860', 'name' => 'Lendelede'),
      array('lat' => '50.9272', 'lng' => '3.2179', 'postal_code' => '8870', 'name' => 'Emelgem'),
      array('lat' => '50.9181', 'lng' => '3.2132', 'postal_code' => '8870', 'name' => 'Izegem'),
      array('lat' => '50.9319', 'lng' => '3.1924', 'postal_code' => '8870', 'name' => 'Kachtem'),
      array('lat' => '50.8550', 'lng' => '3.1275', 'postal_code' => '8880', 'name' => 'Ledegem'),
      array('lat' => '50.8683', 'lng' => '3.1450', 'postal_code' => '8880', 'name' => 'Rollegem-Kapelle'),
      array('lat' => '50.8763', 'lng' => '3.1824', 'postal_code' => '8880', 'name' => 'Sint-Eloois-Winkel'),
      array('lat' => '50.8516', 'lng' => '3.0945', 'postal_code' => '8890', 'name' => 'Dadizele'),
      array('lat' => '50.8911', 'lng' => '3.0632', 'postal_code' => '8890', 'name' => 'Moorslede'),
      array('lat' => '50.8674', 'lng' => '2.8501', 'postal_code' => '8900', 'name' => 'Brielen'),
      array('lat' => '50.8206', 'lng' => '2.8319', 'postal_code' => '8900', 'name' => 'Dikkebus'),
      array('lat' => '50.8492', 'lng' => '2.8779', 'postal_code' => '8900', 'name' => 'Ieper'),
      array('lat' => '50.8669', 'lng' => '2.9021', 'postal_code' => '8900', 'name' => 'Sint-Jan'),
      array('lat' => '50.8054', 'lng' => '2.9372', 'postal_code' => '8902', 'name' => 'Hollebeke'),
      array('lat' => '50.8166', 'lng' => '2.8758', 'postal_code' => '8902', 'name' => 'Voormezele'),
      array('lat' => '50.8345', 'lng' => '2.9225', 'postal_code' => '8902', 'name' => 'Zillebeke'),
      array('lat' => '50.8967', 'lng' => '2.8548', 'postal_code' => '8904', 'name' => 'Boezinge'),
      array('lat' => '50.9130', 'lng' => '2.8295', 'postal_code' => '8904', 'name' => 'Zuidschote'),
      array('lat' => '50.9249', 'lng' => '4.7862', 'postal_code' => '3220', 'name' => 'Holsbeek'),
      array('lat' => '50.9267', 'lng' => '4.8055', 'postal_code' => '3220', 'name' => 'Kortrijk-Dutsel'),
      array('lat' => '50.9324', 'lng' => '4.8206', 'postal_code' => '3220', 'name' => 'Sint-Pieters-Rode'),
      array('lat' => '50.9496', 'lng' => '4.8334', 'postal_code' => '3221', 'name' => 'Nieuwrode'),
      array('lat' => '50.8859', 'lng' => '2.8175', 'postal_code' => '8906', 'name' => 'Elverdinge'),
      array('lat' => '50.8537', 'lng' => '2.8243', 'postal_code' => '8908', 'name' => 'Vlamertinge'),
      array('lat' => '50.9258', 'lng' => '2.8647', 'postal_code' => '8920', 'name' => 'Bikschote'),
      array('lat' => '50.9136', 'lng' => '2.9200', 'postal_code' => '8920', 'name' => 'Langemark'),
      array('lat' => '50.9136', 'lng' => '2.9200', 'postal_code' => '8920', 'name' => 'Langemark-Poelkapelle'),
      array('lat' => '50.9177', 'lng' => '2.9566', 'postal_code' => '8920', 'name' => 'Poelkapelle'),
      array('lat' => '50.7946', 'lng' => '3.1850', 'postal_code' => '8930', 'name' => 'Lauwe'),
      array('lat' => '50.7962', 'lng' => '3.1214', 'postal_code' => '8930', 'name' => 'Menen'),
      array('lat' => '50.7828', 'lng' => '3.1641', 'postal_code' => '8930', 'name' => 'Rekkem'),
      array('lat' => '50.8100', 'lng' => '3.0767', 'postal_code' => '8940', 'name' => 'Geluwe'),
      array('lat' => '50.7841', 'lng' => '3.0449', 'postal_code' => '8940', 'name' => 'Wervik'),
      array('lat' => '50.7335', 'lng' => '2.8251', 'postal_code' => '8950', 'name' => 'Heuvelland'),
      array('lat' => '50.7461', 'lng' => '2.8253', 'postal_code' => '8950', 'name' => 'Nieuwkerke'),
      array('lat' => '50.7659', 'lng' => '2.7830', 'postal_code' => '8951', 'name' => 'Dranouter'),
      array('lat' => '50.7602', 'lng' => '2.8524', 'postal_code' => '8952', 'name' => 'Wulvergem'),
      array('lat' => '50.7859', 'lng' => '2.8831', 'postal_code' => '8953', 'name' => 'Wijtschate'),
      array('lat' => '50.7971', 'lng' => '2.7464', 'postal_code' => '8954', 'name' => 'Westouter'),
      array('lat' => '50.7833', 'lng' => '2.8286', 'postal_code' => '8956', 'name' => 'Kemmel'),
      array('lat' => '50.7639', 'lng' => '2.8977', 'postal_code' => '8957', 'name' => 'Mesen'),
      array('lat' => '50.7817', 'lng' => '2.7721', 'postal_code' => '8958', 'name' => 'Loker'),
      array('lat' => '50.8452', 'lng' => '2.7212', 'postal_code' => '8970', 'name' => 'Poperinge'),
      array('lat' => '50.8171', 'lng' => '2.7634', 'postal_code' => '8970', 'name' => 'Reningelst'),
      array('lat' => '50.9149', 'lng' => '2.6886', 'postal_code' => '8972', 'name' => 'Krombeke'),
      array('lat' => '50.8905', 'lng' => '2.6560', 'postal_code' => '8972', 'name' => 'Proven'),
      array('lat' => '50.9189', 'lng' => '2.6248', 'postal_code' => '8972', 'name' => 'Roesbrugge-Haringe'),
      array('lat' => '50.8588', 'lng' => '2.6206', 'postal_code' => '8978', 'name' => 'Watou'),
      array('lat' => '50.8479', 'lng' => '3.0247', 'postal_code' => '8980', 'name' => 'Beselare'),
      array('lat' => '50.8338', 'lng' => '2.9939', 'postal_code' => '8980', 'name' => 'Geluveld'),
      array('lat' => '50.9003', 'lng' => '3.0207', 'postal_code' => '8980', 'name' => 'Passendale'),
      array('lat' => '50.8123', 'lng' => '2.9817', 'postal_code' => '8980', 'name' => 'Zandvoorde'),
      array('lat' => '50.8727', 'lng' => '2.9875', 'postal_code' => '8980', 'name' => 'Zonnebeke'),
    ],
    'VOV' => [
      array('lat' => '51.0678', 'lng' => '3.7291', 'postal_code' => '9000', 'name' => 'Gent'),
      array('lat' => '51.0736', 'lng' => '3.6806', 'postal_code' => '9030', 'name' => 'Mariakerke'),
      array('lat' => '51.0505', 'lng' => '3.6633', 'postal_code' => '9031', 'name' => 'Drongen'),
      array('lat' => '51.0905', 'lng' => '3.7161', 'postal_code' => '9032', 'name' => 'Wondelgem'),
      array('lat' => '51.0593', 'lng' => '3.7510', 'postal_code' => '9040', 'name' => 'Sint-Amandsberg'),
      array('lat' => '51.0997', 'lng' => '3.7642', 'postal_code' => '9041', 'name' => 'Oostakker'),
      array('lat' => '51.1221', 'lng' => '3.7826', 'postal_code' => '9042', 'name' => 'Desteldonk'),
      array('lat' => '51.1448', 'lng' => '3.8193', 'postal_code' => '9042', 'name' => 'Mendonk'),
      array('lat' => '51.1558', 'lng' => '3.8158', 'postal_code' => '9042', 'name' => 'Sint-Kruis-Winkel'),
      array('lat' => '51.0343', 'lng' => '3.7640', 'postal_code' => '9050', 'name' => 'Gentbrugge'),
      array('lat' => '51.0372', 'lng' => '3.7412', 'postal_code' => '9050', 'name' => 'Ledeberg'),
      array('lat' => '51.0306', 'lng' => '3.6662', 'postal_code' => '9051', 'name' => 'Afsnee'),
      array('lat' => '51.0201', 'lng' => '3.6696', 'postal_code' => '9051', 'name' => 'Sint-Denijs-Westrem'),
      array('lat' => '50.9998', 'lng' => '3.7106', 'postal_code' => '9052', 'name' => 'Zwijnaarde'),
      array('lat' => '51.1987', 'lng' => '3.8120', 'postal_code' => '9060', 'name' => 'Zelzate'),
      array('lat' => '51.0609', 'lng' => '3.7978', 'postal_code' => '9070', 'name' => 'Destelbergen'),
      array('lat' => '51.0328', 'lng' => '3.8037', 'postal_code' => '9070', 'name' => 'Heusden'),
      array('lat' => '51.0801', 'lng' => '3.8806', 'postal_code' => '9080', 'name' => 'Beervelde'),
      array('lat' => '51.0975', 'lng' => '3.8378', 'postal_code' => '9080', 'name' => 'Lochristi'),
      array('lat' => '51.1325', 'lng' => '3.8618', 'postal_code' => '9080', 'name' => 'Zaffelare'),
      array('lat' => '51.1075', 'lng' => '3.8989', 'postal_code' => '9080', 'name' => 'Zeveneken'),
      array('lat' => '50.9835', 'lng' => '3.7973', 'postal_code' => '9090', 'name' => 'Gontrode'),
      array('lat' => '51.0037', 'lng' => '3.8003', 'postal_code' => '9090', 'name' => 'Melle'),
      array('lat' => '51.1935', 'lng' => '4.1775', 'postal_code' => '9100', 'name' => 'Nieuwkerken-Waas'),
      array('lat' => '51.1559', 'lng' => '4.1544', 'postal_code' => '9100', 'name' => 'Sint-Niklaas'),
      array('lat' => '51.1428', 'lng' => '4.0862', 'postal_code' => '9111', 'name' => 'Belsele'),
      array('lat' => '51.1563', 'lng' => '4.0444', 'postal_code' => '9112', 'name' => 'Sinaai-Waas'),
      array('lat' => '51.2175', 'lng' => '4.2521', 'postal_code' => '9120', 'name' => 'Beveren-Waas'),
      array('lat' => '51.1810', 'lng' => '4.2379', 'postal_code' => '9120', 'name' => 'Haasdonk'),
      array('lat' => '51.2225', 'lng' => '4.2822', 'postal_code' => '9120', 'name' => 'Melsele'),
      array('lat' => '51.2194', 'lng' => '4.1945', 'postal_code' => '9120', 'name' => 'Vrasene'),
      array('lat' => '51.3106', 'lng' => '4.2650', 'postal_code' => '9130', 'name' => 'Doel'),
      array('lat' => '51.2531', 'lng' => '4.2567', 'postal_code' => '9130', 'name' => 'Kallo'),
      array('lat' => '51.2894', 'lng' => '4.1755', 'postal_code' => '9130', 'name' => 'Kieldrecht'),
      array('lat' => '51.2556', 'lng' => '4.1888', 'postal_code' => '9130', 'name' => 'Verrebroek'),
      array('lat' => '51.1145', 'lng' => '4.1433', 'postal_code' => '9140', 'name' => 'Elversele'),
      array('lat' => '51.1258', 'lng' => '4.2706', 'postal_code' => '9140', 'name' => 'Steendorp'),
      array('lat' => '51.1296', 'lng' => '4.2128', 'postal_code' => '9140', 'name' => 'Temse'),
      array('lat' => '51.1148', 'lng' => '4.1640', 'postal_code' => '9140', 'name' => 'Tielrode'),
      array('lat' => '51.1475', 'lng' => '4.2984', 'postal_code' => '9150', 'name' => 'Bazel'),
      array('lat' => '51.1706', 'lng' => '4.3123', 'postal_code' => '9150', 'name' => 'Kruibeke'),
      array('lat' => '51.1274', 'lng' => '4.2903', 'postal_code' => '9150', 'name' => 'Rupelmonde'),
      array('lat' => '51.1278', 'lng' => '3.9874', 'postal_code' => '9160', 'name' => 'Daknam'),
      array('lat' => '51.1472', 'lng' => '3.9586', 'postal_code' => '9160', 'name' => 'Eksaarde'),
      array('lat' => '51.1024', 'lng' => '3.9941', 'postal_code' => '9160', 'name' => 'Lokeren'),
      array('lat' => '51.2562', 'lng' => '4.0900', 'postal_code' => '9170', 'name' => 'De Klinge'),
      array('lat' => '51.2607', 'lng' => '4.1460', 'postal_code' => '9170', 'name' => 'Meerdonk'),
      array('lat' => '51.2199', 'lng' => '4.1243', 'postal_code' => '9170', 'name' => 'Sint-Gillis-Waas'),
      array('lat' => '51.1933', 'lng' => '4.0977', 'postal_code' => '9170', 'name' => 'Sint-Pauwels'),
      array('lat' => '51.1735', 'lng' => '3.9343', 'postal_code' => '9180', 'name' => 'Moerbeke-Waas'),
      array('lat' => '51.1710', 'lng' => '3.8606', 'postal_code' => '9185', 'name' => 'Wachtebeke'),
      array('lat' => '51.2062', 'lng' => '4.0757', 'postal_code' => '9190', 'name' => 'Kemzeke'),
      array('lat' => '51.2064', 'lng' => '4.0409', 'postal_code' => '9190', 'name' => 'Stekene'),
      array('lat' => '51.0293', 'lng' => '4.0541', 'postal_code' => '9200', 'name' => 'Appels'),
      array('lat' => '51.0378', 'lng' => '4.1577', 'postal_code' => '9200', 'name' => 'Baasrode'),
      array('lat' => '51.0255', 'lng' => '4.1020', 'postal_code' => '9200', 'name' => 'Dendermonde'),
      array('lat' => '51.0551', 'lng' => '4.1057', 'postal_code' => '9200', 'name' => 'Grembergen'),
      array('lat' => '50.9961', 'lng' => '4.0692', 'postal_code' => '9200', 'name' => 'Mespelare'),
      array('lat' => '51.0091', 'lng' => '4.0612', 'postal_code' => '9200', 'name' => 'Oudegem'),
      array('lat' => '51.0035', 'lng' => '4.0151', 'postal_code' => '9200', 'name' => 'Schoonaarde'),
      array('lat' => '51.0216', 'lng' => '4.1080', 'postal_code' => '9200', 'name' => 'Sint-Gillis-Dendermonde'),
      array('lat' => '51.0902', 'lng' => '4.1403', 'postal_code' => '9220', 'name' => 'Hamme'),
      array('lat' => '51.0667', 'lng' => '4.1557', 'postal_code' => '9220', 'name' => 'Moerzeke'),
      array('lat' => '50.9809', 'lng' => '3.8735', 'postal_code' => '9230', 'name' => 'Massemen'),
      array('lat' => '50.9698', 'lng' => '3.8614', 'postal_code' => '9230', 'name' => 'Westrem'),
      array('lat' => '51.0029', 'lng' => '3.8896', 'postal_code' => '9230', 'name' => 'Wetteren'),
      array('lat' => '51.0701', 'lng' => '4.0403', 'postal_code' => '9240', 'name' => 'Zele'),
      array('lat' => '51.1095', 'lng' => '4.0845', 'postal_code' => '9250', 'name' => 'Waasmunster'),
      array('lat' => '51.0137', 'lng' => '4.2011', 'postal_code' => '9255', 'name' => 'Buggenhout'),
      array('lat' => '51.0281', 'lng' => '4.2192', 'postal_code' => '9255', 'name' => 'Opdorp'),
      array('lat' => '51.0115', 'lng' => '3.9288', 'postal_code' => '9260', 'name' => 'Schellebelle'),
      array('lat' => '50.9908', 'lng' => '3.9221', 'postal_code' => '9260', 'name' => 'Serskamp'),
      array('lat' => '51.0048', 'lng' => '3.9736', 'postal_code' => '9260', 'name' => 'Wichelen'),
      array('lat' => '51.0383', 'lng' => '3.9184', 'postal_code' => '9270', 'name' => 'Kalken'),
      array('lat' => '51.0304', 'lng' => '3.8536', 'postal_code' => '9270', 'name' => 'Laarne'),
      array('lat' => '51.0010', 'lng' => '4.0907', 'postal_code' => '9280', 'name' => 'Denderbelle'),
      array('lat' => '51.0006', 'lng' => '4.1292', 'postal_code' => '9280', 'name' => 'Lebbeke'),
      array('lat' => '50.9786', 'lng' => '4.0837', 'postal_code' => '9280', 'name' => 'Wieze'),
      array('lat' => '51.0174', 'lng' => '4.0058', 'postal_code' => '9290', 'name' => 'Berlare'),
      array('lat' => '51.0466', 'lng' => '3.9466', 'postal_code' => '9290', 'name' => 'Overmere'),
      array('lat' => '51.0225', 'lng' => '3.9542', 'postal_code' => '9290', 'name' => 'Uitbergen'),
      array('lat' => '50.9378', 'lng' => '4.0409', 'postal_code' => '9300', 'name' => 'Aalst'),
      array('lat' => '50.9838', 'lng' => '4.0511', 'postal_code' => '9308', 'name' => 'Gijzegem'),
      array('lat' => '50.9608', 'lng' => '4.0318', 'postal_code' => '9308', 'name' => 'Hofstade'),
      array('lat' => '50.9550', 'lng' => '4.1416', 'postal_code' => '9310', 'name' => 'Baardegem'),
      array('lat' => '50.9701', 'lng' => '4.0659', 'postal_code' => '9310', 'name' => 'Herdersem'),
      array('lat' => '50.9343', 'lng' => '4.1354', 'postal_code' => '9310', 'name' => 'Meldert'),
      array('lat' => '50.9478', 'lng' => '4.0984', 'postal_code' => '9310', 'name' => 'Moorsel'),
      array('lat' => '50.9206', 'lng' => '4.0609', 'postal_code' => '9320', 'name' => 'Erembodegem'),
      array('lat' => '50.9234', 'lng' => '4.0047', 'postal_code' => '9320', 'name' => 'Nieuwerkerken'),
      array('lat' => '50.9604', 'lng' => '3.9499', 'postal_code' => '9340', 'name' => 'Impe'),
      array('lat' => '50.9659', 'lng' => '3.9773', 'postal_code' => '9340', 'name' => 'Lede'),
      array('lat' => '50.9565', 'lng' => '3.9029', 'postal_code' => '9340', 'name' => 'Oordegem'),
      array('lat' => '50.9660', 'lng' => '3.9277', 'postal_code' => '9340', 'name' => 'Smetlede'),
      array('lat' => '50.9741', 'lng' => '3.9558', 'postal_code' => '9340', 'name' => 'Wanzele'),
      array('lat' => '50.8188', 'lng' => '3.9670', 'postal_code' => '9400', 'name' => 'Appelterre-Eichem'),
      array('lat' => '50.7981', 'lng' => '4.0247', 'postal_code' => '9400', 'name' => 'Denderwindeke'),
      array('lat' => '50.7919', 'lng' => '4.0526', 'postal_code' => '9400', 'name' => 'Lieferinge'),
      array('lat' => '50.8469', 'lng' => '3.9751', 'postal_code' => '9400', 'name' => 'Nederhasselt'),
      array('lat' => '50.8336', 'lng' => '4.0188', 'postal_code' => '9400', 'name' => 'Ninove'),
      array('lat' => '50.8555', 'lng' => '4.0555', 'postal_code' => '9400', 'name' => 'Okegem'),
      array('lat' => '50.8246', 'lng' => '3.9449', 'postal_code' => '9400', 'name' => 'Voorde'),
      array('lat' => '50.8172', 'lng' => '4.0069', 'postal_code' => '9401', 'name' => 'Pollare'),
      array('lat' => '50.8238', 'lng' => '4.0407', 'postal_code' => '9402', 'name' => 'Meerbeke'),
      array('lat' => '50.8034', 'lng' => '4.0618', 'postal_code' => '9403', 'name' => 'Neigem'),
      array('lat' => '50.8433', 'lng' => '3.9575', 'postal_code' => '9404', 'name' => 'Aspelare'),
      array('lat' => '50.8416', 'lng' => '3.9993', 'postal_code' => '9406', 'name' => 'Outer'),
      array('lat' => '50.8892', 'lng' => '3.9372', 'postal_code' => '9420', 'name' => 'Aaigem'),
      array('lat' => '50.9219', 'lng' => '3.9288', 'postal_code' => '9420', 'name' => 'Bambrugge'),
      array('lat' => '50.9134', 'lng' => '3.9203', 'postal_code' => '9420', 'name' => 'Burst'),
      array('lat' => '50.9408', 'lng' => '3.9554', 'postal_code' => '9420', 'name' => 'Erondegem'),
      array('lat' => '50.9338', 'lng' => '3.9769', 'postal_code' => '9420', 'name' => 'Erpe'),
      array('lat' => '50.9141', 'lng' => '3.9568', 'postal_code' => '9420', 'name' => 'Erpe-Mere'),
      array('lat' => '50.9224', 'lng' => '3.9681', 'postal_code' => '9420', 'name' => 'Mere'),
      array('lat' => '50.9338', 'lng' => '3.9446', 'postal_code' => '9420', 'name' => 'Ottergem'),
      array('lat' => '50.9364', 'lng' => '3.9316', 'postal_code' => '9420', 'name' => 'Vlekkem'),
      array('lat' => '50.8710', 'lng' => '4.0185', 'postal_code' => '9450', 'name' => 'Denderhoutem'),
      array('lat' => '50.9024', 'lng' => '4.0057', 'postal_code' => '9450', 'name' => 'Haaltert'),
      array('lat' => '50.8750', 'lng' => '3.9606', 'postal_code' => '9450', 'name' => 'Heldergem'),
      array('lat' => '50.8903', 'lng' => '3.9921', 'postal_code' => '9451', 'name' => 'Kerksken'),
      array('lat' => '50.8841', 'lng' => '4.0708', 'postal_code' => '9470', 'name' => 'Denderleeuw'),
      array('lat' => '50.8745', 'lng' => '4.0488', 'postal_code' => '9472', 'name' => 'Iddergem'),
      array('lat' => '50.8990', 'lng' => '4.0556', 'postal_code' => '9473', 'name' => 'Welle'),
      array('lat' => '50.7706', 'lng' => '3.8871', 'postal_code' => '9500', 'name' => 'Geraardsbergen'),
      array('lat' => '50.7674', 'lng' => '3.8415', 'postal_code' => '9500', 'name' => 'Goeferdinge'),
      array('lat' => '50.7524', 'lng' => '3.9179', 'postal_code' => '9500', 'name' => 'Moerbeke'),
      array('lat' => '50.7707', 'lng' => '3.8631', 'postal_code' => '9500', 'name' => 'Nederboelare'),
      array('lat' => '50.7855', 'lng' => '3.9165', 'postal_code' => '9500', 'name' => 'Onkerzele'),
      array('lat' => '50.8212', 'lng' => '3.8913', 'postal_code' => '9500', 'name' => 'Ophasselt'),
      array('lat' => '50.7623', 'lng' => '3.8631', 'postal_code' => '9500', 'name' => 'Overboelare'),
      array('lat' => '50.7435', 'lng' => '3.9228', 'postal_code' => '9500', 'name' => 'Viane'),
      array('lat' => '50.7621', 'lng' => '3.8286', 'postal_code' => '9500', 'name' => 'Zarlardinge'),
      array('lat' => '50.7939', 'lng' => '3.9441', 'postal_code' => '9506', 'name' => 'Grimminge'),
      array('lat' => '50.8000', 'lng' => '3.9268', 'postal_code' => '9506', 'name' => 'Idegem'),
      array('lat' => '50.7876', 'lng' => '3.9866', 'postal_code' => '9506', 'name' => 'Nieuwenhove'),
      array('lat' => '50.7958', 'lng' => '3.8949', 'postal_code' => '9506', 'name' => 'Schendelbeke'),
      array('lat' => '50.8157', 'lng' => '3.9210', 'postal_code' => '9506', 'name' => 'Smeerebbe-Vloerzegem'),
      array('lat' => '50.7782', 'lng' => '3.9688', 'postal_code' => '9506', 'name' => 'Waarbeke'),
      array('lat' => '50.8027', 'lng' => '3.9663', 'postal_code' => '9506', 'name' => 'Zandbergen'),
      array('lat' => '50.9443', 'lng' => '3.8658', 'postal_code' => '9520', 'name' => 'Bavegem'),
      array('lat' => '50.9207', 'lng' => '3.8544', 'postal_code' => '9520', 'name' => 'Sint-Lievens-Houtem'),
      array('lat' => '50.9313', 'lng' => '3.8956', 'postal_code' => '9520', 'name' => 'Vlierzele'),
      array('lat' => '50.9262', 'lng' => '3.9088', 'postal_code' => '9520', 'name' => 'Zonnegem'),
      array('lat' => '50.9264', 'lng' => '3.8820', 'postal_code' => '9521', 'name' => 'Letterhoutem'),
      array('lat' => '50.8535', 'lng' => '3.8987', 'postal_code' => '9550', 'name' => 'Herzele'),
      array('lat' => '50.8956', 'lng' => '3.8542', 'postal_code' => '9550', 'name' => 'Hillegem'),
      array('lat' => '50.8502', 'lng' => '3.9253', 'postal_code' => '9550', 'name' => 'Sint-Antelinks'),
      array('lat' => '50.8571', 'lng' => '3.8856', 'postal_code' => '9550', 'name' => 'Sint-Lievens-Esse'),
      array('lat' => '50.8457', 'lng' => '3.8757', 'postal_code' => '9550', 'name' => 'Steenhuize-Wijnhuize'),
      array('lat' => '50.8729', 'lng' => '3.9158', 'postal_code' => '9550', 'name' => 'Woubrechtegem'),
      array('lat' => '50.8920', 'lng' => '3.9096', 'postal_code' => '9551', 'name' => 'Ressegem'),
      array('lat' => '50.9049', 'lng' => '3.8932', 'postal_code' => '9552', 'name' => 'Borsbeke'),
      array('lat' => '50.7873', 'lng' => '3.8397', 'postal_code' => '9570', 'name' => 'Deftinge'),
      array('lat' => '50.8191', 'lng' => '3.8382', 'postal_code' => '9570', 'name' => 'Lierde'),
      array('lat' => '50.8184', 'lng' => '3.8391', 'postal_code' => '9570', 'name' => 'Sint-Maria-Lierde'),
      array('lat' => '50.8070', 'lng' => '3.8569', 'postal_code' => '9571', 'name' => 'Hemelveerdegem'),
      array('lat' => '50.8047', 'lng' => '3.8227', 'postal_code' => '9572', 'name' => 'Sint-Martens-Lierde'),
      array('lat' => '50.7505', 'lng' => '3.6005', 'postal_code' => '9600', 'name' => 'Ronse'),
      array('lat' => '50.8904', 'lng' => '3.8103', 'postal_code' => '9620', 'name' => 'Elene'),
      array('lat' => '50.8534', 'lng' => '3.8187', 'postal_code' => '9620', 'name' => 'Erwetegem'),
      array('lat' => '50.8623', 'lng' => '3.8299', 'postal_code' => '9620', 'name' => 'Godveerdegem'),
      array('lat' => '50.8730', 'lng' => '3.8334', 'postal_code' => '9620', 'name' => 'Grotenberge'),
      array('lat' => '50.8881', 'lng' => '3.8303', 'postal_code' => '9620', 'name' => 'Leeuwergem'),
      array('lat' => '50.8990', 'lng' => '3.8370', 'postal_code' => '9620', 'name' => 'Oombergen'),
      array('lat' => '50.8535', 'lng' => '3.7862', 'postal_code' => '9620', 'name' => 'Sint-Goriks-Oudenhove'),
      array('lat' => '50.8680', 'lng' => '3.7876', 'postal_code' => '9620', 'name' => 'Strijpen'),
      array('lat' => '50.8856', 'lng' => '3.7809', 'postal_code' => '9620', 'name' => 'Velzeke-Ruddershove'),
      array('lat' => '50.8695', 'lng' => '3.8107', 'postal_code' => '9620', 'name' => 'Zottegem'),
      array('lat' => '50.9059', 'lng' => '3.7167', 'postal_code' => '9630', 'name' => 'Beerlegem'),
      array('lat' => '50.9041', 'lng' => '3.7421', 'postal_code' => '9630', 'name' => 'Dikkele'),
      array('lat' => '50.8895', 'lng' => '3.7484', 'postal_code' => '9630', 'name' => 'Hundelgem'),
      array('lat' => '50.9050', 'lng' => '3.6990', 'postal_code' => '9630', 'name' => 'Meilegem'),
      array('lat' => '50.8778', 'lng' => '3.7331', 'postal_code' => '9630', 'name' => 'Munkzwalm'),
      array('lat' => '50.8963', 'lng' => '3.7157', 'postal_code' => '9630', 'name' => 'Paulatem'),
      array('lat' => '50.8626', 'lng' => '3.7637', 'postal_code' => '9630', 'name' => 'Roborst'),
      array('lat' => '50.8497', 'lng' => '3.7528', 'postal_code' => '9630', 'name' => 'Rozebeke'),
      array('lat' => '50.8517', 'lng' => '3.7194', 'postal_code' => '9630', 'name' => 'Sint-Blasius-Boekel'),
      array('lat' => '50.8649', 'lng' => '3.7113', 'postal_code' => '9630', 'name' => 'Sint-Denijs-Boekel'),
      array('lat' => '50.8902', 'lng' => '3.7069', 'postal_code' => '9630', 'name' => 'Sint-Maria-Latem'),
      array('lat' => '50.8799', 'lng' => '3.7289', 'postal_code' => '9630', 'name' => 'Zwalm'),
      array('lat' => '50.8875', 'lng' => '3.6864', 'postal_code' => '9636', 'name' => 'Nederzwalm-Hermelgem'),
      array('lat' => '50.8028', 'lng' => '3.7638', 'postal_code' => '9660', 'name' => 'Brakel'),
      array('lat' => '50.8313', 'lng' => '3.7386', 'postal_code' => '9660', 'name' => 'Elst'),
      array('lat' => '50.7630', 'lng' => '3.8083', 'postal_code' => '9660', 'name' => 'Everbeek'),
      array('lat' => '50.8334', 'lng' => '3.7629', 'postal_code' => '9660', 'name' => 'Michelbeke'),
      array('lat' => '50.8031', 'lng' => '3.7522', 'postal_code' => '9660', 'name' => 'Nederbrakel'),
      array('lat' => '50.7970', 'lng' => '3.7570', 'postal_code' => '9660', 'name' => 'Opbrakel'),
      array('lat' => '50.8213', 'lng' => '3.7846', 'postal_code' => '9660', 'name' => 'Sint-Maria-Oudenhove'),
      array('lat' => '50.8188', 'lng' => '3.7181', 'postal_code' => '9660', 'name' => 'Zegelsem'),
      array('lat' => '50.7848', 'lng' => '3.7979', 'postal_code' => '9661', 'name' => 'Parike'),
      array('lat' => '50.8372', 'lng' => '3.6867', 'postal_code' => '9667', 'name' => 'Horebeke'),
      array('lat' => '50.8344', 'lng' => '3.6983', 'postal_code' => '9667', 'name' => 'Sint-Kornelis-Horebeke'),
      array('lat' => '50.8405', 'lng' => '3.6916', 'postal_code' => '9667', 'name' => 'Sint-Maria-Horebeke'),
      array('lat' => '50.8125', 'lng' => '3.6267', 'postal_code' => '9680', 'name' => 'Etikhove'),
      array('lat' => '50.8159', 'lng' => '3.6544', 'postal_code' => '9680', 'name' => 'Maarke-Kerkem'),
      array('lat' => '50.7992', 'lng' => '3.6442', 'postal_code' => '9680', 'name' => 'Maarkedal'),
      array('lat' => '50.7970', 'lng' => '3.5947', 'postal_code' => '9681', 'name' => 'Nukerke'),
      array('lat' => '50.8045', 'lng' => '3.6770', 'postal_code' => '9688', 'name' => 'Schorisse'),
      array('lat' => '50.7902', 'lng' => '3.5095', 'postal_code' => '9690', 'name' => 'Berchem'),
      array('lat' => '50.7784', 'lng' => '3.4936', 'postal_code' => '9690', 'name' => 'Kluisbergen'),
      array('lat' => '50.7767', 'lng' => '3.5254', 'postal_code' => '9690', 'name' => 'Kwaremont'),
      array('lat' => '50.7707', 'lng' => '3.4830', 'postal_code' => '9690', 'name' => 'Ruien'),
      array('lat' => '50.7890', 'lng' => '3.5709', 'postal_code' => '9690', 'name' => 'Zulzeke'),
      array('lat' => '50.8524', 'lng' => '3.5875', 'postal_code' => '9700', 'name' => 'Bevere'),
      array('lat' => '50.8302', 'lng' => '3.6287', 'postal_code' => '9700', 'name' => 'Edelare'),
      array('lat' => '50.8679', 'lng' => '3.6207', 'postal_code' => '9700', 'name' => 'Eine'),
      array('lat' => '50.8570', 'lng' => '3.6319', 'postal_code' => '9700', 'name' => 'Ename'),
      array('lat' => '50.8837', 'lng' => '3.6287', 'postal_code' => '9700', 'name' => 'Heurne'),
      array('lat' => '50.8329', 'lng' => '3.6018', 'postal_code' => '9700', 'name' => 'Leupegem'),
      array('lat' => '50.8425', 'lng' => '3.6636', 'postal_code' => '9700', 'name' => 'Mater'),
      array('lat' => '50.8138', 'lng' => '3.5643', 'postal_code' => '9700', 'name' => 'Melden'),
      array('lat' => '50.8912', 'lng' => '3.6031', 'postal_code' => '9700', 'name' => 'Mullem'),
      array('lat' => '50.8667', 'lng' => '3.6349', 'postal_code' => '9700', 'name' => 'Nederename'),
      array('lat' => '50.8469', 'lng' => '3.6014', 'postal_code' => '9700', 'name' => 'Oudenaarde'),
      array('lat' => '50.8394', 'lng' => '3.6428', 'postal_code' => '9700', 'name' => 'Volkegem'),
      array('lat' => '50.8784', 'lng' => '3.6555', 'postal_code' => '9700', 'name' => 'Welden'),
      array('lat' => '50.8993', 'lng' => '3.5897', 'postal_code' => '9750', 'name' => 'Huise'),
      array('lat' => '50.9116', 'lng' => '3.5992', 'postal_code' => '9750', 'name' => 'Ouwegem'),
      array('lat' => '50.9167', 'lng' => '3.5667', 'postal_code' => '9750,9770', 'name' => 'Kruisem'),
      array('lat' => '50.8851', 'lng' => '3.5106', 'postal_code' => '9771', 'name' => 'Nokere'),
      array('lat' => '50.8898', 'lng' => '3.5515', 'postal_code' => '9772', 'name' => 'Wannegem-Lede'),
      array('lat' => '50.8246', 'lng' => '3.5354', 'postal_code' => '9790', 'name' => 'Elsegem'),
      array('lat' => '50.8505', 'lng' => '3.5614', 'postal_code' => '9790', 'name' => 'Moregem'),
      array('lat' => '50.8699', 'lng' => '3.5511', 'postal_code' => '9790', 'name' => 'Ooike'),
      array('lat' => '50.8333', 'lng' => '3.5561', 'postal_code' => '9790', 'name' => 'Petegem-Aan-De-Schelde'),
      array('lat' => '50.8521', 'lng' => '3.5102', 'postal_code' => '9790', 'name' => 'Wortegem'),
      array('lat' => '50.8445', 'lng' => '3.5269', 'postal_code' => '9790', 'name' => 'Wortegem-Petegem'),
      array('lat' => '50.9838', 'lng' => '3.5604', 'postal_code' => '9800', 'name' => 'Astene'),
      array('lat' => '51.0109', 'lng' => '3.5784', 'postal_code' => '9800', 'name' => 'Bachte-Maria-Leerne'),
      array('lat' => '50.9833', 'lng' => '3.5272', 'postal_code' => '9800,9850', 'name' => 'Deinze'),
      array('lat' => '50.9650', 'lng' => '3.4613', 'postal_code' => '9800', 'name' => 'Gottem'),
      array('lat' => '50.9771', 'lng' => '3.4649', 'postal_code' => '9800', 'name' => 'Grammene'),
      array('lat' => '51.0169', 'lng' => '3.5404', 'postal_code' => '9800', 'name' => 'Meigem'),
      array('lat' => '50.9800', 'lng' => '3.5339', 'postal_code' => '9800', 'name' => 'Petegem-Aan-De-Leie'),
      array('lat' => '51.0154', 'lng' => '3.5877', 'postal_code' => '9800', 'name' => 'Sint-Martens-Leerne'),
      array('lat' => '51.0082', 'lng' => '3.4794', 'postal_code' => '9800', 'name' => 'Vinkt'),
      array('lat' => '50.9794', 'lng' => '3.4446', 'postal_code' => '9800', 'name' => 'Wontergem'),
      array('lat' => '50.9963', 'lng' => '3.5011', 'postal_code' => '9800', 'name' => 'Zeveren'),
      array('lat' => '50.9581', 'lng' => '3.6375', 'postal_code' => '9810', 'name' => 'Eke'),
      array('lat' => '50.9598', 'lng' => '3.5951', 'postal_code' => '9810', 'name' => 'Nazareth'),
      array('lat' => '50.9632', 'lng' => '3.7538', 'postal_code' => '9820', 'name' => 'Bottelare'),
      array('lat' => '50.9781', 'lng' => '3.7730', 'postal_code' => '9820', 'name' => 'Lemberge'),
      array('lat' => '50.9563', 'lng' => '3.6941', 'postal_code' => '9820', 'name' => 'Melsen'),
      array('lat' => '50.9945', 'lng' => '3.7455', 'postal_code' => '9820', 'name' => 'Merelbeke'),
      array('lat' => '50.9450', 'lng' => '3.7442', 'postal_code' => '9820', 'name' => 'Munte'),
      array('lat' => '50.9714', 'lng' => '3.7155', 'postal_code' => '9820', 'name' => 'Schelderode'),
      array('lat' => '51.0135', 'lng' => '3.6288', 'postal_code' => '9830', 'name' => 'Sint-Martens-Latem'),
      array('lat' => '51.0092', 'lng' => '3.6043', 'postal_code' => '9831', 'name' => 'Deurle'),
      array('lat' => '50.9918', 'lng' => '3.6494', 'postal_code' => '9840', 'name' => 'De Pinte'),
      array('lat' => '50.9791', 'lng' => '3.6962', 'postal_code' => '9840', 'name' => 'Zevergem'),
      array('lat' => '51.0747', 'lng' => '3.5356', 'postal_code' => '9850', 'name' => 'Hansbeke'),
      array('lat' => '51.0567', 'lng' => '3.5731', 'postal_code' => '9850', 'name' => 'Landegem'),
      array('lat' => '51.0777', 'lng' => '3.5770', 'postal_code' => '9850', 'name' => 'Merendree'),
      array('lat' => '51.0340', 'lng' => '3.5161', 'postal_code' => '9850', 'name' => 'Poesele'),
      array('lat' => '51.0295', 'lng' => '3.5574', 'postal_code' => '9850', 'name' => 'Vosselare'),
      array('lat' => '50.9205', 'lng' => '3.7935', 'postal_code' => '9860', 'name' => 'Balegem'),
      array('lat' => '50.9710', 'lng' => '3.8165', 'postal_code' => '9860', 'name' => 'Gijzenzele'),
      array('lat' => '50.9684', 'lng' => '3.7929', 'postal_code' => '9860', 'name' => 'Landskouter'),
      array('lat' => '50.9590', 'lng' => '3.7795', 'postal_code' => '9860', 'name' => 'Moortsele'),
      array('lat' => '50.9468', 'lng' => '3.8155', 'postal_code' => '9860', 'name' => 'Oosterzele'),
      array('lat' => '50.9381', 'lng' => '3.7848', 'postal_code' => '9860', 'name' => 'Scheldewindeke'),
      array('lat' => '50.9588', 'lng' => '3.4880', 'postal_code' => '9870', 'name' => 'Machelen'),
      array('lat' => '50.9362', 'lng' => '3.4657', 'postal_code' => '9870', 'name' => 'Olsene'),
      array('lat' => '50.9219', 'lng' => '3.4438', 'postal_code' => '9870', 'name' => 'Zulte'),
      array('lat' => '51.0833', 'lng' => '3.4500', 'postal_code' => '9880,9910', 'name' => 'Aalter'),
      array('lat' => '51.0484', 'lng' => '3.4656', 'postal_code' => '9880', 'name' => 'Lotenhulle'),
      array('lat' => '51.0409', 'lng' => '3.4440', 'postal_code' => '9880', 'name' => 'Poeke'),
      array('lat' => '51.0884', 'lng' => '3.4906', 'postal_code' => '9881', 'name' => 'Bellem'),
      array('lat' => '50.9160', 'lng' => '3.6510', 'postal_code' => '9890', 'name' => 'Asper'),
      array('lat' => '50.9296', 'lng' => '3.7219', 'postal_code' => '9890', 'name' => 'Baaigem'),
      array('lat' => '50.9190', 'lng' => '3.6874', 'postal_code' => '9890', 'name' => 'Dikkelvenne'),
      array('lat' => '50.9283', 'lng' => '3.6599', 'postal_code' => '9890', 'name' => 'Gavere'),
      array('lat' => '50.9431', 'lng' => '3.6647', 'postal_code' => '9890', 'name' => 'Semmerzake'),
      array('lat' => '50.9491', 'lng' => '3.6843', 'postal_code' => '9890', 'name' => 'Vurste'),
      array('lat' => '51.1853', 'lng' => '3.5639', 'postal_code' => '9900', 'name' => 'Eeklo'),
      array('lat' => '51.1294', 'lng' => '3.4856', 'postal_code' => '9910', 'name' => 'Ursel'),
      array('lat' => '51.1333', 'lng' => '3.6000', 'postal_code' => '9920,9930,9950', 'name' => 'Lievegem'),
      array('lat' => '51.1076', 'lng' => '3.6286', 'postal_code' => '9920', 'name' => 'Lovendegem'),
      array('lat' => '51.0869', 'lng' => '3.6407', 'postal_code' => '9921', 'name' => 'Vinderhoute'),
      array('lat' => '51.1508', 'lng' => '3.5253', 'postal_code' => '9931', 'name' => 'Oostwinkel'),
      array('lat' => '51.1310', 'lng' => '3.5517', 'postal_code' => '9932', 'name' => 'Ronsele'),
      array('lat' => '51.1788', 'lng' => '3.7467', 'postal_code' => '9940', 'name' => 'Ertvelde'),
      array('lat' => '51.1101', 'lng' => '3.7067', 'postal_code' => '9940', 'name' => 'Evergem'),
      array('lat' => '51.1557', 'lng' => '3.7303', 'postal_code' => '9940', 'name' => 'Kluizen'),
      array('lat' => '51.1320', 'lng' => '3.6789', 'postal_code' => '9940', 'name' => 'Sleidinge'),
      array('lat' => '51.2270', 'lng' => '3.7510', 'postal_code' => '9960', 'name' => 'Assenede'),
      array('lat' => '51.2582', 'lng' => '3.7182', 'postal_code' => '9961', 'name' => 'Boekhoute'),
      array('lat' => '51.2301', 'lng' => '3.6777', 'postal_code' => '9968', 'name' => 'Bassevelde'),
      array('lat' => '51.1920', 'lng' => '3.6884', 'postal_code' => '9968', 'name' => 'Oosteeklo'),
      array('lat' => '51.2231', 'lng' => '3.6186', 'postal_code' => '9970', 'name' => 'Kaprijke'),
      array('lat' => '51.1946', 'lng' => '3.6330', 'postal_code' => '9971', 'name' => 'Lembeke'),
      array('lat' => '51.2362', 'lng' => '3.5329', 'postal_code' => '9980', 'name' => 'Sint-Laureins'),
      array('lat' => '51.2804', 'lng' => '3.5469', 'postal_code' => '9981', 'name' => 'Sint-Margriete'),
      array('lat' => '51.2737', 'lng' => '3.5769', 'postal_code' => '9982', 'name' => 'Sint-Jan-In-Eremo'),
      array('lat' => '51.2889', 'lng' => '3.5903', 'postal_code' => '9988', 'name' => 'Waterland-Oudeman'),
      array('lat' => '51.2765', 'lng' => '3.6270', 'postal_code' => '9988', 'name' => 'Watervliet'),
      array('lat' => '51.2091', 'lng' => '3.4487', 'postal_code' => '9990', 'name' => 'Maldegem'),
      array('lat' => '51.2047', 'lng' => '3.4868', 'postal_code' => '9991', 'name' => 'Adegem'),
      array('lat' => '51.2547', 'lng' => '3.4151', 'postal_code' => '9992', 'name' => 'Middelburg'),
    ],

    // France
    '20R' => [
      array('lat' => '41.5884', 'lng' => '8.9545', 'postal_code' => '20100', 'name' => 'Giuncheto'),
      array('lat' => '41.6103', 'lng' => '8.8764', 'postal_code' => '20100', 'name' => 'Grossa'),
      array('lat' => '41.6250', 'lng' => '8.9070', 'postal_code' => '20100', 'name' => 'Bilia'),
      array('lat' => NULL, 'lng' => NULL, 'postal_code' => '20100', 'name' => 'Foce'),
      array('lat' => '41.6167', 'lng' => '8.9833', 'postal_code' => '20100', 'name' => 'Sartène'),
      array('lat' => '41.6460', 'lng' => '9.0082', 'postal_code' => '20100', 'name' => 'Granace'),
      array('lat' => '41.6803', 'lng' => '8.9519', 'postal_code' => '20110', 'name' => 'Viggianello'),
      array('lat' => '41.6759', 'lng' => '8.9041', 'postal_code' => '20110', 'name' => 'Propriano'),
      array('lat' => '41.6277', 'lng' => '8.8154', 'postal_code' => '20110', 'name' => 'Belvédère-Campomoro'),
      array('lat' => '41.6816', 'lng' => '8.9901', 'postal_code' => '20110', 'name' => 'Arbellara'),
      array('lat' => '42.0682', 'lng' => '8.7865', 'postal_code' => '20111', 'name' => 'Casaglione'),
      array('lat' => '42.0287', 'lng' => '8.7681', 'postal_code' => '20111', 'name' => 'Calcatoggio'),
      array('lat' => '41.6938', 'lng' => '9.0598', 'postal_code' => '20112', 'name' => 'Olmiccia'),
      array('lat' => '41.6979', 'lng' => '9.0647', 'postal_code' => '20112', 'name' => 'Sainte-Lucie-de-Tallano'),
      array('lat' => '41.7178', 'lng' => '9.0705', 'postal_code' => '20112', 'name' => 'Zoza'),
      array('lat' => '41.7061', 'lng' => '9.0709', 'postal_code' => '20112', 'name' => 'Altagène'),
      array('lat' => '41.6958', 'lng' => '9.0945', 'postal_code' => '20112', 'name' => 'Mela'),
      array('lat' => '41.7172', 'lng' => '8.9178', 'postal_code' => '20113', 'name' => 'Olmeto'),
      array('lat' => '41.4882', 'lng' => '9.1295', 'postal_code' => '20114', 'name' => 'Figari'),
      array('lat' => '42.2388', 'lng' => '8.6370', 'postal_code' => '20115', 'name' => 'Piana'),
      array('lat' => '41.7527', 'lng' => '9.0754', 'postal_code' => '20116', 'name' => 'Zérubia'),
      array('lat' => '41.7720', 'lng' => '9.0815', 'postal_code' => '20116', 'name' => 'Aullène'),
      array('lat' => '41.9179', 'lng' => '8.9140', 'postal_code' => '20117', 'name' => 'Cauro'),
      array('lat' => '41.9167', 'lng' => '8.9167', 'postal_code' => '20117', 'name' => 'Eccica-Suarella'),
      array('lat' => '41.9593', 'lng' => '8.9349', 'postal_code' => '20117', 'name' => 'Ocana'),
      array('lat' => '41.9756', 'lng' => '8.9717', 'postal_code' => '20117', 'name' => 'Tolla'),
      array('lat' => '42.0008', 'lng' => '9.0500', 'postal_code' => '20119', 'name' => 'Bastelica'),
      array('lat' => '42.1174', 'lng' => '8.9249', 'postal_code' => '20121', 'name' => 'Azzana'),
      array('lat' => '42.1298', 'lng' => '8.8713', 'postal_code' => '20121', 'name' => 'Rosazia'),
      array('lat' => '42.1209', 'lng' => '8.9022', 'postal_code' => '20121', 'name' => 'Salice'),
      array('lat' => '42.1266', 'lng' => '8.9460', 'postal_code' => '20121', 'name' => 'Rezza'),
      array('lat' => '42.1405', 'lng' => '8.9833', 'postal_code' => '20121', 'name' => 'Pastricciola'),
      array('lat' => '41.7657', 'lng' => '9.1377', 'postal_code' => '20122', 'name' => 'Quenza'),
      array('lat' => '41.8128', 'lng' => '8.9099', 'postal_code' => '20123', 'name' => 'Pila-Canale'),
      array('lat' => '42.1890', 'lng' => '8.9310', 'postal_code' => '20125', 'name' => 'Orto'),
      array('lat' => '42.1903', 'lng' => '8.9098', 'postal_code' => '20125', 'name' => 'Soccia'),
      array('lat' => '42.2397', 'lng' => '8.8391', 'postal_code' => '20126', 'name' => 'Cristinacce'),
      array('lat' => '42.2500', 'lng' => '8.8000', 'postal_code' => '20126', 'name' => 'Évisa'),
      array('lat' => '41.7531', 'lng' => '9.0995', 'postal_code' => '20127', 'name' => 'Serra-di-Scopamène'),
      array('lat' => '41.8371', 'lng' => '8.9276', 'postal_code' => '20128', 'name' => 'Guarguale'),
      array('lat' => '41.8366', 'lng' => '8.9479', 'postal_code' => '20128', 'name' => 'Urbalacone'),
      array('lat' => '41.9220', 'lng' => '8.8289', 'postal_code' => '20129', 'name' => 'Bastelicaccia'),
      array('lat' => '42.1363', 'lng' => '8.5959', 'postal_code' => '20130', 'name' => 'Cargèse'),
      array('lat' => '41.4944', 'lng' => '9.0563', 'postal_code' => '20131', 'name' => 'Pianottoli-Caldarello'),
      array('lat' => '41.9067', 'lng' => '9.1293', 'postal_code' => '20132', 'name' => 'Zicavo'),
      array('lat' => '42.0380', 'lng' => '8.9486', 'postal_code' => '20133', 'name' => 'Carbuccia'),
      array('lat' => '42.0445', 'lng' => '8.9787', 'postal_code' => '20133', 'name' => 'Ucciani'),
      array('lat' => '41.9687', 'lng' => '9.1724', 'postal_code' => '20134', 'name' => 'Palneca'),
      array('lat' => '41.9437', 'lng' => '9.1040', 'postal_code' => '20134', 'name' => 'Tasso'),
      array('lat' => '41.9410', 'lng' => '9.1225', 'postal_code' => '20134', 'name' => 'Sampolo'),
      array('lat' => '41.9505', 'lng' => '9.1465', 'postal_code' => '20134', 'name' => 'Ciamannacce'),
      array('lat' => '41.7345', 'lng' => '9.3323', 'postal_code' => '20135', 'name' => 'Conca'),
      array('lat' => '42.0831', 'lng' => '9.0652', 'postal_code' => '20136', 'name' => 'Bocognano'),
      array('lat' => '41.6801', 'lng' => '9.3157', 'postal_code' => '20137', 'name' => 'Lecci'),
      array('lat' => '41.7725', 'lng' => '8.7710', 'postal_code' => '20138', 'name' => 'Coti-Chiavari'),
      array('lat' => '42.0986', 'lng' => '8.8450', 'postal_code' => '20139', 'name' => 'Lopigna'),
      array('lat' => '41.8458', 'lng' => '9.0560', 'postal_code' => '20140', 'name' => 'Olivese'),
      array('lat' => '41.8092', 'lng' => '9.0115', 'postal_code' => '20140', 'name' => 'Moca'),
      array('lat' => '41.7277', 'lng' => '8.7971', 'postal_code' => '20140', 'name' => 'Serra-di-Ferro'),
      array('lat' => '41.7445', 'lng' => '8.9124', 'postal_code' => '20140', 'name' => 'Sollacaro'),
      array('lat' => '41.8157', 'lng' => '9.0253', 'postal_code' => '20140', 'name' => 'Argiusta-Moriccio'),
      array('lat' => '41.7532', 'lng' => '8.9380', 'postal_code' => '20140', 'name' => 'Casalabriva'),
      array('lat' => '41.7835', 'lng' => '8.9807', 'postal_code' => '20140', 'name' => 'Petreto'),
      array('lat' => '42.2322', 'lng' => '8.7980', 'postal_code' => '20141', 'name' => 'Marignana'),
      array('lat' => '41.9008', 'lng' => '9.0093', 'postal_code' => '20142', 'name' => 'Quasquara'),
      array('lat' => '41.8906', 'lng' => '9.0035', 'postal_code' => '20142', 'name' => 'Campo'),
      array('lat' => '41.6975', 'lng' => '9.0016', 'postal_code' => '20143', 'name' => 'Fozzano'),
      array('lat' => '41.7070', 'lng' => '9.0045', 'postal_code' => '20143', 'name' => 'Santa-Maria'),
      array('lat' => '41.7493', 'lng' => '9.1708', 'postal_code' => '20144', 'name' => 'Zonza'),
      array('lat' => '41.8352', 'lng' => '9.3747', 'postal_code' => '20145', 'name' => 'Sari-Solenzara'),
      array('lat' => '41.5448', 'lng' => '9.1963', 'postal_code' => '20146', 'name' => 'Sotta'),
      array('lat' => '42.3117', 'lng' => '8.6827', 'postal_code' => '20147', 'name' => 'Partinello'),
      array('lat' => '42.3015', 'lng' => '8.7089', 'postal_code' => '20147', 'name' => 'Serriera'),
      array('lat' => '42.3241', 'lng' => '8.6329', 'postal_code' => '20147', 'name' => 'Osani'),
      array('lat' => '41.9327', 'lng' => '9.1529', 'postal_code' => '20148', 'name' => 'Cozzano'),
      array('lat' => '42.2659', 'lng' => '8.7056', 'postal_code' => '20150', 'name' => 'Porto'),
      array('lat' => '42.2581', 'lng' => '8.7463', 'postal_code' => '20150', 'name' => 'Ota'),
      array('lat' => '42.0591', 'lng' => '8.8286', 'postal_code' => '20151', 'name' => 'Sari-d’Orcino'),
      array('lat' => '42.0929', 'lng' => '8.8117', 'postal_code' => '20151', 'name' => 'Arro'),
      array('lat' => '42.0333', 'lng' => '8.8000', 'postal_code' => '20151', 'name' => 'Sant\'Andréa-d\'Orcino'),
      array('lat' => '42.0492', 'lng' => '8.8213', 'postal_code' => '20151', 'name' => 'Cannelle'),
      array('lat' => '42.0837', 'lng' => '8.7928', 'postal_code' => '20151', 'name' => 'Ambiegna'),
      array('lat' => '41.7519', 'lng' => '9.1095', 'postal_code' => '20152', 'name' => 'Sorbollano'),
      array('lat' => '41.9167', 'lng' => '9.0833', 'postal_code' => '20153', 'name' => 'Guitera-les-Bains'),
      array('lat' => '41.8959', 'lng' => '9.0221', 'postal_code' => '20157', 'name' => 'Frasseto'),
      array('lat' => '42.1683', 'lng' => '8.9490', 'postal_code' => '20160', 'name' => 'Guagno'),
      array('lat' => '42.1283', 'lng' => '8.7971', 'postal_code' => '20160', 'name' => 'Arbori'),
      array('lat' => '42.2091', 'lng' => '8.8269', 'postal_code' => '20160', 'name' => 'Renno'),
      array('lat' => '42.1673', 'lng' => '8.8002', 'postal_code' => '20160', 'name' => 'Vico'),
      array('lat' => '42.1767', 'lng' => '8.9099', 'postal_code' => '20160', 'name' => 'Poggiolo'),
      array('lat' => '42.1783', 'lng' => '8.7791', 'postal_code' => '20160', 'name' => 'Balogna'),
      array('lat' => '42.1213', 'lng' => '8.7590', 'postal_code' => '20160', 'name' => 'Coggia'),
      array('lat' => '42.1676', 'lng' => '8.8254', 'postal_code' => '20160', 'name' => 'Murzo'),
      array('lat' => '42.1903', 'lng' => '8.8501', 'postal_code' => '20160', 'name' => 'Letia'),
      array('lat' => '42.0666', 'lng' => '9.0155', 'postal_code' => '20163', 'name' => 'Tavera'),
      array('lat' => '41.7312', 'lng' => '9.0480', 'postal_code' => '20164', 'name' => 'Cargiaca'),
      array('lat' => '41.7194', 'lng' => '9.0373', 'postal_code' => '20165', 'name' => 'Loreto-di-Tallano'),
      array('lat' => '41.8710', 'lng' => '8.9640', 'postal_code' => '20166', 'name' => 'Grosseto-Prugna'),
      array('lat' => '41.8625', 'lng' => '8.9418', 'postal_code' => '20166', 'name' => 'Albitreccia'),
      array('lat' => '41.8358', 'lng' => '8.8457', 'postal_code' => '20166', 'name' => 'Pietrosella'),
      array('lat' => '41.8285', 'lng' => '8.9053', 'postal_code' => '20166', 'name' => 'Cognocoli-Monticchi'),
      array('lat' => '42.0124', 'lng' => '8.8505', 'postal_code' => '20167', 'name' => 'Sarrola-Carcopino'),
      array('lat' => '42.0039', 'lng' => '8.9210', 'postal_code' => '20167', 'name' => 'Peri'),
      array('lat' => '42.0229', 'lng' => '8.8215', 'postal_code' => '20167', 'name' => 'Valle-di-Mezzana'),
      array('lat' => '41.9775', 'lng' => '8.7423', 'postal_code' => '20167', 'name' => 'Alata'),
      array('lat' => '41.9836', 'lng' => '8.7947', 'postal_code' => '20167', 'name' => 'Afa'),
      array('lat' => '41.9833', 'lng' => '8.9167', 'postal_code' => '20167', 'name' => 'Cuttoli-Corticchiato'),
      array('lat' => '41.9597', 'lng' => '8.6679', 'postal_code' => '20167', 'name' => 'Villanova'),
      array('lat' => '42.0145', 'lng' => '8.7679', 'postal_code' => '20167', 'name' => 'Appietto'),
      array('lat' => '42.0349', 'lng' => '8.9001', 'postal_code' => '20167', 'name' => 'Tavaco'),
      array('lat' => '41.8899', 'lng' => '9.0646', 'postal_code' => '20168', 'name' => 'Corrano'),
      array('lat' => '41.3874', 'lng' => '9.1594', 'postal_code' => '20169', 'name' => 'Bonifacio'),
      array('lat' => '41.7212', 'lng' => '9.1483', 'postal_code' => '20170', 'name' => 'San-Gavino-di-Carbini'),
      array('lat' => '41.7022', 'lng' => '9.1247', 'postal_code' => '20170', 'name' => 'Levie'),
      array('lat' => '41.6788', 'lng' => '9.1468', 'postal_code' => '20170', 'name' => 'Carbini'),
      array('lat' => '41.5136', 'lng' => '9.0122', 'postal_code' => '20171', 'name' => 'Monacia-d’Aullène'),
      array('lat' => '42.0630', 'lng' => '8.9320', 'postal_code' => '20172', 'name' => 'Vero'),
      array('lat' => '41.8833', 'lng' => '9.0500', 'postal_code' => '20173', 'name' => 'Zévaco'),
      array('lat' => '41.8535', 'lng' => '9.0089', 'postal_code' => '20190', 'name' => 'Forciolo'),
      array('lat' => '41.8633', 'lng' => '9.0155', 'postal_code' => '20190', 'name' => 'Azilone-Ampaza'),
      array('lat' => '41.8767', 'lng' => '8.9767', 'postal_code' => '20190', 'name' => 'Santa-Maria-Siché'),
      array('lat' => '41.8684', 'lng' => '8.9789', 'postal_code' => '20190', 'name' => 'Cardo-Torgia'),
      array('lat' => '41.8462', 'lng' => '8.9941', 'postal_code' => '20190', 'name' => 'Zigliara'),
      array('lat' => '41.5910', 'lng' => '9.2795', 'postal_code' => '20538 CEDEX', 'name' => 'Porto-Vecchio'),
      array('lat' => '41.9189', 'lng' => '8.7381', 'postal_code' => '20900 CEDEX 9', 'name' => 'Ajaccio'),
      array('lat' => '42.7316', 'lng' => '9.4397', 'postal_code' => '20200', 'name' => 'San-Martino-di-Lota'),
      array('lat' => '42.7478', 'lng' => '9.4320', 'postal_code' => '20200', 'name' => 'Santa-Maria-di-Lota'),
      array('lat' => '42.7131', 'lng' => '9.4310', 'postal_code' => '20200', 'name' => 'Ville-di-Pietrabugno'),
      array('lat' => '42.3064', 'lng' => '9.2905', 'postal_code' => '20212', 'name' => 'Alando'),
      array('lat' => '42.3217', 'lng' => '9.3003', 'postal_code' => '20212', 'name' => 'Bustanico'),
      array('lat' => '42.3105', 'lng' => '9.2470', 'postal_code' => '20212', 'name' => 'Castellare-di-Mercurio'),
      array('lat' => '42.3011', 'lng' => '9.3112', 'postal_code' => '20212', 'name' => 'Mazzola'),
      array('lat' => '42.2954', 'lng' => '9.2715', 'postal_code' => '20212', 'name' => 'Favalello'),
      array('lat' => '42.2973', 'lng' => '9.3032', 'postal_code' => '20212', 'name' => 'Sant\'Andréa-di-Bozio'),
      array('lat' => '42.2496', 'lng' => '9.2935', 'postal_code' => '20212', 'name' => 'Focicchia'),
      array('lat' => '42.3145', 'lng' => '9.2675', 'postal_code' => '20212', 'name' => 'Sermano'),
      array('lat' => '42.3036', 'lng' => '9.3025', 'postal_code' => '20212', 'name' => 'Alzi'),
      array('lat' => '42.2634', 'lng' => '9.2819', 'postal_code' => '20212', 'name' => 'Erbajolo'),
      array('lat' => '42.4024', 'lng' => '9.4194', 'postal_code' => '20213', 'name' => 'San-Damiano'),
      array('lat' => '42.4168', 'lng' => '9.4024', 'postal_code' => '20213', 'name' => 'Scata'),
      array('lat' => '42.4658', 'lng' => '9.4588', 'postal_code' => '20213', 'name' => 'Penta-di-Casinca'),
      array('lat' => '42.4162', 'lng' => '9.4405', 'postal_code' => '20213', 'name' => 'Pruno'),
      array('lat' => '42.4762', 'lng' => '9.4559', 'postal_code' => '20213', 'name' => 'Sorbo-Ocagnano'),
      array('lat' => '42.4676', 'lng' => '9.4742', 'postal_code' => '20213', 'name' => 'Castellare-di-Casinca'),
      array('lat' => '42.4125', 'lng' => '9.4229', 'postal_code' => '20213', 'name' => 'San-Gavino-d\'Ampugnani'),
      array('lat' => '42.5421', 'lng' => '8.8865', 'postal_code' => '20214', 'name' => 'Montegrosso'),
      array('lat' => '42.5302', 'lng' => '8.9017', 'postal_code' => '20214', 'name' => 'Zilia'),
      array('lat' => '42.5098', 'lng' => '8.8367', 'postal_code' => '20214', 'name' => 'Moncale'),
      array('lat' => '42.4929', 'lng' => '9.4393', 'postal_code' => '20215', 'name' => 'Vescovato'),
      array('lat' => '42.4420', 'lng' => '9.4093', 'postal_code' => '20215', 'name' => 'Casalta'),
      array('lat' => '42.4765', 'lng' => '9.4306', 'postal_code' => '20215', 'name' => 'Loreto-di-Casinca'),
      array('lat' => '42.4476', 'lng' => '9.4028', 'postal_code' => '20215', 'name' => 'Piano'),
      array('lat' => '42.4840', 'lng' => '9.4557', 'postal_code' => '20215', 'name' => 'Venzolasca'),
      array('lat' => '42.4531', 'lng' => '9.4340', 'postal_code' => '20215', 'name' => 'Porri'),
      array('lat' => '42.4502', 'lng' => '9.4098', 'postal_code' => '20215', 'name' => 'Silvareccio'),
      array('lat' => '42.8500', 'lng' => '9.3500', 'postal_code' => '20217', 'name' => 'Canari'),
      array('lat' => '42.8169', 'lng' => '9.3482', 'postal_code' => '20217', 'name' => 'Ogliastro'),
      array('lat' => '42.7846', 'lng' => '9.3444', 'postal_code' => '20217', 'name' => 'Nonza'),
      array('lat' => '42.6815', 'lng' => '9.3040', 'postal_code' => '20217', 'name' => 'Saint-Florent'),
      array('lat' => '42.8103', 'lng' => '9.3707', 'postal_code' => '20217', 'name' => 'Olcani'),
      array('lat' => '42.7689', 'lng' => '9.3716', 'postal_code' => '20217', 'name' => 'Olmeta-di-Capocorso'),
      array('lat' => '42.3996', 'lng' => '9.2951', 'postal_code' => '20218', 'name' => 'Saliceto'),
      array('lat' => '42.4351', 'lng' => '9.3001', 'postal_code' => '20218', 'name' => 'Morosaglia'),
      array('lat' => '42.5462', 'lng' => '9.1850', 'postal_code' => '20218', 'name' => 'Pietralba'),
      array('lat' => '42.4178', 'lng' => '9.1279', 'postal_code' => '20218', 'name' => 'Castiglione'),
      array('lat' => '42.4338', 'lng' => '9.1343', 'postal_code' => '20218', 'name' => 'Popolasca'),
      array('lat' => '42.5958', 'lng' => '9.1668', 'postal_code' => '20218', 'name' => 'Urtaca'),
      array('lat' => '42.4470', 'lng' => '9.1712', 'postal_code' => '20218', 'name' => 'Piedigriggio'),
      array('lat' => '42.4167', 'lng' => '9.1667', 'postal_code' => '20218', 'name' => 'Prato-di-Giovellina'),
      array('lat' => '42.4865', 'lng' => '9.1141', 'postal_code' => '20218', 'name' => 'Moltifao'),
      array('lat' => '42.5767', 'lng' => '9.1720', 'postal_code' => '20218', 'name' => 'Lama'),
      array('lat' => '42.4228', 'lng' => '9.2988', 'postal_code' => '20218', 'name' => 'Castineta'),
      array('lat' => '42.4179', 'lng' => '9.2879', 'postal_code' => '20218', 'name' => 'Gavignano'),
      array('lat' => '42.5037', 'lng' => '9.1125', 'postal_code' => '20218', 'name' => 'Castifao'),
      array('lat' => '42.1713', 'lng' => '9.1711', 'postal_code' => '20219', 'name' => 'Vivario'),
      array('lat' => '42.1691', 'lng' => '9.1829', 'postal_code' => '20219', 'name' => 'Muracciole'),
      array('lat' => '42.6170', 'lng' => '8.9548', 'postal_code' => '20220', 'name' => 'Monticello'),
      array('lat' => '42.6337', 'lng' => '8.9376', 'postal_code' => '20220', 'name' => 'L\'Île-Rousse'),
      array('lat' => '42.5810', 'lng' => '8.8942', 'postal_code' => '20220', 'name' => 'Aregno'),
      array('lat' => '42.6079', 'lng' => '8.8625', 'postal_code' => '20220', 'name' => 'Algajola'),
      array('lat' => '42.5995', 'lng' => '8.9028', 'postal_code' => '20220', 'name' => 'Pigna'),
      array('lat' => '42.6042', 'lng' => '8.9289', 'postal_code' => '20220', 'name' => 'Santa-Reparata-di-Balagna'),
      array('lat' => '42.5886', 'lng' => '8.9050', 'postal_code' => '20220', 'name' => 'Sant’Antonino'),
      array('lat' => '42.3449', 'lng' => '9.4952', 'postal_code' => '20221', 'name' => 'Santa-Maria-Poggio'),
      array('lat' => '42.3000', 'lng' => '9.4667', 'postal_code' => '20221', 'name' => 'Sant\'Andréa-di-Cotone'),
      array('lat' => '42.3343', 'lng' => '9.5152', 'postal_code' => '20221', 'name' => 'Valle-di-Campoloro'),
      array('lat' => '42.3284', 'lng' => '9.4934', 'postal_code' => '20221', 'name' => 'Cervione'),
      array('lat' => '42.7667', 'lng' => '9.4500', 'postal_code' => '20222', 'name' => 'Brando'),
      array('lat' => '41.9244', 'lng' => '9.4060', 'postal_code' => '20223 AIR', 'name' => 'Solenzara Air Base'),
      array('lat' => '42.3270', 'lng' => '8.9842', 'postal_code' => '20224', 'name' => 'Albertacce'),
      array('lat' => '42.3176', 'lng' => '9.0015', 'postal_code' => '20224', 'name' => 'Casamaccioli'),
      array('lat' => '42.3450', 'lng' => '9.0035', 'postal_code' => '20224', 'name' => 'Lozzi'),
      array('lat' => '42.3353', 'lng' => '9.0162', 'postal_code' => '20224', 'name' => 'Calacuccia'),
      array('lat' => '42.3542', 'lng' => '9.0425', 'postal_code' => '20224', 'name' => 'Corscia'),
      array('lat' => '42.5458', 'lng' => '8.9141', 'postal_code' => '20225', 'name' => 'Muro'),
      array('lat' => '42.5742', 'lng' => '8.8776', 'postal_code' => '20225', 'name' => 'Lavatoggio'),
      array('lat' => '42.5718', 'lng' => '8.8911', 'postal_code' => '20225', 'name' => 'Cateri'),
      array('lat' => '42.5501', 'lng' => '8.9483', 'postal_code' => '20225', 'name' => 'Nessa'),
      array('lat' => '42.5441', 'lng' => '8.9352', 'postal_code' => '20225', 'name' => 'Feliceto'),
      array('lat' => '42.5611', 'lng' => '8.8953', 'postal_code' => '20225', 'name' => 'Avapessa'),
      array('lat' => '42.5750', 'lng' => '9.0019', 'postal_code' => '20226', 'name' => 'Costa'),
      array('lat' => '42.5618', 'lng' => '8.9812', 'postal_code' => '20226', 'name' => 'Speloncato'),
      array('lat' => '42.5736', 'lng' => '9.0088', 'postal_code' => '20226', 'name' => 'Occhiatana'),
      array('lat' => '42.5855', 'lng' => '9.0179', 'postal_code' => '20226', 'name' => 'Belgodère'),
      array('lat' => '42.5889', 'lng' => '9.0429', 'postal_code' => '20226', 'name' => 'Palasca'),
      array('lat' => '42.5846', 'lng' => '9.1172', 'postal_code' => '20226', 'name' => 'Novella'),
      array('lat' => '42.1026', 'lng' => '9.2103', 'postal_code' => '20227', 'name' => 'Ghisoni'),
      array('lat' => '42.8769', 'lng' => '9.3554', 'postal_code' => '20228', 'name' => 'Barrettali'),
      array('lat' => '42.8783', 'lng' => '9.4537', 'postal_code' => '20228', 'name' => 'Cagnano'),
      array('lat' => '42.9085', 'lng' => '9.3505', 'postal_code' => '20228', 'name' => 'Pino'),
      array('lat' => '42.8967', 'lng' => '9.4058', 'postal_code' => '20228', 'name' => 'Luri'),
      array('lat' => '42.3667', 'lng' => '9.3667', 'postal_code' => '20229', 'name' => 'Carcheto-Brustico'),
      array('lat' => '42.3932', 'lng' => '9.4022', 'postal_code' => '20229', 'name' => 'Piazzole'),
      array('lat' => '42.3721', 'lng' => '9.3548', 'postal_code' => '20229', 'name' => 'Pie-d’Orezza'),
      array('lat' => '42.3710', 'lng' => '9.3727', 'postal_code' => '20229', 'name' => 'Stazzona'),
      array('lat' => '42.3930', 'lng' => '9.3646', 'postal_code' => '20229', 'name' => 'Verdèse'),
      array('lat' => '42.3551', 'lng' => '9.3799', 'postal_code' => '20229', 'name' => 'Carpineto'),
      array('lat' => '42.3682', 'lng' => '9.3584', 'postal_code' => '20229', 'name' => 'Piedipartino'),
      array('lat' => '42.3612', 'lng' => '9.4040', 'postal_code' => '20229', 'name' => 'Valle-d’Orezza'),
      array('lat' => '42.3887', 'lng' => '9.3534', 'postal_code' => '20229', 'name' => 'Campana'),
      array('lat' => '42.3702', 'lng' => '9.4090', 'postal_code' => '20229', 'name' => 'Parata'),
      array('lat' => '42.3833', 'lng' => '9.3833', 'postal_code' => '20229', 'name' => 'Monacia-d’Orezza'),
      array('lat' => '42.3724', 'lng' => '9.3895', 'postal_code' => '20229', 'name' => 'Rapaggio'),
      array('lat' => '42.3746', 'lng' => '9.3681', 'postal_code' => '20229', 'name' => 'Piedicroce'),
      array('lat' => '42.4005', 'lng' => '9.3643', 'postal_code' => '20229', 'name' => 'Polveroso'),
      array('lat' => '42.3982', 'lng' => '9.3522', 'postal_code' => '20229', 'name' => 'Nocario'),
      array('lat' => '42.3123', 'lng' => '9.5166', 'postal_code' => '20230', 'name' => 'San-Giuliano'),
      array('lat' => '42.2911', 'lng' => '9.4741', 'postal_code' => '20230', 'name' => 'Chiatra'),
      array('lat' => '42.3503', 'lng' => '9.4564', 'postal_code' => '20230', 'name' => 'Santa-Reparata-di-Moriani'),
      array('lat' => '42.2771', 'lng' => '9.4748', 'postal_code' => '20230', 'name' => 'Canale-di-Verde'),
      array('lat' => '42.4145', 'lng' => '9.4653', 'postal_code' => '20230', 'name' => 'Pero-Casevecchie'),
      array('lat' => '42.4004', 'lng' => '9.4710', 'postal_code' => '20230', 'name' => 'Velone-Orneto'),
      array('lat' => '42.2991', 'lng' => '9.4508', 'postal_code' => '20230', 'name' => 'Pietra-di-Verde'),
      array('lat' => '42.4351', 'lng' => '9.4698', 'postal_code' => '20230', 'name' => 'Taglio'),
      array('lat' => '42.2638', 'lng' => '9.4730', 'postal_code' => '20230', 'name' => 'Linguizzetta'),
      array('lat' => '42.3821', 'lng' => '9.5224', 'postal_code' => '20230', 'name' => 'Santa-Lucia-di-Moriani'),
      array('lat' => '42.3979', 'lng' => '9.4942', 'postal_code' => '20230', 'name' => 'Poggio-Mezzana'),
      array('lat' => '42.3699', 'lng' => '9.5144', 'postal_code' => '20230', 'name' => 'San-Nicolao'),
      array('lat' => '42.3759', 'lng' => '9.4586', 'postal_code' => '20230', 'name' => 'San-Giovanni-di-Moriani'),
      array('lat' => '42.4085', 'lng' => '9.4796', 'postal_code' => '20230', 'name' => 'Talasani'),
      array('lat' => '42.2323', 'lng' => '9.1725', 'postal_code' => '20231', 'name' => 'Venaco'),
      array('lat' => '42.6408', 'lng' => '9.3600', 'postal_code' => '20232', 'name' => 'Poggio-d’Oletta'),
      array('lat' => '42.5987', 'lng' => '9.3398', 'postal_code' => '20232', 'name' => 'Vallecalle'),
      array('lat' => '42.6108', 'lng' => '9.3545', 'postal_code' => '20232', 'name' => 'Olmeta-di-Tuda'),
      array('lat' => '42.6299', 'lng' => '9.3543', 'postal_code' => '20232', 'name' => 'Oletta'),
      array('lat' => '42.8000', 'lng' => '9.4333', 'postal_code' => '20233', 'name' => 'Sisco'),
      array('lat' => '42.8463', 'lng' => '9.4301', 'postal_code' => '20233', 'name' => 'Pietracorbara'),
      array('lat' => '42.3488', 'lng' => '9.4182', 'postal_code' => '20234', 'name' => 'Felce'),
      array('lat' => '42.3421', 'lng' => '9.3979', 'postal_code' => '20234', 'name' => 'Tarrano'),
      array('lat' => '42.3097', 'lng' => '9.4140', 'postal_code' => '20234', 'name' => 'Novale'),
      array('lat' => '42.3349', 'lng' => '9.3888', 'postal_code' => '20234', 'name' => 'Pietricaggio'),
      array('lat' => '42.3192', 'lng' => '9.4069', 'postal_code' => '20234', 'name' => 'Piazzali'),
      array('lat' => '42.3163', 'lng' => '9.4230', 'postal_code' => '20234', 'name' => 'Ortale'),
      array('lat' => '42.3229', 'lng' => '9.3930', 'postal_code' => '20234', 'name' => 'Perelli'),
      array('lat' => '42.3261', 'lng' => '9.4157', 'postal_code' => '20234', 'name' => 'Valle-d\'Alesani'),
      array('lat' => '42.3333', 'lng' => '9.3833', 'postal_code' => '20234', 'name' => 'Piobetta'),
      array('lat' => '42.4775', 'lng' => '9.3242', 'postal_code' => '20235', 'name' => 'Bisinchi'),
      array('lat' => '42.4638', 'lng' => '9.3149', 'postal_code' => '20235', 'name' => 'Castello-di-Rostino'),
      array('lat' => '42.5044', 'lng' => '9.2610', 'postal_code' => '20235', 'name' => 'Canavaggia'),
      array('lat' => '42.4572', 'lng' => '9.2798', 'postal_code' => '20235', 'name' => 'Valle-di-Rostino'),
      array('lat' => '42.3725', 'lng' => '9.1441', 'postal_code' => '20236', 'name' => 'Castirla'),
      array('lat' => '42.3703', 'lng' => '9.1992', 'postal_code' => '20236', 'name' => 'Omessa'),
      array('lat' => '42.4221', 'lng' => '9.3684', 'postal_code' => '20237', 'name' => 'Ficaja'),
      array('lat' => '42.4138', 'lng' => '9.3617', 'postal_code' => '20237', 'name' => 'Croce'),
      array('lat' => '42.4463', 'lng' => '9.3634', 'postal_code' => '20237', 'name' => 'Casabianca'),
      array('lat' => '42.4167', 'lng' => '9.3500', 'postal_code' => '20237', 'name' => 'La Porta'),
      array('lat' => '42.4250', 'lng' => '9.3492', 'postal_code' => '20237', 'name' => 'Quercitello'),
      array('lat' => '42.4437', 'lng' => '9.3487', 'postal_code' => '20237', 'name' => 'Giocatojo'),
      array('lat' => '42.4358', 'lng' => '9.3540', 'postal_code' => '20237', 'name' => 'Poggio-Marinaccio'),
      array('lat' => '42.9659', 'lng' => '9.3518', 'postal_code' => '20238', 'name' => 'Centuri'),
      array('lat' => '42.9453', 'lng' => '9.3653', 'postal_code' => '20238', 'name' => 'Morsiglia'),
      array('lat' => '42.5780', 'lng' => '9.3271', 'postal_code' => '20239', 'name' => 'Murato'),
      array('lat' => '42.5798', 'lng' => '9.3634', 'postal_code' => '20239', 'name' => 'Rutali'),
      array('lat' => '41.9235', 'lng' => '9.2608', 'postal_code' => '20240', 'name' => 'Chisa'),
      array('lat' => '41.9040', 'lng' => '9.3269', 'postal_code' => '20240', 'name' => 'Solaro'),
      array('lat' => '42.0734', 'lng' => '9.3001', 'postal_code' => '20240', 'name' => 'Lugo-di-Nazza'),
      array('lat' => '42.0162', 'lng' => '9.4041', 'postal_code' => '20240', 'name' => 'Ghisonaccia'),
      array('lat' => '41.9417', 'lng' => '9.3317', 'postal_code' => '20240', 'name' => 'Ventiseri'),
      array('lat' => '42.0544', 'lng' => '9.2948', 'postal_code' => '20240', 'name' => 'Poggio-di-Nazza'),
      array('lat' => '42.1735', 'lng' => '9.2453', 'postal_code' => '20242', 'name' => 'Vezzani'),
      array('lat' => '42.1894', 'lng' => '9.2295', 'postal_code' => '20242', 'name' => 'Rospigliani'),
      array('lat' => '42.1547', 'lng' => '9.2702', 'postal_code' => '20242', 'name' => 'Pietroso'),
      array('lat' => '42.1977', 'lng' => '9.2095', 'postal_code' => '20242', 'name' => 'Noceta'),
      array('lat' => '41.9850', 'lng' => '9.3365', 'postal_code' => '20243', 'name' => 'Serra-di-Fiumorbo'),
      array('lat' => '41.9827', 'lng' => '9.2676', 'postal_code' => '20243', 'name' => 'San-Gavino-di-Fiumorbo'),
      array('lat' => '42.0105', 'lng' => '9.3247', 'postal_code' => '20243', 'name' => 'Prunelli-di-Fiumorbo'),
      array('lat' => '42.0007', 'lng' => '9.2805', 'postal_code' => '20243', 'name' => 'Isolaccio-di-Fiumorbo'),
      array('lat' => '42.3991', 'lng' => '9.2442', 'postal_code' => '20244', 'name' => 'Aiti'),
      array('lat' => '42.3569', 'lng' => '9.2907', 'postal_code' => '20244', 'name' => 'Carticasi'),
      array('lat' => '42.3815', 'lng' => '9.2474', 'postal_code' => '20244', 'name' => 'Lano'),
      array('lat' => '42.3619', 'lng' => '9.2608', 'postal_code' => '20244', 'name' => 'Rusio'),
      array('lat' => '42.3837', 'lng' => '9.2886', 'postal_code' => '20244', 'name' => 'San-Lorenzo'),
      array('lat' => '42.3636', 'lng' => '9.2938', 'postal_code' => '20244', 'name' => 'Cambia'),
      array('lat' => '42.3727', 'lng' => '9.2712', 'postal_code' => '20244', 'name' => 'Érone'),
      array('lat' => '42.4108', 'lng' => '8.6491', 'postal_code' => '20245', 'name' => 'Galéria'),
      array('lat' => '42.3779', 'lng' => '8.7784', 'postal_code' => '20245', 'name' => 'Manso'),
      array('lat' => '42.6070', 'lng' => '9.2568', 'postal_code' => '20246', 'name' => 'Santo-Pietro-di-Tenda'),
      array('lat' => '42.5988', 'lng' => '9.2657', 'postal_code' => '20246', 'name' => 'San-Gavino-di-Tenda'),
      array('lat' => '42.5907', 'lng' => '9.3030', 'postal_code' => '20246', 'name' => 'Rapale'),
      array('lat' => '42.5835', 'lng' => '9.2739', 'postal_code' => '20246', 'name' => 'Sorio'),
      array('lat' => '42.5799', 'lng' => '9.2879', 'postal_code' => '20246', 'name' => 'Piève'),
      array('lat' => '42.9462', 'lng' => '9.4427', 'postal_code' => '20248', 'name' => 'Tomino'),
      array('lat' => '42.9561', 'lng' => '9.4184', 'postal_code' => '20248', 'name' => 'Rogliano'),
      array('lat' => '42.3096', 'lng' => '9.1492', 'postal_code' => '20250', 'name' => 'Corte'),
      array('lat' => '42.3264', 'lng' => '9.2214', 'postal_code' => '20250', 'name' => 'Santa-Lucia-di-Mercurio'),
      array('lat' => '42.2500', 'lng' => '9.1805', 'postal_code' => '20250', 'name' => 'Riventosa'),
      array('lat' => '42.3432', 'lng' => '9.2073', 'postal_code' => '20250', 'name' => 'Tralonca'),
      array('lat' => '42.2535', 'lng' => '9.1736', 'postal_code' => '20250', 'name' => 'Casanova'),
      array('lat' => '42.2497', 'lng' => '9.1703', 'postal_code' => '20250', 'name' => 'Santo-Pietro-di-Venaco'),
      array('lat' => '42.2574', 'lng' => '9.1867', 'postal_code' => '20250', 'name' => 'Poggio-di-Venaco'),
      array('lat' => '42.3588', 'lng' => '9.1662', 'postal_code' => '20250', 'name' => 'Soveria'),
      array('lat' => '42.2362', 'lng' => '9.2902', 'postal_code' => '20251', 'name' => 'Altiani'),
      array('lat' => '42.2162', 'lng' => '9.3662', 'postal_code' => '20251', 'name' => 'Giuncaggio'),
      array('lat' => '42.2341', 'lng' => '9.3276', 'postal_code' => '20251', 'name' => 'Piedicorte-di-Gaggio'),
      array('lat' => '42.2339', 'lng' => '9.3458', 'postal_code' => '20251', 'name' => 'Pietraserena'),
      array('lat' => '42.5286', 'lng' => '9.3178', 'postal_code' => '20252', 'name' => 'Campitello'),
      array('lat' => '42.5216', 'lng' => '9.2824', 'postal_code' => '20252', 'name' => 'Lento'),
      array('lat' => '42.5273', 'lng' => '9.2990', 'postal_code' => '20252', 'name' => 'Bigorno'),
      array('lat' => '42.7316', 'lng' => '9.3660', 'postal_code' => '20253', 'name' => 'Farinole'),
      array('lat' => '42.6897', 'lng' => '9.3779', 'postal_code' => '20253', 'name' => 'Barbaggio'),
      array('lat' => '42.6978', 'lng' => '9.3626', 'postal_code' => '20253', 'name' => 'Patrimonio'),
      array('lat' => '42.6144', 'lng' => '8.9066', 'postal_code' => '20256', 'name' => 'Corbara'),
      array('lat' => '42.5208', 'lng' => '9.0515', 'postal_code' => '20259', 'name' => 'Vallica'),
      array('lat' => '42.5201', 'lng' => '9.0083', 'postal_code' => '20259', 'name' => 'Mausoléo'),
      array('lat' => '42.5369', 'lng' => '8.9973', 'postal_code' => '20259', 'name' => 'Pioggiola'),
      array('lat' => '42.5288', 'lng' => '9.0159', 'postal_code' => '20259', 'name' => 'Olmi'),
      array('lat' => '42.5660', 'lng' => '8.7571', 'postal_code' => '20260', 'name' => 'Calvi'),
      array('lat' => '42.5789', 'lng' => '8.8337', 'postal_code' => '20260', 'name' => 'Lumio'),
      array('lat' => '42.5081', 'lng' => '8.8553', 'postal_code' => '20260', 'name' => 'Calenzana'),
      array('lat' => '42.2789', 'lng' => '9.4129', 'postal_code' => '20270', 'name' => 'Moïta'),
      array('lat' => '42.1429', 'lng' => '9.3617', 'postal_code' => '20270', 'name' => 'Casevecchie'),
      array('lat' => '42.1664', 'lng' => '9.3452', 'postal_code' => '20270', 'name' => 'Antisanti'),
      array('lat' => '42.2714', 'lng' => '9.4236', 'postal_code' => '20270', 'name' => 'Campi'),
      array('lat' => '42.2309', 'lng' => '9.4121', 'postal_code' => '20270', 'name' => 'Tallone'),
      array('lat' => '42.1024', 'lng' => '9.5158', 'postal_code' => '20270', 'name' => 'Aléria'),
      array('lat' => '42.2804', 'lng' => '9.3905', 'postal_code' => '20270', 'name' => 'Matra'),
      array('lat' => '42.1122', 'lng' => '9.4005', 'postal_code' => '20270', 'name' => 'Aghione'),
      array('lat' => '42.2183', 'lng' => '9.3719', 'postal_code' => '20270', 'name' => 'Pancheraccia'),
      array('lat' => '42.2516', 'lng' => '9.4313', 'postal_code' => '20270', 'name' => 'Tox'),
      array('lat' => '42.2606', 'lng' => '9.3754', 'postal_code' => '20272', 'name' => 'Zalana'),
      array('lat' => '42.2544', 'lng' => '9.3582', 'postal_code' => '20272', 'name' => 'Ampriani'),
      array('lat' => '42.2712', 'lng' => '9.3464', 'postal_code' => '20272', 'name' => 'Zuani'),
      array('lat' => '42.2910', 'lng' => '9.3604', 'postal_code' => '20272', 'name' => 'Pianello'),
      array('lat' => '42.9750', 'lng' => '9.3806', 'postal_code' => '20275', 'name' => 'Ersa'),
      array('lat' => '42.4540', 'lng' => '9.0338', 'postal_code' => '20276', 'name' => 'Asco'),
      array('lat' => '42.5656', 'lng' => '8.9859', 'postal_code' => '20279', 'name' => 'Ville-di-Paraso'),
      array('lat' => '42.9268', 'lng' => '9.4526', 'postal_code' => '20287', 'name' => 'Meria'),
      array('lat' => '42.4678', 'lng' => '9.3896', 'postal_code' => '20290', 'name' => 'Monte'),
      array('lat' => '42.4573', 'lng' => '9.3433', 'postal_code' => '20290', 'name' => 'Ortiporio'),
      array('lat' => '42.5266', 'lng' => '9.3556', 'postal_code' => '20290', 'name' => 'Volpajola'),
      array('lat' => '42.5038', 'lng' => '9.4024', 'postal_code' => '20290', 'name' => 'Prunelli-di-Casacconi'),
      array('lat' => '42.4684', 'lng' => '9.3524', 'postal_code' => '20290', 'name' => 'Crocicchia'),
      array('lat' => '42.5309', 'lng' => '9.3628', 'postal_code' => '20290', 'name' => 'Scolca'),
      array('lat' => '42.4925', 'lng' => '9.3534', 'postal_code' => '20290', 'name' => 'Campile'),
      array('lat' => '42.5389', 'lng' => '9.3822', 'postal_code' => '20290', 'name' => 'Vignale'),
      array('lat' => '42.4616', 'lng' => '9.3740', 'postal_code' => '20290', 'name' => 'Penta'),
      array('lat' => '42.5461', 'lng' => '9.4186', 'postal_code' => '20290', 'name' => 'Lucciana'),
      array('lat' => '42.4957', 'lng' => '9.4070', 'postal_code' => '20290', 'name' => 'Olmo'),
      array('lat' => '42.5549', 'lng' => '9.4264', 'postal_code' => '20290', 'name' => 'Borgo'),
      array('lat' => '42.6585', 'lng' => '9.4145', 'postal_code' => '20600', 'name' => 'Furiani'),
      array('lat' => '42.7028', 'lng' => '9.4500', 'postal_code' => '20611 CEDEX', 'name' => 'Bastia'),
      array('lat' => '42.6269', 'lng' => '9.4202', 'postal_code' => '20620', 'name' => 'Biguglia'),
    ],
    'IDF' => [

      array('postal_code' => '75009', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75005', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75018', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75020', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75004', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75011', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75036 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75016', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75015', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75006', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75019', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75017', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75012', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75003', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75024 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75016', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75005', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75029 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75010', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => 'CEDEX 01 75021', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75010', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75014', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75008', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75030 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75013', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75001', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75002', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75023 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75018', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75033 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75007', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75047 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75009', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75003', 'name' => 'Paris 03', 'lat' => '48.8637', 'lng' => '2.3615'),
      array('postal_code' => '75015', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75002', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75008', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75011', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75026 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75014', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75019', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75041 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75032 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75058 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75035 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75007', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75001', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75020', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75053 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75004', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75012', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75028 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75013', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75006', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75000', 'name' => 'Paris', 'lat' => '48.8534', 'lng' => '2.3488'),
      array('postal_code' => '75017', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75045 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75064 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75031 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75046 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75048 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75060 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75034 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75038 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75042 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75054 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75084 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75061 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75074 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75065 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75051 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75043 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75044 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75063 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75056 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75067 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75062 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75086 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75076 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75087 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75077 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75055 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75049 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75082 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75068 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75079 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75059 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75083 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75078 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75088 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75080 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75040 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75081 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75069 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75075 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75039 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75073 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75052 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75066 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75072 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75085 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75093 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75092 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75090 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75089 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75095 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75102 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75097 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75094 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75113 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75103 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75108 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75111 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75101 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75109 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75105 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75096 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75106 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75104 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75100 CEDEX 01', 'name' => 'Paris 01', 'lat' => '48.8592', 'lng' => '2.3417'),
      array('postal_code' => '75112 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75114 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75110 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75107 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75115 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75127 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75129 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75116', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75128 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75122 CEDEX 03', 'name' => 'Paris 03', 'lat' => '48.8637', 'lng' => '2.3615'),
      array('postal_code' => '75118 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75119 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75120 CEDEX 02', 'name' => 'Paris 02', 'lat' => '48.8655', 'lng' => '2.3426'),
      array('postal_code' => '75126 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75139 CEDEX 03', 'name' => 'Paris 03', 'lat' => '48.8637', 'lng' => '2.3615'),
      array('postal_code' => '75130 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75134 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75124 CEDEX 03', 'name' => 'Paris 03', 'lat' => '48.8637', 'lng' => '2.3615'),
      array('postal_code' => '75123 CEDEX 03', 'name' => 'Paris 03', 'lat' => '48.8637', 'lng' => '2.3615'),
      array('postal_code' => '75131 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75125 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75138 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75140 CEDEX 03', 'name' => 'Paris 03', 'lat' => '48.8637', 'lng' => '2.3615'),
      array('postal_code' => '75157 CEDEX 03', 'name' => 'Paris 03', 'lat' => '48.8637', 'lng' => '2.3615'),
      array('postal_code' => '75144 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75141 CEDEX 03', 'name' => 'Paris 03', 'lat' => '48.8637', 'lng' => '2.3615'),
      array('postal_code' => '75151 CEDEX 03', 'name' => 'Paris 03', 'lat' => '48.8637', 'lng' => '2.3615'),
      array('postal_code' => '75158 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75163 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75154 CEDEX 03', 'name' => 'Paris 03', 'lat' => '48.8637', 'lng' => '2.3615'),
      array('postal_code' => '75159 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75161 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75165 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75152 CEDEX 03', 'name' => 'Paris 03', 'lat' => '48.8637', 'lng' => '2.3615'),
      array('postal_code' => '75156 CEDEX 03', 'name' => 'Paris 03', 'lat' => '48.8637', 'lng' => '2.3615'),
      array('postal_code' => '75142 CEDEX 03', 'name' => 'Paris 03', 'lat' => '48.8637', 'lng' => '2.3615'),
      array('postal_code' => '75162 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75153 CEDEX 03', 'name' => 'Paris 03', 'lat' => '48.8637', 'lng' => '2.3615'),
      array('postal_code' => '75164 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75168 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75150 CEDEX 03', 'name' => 'Paris 03', 'lat' => '48.8637', 'lng' => '2.3615'),
      array('postal_code' => '75166 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75155 CEDEX 03', 'name' => 'Paris 03', 'lat' => '48.8637', 'lng' => '2.3615'),
      array('postal_code' => '75170 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75174 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75167 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75169 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75181 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75197 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75177 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75184 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75180 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75189 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75196 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75192 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75198 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75188 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75179 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75171 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75182 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75176 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75172 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75191 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75194 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75208 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75186 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75203 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75205 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75195 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75206 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75207 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75213 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75204 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75202 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75201 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75210 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75211 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75209 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75214 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75215 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75212 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75216 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75218 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75230 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75231 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75221 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75220 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75219 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75223 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75228 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75224 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75217 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75226 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75227 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75229 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75222 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75235 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75244 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75234 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75232 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75239 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75248 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75237 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75233 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75250 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75252 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75253 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75238 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75243 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75236 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75241 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75240 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75270 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75278 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75256 CEDEX 05', 'name' => 'Paris 05', 'lat' => '48.8448', 'lng' => '2.3471'),
      array('postal_code' => '75279 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75261 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75269 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75260 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75264 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75284 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75266 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75282 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75263 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75265 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75281 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75272 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75280 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75262 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75275 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75299 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75294 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75288 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75290 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75283 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75291 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75292 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75302 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75298 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75315 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75314 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75295 CEDEX 06', 'name' => 'Paris 06', 'lat' => '48.8493', 'lng' => '2.3300'),
      array('postal_code' => '75333 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75327 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75335 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75306 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75307 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75317 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75309 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75308 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75318 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75323 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75320 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75303 SP 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75305 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75312 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75319 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75304 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75342 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75325 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75311 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75313 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75321 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75328 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75324 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75310 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75322 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75326 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75341 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75338 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75330 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75337 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75329 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75348 SP 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75340 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75349 SP 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75339 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75345 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75344 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75350 SP 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75343 CEDEX 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75352 SP 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75363 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75357 SP 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75353 SP 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75355 SP 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75356 SP 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75366 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75358 SP 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75364 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75362 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75361 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75359 SP 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75365 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75360 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75367 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75370 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75375 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75385 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75373 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75374 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75379 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75381 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75372 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75371 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75380 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75376 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75382 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75378 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75384 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75386 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75383 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75390 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75392 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75397 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75391 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75388 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75387 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75389 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75394 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75402 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75408 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75399 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75410 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75405 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75411 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75403 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75415 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75398 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75396 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75400 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75395 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75417 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75420 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75422 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75416 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75412 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75421 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75430 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75401 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75407 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75442 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75418 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75457 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75427 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75426 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75458 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75413 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75431 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75425 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75419 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75423 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75428 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75454 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75406 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75444 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75434 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75437 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75453 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75436 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75449 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75438 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75432 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75446 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75459 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75439 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75443 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75441 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75424 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75447 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75452 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75429 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75435 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75451 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75440 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75456 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75455 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75450 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75445 CEDEX 09', 'name' => 'Paris 09', 'lat' => '48.8718', 'lng' => '2.3399'),
      array('postal_code' => '75460 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75462 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75463 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75477 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75474 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75480 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75465 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75464 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75466 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75468 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75470 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75484 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75486 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75475 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75472 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75467 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75476 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75478 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75491 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75471 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75473 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75479 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75488 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75487 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75490 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75483 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75482 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75485 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75493 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75481 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75492 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75511 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75505 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75497 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75522 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75502 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75525 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75504 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75495 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75498 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75527 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75512 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75538 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75535 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75507 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75496 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75506 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75503 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75536 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75508 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75524 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75510 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75509 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75499 CEDEX 10', 'name' => 'Paris 10', 'lat' => '48.8709', 'lng' => '2.3561'),
      array('postal_code' => '75528 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75537 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75526 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75534 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75521 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75523 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75533 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75543 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75545 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75540 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75557 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75546 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75561 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75569 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75553 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75547 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75568 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75554 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75564 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75542 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75550 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75555 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75548 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75541 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75558 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75551 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75566 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75560 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75544 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75571 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75556 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75563 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75567 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75562 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75552 CEDEX 11', 'name' => 'Paris 11', 'lat' => '48.8574', 'lng' => '2.3795'),
      array('postal_code' => '75570 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75565 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75574 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75573 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75579 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75577 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75576 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75578 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75572 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75575 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75580 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75581 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75582 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75583 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75598 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75588 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75596 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75603 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75597 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75600 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75584 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75594 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75586 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75601 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75589 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75591 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75599 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75593 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75595 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75587 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75585 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75592 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75602 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75614 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75621 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75607 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75609 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75617 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75608 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75624 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75630 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75616 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75610 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75604 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75623 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75605 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75613 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75622 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75620 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75618 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75611 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75606 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75627 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75631 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75612 CEDEX 12', 'name' => 'Paris 12', 'lat' => '48.8412', 'lng' => '2.3876'),
      array('postal_code' => '75629 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75619 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75626 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75625 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75632 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75635 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75628 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75637 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75642 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75641 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75636 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75640 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75638 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75634 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75633 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75639 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75655 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75644 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75647 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75646 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75657 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75648 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75653 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75652 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75643 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75654 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75662 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75658 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75650 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75651 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75649 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75656 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75668 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75675 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75661 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75678 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75669 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75674 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75673 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75659 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75660 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75670 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75679 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75667 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75663 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75665 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75680 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75681 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75671 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75687 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75664 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75685 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75682 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75677 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75688 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75683 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75689 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75690 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75691 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75697 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75699 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75698 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75696 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75694 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75693 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75692 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75701 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75713 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75710 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75703 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75700 SP 07', 'name' => 'Paris 07', 'lat' => '48.8565', 'lng' => '2.3210'),
      array('postal_code' => '75709 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75707 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75705 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75719 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75706 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75702 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75717 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75723 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75718 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75729 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75708 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75716 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75712 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75715 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75720 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75722 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75726 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75714 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75721 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75727 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75724 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75732 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75725 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75731 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75730 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75737 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75750 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75763 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75742 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75741 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75759 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75739 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75761 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75734 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75749 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75740 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75762 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75748 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75756 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75754 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75743 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75747 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75757 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75753 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75745 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75768 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75766 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75738 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75755 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75780 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75770 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75786 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75785 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75771 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75769 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75764 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75781 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75765 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75775 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75773 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75772 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75782 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75794 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75799 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75803 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75767 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75784 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75778 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75783 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75789 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75796 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75798 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75790 CEDEX 16', 'name' => 'Paris 16', 'lat' => '48.8637', 'lng' => '2.2769'),
      array('postal_code' => '75805 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75812 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75804 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75800 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75808 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75809 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75819 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75802 CEDEX 08', 'name' => 'Paris 08', 'lat' => '48.8763', 'lng' => '2.3183'),
      array('postal_code' => '75817 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75806 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75813 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75807 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75815 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75818 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75820 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75824 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75829 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75837 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75835 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75839 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75828 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75821 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75823 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75825 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75833 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75822 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75843 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75834 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75827 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75831 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75838 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75826 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75841 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75830 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75850 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75836 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75832 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75844 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75840 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75845 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75857 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75853 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75847 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75848 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75862 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75861 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75855 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75849 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75867 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75854 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75846 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75851 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75852 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75860 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75865 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75858 CEDEX 17', 'name' => 'Paris 17', 'lat' => '48.8835', 'lng' => '2.3219'),
      array('postal_code' => '75866 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75863 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75864 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75872 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75883 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75876 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75869 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75870 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75887 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75868 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75892 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75890 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75874 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75880 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75871 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75881 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75895 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75886 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75877 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75898 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75893 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75875 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75900 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75882 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75891 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75878 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75889 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75903 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75884 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75879 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75894 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75905 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75885 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75899 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75904 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75909 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75916 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75901 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75921 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75897 CEDEX 18', 'name' => 'Paris 18', 'lat' => '48.8925', 'lng' => '2.3444'),
      array('postal_code' => '75913 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75917 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75923 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75914 CEDEX 13', 'name' => 'Paris 13', 'lat' => '48.8322', 'lng' => '2.3561'),
      array('postal_code' => '75902 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75908 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75918 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75907 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75911 CEDEX 15', 'name' => 'Paris 15', 'lat' => '48.8412', 'lng' => '2.3003'),
      array('postal_code' => '75922 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75925 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75924 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75927 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75915 CEDEX 04', 'name' => 'Paris 04', 'lat' => '48.8601', 'lng' => '2.3507'),
      array('postal_code' => '75920 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75926 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75928 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75919 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75929 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75931 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75930 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75933 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75935 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75958 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75943 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75942 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75956 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75938 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75941 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75932 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75948 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75940 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75981 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75965 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75960 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75961 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75937 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75947 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75936 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75969 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75934 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75971 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75939 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75951 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75953 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75952 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75979 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75976 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75950 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75945 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75967 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75944 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75946 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75966 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75959 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75955 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75957 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75962 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75974 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75978 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75980 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75949 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75970 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75954 CEDEX 19', 'name' => 'Paris 19', 'lat' => '48.8817', 'lng' => '2.3822'),
      array('postal_code' => '75972 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75975 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75973 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75987 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75983 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '77002 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77011 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77010 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '75986 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '77001 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '75988 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75995 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75985 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75984 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75996 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75993 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75990 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75977 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75989 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '75997 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75991 CEDEX 20', 'name' => 'Paris 20', 'lat' => '48.8646', 'lng' => '2.3984'),
      array('postal_code' => '77000', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77016 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77008 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77005 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77009 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '75994 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '75998 CEDEX 14', 'name' => 'Paris 14', 'lat' => '48.8331', 'lng' => '2.3264'),
      array('postal_code' => '77006 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77000', 'name' => 'Livry-sur-Seine', 'lat' => '48.5177', 'lng' => '2.6788'),
      array('postal_code' => '77000', 'name' => 'Vaux-le-P_nil', 'lat' => '48.5280', 'lng' => '2.6917'),
      array('postal_code' => '77004 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77000', 'name' => 'La Rochette', 'lat' => '48.5088', 'lng' => '2.6636'),
      array('postal_code' => '77003 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77014 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77021 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77020 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77013 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77015 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77028 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77018 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77007 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77012 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77019 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77017 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77026 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77025 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77027 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77040 CEDEX 9', 'name' => 'Lognes', 'lat' => '48.8354', 'lng' => '2.6300'),
      array('postal_code' => '77041 CEDEX 9', 'name' => 'Lognes', 'lat' => '48.8354', 'lng' => '2.6300'),
      array('postal_code' => '77042 CEDEX 9', 'name' => 'Lognes', 'lat' => '48.8354', 'lng' => '2.6300'),
      array('postal_code' => '77024 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77023 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77039 CEDEX 9', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77043 CEDEX 9', 'name' => 'Lognes', 'lat' => '48.8354', 'lng' => '2.6300'),
      array('postal_code' => '77051 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77050 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77101 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77111', 'name' => 'Soignolles-en-Brie', 'lat' => '48.6535', 'lng' => '2.6997'),
      array('postal_code' => '77112 CEDEX', 'name' => 'Roissy-en-Brie', 'lat' => '48.7916', 'lng' => '2.6475'),
      array('postal_code' => '77109 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77114', 'name' => 'Herm_', 'lat' => '48.4844', 'lng' => '3.3463'),
      array('postal_code' => '77104 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77105 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77118', 'name' => 'Balloy', 'lat' => '48.3974', 'lng' => '3.1468'),
      array('postal_code' => '77102 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77108 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77106 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77100', 'name' => 'Nanteuil-l�s-Meaux', 'lat' => '48.9294', 'lng' => '2.8959'),
      array('postal_code' => '77052 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77114', 'name' => 'Noyen-sur-Seine', 'lat' => '48.4529', 'lng' => '3.3509'),
      array('postal_code' => '77100', 'name' => 'Mareuil-l�s-Meaux', 'lat' => '48.9265', 'lng' => '2.8613'),
      array('postal_code' => '77090', 'name' => 'Coll_gien', 'lat' => '48.8357', 'lng' => '2.6736'),
      array('postal_code' => '77113 CEDEX', 'name' => 'Roissy-en-Brie', 'lat' => '48.7916', 'lng' => '2.6475'),
      array('postal_code' => '77118', 'name' => 'Bazoches-l�s-Bray', 'lat' => '48.3987', 'lng' => '3.1883'),
      array('postal_code' => '77115', 'name' => 'Sivry-Courtry', 'lat' => '48.5283', 'lng' => '2.7546'),
      array('postal_code' => '77114', 'name' => 'Villiers-sur-Seine', 'lat' => '48.4552', 'lng' => '3.3761'),
      array('postal_code' => '77114', 'name' => 'Gouaix', 'lat' => '48.4854', 'lng' => '3.2934'),
      array('postal_code' => '77100', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77103 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77111', 'name' => 'Solers', 'lat' => '48.6592', 'lng' => '2.7162'),
      array('postal_code' => '77115', 'name' => 'Blandy', 'lat' => '48.5672', 'lng' => '2.7818'),
      array('postal_code' => '77107 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77110 CEDEX', 'name' => 'Melun', 'lat' => '48.5457', 'lng' => '2.6536'),
      array('postal_code' => '77120', 'name' => 'Coulommiers', 'lat' => '48.8145', 'lng' => '3.0850'),
      array('postal_code' => '77120', 'name' => 'Beautheil', 'lat' => '48.7631', 'lng' => '3.0874'),
      array('postal_code' => '77123', 'name' => 'Le Vaudou_', 'lat' => '48.3570', 'lng' => '2.5184'),
      array('postal_code' => '77120', 'name' => 'Mauperthuis', 'lat' => '48.7682', 'lng' => '3.0387'),
      array('postal_code' => '77120', 'name' => 'Chailly-en-Brie', 'lat' => '48.7901', 'lng' => '3.1245'),
      array('postal_code' => '77118', 'name' => 'Gravon', 'lat' => '48.4004', 'lng' => '3.1189'),
      array('postal_code' => '77120', 'name' => 'Aulnoy', 'lat' => '48.8410', 'lng' => '3.0967'),
      array('postal_code' => '77120', 'name' => 'Marolles-en-Brie', 'lat' => '48.7767', 'lng' => '3.1634'),
      array('postal_code' => '77120', 'name' => 'Saints', 'lat' => '48.7607', 'lng' => '3.0464'),
      array('postal_code' => '77122', 'name' => 'Monthyon', 'lat' => '49.0075', 'lng' => '2.8261'),
      array('postal_code' => '77120', 'name' => 'Amillis', 'lat' => '48.7408', 'lng' => '3.1289'),
      array('postal_code' => '77123', 'name' => 'Tousson', 'lat' => '48.3467', 'lng' => '2.4592'),
      array('postal_code' => '77123', 'name' => 'Noisy-sur-�cole', 'lat' => '48.3670', 'lng' => '2.5080'),
      array('postal_code' => '77120', 'name' => 'Giremoutiers', 'lat' => '48.8421', 'lng' => '3.0293'),
      array('postal_code' => '77120', 'name' => 'Mouroux', 'lat' => '48.8226', 'lng' => '3.0388'),
      array('postal_code' => '77130', 'name' => 'Barbey', 'lat' => '48.3666', 'lng' => '3.0541'),
      array('postal_code' => '77124', 'name' => 'Penchard', 'lat' => '48.9865', 'lng' => '2.8610'),
      array('postal_code' => '77124', 'name' => 'Chauconin-Neufmontiers', 'lat' => '48.9667', 'lng' => '2.8500'),
      array('postal_code' => '77124', 'name' => 'Villenoy', 'lat' => '48.9411', 'lng' => '2.8602'),
      array('postal_code' => '77130', 'name' => 'Ville-Saint-Jacques', 'lat' => '48.3430', 'lng' => '2.8987'),
      array('postal_code' => '77134', 'name' => 'Les Ormes-sur-Voulzie', 'lat' => '48.4636', 'lng' => '3.2296'),
      array('postal_code' => '77127', 'name' => 'Lieusaint', 'lat' => '48.6348', 'lng' => '2.5481'),
      array('postal_code' => '77130', 'name' => 'Varennes-sur-Seine', 'lat' => '48.3730', 'lng' => '2.9257'),
      array('postal_code' => '77130', 'name' => 'Saint-Germain-Laval', 'lat' => '48.3997', 'lng' => '2.9978'),
      array('postal_code' => '77126', 'name' => 'Ch_tenay-sur-Seine', 'lat' => '48.4184', 'lng' => '3.0947'),
      array('postal_code' => '77126', 'name' => '�gligny', 'lat' => '48.4272', 'lng' => '3.1198'),
      array('postal_code' => '77124', 'name' => 'Cr_gy-l�s-Meaux', 'lat' => '48.9765', 'lng' => '2.8748'),
      array('postal_code' => '77126', 'name' => 'Courcelles-en-Bass_e', 'lat' => '48.4106', 'lng' => '3.0545'),
      array('postal_code' => '77130', 'name' => 'Forges', 'lat' => '48.4195', 'lng' => '2.9603'),
      array('postal_code' => '77130', 'name' => 'Misy-sur-Yonne', 'lat' => '48.3607', 'lng' => '3.0898'),
      array('postal_code' => '77130', 'name' => 'La Tombe', 'lat' => '48.3877', 'lng' => '3.0871'),
      array('postal_code' => '77130', 'name' => 'Cannes-�cluse', 'lat' => '48.3630', 'lng' => '2.9875'),
      array('postal_code' => '77130', 'name' => 'Montereau-Fault-Yonne', 'lat' => '48.3833', 'lng' => '2.9500'),
      array('postal_code' => '77130', 'name' => 'La Grande-Paroisse', 'lat' => '48.3868', 'lng' => '2.9016'),
      array('postal_code' => '77130', 'name' => 'Marolles-sur-Seine', 'lat' => '48.3866', 'lng' => '3.0356'),
      array('postal_code' => '77139', 'name' => '�tr_pilly', 'lat' => '49.0349', 'lng' => '2.9313'),
      array('postal_code' => '77131', 'name' => 'P_zarches', 'lat' => '48.7371', 'lng' => '2.9922'),
      array('postal_code' => '77130', 'name' => 'Dormelles', 'lat' => '48.3148', 'lng' => '2.8992'),
      array('postal_code' => '77144', 'name' => 'Chalifert', 'lat' => '48.8899', 'lng' => '2.7734'),
      array('postal_code' => '77133', 'name' => 'F_ricy', 'lat' => '48.4604', 'lng' => '2.8008'),
      array('postal_code' => '77140', 'name' => 'Nonville', 'lat' => '48.2825', 'lng' => '2.7931'),
      array('postal_code' => '77133', 'name' => 'Machault', 'lat' => '48.4555', 'lng' => '2.8314'),
      array('postal_code' => '77138', 'name' => 'Luzancy', 'lat' => '48.9725', 'lng' => '3.1821'),
      array('postal_code' => '77150', 'name' => 'L_signy', 'lat' => '48.7437', 'lng' => '2.6152'),
      array('postal_code' => '77160', 'name' => 'Provins', 'lat' => '48.5500', 'lng' => '3.3000'),
      array('postal_code' => '77139', 'name' => 'Marcilly', 'lat' => '49.0365', 'lng' => '2.8780'),
      array('postal_code' => '77139', 'name' => 'Douy-la-Ram_e', 'lat' => '49.0667', 'lng' => '2.8833'),
      array('postal_code' => '77139', 'name' => 'Puisieux', 'lat' => '49.0667', 'lng' => '2.9167'),
      array('postal_code' => '77141', 'name' => 'Vaudoy-en-Brie', 'lat' => '48.6888', 'lng' => '3.0800'),
      array('postal_code' => '77139', 'name' => 'Vincy-Man�uvre', 'lat' => '49.0833', 'lng' => '2.9667'),
      array('postal_code' => '77148', 'name' => 'Salins', 'lat' => '48.4216', 'lng' => '3.0213'),
      array('postal_code' => '77140', 'name' => 'Nemours', 'lat' => '48.2751', 'lng' => '2.6908'),
      array('postal_code' => '77150', 'name' => 'F_rolles-Attilly', 'lat' => '48.7318', 'lng' => '2.6309'),
      array('postal_code' => '77140', 'name' => 'Saint-Pierre-l�s-Nemours', 'lat' => '48.2673', 'lng' => '2.6797'),
      array('postal_code' => '77131', 'name' => 'Touquin', 'lat' => '48.7350', 'lng' => '3.0122'),
      array('postal_code' => '77135', 'name' => 'Pontcarr_', 'lat' => '48.7977', 'lng' => '2.7051'),
      array('postal_code' => '77160', 'name' => 'Poigny', 'lat' => '48.5402', 'lng' => '3.2838'),
      array('postal_code' => '77145', 'name' => 'May-en-Multien', 'lat' => '49.0723', 'lng' => '3.0233'),
      array('postal_code' => '77144', 'name' => 'Mont_vrain', 'lat' => '48.8742', 'lng' => '2.7511'),
      array('postal_code' => '77140', 'name' => 'Darvault', 'lat' => '48.2697', 'lng' => '2.7308'),
      array('postal_code' => '77140', 'name' => 'Montcourt-Fromonville', 'lat' => '48.3067', 'lng' => '2.7046'),
      array('postal_code' => '77151', 'name' => 'Montceaux-l�s-Provins', 'lat' => '48.6942', 'lng' => '3.4394'),
      array('postal_code' => '77148', 'name' => 'Laval-en-Brie', 'lat' => '48.4256', 'lng' => '2.9970'),
      array('postal_code' => '77160', 'name' => 'Vulaines-l�s-Provins', 'lat' => '48.5601', 'lng' => '3.2195'),
      array('postal_code' => '77157', 'name' => 'Everly', 'lat' => '48.4667', 'lng' => '3.2500'),
      array('postal_code' => '77160', 'name' => 'Cucharmoy', 'lat' => '48.5829', 'lng' => '3.1934'),
      array('postal_code' => '77154', 'name' => 'Couten�on', 'lat' => '48.4713', 'lng' => '2.9959'),
      array('postal_code' => '77154', 'name' => 'Villeneuve-les-Bordes', 'lat' => '48.4831', 'lng' => '3.0492'),
      array('postal_code' => '77160', 'name' => 'Mortery', 'lat' => '48.5996', 'lng' => '3.2612'),
      array('postal_code' => '77160', 'name' => 'La Chapelle-Saint-Sulpice', 'lat' => '48.5543', 'lng' => '3.1786'),
      array('postal_code' => '77160', 'name' => 'Saint-Hilliers', 'lat' => '48.6214', 'lng' => '3.2577'),
      array('postal_code' => '77160', 'name' => 'Saint-Brice', 'lat' => '48.5676', 'lng' => '3.3241'),
      array('postal_code' => '77165', 'name' => 'Cuisy', 'lat' => '49.0198', 'lng' => '2.7731'),
      array('postal_code' => '77165', 'name' => 'Forfry', 'lat' => '49.0572', 'lng' => '2.8481'),
      array('postal_code' => '77165', 'name' => 'Saint-Soupplets', 'lat' => '49.0387', 'lng' => '2.8072'),
      array('postal_code' => '77165', 'name' => 'Le Plessis-aux-Bois', 'lat' => '49.0033', 'lng' => '2.7691'),
      array('postal_code' => '77160', 'name' => 'Rouilly', 'lat' => '48.5918', 'lng' => '3.2777'),
      array('postal_code' => '77169', 'name' => 'Boissy-le-Ch_tel', 'lat' => '48.8207', 'lng' => '3.1365'),
      array('postal_code' => '77165', 'name' => 'Gesvres-le-Chapitre', 'lat' => '49.0440', 'lng' => '2.8518'),
      array('postal_code' => '77167', 'name' => 'Ormesson', 'lat' => '48.2444', 'lng' => '2.6541'),
      array('postal_code' => '77163', 'name' => 'Mortcerf', 'lat' => '48.7888', 'lng' => '2.9169'),
      array('postal_code' => '77164', 'name' => 'Ferri�res-en-Brie', 'lat' => '48.8235', 'lng' => '2.7066'),
      array('postal_code' => '77165', 'name' => 'Iverny', 'lat' => '49.0010', 'lng' => '2.7893'),
      array('postal_code' => '77160', 'name' => 'Chalautre-la-Petite', 'lat' => '48.5294', 'lng' => '3.3122'),
      array('postal_code' => '77169', 'name' => 'Chauffry', 'lat' => '48.8113', 'lng' => '3.1813'),
      array('postal_code' => '77169', 'name' => 'Saint-Sim_on', 'lat' => '48.7986', 'lng' => '3.2032'),
      array('postal_code' => '77170', 'name' => 'Servon', 'lat' => '48.7166', 'lng' => '2.5874'),
      array('postal_code' => '77166', 'name' => 'Grisy-Suisnes', 'lat' => '48.6854', 'lng' => '2.6678'),
      array('postal_code' => '77169', 'name' => 'Saint-Germain-sous-Doue', 'lat' => '48.8508', 'lng' => '3.1444'),
      array('postal_code' => '77163', 'name' => 'Dammartin-sur-Tigeaux', 'lat' => '48.8193', 'lng' => '2.9191'),
      array('postal_code' => '77167', 'name' => 'Fa�-l�s-Nemours', 'lat' => '48.2333', 'lng' => '2.6667'),
      array('postal_code' => '77160', 'name' => 'Chenoise', 'lat' => '48.6146', 'lng' => '3.1946'),
      array('postal_code' => '77165', 'name' => 'Le Plessis-l\'�v�que', 'lat' => '49.0000', 'lng' => '2.7833'),
      array('postal_code' => '77163', 'name' => 'Tigeaux', 'lat' => '48.8257', 'lng' => '2.9022'),
      array('postal_code' => '77166', 'name' => '�vry-Gr_gy-sur-Yerre', 'lat' => '48.6667', 'lng' => '2.6167'),
      array('postal_code' => '77167', 'name' => 'Poligny', 'lat' => '48.2242', 'lng' => '2.7445'),
      array('postal_code' => '77167', 'name' => 'Ch_tenoy', 'lat' => '48.2341', 'lng' => '2.6262'),
      array('postal_code' => '77170', 'name' => 'Coubert', 'lat' => '48.6719', 'lng' => '2.6973'),
      array('postal_code' => '77167', 'name' => 'Bagneaux-sur-Loing', 'lat' => '48.2331', 'lng' => '2.7067'),
      array('postal_code' => '77173', 'name' => 'Chevry-Cossigny', 'lat' => '48.7246', 'lng' => '2.6611'),
      array('postal_code' => '77184', 'name' => '�merainville', 'lat' => '48.8128', 'lng' => '2.6214'),
      array('postal_code' => '77170', 'name' => 'Brie-Comte-Robert', 'lat' => '48.6925', 'lng' => '2.6109'),
      array('postal_code' => '77176', 'name' => 'Savigny-le-Temple', 'lat' => '48.5741', 'lng' => '2.5829'),
      array('postal_code' => '77181', 'name' => 'Le Pin', 'lat' => '48.9152', 'lng' => '2.6284'),
      array('postal_code' => '77183', 'name' => 'Croissy-Beaubourg', 'lat' => '48.8283', 'lng' => '2.6696'),
      array('postal_code' => '77171', 'name' => 'L_chelle', 'lat' => '48.5781', 'lng' => '3.3880'),
      array('postal_code' => '77174', 'name' => 'Villeneuve-le-Comte', 'lat' => '48.8141', 'lng' => '2.8295'),
      array('postal_code' => '77171', 'name' => 'Melz-sur-Seine', 'lat' => '48.4982', 'lng' => '3.4177'),
      array('postal_code' => '77190', 'name' => 'Villiers-en-Bi�re', 'lat' => '48.4940', 'lng' => '2.5983'),
      array('postal_code' => '77178', 'name' => 'Oissery', 'lat' => '49.0705', 'lng' => '2.8182'),
      array('postal_code' => '77171', 'name' => 'Chalautre-la-Grande', 'lat' => '48.5417', 'lng' => '3.4603'),
      array('postal_code' => '77190', 'name' => 'Dammarie-les-Lys', 'lat' => '48.5167', 'lng' => '2.6500'),
      array('postal_code' => '77195 CEDEX', 'name' => 'Dammarie-les-Lys', 'lat' => '48.5167', 'lng' => '2.6500'),
      array('postal_code' => '77171', 'name' => 'Sourdun', 'lat' => '48.5369', 'lng' => '3.3520'),
      array('postal_code' => '77186', 'name' => 'Noisiel', 'lat' => '48.8487', 'lng' => '2.6243'),
      array('postal_code' => '77178', 'name' => 'Saint-Pathus', 'lat' => '49.0714', 'lng' => '2.7989'),
      array('postal_code' => '77177', 'name' => 'Brou-sur-Chantereine', 'lat' => '48.8833', 'lng' => '2.6333'),
      array('postal_code' => '77193 CEDEX', 'name' => 'Dammarie-les-Lys', 'lat' => '48.5167', 'lng' => '2.6500'),
      array('postal_code' => '77174', 'name' => 'Villeneuve-Saint-Denis', 'lat' => '48.8158', 'lng' => '2.7935'),
      array('postal_code' => '77176', 'name' => 'Nandy', 'lat' => '48.5830', 'lng' => '2.5629'),
      array('postal_code' => '77181', 'name' => 'Courtry', 'lat' => '48.9191', 'lng' => '2.6043'),
      array('postal_code' => '77191 CEDEX', 'name' => 'Dammarie-les-Lys', 'lat' => '48.5167', 'lng' => '2.6500'),
      array('postal_code' => '77185', 'name' => 'Lognes', 'lat' => '48.8354', 'lng' => '2.6300'),
      array('postal_code' => '77187 CEDEX', 'name' => 'Dammarie-les-Lys', 'lat' => '48.5167', 'lng' => '2.6500'),
      array('postal_code' => '77206 CEDEX 1', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77214 CEDEX', 'name' => 'Avon', 'lat' => '48.4022', 'lng' => '2.7202'),
      array('postal_code' => '77201 CEDEX 1', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77197 CEDEX', 'name' => 'Dammarie-les-Lys', 'lat' => '48.5167', 'lng' => '2.6500'),
      array('postal_code' => '77210', 'name' => 'Avon', 'lat' => '48.4022', 'lng' => '2.7202'),
      array('postal_code' => '77213 CEDEX', 'name' => 'Avon', 'lat' => '48.4022', 'lng' => '2.7202'),
      array('postal_code' => '77203 CEDEX 1', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77204 CEDEX 1', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77205 CEDEX 1', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77200', 'name' => 'Torcy', 'lat' => '48.8500', 'lng' => '2.6500'),
      array('postal_code' => '77194 CEDEX', 'name' => 'Dammarie-les-Lys', 'lat' => '48.5167', 'lng' => '2.6500'),
      array('postal_code' => '77198 CEDEX', 'name' => 'Dammarie-les-Lys', 'lat' => '48.5167', 'lng' => '2.6500'),
      array('postal_code' => '77192 CEDEX', 'name' => 'Dammarie-les-Lys', 'lat' => '48.5167', 'lng' => '2.6500'),
      array('postal_code' => '77207 CEDEX 1', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77196 CEDEX', 'name' => 'Dammarie-les-Lys', 'lat' => '48.5167', 'lng' => '2.6500'),
      array('postal_code' => '77202 CEDEX 1', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77210', 'name' => 'Samoreau', 'lat' => '48.4295', 'lng' => '2.7559'),
      array('postal_code' => '77199 CEDEX', 'name' => 'Dammarie-les-Lys', 'lat' => '48.5167', 'lng' => '2.6500'),
      array('postal_code' => '77209 CEDEX 1', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77208 CEDEX 1', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77215 CEDEX', 'name' => 'Avon', 'lat' => '48.4022', 'lng' => '2.7202'),
      array('postal_code' => '77219 CEDEX', 'name' => 'Avon', 'lat' => '48.4022', 'lng' => '2.7202'),
      array('postal_code' => '77211 CEDEX', 'name' => 'Avon', 'lat' => '48.4022', 'lng' => '2.7202'),
      array('postal_code' => '77212 CEDEX', 'name' => 'Avon', 'lat' => '48.4022', 'lng' => '2.7202'),
      array('postal_code' => '77217 CEDEX', 'name' => 'Avon', 'lat' => '48.4022', 'lng' => '2.7202'),
      array('postal_code' => '77230', 'name' => 'Dammartin-en-Go�le', 'lat' => '49.0542', 'lng' => '2.6778'),
      array('postal_code' => '77225 CEDEX', 'name' => 'Tournan-en-Brie', 'lat' => '48.7415', 'lng' => '2.7720'),
      array('postal_code' => '77220', 'name' => 'Tournan-en-Brie', 'lat' => '48.7415', 'lng' => '2.7720'),
      array('postal_code' => '77221 CEDEX', 'name' => 'Tournan-en-Brie', 'lat' => '48.7415', 'lng' => '2.7720'),
      array('postal_code' => '77230', 'name' => 'Saint-Mard', 'lat' => '49.0370', 'lng' => '2.6964'),
      array('postal_code' => '77230', 'name' => 'Nantouillet', 'lat' => '49.0019', 'lng' => '2.7036'),
      array('postal_code' => '77230', 'name' => 'March_moret', 'lat' => '49.0505', 'lng' => '2.7703'),
      array('postal_code' => '77218 CEDEX', 'name' => 'Avon', 'lat' => '48.4022', 'lng' => '2.7202'),
      array('postal_code' => '77230', 'name' => 'Rouvres', 'lat' => '49.0624', 'lng' => '2.7171'),
      array('postal_code' => '77223 CEDEX', 'name' => 'Tournan-en-Brie', 'lat' => '48.7415', 'lng' => '2.7720'),
      array('postal_code' => '77224 CEDEX', 'name' => 'Tournan-en-Brie', 'lat' => '48.7415', 'lng' => '2.7720'),
      array('postal_code' => '77216 CEDEX', 'name' => 'Avon', 'lat' => '48.4022', 'lng' => '2.7202'),
      array('postal_code' => '77220', 'name' => 'Gretz-Armainvilliers', 'lat' => '48.7412', 'lng' => '2.7310'),
      array('postal_code' => '77220', 'name' => 'Favi�res', 'lat' => '48.7632', 'lng' => '2.7747'),
      array('postal_code' => '77230', 'name' => 'Vinantes', 'lat' => '49.0104', 'lng' => '2.7349'),
      array('postal_code' => '77230', 'name' => 'Moussy-le-Vieux', 'lat' => '49.0471', 'lng' => '2.6249'),
      array('postal_code' => '77220', 'name' => 'Liverdy-en-Brie', 'lat' => '48.6999', 'lng' => '2.7761'),
      array('postal_code' => '77230', 'name' => 'Juilly', 'lat' => '49.0137', 'lng' => '2.7056'),
      array('postal_code' => '77220', 'name' => 'Presles-en-Brie', 'lat' => '48.7153', 'lng' => '2.7411'),
      array('postal_code' => '77222 CEDEX', 'name' => 'Tournan-en-Brie', 'lat' => '48.7415', 'lng' => '2.7720'),
      array('postal_code' => '77229 CEDEX', 'name' => 'Tournan-en-Brie', 'lat' => '48.7415', 'lng' => '2.7720'),
      array('postal_code' => '77230', 'name' => 'Thieux', 'lat' => '49.0077', 'lng' => '2.6721'),
      array('postal_code' => '77247 CEDEX', 'name' => 'Cesson', 'lat' => '48.5620', 'lng' => '2.6082'),
      array('postal_code' => '77246 CEDEX', 'name' => 'Cesson', 'lat' => '48.5620', 'lng' => '2.6082'),
      array('postal_code' => '77250', 'name' => 'Moret-Loing-et-Orvanne', 'lat' => '48.3736', 'lng' => '2.8142'),
      array('postal_code' => '77230', 'name' => 'Villeneuve-sous-Dammartin', 'lat' => '49.0350', 'lng' => '2.6410'),
      array('postal_code' => '77230', 'name' => 'Montg_-en-Go�le', 'lat' => '49.0333', 'lng' => '2.7500'),
      array('postal_code' => '77230', 'name' => 'Longperrier', 'lat' => '49.0484', 'lng' => '2.6657'),
      array('postal_code' => '77230', 'name' => 'Moussy-le-Neuf', 'lat' => '49.0643', 'lng' => '2.6025'),
      array('postal_code' => '77251 CEDEX', 'name' => 'Brie-Comte-Robert', 'lat' => '48.6925', 'lng' => '2.6109'),
      array('postal_code' => '77234 CEDEX', 'name' => 'Dammartin-en-Go�le', 'lat' => '49.0542', 'lng' => '2.6778'),
      array('postal_code' => '77243 CEDEX', 'name' => 'Cesson', 'lat' => '48.5620', 'lng' => '2.6082'),
      array('postal_code' => '77248 CEDEX', 'name' => 'Cesson', 'lat' => '48.5620', 'lng' => '2.6082'),
      array('postal_code' => '77250', 'name' => '�cuelles', 'lat' => '48.3564', 'lng' => '2.8234'),
      array('postal_code' => '77250', 'name' => 'Villecerf', 'lat' => '48.3278', 'lng' => '2.8472'),
      array('postal_code' => '77239 CEDEX', 'name' => 'Dammartin-en-Go�le', 'lat' => '49.0542', 'lng' => '2.6778'),
      array('postal_code' => '77250', 'name' => 'Villemer', 'lat' => '48.3010', 'lng' => '2.8242'),
      array('postal_code' => '77232 CEDEX', 'name' => 'Dammartin-en-Go�le', 'lat' => '49.0542', 'lng' => '2.6778'),
      array('postal_code' => '77240', 'name' => 'Vert-Saint-Denis', 'lat' => '48.5682', 'lng' => '2.6201'),
      array('postal_code' => '77241 CEDEX', 'name' => 'Cesson', 'lat' => '48.5620', 'lng' => '2.6082'),
      array('postal_code' => '77231 CEDEX', 'name' => 'Dammartin-en-Go�le', 'lat' => '49.0542', 'lng' => '2.6778'),
      array('postal_code' => '77240', 'name' => 'Cesson', 'lat' => '48.5620', 'lng' => '2.6082'),
      array('postal_code' => '77250', 'name' => 'Montarlot', 'lat' => '48.3497', 'lng' => '2.8490'),
      array('postal_code' => '77250', 'name' => 'Veneux-les-Sablons', 'lat' => '48.3787', 'lng' => '2.7950'),
      array('postal_code' => '77249 CEDEX', 'name' => 'Cesson', 'lat' => '48.5620', 'lng' => '2.6082'),
      array('postal_code' => '77250', 'name' => 'Moret-sur-Loing', 'lat' => '48.3724', 'lng' => '2.8171'),
      array('postal_code' => '77253 CEDEX', 'name' => 'Brie-Comte-Robert', 'lat' => '48.6925', 'lng' => '2.6109'),
      array('postal_code' => '77240', 'name' => 'Seine-Port', 'lat' => '48.5574', 'lng' => '2.5532'),
      array('postal_code' => '77242 CEDEX', 'name' => 'Cesson', 'lat' => '48.5620', 'lng' => '2.6082'),
      array('postal_code' => '77252 CEDEX', 'name' => 'Brie-Comte-Robert', 'lat' => '48.6925', 'lng' => '2.6109'),
      array('postal_code' => '77280', 'name' => 'Othis', 'lat' => '49.0739', 'lng' => '2.6750'),
      array('postal_code' => '77260', 'name' => 'Sainte-Aulde', 'lat' => '48.9934', 'lng' => '3.1724'),
      array('postal_code' => '77270', 'name' => 'Villeparisis', 'lat' => '48.9421', 'lng' => '2.6146'),
      array('postal_code' => '77295 CEDEX', 'name' => 'Mitry-Mory', 'lat' => '48.9833', 'lng' => '2.6167'),
      array('postal_code' => '77290', 'name' => 'Mitry-Mory', 'lat' => '48.9833', 'lng' => '2.6167'),
      array('postal_code' => '77263 CEDEX', 'name' => 'La Fert_-sous-Jouarre', 'lat' => '48.9514', 'lng' => '3.1272'),
      array('postal_code' => '77266 CEDEX', 'name' => 'Brie-Comte-Robert', 'lat' => '48.6925', 'lng' => '2.6109'),
      array('postal_code' => '77260', 'name' => 'Ussy-sur-Marne', 'lat' => '48.9566', 'lng' => '3.0727'),
      array('postal_code' => '77260', 'name' => 'Sammeron', 'lat' => '48.9472', 'lng' => '3.0833'),
      array('postal_code' => '77250', 'name' => '�pisy', 'lat' => '48.3345', 'lng' => '2.7863'),
      array('postal_code' => '77254 CEDEX', 'name' => 'Brie-Comte-Robert', 'lat' => '48.6925', 'lng' => '2.6109'),
      array('postal_code' => '77293 CEDEX', 'name' => 'Mitry-Mory', 'lat' => '48.9833', 'lng' => '2.6167'),
      array('postal_code' => '77257 CEDEX', 'name' => 'Brie-Comte-Robert', 'lat' => '48.6925', 'lng' => '2.6109'),
      array('postal_code' => '77281 CEDEX', 'name' => 'Avon', 'lat' => '48.4022', 'lng' => '2.7202'),
      array('postal_code' => '77259 CEDEX', 'name' => 'Brie-Comte-Robert', 'lat' => '48.6925', 'lng' => '2.6109'),
      array('postal_code' => '77255 CEDEX', 'name' => 'Brie-Comte-Robert', 'lat' => '48.6925', 'lng' => '2.6109'),
      array('postal_code' => '77291 CEDEX', 'name' => 'Mitry-Mory', 'lat' => '48.9833', 'lng' => '2.6167'),
      array('postal_code' => '77260', 'name' => 'Sept-Sorts', 'lat' => '48.9374', 'lng' => '3.1023'),
      array('postal_code' => '77260', 'name' => 'Chamigny', 'lat' => '48.9724', 'lng' => '3.1517'),
      array('postal_code' => '77260', 'name' => 'La Fert_-sous-Jouarre', 'lat' => '48.9514', 'lng' => '3.1272'),
      array('postal_code' => '77282 CEDEX', 'name' => 'Avon', 'lat' => '48.4022', 'lng' => '2.7202'),
      array('postal_code' => '77264 CEDEX', 'name' => 'La Fert_-sous-Jouarre', 'lat' => '48.9514', 'lng' => '3.1272'),
      array('postal_code' => '77272 CEDEX', 'name' => 'Villeparisis', 'lat' => '48.9421', 'lng' => '2.6146'),
      array('postal_code' => '77262 CEDEX', 'name' => 'La Fert_-sous-Jouarre', 'lat' => '48.9514', 'lng' => '3.1272'),
      array('postal_code' => '77290', 'name' => 'Compans', 'lat' => '48.9946', 'lng' => '2.6645'),
      array('postal_code' => '77292 CEDEX', 'name' => 'Mitry-Mory', 'lat' => '48.9833', 'lng' => '2.6167'),
      array('postal_code' => '77260', 'name' => 'Reuil-en-Brie', 'lat' => '48.9603', 'lng' => '3.1471'),
      array('postal_code' => '77296 CEDEX', 'name' => 'Mitry-Mory', 'lat' => '48.9833', 'lng' => '2.6167'),
      array('postal_code' => '77261 CEDEX', 'name' => 'La Fert_-sous-Jouarre', 'lat' => '48.9514', 'lng' => '3.1272'),
      array('postal_code' => '77271 CEDEX', 'name' => 'Villeparisis', 'lat' => '48.9421', 'lng' => '2.6146'),
      array('postal_code' => '77294 CEDEX', 'name' => 'Mitry-Mory', 'lat' => '48.9833', 'lng' => '2.6167'),
      array('postal_code' => '77299 CEDEX', 'name' => 'Mitry-Mory', 'lat' => '48.9833', 'lng' => '2.6167'),
      array('postal_code' => '77300', 'name' => 'Fontainebleau', 'lat' => '48.4000', 'lng' => '2.7000'),
      array('postal_code' => '77305 CEDEX', 'name' => 'Fontainebleau', 'lat' => '48.4000', 'lng' => '2.7000'),
      array('postal_code' => '77312 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77316 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77313 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77314 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77309 CEDEX', 'name' => 'Fontainebleau', 'lat' => '48.4000', 'lng' => '2.7000'),
      array('postal_code' => '77303 CEDEX', 'name' => 'Fontainebleau', 'lat' => '48.4000', 'lng' => '2.7000'),
      array('postal_code' => '77307 CEDEX', 'name' => 'Fontainebleau', 'lat' => '48.4000', 'lng' => '2.7000'),
      array('postal_code' => '77301 CEDEX', 'name' => 'Fontainebleau', 'lat' => '48.4000', 'lng' => '2.7000'),
      array('postal_code' => '77320', 'name' => 'La Fert_-Gaucher', 'lat' => '48.7831', 'lng' => '3.3068'),
      array('postal_code' => '77302 CEDEX', 'name' => 'Fontainebleau', 'lat' => '48.4000', 'lng' => '2.7000'),
      array('postal_code' => '77320', 'name' => 'Fr_toy', 'lat' => '48.7051', 'lng' => '3.1972'),
      array('postal_code' => '77297 CEDEX', 'name' => 'Mitry-Mory', 'lat' => '48.9833', 'lng' => '2.6167'),
      array('postal_code' => '77298 CEDEX', 'name' => 'Mitry-Mory', 'lat' => '48.9833', 'lng' => '2.6167'),
      array('postal_code' => '77310', 'name' => 'Boissise-le-Roi', 'lat' => '48.5248', 'lng' => '2.5697'),
      array('postal_code' => '77320', 'name' => 'Saint-Mars-Vieux-Maisons', 'lat' => '48.7422', 'lng' => '3.3207'),
      array('postal_code' => '77308 CEDEX', 'name' => 'Fontainebleau', 'lat' => '48.4000', 'lng' => '2.7000'),
      array('postal_code' => '77304 CEDEX', 'name' => 'Fontainebleau', 'lat' => '48.4000', 'lng' => '2.7000'),
      array('postal_code' => '77310', 'name' => 'Saint-Fargeau-Ponthierry', 'lat' => '48.5571', 'lng' => '2.5284'),
      array('postal_code' => '77315 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77319 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77318 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77320', 'name' => 'Sancy-l�s-Provins', 'lat' => '48.6966', 'lng' => '3.3925'),
      array('postal_code' => '77311 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77310', 'name' => 'Pringy', 'lat' => '48.5182', 'lng' => '2.5633'),
      array('postal_code' => '77320', 'name' => 'Leudon-en-Brie', 'lat' => '48.7335', 'lng' => '3.2734'),
      array('postal_code' => '77320', 'name' => 'Meilleray', 'lat' => '48.7884', 'lng' => '3.4271'),
      array('postal_code' => '77320', 'name' => 'Saint-Martin-du-Boschet', 'lat' => '48.7359', 'lng' => '3.4283'),
      array('postal_code' => '77320', 'name' => 'La Chapelle-Moutils', 'lat' => '48.7750', 'lng' => '3.3919'),
      array('postal_code' => '77320', 'name' => 'Saint-R_my-la-Vanne', 'lat' => '48.7918', 'lng' => '3.2327'),
      array('postal_code' => '77320', 'name' => 'Saint-Martin-des-Champs', 'lat' => '48.7785', 'lng' => '3.3346'),
      array('postal_code' => '77320', 'name' => 'Lescherolles', 'lat' => '48.7628', 'lng' => '3.3474'),
      array('postal_code' => '77320', 'name' => 'Jouy-sur-Morin', 'lat' => '48.7950', 'lng' => '3.2724'),
      array('postal_code' => '77320', 'name' => 'Cerneux', 'lat' => '48.6937', 'lng' => '3.3447'),
      array('postal_code' => '77320', 'name' => 'Chevru', 'lat' => '48.7368', 'lng' => '3.1957'),
      array('postal_code' => '77320', 'name' => 'Montenils', 'lat' => '48.8420', 'lng' => '3.4773'),
      array('postal_code' => '77320', 'name' => 'Montdauphin', 'lat' => '48.8519', 'lng' => '3.4286'),
      array('postal_code' => '77320', 'name' => 'Dagny', 'lat' => '48.7174', 'lng' => '3.1714'),
      array('postal_code' => '77320', 'name' => 'Montolivet', 'lat' => '48.8296', 'lng' => '3.4400'),
      array('postal_code' => '77320', 'name' => 'Beton-Bazoches', 'lat' => '48.7008', 'lng' => '3.2448'),
      array('postal_code' => '77320', 'name' => 'Chartronges', 'lat' => '48.7465', 'lng' => '3.2690'),
      array('postal_code' => '77320', 'name' => 'Choisy-en-Brie', 'lat' => '48.7587', 'lng' => '3.2170'),
      array('postal_code' => '77320', 'name' => 'Saint-Barth_lemy', 'lat' => '48.8170', 'lng' => '3.3616'),
      array('postal_code' => '77330', 'name' => 'Ozoir-la-Ferri�re', 'lat' => '48.7670', 'lng' => '2.6687'),
      array('postal_code' => '77343 CEDEX', 'name' => 'Pontault-Combault', 'lat' => '48.7981', 'lng' => '2.6068'),
      array('postal_code' => '77331 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77349 CEDEX', 'name' => 'Pontault-Combault', 'lat' => '48.7981', 'lng' => '2.6068'),
      array('postal_code' => '77350', 'name' => 'Boissettes', 'lat' => '48.5195', 'lng' => '2.6065'),
      array('postal_code' => '77332 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77340', 'name' => 'Pontault-Combault', 'lat' => '48.7981', 'lng' => '2.6068'),
      array('postal_code' => '77337 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77346 CEDEX', 'name' => 'Pontault-Combault', 'lat' => '48.7981', 'lng' => '2.6068'),
      array('postal_code' => '77347 CEDEX', 'name' => 'Pontault-Combault', 'lat' => '48.7981', 'lng' => '2.6068'),
      array('postal_code' => '77342 CEDEX', 'name' => 'Pontault-Combault', 'lat' => '48.7981', 'lng' => '2.6068'),
      array('postal_code' => '77341 CEDEX', 'name' => 'Pontault-Combault', 'lat' => '48.7981', 'lng' => '2.6068'),
      array('postal_code' => '77334 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77335 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77327 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77333 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77370', 'name' => 'Saint-Just-en-Brie', 'lat' => '48.6136', 'lng' => '3.1169'),
      array('postal_code' => '77348 CEDEX', 'name' => 'Pontault-Combault', 'lat' => '48.7981', 'lng' => '2.6068'),
      array('postal_code' => '77353 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77344 CEDEX', 'name' => 'Pontault-Combault', 'lat' => '48.7981', 'lng' => '2.6068'),
      array('postal_code' => '77350', 'name' => 'Boissise-la-Bertrand', 'lat' => '48.5285', 'lng' => '2.5894'),
      array('postal_code' => '77352 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77350', 'name' => 'Le M_e-sur-Seine', 'lat' => '48.5316', 'lng' => '2.6283'),
      array('postal_code' => '77360', 'name' => 'Vaires-sur-Marne', 'lat' => '48.8765', 'lng' => '2.6398'),
      array('postal_code' => '77351 CEDEX', 'name' => 'Meaux', 'lat' => '48.9601', 'lng' => '2.8788'),
      array('postal_code' => '77370', 'name' => 'La Croix-en-Brie', 'lat' => '48.5939', 'lng' => '3.0767'),
      array('postal_code' => '77389 CEDEX', 'name' => 'Combs-la-Ville', 'lat' => '48.6650', 'lng' => '2.5696'),
      array('postal_code' => '77370', 'name' => 'Gastins', 'lat' => '48.6293', 'lng' => '3.0201'),
      array('postal_code' => '77384 CEDEX', 'name' => 'Combs-la-Ville', 'lat' => '48.6650', 'lng' => '2.5696'),
      array('postal_code' => '77388 CEDEX', 'name' => 'Combs-la-Ville', 'lat' => '48.6650', 'lng' => '2.5696'),
      array('postal_code' => '77370', 'name' => 'Clos-Fontaine', 'lat' => '48.6077', 'lng' => '3.0158'),
      array('postal_code' => '77370', 'name' => 'Ch_teaubleau', 'lat' => '48.5891', 'lng' => '3.1062'),
      array('postal_code' => '77370', 'name' => 'Maison-Rouge', 'lat' => '48.5588', 'lng' => '3.1507'),
      array('postal_code' => '77380', 'name' => 'Combs-la-Ville', 'lat' => '48.6650', 'lng' => '2.5696'),
      array('postal_code' => '77390', 'name' => 'Champdeuil', 'lat' => '48.6207', 'lng' => '2.7286'),
      array('postal_code' => '77370', 'name' => 'Vanvill_', 'lat' => '48.5541', 'lng' => '3.1060'),
      array('postal_code' => '77370', 'name' => 'Rampillon', 'lat' => '48.5504', 'lng' => '3.0662'),
      array('postal_code' => '77370', 'name' => 'La Chapelle-Rablais', 'lat' => '48.5112', 'lng' => '2.9718'),
      array('postal_code' => '77385 CEDEX', 'name' => 'Combs-la-Ville', 'lat' => '48.6650', 'lng' => '2.5696'),
      array('postal_code' => '77381 CEDEX', 'name' => 'Combs-la-Ville', 'lat' => '48.6650', 'lng' => '2.5696'),
      array('postal_code' => '77370', 'name' => 'Nangis', 'lat' => '48.5554', 'lng' => '3.0131'),
      array('postal_code' => '77390', 'name' => 'Courquetaine', 'lat' => '48.6779', 'lng' => '2.7462'),
      array('postal_code' => '77370', 'name' => 'Vieux-Champagne', 'lat' => '48.5803', 'lng' => '3.1381'),
      array('postal_code' => '77382 CEDEX', 'name' => 'Combs-la-Ville', 'lat' => '48.6650', 'lng' => '2.5696'),
      array('postal_code' => '77370', 'name' => 'Fontenailles', 'lat' => '48.5522', 'lng' => '2.9523'),
      array('postal_code' => '77370', 'name' => 'Fontains', 'lat' => '48.5265', 'lng' => '3.0010'),
      array('postal_code' => '77390', 'name' => 'Chaumes-en-Brie', 'lat' => '48.6685', 'lng' => '2.8401'),
      array('postal_code' => '77390', 'name' => 'Courtomer', 'lat' => '48.6529', 'lng' => '2.9044'),
      array('postal_code' => '77390', 'name' => 'Y�bles', 'lat' => '48.6364', 'lng' => '2.7681'),
      array('postal_code' => '77390', 'name' => 'Guignes', 'lat' => '48.6333', 'lng' => '2.8000'),
      array('postal_code' => '77390', 'name' => 'Fouju', 'lat' => '48.5858', 'lng' => '2.7779'),
      array('postal_code' => '77390', 'name' => 'Andrezel', 'lat' => '48.6105', 'lng' => '2.8138'),
      array('postal_code' => '77390', 'name' => 'Crisenoy', 'lat' => '48.5955', 'lng' => '2.7418'),
      array('postal_code' => '77390', 'name' => 'Verneuil-l��tang', 'lat' => '48.6445', 'lng' => '2.8368'),
      array('postal_code' => '77401 CEDEX', 'name' => 'Lagny-sur-Marne', 'lat' => '48.8667', 'lng' => '2.7167'),
      array('postal_code' => '77390', 'name' => 'Beauvoir', 'lat' => '48.6445', 'lng' => '2.8636'),
      array('postal_code' => '77400', 'name' => 'Carnetin', 'lat' => '48.9010', 'lng' => '2.7059'),
      array('postal_code' => '77400', 'name' => 'Thorigny-sur-Marne', 'lat' => '48.8869', 'lng' => '2.7181'),
      array('postal_code' => '77400', 'name' => 'Lagny-sur-Marne', 'lat' => '48.8667', 'lng' => '2.7167'),
      array('postal_code' => '77400', 'name' => 'Saint-Thibault-des-Vignes', 'lat' => '48.8711', 'lng' => '2.6804'),
      array('postal_code' => '77390', 'name' => 'Argenti�res', 'lat' => '48.6534', 'lng' => '2.8676'),
      array('postal_code' => '77400', 'name' => 'Gouvernes', 'lat' => '48.8601', 'lng' => '2.6907'),
      array('postal_code' => '77390', 'name' => 'Ozouer-le-Voulgis', 'lat' => '48.6601', 'lng' => '2.7741'),
      array('postal_code' => '77400', 'name' => 'Dampmart', 'lat' => '48.8885', 'lng' => '2.7409'),
      array('postal_code' => '77403 CEDEX', 'name' => 'Lagny-sur-Marne', 'lat' => '48.8667', 'lng' => '2.7167'),
      array('postal_code' => '77406 CEDEX', 'name' => 'Lagny-sur-Marne', 'lat' => '48.8667', 'lng' => '2.7167'),
      array('postal_code' => '77404 CEDEX', 'name' => 'Lagny-sur-Marne', 'lat' => '48.8667', 'lng' => '2.7167'),
      array('postal_code' => '77405 CEDEX', 'name' => 'Lagny-sur-Marne', 'lat' => '48.8667', 'lng' => '2.7167'),
      array('postal_code' => '77409 CEDEX', 'name' => 'Lagny-sur-Marne', 'lat' => '48.8667', 'lng' => '2.7167'),
      array('postal_code' => '77410', 'name' => 'Pr_cy-sur-Marne', 'lat' => '48.9308', 'lng' => '2.7744'),
      array('postal_code' => '77410', 'name' => 'Annet-sur-Marne', 'lat' => '48.9267', 'lng' => '2.7196'),
      array('postal_code' => '77407 CEDEX', 'name' => 'Lagny-sur-Marne', 'lat' => '48.8667', 'lng' => '2.7167'),
      array('postal_code' => '77402 CEDEX', 'name' => 'Lagny-sur-Marne', 'lat' => '48.8667', 'lng' => '2.7167'),
      array('postal_code' => '77400', 'name' => 'Pomponne', 'lat' => '48.8813', 'lng' => '2.6823'),
      array('postal_code' => '77410', 'name' => 'Charmentray', 'lat' => '48.9453', 'lng' => '2.7765'),
      array('postal_code' => '77410', 'name' => 'Villeroy', 'lat' => '48.9830', 'lng' => '2.7818'),
      array('postal_code' => '77410', 'name' => 'Villevaud_', 'lat' => '48.9175', 'lng' => '2.6523'),
      array('postal_code' => '77410', 'name' => 'Gressy', 'lat' => '48.9649', 'lng' => '2.6735'),
      array('postal_code' => '77410', 'name' => 'Claye-Souilly', 'lat' => '48.9449', 'lng' => '2.6857'),
      array('postal_code' => '77410', 'name' => 'Saint-Mesmes', 'lat' => '48.9846', 'lng' => '2.6948'),
      array('postal_code' => '77414 CEDEX', 'name' => 'Claye-Souilly', 'lat' => '48.9449', 'lng' => '2.6857'),
      array('postal_code' => '77415 CEDEX', 'name' => 'Claye-Souilly', 'lat' => '48.9449', 'lng' => '2.6857'),
      array('postal_code' => '77410', 'name' => 'Charny', 'lat' => '48.9710', 'lng' => '2.7612'),
      array('postal_code' => '77412 CEDEX', 'name' => 'Claye-Souilly', 'lat' => '48.9449', 'lng' => '2.6857'),
      array('postal_code' => '77411 CEDEX', 'name' => 'Claye-Souilly', 'lat' => '48.9449', 'lng' => '2.6857'),
      array('postal_code' => '77413 CEDEX', 'name' => 'Claye-Souilly', 'lat' => '48.9449', 'lng' => '2.6857'),
      array('postal_code' => '77410', 'name' => 'Fresnes-sur-Marne', 'lat' => '48.9396', 'lng' => '2.7413'),
      array('postal_code' => '77410', 'name' => 'Messy', 'lat' => '48.9667', 'lng' => '2.7000'),
      array('postal_code' => '77417 CEDEX', 'name' => 'Claye-Souilly', 'lat' => '48.9449', 'lng' => '2.6857'),
      array('postal_code' => '77423 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77422 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77420', 'name' => 'Champs-sur-Marne', 'lat' => '48.8500', 'lng' => '2.6000'),
      array('postal_code' => '77421 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77416 CEDEX', 'name' => 'Claye-Souilly', 'lat' => '48.9449', 'lng' => '2.6857'),
      array('postal_code' => '77419 CEDEX', 'name' => 'Claye-Souilly', 'lat' => '48.9449', 'lng' => '2.6857'),
      array('postal_code' => '77425 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77424 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77437 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77436 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77434 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77440', 'name' => 'Dhuisy', 'lat' => '49.0389', 'lng' => '3.1608'),
      array('postal_code' => '77432 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77429 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77440', 'name' => 'Vendrest', 'lat' => '49.0464', 'lng' => '3.0939'),
      array('postal_code' => '77440', 'name' => 'Ocquerre', 'lat' => '49.0383', 'lng' => '3.0571'),
      array('postal_code' => '77439 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77427 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77426 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77433 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77431 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77430', 'name' => 'Champagne-sur-Seine', 'lat' => '48.3979', 'lng' => '2.7978'),
      array('postal_code' => '77440', 'name' => 'Armenti�res-en-Brie', 'lat' => '48.9777', 'lng' => '3.0207'),
      array('postal_code' => '77440', 'name' => 'Trocy-en-Multien', 'lat' => '49.0421', 'lng' => '2.9620'),
      array('postal_code' => '77440', 'name' => 'Cocherel', 'lat' => '49.0214', 'lng' => '3.1030'),
      array('postal_code' => '77440', 'name' => 'Lizy-sur-Ourcq', 'lat' => '49.0245', 'lng' => '3.0218'),
      array('postal_code' => '77440', 'name' => 'Mary-sur-Marne', 'lat' => '49.0159', 'lng' => '3.0279'),
      array('postal_code' => '77435 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77440', 'name' => 'Tancrou', 'lat' => '49.0027', 'lng' => '3.0506'),
      array('postal_code' => '77440', 'name' => 'Congis-sur-Th_rouanne', 'lat' => '49.0000', 'lng' => '2.9833'),
      array('postal_code' => '77444 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77440', 'name' => 'Le Plessis-Placy', 'lat' => '49.0579', 'lng' => '2.9892'),
      array('postal_code' => '77441 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77440', 'name' => 'Jaignes', 'lat' => '48.9919', 'lng' => '3.0552'),
      array('postal_code' => '77442 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77445 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77440', 'name' => 'Isles-les-Meldeuses', 'lat' => '48.9995', 'lng' => '3.0061'),
      array('postal_code' => '77447 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77448 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77446 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77450', 'name' => 'Cond_-Sainte-Libiaire', 'lat' => '48.8970', 'lng' => '2.8390'),
      array('postal_code' => '77443 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77450', 'name' => 'Esbly', 'lat' => '48.9052', 'lng' => '2.8124'),
      array('postal_code' => '77450', 'name' => 'Trilbardou', 'lat' => '48.9425', 'lng' => '2.8062'),
      array('postal_code' => '77464 CEDEX', 'name' => 'Lagny-sur-Marne', 'lat' => '48.8667', 'lng' => '2.7167'),
      array('postal_code' => '77451 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77458 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77450', 'name' => 'Montry', 'lat' => '48.8841', 'lng' => '2.8291'),
      array('postal_code' => '77450', 'name' => 'Jablines', 'lat' => '48.9177', 'lng' => '2.7635'),
      array('postal_code' => '77450', 'name' => 'Vignely', 'lat' => '48.9310', 'lng' => '2.8084'),
      array('postal_code' => '77452 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77465 CEDEX', 'name' => 'Lagny-sur-Marne', 'lat' => '48.8667', 'lng' => '2.7167'),
      array('postal_code' => '77450', 'name' => 'Isles-l�s-Villenoy', 'lat' => '48.9125', 'lng' => '2.8272'),
      array('postal_code' => '77450', 'name' => 'Lesches', 'lat' => '48.9095', 'lng' => '2.7824'),
      array('postal_code' => '77460', 'name' => 'Souppes-sur-Loing', 'lat' => '48.1830', 'lng' => '2.7352'),
      array('postal_code' => '77454 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77455 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77462 CEDEX', 'name' => 'Lagny-sur-Marne', 'lat' => '48.8667', 'lng' => '2.7167'),
      array('postal_code' => '77470', 'name' => 'Villemareuil', 'lat' => '48.9212', 'lng' => '2.9714'),
      array('postal_code' => '77470', 'name' => 'Fublaines', 'lat' => '48.9382', 'lng' => '2.9365'),
      array('postal_code' => '77468 CEDEX', 'name' => 'Souppes-sur-Loing', 'lat' => '48.1830', 'lng' => '2.7352'),
      array('postal_code' => '77463 CEDEX', 'name' => 'Lagny-sur-Marne', 'lat' => '48.8667', 'lng' => '2.7167'),
      array('postal_code' => '77453 CEDEX 2', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77470', 'name' => 'Saint-Fiacre', 'lat' => '48.9233', 'lng' => '2.9556'),
      array('postal_code' => '77460', 'name' => 'Chaintreaux', 'lat' => '48.1988', 'lng' => '2.8203'),
      array('postal_code' => '77470', 'name' => 'Boutigny', 'lat' => '48.9205', 'lng' => '2.9300'),
      array('postal_code' => '77470', 'name' => 'Poincy', 'lat' => '48.9696', 'lng' => '2.9364'),
      array('postal_code' => '77480', 'name' => 'Grisy-sur-Seine', 'lat' => '48.4392', 'lng' => '3.3187'),
      array('postal_code' => '77470', 'name' => 'Trilport', 'lat' => '48.9569', 'lng' => '2.9508'),
      array('postal_code' => '77467 CEDEX', 'name' => 'Lagny-sur-Marne', 'lat' => '48.8667', 'lng' => '2.7167'),
      array('postal_code' => '77469 CEDEX', 'name' => 'Souppes-sur-Loing', 'lat' => '48.1830', 'lng' => '2.7352'),
      array('postal_code' => '77480', 'name' => 'Villuis', 'lat' => '48.4107', 'lng' => '3.3587'),
      array('postal_code' => '77483 CEDEX', 'name' => 'Provins', 'lat' => '48.5500', 'lng' => '3.3000'),
      array('postal_code' => '77470', 'name' => 'Montceaux-l�s-Meaux', 'lat' => '48.9416', 'lng' => '2.9901'),
      array('postal_code' => '77480', 'name' => 'Mousseaux-l�s-Bray', 'lat' => '48.4147', 'lng' => '3.2283'),
      array('postal_code' => '77481 CEDEX', 'name' => 'Provins', 'lat' => '48.5500', 'lng' => '3.3000'),
      array('postal_code' => '77480', 'name' => 'Passy-sur-Seine', 'lat' => '48.4257', 'lng' => '3.3472'),
      array('postal_code' => '77480', 'name' => 'Baby', 'lat' => '48.3972', 'lng' => '3.3411'),
      array('postal_code' => '77480', 'name' => 'Montigny-le-Guesdier', 'lat' => '48.3832', 'lng' => '3.2544'),
      array('postal_code' => '77480', 'name' => 'Mouy-sur-Seine', 'lat' => '48.4204', 'lng' => '3.2426'),
      array('postal_code' => '77480', 'name' => 'Villenauxe-la-Petite', 'lat' => '48.4081', 'lng' => '3.3098'),
      array('postal_code' => '77480', 'name' => 'Saint-Sauveur-l�s-Bray', 'lat' => '48.4397', 'lng' => '3.2089'),
      array('postal_code' => '77480', 'name' => 'Fontaine-Fourches', 'lat' => '48.4141', 'lng' => '3.3903'),
      array('postal_code' => '77482 CEDEX', 'name' => 'Provins', 'lat' => '48.5500', 'lng' => '3.3000'),
      array('postal_code' => '77480', 'name' => 'Bray-sur-Seine', 'lat' => '48.4137', 'lng' => '3.2385'),
      array('postal_code' => '77488 CEDEX', 'name' => 'Provins', 'lat' => '48.5500', 'lng' => '3.3000'),
      array('postal_code' => '77489 CEDEX', 'name' => 'Provins', 'lat' => '48.5500', 'lng' => '3.3000'),
      array('postal_code' => '77480', 'name' => 'Jaulnes', 'lat' => '48.4178', 'lng' => '3.2735'),
      array('postal_code' => '77486 CEDEX', 'name' => 'Provins', 'lat' => '48.5500', 'lng' => '3.3000'),
      array('postal_code' => '77507 CEDEX', 'name' => 'Chelles', 'lat' => '48.8811', 'lng' => '2.5929'),
      array('postal_code' => '77487 CEDEX', 'name' => 'Provins', 'lat' => '48.5500', 'lng' => '3.3000'),
      array('postal_code' => '77503 CEDEX', 'name' => 'Chelles', 'lat' => '48.8811', 'lng' => '2.5929'),
      array('postal_code' => '77501 CEDEX', 'name' => 'Chelles', 'lat' => '48.8811', 'lng' => '2.5929'),
      array('postal_code' => '77504 CEDEX', 'name' => 'Chelles', 'lat' => '48.8811', 'lng' => '2.5929'),
      array('postal_code' => '77510', 'name' => 'Saint-L_ger', 'lat' => '48.8390', 'lng' => '3.2554'),
      array('postal_code' => '77509 CEDEX', 'name' => 'Chelles', 'lat' => '48.8811', 'lng' => '2.5929'),
      array('postal_code' => '77502 CEDEX', 'name' => 'Chelles', 'lat' => '48.8811', 'lng' => '2.5929'),
      array('postal_code' => '77500', 'name' => 'Chelles', 'lat' => '48.8811', 'lng' => '2.5929'),
      array('postal_code' => '77510', 'name' => 'Rebais', 'lat' => '48.8472', 'lng' => '3.2323'),
      array('postal_code' => '77508 CEDEX', 'name' => 'Chelles', 'lat' => '48.8811', 'lng' => '2.5929'),
      array('postal_code' => '77510', 'name' => 'Sablonni�res', 'lat' => '48.8757', 'lng' => '3.2970'),
      array('postal_code' => '77506 CEDEX', 'name' => 'Chelles', 'lat' => '48.8811', 'lng' => '2.5929'),
      array('postal_code' => '77484 CEDEX', 'name' => 'Provins', 'lat' => '48.5500', 'lng' => '3.3000'),
      array('postal_code' => '77510', 'name' => 'Doue', 'lat' => '48.8664', 'lng' => '3.1627'),
      array('postal_code' => '77505 CEDEX', 'name' => 'Chelles', 'lat' => '48.8811', 'lng' => '2.5929'),
      array('postal_code' => '77510', 'name' => 'Verdelot', 'lat' => '48.8754', 'lng' => '3.3658'),
      array('postal_code' => '77510', 'name' => 'La Tr_toire', 'lat' => '48.8735', 'lng' => '3.2517'),
      array('postal_code' => '77515', 'name' => 'Pommeuse', 'lat' => '48.8167', 'lng' => '3.0167'),
      array('postal_code' => '77520', 'name' => 'Montigny-Lencoup', 'lat' => '48.4516', 'lng' => '3.0650'),
      array('postal_code' => '77510', 'name' => 'Hondevilliers', 'lat' => '48.8999', 'lng' => '3.3104'),
      array('postal_code' => '77520', 'name' => 'Luisetaines', 'lat' => '48.4675', 'lng' => '3.1806'),
      array('postal_code' => '77510', 'name' => 'Saint-Denis-l�s-Rebais', 'lat' => '48.8355', 'lng' => '3.2102'),
      array('postal_code' => '77520', 'name' => 'Th_nisy', 'lat' => '48.4903', 'lng' => '3.1750'),
      array('postal_code' => '77510', 'name' => 'Bellot', 'lat' => '48.8567', 'lng' => '3.3186'),
      array('postal_code' => '77510', 'name' => 'Villeneuve-sur-Bellot', 'lat' => '48.8620', 'lng' => '3.3414'),
      array('postal_code' => '77520', 'name' => 'Paroy', 'lat' => '48.4789', 'lng' => '3.1992'),
      array('postal_code' => '77520', 'name' => 'Sognolles-en-Montois', 'lat' => '48.5123', 'lng' => '3.1669'),
      array('postal_code' => '77515', 'name' => 'Saint-Augustin', 'lat' => '48.7833', 'lng' => '3.0302'),
      array('postal_code' => '77520', 'name' => 'Cessoy-en-Montois', 'lat' => '48.5046', 'lng' => '3.1465'),
      array('postal_code' => '77515', 'name' => 'La Celle-sur-Morin', 'lat' => '48.8115', 'lng' => '2.9692'),
      array('postal_code' => '77520', 'name' => 'Meigneux', 'lat' => '48.5121', 'lng' => '3.1045'),
      array('postal_code' => '77523 CEDEX', 'name' => 'Coulommiers', 'lat' => '48.8145', 'lng' => '3.0850'),
      array('postal_code' => '77515', 'name' => 'Hautefeuille', 'lat' => '48.7655', 'lng' => '2.9681'),
      array('postal_code' => '77520', 'name' => 'Donnemarie-Dontilly', 'lat' => '48.4772', 'lng' => '3.1316'),
      array('postal_code' => '77520', 'name' => 'Sigy', 'lat' => '48.4784', 'lng' => '3.1823'),
      array('postal_code' => '77520', 'name' => 'Gurcy-le-Ch_tel', 'lat' => '48.4702', 'lng' => '3.0865'),
      array('postal_code' => '77522 CEDEX', 'name' => 'Coulommiers', 'lat' => '48.8145', 'lng' => '3.0850'),
      array('postal_code' => '77515', 'name' => 'Faremoutiers', 'lat' => '48.7996', 'lng' => '2.9961'),
      array('postal_code' => '77520', 'name' => 'Mons-en-Montois', 'lat' => '48.4900', 'lng' => '3.1477'),
      array('postal_code' => '77520', 'name' => 'Vimpelles', 'lat' => '48.4397', 'lng' => '3.1654'),
      array('postal_code' => '77521 CEDEX', 'name' => 'Coulommiers', 'lat' => '48.8145', 'lng' => '3.0850'),
      array('postal_code' => '77540', 'name' => 'Courpalay', 'lat' => '48.6495', 'lng' => '2.9612'),
      array('postal_code' => '77540', 'name' => 'Lumigny-Nesles-Ormeaux', 'lat' => '48.7333', 'lng' => '2.9500'),
      array('postal_code' => '77540', 'name' => 'La Chapelle-Iger', 'lat' => '48.6538', 'lng' => '2.9933'),
      array('postal_code' => '77556 CEDEX', 'name' => 'Moissy-Cramayel', 'lat' => '48.6261', 'lng' => '2.6012'),
      array('postal_code' => '77548 CEDEX', 'name' => 'Savigny-le-Temple', 'lat' => '48.5741', 'lng' => '2.5829'),
      array('postal_code' => '77546 CEDEX', 'name' => 'Savigny-le-Temple', 'lat' => '48.5741', 'lng' => '2.5829'),
      array('postal_code' => '77528 CEDEX', 'name' => 'Coulommiers', 'lat' => '48.8145', 'lng' => '3.0850'),
      array('postal_code' => '77540', 'name' => 'Voinsles', 'lat' => '48.6913', 'lng' => '3.0047'),
      array('postal_code' => '77540', 'name' => 'Bernay-Vilbert', 'lat' => '48.6766', 'lng' => '2.9371'),
      array('postal_code' => '77529 CEDEX', 'name' => 'Coulommiers', 'lat' => '48.8145', 'lng' => '3.0850'),
      array('postal_code' => '77526 CEDEX', 'name' => 'Coulommiers', 'lat' => '48.8145', 'lng' => '3.0850'),
      array('postal_code' => '77547 CEDEX', 'name' => 'Savigny-le-Temple', 'lat' => '48.5741', 'lng' => '2.5829'),
      array('postal_code' => '77550', 'name' => 'Limoges-Fourches', 'lat' => '48.6280', 'lng' => '2.6655'),
      array('postal_code' => '77527 CEDEX', 'name' => 'Coulommiers', 'lat' => '48.8145', 'lng' => '3.0850'),
      array('postal_code' => '77524 CEDEX', 'name' => 'Coulommiers', 'lat' => '48.8145', 'lng' => '3.0850'),
      array('postal_code' => '77551 CEDEX', 'name' => 'Moissy-Cramayel', 'lat' => '48.6261', 'lng' => '2.6012'),
      array('postal_code' => '77544 CEDEX', 'name' => 'Savigny-le-Temple', 'lat' => '48.5741', 'lng' => '2.5829'),
      array('postal_code' => '77557 CEDEX', 'name' => 'Moissy-Cramayel', 'lat' => '48.6261', 'lng' => '2.6012'),
      array('postal_code' => '77560', 'name' => 'Louan-Villegruis-Fontaine', 'lat' => '48.6263', 'lng' => '3.4768'),
      array('postal_code' => '77542 CEDEX', 'name' => 'Savigny-le-Temple', 'lat' => '48.5741', 'lng' => '2.5829'),
      array('postal_code' => '77540', 'name' => 'Rozay-en-Brie', 'lat' => '48.6833', 'lng' => '2.9582'),
      array('postal_code' => '77543 CEDEX', 'name' => 'Savigny-le-Temple', 'lat' => '48.5741', 'lng' => '2.5829'),
      array('postal_code' => '77550', 'name' => 'R_au', 'lat' => '48.6102', 'lng' => '2.6240'),
      array('postal_code' => '77540', 'name' => 'Le Plessis-Feu-Aussoux', 'lat' => '48.7167', 'lng' => '3.0333'),
      array('postal_code' => '77554 CEDEX', 'name' => 'Moissy-Cramayel', 'lat' => '48.6261', 'lng' => '2.6012'),
      array('postal_code' => '77525 CEDEX', 'name' => 'Coulommiers', 'lat' => '48.8145', 'lng' => '3.0850'),
      array('postal_code' => '77545 CEDEX', 'name' => 'Savigny-le-Temple', 'lat' => '48.5741', 'lng' => '2.5829'),
      array('postal_code' => '77550', 'name' => 'Lissy', 'lat' => '48.6265', 'lng' => '2.6965'),
      array('postal_code' => '77541 CEDEX', 'name' => 'Savigny-le-Temple', 'lat' => '48.5741', 'lng' => '2.5829'),
      array('postal_code' => '77549 CEDEX', 'name' => 'Savigny-le-Temple', 'lat' => '48.5741', 'lng' => '2.5829'),
      array('postal_code' => '77552 CEDEX', 'name' => 'Moissy-Cramayel', 'lat' => '48.6261', 'lng' => '2.6012'),
      array('postal_code' => '77550', 'name' => 'Moissy-Cramayel', 'lat' => '48.6261', 'lng' => '2.6012'),
      array('postal_code' => '77553 CEDEX', 'name' => 'Moissy-Cramayel', 'lat' => '48.6261', 'lng' => '2.6012'),
      array('postal_code' => '77559 CEDEX', 'name' => 'Moissy-Cramayel', 'lat' => '48.6261', 'lng' => '2.6012'),
      array('postal_code' => '77560', 'name' => 'Augers-en-Brie', 'lat' => '48.6798', 'lng' => '3.3563'),
      array('postal_code' => '77555 CEDEX', 'name' => 'Moissy-Cramayel', 'lat' => '48.6261', 'lng' => '2.6012'),
      array('postal_code' => '77560', 'name' => 'Beauchery-Saint-Martin', 'lat' => '48.6167', 'lng' => '3.4000'),
      array('postal_code' => '77558 CEDEX', 'name' => 'Moissy-Cramayel', 'lat' => '48.6261', 'lng' => '2.6012'),
      array('postal_code' => '77560', 'name' => 'Champcenest', 'lat' => '48.6711', 'lng' => '3.2821'),
      array('postal_code' => '77560', 'name' => 'Les Mar�ts', 'lat' => '48.6667', 'lng' => '3.3167'),
      array('postal_code' => '77560', 'name' => 'Voulton', 'lat' => '48.6175', 'lng' => '3.3342'),
      array('postal_code' => '77560', 'name' => 'Courchamp', 'lat' => '48.6364', 'lng' => '3.2861'),
      array('postal_code' => '77561 CEDEX', 'name' => 'Lieusaint', 'lat' => '48.6348', 'lng' => '2.5481'),
      array('postal_code' => '77567 CEDEX', 'name' => 'Lieusaint', 'lat' => '48.6348', 'lng' => '2.5481'),
      array('postal_code' => '77568 CEDEX', 'name' => 'Lieusaint', 'lat' => '48.6348', 'lng' => '2.5481'),
      array('postal_code' => '77564 CEDEX', 'name' => 'Lieusaint', 'lat' => '48.6348', 'lng' => '2.5481'),
      array('postal_code' => '77560', 'name' => 'Courtacon', 'lat' => '48.6968', 'lng' => '3.2925'),
      array('postal_code' => '77570', 'name' => 'Chenou', 'lat' => '48.1654', 'lng' => '2.6592'),
      array('postal_code' => '77566 CEDEX', 'name' => 'Lieusaint', 'lat' => '48.6348', 'lng' => '2.5481'),
      array('postal_code' => '77565 CEDEX', 'name' => 'Lieusaint', 'lat' => '48.6348', 'lng' => '2.5481'),
      array('postal_code' => '77560', 'name' => 'Rup_reux', 'lat' => '48.6351', 'lng' => '3.3326'),
      array('postal_code' => '77563 CEDEX', 'name' => 'Lieusaint', 'lat' => '48.6348', 'lng' => '2.5481'),
      array('postal_code' => '77560', 'name' => 'Villiers-Saint-Georges', 'lat' => '48.6500', 'lng' => '3.4075'),
      array('postal_code' => '77570', 'name' => 'Maisoncelles-en-G_tinais', 'lat' => '48.1877', 'lng' => '2.6253'),
      array('postal_code' => '77569 CEDEX', 'name' => 'Lieusaint', 'lat' => '48.6348', 'lng' => '2.5481'),
      array('postal_code' => '77570', 'name' => 'La Madeleine-sur-Loing', 'lat' => '48.2000', 'lng' => '2.8667'),
      array('postal_code' => '77570', 'name' => 'Mondreville', 'lat' => '48.1415', 'lng' => '2.6087'),
      array('postal_code' => '77570', 'name' => 'Bougligny', 'lat' => '48.1965', 'lng' => '2.6583'),
      array('postal_code' => '77562 CEDEX', 'name' => 'Lieusaint', 'lat' => '48.6348', 'lng' => '2.5481'),
      array('postal_code' => '77580', 'name' => 'Pierre-Lev_e', 'lat' => '48.8996', 'lng' => '3.0384'),
      array('postal_code' => '77580', 'name' => 'Bouleurs', 'lat' => '48.8818', 'lng' => '2.9073'),
      array('postal_code' => '77582 CEDEX', 'name' => 'Savigny-le-Temple', 'lat' => '48.5741', 'lng' => '2.5829'),
      array('postal_code' => '77580', 'name' => 'Coulommes', 'lat' => '48.8914', 'lng' => '2.9289'),
      array('postal_code' => '77580', 'name' => 'La Haute-Maison', 'lat' => '48.8816', 'lng' => '3.0020'),
      array('postal_code' => '77580', 'name' => 'Voulangis', 'lat' => '48.8525', 'lng' => '2.8956'),
      array('postal_code' => '77570', 'name' => 'Ch_teau-Landon', 'lat' => '48.1472', 'lng' => '2.6975'),
      array('postal_code' => '77580', 'name' => 'Maisoncelles-en-Brie', 'lat' => '48.8660', 'lng' => '2.9923'),
      array('postal_code' => '77581 CEDEX', 'name' => 'Savigny-le-Temple', 'lat' => '48.5741', 'lng' => '2.5829'),
      array('postal_code' => '77580', 'name' => 'Cr_cy-la-Chapelle', 'lat' => '48.8592', 'lng' => '2.9074'),
      array('postal_code' => '77570', 'name' => 'Aufferville', 'lat' => '48.2151', 'lng' => '2.6097'),
      array('postal_code' => '77580', 'name' => 'Sancy', 'lat' => '48.8833', 'lng' => '2.9667'),
      array('postal_code' => '77580', 'name' => 'Coutevroult', 'lat' => '48.8622', 'lng' => '2.8527'),
      array('postal_code' => '77580', 'name' => 'Vaucourtois', 'lat' => '48.8958', 'lng' => '2.9519'),
      array('postal_code' => '77580', 'name' => 'Villiers-sur-Morin', 'lat' => '48.8610', 'lng' => '2.8777'),
      array('postal_code' => '77580', 'name' => 'Gu_rard', 'lat' => '48.8209', 'lng' => '2.9597'),
      array('postal_code' => '77583 CEDEX', 'name' => 'Savigny-le-Temple', 'lat' => '48.5741', 'lng' => '2.5829'),
      array('postal_code' => '77585 CEDEX', 'name' => 'Savigny-le-Temple', 'lat' => '48.5741', 'lng' => '2.5829'),
      array('postal_code' => '77590', 'name' => 'Fontaine-le-Port', 'lat' => '48.4857', 'lng' => '2.7653'),
      array('postal_code' => '77600', 'name' => 'Bussy-Saint-Martin', 'lat' => '48.8490', 'lng' => '2.6904'),
      array('postal_code' => '77630', 'name' => 'Arbonne-la-For�t', 'lat' => '48.4140', 'lng' => '2.5668'),
      array('postal_code' => '77612 CEDEX 3', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77606 CEDEX 3', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77590', 'name' => 'Bois-le-Roi', 'lat' => '48.4735', 'lng' => '2.7046'),
      array('postal_code' => '77605 CEDEX 3', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77615 CEDEX 3', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77610', 'name' => 'Ch_tres', 'lat' => '48.7102', 'lng' => '2.8097'),
      array('postal_code' => '77610', 'name' => 'Cr�vec�ur-en-Brie', 'lat' => '48.7500', 'lng' => '2.9000'),
      array('postal_code' => '77590', 'name' => 'Chartrettes', 'lat' => '48.4881', 'lng' => '2.7008'),
      array('postal_code' => '77611 CEDEX 3', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77600', 'name' => 'Guermantes', 'lat' => '48.8530', 'lng' => '2.7050'),
      array('postal_code' => '77600', 'name' => 'Conches-sur-Gondoire', 'lat' => '48.8562', 'lng' => '2.7178'),
      array('postal_code' => '77602 CEDEX 3', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77607 CEDEX 3', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77600', 'name' => 'Bussy-Saint-Georges', 'lat' => '48.8410', 'lng' => '2.7016'),
      array('postal_code' => '77600', 'name' => 'Jossigny', 'lat' => '48.8376', 'lng' => '2.7543'),
      array('postal_code' => '77604 CEDEX 3', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77601 CEDEX 3', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77610', 'name' => 'Les Chapelles-Bourbon', 'lat' => '48.7420', 'lng' => '2.8404'),
      array('postal_code' => '77610', 'name' => 'Neufmoutiers-en-Brie', 'lat' => '48.7688', 'lng' => '2.8316'),
      array('postal_code' => '77603 CEDEX 3', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77620', 'name' => '�greville', 'lat' => '48.1761', 'lng' => '2.8728'),
      array('postal_code' => '77609 CEDEX 3', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77630', 'name' => 'Saint-Martin-en-Bi�re', 'lat' => '48.4366', 'lng' => '2.5668'),
      array('postal_code' => '77630', 'name' => 'Barbizon', 'lat' => '48.4435', 'lng' => '2.6031'),
      array('postal_code' => '77610', 'name' => 'Fontenay-Tr_signy', 'lat' => '48.7065', 'lng' => '2.8705'),
      array('postal_code' => '77640', 'name' => 'Jouarre', 'lat' => '48.9266', 'lng' => '3.1317'),
      array('postal_code' => '77640', 'name' => 'Signy-Signets', 'lat' => '48.9277', 'lng' => '3.0665'),
      array('postal_code' => '77610', 'name' => 'Marles-en-Brie', 'lat' => '48.7278', 'lng' => '2.8800'),
      array('postal_code' => '77608 CEDEX 3', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77617 CEDEX 3', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77614 CEDEX 3', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77600', 'name' => 'Chanteloup-en-Brie', 'lat' => '48.8548', 'lng' => '2.7393'),
      array('postal_code' => '77620', 'name' => 'Bransles', 'lat' => '48.1530', 'lng' => '2.8319'),
      array('postal_code' => '77616 CEDEX 3', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77610', 'name' => 'La Houssaye-en-Brie', 'lat' => '48.7538', 'lng' => '2.8655'),
      array('postal_code' => '77645 CEDEX', 'name' => 'Chelles', 'lat' => '48.8811', 'lng' => '2.5929'),
      array('postal_code' => '77650', 'name' => 'Soisy-Bouy', 'lat' => '48.5118', 'lng' => '3.2950'),
      array('postal_code' => '77650', 'name' => 'Chalmaison', 'lat' => '48.4823', 'lng' => '3.2513'),
      array('postal_code' => '77649 CEDEX', 'name' => 'Chelles', 'lat' => '48.8811', 'lng' => '2.5929'),
      array('postal_code' => '77650', 'name' => 'Sainte-Colombe', 'lat' => '48.5305', 'lng' => '3.2552'),
      array('postal_code' => '77701 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77650', 'name' => 'Longueville', 'lat' => '48.5150', 'lng' => '3.2468'),
      array('postal_code' => '77680', 'name' => 'Roissy-en-Brie', 'lat' => '48.7916', 'lng' => '2.6475'),
      array('postal_code' => '77646 CEDEX', 'name' => 'Chelles', 'lat' => '48.8811', 'lng' => '2.5929'),
      array('postal_code' => '77700', 'name' => 'Magny-le-Hongre', 'lat' => '48.8632', 'lng' => '2.8155'),
      array('postal_code' => '77670', 'name' => 'Vernou-la-Celle-sur-Seine', 'lat' => '48.3879', 'lng' => '2.8472'),
      array('postal_code' => '77641 CEDEX', 'name' => 'Chelles', 'lat' => '48.8811', 'lng' => '2.5929'),
      array('postal_code' => '77650', 'name' => 'Saint-Loup-de-Naud', 'lat' => '48.5333', 'lng' => '3.2000'),
      array('postal_code' => '77660', 'name' => 'Changis-sur-Marne', 'lat' => '48.9582', 'lng' => '3.0219'),
      array('postal_code' => '77690', 'name' => 'Montigny-sur-Loing', 'lat' => '48.3357', 'lng' => '2.7442'),
      array('postal_code' => '77700', 'name' => 'Serris', 'lat' => '48.8453', 'lng' => '2.7861'),
      array('postal_code' => '77650', 'name' => 'Lizines', 'lat' => '48.5264', 'lng' => '3.1778'),
      array('postal_code' => '77660', 'name' => 'Saint-Jean-les-Deux-Jumeaux', 'lat' => '48.9514', 'lng' => '3.0196'),
      array('postal_code' => '77650', 'name' => 'Jutigny', 'lat' => '48.4983', 'lng' => '3.2319'),
      array('postal_code' => '77650', 'name' => 'Savins', 'lat' => '48.5089', 'lng' => '3.2022'),
      array('postal_code' => '77700', 'name' => 'Bailly-Romainvilliers', 'lat' => '48.8473', 'lng' => '2.8235'),
      array('postal_code' => '77670', 'name' => 'Saint-Mamm�s', 'lat' => '48.3846', 'lng' => '2.8158'),
      array('postal_code' => '77700', 'name' => 'Coupvray', 'lat' => '48.8929', 'lng' => '2.7967'),
      array('postal_code' => '77700', 'name' => 'Chessy', 'lat' => '48.8833', 'lng' => '2.7667'),
      array('postal_code' => '77690', 'name' => 'La Genevraye', 'lat' => '48.3203', 'lng' => '2.7455'),
      array('postal_code' => '77710', 'name' => 'Remauville', 'lat' => '48.2126', 'lng' => '2.8240'),
      array('postal_code' => '77704 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77708 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77706 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77709 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77720', 'name' => 'Bombon', 'lat' => '48.5718', 'lng' => '2.8608'),
      array('postal_code' => '77705 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77720', 'name' => 'Aubepierre-Ozouer-le-Repos', 'lat' => '48.6333', 'lng' => '2.8833'),
      array('postal_code' => '77721 CEDEX', 'name' => 'Mormant', 'lat' => '48.6090', 'lng' => '2.8903'),
      array('postal_code' => '77710', 'name' => 'Vaux-sur-Lunain', 'lat' => '48.2272', 'lng' => '2.9369'),
      array('postal_code' => '77720', 'name' => 'Mormant', 'lat' => '48.6090', 'lng' => '2.8903'),
      array('postal_code' => '77717 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77710', 'name' => 'Treuzy-Levelay', 'lat' => '48.2779', 'lng' => '2.8020'),
      array('postal_code' => '77710', 'name' => 'Chevry-en-Sereine', 'lat' => '48.2539', 'lng' => '2.9424'),
      array('postal_code' => '77703 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77702 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77715 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77720', 'name' => 'Grandpuits-Bailly-Carrois', 'lat' => '48.5833', 'lng' => '2.9667'),
      array('postal_code' => '77722 CEDEX', 'name' => 'Mormant', 'lat' => '48.6090', 'lng' => '2.8903'),
      array('postal_code' => '77710', 'name' => 'Villemar_chal', 'lat' => '48.2670', 'lng' => '2.8669'),
      array('postal_code' => '77710', 'name' => 'Saint-Ange-le-Viel', 'lat' => '48.2667', 'lng' => '2.9000'),
      array('postal_code' => '77714 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77710', 'name' => 'Lorrez-le-Bocage-Pr_aux', 'lat' => '48.2333', 'lng' => '2.9000'),
      array('postal_code' => '77720', 'name' => 'Br_au', 'lat' => '48.5615', 'lng' => '2.8786'),
      array('postal_code' => '77720', 'name' => 'Champeaux', 'lat' => '48.5846', 'lng' => '2.8066'),
      array('postal_code' => '77716 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77710', 'name' => 'Paley', 'lat' => '48.2425', 'lng' => '2.8596'),
      array('postal_code' => '77711 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77723 CEDEX', 'name' => 'Mormant', 'lat' => '48.6090', 'lng' => '2.8903'),
      array('postal_code' => '77710', 'name' => 'Nanteau-sur-Lunain', 'lat' => '48.2567', 'lng' => '2.8114'),
      array('postal_code' => '77720', 'name' => 'Quiers', 'lat' => '48.6069', 'lng' => '2.9695'),
      array('postal_code' => '77710', 'name' => 'Villeb_on', 'lat' => '48.2106', 'lng' => '2.9403'),
      array('postal_code' => '77720', 'name' => 'La Chapelle-Gauthier', 'lat' => '48.5495', 'lng' => '2.8978'),
      array('postal_code' => '77720', 'name' => 'Saint-Ouen-en-Brie', 'lat' => '48.5584', 'lng' => '2.9194'),
      array('postal_code' => '77720', 'name' => 'Saint-M_ry', 'lat' => '48.5774', 'lng' => '2.8258'),
      array('postal_code' => '77730', 'name' => 'M_ry-sur-Marne', 'lat' => '48.9649', 'lng' => '3.2001'),
      array('postal_code' => '77730', 'name' => 'Citry', 'lat' => '48.9682', 'lng' => '3.2398'),
      array('postal_code' => '77750', 'name' => 'Saint-Cyr-sur-Morin', 'lat' => '48.9066', 'lng' => '3.1802'),
      array('postal_code' => '77730', 'name' => 'Sa_cy-sur-Marne', 'lat' => '48.9621', 'lng' => '3.2108'),
      array('postal_code' => '77750', 'name' => 'Orly-sur-Morin', 'lat' => '48.9038', 'lng' => '3.2307'),
      array('postal_code' => '77750', 'name' => 'Saint-Ouen-sur-Morin', 'lat' => '48.9020', 'lng' => '3.2015'),
      array('postal_code' => '77730', 'name' => 'Nanteuil-sur-Marne', 'lat' => '48.9783', 'lng' => '3.2202'),
      array('postal_code' => '77750', 'name' => 'Boitron', 'lat' => '48.8980', 'lng' => '3.2612'),
      array('postal_code' => '77760', 'name' => 'Rumont', 'lat' => '48.2637', 'lng' => '2.4994'),
      array('postal_code' => '77760', 'name' => 'Ach�res-la-For�t', 'lat' => '48.3546', 'lng' => '2.5704'),
      array('postal_code' => '77760', 'name' => 'Fromont', 'lat' => '48.2548', 'lng' => '2.5003'),
      array('postal_code' => '77760', 'name' => 'Ury', 'lat' => '48.3440', 'lng' => '2.6030'),
      array('postal_code' => '77778 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77760', 'name' => 'Amponville', 'lat' => '48.2781', 'lng' => '2.5293'),
      array('postal_code' => '77792 CEDEX', 'name' => 'Nemours', 'lat' => '48.2751', 'lng' => '2.6908'),
      array('postal_code' => '77760', 'name' => 'Boulancourt', 'lat' => '48.2581', 'lng' => '2.4339'),
      array('postal_code' => '77750', 'name' => 'Bassevelle', 'lat' => '48.9273', 'lng' => '3.2876'),
      array('postal_code' => '77760', 'name' => 'Villiers-sous-Grez', 'lat' => '48.3187', 'lng' => '2.6482'),
      array('postal_code' => '77750', 'name' => 'Bussi�res', 'lat' => '48.9228', 'lng' => '3.2345'),
      array('postal_code' => '77760', 'name' => 'Chevrainvilliers', 'lat' => '48.2451', 'lng' => '2.6159'),
      array('postal_code' => '77760', 'name' => 'Recloses', 'lat' => '48.3466', 'lng' => '2.6430'),
      array('postal_code' => '77780', 'name' => 'Bourron-Marlotte', 'lat' => '48.3405', 'lng' => '2.7004'),
      array('postal_code' => '77813 CEDEX', 'name' => 'Moret-sur-Loing', 'lat' => '48.3724', 'lng' => '2.8171'),
      array('postal_code' => '77760', 'name' => 'Burcy', 'lat' => '48.2380', 'lng' => '2.5228'),
      array('postal_code' => '77760', 'name' => 'Guercheville', 'lat' => '48.2592', 'lng' => '2.5575'),
      array('postal_code' => '77791 CEDEX', 'name' => 'Nemours', 'lat' => '48.2751', 'lng' => '2.6908'),
      array('postal_code' => '77811 CEDEX', 'name' => 'Moret-sur-Loing', 'lat' => '48.3724', 'lng' => '2.8171'),
      array('postal_code' => '77771 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77760', 'name' => 'Buthiers', 'lat' => '48.2871', 'lng' => '2.4316'),
      array('postal_code' => '77760', 'name' => 'Boissy-aux-Cailles', 'lat' => '48.3194', 'lng' => '2.4996'),
      array('postal_code' => '77814 CEDEX', 'name' => 'Moret-sur-Loing', 'lat' => '48.3724', 'lng' => '2.8171'),
      array('postal_code' => '77795 CEDEX', 'name' => 'Nemours', 'lat' => '48.2751', 'lng' => '2.6908'),
      array('postal_code' => '77760', 'name' => 'La Chapelle-la-Reine', 'lat' => '48.3181', 'lng' => '2.5715'),
      array('postal_code' => '77799 CEDEX', 'name' => 'Nemours', 'lat' => '48.2751', 'lng' => '2.6908'),
      array('postal_code' => '77820', 'name' => 'Les �crennes', 'lat' => '48.5048', 'lng' => '2.8584'),
      array('postal_code' => '77760', 'name' => 'Nanteau-sur-Essonne', 'lat' => '48.3167', 'lng' => '2.4167'),
      array('postal_code' => '77793 CEDEX', 'name' => 'Nemours', 'lat' => '48.2751', 'lng' => '2.6908'),
      array('postal_code' => '77760', 'name' => 'Larchant', 'lat' => '48.2848', 'lng' => '2.5944'),
      array('postal_code' => '77776 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77819 CEDEX', 'name' => 'Moret-sur-Loing', 'lat' => '48.3724', 'lng' => '2.8171'),
      array('postal_code' => '77798 CEDEX', 'name' => 'Nemours', 'lat' => '48.2751', 'lng' => '2.6908'),
      array('postal_code' => '77810', 'name' => 'Thomery', 'lat' => '48.4072', 'lng' => '2.7885'),
      array('postal_code' => '77830', 'name' => '�chouboulains', 'lat' => '48.4638', 'lng' => '2.9453'),
      array('postal_code' => '77772 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77815 CEDEX', 'name' => 'Moret-sur-Loing', 'lat' => '48.3724', 'lng' => '2.8171'),
      array('postal_code' => '77779 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77777 CEDEX 4', 'name' => 'Marne-la-Vall_e', 'lat' => '48.8333', 'lng' => '2.6333'),
      array('postal_code' => '77794 CEDEX', 'name' => 'Nemours', 'lat' => '48.2751', 'lng' => '2.6908'),
      array('postal_code' => '77796 CEDEX', 'name' => 'Nemours', 'lat' => '48.2751', 'lng' => '2.6908'),
      array('postal_code' => '77818 CEDEX', 'name' => 'Moret-sur-Loing', 'lat' => '48.3724', 'lng' => '2.8171'),
      array('postal_code' => '77830', 'name' => 'Pamfou', 'lat' => '48.4611', 'lng' => '2.8702'),
      array('postal_code' => '77817 CEDEX', 'name' => 'Moret-sur-Loing', 'lat' => '48.3724', 'lng' => '2.8171'),
      array('postal_code' => '77820', 'name' => 'Le Ch_telet-en-Brie', 'lat' => '48.5069', 'lng' => '2.7916'),
      array('postal_code' => '77816 CEDEX', 'name' => 'Moret-sur-Loing', 'lat' => '48.3724', 'lng' => '2.8171'),
      array('postal_code' => '77820', 'name' => 'Ch_tillon-la-Borde', 'lat' => '48.5426', 'lng' => '2.8089'),
      array('postal_code' => '77832 CEDEX', 'name' => 'Ozoir-la-Ferri�re', 'lat' => '48.7670', 'lng' => '2.6687'),
      array('postal_code' => '77834 CEDEX', 'name' => 'Ozoir-la-Ferri�re', 'lat' => '48.7670', 'lng' => '2.6687'),
      array('postal_code' => '77830', 'name' => 'Valence-en-Brie', 'lat' => '48.4428', 'lng' => '2.8902'),
      array('postal_code' => '77831 CEDEX', 'name' => 'Ozoir-la-Ferri�re', 'lat' => '48.7670', 'lng' => '2.6687'),
      array('postal_code' => '77840', 'name' => 'Germigny-sous-Coulombs', 'lat' => '49.0644', 'lng' => '3.1591'),
      array('postal_code' => '77838 CEDEX', 'name' => 'Ozoir-la-Ferri�re', 'lat' => '48.7670', 'lng' => '2.6687'),
      array('postal_code' => '77840', 'name' => 'Crouy-sur-Ourcq', 'lat' => '49.0898', 'lng' => '3.0753'),
      array('postal_code' => '77879 CEDEX', 'name' => 'Montereau-Fault-Yonne', 'lat' => '48.3833', 'lng' => '2.9500'),
      array('postal_code' => '77890', 'name' => 'Arville', 'lat' => '48.1883', 'lng' => '2.5497'),
      array('postal_code' => '77835 CEDEX', 'name' => 'Ozoir-la-Ferri�re', 'lat' => '48.7670', 'lng' => '2.6687'),
      array('postal_code' => '77871 CEDEX', 'name' => 'Montereau-Fault-Yonne', 'lat' => '48.3833', 'lng' => '2.9500'),
      array('postal_code' => '77850', 'name' => 'H_ricy', 'lat' => '48.4485', 'lng' => '2.7644'),
      array('postal_code' => '77833 CEDEX', 'name' => 'Ozoir-la-Ferri�re', 'lat' => '48.7670', 'lng' => '2.6687'),
      array('postal_code' => '77872 CEDEX', 'name' => 'Montereau-Fault-Yonne', 'lat' => '48.3833', 'lng' => '2.9500'),
      array('postal_code' => '77932 CEDEX', 'name' => 'Perthes', 'lat' => '48.4782', 'lng' => '2.5551'),
      array('postal_code' => '77870', 'name' => 'Vulaines-sur-Seine', 'lat' => '48.4319', 'lng' => '2.7648'),
      array('postal_code' => '77930', 'name' => 'Saint-Sauveur-sur-�cole', 'lat' => '48.4975', 'lng' => '2.5471'),
      array('postal_code' => '77860', 'name' => 'Saint-Germain-sur-Morin', 'lat' => '48.8826', 'lng' => '2.8513'),
      array('postal_code' => '77837 CEDEX', 'name' => 'Ozoir-la-Ferri�re', 'lat' => '48.7670', 'lng' => '2.6687'),
      array('postal_code' => '77910', 'name' => 'Chambry', 'lat' => '48.9985', 'lng' => '2.8940'),
      array('postal_code' => '77860', 'name' => 'Couilly-Pont-aux-Dames', 'lat' => '48.8847', 'lng' => '2.8568'),
      array('postal_code' => '77890', 'name' => 'Garentreville', 'lat' => '48.2361', 'lng' => '2.5494'),
      array('postal_code' => '77930', 'name' => 'C_ly', 'lat' => '48.4596', 'lng' => '2.5324'),
      array('postal_code' => '77890', 'name' => 'Gironville', 'lat' => '48.1862', 'lng' => '2.5277'),
      array('postal_code' => '77839 CEDEX', 'name' => 'Ozoir-la-Ferri�re', 'lat' => '48.7670', 'lng' => '2.6687'),
      array('postal_code' => '77873 CEDEX', 'name' => 'Montereau-Fault-Yonne', 'lat' => '48.3833', 'lng' => '2.9500'),
      array('postal_code' => '77880', 'name' => 'Grez-sur-Loing', 'lat' => '48.3175', 'lng' => '2.6885'),
      array('postal_code' => '77890', 'name' => 'Beaumont-du-G_tinais', 'lat' => '48.1386', 'lng' => '2.4791'),
      array('postal_code' => '77910', 'name' => 'Varreddes', 'lat' => '49.0030', 'lng' => '2.9279'),
      array('postal_code' => '77875 CEDEX', 'name' => 'Montereau-Fault-Yonne', 'lat' => '48.3833', 'lng' => '2.9500'),
      array('postal_code' => '77930', 'name' => 'Fleury-en-Bi�re', 'lat' => '48.4459', 'lng' => '2.5487'),
      array('postal_code' => '77840', 'name' => 'Coulombs-en-Valois', 'lat' => '49.0667', 'lng' => '3.1333'),
      array('postal_code' => '77930', 'name' => 'Chailly-en-Bi�re', 'lat' => '48.4670', 'lng' => '2.6078'),
      array('postal_code' => '77910', 'name' => 'Barcy', 'lat' => '49.0182', 'lng' => '2.8804'),
      array('postal_code' => '77890', 'name' => 'Obsonville', 'lat' => '48.2170', 'lng' => '2.5613'),
      array('postal_code' => '77860', 'name' => 'Quincy-Voisins', 'lat' => '48.9011', 'lng' => '2.8756'),
      array('postal_code' => '77876 CEDEX', 'name' => 'Montereau-Fault-Yonne', 'lat' => '48.3833', 'lng' => '2.9500'),
      array('postal_code' => '77910', 'name' => 'Germigny-l�Ev�que', 'lat' => '48.9916', 'lng' => '2.9443'),
      array('postal_code' => '77930', 'name' => 'Perthes', 'lat' => '48.4782', 'lng' => '2.5551'),
      array('postal_code' => '77931 CEDEX', 'name' => 'Perthes', 'lat' => '48.4782', 'lng' => '2.5551'),
      array('postal_code' => '77923 CEDEX', 'name' => 'Mitry-Mory', 'lat' => '48.9833', 'lng' => '2.6167'),
      array('postal_code' => '77920', 'name' => 'Samois-sur-Seine', 'lat' => '48.4525', 'lng' => '2.7504'),
      array('postal_code' => '77930', 'name' => 'Saint-Germain-sur-�cole', 'lat' => '48.4742', 'lng' => '2.5079'),
      array('postal_code' => '77890', 'name' => 'Ichy', 'lat' => '48.2026', 'lng' => '2.5471'),
      array('postal_code' => '77933 CEDEX', 'name' => 'Perthes', 'lat' => '48.4782', 'lng' => '2.5551'),
      array('postal_code' => '77939 CEDEX', 'name' => 'Perthes', 'lat' => '48.4782', 'lng' => '2.5551'),
      array('postal_code' => '77940', 'name' => 'Flagy', 'lat' => '48.3123', 'lng' => '2.9221'),
      array('postal_code' => '77961 CEDEX', 'name' => 'Moret-sur-Loing', 'lat' => '48.3724', 'lng' => '2.8171'),
      array('postal_code' => '77940', 'name' => 'Blennes', 'lat' => '48.2577', 'lng' => '3.0230'),
      array('postal_code' => '77940', 'name' => 'Voulx', 'lat' => '48.2820', 'lng' => '2.9675'),
      array('postal_code' => '77940', 'name' => 'Thoury-F_rottes', 'lat' => '48.2942', 'lng' => '2.9415'),
      array('postal_code' => '77940', 'name' => 'Noisy-Rudignon', 'lat' => '48.3355', 'lng' => '2.9304'),
      array('postal_code' => '77950', 'name' => 'Rubelles', 'lat' => '48.5533', 'lng' => '2.6759'),
      array('postal_code' => '77940', 'name' => 'Diant', 'lat' => '48.2830', 'lng' => '2.9932'),
      array('postal_code' => '77970', 'name' => 'Bannost-Villegagnon', 'lat' => '48.6783', 'lng' => '3.1918'),
      array('postal_code' => '77940', 'name' => 'Esmans', 'lat' => '48.3460', 'lng' => '2.9762'),
      array('postal_code' => '77940', 'name' => 'Montmachoux', 'lat' => '48.3185', 'lng' => '2.9929'),
      array('postal_code' => '77970', 'name' => 'Bezalles', 'lat' => '48.6790', 'lng' => '3.2440'),
      array('postal_code' => '77950', 'name' => 'Voisenon', 'lat' => '48.5717', 'lng' => '2.6648'),
      array('postal_code' => '77951 CEDEX', 'name' => 'Maincy', 'lat' => '48.5498', 'lng' => '2.7002'),
      array('postal_code' => '77940', 'name' => 'La Brosse-Montceaux', 'lat' => '48.3451', 'lng' => '3.0195'),
      array('postal_code' => '77950', 'name' => 'Saint-Germain-Laxis', 'lat' => '48.5821', 'lng' => '2.7104'),
      array('postal_code' => '77950', 'name' => 'Moisenay', 'lat' => '48.5627', 'lng' => '2.7353'),
      array('postal_code' => '77970', 'name' => 'Boisdon', 'lat' => '48.6851', 'lng' => '3.2248'),
      array('postal_code' => '77982 CEDEX', 'name' => 'Saint-Fargeau-Ponthierry', 'lat' => '48.5571', 'lng' => '2.5284'),
      array('postal_code' => '77950', 'name' => 'Maincy', 'lat' => '48.5498', 'lng' => '2.7002'),
      array('postal_code' => '77950', 'name' => 'Montereau-sur-le-Jard', 'lat' => '48.5914', 'lng' => '2.6684'),
      array('postal_code' => '77989 CEDEX', 'name' => 'Saint-Fargeau-Ponthierry', 'lat' => '48.5571', 'lng' => '2.5284'),
      array('postal_code' => '77970', 'name' => 'P_cy', 'lat' => '48.6555', 'lng' => '3.0822'),
      array('postal_code' => '78000', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '77970', 'name' => 'Jouy-le-Ch_tel', 'lat' => '48.6665', 'lng' => '3.1304'),
      array('postal_code' => '77990', 'name' => 'Le Mesnil-Amelot', 'lat' => '49.0179', 'lng' => '2.5942'),
      array('postal_code' => '77983 CEDEX', 'name' => 'Saint-Fargeau-Ponthierry', 'lat' => '48.5571', 'lng' => '2.5284'),
      array('postal_code' => '77981 CEDEX', 'name' => 'Saint-Fargeau-Ponthierry', 'lat' => '48.5571', 'lng' => '2.5284'),
      array('postal_code' => '77986 CEDEX', 'name' => 'Saint-Fargeau-Ponthierry', 'lat' => '48.5571', 'lng' => '2.5284'),
      array('postal_code' => '77990', 'name' => 'Mauregard', 'lat' => '49.0342', 'lng' => '2.5806'),
      array('postal_code' => '78020 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78033 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78001 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78004 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78034 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78024 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78003 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78035 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78007 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78010 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78009 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78005 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78011 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78012 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78013 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78002 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78028 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78019 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78021 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78008 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78029 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78018 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78015 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78027 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78014 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78046 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78006 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78017 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78052 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78026 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78042 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78041 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78032 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78022 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78043 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78049 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78054 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78048 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78045 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78030 CEDEX', 'name' => 'Versailles', 'lat' => '48.8036', 'lng' => '2.1342'),
      array('postal_code' => '78044 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78071 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78053 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78066 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78060 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78086 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78051 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78057 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78091 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78061 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78088 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78062 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78059 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78078 CITYSSIMO', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78064 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78047 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78079 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78065 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78084 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78081 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78092 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78089 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78082 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78055 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78067 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78056 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78083 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78085 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78087 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78093 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78099 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78094 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78096 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78095 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78109 CEDEX', 'name' => 'Saint-Germain-en-Laye', 'lat' => '48.9000', 'lng' => '2.0833'),
      array('postal_code' => '78111', 'name' => 'Dammartin-en-Serve', 'lat' => '48.9032', 'lng' => '1.6195'),
      array('postal_code' => '78113', 'name' => 'Cond_-sur-Vesgre', 'lat' => '48.7420', 'lng' => '1.6607'),
      array('postal_code' => '78101 CEDEX', 'name' => 'Saint-Germain-en-Laye', 'lat' => '48.9000', 'lng' => '2.0833'),
      array('postal_code' => '78113', 'name' => 'Le Tartre-Gaudran', 'lat' => '48.6999', 'lng' => '1.5967'),
      array('postal_code' => '78115 CEDEX', 'name' => 'Le V_sinet', 'lat' => '48.8928', 'lng' => '2.1331'),
      array('postal_code' => '78106 CEDEX', 'name' => 'Saint-Germain-en-Laye', 'lat' => '48.9000', 'lng' => '2.0833'),
      array('postal_code' => '78108 CEDEX', 'name' => 'Saint-Germain-en-Laye', 'lat' => '48.9000', 'lng' => '2.0833'),
      array('postal_code' => '78100', 'name' => 'Saint-Germain-en-Laye', 'lat' => '48.9000', 'lng' => '2.0833'),
      array('postal_code' => '78104 CEDEX', 'name' => 'Saint-Germain-en-Laye', 'lat' => '48.9000', 'lng' => '2.0833'),
      array('postal_code' => '78105 CEDEX', 'name' => 'Saint-Germain-en-Laye', 'lat' => '48.9000', 'lng' => '2.0833'),
      array('postal_code' => '78113', 'name' => 'Bourdonn_', 'lat' => '48.7574', 'lng' => '1.6639'),
      array('postal_code' => '78114', 'name' => 'Magny-les-Hameaux', 'lat' => '48.7435', 'lng' => '2.0615'),
      array('postal_code' => '78110', 'name' => 'Le V_sinet', 'lat' => '48.8928', 'lng' => '2.1331'),
      array('postal_code' => '78102 CEDEX', 'name' => 'Saint-Germain-en-Laye', 'lat' => '48.9000', 'lng' => '2.0833'),
      array('postal_code' => '78113', 'name' => 'Grandchamp', 'lat' => '48.7190', 'lng' => '1.6200'),
      array('postal_code' => '78116 CEDEX', 'name' => 'Le V_sinet', 'lat' => '48.8928', 'lng' => '2.1331'),
      array('postal_code' => '78113', 'name' => 'La Hauteville', 'lat' => '48.7060', 'lng' => '1.6211'),
      array('postal_code' => '78112', 'name' => 'Fourqueux', 'lat' => '48.8869', 'lng' => '2.0637'),
      array('postal_code' => '78122 CEDEX', 'name' => 'Saint-Germain-en-Laye', 'lat' => '48.9000', 'lng' => '2.0833'),
      array('postal_code' => '78118 CEDEX', 'name' => 'Le V_sinet', 'lat' => '48.8928', 'lng' => '2.1331'),
      array('postal_code' => '78113', 'name' => 'Adainville', 'lat' => '48.7233', 'lng' => '1.6532'),
      array('postal_code' => '78117', 'name' => 'Toussus-le-Noble', 'lat' => '48.7493', 'lng' => '2.1134'),
      array('postal_code' => '78120', 'name' => 'Clairefontaine-en-Yvelines', 'lat' => '48.6167', 'lng' => '1.9167'),
      array('postal_code' => '78125', 'name' => 'Mittainville', 'lat' => '48.6707', 'lng' => '1.6462'),
      array('postal_code' => '78120', 'name' => 'Rambouillet', 'lat' => '48.6500', 'lng' => '1.8333'),
      array('postal_code' => '78125', 'name' => 'Orcemont', 'lat' => '48.5879', 'lng' => '1.8105'),
      array('postal_code' => '78124', 'name' => 'Montainville', 'lat' => '48.8825', 'lng' => '1.8608'),
      array('postal_code' => '78117', 'name' => 'Ch_teaufort', 'lat' => '48.7358', 'lng' => '2.0905'),
      array('postal_code' => '78121', 'name' => 'Crespi�res', 'lat' => '48.8832', 'lng' => '1.9215'),
      array('postal_code' => '78119 CEDEX', 'name' => 'Le V_sinet', 'lat' => '48.8928', 'lng' => '2.1331'),
      array('postal_code' => '78125', 'name' => 'Gazeran', 'lat' => '48.6326', 'lng' => '1.7715'),
      array('postal_code' => '78125', 'name' => 'La Boissi�re-�cole', 'lat' => '48.6804', 'lng' => '1.6513'),
      array('postal_code' => '78125', 'name' => 'Raizeux', 'lat' => '48.6245', 'lng' => '1.6834'),
      array('postal_code' => '78120', 'name' => 'Sonchamp', 'lat' => '48.5759', 'lng' => '1.8775'),
      array('postal_code' => '78125', 'name' => 'Poigny-la-For�t', 'lat' => '48.6800', 'lng' => '1.7557'),
      array('postal_code' => '78124', 'name' => 'Mareil-sur-Mauldre', 'lat' => '48.8952', 'lng' => '1.8687'),
      array('postal_code' => '78125', 'name' => 'Orphin', 'lat' => '48.5783', 'lng' => '1.7807'),
      array('postal_code' => '78133 CEDEX', 'name' => 'Les Mureaux', 'lat' => '48.9917', 'lng' => '1.9097'),
      array('postal_code' => '78125', 'name' => '�manc_', 'lat' => '48.5905', 'lng' => '1.7312'),
      array('postal_code' => '78125', 'name' => 'Saint-Hilarion', 'lat' => '48.6205', 'lng' => '1.7337'),
      array('postal_code' => '78126', 'name' => 'Aulnay-sur-Mauldre', 'lat' => '48.9295', 'lng' => '1.8411'),
      array('postal_code' => '78129 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78125', 'name' => 'Vieille-�glise-en-Yvelines', 'lat' => '48.6666', 'lng' => '1.8768'),
      array('postal_code' => '78134 CEDEX', 'name' => 'Les Mureaux', 'lat' => '48.9917', 'lng' => '1.9097'),
      array('postal_code' => '78132 CEDEX', 'name' => 'Les Mureaux', 'lat' => '48.9917', 'lng' => '1.9097'),
      array('postal_code' => '78130', 'name' => 'Chapet', 'lat' => '48.9667', 'lng' => '1.9333'),
      array('postal_code' => '78125', 'name' => 'Hermeray', 'lat' => '48.6376', 'lng' => '1.6756'),
      array('postal_code' => '78131 CEDEX', 'name' => 'Les Mureaux', 'lat' => '48.9917', 'lng' => '1.9097'),
      array('postal_code' => '78142 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78139 CEDEX', 'name' => 'Les Mureaux', 'lat' => '48.9917', 'lng' => '1.9097'),
      array('postal_code' => '78150', 'name' => 'Rocquencourt', 'lat' => '48.8378', 'lng' => '2.1023'),
      array('postal_code' => '78140', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78150', 'name' => 'Le Chesnay', 'lat' => '48.8222', 'lng' => '2.1221'),
      array('postal_code' => '78154 CEDEX', 'name' => 'Le Chesnay', 'lat' => '48.8222', 'lng' => '2.1221'),
      array('postal_code' => '78141 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78130', 'name' => 'Les Mureaux', 'lat' => '48.9917', 'lng' => '1.9097'),
      array('postal_code' => '78148 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78157 CEDEX', 'name' => 'Le Chesnay', 'lat' => '48.8222', 'lng' => '2.1221'),
      array('postal_code' => '78146 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78149 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78147 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78164 CEDEX', 'name' => 'Marly-le-Roi', 'lat' => '48.8667', 'lng' => '2.0833'),
      array('postal_code' => '78155 CEDEX', 'name' => 'Le Chesnay', 'lat' => '48.8222', 'lng' => '2.1221'),
      array('postal_code' => '78135 CEDEX', 'name' => 'Les Mureaux', 'lat' => '48.9917', 'lng' => '1.9097'),
      array('postal_code' => '78163 CEDEX', 'name' => 'Marly-le-Roi', 'lat' => '48.8667', 'lng' => '2.0833'),
      array('postal_code' => '78145 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78152 CEDEX', 'name' => 'Le Chesnay', 'lat' => '48.8222', 'lng' => '2.1221'),
      array('postal_code' => '78151 CEDEX', 'name' => 'Le Chesnay', 'lat' => '48.8222', 'lng' => '2.1221'),
      array('postal_code' => '78160', 'name' => 'Marly-le-Roi', 'lat' => '48.8667', 'lng' => '2.0833'),
      array('postal_code' => '78158 CEDEX', 'name' => 'Le Chesnay', 'lat' => '48.8222', 'lng' => '2.1221'),
      array('postal_code' => '78143 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78170', 'name' => 'La Celle-Saint-Cloud', 'lat' => '48.8503', 'lng' => '2.1452'),
      array('postal_code' => '78166 CEDEX', 'name' => 'Marly-le-Roi', 'lat' => '48.8667', 'lng' => '2.0833'),
      array('postal_code' => '78174 CEDEX', 'name' => 'Saint-Germain-en-Laye', 'lat' => '48.9000', 'lng' => '2.0833'),
      array('postal_code' => '78162 CEDEX', 'name' => 'Marly-le-Roi', 'lat' => '48.8667', 'lng' => '2.0833'),
      array('postal_code' => '78169 CEDEX', 'name' => 'Marly-le-Roi', 'lat' => '48.8667', 'lng' => '2.0833'),
      array('postal_code' => '78153 CEDEX', 'name' => 'Le Chesnay', 'lat' => '48.8222', 'lng' => '2.1221'),
      array('postal_code' => '78167 CEDEX', 'name' => 'Marly-le-Roi', 'lat' => '48.8667', 'lng' => '2.0833'),
      array('postal_code' => '78177 CITYSSIMO', 'name' => 'Saint-Germain-en-Laye', 'lat' => '48.9000', 'lng' => '2.0833'),
      array('postal_code' => '78186 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78183 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78171 CEDEX', 'name' => 'La Celle-Saint-Cloud', 'lat' => '48.8503', 'lng' => '2.1452'),
      array('postal_code' => '78172 CEDEX', 'name' => 'La Celle-Saint-Cloud', 'lat' => '48.8503', 'lng' => '2.1452'),
      array('postal_code' => '78173 CEDEX', 'name' => 'La Celle-Saint-Cloud', 'lat' => '48.8503', 'lng' => '2.1452'),
      array('postal_code' => '78159 CEDEX', 'name' => 'Le Chesnay', 'lat' => '48.8222', 'lng' => '2.1221'),
      array('postal_code' => '78182 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78180', 'name' => 'Montigny-le-Bretonneux', 'lat' => '48.7664', 'lng' => '2.0341'),
      array('postal_code' => '78165 CEDEX', 'name' => 'Marly-le-Roi', 'lat' => '48.8667', 'lng' => '2.0833'),
      array('postal_code' => '78185 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78188 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78189 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78181 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78179 CEDEX', 'name' => 'La Celle-Saint-Cloud', 'lat' => '48.8503', 'lng' => '2.1452'),
      array('postal_code' => '78184 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78190', 'name' => 'Trappes', 'lat' => '48.7741', 'lng' => '2.0178'),
      array('postal_code' => '78191 CEDEX', 'name' => 'Trappes', 'lat' => '48.7741', 'lng' => '2.0178'),
      array('postal_code' => '78193 CEDEX', 'name' => 'Trappes', 'lat' => '48.7741', 'lng' => '2.0178'),
      array('postal_code' => '78200', 'name' => 'Fontenay-Mauvoisin', 'lat' => '48.9651', 'lng' => '1.6529'),
      array('postal_code' => '78198 CEDEX', 'name' => 'Trappes', 'lat' => '48.7741', 'lng' => '2.0178'),
      array('postal_code' => '78203 CEDEX', 'name' => 'Mantes-la-Jolie', 'lat' => '48.9833', 'lng' => '1.7167'),
      array('postal_code' => '78192 CEDEX', 'name' => 'Trappes', 'lat' => '48.7741', 'lng' => '2.0178'),
      array('postal_code' => '78200', 'name' => 'Soindres', 'lat' => '48.9579', 'lng' => '1.6754'),
      array('postal_code' => '78195 CEDEX', 'name' => 'Trappes', 'lat' => '48.7741', 'lng' => '2.0178'),
      array('postal_code' => '78205 CEDEX', 'name' => 'Mantes-la-Jolie', 'lat' => '48.9833', 'lng' => '1.7167'),
      array('postal_code' => '78209 CEDEX', 'name' => 'Mantes-la-Jolie', 'lat' => '48.9833', 'lng' => '1.7167'),
      array('postal_code' => '78200', 'name' => 'Boinvilliers', 'lat' => '48.9176', 'lng' => '1.6612'),
      array('postal_code' => '78194 CEDEX', 'name' => 'Trappes', 'lat' => '48.7741', 'lng' => '2.0178'),
      array('postal_code' => '78199 CEDEX', 'name' => 'Trappes', 'lat' => '48.7741', 'lng' => '2.0178'),
      array('postal_code' => '78197 CEDEX', 'name' => 'Trappes', 'lat' => '48.7741', 'lng' => '2.0178'),
      array('postal_code' => '78204 CEDEX', 'name' => 'Mantes-la-Jolie', 'lat' => '48.9833', 'lng' => '1.7167'),
      array('postal_code' => '78196 CEDEX', 'name' => 'Trappes', 'lat' => '48.7741', 'lng' => '2.0178'),
      array('postal_code' => '78201 CEDEX', 'name' => 'Mantes-la-Jolie', 'lat' => '48.9833', 'lng' => '1.7167'),
      array('postal_code' => '78200', 'name' => 'Magnanville', 'lat' => '48.9680', 'lng' => '1.6784'),
      array('postal_code' => '78200', 'name' => 'Buchelay', 'lat' => '48.9793', 'lng' => '1.6703'),
      array('postal_code' => '78200', 'name' => 'Perdreauville', 'lat' => '48.9646', 'lng' => '1.6293'),
      array('postal_code' => '78200', 'name' => 'Favrieux', 'lat' => '48.9435', 'lng' => '1.6429'),
      array('postal_code' => '78200', 'name' => 'Boissy-Mauvoisin', 'lat' => '48.9632', 'lng' => '1.5782'),
      array('postal_code' => '78200', 'name' => 'Flacourt', 'lat' => '48.9278', 'lng' => '1.6469'),
      array('postal_code' => '78202 CEDEX', 'name' => 'Mantes-la-Jolie', 'lat' => '48.9833', 'lng' => '1.7167'),
      array('postal_code' => '78200', 'name' => 'Jouy-Mauvoisin', 'lat' => '48.9759', 'lng' => '1.6482'),
      array('postal_code' => '78200', 'name' => 'M_nerville', 'lat' => '48.9542', 'lng' => '1.6029'),
      array('postal_code' => '78207 CEDEX', 'name' => 'Mantes-la-Jolie', 'lat' => '48.9833', 'lng' => '1.7167'),
      array('postal_code' => '78200', 'name' => 'Mantes-la-Jolie', 'lat' => '48.9833', 'lng' => '1.7167'),
      array('postal_code' => '78208 CEDEX', 'name' => 'Mantes-la-Jolie', 'lat' => '48.9833', 'lng' => '1.7167'),
      array('postal_code' => '78221 CEDEX', 'name' => 'Viroflay', 'lat' => '48.8008', 'lng' => '2.1618'),
      array('postal_code' => '78206 CEDEX', 'name' => 'Mantes-la-Jolie', 'lat' => '48.9833', 'lng' => '1.7167'),
      array('postal_code' => '78230', 'name' => 'Le Pecq', 'lat' => '48.8932', 'lng' => '2.1037'),
      array('postal_code' => '78223 CEDEX', 'name' => 'Viroflay', 'lat' => '48.8008', 'lng' => '2.1618'),
      array('postal_code' => '78220', 'name' => 'Viroflay', 'lat' => '48.8008', 'lng' => '2.1618'),
      array('postal_code' => '78219 CEDEX', 'name' => 'Saint-Cyr-l��cole', 'lat' => '48.7987', 'lng' => '2.0681'),
      array('postal_code' => '78229 CEDEX', 'name' => 'Viroflay', 'lat' => '48.8008', 'lng' => '2.1618'),
      array('postal_code' => '78233 CEDEX', 'name' => 'Le Pecq', 'lat' => '48.8932', 'lng' => '2.1037'),
      array('postal_code' => '78212 CEDEX', 'name' => 'Saint-Cyr-l��cole', 'lat' => '48.7987', 'lng' => '2.0681'),
      array('postal_code' => '78243 CEDEX', 'name' => 'Chambourcy', 'lat' => '48.9066', 'lng' => '2.0410'),
      array('postal_code' => '78241 CEDEX', 'name' => 'Chambourcy', 'lat' => '48.9066', 'lng' => '2.0410'),
      array('postal_code' => '78214 CEDEX', 'name' => 'Saint-Cyr-l��cole', 'lat' => '48.7987', 'lng' => '2.0681'),
      array('postal_code' => '78210', 'name' => 'Saint-Cyr-l��cole', 'lat' => '48.7987', 'lng' => '2.0681'),
      array('postal_code' => '78239 CEDEX', 'name' => 'Le Pecq', 'lat' => '48.8932', 'lng' => '2.1037'),
      array('postal_code' => '78234 CEDEX', 'name' => 'Le Pecq', 'lat' => '48.8932', 'lng' => '2.1037'),
      array('postal_code' => '78231 CEDEX', 'name' => 'Le Pecq', 'lat' => '48.8932', 'lng' => '2.1037'),
      array('postal_code' => '78240', 'name' => 'Aigremont', 'lat' => '48.9045', 'lng' => '2.0192'),
      array('postal_code' => '78270', 'name' => 'Chaufour-l�s-Bonni�res', 'lat' => '49.0167', 'lng' => '1.4833'),
      array('postal_code' => '78270', 'name' => 'Bonni�res-sur-Seine', 'lat' => '49.0352', 'lng' => '1.5783'),
      array('postal_code' => '78270', 'name' => 'M_ricourt', 'lat' => '49.0358', 'lng' => '1.6255'),
      array('postal_code' => '78270', 'name' => 'Bennecourt', 'lat' => '49.0415', 'lng' => '1.5547'),
      array('postal_code' => '78242 CEDEX', 'name' => 'Chambourcy', 'lat' => '48.9066', 'lng' => '2.0410'),
      array('postal_code' => '78250', 'name' => 'Gaillon-sur-Montcient', 'lat' => '49.0333', 'lng' => '1.9000'),
      array('postal_code' => '78249 CEDEX', 'name' => 'Chambourcy', 'lat' => '48.9066', 'lng' => '2.0410'),
      array('postal_code' => '78222 CEDEX', 'name' => 'Viroflay', 'lat' => '48.8008', 'lng' => '2.1618'),
      array('postal_code' => '78240', 'name' => 'Chambourcy', 'lat' => '48.9066', 'lng' => '2.0410'),
      array('postal_code' => '78250', 'name' => 'Meulan-en-Yvelines', 'lat' => '49.0077', 'lng' => '1.9060'),
      array('postal_code' => '78250', 'name' => 'M_zy-sur-Seine', 'lat' => '49.0000', 'lng' => '1.8833'),
      array('postal_code' => '78260', 'name' => 'Ach�res', 'lat' => '48.9612', 'lng' => '2.0688'),
      array('postal_code' => '78250', 'name' => 'Tessancourt-sur-Aubette', 'lat' => '49.0229', 'lng' => '1.9222'),
      array('postal_code' => '78232 CEDEX', 'name' => 'Le Pecq', 'lat' => '48.8932', 'lng' => '2.1037'),
      array('postal_code' => '78270', 'name' => 'Blaru', 'lat' => '49.0481', 'lng' => '1.4795'),
      array('postal_code' => '78270', 'name' => 'Mousseaux-sur-Seine', 'lat' => '49.0441', 'lng' => '1.6472'),
      array('postal_code' => '78270', 'name' => 'La Villeneuve-en-Chevrie', 'lat' => '49.0147', 'lng' => '1.5267'),
      array('postal_code' => '78250', 'name' => 'Oinville-sur-Montcient', 'lat' => '49.0272', 'lng' => '1.8493'),
      array('postal_code' => '78250', 'name' => 'Hardricourt', 'lat' => '49.0078', 'lng' => '1.8939'),
      array('postal_code' => '78244 CEDEX', 'name' => 'Chambourcy', 'lat' => '48.9066', 'lng' => '2.0410'),
      array('postal_code' => '78270', 'name' => 'Port-Villez', 'lat' => '49.0622', 'lng' => '1.5231'),
      array('postal_code' => '78291 CEDEX', 'name' => 'Croissy-sur-Seine', 'lat' => '48.8792', 'lng' => '2.1384'),
      array('postal_code' => '78284 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78287 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78270', 'name' => 'Gommecourt', 'lat' => '49.0833', 'lng' => '1.6000'),
      array('postal_code' => '78270', 'name' => 'Jeufosse', 'lat' => '49.0356', 'lng' => '1.5452'),
      array('postal_code' => '78280', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78281 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78294 CEDEX', 'name' => 'Croissy-sur-Seine', 'lat' => '48.8792', 'lng' => '2.1384'),
      array('postal_code' => '78290', 'name' => 'Croissy-sur-Seine', 'lat' => '48.8792', 'lng' => '2.1384'),
      array('postal_code' => '78283 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78270', 'name' => 'Lommoye', 'lat' => '48.9937', 'lng' => '1.5130'),
      array('postal_code' => '78299 CEDEX', 'name' => 'Croissy-sur-Seine', 'lat' => '48.8792', 'lng' => '2.1384'),
      array('postal_code' => '78282 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78286 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78270', 'name' => 'Rolleboise', 'lat' => '49.0193', 'lng' => '1.6078'),
      array('postal_code' => '78270', 'name' => 'Cravent', 'lat' => '48.9911', 'lng' => '1.4894'),
      array('postal_code' => '78285 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78289 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78300', 'name' => 'Poissy', 'lat' => '48.9290', 'lng' => '2.0495'),
      array('postal_code' => '78270', 'name' => 'Limetz-Villez', 'lat' => '49.0667', 'lng' => '1.5500'),
      array('postal_code' => '78302 CEDEX', 'name' => 'Poissy', 'lat' => '48.9290', 'lng' => '2.0495'),
      array('postal_code' => '78308 CEDEX', 'name' => 'Poissy', 'lat' => '48.9290', 'lng' => '2.0495'),
      array('postal_code' => '78303 CEDEX', 'name' => 'Poissy', 'lat' => '48.9290', 'lng' => '2.0495'),
      array('postal_code' => '78306 CEDEX', 'name' => 'Poissy', 'lat' => '48.9290', 'lng' => '2.0495'),
      array('postal_code' => '78309 CEDEX', 'name' => 'Poissy', 'lat' => '48.9290', 'lng' => '2.0495'),
      array('postal_code' => '78310', 'name' => 'Coigni�res', 'lat' => '48.7501', 'lng' => '1.9208'),
      array('postal_code' => '78304 CEDEX', 'name' => 'Poissy', 'lat' => '48.9290', 'lng' => '2.0495'),
      array('postal_code' => '78292 CEDEX', 'name' => 'Croissy-sur-Seine', 'lat' => '48.8792', 'lng' => '2.1384'),
      array('postal_code' => '78301 CEDEX', 'name' => 'Poissy', 'lat' => '48.9290', 'lng' => '2.0495'),
      array('postal_code' => '78293 CEDEX', 'name' => 'Croissy-sur-Seine', 'lat' => '48.8792', 'lng' => '2.1384'),
      array('postal_code' => '78288 CEDEX', 'name' => 'Guyancourt', 'lat' => '48.7733', 'lng' => '2.0739'),
      array('postal_code' => '78307 CEDEX', 'name' => 'Poissy', 'lat' => '48.9290', 'lng' => '2.0495'),
      array('postal_code' => '78310', 'name' => 'Maurepas', 'lat' => '48.7649', 'lng' => '1.9292'),
      array('postal_code' => '78314 CEDEX', 'name' => 'Maurepas', 'lat' => '48.7649', 'lng' => '1.9292'),
      array('postal_code' => '78317 CEDEX', 'name' => 'Maurepas', 'lat' => '48.7649', 'lng' => '1.9292'),
      array('postal_code' => '78311 CEDEX', 'name' => 'Maurepas', 'lat' => '48.7649', 'lng' => '1.9292'),
      array('postal_code' => '78312 CEDEX', 'name' => 'Maurepas', 'lat' => '48.7649', 'lng' => '1.9292'),
      array('postal_code' => '78315 CEDEX', 'name' => 'Maurepas', 'lat' => '48.7649', 'lng' => '1.9292'),
      array('postal_code' => '78313 CEDEX', 'name' => 'Maurepas', 'lat' => '48.7649', 'lng' => '1.9292'),
      array('postal_code' => '78316 CEDEX', 'name' => 'Maurepas', 'lat' => '48.7649', 'lng' => '1.9292'),
      array('postal_code' => '78319 CEDEX', 'name' => 'Maurepas', 'lat' => '48.7649', 'lng' => '1.9292'),
      array('postal_code' => '78320', 'name' => 'Le Mesnil-Saint-Denis', 'lat' => '48.7449', 'lng' => '1.9559'),
      array('postal_code' => '78340', 'name' => 'Les Clayes-sous-Bois', 'lat' => '48.8221', 'lng' => '1.9868'),
      array('postal_code' => '78330', 'name' => 'Fontenay-le-Fleury', 'lat' => '48.8125', 'lng' => '2.0486'),
      array('postal_code' => '78345 CEDEX', 'name' => 'Les Clayes-sous-Bois', 'lat' => '48.8221', 'lng' => '1.9868'),
      array('postal_code' => '78320', 'name' => 'L_vis-Saint-Nom', 'lat' => '48.7167', 'lng' => '1.9500'),
      array('postal_code' => '78341 CEDEX', 'name' => 'Les Clayes-sous-Bois', 'lat' => '48.8221', 'lng' => '1.9868'),
      array('postal_code' => '78350', 'name' => 'Jouy-en-Josas', 'lat' => '48.7591', 'lng' => '2.1697'),
      array('postal_code' => '78344 CEDEX', 'name' => 'Les Clayes-sous-Bois', 'lat' => '48.8221', 'lng' => '1.9868'),
      array('postal_code' => '78320', 'name' => 'La Verri�re', 'lat' => '48.7520', 'lng' => '1.9465'),
      array('postal_code' => '78342 CEDEX', 'name' => 'Les Clayes-sous-Bois', 'lat' => '48.8221', 'lng' => '1.9868'),
      array('postal_code' => '78351 CEDEX', 'name' => 'Jouy-en-Josas', 'lat' => '48.7591', 'lng' => '2.1697'),
      array('postal_code' => '78321 CEDEX', 'name' => 'Le Mesnil-Saint-Denis', 'lat' => '48.7449', 'lng' => '1.9559'),
      array('postal_code' => '78370', 'name' => 'Plaisir', 'lat' => '48.8232', 'lng' => '1.9541'),
      array('postal_code' => '78354 CEDEX', 'name' => 'Jouy-en-Josas', 'lat' => '48.7591', 'lng' => '2.1697'),
      array('postal_code' => '78322 CEDEX', 'name' => 'Le Mesnil-Saint-Denis', 'lat' => '48.7449', 'lng' => '1.9559'),
      array('postal_code' => '78339 CEDEX', 'name' => 'Fontenay-le-Fleury', 'lat' => '48.8125', 'lng' => '2.0486'),
      array('postal_code' => '78331 CEDEX', 'name' => 'Fontenay-le-Fleury', 'lat' => '48.8125', 'lng' => '2.0486'),
      array('postal_code' => '78368 CEDEX', 'name' => 'Montesson', 'lat' => '48.9092', 'lng' => '2.1375'),
      array('postal_code' => '78353 CEDEX', 'name' => 'Jouy-en-Josas', 'lat' => '48.7591', 'lng' => '2.1697'),
      array('postal_code' => '78346 CEDEX', 'name' => 'Les Clayes-sous-Bois', 'lat' => '48.8221', 'lng' => '1.9868'),
      array('postal_code' => '78359 CEDEX', 'name' => 'Jouy-en-Josas', 'lat' => '48.7591', 'lng' => '2.1697'),
      array('postal_code' => '78363 CEDEX', 'name' => 'Montesson', 'lat' => '48.9092', 'lng' => '2.1375'),
      array('postal_code' => '78349 CEDEX', 'name' => 'Les Clayes-sous-Bois', 'lat' => '48.8221', 'lng' => '1.9868'),
      array('postal_code' => '78361 CEDEX', 'name' => 'Montesson', 'lat' => '48.9092', 'lng' => '2.1375'),
      array('postal_code' => '78355 CEDEX', 'name' => 'Jouy-en-Josas', 'lat' => '48.7591', 'lng' => '2.1697'),
      array('postal_code' => '78352 CEDEX', 'name' => 'Jouy-en-Josas', 'lat' => '48.7591', 'lng' => '2.1697'),
      array('postal_code' => '78364 CEDEX', 'name' => 'Montesson', 'lat' => '48.9092', 'lng' => '2.1375'),
      array('postal_code' => '78350', 'name' => 'Les Loges-en-Josas', 'lat' => '48.7638', 'lng' => '2.1400'),
      array('postal_code' => '78360', 'name' => 'Montesson', 'lat' => '48.9092', 'lng' => '2.1375'),
      array('postal_code' => '78356 CEDEX', 'name' => 'Jouy-en-Josas', 'lat' => '48.7591', 'lng' => '2.1697'),
      array('postal_code' => '78362 CEDEX', 'name' => 'Montesson', 'lat' => '48.9092', 'lng' => '2.1375'),
      array('postal_code' => '78374 CEDEX', 'name' => 'Plaisir', 'lat' => '48.8232', 'lng' => '1.9541'),
      array('postal_code' => '78376 CEDEX', 'name' => 'Plaisir', 'lat' => '48.8232', 'lng' => '1.9541'),
      array('postal_code' => '78375 CEDEX', 'name' => 'Plaisir', 'lat' => '48.8232', 'lng' => '1.9541'),
      array('postal_code' => '78373 CEDEX', 'name' => 'Plaisir', 'lat' => '48.8232', 'lng' => '1.9541'),
      array('postal_code' => '78378 CEDEX', 'name' => 'Plaisir', 'lat' => '48.8232', 'lng' => '1.9541'),
      array('postal_code' => '78372 CEDEX', 'name' => 'Plaisir', 'lat' => '48.8232', 'lng' => '1.9541'),
      array('postal_code' => '78377 CEDEX', 'name' => 'Plaisir', 'lat' => '48.8232', 'lng' => '1.9541'),
      array('postal_code' => '78379 CEDEX', 'name' => 'Plaisir', 'lat' => '48.8232', 'lng' => '1.9541'),
      array('postal_code' => '78371 CEDEX', 'name' => 'Plaisir', 'lat' => '48.8232', 'lng' => '1.9541'),
      array('postal_code' => '78400', 'name' => 'Chatou', 'lat' => '48.8898', 'lng' => '2.1586'),
      array('postal_code' => '78410', 'name' => 'Flins-sur-Seine', 'lat' => '48.9652', 'lng' => '1.8731'),
      array('postal_code' => '78403 CEDEX', 'name' => 'Chatou', 'lat' => '48.8898', 'lng' => '2.1586'),
      array('postal_code' => '78395 CEDEX', 'name' => 'Bois-d�Arcy', 'lat' => '48.7997', 'lng' => '2.0232'),
      array('postal_code' => '78380', 'name' => 'Bougival', 'lat' => '48.8622', 'lng' => '2.1415'),
      array('postal_code' => '78439 CEDEX', 'name' => 'Louveciennes', 'lat' => '48.8612', 'lng' => '2.1146'),
      array('postal_code' => '78429 CEDEX', 'name' => 'Carri�res-sur-Seine', 'lat' => '48.9069', 'lng' => '2.1792'),
      array('postal_code' => '78391 CEDEX', 'name' => 'Bois-d�Arcy', 'lat' => '48.7997', 'lng' => '2.0232'),
      array('postal_code' => '78417 CEDEX', 'name' => 'Aubergenville', 'lat' => '48.9600', 'lng' => '1.8547'),
      array('postal_code' => '78423 CEDEX', 'name' => 'Carri�res-sur-Seine', 'lat' => '48.9069', 'lng' => '2.1792'),
      array('postal_code' => '78401 CEDEX', 'name' => 'Chatou', 'lat' => '48.8898', 'lng' => '2.1586'),
      array('postal_code' => '78410', 'name' => 'Aubergenville', 'lat' => '48.9600', 'lng' => '1.8547'),
      array('postal_code' => '78409 CEDEX', 'name' => 'Chatou', 'lat' => '48.8898', 'lng' => '2.1586'),
      array('postal_code' => '78390', 'name' => 'Bois-d�Arcy', 'lat' => '48.7997', 'lng' => '2.0232'),
      array('postal_code' => '78410', 'name' => 'La Falaise', 'lat' => '48.9436', 'lng' => '1.8299'),
      array('postal_code' => '78430', 'name' => 'Louveciennes', 'lat' => '48.8612', 'lng' => '2.1146'),
      array('postal_code' => '78413 CEDEX', 'name' => 'Aubergenville', 'lat' => '48.9600', 'lng' => '1.8547'),
      array('postal_code' => '78422 CEDEX', 'name' => 'Carri�res-sur-Seine', 'lat' => '48.9069', 'lng' => '2.1792'),
      array('postal_code' => '78440', 'name' => 'Guitrancourt', 'lat' => '49.0095', 'lng' => '1.7765'),
      array('postal_code' => '78404 CEDEX', 'name' => 'Chatou', 'lat' => '48.8898', 'lng' => '2.1586'),
      array('postal_code' => '78410', 'name' => 'N_zel', 'lat' => '48.9445', 'lng' => '1.8392'),
      array('postal_code' => '78420', 'name' => 'Carri�res-sur-Seine', 'lat' => '48.9069', 'lng' => '2.1792'),
      array('postal_code' => '78410', 'name' => 'Bouafle', 'lat' => '48.9646', 'lng' => '1.9012'),
      array('postal_code' => '78416 CEDEX', 'name' => 'Aubergenville', 'lat' => '48.9600', 'lng' => '1.8547'),
      array('postal_code' => '78402 CEDEX', 'name' => 'Chatou', 'lat' => '48.8898', 'lng' => '2.1586'),
      array('postal_code' => '78412 CEDEX', 'name' => 'Aubergenville', 'lat' => '48.9600', 'lng' => '1.8547'),
      array('postal_code' => '78411 CEDEX', 'name' => 'Aubergenville', 'lat' => '48.9600', 'lng' => '1.8547'),
      array('postal_code' => '78415 CEDEX', 'name' => 'Aubergenville', 'lat' => '48.9600', 'lng' => '1.8547'),
      array('postal_code' => '78431 CEDEX', 'name' => 'Louveciennes', 'lat' => '48.8612', 'lng' => '2.1146'),
      array('postal_code' => '78419 CEDEX', 'name' => 'Aubergenville', 'lat' => '48.9600', 'lng' => '1.8547'),
      array('postal_code' => '78421 CEDEX', 'name' => 'Carri�res-sur-Seine', 'lat' => '48.9069', 'lng' => '2.1792'),
      array('postal_code' => '78440', 'name' => 'Drocourt', 'lat' => '49.0571', 'lng' => '1.7669'),
      array('postal_code' => '78440', 'name' => 'Sailly', 'lat' => '49.0412', 'lng' => '1.8011'),
      array('postal_code' => '78424 CEDEX', 'name' => 'Carri�res-sur-Seine', 'lat' => '48.9069', 'lng' => '2.1792'),
      array('postal_code' => '78440', 'name' => 'Fontenay-Saint-P�re', 'lat' => '49.0247', 'lng' => '1.7578'),
      array('postal_code' => '78440', 'name' => 'Porcheville', 'lat' => '48.9725', 'lng' => '1.7797'),
      array('postal_code' => '78457 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78440', 'name' => 'Gargenville', 'lat' => '48.9880', 'lng' => '1.8118'),
      array('postal_code' => '78440', 'name' => 'Jambville', 'lat' => '49.0457', 'lng' => '1.8528'),
      array('postal_code' => '78440', 'name' => 'Lainville-en-Vexin', 'lat' => '49.0667', 'lng' => '1.8167'),
      array('postal_code' => '78440', 'name' => 'Brueil-en-Vexin', 'lat' => '49.0333', 'lng' => '1.8167'),
      array('postal_code' => '78451 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78440', 'name' => 'Issou', 'lat' => '48.9899', 'lng' => '1.7929'),
      array('postal_code' => '78450', 'name' => 'Villepreux', 'lat' => '48.8281', 'lng' => '1.9976'),
      array('postal_code' => '78450', 'name' => 'Chavenay', 'lat' => '48.8544', 'lng' => '1.9916'),
      array('postal_code' => '78470', 'name' => 'Milon-la-Chapelle', 'lat' => '48.7264', 'lng' => '2.0493'),
      array('postal_code' => '78460', 'name' => 'Choisel', 'lat' => '48.6877', 'lng' => '2.0182'),
      array('postal_code' => '78458 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78440', 'name' => 'Montalet-le-Bois', 'lat' => '49.0466', 'lng' => '1.8265'),
      array('postal_code' => '78470', 'name' => 'Saint-Lambert', 'lat' => '48.7318', 'lng' => '2.0197'),
      array('postal_code' => '78460', 'name' => 'Chevreuse', 'lat' => '48.7066', 'lng' => '2.0333'),
      array('postal_code' => '78479 CEDEX', 'name' => 'Saint-R_my-l�s-Chevreuse', 'lat' => '48.7071', 'lng' => '2.0769'),
      array('postal_code' => '78480', 'name' => 'Verneuil-sur-Seine', 'lat' => '48.9739', 'lng' => '1.9648'),
      array('postal_code' => '78471 CEDEX', 'name' => 'Saint-R_my-l�s-Chevreuse', 'lat' => '48.7071', 'lng' => '2.0769'),
      array('postal_code' => '78472 CEDEX', 'name' => 'Saint-R_my-l�s-Chevreuse', 'lat' => '48.7071', 'lng' => '2.0769'),
      array('postal_code' => '78470', 'name' => 'Saint-R_my-l�s-Chevreuse', 'lat' => '48.7071', 'lng' => '2.0769'),
      array('postal_code' => '78490', 'name' => 'Gambaiseuil', 'lat' => '48.7567', 'lng' => '1.7321'),
      array('postal_code' => '78490', 'name' => 'Boissy-sans-Avoir', 'lat' => '48.8167', 'lng' => '1.8000'),
      array('postal_code' => '78490', 'name' => 'Grosrouvre', 'lat' => '48.7821', 'lng' => '1.7617'),
      array('postal_code' => '78490', 'name' => 'Montfort-l�Amaury', 'lat' => '48.7728', 'lng' => '1.8131'),
      array('postal_code' => '78490', 'name' => 'Mareil-le-Guyon', 'lat' => '48.7896', 'lng' => '1.8522'),
      array('postal_code' => '78500', 'name' => 'Sartrouville', 'lat' => '48.9482', 'lng' => '2.1917'),
      array('postal_code' => '78490', 'name' => 'Galluis', 'lat' => '48.7966', 'lng' => '1.7941'),
      array('postal_code' => '78490', 'name' => 'M_r_', 'lat' => '48.7845', 'lng' => '1.8125'),
      array('postal_code' => '78490', 'name' => 'Vicq', 'lat' => '48.8148', 'lng' => '1.8354'),
      array('postal_code' => '78490', 'name' => 'Bazoches-sur-Guyonne', 'lat' => '48.7783', 'lng' => '1.8554'),
      array('postal_code' => '78490', 'name' => 'Le Tremblay-sur-Mauldre', 'lat' => '48.7782', 'lng' => '1.8778'),
      array('postal_code' => '78490', 'name' => 'Les Mesnuls', 'lat' => '48.7565', 'lng' => '1.8446'),
      array('postal_code' => '78502 CEDEX', 'name' => 'Sartrouville', 'lat' => '48.9482', 'lng' => '2.1917'),
      array('postal_code' => '78501 CEDEX', 'name' => 'Sartrouville', 'lat' => '48.9482', 'lng' => '2.1917'),
      array('postal_code' => '78507 CEDEX', 'name' => 'Sartrouville', 'lat' => '48.9482', 'lng' => '2.1917'),
      array('postal_code' => '78511 CEDEX', 'name' => 'Rambouillet', 'lat' => '48.6500', 'lng' => '1.8333'),
      array('postal_code' => '78506 CEDEX', 'name' => 'Sartrouville', 'lat' => '48.9482', 'lng' => '2.1917'),
      array('postal_code' => '78503 CEDEX', 'name' => 'Sartrouville', 'lat' => '48.9482', 'lng' => '2.1917'),
      array('postal_code' => '78520', 'name' => 'Follainville-Dennemont', 'lat' => '49.0219', 'lng' => '1.7133'),
      array('postal_code' => '78530', 'name' => 'Buc', 'lat' => '48.7763', 'lng' => '2.1258'),
      array('postal_code' => '78520', 'name' => 'Saint-Martin-la-Garenne', 'lat' => '49.0410', 'lng' => '1.6893'),
      array('postal_code' => '78510', 'name' => 'Triel-sur-Seine', 'lat' => '48.9782', 'lng' => '2.0074'),
      array('postal_code' => '78504 CEDEX', 'name' => 'Sartrouville', 'lat' => '48.9482', 'lng' => '2.1917'),
      array('postal_code' => '78520', 'name' => 'Limay', 'lat' => '48.9955', 'lng' => '1.7408'),
      array('postal_code' => '78512 CEDEX', 'name' => 'Rambouillet', 'lat' => '48.6500', 'lng' => '1.8333'),
      array('postal_code' => '78505 CEDEX', 'name' => 'Sartrouville', 'lat' => '48.9482', 'lng' => '2.1917'),
      array('postal_code' => '78520', 'name' => 'Guernes', 'lat' => '49.0112', 'lng' => '1.6368'),
      array('postal_code' => '78509 CEDEX', 'name' => 'Sartrouville', 'lat' => '48.9482', 'lng' => '2.1917'),
      array('postal_code' => '78513 CEDEX', 'name' => 'Rambouillet', 'lat' => '48.6500', 'lng' => '1.8333'),
      array('postal_code' => '78533 CEDEX', 'name' => 'Buc', 'lat' => '48.7763', 'lng' => '2.1258'),
      array('postal_code' => '78531 CEDEX', 'name' => 'Buc', 'lat' => '48.7763', 'lng' => '2.1258'),
      array('postal_code' => '78535 CEDEX', 'name' => 'Buc', 'lat' => '48.7763', 'lng' => '2.1258'),
      array('postal_code' => '78514 CEDEX', 'name' => 'Rambouillet', 'lat' => '48.6500', 'lng' => '1.8333'),
      array('postal_code' => '78519 CEDEX', 'name' => 'Rambouillet', 'lat' => '48.6500', 'lng' => '1.8333'),
      array('postal_code' => '78515 CEDEX', 'name' => 'Rambouillet', 'lat' => '48.6500', 'lng' => '1.8333'),
      array('postal_code' => '78550', 'name' => 'Gressey', 'lat' => '48.8353', 'lng' => '1.6091'),
      array('postal_code' => '78604 CEDEX', 'name' => 'Maisons-Laffitte', 'lat' => '48.9526', 'lng' => '2.1452'),
      array('postal_code' => '78590', 'name' => 'Noisy-le-Roi', 'lat' => '48.8445', 'lng' => '2.0634'),
      array('postal_code' => '78550', 'name' => 'Richebourg', 'lat' => '48.8244', 'lng' => '1.6404'),
      array('postal_code' => '78536 CEDEX', 'name' => 'Buc', 'lat' => '48.7763', 'lng' => '2.1258'),
      array('postal_code' => '78603 CEDEX', 'name' => 'Maisons-Laffitte', 'lat' => '48.9526', 'lng' => '2.1452'),
      array('postal_code' => '78570', 'name' => 'Chanteloup-les-Vignes', 'lat' => '48.9761', 'lng' => '2.0326'),
      array('postal_code' => '78570', 'name' => 'Andr_sy', 'lat' => '48.9823', 'lng' => '2.0569'),
      array('postal_code' => '78532 CEDEX', 'name' => 'Buc', 'lat' => '48.7763', 'lng' => '2.1258'),
      array('postal_code' => '78534 CEDEX', 'name' => 'Buc', 'lat' => '48.7763', 'lng' => '2.1258'),
      array('postal_code' => '78540', 'name' => 'Vernouillet', 'lat' => '48.9715', 'lng' => '1.9808'),
      array('postal_code' => '78550', 'name' => 'Bazainville', 'lat' => '48.8044', 'lng' => '1.6673'),
      array('postal_code' => '78580', 'name' => 'Jumeauville', 'lat' => '48.9110', 'lng' => '1.7874'),
      array('postal_code' => '78550', 'name' => 'Dannemarie', 'lat' => '48.7614', 'lng' => '1.6084'),
      array('postal_code' => '78580', 'name' => 'Les Alluets-le-Roi', 'lat' => '48.9138', 'lng' => '1.9181'),
      array('postal_code' => '78609 CEDEX', 'name' => 'Maisons-Laffitte', 'lat' => '48.9526', 'lng' => '2.1452'),
      array('postal_code' => '78539 CEDEX', 'name' => 'Buc', 'lat' => '48.7763', 'lng' => '2.1258'),
      array('postal_code' => '78591 CEDEX', 'name' => 'Noisy-le-Roi', 'lat' => '48.8445', 'lng' => '2.0634'),
      array('postal_code' => '78580', 'name' => 'Maule', 'lat' => '48.9106', 'lng' => '1.8526'),
      array('postal_code' => '78601 CEDEX', 'name' => 'Maisons-Laffitte', 'lat' => '48.9526', 'lng' => '2.1452'),
      array('postal_code' => '78600', 'name' => 'Le Mesnil-le-Roi', 'lat' => '48.9382', 'lng' => '2.1255'),
      array('postal_code' => '78580', 'name' => 'Bazemont', 'lat' => '48.9273', 'lng' => '1.8665'),
      array('postal_code' => '78605 CEDEX', 'name' => 'Maisons-Laffitte', 'lat' => '48.9526', 'lng' => '2.1452'),
      array('postal_code' => '78550', 'name' => 'Houdan', 'lat' => '48.7904', 'lng' => '1.6001'),
      array('postal_code' => '78560', 'name' => 'Le Port-Marly', 'lat' => '48.8902', 'lng' => '2.1114'),
      array('postal_code' => '78550', 'name' => 'Maulette', 'lat' => '48.7929', 'lng' => '1.6215'),
      array('postal_code' => '78580', 'name' => 'Herbeville', 'lat' => '48.9064', 'lng' => '1.8874'),
      array('postal_code' => '78592 CEDEX', 'name' => 'Noisy-le-Roi', 'lat' => '48.8445', 'lng' => '2.0634'),
      array('postal_code' => '78599 CEDEX', 'name' => 'Noisy-le-Roi', 'lat' => '48.8445', 'lng' => '2.0634'),
      array('postal_code' => '78602 CEDEX', 'name' => 'Maisons-Laffitte', 'lat' => '48.9526', 'lng' => '2.1452'),
      array('postal_code' => '78590', 'name' => 'Rennemoulin', 'lat' => '48.8341', 'lng' => '2.0445'),
      array('postal_code' => '78600', 'name' => 'Maisons-Laffitte', 'lat' => '48.9526', 'lng' => '2.1452'),
      array('postal_code' => '78606 CEDEX', 'name' => 'Maisons-Laffitte', 'lat' => '48.9526', 'lng' => '2.1452'),
      array('postal_code' => '78610', 'name' => 'Les Br_viaires', 'lat' => '48.7077', 'lng' => '1.8138'),
      array('postal_code' => '78630', 'name' => 'Morainvilliers', 'lat' => '48.9290', 'lng' => '1.9362'),
      array('postal_code' => '78650', 'name' => 'Saulx-Marchais', 'lat' => '48.8380', 'lng' => '1.8376'),
      array('postal_code' => '78620', 'name' => 'L��tang-la-Ville', 'lat' => '48.8695', 'lng' => '2.0573'),
      array('postal_code' => '78640', 'name' => 'Neauphle-le-Vieux', 'lat' => '48.8155', 'lng' => '1.8620'),
      array('postal_code' => '78619 CEDEX', 'name' => 'Le Perray-en-Yvelines', 'lat' => '48.6944', 'lng' => '1.8564'),
      array('postal_code' => '78640', 'name' => 'Villiers-Saint-Fr_deric', 'lat' => '48.8167', 'lng' => '1.8833'),
      array('postal_code' => '78610', 'name' => 'Saint-L_ger-en-Yvelines', 'lat' => '48.7217', 'lng' => '1.7664'),
      array('postal_code' => '78612 CEDEX', 'name' => 'Le Perray-en-Yvelines', 'lat' => '48.6944', 'lng' => '1.8564'),
      array('postal_code' => '78640', 'name' => 'Neauphle-le-Ch_teau', 'lat' => '48.8142', 'lng' => '1.9057'),
      array('postal_code' => '78610', 'name' => 'Le Perray-en-Yvelines', 'lat' => '48.6944', 'lng' => '1.8564'),
      array('postal_code' => '78630', 'name' => 'Orgeval', 'lat' => '48.9216', 'lng' => '1.9779'),
      array('postal_code' => '78660', 'name' => 'Paray-Douaville', 'lat' => '48.4637', 'lng' => '1.8775'),
      array('postal_code' => '78660', 'name' => 'Saint-Martin-de-Br_thencourt', 'lat' => '48.5097', 'lng' => '1.9283'),
      array('postal_code' => '78660', 'name' => 'Boinville-le-Gaillard', 'lat' => '48.4942', 'lng' => '1.8723'),
      array('postal_code' => '78660', 'name' => 'Prunay-en-Yvelines', 'lat' => '48.5333', 'lng' => '1.8000'),
      array('postal_code' => '78640', 'name' => 'Saint-Germain-de-la-Grange', 'lat' => '48.8344', 'lng' => '1.8988'),
      array('postal_code' => '78610', 'name' => 'Auffargis', 'lat' => '48.7005', 'lng' => '1.8870'),
      array('postal_code' => '78660', 'name' => 'Orsonville', 'lat' => '48.4764', 'lng' => '1.8364'),
      array('postal_code' => '78650', 'name' => 'Beynes', 'lat' => '48.8563', 'lng' => '1.8726'),
      array('postal_code' => '78660', 'name' => 'Ablis', 'lat' => '48.5172', 'lng' => '1.8362'),
      array('postal_code' => '78690', 'name' => 'Saint-R_my-l�Honor_', 'lat' => '48.7563', 'lng' => '1.8808'),
      array('postal_code' => '78690', 'name' => 'Les Essarts-le-Roi', 'lat' => '48.7167', 'lng' => '1.9009'),
      array('postal_code' => '78660', 'name' => 'Allainville', 'lat' => '48.4569', 'lng' => '1.8958'),
      array('postal_code' => '78680', 'name' => '�p�ne', 'lat' => '48.9548', 'lng' => '1.8223'),
      array('postal_code' => '78670', 'name' => 'M_dan', 'lat' => '48.9554', 'lng' => '1.9949'),
      array('postal_code' => '78670', 'name' => 'Villennes-sur-Seine', 'lat' => '48.9414', 'lng' => '1.9914'),
      array('postal_code' => '78711', 'name' => 'Mantes-la-Ville', 'lat' => '48.9737', 'lng' => '1.7025'),
      array('postal_code' => '78720', 'name' => 'La Celle-les-Bordes', 'lat' => '48.6357', 'lng' => '1.9532'),
      array('postal_code' => '78712 CEDEX', 'name' => 'Mantes-la-Jolie', 'lat' => '48.9833', 'lng' => '1.7167'),
      array('postal_code' => '78718 CEDEX', 'name' => 'Mantes-la-Jolie', 'lat' => '48.9833', 'lng' => '1.7167'),
      array('postal_code' => '78705 CEDEX', 'name' => 'Conflans-Sainte-Honorine', 'lat' => '49.0016', 'lng' => '2.0969'),
      array('postal_code' => '78703 CEDEX', 'name' => 'Conflans-Sainte-Honorine', 'lat' => '49.0016', 'lng' => '2.0969'),
      array('postal_code' => '78702 CEDEX', 'name' => 'Conflans-Sainte-Honorine', 'lat' => '49.0016', 'lng' => '2.0969'),
      array('postal_code' => '78700', 'name' => 'Conflans-Sainte-Honorine', 'lat' => '49.0016', 'lng' => '2.0969'),
      array('postal_code' => '78701 CEDEX', 'name' => 'Conflans-Sainte-Honorine', 'lat' => '49.0016', 'lng' => '2.0969'),
      array('postal_code' => '78720', 'name' => 'Saint-Forget', 'lat' => '48.7000', 'lng' => '2.0000'),
      array('postal_code' => '78713 CEDEX', 'name' => 'Mantes-la-Jolie', 'lat' => '48.9833', 'lng' => '1.7167'),
      array('postal_code' => '78720', 'name' => 'Senlisse', 'lat' => '48.6883', 'lng' => '1.9819'),
      array('postal_code' => '78720', 'name' => 'Dampierre-en-Yvelines', 'lat' => '48.7000', 'lng' => '1.9833'),
      array('postal_code' => '78730', 'name' => 'Saint-Arnoult-en-Yvelines', 'lat' => '48.5711', 'lng' => '1.9395'),
      array('postal_code' => '78730', 'name' => 'Sainte-Mesme', 'lat' => '48.5304', 'lng' => '1.9557'),
      array('postal_code' => '78709 CEDEX', 'name' => 'Conflans-Sainte-Honorine', 'lat' => '49.0016', 'lng' => '2.0969'),
      array('postal_code' => '78714 CEDEX', 'name' => 'Mantes-la-Jolie', 'lat' => '48.9833', 'lng' => '1.7167'),
      array('postal_code' => '78710', 'name' => 'Rosny-sur-Seine', 'lat' => '48.9981', 'lng' => '1.6313'),
      array('postal_code' => '78715 CEDEX', 'name' => 'Mantes-la-Jolie', 'lat' => '48.9833', 'lng' => '1.7167'),
      array('postal_code' => '78740', 'name' => 'Vaux-sur-Seine', 'lat' => '49.0127', 'lng' => '1.9694'),
      array('postal_code' => '78790', 'name' => 'Rosay', 'lat' => '48.9171', 'lng' => '1.6783'),
      array('postal_code' => '78770', 'name' => 'Goupilli�res', 'lat' => '48.8806', 'lng' => '1.7656'),
      array('postal_code' => '78790', 'name' => 'Arnouville-l�s-Mantes', 'lat' => '48.9101', 'lng' => '1.7311'),
      array('postal_code' => '78806 CEDEX', 'name' => 'Houilles', 'lat' => '48.9216', 'lng' => '2.1926'),
      array('postal_code' => '78730', 'name' => 'Ponth_vrard', 'lat' => '48.5519', 'lng' => '1.9105'),
      array('postal_code' => '78770', 'name' => 'Thoiry', 'lat' => '48.8671', 'lng' => '1.7976'),
      array('postal_code' => '78770', 'name' => 'Auteuil', 'lat' => '48.8410', 'lng' => '1.8175'),
      array('postal_code' => '78740', 'name' => '�vecquemont', 'lat' => '49.0144', 'lng' => '1.9442'),
      array('postal_code' => '78790', 'name' => 'Courgent', 'lat' => '48.8951', 'lng' => '1.6584'),
      array('postal_code' => '78720', 'name' => 'Cernay-la-Ville', 'lat' => '48.6732', 'lng' => '1.9742'),
      array('postal_code' => '78730', 'name' => 'Longvilliers', 'lat' => '48.5788', 'lng' => '1.9907'),
      array('postal_code' => '78770', 'name' => 'Autouillet', 'lat' => '48.8481', 'lng' => '1.8037'),
      array('postal_code' => '78790', 'name' => 'Hargeville', 'lat' => '48.8902', 'lng' => '1.7402'),
      array('postal_code' => '78770', 'name' => 'Andelu', 'lat' => '48.8813', 'lng' => '1.8258'),
      array('postal_code' => '78803 CEDEX', 'name' => 'Houilles', 'lat' => '48.9216', 'lng' => '2.1926'),
      array('postal_code' => '78780', 'name' => 'Maurecourt', 'lat' => '48.9961', 'lng' => '2.0615'),
      array('postal_code' => '78730', 'name' => 'Rochefort-en-Yvelines', 'lat' => '48.5852', 'lng' => '1.9877'),
      array('postal_code' => '78779 CEDEX', 'name' => 'Magny-les-Hameaux', 'lat' => '48.7435', 'lng' => '2.0615'),
      array('postal_code' => '78790', 'name' => 'Mulcent', 'lat' => '48.8787', 'lng' => '1.6519'),
      array('postal_code' => '78790', 'name' => 'Montchauvet', 'lat' => '48.8913', 'lng' => '1.6313'),
      array('postal_code' => '78801 CEDEX', 'name' => 'Houilles', 'lat' => '48.9216', 'lng' => '2.1926'),
      array('postal_code' => '78800', 'name' => 'Houilles', 'lat' => '48.9216', 'lng' => '2.1926'),
      array('postal_code' => '78830', 'name' => 'Bullion', 'lat' => '48.6229', 'lng' => '1.9902'),
      array('postal_code' => '78802 CEDEX', 'name' => 'Houilles', 'lat' => '48.9216', 'lng' => '2.1926'),
      array('postal_code' => '78790', 'name' => 'Tilly', 'lat' => '48.8824', 'lng' => '1.5767'),
      array('postal_code' => '78778 CEDEX', 'name' => 'Magny-les-Hameaux', 'lat' => '48.7435', 'lng' => '2.0615'),
      array('postal_code' => '78790', 'name' => 'Saint-Martin-des-Champs', 'lat' => '48.8817', 'lng' => '1.7168'),
      array('postal_code' => '78770', 'name' => 'Marcq', 'lat' => '48.8586', 'lng' => '1.8251'),
      array('postal_code' => '78804 CEDEX', 'name' => 'Houilles', 'lat' => '48.9216', 'lng' => '2.1926'),
      array('postal_code' => '78790', 'name' => 'Flins-Neuve-�glise', 'lat' => '48.8914', 'lng' => '1.5792'),
      array('postal_code' => '78760', 'name' => 'Jouars-Pontchartrain', 'lat' => '48.7889', 'lng' => '1.8990'),
      array('postal_code' => '78771 CEDEX', 'name' => 'Magny-les-Hameaux', 'lat' => '48.7435', 'lng' => '2.0615'),
      array('postal_code' => '78805 CEDEX', 'name' => 'Houilles', 'lat' => '48.9216', 'lng' => '2.1926'),
      array('postal_code' => '78790', 'name' => 'Septeuil', 'lat' => '48.8925', 'lng' => '1.6836'),
      array('postal_code' => '78750', 'name' => 'Mareil-Marly', 'lat' => '48.8821', 'lng' => '2.0735'),
      array('postal_code' => '78770', 'name' => 'Villiers-le-Mahieu', 'lat' => '48.8607', 'lng' => '1.7718'),
      array('postal_code' => '78840', 'name' => 'Moisson', 'lat' => '49.0735', 'lng' => '1.6687'),
      array('postal_code' => '78870', 'name' => 'Bailly', 'lat' => '48.8417', 'lng' => '2.0767'),
      array('postal_code' => '78860', 'name' => 'Saint-Nom-la-Bret�che', 'lat' => '48.8594', 'lng' => '2.0223'),
      array('postal_code' => '78810', 'name' => 'Davron', 'lat' => '48.8655', 'lng' => '1.9471'),
      array('postal_code' => '78851 CEDEX', 'name' => '�lancourt', 'lat' => '48.7842', 'lng' => '1.9552'),
      array('postal_code' => '78897 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78910', 'name' => 'Flexanville', 'lat' => '48.8534', 'lng' => '1.7378'),
      array('postal_code' => '78840', 'name' => 'Freneuse', 'lat' => '49.0483', 'lng' => '1.6017'),
      array('postal_code' => '78883 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78820', 'name' => 'Juziers', 'lat' => '48.9914', 'lng' => '1.8476'),
      array('postal_code' => '78810', 'name' => 'Feucherolles', 'lat' => '48.8700', 'lng' => '1.9740'),
      array('postal_code' => '78921 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78809 CEDEX', 'name' => 'Houilles', 'lat' => '48.9216', 'lng' => '2.1926'),
      array('postal_code' => '78830', 'name' => 'Bonnelles', 'lat' => '48.6182', 'lng' => '2.0292'),
      array('postal_code' => '78852 CEDEX', 'name' => '�lancourt', 'lat' => '48.7842', 'lng' => '1.9552'),
      array('postal_code' => '78859 CEDEX', 'name' => '�lancourt', 'lat' => '48.7842', 'lng' => '1.9552'),
      array('postal_code' => '78910', 'name' => 'Boissets', 'lat' => '48.8614', 'lng' => '1.5837'),
      array('postal_code' => '78850', 'name' => 'Thiverval-Grignon', 'lat' => '48.8496', 'lng' => '1.9173'),
      array('postal_code' => '78881 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78890', 'name' => 'Garanci�res', 'lat' => '48.8227', 'lng' => '1.7551'),
      array('postal_code' => '78854 CEDEX', 'name' => '�lancourt', 'lat' => '48.7842', 'lng' => '1.9552'),
      array('postal_code' => '78884 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78910', 'name' => 'B_houst', 'lat' => '48.8303', 'lng' => '1.7213'),
      array('postal_code' => '78882 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78885 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78910', 'name' => 'Prunay-le-Temple', 'lat' => '48.8614', 'lng' => '1.6740'),
      array('postal_code' => '78910', 'name' => 'Osmoy', 'lat' => '48.8634', 'lng' => '1.7171'),
      array('postal_code' => '78886 CEDEX', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78910', 'name' => 'Orgerus', 'lat' => '48.8385', 'lng' => '1.7013'),
      array('postal_code' => '78915 CEDEX', 'name' => 'Poissy', 'lat' => '48.9290', 'lng' => '2.0495'),
      array('postal_code' => '78924 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78922 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78910', 'name' => 'Orvilliers', 'lat' => '48.8600', 'lng' => '1.6476'),
      array('postal_code' => '78910', 'name' => 'Civry-la-For�t', 'lat' => '48.8656', 'lng' => '1.6109'),
      array('postal_code' => '78920', 'name' => 'Ecquevilly', 'lat' => '48.9519', 'lng' => '1.9234'),
      array('postal_code' => '78910', 'name' => 'Tacoigni�res', 'lat' => '48.8362', 'lng' => '1.6750'),
      array('postal_code' => '78929 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78923 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78930', 'name' => 'Guerville', 'lat' => '48.9439', 'lng' => '1.7343'),
      array('postal_code' => '78930', 'name' => 'Breuil-Bois-Robert', 'lat' => '48.9456', 'lng' => '1.7170'),
      array('postal_code' => '78925 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78927 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78928 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78926 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78980', 'name' => 'Le Tertre-Saint-Denis', 'lat' => '48.9382', 'lng' => '1.6067'),
      array('postal_code' => '78930', 'name' => 'Villette', 'lat' => '48.9277', 'lng' => '1.6921'),
      array('postal_code' => '78931 CEDEX', 'name' => 'Septeuil', 'lat' => '48.8925', 'lng' => '1.6836'),
      array('postal_code' => '78955', 'name' => 'Carri�res-sous-Poissy', 'lat' => '48.9495', 'lng' => '2.0407'),
      array('postal_code' => '78995 CEDEX', 'name' => '�lancourt', 'lat' => '48.7842', 'lng' => '1.9552'),
      array('postal_code' => '78930', 'name' => 'Boinville-en-Mantois', 'lat' => '48.9303', 'lng' => '1.7567'),
      array('postal_code' => '78990', 'name' => '�lancourt', 'lat' => '48.7842', 'lng' => '1.9552'),
      array('postal_code' => '78948 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78980', 'name' => 'Neauphlette', 'lat' => '48.9314', 'lng' => '1.5261'),
      array('postal_code' => '78942 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78970', 'name' => 'M_zi�res-sur-Seine', 'lat' => '48.9613', 'lng' => '1.7925'),
      array('postal_code' => '78980', 'name' => 'Saint-Illiers-le-Bois', 'lat' => '48.9590', 'lng' => '1.5060'),
      array('postal_code' => '78944 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78930', 'name' => 'Goussonville', 'lat' => '48.9201', 'lng' => '1.7644'),
      array('postal_code' => '78946 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78930', 'name' => 'Auffreville-Brasseuil', 'lat' => '48.9541', 'lng' => '1.7100'),
      array('postal_code' => '78940', 'name' => 'La Queue-les-Yvelines', 'lat' => '48.8000', 'lng' => '1.7667'),
      array('postal_code' => '78980', 'name' => 'Longnes', 'lat' => '48.9200', 'lng' => '1.5870'),
      array('postal_code' => '78960', 'name' => 'Voisins-le-Bretonneux', 'lat' => '48.7579', 'lng' => '2.0514'),
      array('postal_code' => '78950', 'name' => 'Gambais', 'lat' => '48.7735', 'lng' => '1.6720'),
      array('postal_code' => '78930', 'name' => 'Vert', 'lat' => '48.9429', 'lng' => '1.6922'),
      array('postal_code' => '78945 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78980', 'name' => 'Br_val', 'lat' => '48.9454', 'lng' => '1.5331'),
      array('postal_code' => '78940', 'name' => 'Millemont', 'lat' => '48.8094', 'lng' => '1.7446'),
      array('postal_code' => '78980', 'name' => 'Saint-Illiers-la-Ville', 'lat' => '48.9765', 'lng' => '1.5395'),
      array('postal_code' => '78996 CEDEX', 'name' => '�lancourt', 'lat' => '48.7842', 'lng' => '1.9552'),
      array('postal_code' => '91001 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '78949 CEDEX 9', 'name' => 'Saint-Quentin-en-Yvelines', 'lat' => '48.7732', 'lng' => '2.0191'),
      array('postal_code' => '78941 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '78943 CEDEX', 'name' => 'V_lizy-Villacoublay', 'lat' => '48.7820', 'lng' => '2.1939'),
      array('postal_code' => '91002 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '78997 CEDEX', 'name' => '�lancourt', 'lat' => '48.7842', 'lng' => '1.9552'),
      array('postal_code' => '91008 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91033 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91032 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91012 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91030 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91000', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91017 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91015 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91026 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91010 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91006 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91005 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91014 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91024 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91007 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '78980', 'name' => 'Mondreville', 'lat' => '48.9029', 'lng' => '1.5524'),
      array('postal_code' => '91019 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91018 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91031 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91028 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91042 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91029 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91023 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91003 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91016 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91025 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91011 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91009 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91022 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91034 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91043 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91036 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91013 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91021 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91004 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91035 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91048 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91038 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91027 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91037 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91041 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91020 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91072 CEDEX', 'name' => 'Bondoufle', 'lat' => '48.6129', 'lng' => '2.3777'),
      array('postal_code' => '91054 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91045 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91046 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91053 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91044 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91039 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91047 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91057 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91090', 'name' => 'Lisses', 'lat' => '48.6022', 'lng' => '2.4225'),
      array('postal_code' => '91051 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91055 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91040 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91074 CEDEX', 'name' => 'Bondoufle', 'lat' => '48.6129', 'lng' => '2.3777'),
      array('postal_code' => '91071 CEDEX', 'name' => 'Bondoufle', 'lat' => '48.6129', 'lng' => '2.3777'),
      array('postal_code' => '91080', 'name' => 'Courcouronnes', 'lat' => '48.6143', 'lng' => '2.4076'),
      array('postal_code' => '91049 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91050 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91056 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91058 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91052 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91059 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91077 CEDEX', 'name' => 'Bondoufle', 'lat' => '48.6129', 'lng' => '2.3777'),
      array('postal_code' => '91079 CEDEX', 'name' => 'Bondoufle', 'lat' => '48.6129', 'lng' => '2.3777'),
      array('postal_code' => '91070', 'name' => 'Bondoufle', 'lat' => '48.6129', 'lng' => '2.3777'),
      array('postal_code' => '91078 CEDEX', 'name' => 'Bondoufle', 'lat' => '48.6129', 'lng' => '2.3777'),
      array('postal_code' => '91097 CEDEX', 'name' => '�vry', 'lat' => '48.6328', 'lng' => '2.4405'),
      array('postal_code' => '91107 CEDEX', 'name' => 'Corbeil-Essonnes', 'lat' => '48.6060', 'lng' => '2.4876'),
      array('postal_code' => '91100', 'name' => 'Corbeil-Essonnes', 'lat' => '48.6060', 'lng' => '2.4876'),
      array('postal_code' => '91101 CEDEX', 'name' => 'Corbeil-Essonnes', 'lat' => '48.6060', 'lng' => '2.4876'),
      array('postal_code' => '91100', 'name' => 'Villab_', 'lat' => '48.5895', 'lng' => '2.4510'),
      array('postal_code' => '91102 CEDEX', 'name' => 'Corbeil-Essonnes', 'lat' => '48.6060', 'lng' => '2.4876'),
      array('postal_code' => '91103 CEDEX', 'name' => 'Corbeil-Essonnes', 'lat' => '48.6060', 'lng' => '2.4876'),
      array('postal_code' => '91126 CEDEX', 'name' => 'Palaiseau', 'lat' => '48.7167', 'lng' => '2.2500'),
      array('postal_code' => '91108 CEDEX', 'name' => 'Corbeil-Essonnes', 'lat' => '48.6060', 'lng' => '2.4876'),
      array('postal_code' => '91109 CEDEX', 'name' => 'Corbeil-Essonnes', 'lat' => '48.6060', 'lng' => '2.4876'),
      array('postal_code' => '91137 CEDEX', 'name' => 'Ris-Orangis', 'lat' => '48.6511', 'lng' => '2.4141'),
      array('postal_code' => '91133 CEDEX', 'name' => 'Ris-Orangis', 'lat' => '48.6511', 'lng' => '2.4141'),
      array('postal_code' => '91121 CEDEX', 'name' => 'Palaiseau', 'lat' => '48.7167', 'lng' => '2.2500'),
      array('postal_code' => '91127 CEDEX', 'name' => 'Palaiseau', 'lat' => '48.7167', 'lng' => '2.2500'),
      array('postal_code' => '91124 CEDEX', 'name' => 'Palaiseau', 'lat' => '48.7167', 'lng' => '2.2500'),
      array('postal_code' => '91104 CEDEX', 'name' => 'Corbeil-Essonnes', 'lat' => '48.6060', 'lng' => '2.4876'),
      array('postal_code' => '91140', 'name' => 'Villebon-sur-Yvette', 'lat' => '48.7059', 'lng' => '2.2402'),
      array('postal_code' => '91105 CEDEX', 'name' => 'Corbeil-Essonnes', 'lat' => '48.6060', 'lng' => '2.4876'),
      array('postal_code' => '91136 CEDEX', 'name' => 'Ris-Orangis', 'lat' => '48.6511', 'lng' => '2.4141'),
      array('postal_code' => '91106 CEDEX', 'name' => 'Corbeil-Essonnes', 'lat' => '48.6060', 'lng' => '2.4876'),
      array('postal_code' => '91125 CEDEX', 'name' => 'Palaiseau', 'lat' => '48.7167', 'lng' => '2.2500'),
      array('postal_code' => '91131 CEDEX', 'name' => 'Ris-Orangis', 'lat' => '48.6511', 'lng' => '2.4141'),
      array('postal_code' => '91120', 'name' => 'Palaiseau', 'lat' => '48.7167', 'lng' => '2.2500'),
      array('postal_code' => '91130', 'name' => 'Ris-Orangis', 'lat' => '48.6511', 'lng' => '2.4141'),
      array('postal_code' => '91122 CEDEX', 'name' => 'Palaiseau', 'lat' => '48.7167', 'lng' => '2.2500'),
      array('postal_code' => '91149 CEDEX', 'name' => 'Villebon-sur-Yvette', 'lat' => '48.7059', 'lng' => '2.2402'),
      array('postal_code' => '91123 CEDEX', 'name' => 'Palaiseau', 'lat' => '48.7167', 'lng' => '2.2500'),
      array('postal_code' => '91132 CEDEX', 'name' => 'Ris-Orangis', 'lat' => '48.6511', 'lng' => '2.4141'),
      array('postal_code' => '91135 CEDEX', 'name' => 'Ris-Orangis', 'lat' => '48.6511', 'lng' => '2.4141'),
      array('postal_code' => '91128 CEDEX', 'name' => 'Palaiseau', 'lat' => '48.7167', 'lng' => '2.2500'),
      array('postal_code' => '91129 CEDEX', 'name' => 'Palaiseau', 'lat' => '48.7167', 'lng' => '2.2500'),
      array('postal_code' => '91140', 'name' => 'Villejust', 'lat' => '48.6830', 'lng' => '2.2361'),
      array('postal_code' => '91141 CEDEX', 'name' => 'Villebon-sur-Yvette', 'lat' => '48.7059', 'lng' => '2.2402'),
      array('postal_code' => '91142 CEDEX', 'name' => 'Villebon-sur-Yvette', 'lat' => '48.7059', 'lng' => '2.2402'),
      array('postal_code' => '91150', 'name' => 'Blandy', 'lat' => '48.3142', 'lng' => '2.2573'),
      array('postal_code' => '91150', 'name' => 'Boutervilliers', 'lat' => '48.4527', 'lng' => '2.0557'),
      array('postal_code' => '91150', 'name' => 'Morigny-Champigny', 'lat' => '48.4468', 'lng' => '2.1835'),
      array('postal_code' => '91150', 'name' => 'Brouy', 'lat' => '48.3161', 'lng' => '2.2787'),
      array('postal_code' => '91150', 'name' => 'Bois-Herpin', 'lat' => '48.3705', 'lng' => '2.2357'),
      array('postal_code' => '91146 CEDEX', 'name' => 'Villebon-sur-Yvette', 'lat' => '48.7059', 'lng' => '2.2402'),
      array('postal_code' => '91150', 'name' => 'Mespuits', 'lat' => '48.3568', 'lng' => '2.2724'),
      array('postal_code' => '91150', 'name' => 'Puiselet-le-Marais', 'lat' => '48.4058', 'lng' => '2.2626'),
      array('postal_code' => '91150', 'name' => 'Bri�res-les-Scell_s', 'lat' => '48.4565', 'lng' => '2.1371'),
      array('postal_code' => '91150', 'name' => 'Champmotteux', 'lat' => '48.3433', 'lng' => '2.3195'),
      array('postal_code' => '91150', 'name' => 'Marolles-en-Beauce', 'lat' => '48.3748', 'lng' => '2.2005'),
      array('postal_code' => '91150', 'name' => 'Abb_ville-la-Rivi�re', 'lat' => '48.3468', 'lng' => '2.1659'),
      array('postal_code' => '91151 CEDEX', 'name' => '�tampes', 'lat' => '48.4333', 'lng' => '2.1500'),
      array('postal_code' => '91160', 'name' => 'Saulx-les-Chartreux', 'lat' => '48.6906', 'lng' => '2.2673'),
      array('postal_code' => '91160', 'name' => 'Longjumeau', 'lat' => '48.6950', 'lng' => '2.3074'),
      array('postal_code' => '91150', 'name' => '�tampes', 'lat' => '48.4333', 'lng' => '2.1500'),
      array('postal_code' => '91150', 'name' => 'Ormoy-la-Rivi�re', 'lat' => '48.4050', 'lng' => '2.1498'),
      array('postal_code' => '91153 CEDEX', 'name' => '�tampes', 'lat' => '48.4333', 'lng' => '2.1500'),
      array('postal_code' => '91156 CEDEX', 'name' => '�tampes', 'lat' => '48.4333', 'lng' => '2.1500'),
      array('postal_code' => '91158 CEDEX', 'name' => '�tampes', 'lat' => '48.4333', 'lng' => '2.1500'),
      array('postal_code' => '91150', 'name' => 'La For�t-Sainte-Croix', 'lat' => '48.3843', 'lng' => '2.2309'),
      array('postal_code' => '91154 CEDEX', 'name' => '�tampes', 'lat' => '48.4333', 'lng' => '2.1500'),
      array('postal_code' => '91150', 'name' => 'Roinvilliers', 'lat' => '48.3562', 'lng' => '2.2431'),
      array('postal_code' => '91157 CEDEX', 'name' => '�tampes', 'lat' => '48.4333', 'lng' => '2.1500'),
      array('postal_code' => '91159 CEDEX', 'name' => '�tampes', 'lat' => '48.4333', 'lng' => '2.1500'),
      array('postal_code' => '91161 CEDEX', 'name' => 'Longjumeau', 'lat' => '48.6950', 'lng' => '2.3074'),
      array('postal_code' => '91152 CEDEX', 'name' => '�tampes', 'lat' => '48.4333', 'lng' => '2.1500'),
      array('postal_code' => '91163 CEDEX', 'name' => 'Longjumeau', 'lat' => '48.6950', 'lng' => '2.3074'),
      array('postal_code' => '91160', 'name' => 'Champlan', 'lat' => '48.7082', 'lng' => '2.2797'),
      array('postal_code' => '91162 CEDEX', 'name' => 'Longjumeau', 'lat' => '48.6950', 'lng' => '2.3074'),
      array('postal_code' => '91190', 'name' => 'Gif-sur-Yvette', 'lat' => '48.6833', 'lng' => '2.1333'),
      array('postal_code' => '91180', 'name' => 'Saint-Germain-l�s-Arpajon', 'lat' => '48.5973', 'lng' => '2.2648'),
      array('postal_code' => '91167 CEDEX', 'name' => 'Longjumeau', 'lat' => '48.6950', 'lng' => '2.3074'),
      array('postal_code' => '91172 CEDEX', 'name' => 'Viry-Ch_tillon', 'lat' => '48.6721', 'lng' => '2.3932'),
      array('postal_code' => '91166 CEDEX', 'name' => 'Longjumeau', 'lat' => '48.6950', 'lng' => '2.3074'),
      array('postal_code' => '91169 CEDEX', 'name' => 'Longjumeau', 'lat' => '48.6950', 'lng' => '2.3074'),
      array('postal_code' => '91160', 'name' => 'Ballainvilliers', 'lat' => '48.6748', 'lng' => '2.3006'),
      array('postal_code' => '91178 CEDEX', 'name' => 'Viry-Ch_tillon', 'lat' => '48.6721', 'lng' => '2.3932'),
      array('postal_code' => '91171 CEDEX', 'name' => 'Viry-Ch_tillon', 'lat' => '48.6721', 'lng' => '2.3932'),
      array('postal_code' => '91173 CEDEX', 'name' => 'Viry-Ch_tillon', 'lat' => '48.6721', 'lng' => '2.3932'),
      array('postal_code' => '91164 CEDEX', 'name' => 'Longjumeau', 'lat' => '48.6950', 'lng' => '2.3074'),
      array('postal_code' => '91179 CEDEX', 'name' => 'Viry-Ch_tillon', 'lat' => '48.6721', 'lng' => '2.3932'),
      array('postal_code' => '91168 CEDEX', 'name' => 'Longjumeau', 'lat' => '48.6950', 'lng' => '2.3074'),
      array('postal_code' => '91170', 'name' => 'Viry-Ch_tillon', 'lat' => '48.6721', 'lng' => '2.3932'),
      array('postal_code' => '91165 CEDEX', 'name' => 'Longjumeau', 'lat' => '48.6950', 'lng' => '2.3074'),
      array('postal_code' => '91192 CEDEX', 'name' => 'Gif-sur-Yvette', 'lat' => '48.6833', 'lng' => '2.1333'),
      array('postal_code' => '91204 CEDEX', 'name' => 'Athis-Mons', 'lat' => '48.7052', 'lng' => '2.3915'),
      array('postal_code' => '91211 CEDEX', 'name' => 'Draveil', 'lat' => '48.6847', 'lng' => '2.4142'),
      array('postal_code' => '91198 CEDEX', 'name' => 'Gif-sur-Yvette', 'lat' => '48.6833', 'lng' => '2.1333'),
      array('postal_code' => '91205 CEDEX', 'name' => 'Athis-Mons', 'lat' => '48.7052', 'lng' => '2.3915'),
      array('postal_code' => '91191 CEDEX', 'name' => 'Gif-sur-Yvette', 'lat' => '48.6833', 'lng' => '2.1333'),
      array('postal_code' => '91174 CEDEX', 'name' => 'Viry-Ch_tillon', 'lat' => '48.6721', 'lng' => '2.3932'),
      array('postal_code' => '91200', 'name' => 'Athis-Mons', 'lat' => '48.7052', 'lng' => '2.3915'),
      array('postal_code' => '91197 CEDEX', 'name' => 'Gif-sur-Yvette', 'lat' => '48.6833', 'lng' => '2.1333'),
      array('postal_code' => '91196 CEDEX', 'name' => 'Gif-sur-Yvette', 'lat' => '48.6833', 'lng' => '2.1333'),
      array('postal_code' => '91177 CEDEX', 'name' => 'Viry-Ch_tillon', 'lat' => '48.6721', 'lng' => '2.3932'),
      array('postal_code' => '91207 CEDEX', 'name' => 'Athis-Mons', 'lat' => '48.7052', 'lng' => '2.3915'),
      array('postal_code' => '91210', 'name' => 'Draveil', 'lat' => '48.6847', 'lng' => '2.4142'),
      array('postal_code' => '91190', 'name' => 'Villiers-le-B_cle', 'lat' => '48.7282', 'lng' => '2.1193'),
      array('postal_code' => '91195 CEDEX', 'name' => 'Gif-sur-Yvette', 'lat' => '48.6833', 'lng' => '2.1333'),
      array('postal_code' => '91190', 'name' => 'Saint-Aubin', 'lat' => '48.7133', 'lng' => '2.1412'),
      array('postal_code' => '91209 CEDEX', 'name' => 'Athis-Mons', 'lat' => '48.7052', 'lng' => '2.3915'),
      array('postal_code' => '91193 CEDEX', 'name' => 'Gif-sur-Yvette', 'lat' => '48.6833', 'lng' => '2.1333'),
      array('postal_code' => '91199 CEDEX', 'name' => 'Gif-sur-Yvette', 'lat' => '48.6833', 'lng' => '2.1333'),
      array('postal_code' => '91201 CEDEX', 'name' => 'Athis-Mons', 'lat' => '48.7052', 'lng' => '2.3915')
    ],
    'CVL' => [
      array('postal_code' => '18002 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18005 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18021 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18014 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18000', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18004 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18006 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18001 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18031 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18013 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18007 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18015 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18026 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18003 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18034 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18025 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18036 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18012 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18016 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18020 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18033 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18023 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18024 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18028 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18035 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18019 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18027 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18022 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18037 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18030 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18029 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18032 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18039 CEDEX', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18110', 'name' => 'Saint-Martin-d�Auxigny', 'lat' => '47.2037', 'lng' => '2.4155'),
      array('postal_code' => '18104 CEDEX', 'name' => 'Vierzon', 'lat' => '47.2167', 'lng' => '2.0833'),
      array('postal_code' => '18100', 'name' => 'Th_nioux', 'lat' => '47.2561', 'lng' => '1.9357'),
      array('postal_code' => '18100', 'name' => 'Vierzon', 'lat' => '47.2167', 'lng' => '2.0833'),
      array('postal_code' => '18108 CEDEX', 'name' => 'Vierzon', 'lat' => '47.2167', 'lng' => '2.0833'),
      array('postal_code' => '18106 CEDEX', 'name' => 'Vierzon', 'lat' => '47.2167', 'lng' => '2.0833'),
      array('postal_code' => '18100', 'name' => 'M_ry-sur-Cher', 'lat' => '47.2463', 'lng' => '1.9884'),
      array('postal_code' => '18102 CEDEX', 'name' => 'Vierzon', 'lat' => '47.2167', 'lng' => '2.0833'),
      array('postal_code' => '18100', 'name' => 'Saint-Hilaire-de-Court', 'lat' => '47.2056', 'lng' => '2.0196'),
      array('postal_code' => '18105 CEDEX', 'name' => 'Vierzon', 'lat' => '47.2167', 'lng' => '2.0833'),
      array('postal_code' => '18100', 'name' => 'Saint-Georges-sur-la-Pr_e', 'lat' => '47.2263', 'lng' => '1.9358'),
      array('postal_code' => '18110', 'name' => 'Vignoux-sous-les-Aix', 'lat' => '47.1884', 'lng' => '2.4649'),
      array('postal_code' => '18103 CEDEX', 'name' => 'Vierzon', 'lat' => '47.2167', 'lng' => '2.0833'),
      array('postal_code' => '18101 CEDEX', 'name' => 'Vierzon', 'lat' => '47.2167', 'lng' => '2.0833'),
      array('postal_code' => '18109 CEDEX', 'name' => 'Vierzon', 'lat' => '47.2167', 'lng' => '2.0833'),
      array('postal_code' => '18107 CEDEX', 'name' => 'Vierzon', 'lat' => '47.2167', 'lng' => '2.0833'),
      array('postal_code' => '18110', 'name' => 'Vasselay', 'lat' => '47.1569', 'lng' => '2.3896'),
      array('postal_code' => '18110', 'name' => 'Saint-�loy-de-Gy', 'lat' => '47.1555', 'lng' => '2.3427'),
      array('postal_code' => '18110', 'name' => 'Saint-Palais', 'lat' => '47.2327', 'lng' => '2.4195'),
      array('postal_code' => '18110', 'name' => 'Pigny', 'lat' => '47.1758', 'lng' => '2.4399'),
      array('postal_code' => '18120', 'name' => 'Ch_ry', 'lat' => '47.1211', 'lng' => '2.0461'),
      array('postal_code' => '18130', 'name' => 'Chalivoy-Milon', 'lat' => '46.8603', 'lng' => '2.7050'),
      array('postal_code' => '18130', 'name' => 'Osmery', 'lat' => '46.9354', 'lng' => '2.6562'),
      array('postal_code' => '18120', 'name' => 'Limeux', 'lat' => '47.0749', 'lng' => '2.1084'),
      array('postal_code' => '18130', 'name' => 'Lantan', 'lat' => '46.9067', 'lng' => '2.6620'),
      array('postal_code' => '18120', 'name' => 'Preuilly', 'lat' => '47.0951', 'lng' => '2.1747'),
      array('postal_code' => '18110', 'name' => 'Fussy', 'lat' => '47.1437', 'lng' => '2.4295'),
      array('postal_code' => '18120', 'name' => 'Brinay', 'lat' => '47.1771', 'lng' => '2.1265'),
      array('postal_code' => '18120', 'name' => 'Massay', 'lat' => '47.1532', 'lng' => '1.9933'),
      array('postal_code' => '18110', 'name' => 'Saint-Georges-sur-Moulon', 'lat' => '47.1906', 'lng' => '2.4233'),
      array('postal_code' => '18130', 'name' => 'Parnay', 'lat' => '46.8489', 'lng' => '2.5713'),
      array('postal_code' => '18120', 'name' => 'Lury-sur-Arnon', 'lat' => '47.1272', 'lng' => '2.0572'),
      array('postal_code' => '18110', 'name' => 'Allogny', 'lat' => '47.2254', 'lng' => '2.3201'),
      array('postal_code' => '18130', 'name' => 'Jussy-Champagne', 'lat' => '46.9859', 'lng' => '2.6427'),
      array('postal_code' => '18120', 'name' => 'M_reau', 'lat' => '47.1630', 'lng' => '2.0509'),
      array('postal_code' => '18130', 'name' => 'Vornay', 'lat' => '46.9733', 'lng' => '2.5828'),
      array('postal_code' => '18130', 'name' => 'Bussy', 'lat' => '46.9036', 'lng' => '2.6215'),
      array('postal_code' => '18120', 'name' => 'Quincy', 'lat' => '47.1328', 'lng' => '2.1571'),
      array('postal_code' => '18150', 'name' => 'Germigny-l�Exempt', 'lat' => '46.9190', 'lng' => '2.8988'),
      array('postal_code' => '18130', 'name' => 'Cogny', 'lat' => '46.8456', 'lng' => '2.6328'),
      array('postal_code' => '18130', 'name' => 'Dun-sur-Auron', 'lat' => '46.8849', 'lng' => '2.5734'),
      array('postal_code' => '18140', 'name' => 'Herry', 'lat' => '47.2167', 'lng' => '2.9539'),
      array('postal_code' => '18140', 'name' => 'Charentonnay', 'lat' => '47.1448', 'lng' => '2.8737'),
      array('postal_code' => '18140', 'name' => 'Chaumoux-Marcilly', 'lat' => '47.1249', 'lng' => '2.7777'),
      array('postal_code' => '18130', 'name' => 'Contres', 'lat' => '46.8688', 'lng' => '2.4890'),
      array('postal_code' => '18130', 'name' => 'Raymond', 'lat' => '46.9719', 'lng' => '2.6858'),
      array('postal_code' => '18110', 'name' => 'Quantilly', 'lat' => '47.2241', 'lng' => '2.4455'),
      array('postal_code' => '18140', 'name' => 'Pr_cy', 'lat' => '47.0997', 'lng' => '2.9289'),
      array('postal_code' => '18140', 'name' => 'La Chapelle-Montlinard', 'lat' => '47.1667', 'lng' => '2.9833'),
      array('postal_code' => '18140', 'name' => 'S_vry', 'lat' => '47.1333', 'lng' => '2.8167'),
      array('postal_code' => '18140', 'name' => 'Argenvi�res', 'lat' => '47.1370', 'lng' => '3.0059'),
      array('postal_code' => '18120', 'name' => 'Lazenay', 'lat' => '47.0717', 'lng' => '2.0600'),
      array('postal_code' => '18140', 'name' => 'Couy', 'lat' => '47.1175', 'lng' => '2.8262'),
      array('postal_code' => '18140', 'name' => 'Sancergues', 'lat' => '47.1539', 'lng' => '2.9137'),
      array('postal_code' => '18140', 'name' => 'Lugny-Champagne', 'lat' => '47.1862', 'lng' => '2.8209'),
      array('postal_code' => '18150', 'name' => 'Le Chautay', 'lat' => '46.9768', 'lng' => '2.9668'),
      array('postal_code' => '18120', 'name' => 'Cerbois', 'lat' => '47.1136', 'lng' => '2.0927'),
      array('postal_code' => '18130', 'name' => 'Saint-Denis-de-Palin', 'lat' => '46.9397', 'lng' => '2.5392'),
      array('postal_code' => '18160', 'name' => 'Saint-Baudel', 'lat' => '46.8386', 'lng' => '2.2080'),
      array('postal_code' => '18140', 'name' => 'Groises', 'lat' => '47.2092', 'lng' => '2.8104'),
      array('postal_code' => '18160', 'name' => 'Chezal-Beno�t', 'lat' => '46.8245', 'lng' => '2.1131'),
      array('postal_code' => '18160', 'name' => 'La Celle-Cond_', 'lat' => '46.7937', 'lng' => '2.1842'),
      array('postal_code' => '18140', 'name' => 'Garigny', 'lat' => '47.0869', 'lng' => '2.8876'),
      array('postal_code' => '18170', 'name' => 'Loye-sur-Arnon', 'lat' => '46.6530', 'lng' => '2.3870'),
      array('postal_code' => '18160', 'name' => 'Montlouis', 'lat' => '46.8139', 'lng' => '2.2401'),
      array('postal_code' => '18150', 'name' => 'La Chapelle-Hugon', 'lat' => '46.9052', 'lng' => '2.9452'),
      array('postal_code' => '18170', 'name' => 'Morlac', 'lat' => '46.7196', 'lng' => '2.3088'),
      array('postal_code' => '18140', 'name' => 'Jussy-le-Chaudrier', 'lat' => '47.1275', 'lng' => '2.9343'),
      array('postal_code' => '18150', 'name' => 'Apremont-sur-Allier', 'lat' => '46.9000', 'lng' => '3.0500'),
      array('postal_code' => '18170', 'name' => 'Le Ch_telet', 'lat' => '46.6425', 'lng' => '2.2823'),
      array('postal_code' => '18140', 'name' => 'Saint-Martin-des-Champs', 'lat' => '47.1566', 'lng' => '2.9178'),
      array('postal_code' => '18190', 'name' => 'Uzay-le-Venon', 'lat' => '46.8120', 'lng' => '2.4612'),
      array('postal_code' => '18160', 'name' => 'Saint-Hilaire-en-Ligni�res', 'lat' => '46.7261', 'lng' => '2.1729'),
      array('postal_code' => '18160', 'name' => 'Ligni�res', 'lat' => '46.7515', 'lng' => '2.1738'),
      array('postal_code' => '18140', 'name' => 'Saint-L_ger-le-Petit', 'lat' => '47.1228', 'lng' => '3.0021'),
      array('postal_code' => '18150', 'name' => 'Cuffy', 'lat' => '46.9628', 'lng' => '3.0524'),
      array('postal_code' => '18190', 'name' => 'Serruelles', 'lat' => '46.8875', 'lng' => '2.3834'),
      array('postal_code' => '18170', 'name' => 'Mar�ais', 'lat' => '46.6972', 'lng' => '2.3695'),
      array('postal_code' => '18160', 'name' => 'Touchay', 'lat' => '46.7127', 'lng' => '2.2133'),
      array('postal_code' => '18190', 'name' => 'Chavannes', 'lat' => '46.8500', 'lng' => '2.3833'),
      array('postal_code' => '18170', 'name' => 'Maisonnais', 'lat' => '46.6396', 'lng' => '2.2152'),
      array('postal_code' => '18160', 'name' => 'Villecelin', 'lat' => '46.8261', 'lng' => '2.1828'),
      array('postal_code' => '18160', 'name' => 'Ineuil', 'lat' => '46.7775', 'lng' => '2.2898'),
      array('postal_code' => '18200', 'name' => 'Nozi�res', 'lat' => '46.7339', 'lng' => '2.4346'),
      array('postal_code' => '18150', 'name' => 'La Guerche-sur-l�Aubois', 'lat' => '46.9489', 'lng' => '2.9452'),
      array('postal_code' => '18190', 'name' => 'Venesmes', 'lat' => '46.8390', 'lng' => '2.3123'),
      array('postal_code' => '18190', 'name' => 'Corquoy', 'lat' => '46.8881', 'lng' => '2.2964'),
      array('postal_code' => '18170', 'name' => 'Rezay', 'lat' => '46.6726', 'lng' => '2.1782'),
      array('postal_code' => '18170', 'name' => 'Ardenais', 'lat' => '46.6518', 'lng' => '2.3700'),
      array('postal_code' => '18200', 'name' => 'Arcomps', 'lat' => '46.6771', 'lng' => '2.4243'),
      array('postal_code' => '18170', 'name' => 'Ids-Saint-Roch', 'lat' => '46.7075', 'lng' => '2.2408'),
      array('postal_code' => '18170', 'name' => 'Saint-Pierre-les-Bois', 'lat' => '46.6644', 'lng' => '2.2787'),
      array('postal_code' => '18190', 'name' => 'Saint-Loup-des-Chaumes', 'lat' => '46.8244', 'lng' => '2.3889'),
      array('postal_code' => '18190', 'name' => 'Vallenay', 'lat' => '46.7845', 'lng' => '2.3711'),
      array('postal_code' => '18190', 'name' => 'Chambon', 'lat' => '46.7878', 'lng' => '2.3255'),
      array('postal_code' => '18190', 'name' => 'Saint-Symphorien', 'lat' => '46.8119', 'lng' => '2.3118'),
      array('postal_code' => '18200', 'name' => 'Saint-Amand-Montrond', 'lat' => '46.7167', 'lng' => '2.5167'),
      array('postal_code' => '18190', 'name' => 'Ch_teauneuf-sur-Cher', 'lat' => '46.8578', 'lng' => '2.3171'),
      array('postal_code' => '18190', 'name' => 'Cr_zan�ay-sur-Cher', 'lat' => '46.8130', 'lng' => '2.3555'),
      array('postal_code' => '18200', 'name' => 'Orcenais', 'lat' => '46.7192', 'lng' => '2.4261'),
      array('postal_code' => '18200', 'name' => 'Arpheuilles', 'lat' => '46.7826', 'lng' => '2.5599'),
      array('postal_code' => '18200', 'name' => 'Meillant', 'lat' => '46.7822', 'lng' => '2.5052'),
      array('postal_code' => '18200', 'name' => 'Saint-Georges-de-Poisieux', 'lat' => '46.6865', 'lng' => '2.4785'),
      array('postal_code' => '18200', 'name' => 'Farges-Allichamps', 'lat' => '46.7594', 'lng' => '2.4022'),
      array('postal_code' => '18203 CEDEX', 'name' => 'Saint-Amand-Montrond', 'lat' => '46.7167', 'lng' => '2.5167'),
      array('postal_code' => '18200', 'name' => 'Drevant', 'lat' => '46.6934', 'lng' => '2.5250'),
      array('postal_code' => '18200', 'name' => 'Orval', 'lat' => '46.7258', 'lng' => '2.4714'),
      array('postal_code' => '18200', 'name' => 'Bouzais', 'lat' => '46.7053', 'lng' => '2.4738'),
      array('postal_code' => '18200', 'name' => 'La Perche', 'lat' => '46.6446', 'lng' => '2.5738'),
      array('postal_code' => '18200', 'name' => 'Ainay-le-Vieil', 'lat' => '46.6666', 'lng' => '2.5520'),
      array('postal_code' => '18201 CEDEX', 'name' => 'Saint-Amand-Montrond', 'lat' => '46.7167', 'lng' => '2.5167'),
      array('postal_code' => '18200', 'name' => 'La Celle', 'lat' => '46.7692', 'lng' => '2.4450'),
      array('postal_code' => '18205 CEDEX', 'name' => 'Saint-Amand-Montrond', 'lat' => '46.7167', 'lng' => '2.5167'),
      array('postal_code' => '18200', 'name' => 'Bru�re-Allichamps', 'lat' => '46.7685', 'lng' => '2.4326'),
      array('postal_code' => '18200', 'name' => 'La Groutte', 'lat' => '46.6872', 'lng' => '2.5099'),
      array('postal_code' => '18202 CEDEX', 'name' => 'Saint-Amand-Montrond', 'lat' => '46.7167', 'lng' => '2.5167'),
      array('postal_code' => '18207 CEDEX', 'name' => 'Saint-Amand-Montrond', 'lat' => '46.7167', 'lng' => '2.5167'),
      array('postal_code' => '18200', 'name' => 'Colombiers', 'lat' => '46.7006', 'lng' => '2.5394'),
      array('postal_code' => '18210', 'name' => 'Coust', 'lat' => '46.6929', 'lng' => '2.5980'),
      array('postal_code' => '18210', 'name' => 'Verneuil', 'lat' => '46.8162', 'lng' => '2.6063'),
      array('postal_code' => '18210', 'name' => 'Saint-Pierre-les-�tieux', 'lat' => '46.7343', 'lng' => '2.6229'),
      array('postal_code' => '18204 CEDEX', 'name' => 'Saint-Amand-Montrond', 'lat' => '46.7167', 'lng' => '2.5167'),
      array('postal_code' => '18210', 'name' => 'Bessais-le-Fromental', 'lat' => '46.7459', 'lng' => '2.7633'),
      array('postal_code' => '18206 CEDEX', 'name' => 'Saint-Amand-Montrond', 'lat' => '46.7167', 'lng' => '2.5167'),
      array('postal_code' => '18210', 'name' => 'Bannegon', 'lat' => '46.8012', 'lng' => '2.7137'),
      array('postal_code' => '18220', 'name' => 'Parassy', 'lat' => '47.2335', 'lng' => '2.5478'),
      array('postal_code' => '18210', 'name' => 'Vernais', 'lat' => '46.7655', 'lng' => '2.7132'),
      array('postal_code' => '18210', 'name' => 'Thaumiers', 'lat' => '46.8219', 'lng' => '2.6548'),
      array('postal_code' => '18220', 'name' => 'Sainte-Solange', 'lat' => '47.1363', 'lng' => '2.5502'),
      array('postal_code' => '18210', 'name' => 'Le Pondy', 'lat' => '46.8042', 'lng' => '2.6495'),
      array('postal_code' => '18220', 'name' => 'Br_cy', 'lat' => '47.1240', 'lng' => '2.6200'),
      array('postal_code' => '18220', 'name' => 'Morogues', 'lat' => '47.2408', 'lng' => '2.5985'),
      array('postal_code' => '18210', 'name' => 'Charenton-du-Cher', 'lat' => '46.7301', 'lng' => '2.6444'),
      array('postal_code' => '18220', 'name' => 'Les Aix-d�Angillon', 'lat' => '47.1965', 'lng' => '2.5651'),
      array('postal_code' => '18260', 'name' => 'Barlieu', 'lat' => '47.4879', 'lng' => '2.6295'),
      array('postal_code' => '18250', 'name' => 'Neuilly-en-Sancerre', 'lat' => '47.3030', 'lng' => '2.6871'),
      array('postal_code' => '18220', 'name' => 'Rians', 'lat' => '47.1787', 'lng' => '2.6136'),
      array('postal_code' => '18260', 'name' => 'Le Noyer', 'lat' => '47.3841', 'lng' => '2.6806'),
      array('postal_code' => '18230', 'name' => 'Saint-Doulchard', 'lat' => '47.1037', 'lng' => '2.3520'),
      array('postal_code' => '18240', 'name' => 'Savigny-en-Sancerre', 'lat' => '47.4414', 'lng' => '2.8095'),
      array('postal_code' => '18240', 'name' => 'Sury-pr�s-L_r_', 'lat' => '47.4847', 'lng' => '2.8674'),
      array('postal_code' => '18220', 'name' => 'Soulangis', 'lat' => '47.1870', 'lng' => '2.5182'),
      array('postal_code' => '18240', 'name' => 'Santranges', 'lat' => '47.4992', 'lng' => '2.7712'),
      array('postal_code' => '18220', 'name' => 'Saint-C_ols', 'lat' => '47.2220', 'lng' => '2.6305'),
      array('postal_code' => '18220', 'name' => 'Aubinges', 'lat' => '47.2224', 'lng' => '2.5822'),
      array('postal_code' => '18250', 'name' => 'Ach�res', 'lat' => '47.2791', 'lng' => '2.4500'),
      array('postal_code' => '18220', 'name' => 'Azy', 'lat' => '47.1833', 'lng' => '2.7070'),
      array('postal_code' => '18240', 'name' => 'Belleville-sur-Loire', 'lat' => '47.5000', 'lng' => '2.8500'),
      array('postal_code' => '18240', 'name' => 'Boulleret', 'lat' => '47.4242', 'lng' => '2.8734'),
      array('postal_code' => '18240', 'name' => 'L_r_', 'lat' => '47.4687', 'lng' => '2.8698'),
      array('postal_code' => '18250', 'name' => 'Montigny', 'lat' => '47.2397', 'lng' => '2.6830'),
      array('postal_code' => '18250', 'name' => 'Henrichemont', 'lat' => '47.3033', 'lng' => '2.5246'),
      array('postal_code' => '18260', 'name' => 'Vailly-sur-Sauldre', 'lat' => '47.4592', 'lng' => '2.6499'),
      array('postal_code' => '18240', 'name' => 'Sainte-Gemme-en-Sancerrois', 'lat' => '47.4000', 'lng' => '2.8167'),
      array('postal_code' => '18260', 'name' => 'Concressault', 'lat' => '47.4899', 'lng' => '2.5762'),
      array('postal_code' => '18250', 'name' => 'Humbligny', 'lat' => '47.2542', 'lng' => '2.6608'),
      array('postal_code' => '18250', 'name' => 'Neuvy-Deux-Clochers', 'lat' => '47.2785', 'lng' => '2.7004'),
      array('postal_code' => '18260', 'name' => 'Dampierre-en-Crot', 'lat' => '47.4604', 'lng' => '2.5835'),
      array('postal_code' => '18260', 'name' => 'Jars', 'lat' => '47.3955', 'lng' => '2.6821'),
      array('postal_code' => '18270', 'name' => 'Saint-Maur', 'lat' => '46.5805', 'lng' => '2.2990'),
      array('postal_code' => '18260', 'name' => 'Subligny', 'lat' => '47.4030', 'lng' => '2.7550'),
      array('postal_code' => '18260', 'name' => 'Villegenon', 'lat' => '47.4271', 'lng' => '2.6043'),
      array('postal_code' => '18260', 'name' => 'Thou', 'lat' => '47.4267', 'lng' => '2.6602'),
      array('postal_code' => '18270', 'name' => 'Culan', 'lat' => '46.5486', 'lng' => '2.3496'),
      array('postal_code' => '18270', 'name' => 'Sidiailles', 'lat' => '46.5066', 'lng' => '2.3197'),
      array('postal_code' => '18290', 'name' => 'Saugy', 'lat' => '46.9702', 'lng' => '2.1165'),
      array('postal_code' => '18250', 'name' => 'La Chapelotte', 'lat' => '47.3531', 'lng' => '2.5908'),
      array('postal_code' => '18290', 'name' => 'Plou', 'lat' => '47.0324', 'lng' => '2.1317'),
      array('postal_code' => '18260', 'name' => 'Assigny', 'lat' => '47.4281', 'lng' => '2.7551'),
      array('postal_code' => '18270', 'name' => 'Saint-Christophe-le-Chaudry', 'lat' => '46.5813', 'lng' => '2.3689'),
      array('postal_code' => '18260', 'name' => 'Sury-�s-Bois', 'lat' => '47.4646', 'lng' => '2.7039'),
      array('postal_code' => '18290', 'name' => 'Saint-Ambroix', 'lat' => '46.9318', 'lng' => '2.1195'),
      array('postal_code' => '18270', 'name' => 'Reigny', 'lat' => '46.5766', 'lng' => '2.3527'),
      array('postal_code' => '18290', 'name' => 'Ch_rost', 'lat' => '46.9939', 'lng' => '2.1164'),
      array('postal_code' => '18300', 'name' => 'Menetou-R_tel', 'lat' => '47.3515', 'lng' => '2.7549'),
      array('postal_code' => '18300', 'name' => 'Bu_', 'lat' => '47.3099', 'lng' => '2.7924'),
      array('postal_code' => '18290', 'name' => 'Civray', 'lat' => '46.9665', 'lng' => '2.1739'),
      array('postal_code' => '18290', 'name' => 'Mareuil-sur-Arnon', 'lat' => '46.8805', 'lng' => '2.1605'),
      array('postal_code' => '18300', 'name' => 'Sens-Beaujeu', 'lat' => '47.3269', 'lng' => '2.7087'),
      array('postal_code' => '18300', 'name' => 'Thauvenay', 'lat' => '47.3085', 'lng' => '2.8633'),
      array('postal_code' => '18290', 'name' => 'Poisieux', 'lat' => '47.0296', 'lng' => '2.0996'),
      array('postal_code' => '18300', 'name' => 'Couargues', 'lat' => '47.2923', 'lng' => '2.9146'),
      array('postal_code' => '18300', 'name' => 'Cr_zancy-en-Sancerre', 'lat' => '47.3000', 'lng' => '2.7500'),
      array('postal_code' => '18300', 'name' => 'Saint-Bouize', 'lat' => '47.2856', 'lng' => '2.8847'),
      array('postal_code' => '18300', 'name' => 'Sury-en-Vaux', 'lat' => '47.3680', 'lng' => '2.8042'),
      array('postal_code' => '18300', 'name' => 'Saint-Satur', 'lat' => '47.3391', 'lng' => '2.8373'),
      array('postal_code' => '18310', 'name' => 'Genouilly', 'lat' => '47.1911', 'lng' => '1.8864'),
      array('postal_code' => '18300', 'name' => 'Gardefort', 'lat' => '47.2686', 'lng' => '2.8304'),
      array('postal_code' => '18300', 'name' => 'M_n_tr_ol-sous-Sancerre', 'lat' => '47.3179', 'lng' => '2.8559'),
      array('postal_code' => '18310', 'name' => 'Nohant-en-Gra�ay', 'lat' => '47.1369', 'lng' => '1.8936'),
      array('postal_code' => '18300', 'name' => 'Vinon', 'lat' => '47.2854', 'lng' => '2.8239'),
      array('postal_code' => '18300', 'name' => 'Veaugues', 'lat' => '47.2574', 'lng' => '2.7569'),
      array('postal_code' => '18300', 'name' => 'Sancerre', 'lat' => '47.3289', 'lng' => '2.8345'),
      array('postal_code' => '18300', 'name' => 'Bannay', 'lat' => '47.3879', 'lng' => '2.8838'),
      array('postal_code' => '18300', 'name' => 'Verdigny', 'lat' => '47.3466', 'lng' => '2.8081'),
      array('postal_code' => '18310', 'name' => 'Saint-Outrille', 'lat' => '47.1438', 'lng' => '1.8408'),
      array('postal_code' => '18300', 'name' => 'Feux', 'lat' => '47.2301', 'lng' => '2.8591'),
      array('postal_code' => '18300', 'name' => 'Jalognes', 'lat' => '47.2352', 'lng' => '2.7845'),
      array('postal_code' => '18310', 'name' => 'Dampierre-en-Gra�ay', 'lat' => '47.1800', 'lng' => '1.9431'),
      array('postal_code' => '18310', 'name' => 'Gra�ay', 'lat' => '47.1437', 'lng' => '1.8473'),
      array('postal_code' => '18320', 'name' => 'Saint-Hilaire-de-Gondilly', 'lat' => '47.0490', 'lng' => '2.8868'),
      array('postal_code' => '18330', 'name' => 'Vouzeron', 'lat' => '47.2600', 'lng' => '2.2220'),
      array('postal_code' => '18330', 'name' => 'Neuvy-sur-Barangeon', 'lat' => '47.3150', 'lng' => '2.2534'),
      array('postal_code' => '18340', 'name' => 'Lapan', 'lat' => '46.9230', 'lng' => '2.2993'),
      array('postal_code' => '18320', 'name' => 'Beffes', 'lat' => '47.0944', 'lng' => '3.0087'),
      array('postal_code' => '18340', 'name' => 'Plaimpied-Givaudins', 'lat' => '46.9980', 'lng' => '2.4543'),
      array('postal_code' => '18330', 'name' => 'Nan�ay', 'lat' => '47.3501', 'lng' => '2.1929'),
      array('postal_code' => '18320', 'name' => 'Marseilles-l�s-Aubigny', 'lat' => '47.0667', 'lng' => '3.0118'),
      array('postal_code' => '18320', 'name' => 'Cours-les-Barres', 'lat' => '47.0251', 'lng' => '3.0317'),
      array('postal_code' => '18320', 'name' => 'Menetou-Couture', 'lat' => '47.0453', 'lng' => '2.9137'),
      array('postal_code' => '18340', 'name' => 'Ar�ay', 'lat' => '46.9488', 'lng' => '2.3399'),
      array('postal_code' => '18340', 'name' => 'Crosses', 'lat' => '47.0105', 'lng' => '2.5821'),
      array('postal_code' => '18320', 'name' => 'Torteron', 'lat' => '47.0228', 'lng' => '2.9661'),
      array('postal_code' => '18340', 'name' => 'Soye-en-Septaine', 'lat' => '47.0271', 'lng' => '2.4887'),
      array('postal_code' => '18320', 'name' => 'Jouet-sur-l\'Aubois', 'lat' => '47.0456', 'lng' => '2.9873'),
      array('postal_code' => '18340', 'name' => 'Lissay-Lochy', 'lat' => '46.9725', 'lng' => '2.4102'),
      array('postal_code' => '18330', 'name' => 'Saint-Laurent', 'lat' => '47.2254', 'lng' => '2.2020'),
      array('postal_code' => '18340', 'name' => 'Saint-Germain-des-Bois', 'lat' => '46.9124', 'lng' => '2.4452'),
      array('postal_code' => '18340', 'name' => 'Levet', 'lat' => '46.9261', 'lng' => '2.4073'),
      array('postal_code' => '18340', 'name' => 'Saint-Just', 'lat' => '46.9938', 'lng' => '2.5082'),
      array('postal_code' => '18340', 'name' => 'Senne�ay', 'lat' => '46.9512', 'lng' => '2.4367'),
      array('postal_code' => '18340', 'name' => 'Sainte-Lunaise', 'lat' => '46.9201', 'lng' => '2.3494'),
      array('postal_code' => '18350', 'name' => 'Mornay-Berry', 'lat' => '47.0491', 'lng' => '2.8709'),
      array('postal_code' => '18340', 'name' => 'Annoix', 'lat' => '46.9583', 'lng' => '2.5367'),
      array('postal_code' => '18350', 'name' => 'Flavigny', 'lat' => '46.9683', 'lng' => '2.8003'),
      array('postal_code' => '18350', 'name' => 'Blet', 'lat' => '46.8948', 'lng' => '2.7321'),
      array('postal_code' => '18360', 'name' => 'La Celette', 'lat' => '46.6516', 'lng' => '2.5216'),
      array('postal_code' => '18350', 'name' => 'Cornusse', 'lat' => '46.9546', 'lng' => '2.7308'),
      array('postal_code' => '18370', 'name' => 'Beddes', 'lat' => '46.6059', 'lng' => '2.2145'),
      array('postal_code' => '18350', 'name' => 'Lugny-Bourbonnais', 'lat' => '46.9317', 'lng' => '2.7049'),
      array('postal_code' => '18350', 'name' => 'Saint-Hilaire-de-Gondilly', 'lat' => '47.0494', 'lng' => '2.8861'),
      array('postal_code' => '18350', 'name' => 'Chaumont', 'lat' => '46.8453', 'lng' => '2.7534'),
      array('postal_code' => '18360', 'name' => '�pineuil-le-Fleuriel', 'lat' => '46.5588', 'lng' => '2.5831'),
      array('postal_code' => '18370', 'name' => 'Ch_teaumeillant', 'lat' => '46.5622', 'lng' => '2.1951'),
      array('postal_code' => '18350', 'name' => 'Tendron', 'lat' => '46.9731', 'lng' => '2.8437'),
      array('postal_code' => '18350', 'name' => 'Ourouer-les-Bourdelins', 'lat' => '46.9167', 'lng' => '2.8167'),
      array('postal_code' => '18340', 'name' => 'Vorly', 'lat' => '46.9455', 'lng' => '2.4653'),
      array('postal_code' => '18370', 'name' => 'Saint-Saturnin', 'lat' => '46.5078', 'lng' => '2.2372'),
      array('postal_code' => '18350', 'name' => 'Croisy', 'lat' => '46.9385', 'lng' => '2.8094'),
      array('postal_code' => '18350', 'name' => 'Ignol', 'lat' => '46.9666', 'lng' => '2.8459'),
      array('postal_code' => '18360', 'name' => 'Saint-Vitte', 'lat' => '46.5468', 'lng' => '2.5339'),
      array('postal_code' => '18350', 'name' => 'Charly', 'lat' => '46.8994', 'lng' => '2.7482'),
      array('postal_code' => '18370', 'name' => 'Saint-Jeanvrin', 'lat' => '46.5957', 'lng' => '2.2338'),
      array('postal_code' => '18380', 'name' => 'M_ry-�s-Bois', 'lat' => '47.3146', 'lng' => '2.3629'),
      array('postal_code' => '18380', 'name' => 'Presly', 'lat' => '47.3875', 'lng' => '2.3589'),
      array('postal_code' => '18350', 'name' => 'N_rondes', 'lat' => '46.9976', 'lng' => '2.8183'),
      array('postal_code' => '18360', 'name' => 'Saulzais-le-Potier', 'lat' => '46.5992', 'lng' => '2.4964'),
      array('postal_code' => '18360', 'name' => 'Faverdines', 'lat' => '46.6433', 'lng' => '2.4705'),
      array('postal_code' => '18370', 'name' => 'Pr_veranges', 'lat' => '46.4329', 'lng' => '2.2549'),
      array('postal_code' => '18360', 'name' => 'Vesdun', 'lat' => '46.5393', 'lng' => '2.4288'),
      array('postal_code' => '18370', 'name' => 'Saint-Priest-la-Marche', 'lat' => '46.4494', 'lng' => '2.1762'),
      array('postal_code' => '18390', 'name' => 'Saint-Germain-du-Puy', 'lat' => '47.1000', 'lng' => '2.4833'),
      array('postal_code' => '18390', 'name' => 'Osmoy', 'lat' => '47.0728', 'lng' => '2.5227'),
      array('postal_code' => '18390', 'name' => 'Moulins-sur-Y�vre', 'lat' => '47.0834', 'lng' => '2.5177'),
      array('postal_code' => '18410', 'name' => 'Brinon-sur-Sauldre', 'lat' => '47.5660', 'lng' => '2.2565'),
      array('postal_code' => '18400', 'name' => 'Saint-Florent-sur-Cher', 'lat' => '46.9955', 'lng' => '2.2508'),
      array('postal_code' => '18390', 'name' => 'Saint-Michel-de-Volangis', 'lat' => '47.1482', 'lng' => '2.4888'),
      array('postal_code' => '18400', 'name' => 'Villeneuve-sur-Cher', 'lat' => '47.0290', 'lng' => '2.2234'),
      array('postal_code' => '18410', 'name' => 'Argent-sur-Sauldre', 'lat' => '47.5585', 'lng' => '2.4441'),
      array('postal_code' => '18400', 'name' => 'Lunery', 'lat' => '46.9357', 'lng' => '2.2690'),
      array('postal_code' => '18380', 'name' => 'Ivoy-le-Pr_', 'lat' => '47.3448', 'lng' => '2.4861'),
      array('postal_code' => '18380', 'name' => 'La Chapelle-d�Angillon', 'lat' => '47.3629', 'lng' => '2.4328'),
      array('postal_code' => '18390', 'name' => 'Nohant-en-Go_t', 'lat' => '47.0990', 'lng' => '2.5703'),
      array('postal_code' => '18380', 'name' => 'Ennordres', 'lat' => '47.4300', 'lng' => '2.3830'),
      array('postal_code' => '18400', 'name' => 'Primelles', 'lat' => '46.9033', 'lng' => '2.2127'),
      array('postal_code' => '18390', 'name' => 'Savigny-en-Septaine', 'lat' => '47.0440', 'lng' => '2.5599'),
      array('postal_code' => '18500', 'name' => 'Marmagne', 'lat' => '47.1000', 'lng' => '2.2833'),
      array('postal_code' => '18400', 'name' => 'Saint-Caprais', 'lat' => '46.9684', 'lng' => '2.2933'),
      array('postal_code' => '18500', 'name' => 'Fo�cy', 'lat' => '47.1762', 'lng' => '2.1626'),
      array('postal_code' => '18500', 'name' => 'Vignoux-sur-Barangeon', 'lat' => '47.2007', 'lng' => '2.1726'),
      array('postal_code' => '18520', 'name' => 'Avord', 'lat' => '47.0351', 'lng' => '2.6530'),
      array('postal_code' => '18500', 'name' => 'Mehun-sur-Y�vre', 'lat' => '47.1378', 'lng' => '2.2111'),
      array('postal_code' => '18500', 'name' => 'Allouis', 'lat' => '47.1653', 'lng' => '2.2275'),
      array('postal_code' => '18500', 'name' => 'Berry-Bouy', 'lat' => '47.1098', 'lng' => '2.2889'),
      array('postal_code' => '18410', 'name' => 'Cl_mont', 'lat' => '47.5680', 'lng' => '2.3059'),
      array('postal_code' => '18570', 'name' => 'Morthomiers', 'lat' => '47.0374', 'lng' => '2.2746'),
      array('postal_code' => '18410', 'name' => 'Blancafort', 'lat' => '47.5322', 'lng' => '2.5298'),
      array('postal_code' => '18570', 'name' => 'La Chapelle-Saint-Ursin', 'lat' => '47.0625', 'lng' => '2.3245'),
      array('postal_code' => '18500', 'name' => 'Sainte-Thorette', 'lat' => '47.0816', 'lng' => '2.1988'),
      array('postal_code' => '18520', 'name' => 'Bengy-sur-Craon', 'lat' => '47.0011', 'lng' => '2.7465'),
      array('postal_code' => '18600', 'name' => 'Neuilly-en-Dun', 'lat' => '46.7988', 'lng' => '2.7808'),
      array('postal_code' => '18600', 'name' => 'Sancoins', 'lat' => '46.8331', 'lng' => '2.9224'),
      array('postal_code' => '18510', 'name' => 'Menetou-Salon', 'lat' => '47.2317', 'lng' => '2.4872'),
      array('postal_code' => '18570', 'name' => 'Trouy', 'lat' => '47.0115', 'lng' => '2.3602'),
      array('postal_code' => '18600', 'name' => 'Saint-Aignan-des-Noyers', 'lat' => '46.7653', 'lng' => '2.8162'),
      array('postal_code' => '18600', 'name' => 'Neuvy-le-Barrois', 'lat' => '46.8651', 'lng' => '3.0377'),
      array('postal_code' => '18800', 'name' => 'Villequiers', 'lat' => '47.0706', 'lng' => '2.8040'),
      array('postal_code' => '18700', 'name' => 'Sainte-Montaine', 'lat' => '47.4902', 'lng' => '2.3197'),
      array('postal_code' => '18600', 'name' => 'Givardon', 'lat' => '46.8403', 'lng' => '2.8180'),
      array('postal_code' => '18600', 'name' => 'Augy-sur-Aubois', 'lat' => '46.7845', 'lng' => '2.8446'),
      array('postal_code' => '18570', 'name' => 'Le Subdray', 'lat' => '47.0121', 'lng' => '2.2948'),
      array('postal_code' => '18800', 'name' => 'Laverdines', 'lat' => '47.0343', 'lng' => '2.7875'),
      array('postal_code' => '18600', 'name' => 'Vereaux', 'lat' => '46.8797', 'lng' => '2.8787'),
      array('postal_code' => '18800', 'name' => 'Baugy', 'lat' => '47.0818', 'lng' => '2.7285'),
      array('postal_code' => '18700', 'name' => 'Oizon', 'lat' => '47.4760', 'lng' => '2.5133'),
      array('postal_code' => '18700', 'name' => 'M_n_tr_ol-sur-Sauldre', 'lat' => '47.4483', 'lng' => '2.3072'),
      array('postal_code' => '18600', 'name' => 'Sagonne', 'lat' => '46.8505', 'lng' => '2.8252'),
      array('postal_code' => '18600', 'name' => 'Grossouvre', 'lat' => '46.8798', 'lng' => '2.9362'),
      array('postal_code' => '18600', 'name' => 'Mornay-sur-Allier', 'lat' => '46.8211', 'lng' => '3.0308'),
      array('postal_code' => '18700', 'name' => 'Aubigny-sur-N�re', 'lat' => '47.4882', 'lng' => '2.4389'),
      array('postal_code' => '18800', 'name' => 'Saligny-le-Vif', 'lat' => '47.0455', 'lng' => '2.7668'),
      array('postal_code' => '18800', 'name' => 'Gron', 'lat' => '47.1211', 'lng' => '2.7411'),
      array('postal_code' => '18800', 'name' => '�tr_chy', 'lat' => '47.1617', 'lng' => '2.7248'),
      array('postal_code' => '28004 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '18922 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '28001 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '18940 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18800', 'name' => 'Chassy', 'lat' => '47.0420', 'lng' => '2.8363'),
      array('postal_code' => '18923 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18910 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18800', 'name' => 'Villabon', 'lat' => '47.0964', 'lng' => '2.6747'),
      array('postal_code' => '28002 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '18800', 'name' => 'Farges-en-Septaine', 'lat' => '47.0737', 'lng' => '2.6503'),
      array('postal_code' => '28000', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28011 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '18924 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18920 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '28006 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28024 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '18939 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18934 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18911 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '28035 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28025 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '18935 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '28019 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '18941 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '18998 CEDEX', 'name' => 'Avord', 'lat' => '47.0351', 'lng' => '2.6530'),
      array('postal_code' => '28018 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28007 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28009 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '18945 CEDEX 9', 'name' => 'Bourges', 'lat' => '47.0833', 'lng' => '2.4000'),
      array('postal_code' => '28034 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28029 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28026 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28036 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28005 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28037 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28039 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28100', 'name' => 'Dreux', 'lat' => '48.7333', 'lng' => '1.3667'),
      array('postal_code' => '28105 CEDEX', 'name' => 'Dreux', 'lat' => '48.7333', 'lng' => '1.3667'),
      array('postal_code' => '28044 CEDEX 9', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28040 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28108 CEDEX', 'name' => 'Dreux', 'lat' => '48.7333', 'lng' => '1.3667'),
      array('postal_code' => '28101 CEDEX', 'name' => 'Dreux', 'lat' => '48.7333', 'lng' => '1.3667'),
      array('postal_code' => '28080 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28102 CEDEX', 'name' => 'Dreux', 'lat' => '48.7333', 'lng' => '1.3667'),
      array('postal_code' => '28120', 'name' => 'Charonville', 'lat' => '48.2809', 'lng' => '1.3041'),
      array('postal_code' => '28008 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28111 CEDEX', 'name' => 'Luc_', 'lat' => '48.4369', 'lng' => '1.4636'),
      array('postal_code' => '28120', 'name' => 'Meslay-le-Grenet', 'lat' => '48.3671', 'lng' => '1.3814'),
      array('postal_code' => '28106 CEDEX', 'name' => 'Dreux', 'lat' => '48.7333', 'lng' => '1.3667'),
      array('postal_code' => '28033 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28103 CEDEX', 'name' => 'Dreux', 'lat' => '48.7333', 'lng' => '1.3667'),
      array('postal_code' => '28003 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28023 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28109 CEDEX', 'name' => 'Dreux', 'lat' => '48.7333', 'lng' => '1.3667'),
      array('postal_code' => '28112 CEDEX', 'name' => 'Luc_', 'lat' => '48.4369', 'lng' => '1.4636'),
      array('postal_code' => '28113 CEDEX', 'name' => 'Luc_', 'lat' => '48.4369', 'lng' => '1.4636'),
      array('postal_code' => '28038 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28120', 'name' => 'Montigny-le-Chartif', 'lat' => '48.2863', 'lng' => '1.1539'),
      array('postal_code' => '28120', 'name' => 'Blandainville', 'lat' => '48.3088', 'lng' => '1.2906'),
      array('postal_code' => '28120', 'name' => '�peautrolles', 'lat' => '48.3104', 'lng' => '1.3273'),
      array('postal_code' => '28120', 'name' => 'M_r_glise', 'lat' => '48.2895', 'lng' => '1.1850'),
      array('postal_code' => '28120', 'name' => 'Illiers-Combray', 'lat' => '48.3000', 'lng' => '1.2500'),
      array('postal_code' => '28120', 'name' => 'Les Ch_telliers-Notre-Dame', 'lat' => '48.3473', 'lng' => '1.2037'),
      array('postal_code' => '28120', 'name' => 'Vieuvicq', 'lat' => '48.2640', 'lng' => '1.2134'),
      array('postal_code' => '28114 CEDEX', 'name' => 'Luc_', 'lat' => '48.4369', 'lng' => '1.4636'),
      array('postal_code' => '28130', 'name' => 'Saint-Piat', 'lat' => '48.5467', 'lng' => '1.5836'),
      array('postal_code' => '28110', 'name' => 'Luc_', 'lat' => '48.4369', 'lng' => '1.4636'),
      array('postal_code' => '28120', 'name' => 'Chauffours', 'lat' => '48.3953', 'lng' => '1.3464'),
      array('postal_code' => '28088 CEDEX', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28120', 'name' => 'Ermenonville-la-Petite', 'lat' => '48.2960', 'lng' => '1.3516'),
      array('postal_code' => '28120', 'name' => 'Saint-Avit-les-Guespi�res', 'lat' => '48.2707', 'lng' => '1.2710'),
      array('postal_code' => '28104 CEDEX', 'name' => 'Dreux', 'lat' => '48.7333', 'lng' => '1.3667'),
      array('postal_code' => '28120', 'name' => 'Ermenonville-la-Grande', 'lat' => '48.3360', 'lng' => '1.3829'),
      array('postal_code' => '28120', 'name' => 'Nogent-sur-Eure', 'lat' => '48.3897', 'lng' => '1.3631'),
      array('postal_code' => '28120', 'name' => 'Sandarville', 'lat' => '48.3479', 'lng' => '1.3511'),
      array('postal_code' => '28120', 'name' => 'March_ville', 'lat' => '48.3674', 'lng' => '1.2524'),
      array('postal_code' => '28120', 'name' => 'Magny', 'lat' => '48.3500', 'lng' => '1.2614'),
      array('postal_code' => '28120', 'name' => 'Bailleau-le-Pin', 'lat' => '48.3670', 'lng' => '1.3295'),
      array('postal_code' => '28130', 'name' => 'Hanches', 'lat' => '48.6012', 'lng' => '1.6514'),
      array('postal_code' => '28119 CEDEX', 'name' => 'Luc_', 'lat' => '48.4369', 'lng' => '1.4636'),
      array('postal_code' => '28120', 'name' => 'Saint-�man', 'lat' => '48.3218', 'lng' => '1.2186'),
      array('postal_code' => '28130', 'name' => 'Houx', 'lat' => '48.5666', 'lng' => '1.6183'),
      array('postal_code' => '28130', 'name' => 'Maintenon', 'lat' => '48.5870', 'lng' => '1.5785'),
      array('postal_code' => '28130', 'name' => 'Soulaires', 'lat' => '48.5170', 'lng' => '1.5875'),
      array('postal_code' => '28130', 'name' => 'Villiers-le-Morhier', 'lat' => '48.6202', 'lng' => '1.5635'),
      array('postal_code' => '28132 CEDEX', 'name' => 'Pierres', 'lat' => '48.5921', 'lng' => '1.5644'),
      array('postal_code' => '28133 CEDEX', 'name' => 'Pierres', 'lat' => '48.5921', 'lng' => '1.5644'),
      array('postal_code' => '28131 CEDEX', 'name' => 'Pierres', 'lat' => '48.5921', 'lng' => '1.5644'),
      array('postal_code' => '28120', 'name' => 'Nonvilliers-Grandhoux', 'lat' => '48.3430', 'lng' => '1.1728'),
      array('postal_code' => '28130', 'name' => 'Saint-Martin-de-Nigelles', 'lat' => '48.6123', 'lng' => '1.6092'),
      array('postal_code' => '28130', 'name' => 'Bouglainval', 'lat' => '48.5631', 'lng' => '1.5105'),
      array('postal_code' => '28130', 'name' => 'Chartainvilliers', 'lat' => '48.5441', 'lng' => '1.5542'),
      array('postal_code' => '28130', 'name' => 'Pierres', 'lat' => '48.5921', 'lng' => '1.5644'),
      array('postal_code' => '28130', 'name' => 'M_voisins', 'lat' => '48.5513', 'lng' => '1.5934'),
      array('postal_code' => '28120', 'name' => 'Cernay', 'lat' => '48.3836', 'lng' => '1.2376'),
      array('postal_code' => '28130', 'name' => 'Yermenonville', 'lat' => '48.5571', 'lng' => '1.6200'),
      array('postal_code' => '28120', 'name' => 'Oll_', 'lat' => '48.3889', 'lng' => '1.2969'),
      array('postal_code' => '28140', 'name' => 'Loigny-la-Bataille', 'lat' => '48.1232', 'lng' => '1.7340'),
      array('postal_code' => '28140', 'name' => 'P_ronville', 'lat' => '48.0669', 'lng' => '1.5872'),
      array('postal_code' => '28140', 'name' => 'Tillay-le-P_neux', 'lat' => '48.1608', 'lng' => '1.7740'),
      array('postal_code' => '28140', 'name' => 'Bazoches-en-Dunois', 'lat' => '48.1043', 'lng' => '1.5668'),
      array('postal_code' => '28140', 'name' => 'Guillonville', 'lat' => '48.0909', 'lng' => '1.6629'),
      array('postal_code' => '28140', 'name' => 'Org�res-en-Beauce', 'lat' => '48.1464', 'lng' => '1.6838'),
      array('postal_code' => '28140', 'name' => 'Poupry', 'lat' => '48.0998', 'lng' => '1.8371'),
      array('postal_code' => '28140', 'name' => '�ole-en-Beauce', 'lat' => '48.2167', 'lng' => '1.7025'),
      array('postal_code' => '28140', 'name' => 'Terminiers', 'lat' => '48.0827', 'lng' => '1.7411'),
      array('postal_code' => '28140', 'name' => 'Courbehaye', 'lat' => '48.1591', 'lng' => '1.6091'),
      array('postal_code' => '28140', 'name' => 'Baigneaux', 'lat' => '48.1841', 'lng' => '1.6087'),
      array('postal_code' => '28140', 'name' => 'Bazoches-les-Hautes', 'lat' => '48.1518', 'lng' => '1.7996'),
      array('postal_code' => '28140', 'name' => 'Lumeau', 'lat' => '48.1162', 'lng' => '1.7879'),
      array('postal_code' => '28140', 'name' => 'Fontenay-sur-Conie', 'lat' => '48.1651', 'lng' => '1.6678'),
      array('postal_code' => '28140', 'name' => 'Cormainville', 'lat' => '48.1374', 'lng' => '1.6053'),
      array('postal_code' => '28140', 'name' => 'Germignonville', 'lat' => '48.1933', 'lng' => '1.7391'),
      array('postal_code' => '28140', 'name' => 'Nottonville', 'lat' => '48.1132', 'lng' => '1.5068'),
      array('postal_code' => '28140', 'name' => 'Dambron', 'lat' => '48.1137', 'lng' => '1.8701'),
      array('postal_code' => '28150', 'name' => 'Boisville-la-Saint-P�re', 'lat' => '48.3289', 'lng' => '1.6927'),
      array('postal_code' => '28150', 'name' => 'Montainville', 'lat' => '48.2711', 'lng' => '1.5451'),
      array('postal_code' => '28150', 'name' => 'Rouvray-Saint-Florentin', 'lat' => '48.2582', 'lng' => '1.5663'),
      array('postal_code' => '28150', 'name' => 'Villars', 'lat' => '48.2315', 'lng' => '1.5493'),
      array('postal_code' => '28150', 'name' => 'Baignolet', 'lat' => '48.1740', 'lng' => '1.6222'),
      array('postal_code' => '28160', 'name' => 'Gohory', 'lat' => '48.1662', 'lng' => '1.2285'),
      array('postal_code' => '28150', 'name' => 'R_clainville', 'lat' => '48.3393', 'lng' => '1.7478'),
      array('postal_code' => '28140', 'name' => 'Varize', 'lat' => '48.0960', 'lng' => '1.5153'),
      array('postal_code' => '28150', 'name' => 'Ymonville', 'lat' => '48.2614', 'lng' => '1.7512'),
      array('postal_code' => '28150', 'name' => 'Theuville', 'lat' => '48.3353', 'lng' => '1.6003'),
      array('postal_code' => '28150', 'name' => 'Moutiers', 'lat' => '48.2973', 'lng' => '1.7761'),
      array('postal_code' => '28150', 'name' => 'Louville-la-Chenard', 'lat' => '48.3254', 'lng' => '1.7871'),
      array('postal_code' => '28150', 'name' => 'Fains-la-Folie', 'lat' => '48.2237', 'lng' => '1.6388'),
      array('postal_code' => '28150', 'name' => '�ole-en-Beauce', 'lat' => '48.2167', 'lng' => '1.7025'),
      array('postal_code' => '28150', 'name' => 'Bonc_', 'lat' => '48.3076', 'lng' => '1.5039'),
      array('postal_code' => '28150', 'name' => 'Villeneuve-Saint-Nicolas', 'lat' => '48.2886', 'lng' => '1.5664'),
      array('postal_code' => '28160', 'name' => 'Dampierre-sous-Brou', 'lat' => '48.2140', 'lng' => '1.1136'),
      array('postal_code' => '28170', 'name' => 'Ch_teauneuf-en-Thymerais', 'lat' => '48.5811', 'lng' => '1.2408'),
      array('postal_code' => '28160', 'name' => 'M_zi�res-au-Perche', 'lat' => '48.2505', 'lng' => '1.2734'),
      array('postal_code' => '28150', 'name' => 'Allonnes', 'lat' => '48.3306', 'lng' => '1.6561'),
      array('postal_code' => '28160', 'name' => 'Dangeau', 'lat' => '48.2083', 'lng' => '1.2860'),
      array('postal_code' => '28160', 'name' => 'Brou', 'lat' => '48.2172', 'lng' => '1.1654'),
      array('postal_code' => '28150', 'name' => 'Prasville', 'lat' => '48.2766', 'lng' => '1.7095'),
      array('postal_code' => '28150', 'name' => 'Voves', 'lat' => '48.2714', 'lng' => '1.6258'),
      array('postal_code' => '28150', 'name' => 'Beauvilliers', 'lat' => '48.2970', 'lng' => '1.6561'),
      array('postal_code' => '28160', 'name' => 'Unverre', 'lat' => '48.1983', 'lng' => '1.0921'),
      array('postal_code' => '28150', 'name' => 'Viabon', 'lat' => '48.2167', 'lng' => '1.7051'),
      array('postal_code' => '28160', 'name' => 'Mottereau', 'lat' => '48.2549', 'lng' => '1.1765'),
      array('postal_code' => '28150', 'name' => 'Les Villages Vov_ens', 'lat' => '48.2719', 'lng' => '1.6264'),
      array('postal_code' => '28150', 'name' => 'Ouarville', 'lat' => '48.3548', 'lng' => '1.7741'),
      array('postal_code' => '28160', 'name' => 'Bullou', 'lat' => '48.2403', 'lng' => '1.2504'),
      array('postal_code' => '28170', 'name' => 'Saint-Sauveur-Marville', 'lat' => '48.6000', 'lng' => '1.2833'),
      array('postal_code' => '28150', 'name' => 'Villeau', 'lat' => '48.2394', 'lng' => '1.6017'),
      array('postal_code' => '28150', 'name' => 'P_zy', 'lat' => '48.3180', 'lng' => '1.5736'),
      array('postal_code' => '28160', 'name' => 'Fraz_', 'lat' => '48.2611', 'lng' => '1.1003'),
      array('postal_code' => '28160', 'name' => 'Y�vres', 'lat' => '48.2108', 'lng' => '1.1872'),
      array('postal_code' => '28160', 'name' => 'Moulhard', 'lat' => '48.2087', 'lng' => '1.0439'),
      array('postal_code' => '28170', 'name' => 'Maillebois', 'lat' => '48.6303', 'lng' => '1.1489'),
      array('postal_code' => '28190', 'name' => 'Mittainvilliers', 'lat' => '48.4983', 'lng' => '1.3100'),
      array('postal_code' => '28170', 'name' => 'Fontaine-les-Ribouts', 'lat' => '48.6543', 'lng' => '1.2550'),
      array('postal_code' => '28170', 'name' => 'Favi�res', 'lat' => '48.5310', 'lng' => '1.2269'),
      array('postal_code' => '28170', 'name' => 'Le Boullay-les-Deux-�glises', 'lat' => '48.6333', 'lng' => '1.3333'),
      array('postal_code' => '28170', 'name' => 'Thimert-G_telles', 'lat' => '48.5667', 'lng' => '1.2500'),
      array('postal_code' => '28190', 'name' => 'Saint-Georges-sur-Eure', 'lat' => '48.4187', 'lng' => '1.3546'),
      array('postal_code' => '28170', 'name' => 'Serazereux', 'lat' => '48.5977', 'lng' => '1.4342'),
      array('postal_code' => '28190', 'name' => 'Saint-Luperce', 'lat' => '48.4357', 'lng' => '1.3158'),
      array('postal_code' => '28190', 'name' => 'Landelles', 'lat' => '48.4675', 'lng' => '1.1975'),
      array('postal_code' => '28190', 'name' => 'Villebon', 'lat' => '48.3920', 'lng' => '1.2078'),
      array('postal_code' => '28190', 'name' => 'Billancelles', 'lat' => '48.4868', 'lng' => '1.2141'),
      array('postal_code' => '28170', 'name' => 'Puiseux', 'lat' => '48.6367', 'lng' => '1.3754'),
      array('postal_code' => '28190', 'name' => 'V_rigny', 'lat' => '48.5197', 'lng' => '1.3231'),
      array('postal_code' => '28170', 'name' => 'Saint-Ange-et-Tor�ay', 'lat' => '48.6503', 'lng' => '1.2149'),
      array('postal_code' => '28170', 'name' => 'Tremblay-les-Villages', 'lat' => '48.6000', 'lng' => '1.3833'),
      array('postal_code' => '28170', 'name' => 'Ardelles', 'lat' => '48.5453', 'lng' => '1.1731'),
      array('postal_code' => '28190', 'name' => 'Orrouer', 'lat' => '48.4167', 'lng' => '1.2833'),
      array('postal_code' => '28170', 'name' => 'Saint-Maixme-Hauterive', 'lat' => '48.5882', 'lng' => '1.1819'),
      array('postal_code' => '28190', 'name' => 'Dangers', 'lat' => '48.5093', 'lng' => '1.3508'),
      array('postal_code' => '28170', 'name' => 'Saint-Jean-de-Rebervilliers', 'lat' => '48.6115', 'lng' => '1.2528'),
      array('postal_code' => '28190', 'name' => 'Saint-Arnoult-des-Bois', 'lat' => '48.4917', 'lng' => '1.2633'),
      array('postal_code' => '28190', 'name' => 'Le Favril', 'lat' => '48.4692', 'lng' => '1.1530'),
      array('postal_code' => '28190', 'name' => 'Fontaine-la-Guyon', 'lat' => '48.4727', 'lng' => '1.3142'),
      array('postal_code' => '28190', 'name' => 'Courville-sur-Eure', 'lat' => '48.4490', 'lng' => '1.2409'),
      array('postal_code' => '28190', 'name' => 'Mittainvilliers-V_rigny', 'lat' => '48.4983', 'lng' => '1.3100'),
      array('postal_code' => '28200', 'name' => 'Marbou_', 'lat' => '48.1138', 'lng' => '1.3321'),
      array('postal_code' => '28190', 'name' => 'Chuisnes', 'lat' => '48.4465', 'lng' => '1.2070'),
      array('postal_code' => '28190', 'name' => 'Frunc_', 'lat' => '48.4044', 'lng' => '1.2242'),
      array('postal_code' => '28200', 'name' => 'Jallans', 'lat' => '48.0745', 'lng' => '1.3686'),
      array('postal_code' => '28200', 'name' => 'Donnemain-Saint-Mam�s', 'lat' => '48.1062', 'lng' => '1.3692'),
      array('postal_code' => '28200', 'name' => 'Thiville', 'lat' => '48.0260', 'lng' => '1.3747'),
      array('postal_code' => '28200', 'name' => 'Ch_teaudun', 'lat' => '48.0833', 'lng' => '1.3333'),
      array('postal_code' => '28200', 'name' => 'Conie-Molitard', 'lat' => '48.1148', 'lng' => '1.4437'),
      array('postal_code' => '28190', 'name' => 'Saint-Germain-le-Gaillard', 'lat' => '48.4217', 'lng' => '1.2594'),
      array('postal_code' => '28200', 'name' => 'Villampuy', 'lat' => '48.0372', 'lng' => '1.5099'),
      array('postal_code' => '28200', 'name' => 'Civry', 'lat' => '48.0911', 'lng' => '1.4903'),
      array('postal_code' => '28200', 'name' => 'Lanneray', 'lat' => '48.0864', 'lng' => '1.2414'),
      array('postal_code' => '28200', 'name' => 'Ozoir-le-Breuil', 'lat' => '48.0136', 'lng' => '1.4797'),
      array('postal_code' => '28200', 'name' => 'Mol_ans', 'lat' => '48.1178', 'lng' => '1.3890'),
      array('postal_code' => '28200', 'name' => 'Logron', 'lat' => '48.1469', 'lng' => '1.2649'),
      array('postal_code' => '28200', 'name' => 'Saint-Christophe', 'lat' => '48.1270', 'lng' => '1.3662'),
      array('postal_code' => '28200', 'name' => 'Lutz-en-Dunois', 'lat' => '48.0599', 'lng' => '1.4158'),
      array('postal_code' => '28200', 'name' => 'Saint-Denis-les-Ponts', 'lat' => '48.0669', 'lng' => '1.2976'),
      array('postal_code' => '28190', 'name' => 'Pontgouin', 'lat' => '48.4817', 'lng' => '1.1601'),
      array('postal_code' => '28200', 'name' => 'La Chapelle-du-Noyer', 'lat' => '48.0319', 'lng' => '1.3095'),
      array('postal_code' => '28202 CEDEX', 'name' => 'Ch_teaudun', 'lat' => '48.0833', 'lng' => '1.3333'),
      array('postal_code' => '28201 CEDEX', 'name' => 'Ch_teaudun', 'lat' => '48.0833', 'lng' => '1.3333'),
      array('postal_code' => '28205 CEDEX', 'name' => 'Ch_teaudun', 'lat' => '48.0833', 'lng' => '1.3333'),
      array('postal_code' => '28200', 'name' => 'Saint-Cloud-en-Dunois', 'lat' => '48.0333', 'lng' => '1.4667'),
      array('postal_code' => '28203 CEDEX', 'name' => 'Ch_teaudun', 'lat' => '48.0833', 'lng' => '1.3333'),
      array('postal_code' => '28220', 'name' => 'Autheuil', 'lat' => '48.0076', 'lng' => '1.2913'),
      array('postal_code' => '28210', 'name' => 'Lormaye', 'lat' => '48.6493', 'lng' => '1.5339'),
      array('postal_code' => '28209 CEDEX', 'name' => 'Ch_teaudun', 'lat' => '48.0833', 'lng' => '1.3333'),
      array('postal_code' => '28220', 'name' => 'Langey', 'lat' => '48.0450', 'lng' => '1.1882'),
      array('postal_code' => '28210', 'name' => 'Senantes', 'lat' => '48.6667', 'lng' => '1.5667'),
      array('postal_code' => '28210', 'name' => 'Saint-Lucien', 'lat' => '48.6476', 'lng' => '1.6244'),
      array('postal_code' => '28240', 'name' => 'Saint-Maurice-Saint-Germain', 'lat' => '48.4972', 'lng' => '1.0777'),
      array('postal_code' => '28210', 'name' => 'Faverolles', 'lat' => '48.6875', 'lng' => '1.5790'),
      array('postal_code' => '28210', 'name' => 'Br_champs', 'lat' => '48.6724', 'lng' => '1.5219'),
      array('postal_code' => '28210', 'name' => 'Ormoy', 'lat' => '48.6223', 'lng' => '1.4744'),
      array('postal_code' => '28210', 'name' => 'Le Boullay-Mivoye', 'lat' => '48.6477', 'lng' => '1.4042'),
      array('postal_code' => '28220', 'name' => 'Le M_e', 'lat' => '47.9857', 'lng' => '1.4163'),
      array('postal_code' => '28210', 'name' => 'Croisilles', 'lat' => '48.6915', 'lng' => '1.5006'),
      array('postal_code' => '28210', 'name' => 'N_ron', 'lat' => '48.6018', 'lng' => '1.5139'),
      array('postal_code' => '28210', 'name' => 'Le Boullay-Thierry', 'lat' => '48.6392', 'lng' => '1.4299'),
      array('postal_code' => '28207 CEDEX', 'name' => 'Ch_teaudun', 'lat' => '48.0833', 'lng' => '1.3333'),
      array('postal_code' => '28220', 'name' => 'Cloyes-sur-le-Loir', 'lat' => '47.9973', 'lng' => '1.2371'),
      array('postal_code' => '28232 CEDEX', 'name' => '�pernon', 'lat' => '48.6103', 'lng' => '1.6722'),
      array('postal_code' => '28240', 'name' => 'Les Corv_es-les-Yys', 'lat' => '48.3620', 'lng' => '1.1397'),
      array('postal_code' => '28211 CEDEX', 'name' => 'Pierres', 'lat' => '48.5921', 'lng' => '1.5644'),
      array('postal_code' => '28210', 'name' => 'Villemeux-sur-Eure', 'lat' => '48.6726', 'lng' => '1.4647'),
      array('postal_code' => '28210', 'name' => 'Nogent-le-Roi', 'lat' => '48.6478', 'lng' => '1.5293'),
      array('postal_code' => '28220', 'name' => 'Boisgasson', 'lat' => '48.0491', 'lng' => '1.1514'),
      array('postal_code' => '28210', 'name' => 'Les Pinthi�res', 'lat' => '48.7020', 'lng' => '1.5693'),
      array('postal_code' => '28240', 'name' => 'Meauc_', 'lat' => '48.4866', 'lng' => '1.0032'),
      array('postal_code' => '28210', 'name' => 'Chaudon', 'lat' => '48.6628', 'lng' => '1.4967'),
      array('postal_code' => '28210', 'name' => 'Saint-Laurent-la-G_tine', 'lat' => '48.7015', 'lng' => '1.5412'),
      array('postal_code' => '28240', 'name' => 'Montlandon', 'lat' => '48.3925', 'lng' => '1.0239'),
      array('postal_code' => '28240', 'name' => 'Vaupillon', 'lat' => '48.4602', 'lng' => '0.9947'),
      array('postal_code' => '28240', 'name' => 'La Loupe', 'lat' => '48.4732', 'lng' => '1.0158'),
      array('postal_code' => '28240', 'name' => 'Fontaine-Simon', 'lat' => '48.5042', 'lng' => '1.0192'),
      array('postal_code' => '28220', 'name' => 'Romilly-sur-Aigre', 'lat' => '47.9823', 'lng' => '1.2828'),
      array('postal_code' => '28210', 'name' => 'Coulombs', 'lat' => '48.6525', 'lng' => '1.5465'),
      array('postal_code' => '28231 CEDEX', 'name' => '�pernon', 'lat' => '48.6103', 'lng' => '1.6722'),
      array('postal_code' => '28220', 'name' => 'Charray', 'lat' => '47.9709', 'lng' => '1.3263'),
      array('postal_code' => '28230', 'name' => '�pernon', 'lat' => '48.6103', 'lng' => '1.6722'),
      array('postal_code' => '28240', 'name' => 'Saint-Victor-de-Buthon', 'lat' => '48.4103', 'lng' => '0.9683'),
      array('postal_code' => '28240', 'name' => 'Saint-Denis-des-Puits', 'lat' => '48.3925', 'lng' => '1.1742'),
      array('postal_code' => '28220', 'name' => 'Saint-Hilaire-sur-Yerre', 'lat' => '48.0273', 'lng' => '1.2576'),
      array('postal_code' => '28220', 'name' => 'La Fert_-Villeneuil', 'lat' => '47.9832', 'lng' => '1.3446'),
      array('postal_code' => '28240', 'name' => 'Belhomert-Gu_houville', 'lat' => '48.5053', 'lng' => '1.0586'),
      array('postal_code' => '28234 CEDEX', 'name' => '�pernon', 'lat' => '48.6103', 'lng' => '1.6722'),
      array('postal_code' => '28220', 'name' => 'Douy', 'lat' => '48.0359', 'lng' => '1.2683'),
      array('postal_code' => '28230', 'name' => 'Droue-sur-Drouette', 'lat' => '48.6005', 'lng' => '1.7011'),
      array('postal_code' => '28220', 'name' => 'Montigny-le-Gannelon', 'lat' => '48.0142', 'lng' => '1.2335'),
      array('postal_code' => '28240', 'name' => 'Manou', 'lat' => '48.5195', 'lng' => '0.9800'),
      array('postal_code' => '28240', 'name' => 'Le Thieulin', 'lat' => '48.4074', 'lng' => '1.1332'),
      array('postal_code' => '28250', 'name' => 'La Saucelle', 'lat' => '48.6306', 'lng' => '1.0288'),
      array('postal_code' => '28240', 'name' => 'Montireau', 'lat' => '48.4086', 'lng' => '1.0270'),
      array('postal_code' => '28250', 'name' => 'Jaudrais', 'lat' => '48.5780', 'lng' => '1.1275'),
      array('postal_code' => '28250', 'name' => 'Digny', 'lat' => '48.5363', 'lng' => '1.1536'),
      array('postal_code' => '28260', 'name' => 'Saint-Ouen-Marchefroy', 'lat' => '48.8462', 'lng' => '1.5268'),
      array('postal_code' => '28260', 'name' => 'Sorel-Moussel', 'lat' => '48.8339', 'lng' => '1.3670'),
      array('postal_code' => '28250', 'name' => 'La Puisaye', 'lat' => '48.6083', 'lng' => '0.9582'),
      array('postal_code' => '28260', 'name' => 'La Chauss_e-d�Ivry', 'lat' => '48.8824', 'lng' => '1.4794'),
      array('postal_code' => '28240', 'name' => 'Saint-�liph', 'lat' => '48.4508', 'lng' => '1.0255'),
      array('postal_code' => '28260', 'name' => 'Anet', 'lat' => '48.8564', 'lng' => '1.4398'),
      array('postal_code' => '28250', 'name' => 'Louvilliers-l�s-Perche', 'lat' => '48.6225', 'lng' => '1.0802'),
      array('postal_code' => '28260', 'name' => 'Saussay', 'lat' => '48.8557', 'lng' => '1.4089'),
      array('postal_code' => '28250', 'name' => 'Le Mesnil-Thomas', 'lat' => '48.5996', 'lng' => '1.0961'),
      array('postal_code' => '28250', 'name' => 'Senonches', 'lat' => '48.5600', 'lng' => '1.0307'),
      array('postal_code' => '28260', 'name' => 'Rouvres', 'lat' => '48.8398', 'lng' => '1.4858'),
      array('postal_code' => '28260', 'name' => 'Berch�res-sur-Vesgre', 'lat' => '48.8425', 'lng' => '1.5441'),
      array('postal_code' => '28250', 'name' => 'La Framboisi�re', 'lat' => '48.5944', 'lng' => '1.0139'),
      array('postal_code' => '28240', 'name' => 'Friaize', 'lat' => '48.4314', 'lng' => '1.1345'),
      array('postal_code' => '28240', 'name' => 'Champrond-en-G_tine', 'lat' => '48.4025', 'lng' => '1.0753'),
      array('postal_code' => '28260', 'name' => 'Gilles', 'lat' => '48.9124', 'lng' => '1.5148'),
      array('postal_code' => '28270', 'name' => 'Les Ch_telets', 'lat' => '48.6507', 'lng' => '1.0118'),
      array('postal_code' => '28260', 'name' => 'Guainville', 'lat' => '48.9169', 'lng' => '1.4910'),
      array('postal_code' => '28260', 'name' => 'Boncourt', 'lat' => '48.8461', 'lng' => '1.4628'),
      array('postal_code' => '28270', 'name' => 'Brezolles', 'lat' => '48.6903', 'lng' => '1.0740'),
      array('postal_code' => '28270', 'name' => 'Laons', 'lat' => '48.7046', 'lng' => '1.1767'),
      array('postal_code' => '28260', 'name' => 'Oulins', 'lat' => '48.8645', 'lng' => '1.4704'),
      array('postal_code' => '28270', 'name' => 'Montigny-sur-Avre', 'lat' => '48.7293', 'lng' => '1.0214'),
      array('postal_code' => '28270', 'name' => 'Saint-Lubin-de-Cravant', 'lat' => '48.7113', 'lng' => '1.0892'),
      array('postal_code' => '28270', 'name' => 'La Manceli�re', 'lat' => '48.6454', 'lng' => '0.9794'),
      array('postal_code' => '28290', 'name' => 'Arrou', 'lat' => '48.0977', 'lng' => '1.1285'),
      array('postal_code' => '28290', 'name' => 'Courtalain', 'lat' => '48.0811', 'lng' => '1.1407'),
      array('postal_code' => '28300', 'name' => 'Jouy', 'lat' => '48.5100', 'lng' => '1.5450'),
      array('postal_code' => '28270', 'name' => 'Fessanvilliers-Mattanvilliers', 'lat' => '48.7123', 'lng' => '1.0466'),
      array('postal_code' => '28300', 'name' => 'Gasville-Ois�me', 'lat' => '48.4697', 'lng' => '1.5384'),
      array('postal_code' => '28300', 'name' => 'Coltainville', 'lat' => '48.4875', 'lng' => '1.5878'),
      array('postal_code' => '28260', 'name' => 'Le Mesnil-Simon', 'lat' => '48.8962', 'lng' => '1.5376'),
      array('postal_code' => '28270', 'name' => 'Rueil-la-Gadeli�re', 'lat' => '48.7196', 'lng' => '0.9725'),
      array('postal_code' => '28270', 'name' => 'Escorpain', 'lat' => '48.7218', 'lng' => '1.2087'),
      array('postal_code' => '28270', 'name' => 'B_rou-la-Muloti�re', 'lat' => '48.7456', 'lng' => '1.0489'),
      array('postal_code' => '28270', 'name' => 'Revercourt', 'lat' => '48.7211', 'lng' => '1.0844'),
      array('postal_code' => '28290', 'name' => 'Chapelle-Royale', 'lat' => '48.1449', 'lng' => '1.0444'),
      array('postal_code' => '28290', 'name' => 'Ch_tillon-en-Dunois', 'lat' => '48.1164', 'lng' => '1.1859'),
      array('postal_code' => '28270', 'name' => 'Beauche', 'lat' => '48.6846', 'lng' => '0.9658'),
      array('postal_code' => '28270', 'name' => 'Prudemanche', 'lat' => '48.7159', 'lng' => '1.1355'),
      array('postal_code' => '28270', 'name' => 'Ch_taincourt', 'lat' => '48.6957', 'lng' => '1.2250'),
      array('postal_code' => '28270', 'name' => 'Crucey-Villages', 'lat' => '48.6667', 'lng' => '1.0833'),
      array('postal_code' => '28290', 'name' => 'Saint-Pellerin', 'lat' => '48.0701', 'lng' => '1.1410'),
      array('postal_code' => '28300', 'name' => 'Bailleau-l��v�que', 'lat' => '48.4896', 'lng' => '1.3967'),
      array('postal_code' => '28300', 'name' => 'Fresnay-le-Gilmert', 'lat' => '48.5141', 'lng' => '1.4183'),
      array('postal_code' => '28300', 'name' => 'Challet', 'lat' => '48.5545', 'lng' => '1.4346'),
      array('postal_code' => '28300', 'name' => 'Saint-Prest', 'lat' => '48.4911', 'lng' => '1.5303'),
      array('postal_code' => '28310', 'name' => 'Trancrainville', 'lat' => '48.2386', 'lng' => '1.8592'),
      array('postal_code' => '28300', 'name' => 'Cintray', 'lat' => '48.4488', 'lng' => '1.3661'),
      array('postal_code' => '28300', 'name' => 'L�ves', 'lat' => '48.4707', 'lng' => '1.4819'),
      array('postal_code' => '28310', 'name' => 'Levesville-la-Chenard', 'lat' => '48.3021', 'lng' => '1.8251'),
      array('postal_code' => '28310', 'name' => 'Toury', 'lat' => '48.1940', 'lng' => '1.9348'),
      array('postal_code' => '28300', 'name' => 'Briconville', 'lat' => '48.5279', 'lng' => '1.3879'),
      array('postal_code' => '28310', 'name' => 'Barmainville', 'lat' => '48.2647', 'lng' => '1.9654'),
      array('postal_code' => '28300', 'name' => 'Champhol', 'lat' => '48.4681', 'lng' => '1.5028'),
      array('postal_code' => '28300', 'name' => 'Cl_villiers', 'lat' => '48.5437', 'lng' => '1.3861'),
      array('postal_code' => '28300', 'name' => 'Saint-Aubin-des-Bois', 'lat' => '48.4655', 'lng' => '1.3578'),
      array('postal_code' => '28303 CEDEX', 'name' => 'Mainvilliers', 'lat' => '48.4500', 'lng' => '1.4561'),
      array('postal_code' => '28305 CEDEX', 'name' => 'Mainvilliers', 'lat' => '48.4500', 'lng' => '1.4561'),
      array('postal_code' => '28310', 'name' => 'Intr_ville', 'lat' => '48.2970', 'lng' => '1.9364'),
      array('postal_code' => '28304 CEDEX', 'name' => 'Mainvilliers', 'lat' => '48.4500', 'lng' => '1.4561'),
      array('postal_code' => '28301 CEDEX', 'name' => 'Mainvilliers', 'lat' => '48.4500', 'lng' => '1.4561'),
      array('postal_code' => '28300', 'name' => 'Amilly', 'lat' => '48.4433', 'lng' => '1.3935'),
      array('postal_code' => '28300', 'name' => 'Berch�res-Saint-Germain', 'lat' => '48.5361', 'lng' => '1.4795'),
      array('postal_code' => '28310', 'name' => 'Fresnay-l��v�que', 'lat' => '48.2665', 'lng' => '1.8235'),
      array('postal_code' => '28300', 'name' => 'Poisvilliers', 'lat' => '48.5084', 'lng' => '1.4689'),
      array('postal_code' => '28310', 'name' => 'Allaines-Mervilliers', 'lat' => '48.2000', 'lng' => '1.8333'),
      array('postal_code' => '28310', 'name' => 'Gouillons', 'lat' => '48.3438', 'lng' => '1.8396'),
      array('postal_code' => '28310', 'name' => 'Neuvy-en-Beauce', 'lat' => '48.2681', 'lng' => '1.8775'),
      array('postal_code' => '28310', 'name' => 'Santilly', 'lat' => '48.1467', 'lng' => '1.8717'),
      array('postal_code' => '28302 CEDEX', 'name' => 'Mainvilliers', 'lat' => '48.4500', 'lng' => '1.4561'),
      array('postal_code' => '28320', 'name' => 'Ymeray', 'lat' => '48.5100', 'lng' => '1.7003'),
      array('postal_code' => '28310', 'name' => 'Janville', 'lat' => '48.2028', 'lng' => '1.8802'),
      array('postal_code' => '28300', 'name' => 'Mainvilliers', 'lat' => '48.4500', 'lng' => '1.4561'),
      array('postal_code' => '28310', 'name' => 'Gommerville', 'lat' => '48.3458', 'lng' => '1.9449'),
      array('postal_code' => '28310', 'name' => 'Oinville-Saint-Liphard', 'lat' => '48.2346', 'lng' => '1.9171'),
      array('postal_code' => '28309 CEDEX', 'name' => 'Mainvilliers', 'lat' => '48.4500', 'lng' => '1.4561'),
      array('postal_code' => '28310', 'name' => 'Baudreville', 'lat' => '48.3326', 'lng' => '1.9043'),
      array('postal_code' => '28310', 'name' => 'M_rouville', 'lat' => '48.2962', 'lng' => '1.8979'),
      array('postal_code' => '28310', 'name' => 'Le Puiset', 'lat' => '48.2090', 'lng' => '1.8645'),
      array('postal_code' => '28310', 'name' => 'Poinville', 'lat' => '48.1786', 'lng' => '1.9012'),
      array('postal_code' => '28310', 'name' => 'Rouvray-Saint-Denis', 'lat' => '48.2780', 'lng' => '1.9436'),
      array('postal_code' => '28330', 'name' => 'Soiz_', 'lat' => '48.1653', 'lng' => '0.8888'),
      array('postal_code' => '28320', 'name' => 'Bailleau-Armenonville', 'lat' => '48.5333', 'lng' => '1.6500'),
      array('postal_code' => '28310', 'name' => 'Guilleville', 'lat' => '48.2250', 'lng' => '1.8128'),
      array('postal_code' => '28330', 'name' => 'B_thonvilliers', 'lat' => '48.2210', 'lng' => '0.9094'),
      array('postal_code' => '28320', 'name' => '�crosnes', 'lat' => '48.5464', 'lng' => '1.7291'),
      array('postal_code' => '28330', 'name' => 'Les Autels-Villevillon', 'lat' => '48.1728', 'lng' => '0.9976'),
      array('postal_code' => '28320', 'name' => 'Gas', 'lat' => '48.5667', 'lng' => '1.6667'),
      array('postal_code' => '28320', 'name' => 'Gallardon', 'lat' => '48.5262', 'lng' => '1.6931'),
      array('postal_code' => '28340', 'name' => 'La Chapelle-Fortin', 'lat' => '48.6458', 'lng' => '0.8637'),
      array('postal_code' => '28340', 'name' => 'La Fert_-Vidame', 'lat' => '48.6116', 'lng' => '0.9013'),
      array('postal_code' => '28330', 'name' => 'Charbonni�res', 'lat' => '48.1904', 'lng' => '0.9524'),
      array('postal_code' => '28330', 'name' => 'La Bazoche-Gouet', 'lat' => '48.1399', 'lng' => '0.9816'),
      array('postal_code' => '28330', 'name' => 'Saint-Bomer', 'lat' => '48.1957', 'lng' => '0.8278'),
      array('postal_code' => '28330', 'name' => 'Chapelle-Guillaume', 'lat' => '48.1138', 'lng' => '0.9072'),
      array('postal_code' => '28330', 'name' => 'Coudray-au-Perche', 'lat' => '48.2320', 'lng' => '0.8563'),
      array('postal_code' => '28340', 'name' => 'Lamblore', 'lat' => '48.6251', 'lng' => '0.9182'),
      array('postal_code' => '28330', 'name' => 'Authon-du-Perche', 'lat' => '48.1962', 'lng' => '0.8919'),
      array('postal_code' => '28330', 'name' => 'Les �tilleux', 'lat' => '48.2322', 'lng' => '0.8192'),
      array('postal_code' => '28340', 'name' => 'Rohaire', 'lat' => '48.6699', 'lng' => '0.8503'),
      array('postal_code' => '28340', 'name' => 'Morvilliers', 'lat' => '48.6446', 'lng' => '0.9384'),
      array('postal_code' => '28401 CEDEX', 'name' => 'Nogent-le-Rotrou', 'lat' => '48.3167', 'lng' => '0.8333'),
      array('postal_code' => '28400', 'name' => 'Margon', 'lat' => '48.3357', 'lng' => '0.8345'),
      array('postal_code' => '28380', 'name' => 'Saint-R_my-sur-Avre', 'lat' => '48.7614', 'lng' => '1.2453'),
      array('postal_code' => '28360', 'name' => 'Dammarie', 'lat' => '48.3431', 'lng' => '1.4944'),
      array('postal_code' => '28360', 'name' => 'La Bourdini�re-Saint-Loup', 'lat' => '48.3167', 'lng' => '1.4333'),
      array('postal_code' => '28360', 'name' => 'Theuville', 'lat' => '48.3356', 'lng' => '1.5998'),
      array('postal_code' => '28400', 'name' => 'Brunelles', 'lat' => '48.3242', 'lng' => '0.8934'),
      array('postal_code' => '28340', 'name' => 'Boissy-l�s-Perche', 'lat' => '48.6852', 'lng' => '0.8893'),
      array('postal_code' => '28410', 'name' => 'Goussainville', 'lat' => '48.7767', 'lng' => '1.5554'),
      array('postal_code' => '28360', 'name' => 'Fresnay-le-Comte', 'lat' => '48.3023', 'lng' => '1.4769'),
      array('postal_code' => '28360', 'name' => 'Meslay-le-Vidame', 'lat' => '48.2801', 'lng' => '1.4597'),
      array('postal_code' => '28410', 'name' => 'Boutigny-Prouais', 'lat' => '48.7500', 'lng' => '1.5833'),
      array('postal_code' => '28360', 'name' => 'Vitray-en-Beauce', 'lat' => '48.2760', 'lng' => '1.4208'),
      array('postal_code' => '28400', 'name' => 'Saint-Jean-Pierre-Fixte', 'lat' => '48.2907', 'lng' => '0.8312'),
      array('postal_code' => '28340', 'name' => 'Les Ressuintes', 'lat' => '48.5951', 'lng' => '0.9386'),
      array('postal_code' => '28400', 'name' => 'La Gaudaine', 'lat' => '48.3023', 'lng' => '0.9284'),
      array('postal_code' => '28360', 'name' => 'Prunay-le-Gillon', 'lat' => '48.3640', 'lng' => '1.6355'),
      array('postal_code' => '28350', 'name' => 'Dampierre-sur-Avre', 'lat' => '48.7625', 'lng' => '1.1493'),
      array('postal_code' => '28400', 'name' => 'Nogent-le-Rotrou', 'lat' => '48.3167', 'lng' => '0.8333'),
      array('postal_code' => '28400', 'name' => 'Coudreceau', 'lat' => '48.3468', 'lng' => '0.9204'),
      array('postal_code' => '28403 CEDEX', 'name' => 'Nogent-le-Rotrou', 'lat' => '48.3167', 'lng' => '0.8333'),
      array('postal_code' => '28400', 'name' => 'Souanc_-au-Perche', 'lat' => '48.2670', 'lng' => '0.8553'),
      array('postal_code' => '28350', 'name' => 'Saint-Lubin-des-Joncherets', 'lat' => '48.7667', 'lng' => '1.2167'),
      array('postal_code' => '28410', 'name' => 'Havelu', 'lat' => '48.7876', 'lng' => '1.5351'),
      array('postal_code' => '28410', 'name' => 'B_', 'lat' => '48.7970', 'lng' => '1.4970'),
      array('postal_code' => '28360', 'name' => 'Luplant_', 'lat' => '48.3003', 'lng' => '1.3991'),
      array('postal_code' => '28402 CEDEX', 'name' => 'Nogent-le-Rotrou', 'lat' => '48.3167', 'lng' => '0.8333'),
      array('postal_code' => '28400', 'name' => 'Trizay-Coutretot-Saint-Serge', 'lat' => '48.2924', 'lng' => '0.8667'),
      array('postal_code' => '28400', 'name' => 'Champrond-en-Perchet', 'lat' => '48.3167', 'lng' => '0.8667'),
      array('postal_code' => '28400', 'name' => 'Marolles-les-Buis', 'lat' => '48.3615', 'lng' => '0.9274'),
      array('postal_code' => '28404 CEDEX', 'name' => 'Nogent-le-Rotrou', 'lat' => '48.3167', 'lng' => '0.8333'),
      array('postal_code' => '28410', 'name' => 'Saint-Lubin-de-la-Haye', 'lat' => '48.8188', 'lng' => '1.5722'),
      array('postal_code' => '28480', 'name' => 'Fr_tigny', 'lat' => '48.3732', 'lng' => '0.9700'),
      array('postal_code' => '28409 CEDEX', 'name' => 'Nogent-le-Rotrou', 'lat' => '48.3167', 'lng' => '0.8333'),
      array('postal_code' => '28410', 'name' => 'Marchezais', 'lat' => '48.7719', 'lng' => '1.5093'),
      array('postal_code' => '28410', 'name' => 'Abondant', 'lat' => '48.7859', 'lng' => '1.4401'),
      array('postal_code' => '28410', 'name' => 'Serville', 'lat' => '48.7690', 'lng' => '1.4859'),
      array('postal_code' => '28410', 'name' => 'Champagne', 'lat' => '48.7642', 'lng' => '1.5683'),
      array('postal_code' => '28410', 'name' => 'Brou_', 'lat' => '48.7487', 'lng' => '1.5235'),
      array('postal_code' => '28480', 'name' => 'Miermaigne', 'lat' => '48.2466', 'lng' => '0.9918'),
      array('postal_code' => '28480', 'name' => 'Thiron Gardais', 'lat' => '48.3167', 'lng' => '0.9833'),
      array('postal_code' => '28480', 'name' => 'Happonvilliers', 'lat' => '48.3249', 'lng' => '1.1122'),
      array('postal_code' => '28480', 'name' => 'Combres', 'lat' => '48.3251', 'lng' => '1.0631'),
      array('postal_code' => '28480', 'name' => 'Vich�res', 'lat' => '48.2688', 'lng' => '0.9125'),
      array('postal_code' => '28480', 'name' => 'Beaumont-les-Autels', 'lat' => '48.2579', 'lng' => '0.9594'),
      array('postal_code' => '28480', 'name' => 'Luigny', 'lat' => '48.2405', 'lng' => '1.0247'),
      array('postal_code' => '28480', 'name' => 'Chassant', 'lat' => '48.2953', 'lng' => '1.0639'),
      array('postal_code' => '28480', 'name' => 'Saint-Denis-d�Authou', 'lat' => '48.3449', 'lng' => '0.9856'),
      array('postal_code' => '28500', 'name' => '�cluzelles', 'lat' => '48.7099', 'lng' => '1.4246'),
      array('postal_code' => '28500', 'name' => 'Cherisy', 'lat' => '48.7500', 'lng' => '1.4333'),
      array('postal_code' => '28480', 'name' => 'Argenvilliers', 'lat' => '48.2603', 'lng' => '0.9578'),
      array('postal_code' => '28500', 'name' => 'Sainte-Gemme-Moronval', 'lat' => '48.7384', 'lng' => '1.4145'),
      array('postal_code' => '28500', 'name' => 'La Chapelle-Forainvilliers', 'lat' => '48.7295', 'lng' => '1.5016'),
      array('postal_code' => '28481 CEDEX', 'name' => 'Thiron Gardais', 'lat' => '48.3167', 'lng' => '0.9833'),
      array('postal_code' => '28489 CEDEX', 'name' => 'Thiron Gardais', 'lat' => '48.3167', 'lng' => '0.9833'),
      array('postal_code' => '28480', 'name' => 'La Croix-du-Perche', 'lat' => '48.2746', 'lng' => '1.0497'),
      array('postal_code' => '28500', 'name' => 'Garanci�res-en-Drouais', 'lat' => '48.7015', 'lng' => '1.2851'),
      array('postal_code' => '28500', 'name' => 'M_zi�res-en-Drouais', 'lat' => '48.7241', 'lng' => '1.4244'),
      array('postal_code' => '28500', 'name' => 'Aunay-sous-Cr_cy', 'lat' => '48.6696', 'lng' => '1.3029'),
      array('postal_code' => '28500', 'name' => 'Vert-en-Drouais', 'lat' => '48.7603', 'lng' => '1.2946'),
      array('postal_code' => '28500', 'name' => 'Cr_cy-Couv_', 'lat' => '48.6711', 'lng' => '1.2827'),
      array('postal_code' => '28500', 'name' => 'Montreuil', 'lat' => '48.7774', 'lng' => '1.3697'),
      array('postal_code' => '28500', 'name' => 'Allainville', 'lat' => '48.7223', 'lng' => '1.3024'),
      array('postal_code' => '28500', 'name' => 'Ouerre', 'lat' => '48.7007', 'lng' => '1.4655'),
      array('postal_code' => '28500', 'name' => 'Boissy-en-Drouais', 'lat' => '48.7289', 'lng' => '1.2628'),
      array('postal_code' => '28500', 'name' => 'Vernouillet', 'lat' => '48.7209', 'lng' => '1.3695'),
      array('postal_code' => '28500', 'name' => 'Luray', 'lat' => '48.7204', 'lng' => '1.3989'),
      array('postal_code' => '28630', 'name' => 'Sours', 'lat' => '48.4104', 'lng' => '1.5989'),
      array('postal_code' => '28500', 'name' => 'Garnay', 'lat' => '48.7049', 'lng' => '1.3371'),
      array('postal_code' => '28500', 'name' => 'Saulni�res', 'lat' => '48.6595', 'lng' => '1.2720'),
      array('postal_code' => '28630', 'name' => 'Barjouville', 'lat' => '48.4100', 'lng' => '1.4764'),
      array('postal_code' => '28501 CEDEX', 'name' => 'Vernouillet', 'lat' => '48.7209', 'lng' => '1.3695'),
      array('postal_code' => '28500', 'name' => 'Marville-Moutiers-Br_l_', 'lat' => '48.6667', 'lng' => '1.4000'),
      array('postal_code' => '28630', 'name' => 'Berch�res-les-Pierres', 'lat' => '48.3852', 'lng' => '1.5545'),
      array('postal_code' => '28500', 'name' => 'Louvilliers-en-Drouais', 'lat' => '48.7323', 'lng' => '1.2843'),
      array('postal_code' => '28500', 'name' => 'Charpont', 'lat' => '48.6991', 'lng' => '1.4361'),
      array('postal_code' => '28500', 'name' => 'Germainville', 'lat' => '48.7418', 'lng' => '1.4822'),
      array('postal_code' => '28630', 'name' => 'Ver-l�s-Chartres', 'lat' => '48.3833', 'lng' => '1.4833'),
      array('postal_code' => '28600', 'name' => 'Luisant', 'lat' => '48.4295', 'lng' => '1.4738'),
      array('postal_code' => '28630', 'name' => 'Fontenay-sur-Eure', 'lat' => '48.3957', 'lng' => '1.4118'),
      array('postal_code' => '28630', 'name' => 'Morancez', 'lat' => '48.4005', 'lng' => '1.4939'),
      array('postal_code' => '28500', 'name' => 'Tr_on', 'lat' => '48.6771', 'lng' => '1.3267'),
      array('postal_code' => '28630', 'name' => 'Thivars', 'lat' => '48.3785', 'lng' => '1.4515'),
      array('postal_code' => '28630', 'name' => 'Nogent-le-Phaye', 'lat' => '48.4453', 'lng' => '1.5778'),
      array('postal_code' => '28630', 'name' => 'Gellainville', 'lat' => '48.4087', 'lng' => '1.5297'),
      array('postal_code' => '28637 CEDEX', 'name' => 'Gellainville', 'lat' => '48.4087', 'lng' => '1.5297'),
      array('postal_code' => '28633 CEDEX', 'name' => 'Gellainville', 'lat' => '48.4087', 'lng' => '1.5297'),
      array('postal_code' => '28630', 'name' => 'Migni�res', 'lat' => '48.3593', 'lng' => '1.4253'),
      array('postal_code' => '28700', 'name' => 'Aunay-sous-Auneau', 'lat' => '48.4414', 'lng' => '1.8109'),
      array('postal_code' => '28700', 'name' => 'Oysonville', 'lat' => '48.3936', 'lng' => '1.9572'),
      array('postal_code' => '28632 CEDEX', 'name' => 'Gellainville', 'lat' => '48.4087', 'lng' => '1.5297'),
      array('postal_code' => '28700', 'name' => 'Champseru', 'lat' => '48.4919', 'lng' => '1.6574'),
      array('postal_code' => '28630', 'name' => 'Corancez', 'lat' => '48.3667', 'lng' => '1.5167'),
      array('postal_code' => '28700', 'name' => 'Saint-L_ger-des-Aub_es', 'lat' => '48.4120', 'lng' => '1.7395'),
      array('postal_code' => '28636 CEDEX', 'name' => 'Gellainville', 'lat' => '48.4087', 'lng' => '1.5297'),
      array('postal_code' => '28700', 'name' => 'Gommerville', 'lat' => '48.3453', 'lng' => '1.9447'),
      array('postal_code' => '28631 CEDEX', 'name' => 'Gellainville', 'lat' => '48.4087', 'lng' => '1.5297'),
      array('postal_code' => '28700', 'name' => 'Orlu', 'lat' => '48.3711', 'lng' => '1.9189'),
      array('postal_code' => '28639 CEDEX', 'name' => 'Gellainville', 'lat' => '48.4087', 'lng' => '1.5297'),
      array('postal_code' => '28630', 'name' => 'Le Coudray', 'lat' => '48.4211', 'lng' => '1.5006'),
      array('postal_code' => '28700', 'name' => 'Sainville', 'lat' => '48.4148', 'lng' => '1.8796'),
      array('postal_code' => '28700', 'name' => 'Garanci�res-en-Beauce', 'lat' => '48.4365', 'lng' => '1.9208'),
      array('postal_code' => '28700', 'name' => 'Oinville-sous-Auneau', 'lat' => '48.4662', 'lng' => '1.7267'),
      array('postal_code' => '28700', 'name' => 'Morainville', 'lat' => '48.3796', 'lng' => '1.8278'),
      array('postal_code' => '28700', 'name' => 'Houville-la-Branche', 'lat' => '48.4441', 'lng' => '1.6411'),
      array('postal_code' => '28700', 'name' => 'B_ville-le-Comte', 'lat' => '48.4356', 'lng' => '1.7131'),
      array('postal_code' => '28700', 'name' => 'Ardelu', 'lat' => '48.3543', 'lng' => '1.9116'),
      array('postal_code' => '28700', 'name' => 'Denonville', 'lat' => '48.3910', 'lng' => '1.8122'),
      array('postal_code' => '28700', 'name' => 'La Chapelle-d�Aunainville', 'lat' => '48.4248', 'lng' => '1.8132'),
      array('postal_code' => '28700', 'name' => 'Auneau', 'lat' => '48.4636', 'lng' => '1.7726'),
      array('postal_code' => '28700', 'name' => 'Auneau-Bleury-Saint-Symphorien', 'lat' => '48.4623', 'lng' => '1.7738'),
      array('postal_code' => '28700', 'name' => 'Le Gu_-de-Longroi', 'lat' => '48.5012', 'lng' => '1.7200'),
      array('postal_code' => '28700', 'name' => 'L_thuin', 'lat' => '48.3687', 'lng' => '1.8689'),
      array('postal_code' => '28700', 'name' => 'Umpeau', 'lat' => '48.4771', 'lng' => '1.6730'),
      array('postal_code' => '28700', 'name' => 'Bleury', 'lat' => '48.5198', 'lng' => '1.7483'),
      array('postal_code' => '28700', 'name' => 'Francourville', 'lat' => '48.4059', 'lng' => '1.6600'),
      array('postal_code' => '28703 CEDEX', 'name' => 'Auneau', 'lat' => '48.4636', 'lng' => '1.7726'),
      array('postal_code' => '28700', 'name' => 'Levainville', 'lat' => '48.4938', 'lng' => '1.7386'),
      array('postal_code' => '28800', 'name' => 'Bullainville', 'lat' => '48.1708', 'lng' => '1.5098'),
      array('postal_code' => '28700', 'name' => 'Ch_tenay', 'lat' => '48.3588', 'lng' => '1.8836'),
      array('postal_code' => '28700', 'name' => 'Roinville', 'lat' => '48.4447', 'lng' => '1.7494'),
      array('postal_code' => '28700', 'name' => 'Santeuil', 'lat' => '48.3876', 'lng' => '1.7333'),
      array('postal_code' => '28700', 'name' => 'Vierville', 'lat' => '48.3849', 'lng' => '1.9152'),
      array('postal_code' => '28707 CEDEX', 'name' => 'Auneau', 'lat' => '48.4636', 'lng' => '1.7726'),
      array('postal_code' => '28700', 'name' => 'Moinville-la-Jeulin', 'lat' => '48.3801', 'lng' => '1.6989'),
      array('postal_code' => '28700', 'name' => 'Voise', 'lat' => '48.3996', 'lng' => '1.7078'),
      array('postal_code' => '28800', 'name' => 'Saint-Maur-sur-le-Loir', 'lat' => '48.1531', 'lng' => '1.4197'),
      array('postal_code' => '28800', 'name' => 'Sancheville', 'lat' => '48.1928', 'lng' => '1.5778'),
      array('postal_code' => '28700', 'name' => 'Saint-Symphorien-le-Ch_teau', 'lat' => '48.5172', 'lng' => '1.7612'),
      array('postal_code' => '28800', 'name' => 'Saumeray', 'lat' => '48.2526', 'lng' => '1.3164'),
      array('postal_code' => '28701 CEDEX', 'name' => 'Auneau', 'lat' => '48.4636', 'lng' => '1.7726'),
      array('postal_code' => '28700', 'name' => 'Mondonville-Saint-Jean', 'lat' => '48.3638', 'lng' => '1.8254'),
      array('postal_code' => '28800', 'name' => 'Pr_-Saint-�vroult', 'lat' => '48.1851', 'lng' => '1.4675'),
      array('postal_code' => '28702 CEDEX', 'name' => 'Auneau', 'lat' => '48.4636', 'lng' => '1.7726'),
      array('postal_code' => '28800', 'name' => 'Pr_-Saint-Martin', 'lat' => '48.2129', 'lng' => '1.4665'),
      array('postal_code' => '28700', 'name' => 'Maisons', 'lat' => '48.4087', 'lng' => '1.8437'),
      array('postal_code' => '28709 CEDEX', 'name' => 'Auneau', 'lat' => '48.4636', 'lng' => '1.7726'),
      array('postal_code' => '28800', 'name' => 'Alluyes', 'lat' => '48.2296', 'lng' => '1.3617'),
      array('postal_code' => '28800', 'name' => 'Dancy', 'lat' => '48.1507', 'lng' => '1.4639'),
      array('postal_code' => '28800', 'name' => 'Bonneval', 'lat' => '48.1831', 'lng' => '1.3852'),
      array('postal_code' => '28800', 'name' => 'Flacey', 'lat' => '48.1474', 'lng' => '1.3506'),
      array('postal_code' => '28800', 'name' => 'Villiers-Saint-Orien', 'lat' => '48.1326', 'lng' => '1.4864'),
      array('postal_code' => '28800', 'name' => 'Neuvy-en-Dunois', 'lat' => '48.2079', 'lng' => '1.5388'),
      array('postal_code' => '28800', 'name' => 'Trizay-l�s-Bonneval', 'lat' => '48.1997', 'lng' => '1.3354'),
      array('postal_code' => '28901 CEDEX 9', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28800', 'name' => 'Moriers', 'lat' => '48.2170', 'lng' => '1.4392'),
      array('postal_code' => '28800', 'name' => 'Montharville', 'lat' => '48.1839', 'lng' => '1.3303'),
      array('postal_code' => '28800', 'name' => 'Montboissier', 'lat' => '48.2159', 'lng' => '1.4001'),
      array('postal_code' => '28800', 'name' => 'Le Gault-Saint-Denis', 'lat' => '48.2333', 'lng' => '1.4833'),
      array('postal_code' => '36003 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '28933 CEDEX 9', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '36001 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '28920 CEDEX 9', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28935 CEDEX 9', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '36006 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '28932 CEDEX 9', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28910 CEDEX 9', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28944 CEDEX 9', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '28800', 'name' => 'Bouville', 'lat' => '48.2598', 'lng' => '1.3758'),
      array('postal_code' => '28930 CEDEX 9', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '36005 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36010 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36002 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '28931 CEDEX 9', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '36000', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36004 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '28950 CEDEX 9', 'name' => 'Chartres', 'lat' => '48.4469', 'lng' => '1.4892'),
      array('postal_code' => '36008 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36016 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36017 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36019 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36018 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36013 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36015 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36009 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36011 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36020 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36026 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36007 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36021 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36014 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36012 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36025 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36024 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36100', 'name' => 'Saint-Valentin', 'lat' => '46.9516', 'lng' => '1.8643'),
      array('postal_code' => '36022 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36100', 'name' => 'Lizeray', 'lat' => '46.9667', 'lng' => '1.9000'),
      array('postal_code' => '36033 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36029 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36032 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36027 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36023 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36100', 'name' => 'Saint-Aubin', 'lat' => '46.8515', 'lng' => '2.0246'),
      array('postal_code' => '36028 CEDEX', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36100', 'name' => 'Neuvy-Pailloux', 'lat' => '46.8849', 'lng' => '1.8615'),
      array('postal_code' => '36100', 'name' => 'Vouillon', 'lat' => '46.8221', 'lng' => '1.9262'),
      array('postal_code' => '36100', 'name' => 'Thizay', 'lat' => '46.8977', 'lng' => '1.9107'),
      array('postal_code' => '36100', 'name' => 'Issoudun', 'lat' => '46.9500', 'lng' => '2.0000'),
      array('postal_code' => '36100', 'name' => 'Cond_', 'lat' => '46.8788', 'lng' => '1.9865'),
      array('postal_code' => '36100', 'name' => 'Chouday', 'lat' => '46.9106', 'lng' => '2.0647'),
      array('postal_code' => '36100', 'name' => 'Brives', 'lat' => '46.8442', 'lng' => '1.9462'),
      array('postal_code' => '36102 CEDEX', 'name' => 'Issoudun', 'lat' => '46.9500', 'lng' => '2.0000'),
      array('postal_code' => '36100', 'name' => 'Les Bordes', 'lat' => '46.9811', 'lng' => '1.9738'),
      array('postal_code' => '36101 CEDEX', 'name' => 'Issoudun', 'lat' => '46.9500', 'lng' => '2.0000'),
      array('postal_code' => '36100', 'name' => 'S_gry', 'lat' => '46.8909', 'lng' => '2.0819'),
      array('postal_code' => '36100', 'name' => 'La Champenoise', 'lat' => '46.9403', 'lng' => '1.8014'),
      array('postal_code' => '36100', 'name' => 'Saint-Georges-sur-Arnon', 'lat' => '46.9990', 'lng' => '2.0925'),
      array('postal_code' => '36100', 'name' => 'Sainte-Fauste', 'lat' => '46.8575', 'lng' => '1.8649'),
      array('postal_code' => '36109 CEDEX', 'name' => 'Issoudun', 'lat' => '46.9500', 'lng' => '2.0000'),
      array('postal_code' => '36100', 'name' => 'Saint-Aoustrille', 'lat' => '46.9392', 'lng' => '1.9212'),
      array('postal_code' => '36103 CEDEX', 'name' => 'Issoudun', 'lat' => '46.9500', 'lng' => '2.0000'),
      array('postal_code' => '36110', 'name' => 'Saint-Pierre-de-Lamps', 'lat' => '46.9712', 'lng' => '1.5130'),
      array('postal_code' => '36110', 'name' => 'Vineuil', 'lat' => '46.9004', 'lng' => '1.6354'),
      array('postal_code' => '36110', 'name' => 'Bouges-le-Ch_teau', 'lat' => '47.0333', 'lng' => '1.6667'),
      array('postal_code' => '36110', 'name' => 'Francillon', 'lat' => '46.9833', 'lng' => '1.5500'),
      array('postal_code' => '36110', 'name' => 'Saint-Martin-de-Lamps', 'lat' => '46.9898', 'lng' => '1.5250'),
      array('postal_code' => '36110', 'name' => 'Levroux', 'lat' => '46.9786', 'lng' => '1.6124'),
      array('postal_code' => '36104 CEDEX', 'name' => 'Issoudun', 'lat' => '46.9500', 'lng' => '2.0000'),
      array('postal_code' => '36110', 'name' => 'Rouvres-les-Bois', 'lat' => '47.0724', 'lng' => '1.6553'),
      array('postal_code' => '36100', 'name' => 'Meunet-Planches', 'lat' => '46.8375', 'lng' => '1.9568'),
      array('postal_code' => '36105 CEDEX', 'name' => 'Issoudun', 'lat' => '46.9500', 'lng' => '2.0000'),
      array('postal_code' => '36110', 'name' => 'Brion', 'lat' => '46.9570', 'lng' => '1.7276'),
      array('postal_code' => '36110', 'name' => 'Baudres', 'lat' => '47.0578', 'lng' => '1.5782'),
      array('postal_code' => '36107 CEDEX', 'name' => 'Issoudun', 'lat' => '46.9500', 'lng' => '2.0000'),
      array('postal_code' => '36110', 'name' => 'Bretagne', 'lat' => '47.0034', 'lng' => '1.6813'),
      array('postal_code' => '36120', 'name' => 'Jeu-les-Bois', 'lat' => '46.6732', 'lng' => '1.7946'),
      array('postal_code' => '36130', 'name' => 'Diors', 'lat' => '46.8275', 'lng' => '1.8282'),
      array('postal_code' => '36120', 'name' => 'M_ron', 'lat' => '46.8082', 'lng' => '1.8634'),
      array('postal_code' => '36120', 'name' => 'Ambrault', 'lat' => '46.7837', 'lng' => '1.9590'),
      array('postal_code' => '36120', 'name' => 'Bommiers', 'lat' => '46.7950', 'lng' => '1.9848'),
      array('postal_code' => '36130', 'name' => 'Montierchaume', 'lat' => '46.8636', 'lng' => '1.7718'),
      array('postal_code' => '36110', 'name' => 'Villegongis', 'lat' => '46.9131', 'lng' => '1.5956'),
      array('postal_code' => '36120', 'name' => '�trechet', 'lat' => '46.7794', 'lng' => '1.7840'),
      array('postal_code' => '36110', 'name' => 'Moulins-sur-C_phons', 'lat' => '47.0104', 'lng' => '1.5595'),
      array('postal_code' => '36120', 'name' => 'Pruniers', 'lat' => '46.7891', 'lng' => '2.0506'),
      array('postal_code' => '36120', 'name' => 'Saint-Ao_t', 'lat' => '46.7314', 'lng' => '1.9653'),
      array('postal_code' => '36120', 'name' => 'Sassierges-Saint-Germain', 'lat' => '46.7688', 'lng' => '1.8933'),
      array('postal_code' => '36120', 'name' => 'Ardentes', 'lat' => '46.7419', 'lng' => '1.8343'),
      array('postal_code' => '36130', 'name' => 'Coings', 'lat' => '46.8863', 'lng' => '1.7151'),
      array('postal_code' => '36130', 'name' => 'D_ols', 'lat' => '46.8293', 'lng' => '1.7043'),
      array('postal_code' => '36131 CEDEX', 'name' => 'D_ols', 'lat' => '46.8293', 'lng' => '1.7043'),
      array('postal_code' => '36140', 'name' => 'La Buxerette', 'lat' => '46.4951', 'lng' => '1.8025'),
      array('postal_code' => '36140', 'name' => 'Lourdoueix-Saint-Michel', 'lat' => '46.4260', 'lng' => '1.7292'),
      array('postal_code' => '36150', 'name' => 'Lu�ay-le-Libre', 'lat' => '47.0867', 'lng' => '1.9054'),
      array('postal_code' => '36150', 'name' => 'Reboursin', 'lat' => '47.1069', 'lng' => '1.8209'),
      array('postal_code' => '36150', 'name' => 'Giroux', 'lat' => '47.0663', 'lng' => '1.9120'),
      array('postal_code' => '36150', 'name' => 'Meunet-sur-Vatan', 'lat' => '47.0798', 'lng' => '1.8662'),
      array('postal_code' => '36150', 'name' => 'Vatan', 'lat' => '47.0745', 'lng' => '1.8101'),
      array('postal_code' => '36150', 'name' => 'Liniez', 'lat' => '47.0241', 'lng' => '1.7514'),
      array('postal_code' => '36160', 'name' => 'Sainte-S_v�re-sur-Indre', 'lat' => '46.4867', 'lng' => '2.0707'),
      array('postal_code' => '36140', 'name' => 'Montchevrier', 'lat' => '46.4806', 'lng' => '1.7425'),
      array('postal_code' => '36150', 'name' => 'M_n_tr_ols-sous-Vatan', 'lat' => '47.0156', 'lng' => '1.8432'),
      array('postal_code' => '36150', 'name' => 'Guilly', 'lat' => '47.0819', 'lng' => '1.7249'),
      array('postal_code' => '36140', 'name' => 'Crozon-sur-Vauvre', 'lat' => '46.4890', 'lng' => '1.8699'),
      array('postal_code' => '36150', 'name' => 'Buxeuil', 'lat' => '47.1333', 'lng' => '1.6866'),
      array('postal_code' => '36160', 'name' => 'Champillet', 'lat' => '46.5491', 'lng' => '2.1115'),
      array('postal_code' => '36140', 'name' => 'Aigurande', 'lat' => '46.4340', 'lng' => '1.8303'),
      array('postal_code' => '36140', 'name' => 'Crevant', 'lat' => '46.4879', 'lng' => '1.9454'),
      array('postal_code' => '36150', 'name' => 'Aize', 'lat' => '47.1038', 'lng' => '1.7018'),
      array('postal_code' => '36160', 'name' => 'Feusines', 'lat' => '46.5225', 'lng' => '2.1014'),
      array('postal_code' => '36150', 'name' => 'La Chapelle-Saint-Laurian', 'lat' => '47.0621', 'lng' => '1.7831'),
      array('postal_code' => '36160', 'name' => 'Pouligny-Saint-Martin', 'lat' => '46.5162', 'lng' => '2.0143'),
      array('postal_code' => '36150', 'name' => 'Saint-Florentin', 'lat' => '47.0782', 'lng' => '1.8007'),
      array('postal_code' => '36160', 'name' => 'Pouligny-Notre-Dame', 'lat' => '46.4833', 'lng' => '2.0167'),
      array('postal_code' => '36150', 'name' => 'Fontenay', 'lat' => '47.0611', 'lng' => '1.7441'),
      array('postal_code' => '36160', 'name' => 'La Motte-Feuilly', 'lat' => '46.5436', 'lng' => '2.0889'),
      array('postal_code' => '36160', 'name' => 'Urciers', 'lat' => '46.8667', 'lng' => '2.1167'),
      array('postal_code' => '36160', 'name' => 'Vijon', 'lat' => '46.4297', 'lng' => '2.1181'),
      array('postal_code' => '36180', 'name' => 'Fr_dille', 'lat' => '47.0000', 'lng' => '1.4667'),
      array('postal_code' => '36170', 'name' => 'Chazelet', 'lat' => '46.5099', 'lng' => '1.4432'),
      array('postal_code' => '36170', 'name' => 'Saint-Gilles', 'lat' => '46.4792', 'lng' => '1.4582'),
      array('postal_code' => '36170', 'name' => 'Saint-Civran', 'lat' => '46.4965', 'lng' => '1.3905'),
      array('postal_code' => '36160', 'name' => 'Sazeray', 'lat' => '46.4290', 'lng' => '2.0535'),
      array('postal_code' => '36160', 'name' => 'P_rassay', 'lat' => '46.4721', 'lng' => '2.1471'),
      array('postal_code' => '36160', 'name' => 'Vigoulant', 'lat' => '46.4381', 'lng' => '2.0716'),
      array('postal_code' => '36170', 'name' => 'Mouhet', 'lat' => '46.3831', 'lng' => '1.4335'),
      array('postal_code' => '36170', 'name' => 'Parnac', 'lat' => '46.4535', 'lng' => '1.4426'),
      array('postal_code' => '36170', 'name' => 'Roussines', 'lat' => '46.4688', 'lng' => '1.3895'),
      array('postal_code' => '36180', 'name' => 'Pellevoisin', 'lat' => '46.9833', 'lng' => '1.4167'),
      array('postal_code' => '36170', 'name' => 'Sacierges-Saint-Martin', 'lat' => '46.4948', 'lng' => '1.3663'),
      array('postal_code' => '36160', 'name' => 'Lignerolles', 'lat' => '46.4959', 'lng' => '2.1438'),
      array('postal_code' => '36190', 'name' => 'Saint-Plantaire', 'lat' => '46.4571', 'lng' => '1.6712'),
      array('postal_code' => '36180', 'name' => 'Selles-sur-Nahon', 'lat' => '47.0000', 'lng' => '1.4500'),
      array('postal_code' => '36180', 'name' => 'Heugnes', 'lat' => '47.0000', 'lng' => '1.4000'),
      array('postal_code' => '36170', 'name' => 'Saint-Beno�t-du-Sault', 'lat' => '46.4404', 'lng' => '1.3908'),
      array('postal_code' => '36170', 'name' => 'Vigoux', 'lat' => '46.5103', 'lng' => '1.4875'),
      array('postal_code' => '36170', 'name' => 'La Ch_tre-Langlin', 'lat' => '46.4087', 'lng' => '1.3895'),
      array('postal_code' => '36200', 'name' => 'Saint-Marcel', 'lat' => '46.6019', 'lng' => '1.5132'),
      array('postal_code' => '36190', 'name' => 'Orsennes', 'lat' => '46.4765', 'lng' => '1.6830'),
      array('postal_code' => '36190', 'name' => 'Cuzion', 'lat' => '46.4792', 'lng' => '1.6069'),
      array('postal_code' => '36200', 'name' => 'Chavin', 'lat' => '46.5615', 'lng' => '1.6111'),
      array('postal_code' => '36190', 'name' => 'Pommiers', 'lat' => '46.5236', 'lng' => '1.6560'),
      array('postal_code' => '36190', 'name' => 'Gargilesse-Dampierre', 'lat' => '46.5139', 'lng' => '1.5977'),
      array('postal_code' => '36200', 'name' => 'Le Menoux', 'lat' => '46.5545', 'lng' => '1.5692'),
      array('postal_code' => '36200', 'name' => 'Argenton-sur-Creuse', 'lat' => '46.5900', 'lng' => '1.5198'),
      array('postal_code' => '36200', 'name' => 'Mosnay', 'lat' => '46.6225', 'lng' => '1.6301'),
      array('postal_code' => '36200', 'name' => 'Tendu', 'lat' => '46.6443', 'lng' => '1.5599'),
      array('postal_code' => '36230', 'name' => 'Sarzay', 'lat' => '46.6020', 'lng' => '1.9051'),
      array('postal_code' => '36210', 'name' => 'Anjouin', 'lat' => '47.1896', 'lng' => '1.8014'),
      array('postal_code' => '36200', 'name' => 'Ceaulmont', 'lat' => '46.5232', 'lng' => '1.5757'),
      array('postal_code' => '36210', 'name' => 'Saint-Christophe-en-Bazelle', 'lat' => '47.1913', 'lng' => '1.7119'),
      array('postal_code' => '36210', 'name' => 'Sainte-C_cile', 'lat' => '47.1871', 'lng' => '1.6705'),
      array('postal_code' => '36210', 'name' => 'Bagneux', 'lat' => '47.1832', 'lng' => '1.7531'),
      array('postal_code' => '36210', 'name' => 'Parpe�ay', 'lat' => '47.2082', 'lng' => '1.6518'),
      array('postal_code' => '36220', 'name' => 'Ling_', 'lat' => '46.7548', 'lng' => '1.0838'),
      array('postal_code' => '36220', 'name' => 'M_rigny', 'lat' => '46.6307', 'lng' => '0.9271'),
      array('postal_code' => '36200', 'name' => 'Le P�chereau', 'lat' => '46.5768', 'lng' => '1.5474'),
      array('postal_code' => '36210', 'name' => 'Menetou-sur-Nahon', 'lat' => '47.2185', 'lng' => '1.6490'),
      array('postal_code' => '36220', 'name' => 'Lurais', 'lat' => '46.7045', 'lng' => '0.9509'),
      array('postal_code' => '36200', 'name' => 'Bouesse', 'lat' => '46.6157', 'lng' => '1.6865'),
      array('postal_code' => '36200', 'name' => 'Badecon-le-Pin', 'lat' => '46.5412', 'lng' => '1.5950'),
      array('postal_code' => '36210', 'name' => 'Poulaines', 'lat' => '47.1520', 'lng' => '1.6630'),
      array('postal_code' => '36230', 'name' => 'Montipouret', 'lat' => '46.6500', 'lng' => '1.9000'),
      array('postal_code' => '36220', 'name' => 'Tournon-Saint-Martin', 'lat' => '46.7342', 'lng' => '0.9551'),
      array('postal_code' => '36210', 'name' => 'Dun-le-Po�lier', 'lat' => '47.2047', 'lng' => '1.7530'),
      array('postal_code' => '36210', 'name' => 'Orville', 'lat' => '47.1528', 'lng' => '1.7908'),
      array('postal_code' => '36210', 'name' => 'Val-Fouzon', 'lat' => '47.2131', 'lng' => '1.6058'),
      array('postal_code' => '36210', 'name' => 'Chabris', 'lat' => '47.2534', 'lng' => '1.6518'),
      array('postal_code' => '36230', 'name' => 'Mers-sur-Indre', 'lat' => '46.6589', 'lng' => '1.8808'),
      array('postal_code' => '36220', 'name' => 'N_ons-sur-Creuse', 'lat' => '46.7456', 'lng' => '0.9296'),
      array('postal_code' => '36200', 'name' => 'Celon', 'lat' => '46.5167', 'lng' => '1.5000'),
      array('postal_code' => '36210', 'name' => 'Semble�ay', 'lat' => '47.2208', 'lng' => '1.6828'),
      array('postal_code' => '36220', 'name' => 'Sauzelles', 'lat' => '46.6641', 'lng' => '1.0037'),
      array('postal_code' => '36220', 'name' => 'Lureuil', 'lat' => '46.7447', 'lng' => '1.0421'),
      array('postal_code' => '36210', 'name' => 'Varennes-sur-Fouzon', 'lat' => '47.2129', 'lng' => '1.6055'),
      array('postal_code' => '36220', 'name' => 'Martizay', 'lat' => '46.8077', 'lng' => '1.0432'),
      array('postal_code' => '36230', 'name' => 'Saint-Denis-de-Jouhet', 'lat' => '46.5309', 'lng' => '1.8687'),
      array('postal_code' => '36220', 'name' => 'Preuilly-la-Ville', 'lat' => '46.6969', 'lng' => '0.9680'),
      array('postal_code' => '36220', 'name' => 'Fontgombault', 'lat' => '46.6737', 'lng' => '0.9862'),
      array('postal_code' => '36230', 'name' => 'Gournay', 'lat' => '46.5830', 'lng' => '1.7315'),
      array('postal_code' => '36230', 'name' => 'Tranzault', 'lat' => '46.6306', 'lng' => '1.8507'),
      array('postal_code' => '36230', 'name' => 'Lys-Saint-Georges', 'lat' => '46.6416', 'lng' => '1.8242'),
      array('postal_code' => '36230', 'name' => 'Fougerolles', 'lat' => '46.5634', 'lng' => '1.8678'),
      array('postal_code' => '36250', 'name' => 'Niherne', 'lat' => '46.8277', 'lng' => '1.5638'),
      array('postal_code' => '36230', 'name' => 'Buxi�res-d�Aillac', 'lat' => '46.6385', 'lng' => '1.7533'),
      array('postal_code' => '36230', 'name' => 'Neuvy-Saint-S_pulchre', 'lat' => '46.5978', 'lng' => '1.8060'),
      array('postal_code' => '36240', 'name' => 'Jeu-Maloches', 'lat' => '47.0365', 'lng' => '1.4583'),
      array('postal_code' => '36240', 'name' => 'Pr_aux', 'lat' => '47.0204', 'lng' => '1.2915'),
      array('postal_code' => '36240', 'name' => '�cueill_', 'lat' => '47.0846', 'lng' => '1.3467'),
      array('postal_code' => '36240', 'name' => 'Geh_e', 'lat' => '47.0467', 'lng' => '1.5011'),
      array('postal_code' => '36250', 'name' => 'Saint-Maur', 'lat' => '46.8066', 'lng' => '1.6390'),
      array('postal_code' => '36250', 'name' => 'Villers-les-Ormes', 'lat' => '46.8695', 'lng' => '1.6315'),
      array('postal_code' => '36260', 'name' => 'Diou', 'lat' => '47.0455', 'lng' => '2.0260'),
      array('postal_code' => '36270', 'name' => '�guzon-Chant�me', 'lat' => '46.4500', 'lng' => '1.5833'),
      array('postal_code' => '36270', 'name' => 'Bazaiges', 'lat' => '46.4988', 'lng' => '1.5333'),
      array('postal_code' => '36310', 'name' => 'Dunet', 'lat' => '46.4681', 'lng' => '1.2916'),
      array('postal_code' => '36255 CEDEX', 'name' => 'Saint-Maur', 'lat' => '46.8066', 'lng' => '1.6390'),
      array('postal_code' => '36300', 'name' => 'Concremiers', 'lat' => '46.5967', 'lng' => '1.0167'),
      array('postal_code' => '36290', 'name' => 'Saint-Michel-en-Brenne', 'lat' => '46.8055', 'lng' => '1.1578'),
      array('postal_code' => '36260', 'name' => 'Sainte-Lizaigne', 'lat' => '47.0069', 'lng' => '2.0227'),
      array('postal_code' => '36290', 'name' => 'Saulnay', 'lat' => '46.8688', 'lng' => '1.2689'),
      array('postal_code' => '36290', 'name' => 'Azay-le-Ferron', 'lat' => '46.8510', 'lng' => '1.0708'),
      array('postal_code' => '36270', 'name' => 'Baraize', 'lat' => '46.4889', 'lng' => '1.5617'),
      array('postal_code' => '36260', 'name' => 'Reuilly', 'lat' => '47.0848', 'lng' => '2.0431'),
      array('postal_code' => '36290', 'name' => 'Villiers', 'lat' => '46.8876', 'lng' => '1.1849'),
      array('postal_code' => '36300', 'name' => 'Pouligny-Saint-Pierre', 'lat' => '46.6810', 'lng' => '1.0388'),
      array('postal_code' => '36290', 'name' => 'Obterre', 'lat' => '46.9150', 'lng' => '1.0367'),
      array('postal_code' => '36310', 'name' => 'Chaillac', 'lat' => '46.4338', 'lng' => '1.2989'),
      array('postal_code' => '36300', 'name' => 'Ciron', 'lat' => '46.6273', 'lng' => '1.2453'),
      array('postal_code' => '36320', 'name' => 'Villedieu-sur-Indre', 'lat' => '46.8460', 'lng' => '1.5397'),
      array('postal_code' => '36300', 'name' => 'Le Blanc', 'lat' => '46.6333', 'lng' => '1.0667'),
      array('postal_code' => '36301 CEDEX', 'name' => 'Le Blanc', 'lat' => '46.6333', 'lng' => '1.0667'),
      array('postal_code' => '36290', 'name' => 'Paulnay', 'lat' => '46.8505', 'lng' => '1.1478'),
      array('postal_code' => '36300', 'name' => 'Ruffec', 'lat' => '46.6296', 'lng' => '1.1703'),
      array('postal_code' => '36260', 'name' => 'Paudy', 'lat' => '47.0389', 'lng' => '1.9184'),
      array('postal_code' => '36300', 'name' => 'Ingrandes', 'lat' => '46.5971', 'lng' => '0.9621'),
      array('postal_code' => '36300', 'name' => 'Douadic', 'lat' => '46.7052', 'lng' => '1.1118'),
      array('postal_code' => '36310', 'name' => 'Tilly', 'lat' => '46.4065', 'lng' => '1.2022'),
      array('postal_code' => '36260', 'name' => 'Saint-Pierre-de-Jards', 'lat' => '47.0978', 'lng' => '1.9665'),
      array('postal_code' => '36260', 'name' => 'Migny', 'lat' => '47.0251', 'lng' => '2.0678'),
      array('postal_code' => '36290', 'name' => 'M_zi�res-en-Brenne', 'lat' => '46.8198', 'lng' => '1.2112'),
      array('postal_code' => '36300', 'name' => 'Saint-Aigny', 'lat' => '46.6450', 'lng' => '1.0269'),
      array('postal_code' => '36300', 'name' => 'Rosnay', 'lat' => '46.7010', 'lng' => '1.2148'),
      array('postal_code' => '36330', 'name' => 'Velles', 'lat' => '46.6890', 'lng' => '1.6493'),
      array('postal_code' => '36340', 'name' => 'Maillet', 'lat' => '46.5735', 'lng' => '1.6788'),
      array('postal_code' => '36310', 'name' => 'Beaulieu', 'lat' => '46.3869', 'lng' => '1.3075'),
      array('postal_code' => '36310', 'name' => 'Bonneuil', 'lat' => '46.3744', 'lng' => '1.2311'),
      array('postal_code' => '36340', 'name' => 'Malicornay', 'lat' => '46.5757', 'lng' => '1.6469'),
      array('postal_code' => '36360', 'name' => 'Faverolles', 'lat' => '47.1720', 'lng' => '1.4089'),
      array('postal_code' => '36330', 'name' => 'Le Poin�onnet', 'lat' => '46.7641', 'lng' => '1.7179'),
      array('postal_code' => '36360', 'name' => 'Lu�ay-le-M_le', 'lat' => '47.1300', 'lng' => '1.4417'),
      array('postal_code' => '36350', 'name' => 'Luant', 'lat' => '46.7330', 'lng' => '1.5579'),
      array('postal_code' => '36350', 'name' => 'La P_rouille', 'lat' => '46.7040', 'lng' => '1.5165'),
      array('postal_code' => '36370', 'name' => 'Mauvi�res', 'lat' => '46.5778', 'lng' => '1.0813'),
      array('postal_code' => '36330', 'name' => 'Arthon', 'lat' => '46.6936', 'lng' => '1.6986'),
      array('postal_code' => '36370', 'name' => 'Saint-Hilaire-sur-Benaize', 'lat' => '46.5667', 'lng' => '1.0833'),
      array('postal_code' => '36340', 'name' => 'Mouhers', 'lat' => '46.5644', 'lng' => '1.7772'),
      array('postal_code' => '36370', 'name' => 'Lignac', 'lat' => '46.4658', 'lng' => '1.2184'),
      array('postal_code' => '36400', 'name' => 'Saint-Chartier', 'lat' => '46.6490', 'lng' => '1.9773'),
      array('postal_code' => '36340', 'name' => 'Cluis', 'lat' => '46.5449', 'lng' => '1.7493'),
      array('postal_code' => '36370', 'name' => 'Prissac', 'lat' => '46.5104', 'lng' => '1.3089'),
      array('postal_code' => '36400', 'name' => 'La Berthenoux', 'lat' => '46.6613', 'lng' => '2.0619'),
      array('postal_code' => '36400', 'name' => 'Lacs', 'lat' => '46.5858', 'lng' => '2.0249'),
      array('postal_code' => '36370', 'name' => 'Chalais', 'lat' => '46.5365', 'lng' => '1.1971'),
      array('postal_code' => '36400', 'name' => 'Saint-Christophe-en-Boucherie', 'lat' => '46.6786', 'lng' => '2.1230'),
      array('postal_code' => '36370', 'name' => 'B_l_bre', 'lat' => '46.5512', 'lng' => '1.1579'),
      array('postal_code' => '36400', 'name' => 'Nohant-Vic', 'lat' => '46.6333', 'lng' => '1.9833'),
      array('postal_code' => '36500', 'name' => 'Saint-Lactencin', 'lat' => '46.8980', 'lng' => '1.4935'),
      array('postal_code' => '36400', 'name' => 'Vicq-Exemplet', 'lat' => '46.6285', 'lng' => '2.1426'),
      array('postal_code' => '36400', 'name' => 'Montgivray', 'lat' => '46.6032', 'lng' => '1.9816'),
      array('postal_code' => '36400', 'name' => 'La Ch_tre', 'lat' => '46.5833', 'lng' => '1.9833'),
      array('postal_code' => '36500', 'name' => 'Neuillay-les-Bois', 'lat' => '46.7659', 'lng' => '1.4759'),
      array('postal_code' => '36400', 'name' => 'Thevet-Saint-Julien', 'lat' => '46.6372', 'lng' => '2.0676'),
      array('postal_code' => '36500', 'name' => 'M_obecq', 'lat' => '46.7373', 'lng' => '1.4125'),
      array('postal_code' => '36400', 'name' => 'Lourouer-Saint-Laurent', 'lat' => '46.6238', 'lng' => '2.0118'),
      array('postal_code' => '36501 CEDEX', 'name' => 'Buzan�ais', 'lat' => '46.8888', 'lng' => '1.4195'),
      array('postal_code' => '36400', 'name' => 'Briantes', 'lat' => '46.5574', 'lng' => '2.0218'),
      array('postal_code' => '36600', 'name' => 'Lye', 'lat' => '47.2280', 'lng' => '1.4740'),
      array('postal_code' => '36500', 'name' => 'Palluau-sur-Indre', 'lat' => '46.9426', 'lng' => '1.3127'),
      array('postal_code' => '36400', 'name' => 'Montlevicq', 'lat' => '46.5833', 'lng' => '2.0667'),
      array('postal_code' => '36400', 'name' => 'N_ret', 'lat' => '46.5676', 'lng' => '2.1506'),
      array('postal_code' => '36500', 'name' => 'Buzan�ais', 'lat' => '46.8888', 'lng' => '1.4195'),
      array('postal_code' => '36400', 'name' => 'Le Magny', 'lat' => '46.5680', 'lng' => '1.9560'),
      array('postal_code' => '36500', 'name' => 'Chezelles', 'lat' => '46.8833', 'lng' => '1.5667'),
      array('postal_code' => '36500', 'name' => 'Sainte-Gemme', 'lat' => '46.8524', 'lng' => '1.3400'),
      array('postal_code' => '36400', 'name' => 'Verneuil-sur-Igneraie', 'lat' => '46.6553', 'lng' => '2.0107'),
      array('postal_code' => '36500', 'name' => 'Saint-Genou', 'lat' => '46.9295', 'lng' => '1.3368'),
      array('postal_code' => '36500', 'name' => 'Argy', 'lat' => '46.9408', 'lng' => '1.4382'),
      array('postal_code' => '36600', 'name' => 'Villentrois', 'lat' => '47.1944', 'lng' => '1.4629'),
      array('postal_code' => '36600', 'name' => 'Veuil', 'lat' => '47.1210', 'lng' => '1.5253'),
      array('postal_code' => '36500', 'name' => 'Villegouin', 'lat' => '46.9642', 'lng' => '1.3735'),
      array('postal_code' => '36500', 'name' => 'Soug_', 'lat' => '46.9643', 'lng' => '1.4871'),
      array('postal_code' => '36400', 'name' => 'Chassignolles', 'lat' => '46.5411', 'lng' => '1.9395'),
      array('postal_code' => '36500', 'name' => 'La Chapelle-Orthemale', 'lat' => '46.8427', 'lng' => '1.4524'),
      array('postal_code' => '36500', 'name' => 'Vend�uvres', 'lat' => '46.8000', 'lng' => '1.3500'),
      array('postal_code' => '36600', 'name' => 'La Vernelle', 'lat' => '47.2485', 'lng' => '1.5427'),
      array('postal_code' => '36700', 'name' => 'Clion', 'lat' => '46.9409', 'lng' => '1.2321'),
      array('postal_code' => '36800', 'name' => 'Le Pont-Chr_tien-Chabenet', 'lat' => '46.6167', 'lng' => '1.4667'),
      array('postal_code' => '36700', 'name' => 'Fl_r_-la-Rivi�re', 'lat' => '47.0201', 'lng' => '1.1079'),
      array('postal_code' => '36600', 'name' => 'Lang_', 'lat' => '47.0742', 'lng' => '1.5141'),
      array('postal_code' => '36600', 'name' => 'Fontguenand', 'lat' => '47.2183', 'lng' => '1.5376'),
      array('postal_code' => '36505 CEDEX', 'name' => 'Buzan�ais', 'lat' => '46.8888', 'lng' => '1.4195'),
      array('postal_code' => '36600', 'name' => 'Valen�ay', 'lat' => '47.1621', 'lng' => '1.5685'),
      array('postal_code' => '36700', 'name' => 'Arpheuilles', 'lat' => '46.9010', 'lng' => '1.2772'),
      array('postal_code' => '36700', 'name' => 'Le Tranger', 'lat' => '46.9569', 'lng' => '1.2403'),
      array('postal_code' => '36700', 'name' => 'Ch_tillon-sur-Indre', 'lat' => '46.9874', 'lng' => '1.1722'),
      array('postal_code' => '36600', 'name' => 'Vicq-sur-Nahon', 'lat' => '47.1062', 'lng' => '1.5386'),
      array('postal_code' => '36700', 'name' => 'Saint-Cyran-du-Jambot', 'lat' => '47.0174', 'lng' => '1.1382'),
      array('postal_code' => '36700', 'name' => 'Saint-M_dard', 'lat' => '47.0000', 'lng' => '1.2500'),
      array('postal_code' => '36700', 'name' => 'Murs', 'lat' => '46.9144', 'lng' => '1.1617'),
      array('postal_code' => '36700', 'name' => 'Cl_r_-du-Bois', 'lat' => '46.9231', 'lng' => '1.1022'),
      array('postal_code' => '36800', 'name' => 'Chitray', 'lat' => '46.6353', 'lng' => '1.3602'),
      array('postal_code' => '36800', 'name' => 'Rivarennes', 'lat' => '46.6359', 'lng' => '1.3865'),
      array('postal_code' => '36800', 'name' => 'Oulches', 'lat' => '46.6147', 'lng' => '1.2964'),
      array('postal_code' => '36800', 'name' => 'Mign_', 'lat' => '46.7167', 'lng' => '1.3175'),
      array('postal_code' => '36800', 'name' => 'Saint-Gaultier', 'lat' => '46.6352', 'lng' => '1.4129'),
      array('postal_code' => '37008 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37012 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37009 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '36910 CEDEX 9', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36915 CEDEX 9', 'name' => 'Ch_teauroux', 'lat' => '46.8125', 'lng' => '1.6936'),
      array('postal_code' => '36800', 'name' => 'Chasseneuil', 'lat' => '46.6468', 'lng' => '1.4966'),
      array('postal_code' => '37000', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37010 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '36800', 'name' => 'Thenay', 'lat' => '46.6306', 'lng' => '1.4275'),
      array('postal_code' => '36800', 'name' => 'Nuret-le-Ferron', 'lat' => '46.6847', 'lng' => '1.4330'),
      array('postal_code' => '36800', 'name' => 'Luzeret', 'lat' => '46.5421', 'lng' => '1.3925'),
      array('postal_code' => '37011 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37013 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37014 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37015 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37017 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37041 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37034 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37026 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37020 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37016 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37074 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37048 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37040 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37019 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37029 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37061 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37032 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37027 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37075 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37018 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37025 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37043 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37095 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37058 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37028 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37038 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37033 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37044 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37042 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37035 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37110', 'name' => 'Neuville-sur-Brenne', 'lat' => '47.6167', 'lng' => '0.9167'),
      array('postal_code' => '37039 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37110', 'name' => 'Autr�che', 'lat' => '47.5254', 'lng' => '0.9955'),
      array('postal_code' => '37130', 'name' => 'Les Essards', 'lat' => '47.3488', 'lng' => '0.3008'),
      array('postal_code' => '37120', 'name' => 'Chaveignes', 'lat' => '47.0384', 'lng' => '0.3497'),
      array('postal_code' => '37072 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37120', 'name' => 'Luz_', 'lat' => '47.0236', 'lng' => '0.4525'),
      array('postal_code' => '37047 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37110', 'name' => 'Monthodon', 'lat' => '47.6498', 'lng' => '0.8370'),
      array('postal_code' => '37071 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37089 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37120', 'name' => 'Jaulnay', 'lat' => '46.9485', 'lng' => '0.4141'),
      array('postal_code' => '37059 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37073 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37110', 'name' => 'Villed�mer', 'lat' => '47.5465', 'lng' => '0.8877'),
      array('postal_code' => '37110', 'name' => 'La Ferri�re', 'lat' => '47.6287', 'lng' => '0.7476'),
      array('postal_code' => '37045 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37049 CEDEX 1', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37110', 'name' => 'Le Boulay', 'lat' => '47.6058', 'lng' => '0.8585'),
      array('postal_code' => '37120', 'name' => 'Braslou', 'lat' => '47.0002', 'lng' => '0.3923'),
      array('postal_code' => '37079 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37120', 'name' => 'Richelieu', 'lat' => '47.0139', 'lng' => '0.3241'),
      array('postal_code' => '37060 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37110', 'name' => 'Dame-Marie-les-Bois', 'lat' => '47.5402', 'lng' => '1.0319'),
      array('postal_code' => '37076 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37120', 'name' => 'Verneuil-le-Ch_teau', 'lat' => '47.0394', 'lng' => '0.4594'),
      array('postal_code' => '37099 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37077 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37120', 'name' => 'Braye-sous-Faye', 'lat' => '46.9918', 'lng' => '0.3471'),
      array('postal_code' => '37100', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37097 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37130', 'name' => 'Mazi�res-de-Touraine', 'lat' => '47.3833', 'lng' => '0.4255'),
      array('postal_code' => '37110', 'name' => 'Les Hermites', 'lat' => '47.6647', 'lng' => '0.7536'),
      array('postal_code' => '37096 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37110', 'name' => 'Auzouer-en-Touraine', 'lat' => '47.5423', 'lng' => '0.9207'),
      array('postal_code' => '37120', 'name' => 'L_mer_', 'lat' => '47.0831', 'lng' => '0.3353'),
      array('postal_code' => '37110', 'name' => 'Saint-Nicolas-des-Motets', 'lat' => '47.5855', 'lng' => '1.0377'),
      array('postal_code' => '37120', 'name' => 'Razines', 'lat' => '46.9756', 'lng' => '0.3778'),
      array('postal_code' => '37120', 'name' => 'Assay', 'lat' => '47.0743', 'lng' => '0.2905'),
      array('postal_code' => '37110', 'name' => 'Morand', 'lat' => '47.5629', 'lng' => '1.0097'),
      array('postal_code' => '37098 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37078 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37120', 'name' => 'La Tour-Saint-Gelin', 'lat' => '47.0494', 'lng' => '0.4030'),
      array('postal_code' => '37130', 'name' => 'Cinq-Mars-la-Pile', 'lat' => '47.3464', 'lng' => '0.4587'),
      array('postal_code' => '37120', 'name' => 'Champigny-sur-Veude', 'lat' => '47.0652', 'lng' => '0.3287'),
      array('postal_code' => '37130', 'name' => 'Saint-Michel-sur-Loire', 'lat' => '47.3077', 'lng' => '0.3485'),
      array('postal_code' => '37120', 'name' => 'Faye-la-Vineuse', 'lat' => '46.9573', 'lng' => '0.3407'),
      array('postal_code' => '37120', 'name' => 'Marigny-Marmande', 'lat' => '46.9815', 'lng' => '0.4894'),
      array('postal_code' => '37120', 'name' => 'Courcou_', 'lat' => '47.0337', 'lng' => '0.3957'),
      array('postal_code' => '37081 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37080 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37082 CEDEX 2', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37110', 'name' => 'Saunay', 'lat' => '47.6033', 'lng' => '0.9707'),
      array('postal_code' => '37110', 'name' => 'Ch_teau-Renault', 'lat' => '47.5919', 'lng' => '0.9114'),
      array('postal_code' => '37130', 'name' => 'Ligni�res-de-Touraine', 'lat' => '47.2975', 'lng' => '0.4168'),
      array('postal_code' => '37130', 'name' => 'Saint-Patrice', 'lat' => '47.2844', 'lng' => '0.2941'),
      array('postal_code' => '37130', 'name' => 'Langeais', 'lat' => '47.3259', 'lng' => '0.4014'),
      array('postal_code' => '37130', 'name' => 'La Chapelle-aux-Naux', 'lat' => '47.3176', 'lng' => '0.4269'),
      array('postal_code' => '37130', 'name' => 'Br_h_mont', 'lat' => '47.2950', 'lng' => '0.3592'),
      array('postal_code' => '37140', 'name' => 'Restign_', 'lat' => '47.2822', 'lng' => '0.2279'),
      array('postal_code' => '37150', 'name' => 'Civray-de-Touraine', 'lat' => '47.3325', 'lng' => '1.0495'),
      array('postal_code' => '37140', 'name' => 'Benais', 'lat' => '47.2955', 'lng' => '0.2170'),
      array('postal_code' => '37150', 'name' => 'Bl_r_', 'lat' => '47.3274', 'lng' => '0.9919'),
      array('postal_code' => '37150', 'name' => '�peign_-les-Bois', 'lat' => '47.2807', 'lng' => '1.1115'),
      array('postal_code' => '37140', 'name' => 'La Chapelle-sur-Loire', 'lat' => '47.2506', 'lng' => '0.2189'),
      array('postal_code' => '37150', 'name' => 'Chenonceaux', 'lat' => '47.3317', 'lng' => '1.0672'),
      array('postal_code' => '37140', 'name' => 'Ingrandes-de-Touraine', 'lat' => '47.2833', 'lng' => '0.2667'),
      array('postal_code' => '37140', 'name' => 'Saint-Nicolas-de-Bourgueil', 'lat' => '47.2849', 'lng' => '0.1273'),
      array('postal_code' => '37140', 'name' => 'Bourgueil', 'lat' => '47.2833', 'lng' => '0.1661'),
      array('postal_code' => '37160', 'name' => 'Neuilly-le-Brignon', 'lat' => '46.9744', 'lng' => '0.7895'),
      array('postal_code' => '37150', 'name' => 'Luzill_', 'lat' => '47.2625', 'lng' => '1.0606'),
      array('postal_code' => '37150', 'name' => 'Francueil', 'lat' => '47.3128', 'lng' => '1.0840'),
      array('postal_code' => '37160', 'name' => 'Civray-sur-Esves', 'lat' => '47.0469', 'lng' => '0.7103'),
      array('postal_code' => '37150', 'name' => 'La Croix-en-Touraine', 'lat' => '47.3403', 'lng' => '0.9902'),
      array('postal_code' => '37150', 'name' => 'Chisseaux', 'lat' => '47.3312', 'lng' => '1.0921'),
      array('postal_code' => '37140', 'name' => 'Chouz_-sur-Loire', 'lat' => '47.2367', 'lng' => '0.1236'),
      array('postal_code' => '37152 CEDEX', 'name' => 'Bl_r_', 'lat' => '47.3274', 'lng' => '0.9919'),
      array('postal_code' => '37150', 'name' => 'Dierre', 'lat' => '47.3451', 'lng' => '0.9575'),
      array('postal_code' => '37160', 'name' => 'Abilly', 'lat' => '46.9333', 'lng' => '0.7333'),
      array('postal_code' => '37171 CEDEX', 'name' => 'Chambray-l�s-Tours', 'lat' => '47.3354', 'lng' => '0.7029'),
      array('postal_code' => '37175 CEDEX', 'name' => 'Chambray-l�s-Tours', 'lat' => '47.3354', 'lng' => '0.7029'),
      array('postal_code' => '37160', 'name' => 'Descartes', 'lat' => '46.9667', 'lng' => '0.7000'),
      array('postal_code' => '37160', 'name' => 'Marc_-sur-Esves', 'lat' => '47.0310', 'lng' => '0.6546'),
      array('postal_code' => '37179 CEDEX', 'name' => 'Chambray-l�s-Tours', 'lat' => '47.3354', 'lng' => '0.7029'),
      array('postal_code' => '37160', 'name' => 'La Celle-Saint-Avant', 'lat' => '47.0220', 'lng' => '0.6049'),
      array('postal_code' => '37173 CEDEX', 'name' => 'Chambray-l�s-Tours', 'lat' => '47.3354', 'lng' => '0.7029'),
      array('postal_code' => '37170', 'name' => 'Chambray-l�s-Tours', 'lat' => '47.3354', 'lng' => '0.7029'),
      array('postal_code' => '37172 CEDEX', 'name' => 'Chambray-l�s-Tours', 'lat' => '47.3354', 'lng' => '0.7029'),
      array('postal_code' => '37174 CEDEX', 'name' => 'Chambray-l�s-Tours', 'lat' => '47.3354', 'lng' => '0.7029'),
      array('postal_code' => '37209 CEDEX 3', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37210', 'name' => 'Chan�ay', 'lat' => '47.4540', 'lng' => '0.8745'),
      array('postal_code' => '37190', 'name' => 'Rivarennes', 'lat' => '47.2669', 'lng' => '0.3533'),
      array('postal_code' => '37190', 'name' => 'Cheill_', 'lat' => '47.2611', 'lng' => '0.4055'),
      array('postal_code' => '37190', 'name' => 'Azay-le-Rideau', 'lat' => '47.2641', 'lng' => '0.4713'),
      array('postal_code' => '37210', 'name' => 'Par�ay-Meslay', 'lat' => '47.4420', 'lng' => '0.7485'),
      array('postal_code' => '37190', 'name' => 'Vall�res', 'lat' => '47.3115', 'lng' => '0.4740'),
      array('postal_code' => '37205 CEDEX 3', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37220', 'name' => 'Panzoult', 'lat' => '47.1458', 'lng' => '0.4013'),
      array('postal_code' => '37190', 'name' => 'Neuil', 'lat' => '47.1722', 'lng' => '0.5116'),
      array('postal_code' => '37204 CEDEX 3', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37190', 'name' => 'Villaines-les-Rochers', 'lat' => '47.2216', 'lng' => '0.4961'),
      array('postal_code' => '37220', 'name' => 'Rilly-sur-Vienne', 'lat' => '47.0572', 'lng' => '0.4920'),
      array('postal_code' => '37200', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37210', 'name' => 'Vernou-sur-Brenne', 'lat' => '47.4194', 'lng' => '0.8476'),
      array('postal_code' => '37220', 'name' => 'L\'�le-Bouchard', 'lat' => '47.1167', 'lng' => '0.4167'),
      array('postal_code' => '37220', 'name' => 'Theneuil', 'lat' => '47.0980', 'lng' => '0.4383'),
      array('postal_code' => '37190', 'name' => 'Sach_', 'lat' => '47.2471', 'lng' => '0.5446'),
      array('postal_code' => '37190', 'name' => 'Druye', 'lat' => '47.3093', 'lng' => '0.5382'),
      array('postal_code' => '37220', 'name' => 'Sazilly', 'lat' => '47.1347', 'lng' => '0.3417'),
      array('postal_code' => '37210', 'name' => 'Rochecorbon', 'lat' => '47.4166', 'lng' => '0.7552'),
      array('postal_code' => '37210', 'name' => 'Noizay', 'lat' => '47.4219', 'lng' => '0.8920'),
      array('postal_code' => '37210', 'name' => 'Vouvray', 'lat' => '47.4109', 'lng' => '0.7989'),
      array('postal_code' => '37206 CEDEX 3', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37220', 'name' => 'Tavant', 'lat' => '47.1262', 'lng' => '0.3887'),
      array('postal_code' => '37220', 'name' => 'Trogues', 'lat' => '47.1149', 'lng' => '0.4980'),
      array('postal_code' => '37220', 'name' => 'Chezelles', 'lat' => '47.0500', 'lng' => '0.4333'),
      array('postal_code' => '37220', 'name' => 'Par�ay-sur-Vienne', 'lat' => '47.1057', 'lng' => '0.4766'),
      array('postal_code' => '37220', 'name' => 'Crissay-sur-Manse', 'lat' => '47.1493', 'lng' => '0.4853'),
      array('postal_code' => '37220', 'name' => 'Crouzilles', 'lat' => '47.1238', 'lng' => '0.4598'),
      array('postal_code' => '37240', 'name' => 'Cussay', 'lat' => '47.0243', 'lng' => '0.7885'),
      array('postal_code' => '37230', 'name' => 'Fondettes', 'lat' => '47.4035', 'lng' => '0.5969'),
      array('postal_code' => '37230', 'name' => 'Pernay', 'lat' => '47.4431', 'lng' => '0.5000'),
      array('postal_code' => '37220', 'name' => 'Avon-les-Roches', 'lat' => '47.1568', 'lng' => '0.4486'),
      array('postal_code' => '37240', 'name' => 'Bournan', 'lat' => '47.0620', 'lng' => '0.7288'),
      array('postal_code' => '37230', 'name' => 'Luynes', 'lat' => '47.3844', 'lng' => '0.5547'),
      array('postal_code' => '37240', 'name' => 'Ligueil', 'lat' => '47.0421', 'lng' => '0.8189'),
      array('postal_code' => '37220', 'name' => 'Brizay', 'lat' => '47.1024', 'lng' => '0.4024'),
      array('postal_code' => '37250', 'name' => 'Montbazon', 'lat' => '47.2835', 'lng' => '0.6999'),
      array('postal_code' => '37230', 'name' => 'Saint-�tienne-de-Chigny', 'lat' => '47.3833', 'lng' => '0.5333'),
      array('postal_code' => '37240', 'name' => 'Manthelan', 'lat' => '47.1363', 'lng' => '0.7932'),
      array('postal_code' => '37240', 'name' => 'Ciran', 'lat' => '47.0599', 'lng' => '0.8729'),
      array('postal_code' => '37240', 'name' => 'Vou', 'lat' => '47.0856', 'lng' => '0.8595'),
      array('postal_code' => '37240', 'name' => 'La Chapelle-Blanche-Saint-Martin', 'lat' => '47.0858', 'lng' => '0.7918'),
      array('postal_code' => '37250', 'name' => 'Veign_', 'lat' => '47.2856', 'lng' => '0.7408'),
      array('postal_code' => '37290', 'name' => 'Bossay-sur-Claise', 'lat' => '46.8318', 'lng' => '0.9616'),
      array('postal_code' => '37270', 'name' => 'Montlouis-sur-Loire', 'lat' => '47.3885', 'lng' => '0.8321'),
      array('postal_code' => '37290', 'name' => 'Charnizay', 'lat' => '46.9136', 'lng' => '0.9863'),
      array('postal_code' => '37240', 'name' => 'Le Louroux', 'lat' => '47.1611', 'lng' => '0.7863'),
      array('postal_code' => '37260', 'name' => 'Thilouze', 'lat' => '47.2242', 'lng' => '0.5796'),
      array('postal_code' => '37260', 'name' => 'Artannes-sur-Indre', 'lat' => '47.2745', 'lng' => '0.6004'),
      array('postal_code' => '37260', 'name' => 'Villeperdue', 'lat' => '47.2022', 'lng' => '0.6350'),
      array('postal_code' => '37240', 'name' => 'Esves-le-Moutier', 'lat' => '47.0417', 'lng' => '0.9071'),
      array('postal_code' => '37240', 'name' => 'Boss_e', 'lat' => '47.1121', 'lng' => '0.7294'),
      array('postal_code' => '37270', 'name' => 'Ath_e-sur-Cher', 'lat' => '47.3202', 'lng' => '0.9166'),
      array('postal_code' => '37260', 'name' => 'Monts', 'lat' => '47.2772', 'lng' => '0.6247'),
      array('postal_code' => '37270', 'name' => 'Azay-sur-Cher', 'lat' => '47.3497', 'lng' => '0.8456'),
      array('postal_code' => '37260', 'name' => 'Pont-de-Ruan', 'lat' => '47.2616', 'lng' => '0.5754'),
      array('postal_code' => '37250', 'name' => 'Sorigny', 'lat' => '47.2433', 'lng' => '0.6952'),
      array('postal_code' => '37270', 'name' => 'Saint-Martin-le-Beau', 'lat' => '47.3557', 'lng' => '0.9095'),
      array('postal_code' => '37270', 'name' => 'Lar�ay', 'lat' => '47.3665', 'lng' => '0.7814'),
      array('postal_code' => '37270', 'name' => 'V_retz', 'lat' => '47.3571', 'lng' => '0.8057'),
      array('postal_code' => '37290', 'name' => 'Tournon-Saint-Pierre', 'lat' => '46.7393', 'lng' => '0.9527'),
      array('postal_code' => '37290', 'name' => 'Preuilly-sur-Claise', 'lat' => '46.8542', 'lng' => '0.9295'),
      array('postal_code' => '37290', 'name' => 'Boussay', 'lat' => '46.8412', 'lng' => '0.8883'),
      array('postal_code' => '37290', 'name' => 'Yzeures-sur-Creuse', 'lat' => '46.7861', 'lng' => '0.8717'),
      array('postal_code' => '37310', 'name' => 'Reignac-sur-Indre', 'lat' => '47.2266', 'lng' => '0.9159'),
      array('postal_code' => '37320', 'name' => 'Truyes', 'lat' => '47.2730', 'lng' => '0.8518'),
      array('postal_code' => '37320', 'name' => 'Saint-Branchs', 'lat' => '47.2266', 'lng' => '0.7731'),
      array('postal_code' => '37309 CEDEX', 'name' => 'Jou_-l�s-Tours', 'lat' => '47.3522', 'lng' => '0.6691'),
      array('postal_code' => '37310', 'name' => 'Azay-sur-Indre', 'lat' => '47.2092', 'lng' => '0.9446'),
      array('postal_code' => '37302 CEDEX', 'name' => 'Jou_-l�s-Tours', 'lat' => '47.3522', 'lng' => '0.6691'),
      array('postal_code' => '37310', 'name' => 'Saint-Quentin-sur-Indrois', 'lat' => '47.2000', 'lng' => '1.0167'),
      array('postal_code' => '37305 CEDEX', 'name' => 'Jou_-l�s-Tours', 'lat' => '47.3522', 'lng' => '0.6691'),
      array('postal_code' => '37310', 'name' => 'Sublaines', 'lat' => '47.2649', 'lng' => '0.9911'),
      array('postal_code' => '37320', 'name' => 'Cormery', 'lat' => '47.2681', 'lng' => '0.8358'),
      array('postal_code' => '37306 CEDEX', 'name' => 'Jou_-l�s-Tours', 'lat' => '47.3522', 'lng' => '0.6691'),
      array('postal_code' => '37300', 'name' => 'Jou_-l�s-Tours', 'lat' => '47.3522', 'lng' => '0.6691'),
      array('postal_code' => '37304 CEDEX', 'name' => 'Jou_-l�s-Tours', 'lat' => '47.3522', 'lng' => '0.6691'),
      array('postal_code' => '37290', 'name' => 'Chambon', 'lat' => '46.8418', 'lng' => '0.8113'),
      array('postal_code' => '37310', 'name' => 'Dolus-le-Sec', 'lat' => '47.1650', 'lng' => '0.8941'),
      array('postal_code' => '37310', 'name' => 'Cigogn_', 'lat' => '47.2602', 'lng' => '0.9309'),
      array('postal_code' => '37310', 'name' => 'Ch_digny', 'lat' => '47.2099', 'lng' => '0.9995'),
      array('postal_code' => '37320', 'name' => 'Louans', 'lat' => '47.1845', 'lng' => '0.7479'),
      array('postal_code' => '37301 CEDEX', 'name' => 'Jou_-l�s-Tours', 'lat' => '47.3522', 'lng' => '0.6691'),
      array('postal_code' => '37310', 'name' => 'Cour�ay', 'lat' => '47.2523', 'lng' => '0.8761'),
      array('postal_code' => '37310', 'name' => 'Saint-Bauld', 'lat' => '47.1799', 'lng' => '0.8381'),
      array('postal_code' => '37303 CEDEX', 'name' => 'Jou_-l�s-Tours', 'lat' => '47.3522', 'lng' => '0.6691'),
      array('postal_code' => '37310', 'name' => 'Chambourg-sur-Indre', 'lat' => '47.1816', 'lng' => '0.9686'),
      array('postal_code' => '37321 CEDEX', 'name' => 'Esvres', 'lat' => '47.2854', 'lng' => '0.7859'),
      array('postal_code' => '37330', 'name' => 'Villiers-au-Bouin', 'lat' => '47.5746', 'lng' => '0.3132'),
      array('postal_code' => '37330', 'name' => 'Saint-Laurent-de-Lin', 'lat' => '47.5077', 'lng' => '0.2572'),
      array('postal_code' => '37310', 'name' => 'Tauxigny', 'lat' => '47.2134', 'lng' => '0.8348'),
      array('postal_code' => '37330', 'name' => 'Marcilly-sur-Maulne', 'lat' => '47.5503', 'lng' => '0.2412'),
      array('postal_code' => '37330', 'name' => 'Lubl_', 'lat' => '47.5152', 'lng' => '0.2453'),
      array('postal_code' => '37330', 'name' => 'Channay-sur-Lathan', 'lat' => '47.4791', 'lng' => '0.2642'),
      array('postal_code' => '37340', 'name' => 'Ambillou', 'lat' => '47.4510', 'lng' => '0.4473'),
      array('postal_code' => '37350', 'name' => 'La Guerche', 'lat' => '46.8838', 'lng' => '0.7309'),
      array('postal_code' => '37350', 'name' => 'Barrou', 'lat' => '46.8664', 'lng' => '0.7694'),
      array('postal_code' => '37330', 'name' => 'Ch_teau-la-Valli�re', 'lat' => '47.5467', 'lng' => '0.3246'),
      array('postal_code' => '37340', 'name' => 'Rill_', 'lat' => '47.4522', 'lng' => '0.2487'),
      array('postal_code' => '37320', 'name' => 'Esvres', 'lat' => '47.2854', 'lng' => '0.7859'),
      array('postal_code' => '37330', 'name' => 'Br�ches', 'lat' => '47.5697', 'lng' => '0.3887'),
      array('postal_code' => '37350', 'name' => 'Ferri�re-Lar�on', 'lat' => '46.9932', 'lng' => '0.8819'),
      array('postal_code' => '37360', 'name' => 'Saint-Antoine-du-Rocher', 'lat' => '47.4968', 'lng' => '0.6300'),
      array('postal_code' => '37340', 'name' => 'Savign_-sur-Lathan', 'lat' => '47.4448', 'lng' => '0.3209'),
      array('postal_code' => '37330', 'name' => 'Braye-sur-Maulne', 'lat' => '47.5553', 'lng' => '0.2493'),
      array('postal_code' => '37330', 'name' => 'Souvign_', 'lat' => '47.5218', 'lng' => '0.3972'),
      array('postal_code' => '37330', 'name' => 'Courcelles-de-Touraine', 'lat' => '47.4822', 'lng' => '0.3081'),
      array('postal_code' => '37350', 'name' => 'La Celle-Guenand', 'lat' => '46.9333', 'lng' => '0.9000'),
      array('postal_code' => '37350', 'name' => 'Paulmy', 'lat' => '46.9816', 'lng' => '0.8391'),
      array('postal_code' => '37330', 'name' => 'Couesmes', 'lat' => '47.5640', 'lng' => '0.3418'),
      array('postal_code' => '37360', 'name' => 'Rouziers-de-Touraine', 'lat' => '47.5172', 'lng' => '0.6485'),
      array('postal_code' => '37340', 'name' => 'Hommes', 'lat' => '47.4257', 'lng' => '0.2961'),
      array('postal_code' => '37370', 'name' => '�peign_-sur-D�me', 'lat' => '47.6691', 'lng' => '0.6136'),
      array('postal_code' => '37360', 'name' => 'Beaumont-la-Ronce', 'lat' => '47.5695', 'lng' => '0.6702'),
      array('postal_code' => '37340', 'name' => 'Avrill_-les-Ponceaux', 'lat' => '47.3940', 'lng' => '0.2864'),
      array('postal_code' => '37350', 'name' => 'Le Grand-Pressigny', 'lat' => '46.9202', 'lng' => '0.8038'),
      array('postal_code' => '37340', 'name' => 'Gizeux', 'lat' => '47.3935', 'lng' => '0.1945'),
      array('postal_code' => '37350', 'name' => 'Le Petit-Pressigny', 'lat' => '46.9218', 'lng' => '0.9191'),
      array('postal_code' => '37340', 'name' => 'Cl_r_-les-Pins', 'lat' => '47.4255', 'lng' => '0.3896'),
      array('postal_code' => '37340', 'name' => 'Continvoir', 'lat' => '47.3882', 'lng' => '0.2176'),
      array('postal_code' => '37370', 'name' => 'Saint-Paterne-Racan', 'lat' => '47.6021', 'lng' => '0.4848'),
      array('postal_code' => '37360', 'name' => 'Sonzay', 'lat' => '47.5269', 'lng' => '0.4620'),
      array('postal_code' => '37370', 'name' => 'Saint-Christophe-sur-le-Nais', 'lat' => '47.6172', 'lng' => '0.4780'),
      array('postal_code' => '37360', 'name' => 'Semblan�ay', 'lat' => '47.5000', 'lng' => '0.5833'),
      array('postal_code' => '37350', 'name' => 'Chaumussay', 'lat' => '46.8705', 'lng' => '0.8621'),
      array('postal_code' => '37360', 'name' => 'Neuill_-Pont-Pierre', 'lat' => '47.5484', 'lng' => '0.5496'),
      array('postal_code' => '37370', 'name' => 'Villebourg', 'lat' => '47.6500', 'lng' => '0.5297'),
      array('postal_code' => '37370', 'name' => 'Marray', 'lat' => '47.6208', 'lng' => '0.7007'),
      array('postal_code' => '37380', 'name' => 'Monnaie', 'lat' => '47.5016', 'lng' => '0.7887'),
      array('postal_code' => '37380', 'name' => 'Saint-Laurent-en-G_tines', 'lat' => '47.5866', 'lng' => '0.7779'),
      array('postal_code' => '37370', 'name' => 'Neuvy-le-Roi', 'lat' => '47.6039', 'lng' => '0.5947'),
      array('postal_code' => '37390', 'name' => 'Charentilly', 'lat' => '47.4698', 'lng' => '0.6090'),
      array('postal_code' => '37460', 'name' => 'Montr_sor', 'lat' => '47.1558', 'lng' => '1.2044'),
      array('postal_code' => '37370', 'name' => 'Saint-Aubin-le-D_peint', 'lat' => '47.6353', 'lng' => '0.3904'),
      array('postal_code' => '37380', 'name' => 'Reugny', 'lat' => '47.4821', 'lng' => '0.8847'),
      array('postal_code' => '37404 CEDEX', 'name' => 'Amboise', 'lat' => '47.4125', 'lng' => '0.9827'),
      array('postal_code' => '37370', 'name' => 'Chemill_-sur-D�me', 'lat' => '47.6584', 'lng' => '0.6481'),
      array('postal_code' => '37400', 'name' => 'Amboise', 'lat' => '47.4125', 'lng' => '0.9827'),
      array('postal_code' => '37380', 'name' => 'Nouzilly', 'lat' => '47.5450', 'lng' => '0.7462'),
      array('postal_code' => '37409 CEDEX', 'name' => 'Amboise', 'lat' => '47.4125', 'lng' => '0.9827'),
      array('postal_code' => '37370', 'name' => 'Louestault', 'lat' => '47.6172', 'lng' => '0.6505'),
      array('postal_code' => '37390', 'name' => 'Cerelles', 'lat' => '47.5017', 'lng' => '0.6833'),
      array('postal_code' => '37420', 'name' => 'Beaumont-en-V_ron', 'lat' => '47.1940', 'lng' => '0.1844'),
      array('postal_code' => '37390', 'name' => 'Chanceaux-sur-Choisille', 'lat' => '47.4714', 'lng' => '0.7054'),
      array('postal_code' => '37390', 'name' => 'La Membrolle-sur-Choisille', 'lat' => '47.4372', 'lng' => '0.6316'),
      array('postal_code' => '37390', 'name' => 'Notre-Dame-d�O_', 'lat' => '47.4563', 'lng' => '0.7079'),
      array('postal_code' => '37400', 'name' => 'Lussault-sur-Loire', 'lat' => '47.3947', 'lng' => '0.9161'),
      array('postal_code' => '37370', 'name' => 'Bueil-en-Touraine', 'lat' => '47.6451', 'lng' => '0.5507'),
      array('postal_code' => '37380', 'name' => 'Crotelles', 'lat' => '47.5431', 'lng' => '0.8384'),
      array('postal_code' => '37390', 'name' => 'Mettray', 'lat' => '47.4525', 'lng' => '0.6494'),
      array('postal_code' => '37380', 'name' => 'Neuill_-le-Lierre', 'lat' => '47.5119', 'lng' => '0.9105'),
      array('postal_code' => '37460', 'name' => 'Beaumont-Village', 'lat' => '47.1777', 'lng' => '1.2070'),
      array('postal_code' => '37460', 'name' => 'Villed�main', 'lat' => '47.0544', 'lng' => '1.2579'),
      array('postal_code' => '37420', 'name' => 'Avoine', 'lat' => '47.2053', 'lng' => '0.1825'),
      array('postal_code' => '37401 CEDEX', 'name' => 'Amboise', 'lat' => '47.4125', 'lng' => '0.9827'),
      array('postal_code' => '37460', 'name' => 'Villeloin-Coulang_', 'lat' => '47.1407', 'lng' => '1.2234'),
      array('postal_code' => '37402 CEDEX', 'name' => 'Amboise', 'lat' => '47.4125', 'lng' => '0.9827'),
      array('postal_code' => '37420', 'name' => 'Savigny-en-V_ron', 'lat' => '47.2007', 'lng' => '0.1446'),
      array('postal_code' => '37390', 'name' => 'Saint-Roch', 'lat' => '47.4421', 'lng' => '0.5849'),
      array('postal_code' => '37420', 'name' => 'Huismes', 'lat' => '47.2332', 'lng' => '0.2512'),
      array('postal_code' => '37403 CEDEX', 'name' => 'Amboise', 'lat' => '47.4125', 'lng' => '0.9827'),
      array('postal_code' => '37420', 'name' => 'Rigny-Uss_', 'lat' => '47.2523', 'lng' => '0.2997'),
      array('postal_code' => '37460', 'name' => 'Nouans-les-Fontaines', 'lat' => '47.1364', 'lng' => '1.2985'),
      array('postal_code' => '37460', 'name' => 'Chemill_-sur-Indrois', 'lat' => '47.1619', 'lng' => '1.1674'),
      array('postal_code' => '37460', 'name' => 'Le Li�ge', 'lat' => '47.2294', 'lng' => '1.1044'),
      array('postal_code' => '37460', 'name' => 'Genill_', 'lat' => '47.1833', 'lng' => '1.1000'),
      array('postal_code' => '37460', 'name' => 'Loch_-sur-Indrois', 'lat' => '47.0921', 'lng' => '1.2202'),
      array('postal_code' => '37500', 'name' => 'Ligr_', 'lat' => '47.1119', 'lng' => '0.2756'),
      array('postal_code' => '37500', 'name' => 'Seuilly', 'lat' => '47.1339', 'lng' => '0.1717'),
      array('postal_code' => '37500', 'name' => 'Saint-Beno�t-la-For�t', 'lat' => '47.2230', 'lng' => '0.3227'),
      array('postal_code' => '37460', 'name' => 'Orbigny', 'lat' => '47.2097', 'lng' => '1.2349'),
      array('postal_code' => '37500', 'name' => 'Thizay', 'lat' => '47.1675', 'lng' => '0.1432'),
      array('postal_code' => '37500', 'name' => 'Saint-Germain-sur-Vienne', 'lat' => '47.1944', 'lng' => '0.0981'),
      array('postal_code' => '37500', 'name' => 'Mar�ay', 'lat' => '47.0999', 'lng' => '0.2182'),
      array('postal_code' => '37500', 'name' => 'Anch_', 'lat' => '47.1357', 'lng' => '0.3101'),
      array('postal_code' => '37500', 'name' => 'Cinais', 'lat' => '47.1480', 'lng' => '0.1819'),
      array('postal_code' => '37500', 'name' => 'Candes-Saint-Martin', 'lat' => '47.2112', 'lng' => '0.0738'),
      array('postal_code' => '37500', 'name' => 'Cravant-les-Coteaux', 'lat' => '47.1582', 'lng' => '0.3464'),
      array('postal_code' => '37509 CEDEX', 'name' => 'Chinon', 'lat' => '47.1667', 'lng' => '0.2500'),
      array('postal_code' => '37460', 'name' => 'C_r_-la-Ronde', 'lat' => '47.2612', 'lng' => '1.1900'),
      array('postal_code' => '37500', 'name' => 'Rivi�re', 'lat' => '47.1455', 'lng' => '0.2783'),
      array('postal_code' => '37501 CEDEX', 'name' => 'Chinon', 'lat' => '47.1667', 'lng' => '0.2500'),
      array('postal_code' => '37500', 'name' => 'La Roche-Clermault', 'lat' => '47.1375', 'lng' => '0.2060'),
      array('postal_code' => '37500', 'name' => 'Lern_', 'lat' => '47.1358', 'lng' => '0.1225'),
      array('postal_code' => '37510', 'name' => 'Villandry', 'lat' => '47.3402', 'lng' => '0.5105'),
      array('postal_code' => '37530', 'name' => 'Cangey', 'lat' => '47.4672', 'lng' => '1.0605'),
      array('postal_code' => '37530', 'name' => 'Poc_-sur-Cisse', 'lat' => '47.4433', 'lng' => '0.9914'),
      array('postal_code' => '37530', 'name' => 'Limeray', 'lat' => '47.4594', 'lng' => '1.0404'),
      array('postal_code' => '37520', 'name' => 'La Riche', 'lat' => '47.3900', 'lng' => '0.6707'),
      array('postal_code' => '37510', 'name' => 'Saint-Genouph', 'lat' => '47.3776', 'lng' => '0.5985'),
      array('postal_code' => '37530', 'name' => 'Souvigny-de-Touraine', 'lat' => '47.4111', 'lng' => '1.0899'),
      array('postal_code' => '37530', 'name' => 'Nazelles-N_gron', 'lat' => '47.4333', 'lng' => '0.9500'),
      array('postal_code' => '37510', 'name' => 'Berthenay', 'lat' => '47.3634', 'lng' => '0.5255'),
      array('postal_code' => '37530', 'name' => 'Saint-Ouen-les-Vignes', 'lat' => '47.4675', 'lng' => '0.9948'),
      array('postal_code' => '37502 CEDEX', 'name' => 'Chinon', 'lat' => '47.1667', 'lng' => '0.2500'),
      array('postal_code' => '37510', 'name' => 'Savonni�res', 'lat' => '47.3477', 'lng' => '0.5496'),
      array('postal_code' => '37530', 'name' => 'Montreuil-en-Touraine', 'lat' => '47.4881', 'lng' => '0.9488'),
      array('postal_code' => '37500', 'name' => 'Couziers', 'lat' => '47.1575', 'lng' => '0.0826'),
      array('postal_code' => '37530', 'name' => 'Saint-R�gle', 'lat' => '47.4083', 'lng' => '1.0527'),
      array('postal_code' => '37510', 'name' => 'Ballan-Mir_', 'lat' => '47.3406', 'lng' => '0.6147'),
      array('postal_code' => '37500', 'name' => 'Chinon', 'lat' => '47.1667', 'lng' => '0.2500'),
      array('postal_code' => '37542 CEDEX', 'name' => 'Saint-Cyr-sur-Loire', 'lat' => '47.4000', 'lng' => '0.6667'),
      array('postal_code' => '37600', 'name' => 'Ferri�re-sur-Beaulieu', 'lat' => '47.1375', 'lng' => '1.0377'),
      array('postal_code' => '37521 CEDEX', 'name' => 'La Riche', 'lat' => '47.3900', 'lng' => '0.6707'),
      array('postal_code' => '37549 CEDEX', 'name' => 'Saint-Cyr-sur-Loire', 'lat' => '47.4000', 'lng' => '0.6667'),
      array('postal_code' => '37553 CEDEX', 'name' => 'Saint-Avertin', 'lat' => '47.3636', 'lng' => '0.7399'),
      array('postal_code' => '37540', 'name' => 'Saint-Cyr-sur-Loire', 'lat' => '47.4000', 'lng' => '0.6667'),
      array('postal_code' => '37554 CEDEX', 'name' => 'Saint-Avertin', 'lat' => '47.3636', 'lng' => '0.7399'),
      array('postal_code' => '37541 CEDEX', 'name' => 'Saint-Cyr-sur-Loire', 'lat' => '47.4000', 'lng' => '0.6667'),
      array('postal_code' => '37552 CEDEX', 'name' => 'Saint-Avertin', 'lat' => '47.3636', 'lng' => '0.7399'),
      array('postal_code' => '37530', 'name' => 'Charg_', 'lat' => '47.4327', 'lng' => '1.0304'),
      array('postal_code' => '37551 CEDEX', 'name' => 'Saint-Avertin', 'lat' => '47.3636', 'lng' => '0.7399'),
      array('postal_code' => '37600', 'name' => 'Varennes', 'lat' => '47.0700', 'lng' => '0.9158'),
      array('postal_code' => '37600', 'name' => 'Mouzay', 'lat' => '47.0895', 'lng' => '0.8921'),
      array('postal_code' => '37600', 'name' => 'Sennevi�res', 'lat' => '47.1062', 'lng' => '1.1022'),
      array('postal_code' => '37600', 'name' => 'Betz-le-Ch_teau', 'lat' => '46.9917', 'lng' => '0.9194'),
      array('postal_code' => '37556 CEDEX', 'name' => 'Saint-Avertin', 'lat' => '47.3636', 'lng' => '0.7399'),
      array('postal_code' => '37600', 'name' => 'Saint-Senoch', 'lat' => '47.0467', 'lng' => '0.9686'),
      array('postal_code' => '37600', 'name' => 'Saint-Flovier', 'lat' => '46.9685', 'lng' => '1.0271'),
      array('postal_code' => '37600', 'name' => 'Bridor_', 'lat' => '47.0280', 'lng' => '1.0830'),
      array('postal_code' => '37600', 'name' => 'Beaulieu-l�s-Loches', 'lat' => '47.1253', 'lng' => '1.0159'),
      array('postal_code' => '37600', 'name' => 'Perrusson', 'lat' => '47.0987', 'lng' => '1.0144'),
      array('postal_code' => '37702 CEDEX', 'name' => 'Saint-Pierre-des-Corps', 'lat' => '47.3862', 'lng' => '0.7485'),
      array('postal_code' => '37530', 'name' => 'Mosnes', 'lat' => '47.4559', 'lng' => '1.0997'),
      array('postal_code' => '37555 CEDEX', 'name' => 'Saint-Avertin', 'lat' => '47.3636', 'lng' => '0.7399'),
      array('postal_code' => '37600', 'name' => 'Chanceaux-pr�s-Loches', 'lat' => '47.1500', 'lng' => '0.9333'),
      array('postal_code' => '37600', 'name' => 'Loches', 'lat' => '47.1333', 'lng' => '1.0000'),
      array('postal_code' => '37600', 'name' => 'Saint-Jean-Saint-Germain', 'lat' => '47.0831', 'lng' => '1.0353'),
      array('postal_code' => '37600', 'name' => 'Verneuil-sur-Indre', 'lat' => '47.0555', 'lng' => '1.0403'),
      array('postal_code' => '37550', 'name' => 'Saint-Avertin', 'lat' => '47.3636', 'lng' => '0.7399'),
      array('postal_code' => '37701 CEDEX', 'name' => 'Saint-Pierre-des-Corps', 'lat' => '47.3862', 'lng' => '0.7485'),
      array('postal_code' => '37609 CEDEX', 'name' => 'Loches', 'lat' => '47.1333', 'lng' => '1.0000'),
      array('postal_code' => '37600', 'name' => 'Saint-Hippolyte', 'lat' => '47.0590', 'lng' => '1.1001'),
      array('postal_code' => '37602 CEDEX', 'name' => 'Loches', 'lat' => '47.1333', 'lng' => '1.0000'),
      array('postal_code' => '37703 CEDEX', 'name' => 'Saint-Pierre-des-Corps', 'lat' => '47.3862', 'lng' => '0.7485'),
      array('postal_code' => '37800', 'name' => 'Noyant-de-Touraine', 'lat' => '47.1100', 'lng' => '0.5595'),
      array('postal_code' => '37601 CEDEX', 'name' => 'Loches', 'lat' => '47.1333', 'lng' => '1.0000'),
      array('postal_code' => '37800', 'name' => 'Saint-�pain', 'lat' => '47.1448', 'lng' => '0.5367'),
      array('postal_code' => '37700', 'name' => 'Saint-Pierre-des-Corps', 'lat' => '47.3862', 'lng' => '0.7485'),
      array('postal_code' => '37700', 'name' => 'La Ville-aux-Dames', 'lat' => '47.3955', 'lng' => '0.7684'),
      array('postal_code' => '37800', 'name' => 'Sepmes', 'lat' => '47.0680', 'lng' => '0.6732'),
      array('postal_code' => '37800', 'name' => 'Marcilly-sur-Vienne', 'lat' => '47.0432', 'lng' => '0.5399'),
      array('postal_code' => '37800', 'name' => 'Drach_', 'lat' => '47.0549', 'lng' => '0.6257'),
      array('postal_code' => '37800', 'name' => 'Maill_', 'lat' => '47.0538', 'lng' => '0.5822'),
      array('postal_code' => '37800', 'name' => 'Ports', 'lat' => '47.0158', 'lng' => '0.5540'),
      array('postal_code' => '37800', 'name' => 'Sainte-Maure-de-Touraine', 'lat' => '47.1113', 'lng' => '0.6224'),
      array('postal_code' => '37800', 'name' => 'Sainte-Catherine-de-Fierbois', 'lat' => '47.1565', 'lng' => '0.6556'),
      array('postal_code' => '37913 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37800', 'name' => 'Pouzay', 'lat' => '47.0824', 'lng' => '0.5329'),
      array('postal_code' => '37912 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37800', 'name' => 'Pussigny', 'lat' => '46.9929', 'lng' => '0.5703'),
      array('postal_code' => '37800', 'name' => 'Nou_tre', 'lat' => '47.0505', 'lng' => '0.5489'),
      array('postal_code' => '37709 CEDEX', 'name' => 'Saint-Pierre-des-Corps', 'lat' => '47.3862', 'lng' => '0.7485'),
      array('postal_code' => '37800', 'name' => 'Antogny le Tillac', 'lat' => '46.9781', 'lng' => '0.5785'),
      array('postal_code' => '37705 CEDEX', 'name' => 'Saint-Pierre-des-Corps', 'lat' => '47.3862', 'lng' => '0.7485'),
      array('postal_code' => '37925 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37911 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37917 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37915 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37924 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37922 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37921 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37910 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37927 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37928 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '41000', 'name' => 'Saint-Sulpice-de-Pommeray', 'lat' => '47.6000', 'lng' => '1.2667'),
      array('postal_code' => '37931 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37926 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37941 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37942 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37929 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '37932 CEDEX 9', 'name' => 'Tours', 'lat' => '47.3948', 'lng' => '0.7040'),
      array('postal_code' => '41000', 'name' => 'Villerbon', 'lat' => '47.6626', 'lng' => '1.3723'),
      array('postal_code' => '41009 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41004 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41002 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41019 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41020 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41000', 'name' => 'Villebarou', 'lat' => '47.6234', 'lng' => '1.3225'),
      array('postal_code' => '41006 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41001 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41010 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41029 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41007 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41015 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41000', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41016 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41003 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41000', 'name' => 'Saint-Denis-sur-Loire', 'lat' => '47.6248', 'lng' => '1.3876'),
      array('postal_code' => '41011 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41008 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41022 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41023 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41005 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41018 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41026 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41013 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41012 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41028 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41100', 'name' => 'Villiers-sur-Loir', 'lat' => '47.8051', 'lng' => '0.9977'),
      array('postal_code' => '41100', 'name' => 'Coulommiers-la-Tour', 'lat' => '47.7840', 'lng' => '1.1433'),
      array('postal_code' => '41035 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41100', 'name' => 'Saint-Firmin-des-Pr_s', 'lat' => '47.8413', 'lng' => '1.1144'),
      array('postal_code' => '41100', 'name' => 'Renay', 'lat' => '47.8416', 'lng' => '1.1659'),
      array('postal_code' => '41100', 'name' => 'Naveil', 'lat' => '47.7958', 'lng' => '1.0322'),
      array('postal_code' => '41033 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41100', 'name' => 'Villeromain', 'lat' => '47.7294', 'lng' => '1.1436'),
      array('postal_code' => '41100', 'name' => 'Sainte-Anne', 'lat' => '47.7577', 'lng' => '1.0819'),
      array('postal_code' => '41025 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41043 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41034 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41042 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41100', 'name' => 'Faye', 'lat' => '47.8009', 'lng' => '1.1808'),
      array('postal_code' => '41100', 'name' => 'Thor_-la-Rochette', 'lat' => '47.7874', 'lng' => '0.9636'),
      array('postal_code' => '41100', 'name' => 'Villetrun', 'lat' => '47.7868', 'lng' => '1.1597'),
      array('postal_code' => '41100', 'name' => 'P_rigny', 'lat' => '47.7409', 'lng' => '1.1501'),
      array('postal_code' => '41100', 'name' => 'Saint-Ouen', 'lat' => '47.8140', 'lng' => '1.0807'),
      array('postal_code' => '41100', 'name' => 'Selommes', 'lat' => '47.7559', 'lng' => '1.1940'),
      array('postal_code' => '41100', 'name' => 'Az_', 'lat' => '47.8514', 'lng' => '0.9983'),
      array('postal_code' => '41100', 'name' => 'Mazang_', 'lat' => '47.8240', 'lng' => '0.9459'),
      array('postal_code' => '41100', 'name' => 'Villerable', 'lat' => '47.7577', 'lng' => '1.0313'),
      array('postal_code' => '41100', 'name' => 'Marcilly-en-Beauce', 'lat' => '47.7633', 'lng' => '1.0026'),
      array('postal_code' => '41100', 'name' => 'Crucheray', 'lat' => '47.7280', 'lng' => '1.0882'),
      array('postal_code' => '41100', 'name' => 'Roc_', 'lat' => '47.8071', 'lng' => '1.1494'),
      array('postal_code' => '41100', 'name' => 'Villemardy', 'lat' => '47.7352', 'lng' => '1.1897'),
      array('postal_code' => '41100', 'name' => 'Areines', 'lat' => '47.8028', 'lng' => '1.0952'),
      array('postal_code' => '41100', 'name' => 'Villiersfaux', 'lat' => '47.7500', 'lng' => '0.9877'),
      array('postal_code' => '41100', 'name' => 'Meslay', 'lat' => '47.8109', 'lng' => '1.0971'),
      array('postal_code' => '41102 CEDEX', 'name' => 'Vend�me', 'lat' => '47.8000', 'lng' => '1.0667'),
      array('postal_code' => '41120', 'name' => 'Les Montils', 'lat' => '47.4950', 'lng' => '1.2977'),
      array('postal_code' => '41110', 'name' => 'Seigy', 'lat' => '47.2569', 'lng' => '1.3996'),
      array('postal_code' => '41100', 'name' => 'Lisle', 'lat' => '47.8523', 'lng' => '1.1174'),
      array('postal_code' => '41100', 'name' => 'Pezou', 'lat' => '47.8674', 'lng' => '1.1428'),
      array('postal_code' => '41110', 'name' => 'Ch_teauvieux', 'lat' => '47.2310', 'lng' => '1.3828'),
      array('postal_code' => '41120', 'name' => 'Seur', 'lat' => '47.5027', 'lng' => '1.3338'),
      array('postal_code' => '41100', 'name' => 'Vend�me', 'lat' => '47.8000', 'lng' => '1.0667'),
      array('postal_code' => '41120', 'name' => 'Ouchamps', 'lat' => '47.4728', 'lng' => '1.3083'),
      array('postal_code' => '41110', 'name' => 'Mareuil-sur-Cher', 'lat' => '47.2931', 'lng' => '1.3290'),
      array('postal_code' => '41110', 'name' => 'Pouill_', 'lat' => '47.3174', 'lng' => '1.2901'),
      array('postal_code' => '41110', 'name' => 'Saint-Aignan', 'lat' => '47.2689', 'lng' => '1.3761'),
      array('postal_code' => '41120', 'name' => 'Foug�res-sur-Bi�vre', 'lat' => '47.4487', 'lng' => '1.3424'),
      array('postal_code' => '41106 CEDEX', 'name' => 'Vend�me', 'lat' => '47.8000', 'lng' => '1.0667'),
      array('postal_code' => '41103 CEDEX', 'name' => 'Vend�me', 'lat' => '47.8000', 'lng' => '1.0667'),
      array('postal_code' => '41120', 'name' => 'Chitenay', 'lat' => '47.4975', 'lng' => '1.3714'),
      array('postal_code' => '41105 CEDEX', 'name' => 'Vend�me', 'lat' => '47.8000', 'lng' => '1.0667'),
      array('postal_code' => '41109 CEDEX', 'name' => 'Vend�me', 'lat' => '47.8000', 'lng' => '1.0667'),
      array('postal_code' => '41101 CEDEX', 'name' => 'Vend�me', 'lat' => '47.8000', 'lng' => '1.0667'),
      array('postal_code' => '41120', 'name' => 'Cellettes', 'lat' => '47.5276', 'lng' => '1.3810'),
      array('postal_code' => '41120', 'name' => 'Sambin', 'lat' => '47.4386', 'lng' => '1.2968'),
      array('postal_code' => '41122 CEDEX', 'name' => 'Cand_-sur-Beuvron', 'lat' => '47.4950', 'lng' => '1.2594'),
      array('postal_code' => '41130', 'name' => 'Ch_tillon-sur-Cher', 'lat' => '47.2757', 'lng' => '1.4942'),
      array('postal_code' => '41110', 'name' => 'Couffy', 'lat' => '47.2477', 'lng' => '1.4392'),
      array('postal_code' => '41120', 'name' => 'Cormeray', 'lat' => '47.4920', 'lng' => '1.4061'),
      array('postal_code' => '41120', 'name' => 'Monthou-sur-Bi�vre', 'lat' => '47.4767', 'lng' => '1.2951'),
      array('postal_code' => '41120', 'name' => 'Feings', 'lat' => '47.4379', 'lng' => '1.3536'),
      array('postal_code' => '41130', 'name' => 'Gi�vres', 'lat' => '47.2785', 'lng' => '1.6694'),
      array('postal_code' => '41130', 'name' => 'Meusnes', 'lat' => '47.2490', 'lng' => '1.4969'),
      array('postal_code' => '41120', 'name' => 'Cand_-sur-Beuvron', 'lat' => '47.4950', 'lng' => '1.2594'),
      array('postal_code' => '41130', 'name' => 'Billy', 'lat' => '47.3124', 'lng' => '1.5393'),
      array('postal_code' => '41120', 'name' => 'Chailles', 'lat' => '47.5416', 'lng' => '1.3122'),
      array('postal_code' => '41130', 'name' => 'Selles-sur-Cher', 'lat' => '47.2790', 'lng' => '1.5539'),
      array('postal_code' => '41120', 'name' => 'Valaire', 'lat' => '47.4702', 'lng' => '1.2685'),
      array('postal_code' => '41121 CEDEX', 'name' => 'Cand_-sur-Beuvron', 'lat' => '47.4950', 'lng' => '1.2594'),
      array('postal_code' => '41140', 'name' => 'Saint-Romain-sur-Cher', 'lat' => '47.3188', 'lng' => '1.3996'),
      array('postal_code' => '41150', 'name' => 'Chaumont-sur-Loire', 'lat' => '47.4811', 'lng' => '1.1893'),
      array('postal_code' => '41140', 'name' => 'Noyers-sur-Cher', 'lat' => '47.2770', 'lng' => '1.4032'),
      array('postal_code' => '41150', 'name' => 'Onzain', 'lat' => '47.4996', 'lng' => '1.1770'),
      array('postal_code' => '41150', 'name' => 'Rilly-sur-Loire', 'lat' => '47.4666', 'lng' => '1.1347'),
      array('postal_code' => '41140', 'name' => 'Th_s_e', 'lat' => '47.3235', 'lng' => '1.3088'),
      array('postal_code' => '41140', 'name' => 'M_hers', 'lat' => '47.3288', 'lng' => '1.4576'),
      array('postal_code' => '41150', 'name' => 'Seillac', 'lat' => '47.5459', 'lng' => '1.1568'),
      array('postal_code' => '41150', 'name' => 'Chouzy-sur-Cisse', 'lat' => '47.5258', 'lng' => '1.2466'),
      array('postal_code' => '41150', 'name' => 'Mesland', 'lat' => '47.5097', 'lng' => '1.1226'),
      array('postal_code' => '41150', 'name' => 'Coulanges', 'lat' => '47.5428', 'lng' => '1.2237'),
      array('postal_code' => '41150', 'name' => 'Veuves', 'lat' => '47.4720', 'lng' => '1.1247'),
      array('postal_code' => '41160', 'name' => 'Beauce la Romaine', 'lat' => '47.9111', 'lng' => '1.5275'),
      array('postal_code' => '41160', 'name' => 'Fr_teval', 'lat' => '47.8901', 'lng' => '1.2082'),
      array('postal_code' => '41160', 'name' => 'Saint-Hilaire-la-Gravelle', 'lat' => '47.9209', 'lng' => '1.1991'),
      array('postal_code' => '41151 CEDEX', 'name' => 'Cand_-sur-Beuvron', 'lat' => '47.4950', 'lng' => '1.2594'),
      array('postal_code' => '41160', 'name' => 'Mor_e', 'lat' => '47.9040', 'lng' => '1.2342'),
      array('postal_code' => '41160', 'name' => 'Br_vainville', 'lat' => '47.9532', 'lng' => '1.2830'),
      array('postal_code' => '41160', 'name' => 'La Ville-aux-Clercs', 'lat' => '47.9184', 'lng' => '1.0852'),
      array('postal_code' => '41150', 'name' => 'Monteaux', 'lat' => '47.4876', 'lng' => '1.1131'),
      array('postal_code' => '41160', 'name' => 'Danz_', 'lat' => '47.8945', 'lng' => '1.0257'),
      array('postal_code' => '41160', 'name' => 'Moisy', 'lat' => '47.9153', 'lng' => '1.3160'),
      array('postal_code' => '41160', 'name' => 'Rahart', 'lat' => '47.8712', 'lng' => '1.0681'),
      array('postal_code' => '41160', 'name' => 'Busloup', 'lat' => '47.8944', 'lng' => '1.1323'),
      array('postal_code' => '41160', 'name' => 'Saint-Jean-Froidmentel', 'lat' => '47.9576', 'lng' => '1.2396'),
      array('postal_code' => '41160', 'name' => 'Ouzouer-le-Doyen', 'lat' => '47.9412', 'lng' => '1.3412'),
      array('postal_code' => '41170', 'name' => 'Souday', 'lat' => '48.0368', 'lng' => '0.8669'),
      array('postal_code' => '41170', 'name' => 'Baillou', 'lat' => '47.9669', 'lng' => '0.8421'),
      array('postal_code' => '41190', 'name' => 'Tourailles', 'lat' => '47.6852', 'lng' => '1.1584'),
      array('postal_code' => '41170', 'name' => 'Mondoubleau', 'lat' => '47.9806', 'lng' => '0.8978'),
      array('postal_code' => '41190', 'name' => 'Saint-Cyr-du-Gault', 'lat' => '47.6211', 'lng' => '1.0299'),
      array('postal_code' => '41160', 'name' => 'La Colombe', 'lat' => '47.8892', 'lng' => '1.3712'),
      array('postal_code' => '41190', 'name' => 'Chambon-sur-Cisse', 'lat' => '47.5624', 'lng' => '1.2154'),
      array('postal_code' => '41170', 'name' => 'Saint-Marc-du-Cor', 'lat' => '47.9732', 'lng' => '0.9535'),
      array('postal_code' => '41170', 'name' => 'Le Temple', 'lat' => '47.9317', 'lng' => '0.9353'),
      array('postal_code' => '41200', 'name' => 'Villeherviers', 'lat' => '47.3667', 'lng' => '1.8000'),
      array('postal_code' => '41170', 'name' => 'Saint-Agil', 'lat' => '48.0342', 'lng' => '0.9261'),
      array('postal_code' => '41170', 'name' => 'Le Plessis-Dorin', 'lat' => '48.0893', 'lng' => '0.8651'),
      array('postal_code' => '41170', 'name' => 'Cormenon', 'lat' => '47.9687', 'lng' => '0.8925'),
      array('postal_code' => '41200', 'name' => 'Villefranche-sur-Cher', 'lat' => '47.3000', 'lng' => '1.7667'),
      array('postal_code' => '41170', 'name' => 'Saint-Avit', 'lat' => '48.0908', 'lng' => '0.9162'),
      array('postal_code' => '41160', 'name' => 'Ligni�res', 'lat' => '47.8663', 'lng' => '1.1839'),
      array('postal_code' => '41170', 'name' => 'Oigny', 'lat' => '48.0640', 'lng' => '0.9215'),
      array('postal_code' => '41190', 'name' => 'Herbault', 'lat' => '47.6050', 'lng' => '1.1393'),
      array('postal_code' => '41160', 'name' => 'Semerville', 'lat' => '47.9333', 'lng' => '1.4000'),
      array('postal_code' => '41170', 'name' => 'Arville', 'lat' => '48.0630', 'lng' => '0.9481'),
      array('postal_code' => '41190', 'name' => 'Molineuf', 'lat' => '47.5769', 'lng' => '1.2183'),
      array('postal_code' => '41190', 'name' => 'Landes-le-Gaulois', 'lat' => '47.6542', 'lng' => '1.1844'),
      array('postal_code' => '41170', 'name' => 'Choue', 'lat' => '48.0000', 'lng' => '0.9333'),
      array('postal_code' => '41200', 'name' => 'Pruniers-en-Sologne', 'lat' => '47.3167', 'lng' => '1.6667'),
      array('postal_code' => '41190', 'name' => 'Saint-�tienne-des-Gu_rets', 'lat' => '47.5990', 'lng' => '1.0632'),
      array('postal_code' => '41170', 'name' => 'Sarg_-sur-Braye', 'lat' => '47.9235', 'lng' => '0.8534'),
      array('postal_code' => '41170', 'name' => 'Beauch�ne', 'lat' => '47.9393', 'lng' => '0.9699'),
      array('postal_code' => '41190', 'name' => 'Santenay', 'lat' => '47.5667', 'lng' => '1.1167'),
      array('postal_code' => '41190', 'name' => 'Saint-Lubin-en-Vergonnois', 'lat' => '47.6135', 'lng' => '1.2339'),
      array('postal_code' => '41190', 'name' => 'Orchaise', 'lat' => '47.5909', 'lng' => '1.1986'),
      array('postal_code' => '41190', 'name' => 'Lanc�me', 'lat' => '47.6489', 'lng' => '1.1228'),
      array('postal_code' => '41190', 'name' => 'Fran�ay', 'lat' => '47.6176', 'lng' => '1.1269'),
      array('postal_code' => '41190', 'name' => 'Valencisse', 'lat' => '47.5786', 'lng' => '1.2156'),
      array('postal_code' => '41200', 'name' => 'Romorantin-Lanthenay', 'lat' => '47.3667', 'lng' => '1.7500'),
      array('postal_code' => '41190', 'name' => 'Pray', 'lat' => '47.6761', 'lng' => '1.1169'),
      array('postal_code' => '41204 CEDEX', 'name' => 'Romorantin-Lanthenay', 'lat' => '47.3667', 'lng' => '1.7500'),
      array('postal_code' => '41220', 'name' => 'Crouy-sur-Cosson', 'lat' => '47.6507', 'lng' => '1.6101'),
      array('postal_code' => '41200', 'name' => 'Millan�ay', 'lat' => '47.4470', 'lng' => '1.7721'),
      array('postal_code' => '41210', 'name' => 'Saint-Vi_tre', 'lat' => '47.5244', 'lng' => '1.9328'),
      array('postal_code' => '41206 CEDEX', 'name' => 'Romorantin-Lanthenay', 'lat' => '47.3667', 'lng' => '1.7500'),
      array('postal_code' => '41201 CEDEX', 'name' => 'Romorantin-Lanthenay', 'lat' => '47.3667', 'lng' => '1.7500'),
      array('postal_code' => '41202 CEDEX', 'name' => 'Romorantin-Lanthenay', 'lat' => '47.3667', 'lng' => '1.7500'),
      array('postal_code' => '41200', 'name' => 'Loreux', 'lat' => '47.3989', 'lng' => '1.8316'),
      array('postal_code' => '41207 CEDEX', 'name' => 'Romorantin-Lanthenay', 'lat' => '47.3667', 'lng' => '1.7500'),
      array('postal_code' => '41205 CEDEX', 'name' => 'Romorantin-Lanthenay', 'lat' => '47.3667', 'lng' => '1.7500'),
      array('postal_code' => '41210', 'name' => 'La Fert_-Beauharnais', 'lat' => '47.5420', 'lng' => '1.8504'),
      array('postal_code' => '41203 CEDEX', 'name' => 'Romorantin-Lanthenay', 'lat' => '47.3667', 'lng' => '1.7500'),
      array('postal_code' => '41210', 'name' => 'Neung-sur-Beuvron', 'lat' => '47.5349', 'lng' => '1.8051'),
      array('postal_code' => '41220', 'name' => 'La Fert_-Saint-Cyr', 'lat' => '47.6560', 'lng' => '1.6732'),
      array('postal_code' => '41220', 'name' => 'Thoury', 'lat' => '47.6295', 'lng' => '1.5966'),
      array('postal_code' => '41230', 'name' => 'Rougeou', 'lat' => '47.3630', 'lng' => '1.5363'),
      array('postal_code' => '41210', 'name' => 'Marcilly-en-Gault', 'lat' => '47.4659', 'lng' => '1.8744'),
      array('postal_code' => '41220', 'name' => 'Dhuizon', 'lat' => '47.5872', 'lng' => '1.6581'),
      array('postal_code' => '41220', 'name' => 'Villeny', 'lat' => '47.6230', 'lng' => '1.7555'),
      array('postal_code' => '41230', 'name' => 'Veilleins', 'lat' => '47.4212', 'lng' => '1.6703'),
      array('postal_code' => '41210', 'name' => 'Montrieux-en-Sologne', 'lat' => '47.5541', 'lng' => '1.7259'),
      array('postal_code' => '41210', 'name' => 'La Marolle-en-Sologne', 'lat' => '47.5847', 'lng' => '1.7785'),
      array('postal_code' => '41230', 'name' => 'Lassay-sur-Croisne', 'lat' => '47.3733', 'lng' => '1.6230'),
      array('postal_code' => '41220', 'name' => 'Saint-Laurent-Nouan', 'lat' => '47.7167', 'lng' => '1.6000'),
      array('postal_code' => '41240', 'name' => 'Pr_nouvellon', 'lat' => '47.9692', 'lng' => '1.5388'),
      array('postal_code' => '41240', 'name' => 'Binas', 'lat' => '47.9042', 'lng' => '1.4619'),
      array('postal_code' => '41240', 'name' => 'Tripleville', 'lat' => '47.9433', 'lng' => '1.4848'),
      array('postal_code' => '41230', 'name' => 'Soings-en-Sologne', 'lat' => '47.4129', 'lng' => '1.5245'),
      array('postal_code' => '41230', 'name' => 'Vernou-en-Sologne', 'lat' => '47.5010', 'lng' => '1.6805'),
      array('postal_code' => '41240', 'name' => 'Villermain', 'lat' => '47.8625', 'lng' => '1.5298'),
      array('postal_code' => '41240', 'name' => 'Membrolles', 'lat' => '47.9844', 'lng' => '1.4675'),
      array('postal_code' => '41230', 'name' => 'Gy-en-Sologne', 'lat' => '47.3444', 'lng' => '1.5824'),
      array('postal_code' => '41230', 'name' => 'Mur-de-Sologne', 'lat' => '47.4124', 'lng' => '1.6083'),
      array('postal_code' => '41230', 'name' => 'Courmemin', 'lat' => '47.4720', 'lng' => '1.6275'),
      array('postal_code' => '41240', 'name' => 'Autainville', 'lat' => '47.8818', 'lng' => '1.4166'),
      array('postal_code' => '41240', 'name' => 'Ouzouer-le-March_', 'lat' => '47.9106', 'lng' => '1.5261'),
      array('postal_code' => '41240', 'name' => 'Verdes', 'lat' => '47.9585', 'lng' => '1.4260'),
      array('postal_code' => '41240', 'name' => 'Saint-Laurent-des-Bois', 'lat' => '47.8523', 'lng' => '1.4481'),
      array('postal_code' => '41240', 'name' => 'Beauce la Romaine', 'lat' => '47.9111', 'lng' => '1.5275'),
      array('postal_code' => '41250', 'name' => 'Chambord', 'lat' => '47.6162', 'lng' => '1.5167'),
      array('postal_code' => '41250', 'name' => 'Fontaines-en-Sologne', 'lat' => '47.5091', 'lng' => '1.5504'),
      array('postal_code' => '41250', 'name' => 'Mont-pr�s-Chambord', 'lat' => '47.5623', 'lng' => '1.4571'),
      array('postal_code' => '41260', 'name' => 'La Chauss_e-Saint-Victor', 'lat' => '47.6162', 'lng' => '1.3676'),
      array('postal_code' => '41270', 'name' => 'Drou_', 'lat' => '48.0402', 'lng' => '1.0753'),
      array('postal_code' => '41250', 'name' => 'Bauzy', 'lat' => '47.5356', 'lng' => '1.6081'),
      array('postal_code' => '41270', 'name' => 'Ruan-sur-Egvonne', 'lat' => '48.0167', 'lng' => '1.1500'),
      array('postal_code' => '41250', 'name' => 'Neuvy', 'lat' => '47.5629', 'lng' => '1.6028'),
      array('postal_code' => '41261 CEDEX', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41290', 'name' => 'La Chapelle-Ench_rie', 'lat' => '47.8267', 'lng' => '1.2073'),
      array('postal_code' => '41250', 'name' => 'Tour-en-Sologne', 'lat' => '47.5401', 'lng' => '1.5053'),
      array('postal_code' => '41300', 'name' => 'Or�ay', 'lat' => '47.2909', 'lng' => '2.1116'),
      array('postal_code' => '41270', 'name' => 'Boursay', 'lat' => '48.0192', 'lng' => '0.9704'),
      array('postal_code' => '41270', 'name' => 'Le Poislay', 'lat' => '48.0667', 'lng' => '1.0650'),
      array('postal_code' => '41250', 'name' => 'Maslives', 'lat' => '47.6335', 'lng' => '1.4792'),
      array('postal_code' => '41250', 'name' => 'Bracieux', 'lat' => '47.5489', 'lng' => '1.5412'),
      array('postal_code' => '41270', 'name' => 'Bouffry', 'lat' => '48.0073', 'lng' => '1.0976'),
      array('postal_code' => '41270', 'name' => 'La Chapelle-Vicomtesse', 'lat' => '47.9900', 'lng' => '1.0355'),
      array('postal_code' => '41300', 'name' => 'Selles-Saint-Denis', 'lat' => '47.3869', 'lng' => '1.9229'),
      array('postal_code' => '41290', 'name' => 'Beauvilliers', 'lat' => '47.8300', 'lng' => '1.2500'),
      array('postal_code' => '41290', 'name' => 'Baigneaux', 'lat' => '47.7829', 'lng' => '1.2533'),
      array('postal_code' => '41270', 'name' => 'La Fontenelle', 'lat' => '48.0656', 'lng' => '1.0309'),
      array('postal_code' => '41270', 'name' => 'Romilly', 'lat' => '47.9486', 'lng' => '1.0383'),
      array('postal_code' => '41270', 'name' => 'Le Gault-Perche', 'lat' => '48.1000', 'lng' => '0.9833'),
      array('postal_code' => '41300', 'name' => 'Pierrefitte-sur-Sauldre', 'lat' => '47.5125', 'lng' => '2.1503'),
      array('postal_code' => '41300', 'name' => 'La Fert_-Imbault', 'lat' => '47.3847', 'lng' => '1.9534'),
      array('postal_code' => '41270', 'name' => 'Fontaine-Raoul', 'lat' => '47.9900', 'lng' => '1.1389'),
      array('postal_code' => '41270', 'name' => 'Villebout', 'lat' => '47.9899', 'lng' => '1.1770'),
      array('postal_code' => '41290', 'name' => 'Boisseau', 'lat' => '47.7729', 'lng' => '1.2971'),
      array('postal_code' => '41290', 'name' => 'Sainte-Gemmes', 'lat' => '47.7932', 'lng' => '1.2700'),
      array('postal_code' => '41270', 'name' => 'Chauvigny-du-Perche', 'lat' => '47.9570', 'lng' => '1.0798'),
      array('postal_code' => '41290', 'name' => 'Rhodon', 'lat' => '47.7529', 'lng' => '1.2678'),
      array('postal_code' => '41290', 'name' => '�piais', 'lat' => '47.8063', 'lng' => '1.2541'),
      array('postal_code' => '41290', 'name' => 'Villeneuve-Frouville', 'lat' => '47.7869', 'lng' => '1.3099'),
      array('postal_code' => '41290', 'name' => 'Oucques', 'lat' => '47.8225', 'lng' => '1.2938'),
      array('postal_code' => '41290', 'name' => 'Vievy-le-Ray_', 'lat' => '47.8667', 'lng' => '1.3167'),
      array('postal_code' => '41290', 'name' => 'Conan', 'lat' => '47.7496', 'lng' => '1.2863'),
      array('postal_code' => '41300', 'name' => 'Salbris', 'lat' => '47.4242', 'lng' => '2.0512'),
      array('postal_code' => '41300', 'name' => 'Theillay', 'lat' => '47.3143', 'lng' => '2.0403'),
      array('postal_code' => '41310', 'name' => 'Saint-Gourgon', 'lat' => '47.6608', 'lng' => '1.0173'),
      array('postal_code' => '41310', 'name' => 'Ambloy', 'lat' => '47.7124', 'lng' => '0.9669'),
      array('postal_code' => '41320', 'name' => 'Ch_tres-sur-Cher', 'lat' => '47.2650', 'lng' => '1.9059'),
      array('postal_code' => '41310', 'name' => 'Gombergean', 'lat' => '47.6500', 'lng' => '1.0833'),
      array('postal_code' => '41310', 'name' => 'Authon', 'lat' => '47.6448', 'lng' => '0.8960'),
      array('postal_code' => '41310', 'name' => 'Prunay-Cassereau', 'lat' => '47.6955', 'lng' => '0.9198'),
      array('postal_code' => '41310', 'name' => 'Lanc_', 'lat' => '47.6929', 'lng' => '1.0661'),
      array('postal_code' => '41310', 'name' => 'Nourray', 'lat' => '47.7173', 'lng' => '1.0588'),
      array('postal_code' => '41320', 'name' => 'Mennetou-sur-Cher', 'lat' => '47.2694', 'lng' => '1.8645'),
      array('postal_code' => '41310', 'name' => 'Villeporcher', 'lat' => '47.6408', 'lng' => '0.9938'),
      array('postal_code' => '41310', 'name' => 'Sasni�res', 'lat' => '47.7186', 'lng' => '0.9324'),
      array('postal_code' => '41300', 'name' => 'Souesmes', 'lat' => '47.4564', 'lng' => '2.1749'),
      array('postal_code' => '41310', 'name' => 'Huisseau-en-Beauce', 'lat' => '47.7235', 'lng' => '1.0094'),
      array('postal_code' => '41310', 'name' => 'Villechauve', 'lat' => '47.6497', 'lng' => '0.9415'),
      array('postal_code' => '41310', 'name' => 'Saint-Amand-Longpr_', 'lat' => '47.6833', 'lng' => '1.0167'),
      array('postal_code' => '41320', 'name' => 'Saint-Loup', 'lat' => '47.2651', 'lng' => '1.8389'),
      array('postal_code' => '41357 CEDEX', 'name' => 'Vineuil', 'lat' => '47.5838', 'lng' => '1.3760'),
      array('postal_code' => '41330', 'name' => 'Averdon', 'lat' => '47.6839', 'lng' => '1.2945'),
      array('postal_code' => '41330', 'name' => 'Champigny-en-Beauce', 'lat' => '47.7124', 'lng' => '1.2534'),
      array('postal_code' => '41360', 'name' => 'Fortan', 'lat' => '47.8444', 'lng' => '0.9157'),
      array('postal_code' => '41370', 'name' => 'La Madeleine-Villefrouin', 'lat' => '47.7723', 'lng' => '1.3955'),
      array('postal_code' => '41360', 'name' => 'Savigny-sur-Braye', 'lat' => '47.8792', 'lng' => '0.8098'),
      array('postal_code' => '41320', 'name' => 'Saint-Julien-sur-Cher', 'lat' => '47.2822', 'lng' => '1.7741'),
      array('postal_code' => '41320', 'name' => 'Maray', 'lat' => '47.2477', 'lng' => '1.8851'),
      array('postal_code' => '41350', 'name' => 'Montlivault', 'lat' => '47.6399', 'lng' => '1.4449'),
      array('postal_code' => '41360', 'name' => 'Cell_', 'lat' => '47.8330', 'lng' => '0.7810'),
      array('postal_code' => '41370', 'name' => 'Lorges', 'lat' => '47.8248', 'lng' => '1.4986'),
      array('postal_code' => '41360', 'name' => 'Lunay', 'lat' => '47.8086', 'lng' => '0.9150'),
      array('postal_code' => '41350', 'name' => 'Vineuil', 'lat' => '47.5838', 'lng' => '1.3760'),
      array('postal_code' => '41350', 'name' => 'Saint-Claude-de-Diray', 'lat' => '47.6165', 'lng' => '1.4180'),
      array('postal_code' => '41370', 'name' => 'Josnes', 'lat' => '47.7937', 'lng' => '1.5257'),
      array('postal_code' => '41355 CEDEX', 'name' => 'Vineuil', 'lat' => '47.5838', 'lng' => '1.3760'),
      array('postal_code' => '41320', 'name' => 'La Chapelle-Montmartin', 'lat' => '47.2667', 'lng' => '1.7333'),
      array('postal_code' => '41320', 'name' => 'Langon', 'lat' => '47.2842', 'lng' => '1.8260'),
      array('postal_code' => '41350', 'name' => 'Huisseau-sur-Cosson', 'lat' => '47.5933', 'lng' => '1.4533'),
      array('postal_code' => '41330', 'name' => 'Saint-Bohaire', 'lat' => '47.6431', 'lng' => '1.2634'),
      array('postal_code' => '41330', 'name' => 'Foss_', 'lat' => '47.6335', 'lng' => '1.2839'),
      array('postal_code' => '41330', 'name' => 'La Chapelle-Vend�moise', 'lat' => '47.6710', 'lng' => '1.2389'),
      array('postal_code' => '41354 CEDEX', 'name' => 'Vineuil', 'lat' => '47.5838', 'lng' => '1.3760'),
      array('postal_code' => '41330', 'name' => 'Villefranc�ur', 'lat' => '47.7000', 'lng' => '1.2167'),
      array('postal_code' => '41330', 'name' => 'Marolles', 'lat' => '47.6482', 'lng' => '1.3066'),
      array('postal_code' => '41370', 'name' => 'Talcy', 'lat' => '47.7700', 'lng' => '1.4457'),
      array('postal_code' => '41353 CEDEX', 'name' => 'Vineuil', 'lat' => '47.5838', 'lng' => '1.3760'),
      array('postal_code' => '41350', 'name' => 'Saint-Gervais-la-For�t', 'lat' => '47.5671', 'lng' => '1.3549'),
      array('postal_code' => '41370', 'name' => 'Briou', 'lat' => '47.8146', 'lng' => '1.4808'),
      array('postal_code' => '41370', 'name' => 'Roches', 'lat' => '47.7952', 'lng' => '1.4492'),
      array('postal_code' => '41400', 'name' => 'Monthou-sur-Cher', 'lat' => '47.3483', 'lng' => '1.2974'),
      array('postal_code' => '41370', 'name' => 'Concriers', 'lat' => '47.7720', 'lng' => '1.4747'),
      array('postal_code' => '41400', 'name' => 'Chissay-en-Touraine', 'lat' => '47.3375', 'lng' => '1.1336'),
      array('postal_code' => '41370', 'name' => 'Marchenoir', 'lat' => '47.8239', 'lng' => '1.3959'),
      array('postal_code' => '41360', 'name' => '�puisay', 'lat' => '47.9007', 'lng' => '0.9305'),
      array('postal_code' => '41400', 'name' => 'Ang_', 'lat' => '47.3316', 'lng' => '1.2447'),
      array('postal_code' => '41370', 'name' => 'Saint-L_onard-en-Beauce', 'lat' => '47.8336', 'lng' => '1.3808'),
      array('postal_code' => '41370', 'name' => 'Le Plessis-l��chelle', 'lat' => '47.8138', 'lng' => '1.4284'),
      array('postal_code' => '41400', 'name' => 'Montrichard', 'lat' => '47.3431', 'lng' => '1.1865'),
      array('postal_code' => '41400', 'name' => 'Saint-Georges-sur-Cher', 'lat' => '47.3300', 'lng' => '1.1326'),
      array('postal_code' => '41400', 'name' => 'Pontlevoy', 'lat' => '47.3900', 'lng' => '1.2547'),
      array('postal_code' => '41400', 'name' => 'Valli�res-les-Grandes', 'lat' => '47.4237', 'lng' => '1.1472'),
      array('postal_code' => '41400', 'name' => 'Bourr_', 'lat' => '47.3476', 'lng' => '1.2269'),
      array('postal_code' => '41400', 'name' => 'Montrichard Val de Cher', 'lat' => '47.3431', 'lng' => '1.1833'),
      array('postal_code' => '41400', 'name' => 'Saint-Julien-de-Ch_don', 'lat' => '47.3034', 'lng' => '1.2038'),
      array('postal_code' => '41400', 'name' => 'Faverolles-sur-Cher', 'lat' => '47.3173', 'lng' => '1.1905'),
      array('postal_code' => '41401 CEDEX', 'name' => 'Montrichard', 'lat' => '47.3431', 'lng' => '1.1865'),
      array('postal_code' => '41406 CEDEX', 'name' => 'Montrichard', 'lat' => '47.3431', 'lng' => '1.1865'),
      array('postal_code' => '41402 CEDEX', 'name' => 'Montrichard', 'lat' => '47.3431', 'lng' => '1.1865'),
      array('postal_code' => '41500', 'name' => 'Courbouzon', 'lat' => '47.7149', 'lng' => '1.5435'),
      array('postal_code' => '41500', 'name' => 'Avaray', 'lat' => '47.7225', 'lng' => '1.5644'),
      array('postal_code' => '41500', 'name' => 'Menars', 'lat' => '47.6427', 'lng' => '1.4077'),
      array('postal_code' => '41400', 'name' => 'Thenay', 'lat' => '47.3875', 'lng' => '1.2910'),
      array('postal_code' => '41500', 'name' => 'Mer', 'lat' => '47.7055', 'lng' => '1.5062'),
      array('postal_code' => '41500', 'name' => 'Villexanton', 'lat' => '47.7419', 'lng' => '1.4220'),
      array('postal_code' => '41500', 'name' => 'Su�vres', 'lat' => '47.6666', 'lng' => '1.4615'),
      array('postal_code' => '41600', 'name' => 'Chaumont-sur-Tharonne', 'lat' => '47.6104', 'lng' => '1.9051'),
      array('postal_code' => '41500', 'name' => 'Muides-sur-Loire', 'lat' => '47.6696', 'lng' => '1.5269'),
      array('postal_code' => '41500', 'name' => 'La Chapelle-Saint-Martin-en-Plaine', 'lat' => '47.7172', 'lng' => '1.4169'),
      array('postal_code' => '41500', 'name' => 'Cour-sur-Loire', 'lat' => '47.6506', 'lng' => '1.4238'),
      array('postal_code' => '41600', 'name' => 'Souvigny-en-Sologne', 'lat' => '47.6444', 'lng' => '2.1641'),
      array('postal_code' => '41700', 'name' => 'Fresnes', 'lat' => '47.4349', 'lng' => '1.4122'),
      array('postal_code' => '41500', 'name' => 'Saint-Dy_-sur-Loire', 'lat' => '47.6560', 'lng' => '1.4885'),
      array('postal_code' => '41700', 'name' => 'Ch_mery', 'lat' => '47.3468', 'lng' => '1.4790'),
      array('postal_code' => '41500', 'name' => 'Lestiou', 'lat' => '47.7350', 'lng' => '1.5891'),
      array('postal_code' => '41700', 'name' => 'Cheverny', 'lat' => '47.5008', 'lng' => '1.4595'),
      array('postal_code' => '41500', 'name' => 'Mulsans', 'lat' => '47.6963', 'lng' => '1.3853'),
      array('postal_code' => '41600', 'name' => 'Yvoy-le-Marron', 'lat' => '47.6322', 'lng' => '1.8528'),
      array('postal_code' => '41700', 'name' => 'Oisly', 'lat' => '47.3902', 'lng' => '1.3767'),
      array('postal_code' => '41600', 'name' => 'Lamotte-Beuvron', 'lat' => '47.6020', 'lng' => '2.0284'),
      array('postal_code' => '41600', 'name' => 'Vouzon', 'lat' => '47.6451', 'lng' => '2.0561'),
      array('postal_code' => '41500', 'name' => 'S_ris', 'lat' => '47.7582', 'lng' => '1.5020'),
      array('postal_code' => '41600', 'name' => 'Chaon', 'lat' => '47.6089', 'lng' => '2.1729'),
      array('postal_code' => '41700', 'name' => 'Choussy', 'lat' => '47.3731', 'lng' => '1.3464'),
      array('postal_code' => '41700', 'name' => 'Cour-Cheverny', 'lat' => '47.5103', 'lng' => '1.4558'),
      array('postal_code' => '41500', 'name' => 'Maves', 'lat' => '47.7429', 'lng' => '1.3651'),
      array('postal_code' => '41600', 'name' => 'Nouan-le-Fuzelier', 'lat' => '47.5360', 'lng' => '2.0365'),
      array('postal_code' => '41700', 'name' => 'Contres', 'lat' => '47.4175', 'lng' => '1.4285'),
      array('postal_code' => '41800', 'name' => 'Artins', 'lat' => '47.7457', 'lng' => '0.7394'),
      array('postal_code' => '41800', 'name' => 'Montoire-sur-le-Loir', 'lat' => '47.7532', 'lng' => '0.8653'),
      array('postal_code' => '41800', 'name' => 'Bonneveau', 'lat' => '47.8126', 'lng' => '0.7489'),
      array('postal_code' => '41800', 'name' => 'Ternay', 'lat' => '47.7310', 'lng' => '0.7781'),
      array('postal_code' => '41700', 'name' => 'Sassay', 'lat' => '47.3944', 'lng' => '1.4414'),
      array('postal_code' => '41800', 'name' => 'Tr_het', 'lat' => '47.7337', 'lng' => '0.6227'),
      array('postal_code' => '41800', 'name' => 'Troo', 'lat' => '47.7833', 'lng' => '0.7833'),
      array('postal_code' => '41800', 'name' => 'Saint-Jacques-des-Gu_rets', 'lat' => '47.7667', 'lng' => '0.8000'),
      array('postal_code' => '41800', 'name' => 'Soug_', 'lat' => '47.7698', 'lng' => '0.7281'),
      array('postal_code' => '41700', 'name' => 'Couddes', 'lat' => '47.3641', 'lng' => '1.4044'),
      array('postal_code' => '41800', 'name' => 'Saint-Rimay', 'lat' => '47.7637', 'lng' => '0.9227'),
      array('postal_code' => '41800', 'name' => 'Saint-Arnoult', 'lat' => '47.7082', 'lng' => '0.8716'),
      array('postal_code' => '41800', 'name' => 'Fontaine-les-Coteaux', 'lat' => '47.8000', 'lng' => '0.8333'),
      array('postal_code' => '41800', 'name' => 'Les Roches-l��v�que', 'lat' => '47.7840', 'lng' => '0.8951'),
      array('postal_code' => '41800', 'name' => 'Montrouveau', 'lat' => '47.7148', 'lng' => '0.7309'),
      array('postal_code' => '41800', 'name' => 'Villedieu-le-Ch_teau', 'lat' => '47.7205', 'lng' => '0.6472'),
      array('postal_code' => '41800', 'name' => 'Saint-Martin-des-Bois', 'lat' => '47.7240', 'lng' => '0.8262'),
      array('postal_code' => '41800', 'name' => 'Villavard', 'lat' => '47.7590', 'lng' => '0.9045'),
      array('postal_code' => '41800', 'name' => 'Couture-sur-Loir', 'lat' => '47.7536', 'lng' => '0.6869'),
      array('postal_code' => '41800', 'name' => 'Lavardin', 'lat' => '47.7418', 'lng' => '0.8859'),
      array('postal_code' => '41800', 'name' => 'Les Essarts', 'lat' => '47.7333', 'lng' => '0.7200'),
      array('postal_code' => '41901 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41903 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41906 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41800', 'name' => 'Houssay', 'lat' => '47.7527', 'lng' => '0.9383'),
      array('postal_code' => '41909 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41908 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41800', 'name' => 'Les Hayes', 'lat' => '47.7156', 'lng' => '0.7770'),
      array('postal_code' => '41904 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41905 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41915 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41924 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41941 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41943 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41925 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41932 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41930 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41921 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41936 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41910 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41933 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41913 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41948 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41918 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41914 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41951 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41949 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41960 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41965 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41963 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41945 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41919 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41967 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41958 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41968 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41973 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41942 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41950 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41976 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41964 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41966 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41971 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41975 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41931 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41974 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41972 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '41970 CEDEX 9', 'name' => 'Blois', 'lat' => '47.5943', 'lng' => '1.3291'),
      array('postal_code' => '45000', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45003 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45004 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45001 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45002 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45006 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45008 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45005 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45007 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45023 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45016 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45015 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45011 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45010 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45012 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45009 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45031 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45019 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45032 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45025 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45017 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45029 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45034 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45021 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45045 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45044 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45028 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45042 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45038 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45046 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45069 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45056 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45033 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45040 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45043 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45052 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45030 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45058 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45041 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45035 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45062 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45061 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45063 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45053 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45072 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45074 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45057 CEDEX 1', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45068 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45065 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45060 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45075 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45079 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45120', 'name' => 'Cepoy', 'lat' => '48.0480', 'lng' => '2.7378'),
      array('postal_code' => '45064 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45100', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45110', 'name' => 'Germigny-des-Pr_s', 'lat' => '47.8448', 'lng' => '2.2695'),
      array('postal_code' => '45088 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45082 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45067 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45081 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45120', 'name' => 'Ch_lette-sur-Loing', 'lat' => '48.0134', 'lng' => '2.7359'),
      array('postal_code' => '45071 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45073 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45110', 'name' => 'Saint-Martin-d�Abbat', 'lat' => '47.8565', 'lng' => '2.2653'),
      array('postal_code' => '45110', 'name' => 'Ch_teauneuf-sur-Loire', 'lat' => '47.8657', 'lng' => '2.2190'),
      array('postal_code' => '45078 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45087 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45077 CEDEX 2', 'name' => 'Orl_ans', 'lat' => '47.9029', 'lng' => '1.9039'),
      array('postal_code' => '45121 CEDEX', 'name' => 'Ch_lette-sur-Loing', 'lat' => '48.0134', 'lng' => '2.7359'),
      array('postal_code' => '45120', 'name' => 'Corquilleroy', 'lat' => '48.0421', 'lng' => '2.7038'),
      array('postal_code' => '45145 CEDEX', 'name' => 'Saint-Jean-de-la-Ruelle', 'lat' => '47.9113', 'lng' => '1.8648'),
      array('postal_code' => '45130', 'name' => 'Meung-sur-Loire', 'lat' => '47.8312', 'lng' => '1.6958'),
      array('postal_code' => '45122 CEDEX', 'name' => 'Ch_lette-sur-Loing', 'lat' => '48.0134', 'lng' => '2.7359'),
      array('postal_code' => '45125 CEDEX', 'name' => 'Ch_lette-sur-Loing', 'lat' => '48.0134', 'lng' => '2.7359'),
      array('postal_code' => '45110', 'name' => 'Sigloy', 'lat' => '47.8338', 'lng' => '2.2263'),
      array('postal_code' => '45129 CEDEX', 'name' => 'Ch_lette-sur-Loing', 'lat' => '48.0134', 'lng' => '2.7359'),
      array('postal_code' => '45130', 'name' => 'Baule', 'lat' => '47.8108', 'lng' => '1.6726'),
      array('postal_code' => '45130', 'name' => '�pieds-en-Beauce', 'lat' => '47.9507', 'lng' => '1.6173'),
      array('postal_code' => '45130', 'name' => 'Charsonville', 'lat' => '47.9282', 'lng' => '1.5798'),
      array('postal_code' => '45140', 'name' => 'Boulay-les-Barres', 'lat' => '47.9839', 'lng' => '1.7824'),
      array('postal_code' => '45130', 'name' => 'Saint-Ay', 'lat' => '47.8589', 'lng' => '1.7514'),
      array('postal_code' => '45120', 'name' => 'Girolles', 'lat' => '48.0612', 'lng' => '2.7153'),
      array('postal_code' => '45150', 'name' => 'Jargeau', 'lat' => '47.8632', 'lng' => '2.1265'),
      array('postal_code' => '45147 CEDEX', 'name' => 'Saint-Jean-de-la-Ruelle', 'lat' => '47.9113', 'lng' => '1.8648'),
      array('postal_code' => '45130', 'name' => 'Rozi�res-en-Beauce', 'lat' => '47.9422', 'lng' => '1.7018'),
      array('postal_code' => '45130', 'name' => 'Baccon', 'lat' => '47.8914', 'lng' => '1.6286'),
      array('postal_code' => '45130', 'name' => 'Coulmiers', 'lat' => '47.9314', 'lng' => '1.6646'),
      array('postal_code' => '45130', 'name' => 'Le Bardon', 'lat' => '47.8449', 'lng' => '1.6523'),
      array('postal_code' => '45142 CEDEX', 'name' => 'Saint-Jean-de-la-Ruelle', 'lat' => '47.9113', 'lng' => '1.8648'),
      array('postal_code' => '45140', 'name' => 'Ingr_', 'lat' => '47.9200', 'lng' => '1.8278'),
      array('postal_code' => '45130', 'name' => 'Huisseau-sur-Mauves', 'lat' => '47.8932', 'lng' => '1.7027'),
      array('postal_code' => '45140', 'name' => 'Bucy-Saint-Liphard', 'lat' => '47.9357', 'lng' => '1.7649'),
      array('postal_code' => '45140', 'name' => 'Saint-Jean-de-la-Ruelle', 'lat' => '47.9113', 'lng' => '1.8648'),
      array('postal_code' => '45144 CEDEX', 'name' => 'Saint-Jean-de-la-Ruelle', 'lat' => '47.9113', 'lng' => '1.8648'),
      array('postal_code' => '45143 CEDEX', 'name' => 'Saint-Jean-de-la-Ruelle', 'lat' => '47.9113', 'lng' => '1.8648'),
      array('postal_code' => '45141 CEDEX', 'name' => 'Saint-Jean-de-la-Ruelle', 'lat' => '47.9113', 'lng' => '1.8648'),
      array('postal_code' => '45150', 'name' => 'Darvoy', 'lat' => '47.8584', 'lng' => '2.1003'),
      array('postal_code' => '45140', 'name' => 'Ormes', 'lat' => '47.9415', 'lng' => '1.8182'),
      array('postal_code' => '45149 CEDEX', 'name' => 'Saint-Jean-de-la-Ruelle', 'lat' => '47.9113', 'lng' => '1.8648'),
      array('postal_code' => '45146 CEDEX', 'name' => 'Saint-Jean-de-la-Ruelle', 'lat' => '47.9113', 'lng' => '1.8648'),
      array('postal_code' => '45150', 'name' => 'F_rolles', 'lat' => '47.8347', 'lng' => '2.1111'),
      array('postal_code' => '45150', 'name' => 'Ouvrouer-les-Champs', 'lat' => '47.8323', 'lng' => '2.1788'),
      array('postal_code' => '45160', 'name' => 'Olivet', 'lat' => '47.8622', 'lng' => '1.8991'),
      array('postal_code' => '45160', 'name' => 'Saint-Hilaire-Saint-Mesmin', 'lat' => '47.8661', 'lng' => '1.8335'),
      array('postal_code' => '45163 CEDEX', 'name' => 'Olivet', 'lat' => '47.8622', 'lng' => '1.8991'),
      array('postal_code' => '45170', 'name' => 'Attray', 'lat' => '48.1227', 'lng' => '2.1121'),
      array('postal_code' => '45162 CEDEX', 'name' => 'Olivet', 'lat' => '47.8622', 'lng' => '1.8991'),
      array('postal_code' => '45170', 'name' => 'Saint-Ly_-la-For�t', 'lat' => '48.0407', 'lng' => '1.9826'),
      array('postal_code' => '45161 CEDEX', 'name' => 'Olivet', 'lat' => '47.8622', 'lng' => '1.8991'),
      array('postal_code' => '45170', 'name' => 'Villereau', 'lat' => '48.0695', 'lng' => '1.9885'),
      array('postal_code' => '45168 CEDEX', 'name' => 'Olivet', 'lat' => '47.8622', 'lng' => '1.8991'),
      array('postal_code' => '45169 CEDEX', 'name' => 'Olivet', 'lat' => '47.8622', 'lng' => '1.8991'),
      array('postal_code' => '45165 CEDEX', 'name' => 'Olivet', 'lat' => '47.8622', 'lng' => '1.8991'),
      array('postal_code' => '45160', 'name' => 'Ardon', 'lat' => '47.7793', 'lng' => '1.8742'),
      array('postal_code' => '45170', 'name' => 'Bougy-lez-Neuville', 'lat' => '48.0407', 'lng' => '2.0258'),
      array('postal_code' => '45170', 'name' => 'Tivernon', 'lat' => '48.1561', 'lng' => '1.9307'),
      array('postal_code' => '45170', 'name' => 'Asch�res-le-March_', 'lat' => '48.1101', 'lng' => '2.0073'),
      array('postal_code' => '45166 CEDEX', 'name' => 'Olivet', 'lat' => '47.8622', 'lng' => '1.8991'),
      array('postal_code' => '45170', 'name' => 'Chilleurs-aux-Bois', 'lat' => '48.0722', 'lng' => '2.1354'),
      array('postal_code' => '45170', 'name' => 'Santeau', 'lat' => '48.0882', 'lng' => '2.1589'),
      array('postal_code' => '45164 CEDEX', 'name' => 'Olivet', 'lat' => '47.8622', 'lng' => '1.8991'),
      array('postal_code' => '45170', 'name' => 'Montigny', 'lat' => '48.1136', 'lng' => '2.1149'),
      array('postal_code' => '45170', 'name' => 'Neuville-aux-Bois', 'lat' => '48.0681', 'lng' => '2.0537'),
      array('postal_code' => '45200', 'name' => 'Montargis', 'lat' => '48.0000', 'lng' => '2.7500'),
      array('postal_code' => '45190', 'name' => 'Villorceau', 'lat' => '47.8010', 'lng' => '1.5971'),
      array('postal_code' => '45200', 'name' => 'Amilly', 'lat' => '47.9728', 'lng' => '2.7719'),
      array('postal_code' => '45190', 'name' => 'Cravant', 'lat' => '47.8286', 'lng' => '1.5711'),
      array('postal_code' => '45202 CEDEX', 'name' => 'Montargis', 'lat' => '48.0000', 'lng' => '2.7500'),
      array('postal_code' => '45190', 'name' => 'Messas', 'lat' => '47.8073', 'lng' => '1.6366'),
      array('postal_code' => '45210', 'name' => 'M_rinville', 'lat' => '48.0823', 'lng' => '2.9425'),
      array('postal_code' => '45190', 'name' => 'Tavers', 'lat' => '47.7592', 'lng' => '1.6127'),
      array('postal_code' => '45170', 'name' => 'Oison', 'lat' => '48.1381', 'lng' => '1.9689'),
      array('postal_code' => '45210', 'name' => 'Chevannes', 'lat' => '48.1342', 'lng' => '2.8584'),
      array('postal_code' => '45201 CEDEX', 'name' => 'Montargis', 'lat' => '48.0000', 'lng' => '2.7500'),
      array('postal_code' => '45205 CEDEX', 'name' => 'Montargis', 'lat' => '48.0000', 'lng' => '2.7500'),
      array('postal_code' => '45206 CEDEX', 'name' => 'Montargis', 'lat' => '48.0000', 'lng' => '2.7500'),
      array('postal_code' => '45200', 'name' => 'Paucourt', 'lat' => '48.0378', 'lng' => '2.7953'),
      array('postal_code' => '45208 CEDEX', 'name' => 'Montargis', 'lat' => '48.0000', 'lng' => '2.7500'),
      array('postal_code' => '45170', 'name' => 'Crottes-en-Pithiverais', 'lat' => '48.1222', 'lng' => '2.0664'),
      array('postal_code' => '45210', 'name' => 'La Selle-sur-le-Bied', 'lat' => '48.0639', 'lng' => '2.8974'),
      array('postal_code' => '45203 CEDEX', 'name' => 'Montargis', 'lat' => '48.0000', 'lng' => '2.7500'),
      array('postal_code' => '45190', 'name' => 'Beaugency', 'lat' => '47.7802', 'lng' => '1.6271'),
      array('postal_code' => '45204 CEDEX', 'name' => 'Montargis', 'lat' => '48.0000', 'lng' => '2.7500'),
      array('postal_code' => '45210', 'name' => 'Pers-en-G_tinais', 'lat' => '48.1187', 'lng' => '2.9045'),
      array('postal_code' => '45210', 'name' => 'Ferri�res-en-G_tinais', 'lat' => '48.0833', 'lng' => '2.7833'),
      array('postal_code' => '45210', 'name' => 'La Chapelle-Saint-S_pulcre', 'lat' => '48.0182', 'lng' => '2.8439'),
      array('postal_code' => '45210', 'name' => 'Fontenay-sur-Loing', 'lat' => '48.1036', 'lng' => '2.7754'),
      array('postal_code' => '45210', 'name' => 'Nargis', 'lat' => '48.1111', 'lng' => '2.7560'),
      array('postal_code' => '45210', 'name' => 'Chevry-sous-le-Bignon', 'lat' => '48.1409', 'lng' => '2.8983'),
      array('postal_code' => '45209 CEDEX', 'name' => 'Montargis', 'lat' => '48.0000', 'lng' => '2.7500'),
      array('postal_code' => '45207 CEDEX', 'name' => 'Montargis', 'lat' => '48.0000', 'lng' => '2.7500'),
      array('postal_code' => '45220', 'name' => 'Douchy-Montcorbon', 'lat' => '47.9433', 'lng' => '3.0525'),
      array('postal_code' => '45220', 'name' => 'Douchy', 'lat' => '47.9428', 'lng' => '3.0539'),
      array('postal_code' => '45240', 'name' => 'Sennely', 'lat' => '47.6782', 'lng' => '2.1474'),
      array('postal_code' => '45210', 'name' => 'Le Grand-Ambreville', 'lat' => '48.1101', 'lng' => '2.8363'),
      array('postal_code' => '45210', 'name' => 'La Selle-en-Hermoy', 'lat' => '48.0116', 'lng' => '2.8954'),
      array('postal_code' => '45210', 'name' => 'Rozoy-le-Vieil', 'lat' => '48.1246', 'lng' => '2.9452'),
      array('postal_code' => '45220', 'name' => 'Melleroy', 'lat' => '47.8950', 'lng' => '2.9533'),
      array('postal_code' => '45220', 'name' => 'Ch_teau-Renard', 'lat' => '47.9333', 'lng' => '2.9333'),
      array('postal_code' => '45240', 'name' => 'La Fert_-Saint-Aubin', 'lat' => '47.7170', 'lng' => '1.9390'),
      array('postal_code' => '45210', 'name' => 'Louzouer', 'lat' => '48.0392', 'lng' => '2.8832'),
      array('postal_code' => '45220', 'name' => 'Montcorbon', 'lat' => '47.9696', 'lng' => '3.0709'),
      array('postal_code' => '45230', 'name' => 'Feins-en-G_tinais', 'lat' => '47.7490', 'lng' => '2.8403'),
      array('postal_code' => '45210', 'name' => 'Thorailles', 'lat' => '48.0235', 'lng' => '2.8999'),
      array('postal_code' => '45230', 'name' => 'Adon', 'lat' => '47.7637', 'lng' => '2.7956'),
      array('postal_code' => '45213 CEDEX', 'name' => 'Montargis', 'lat' => '48.0000', 'lng' => '2.7500'),
      array('postal_code' => '45230', 'name' => 'Aillant-sur-Milleron', 'lat' => '47.7923', 'lng' => '2.9303'),
      array('postal_code' => '45210', 'name' => 'Griselles', 'lat' => '48.0831', 'lng' => '2.8295'),
      array('postal_code' => '45220', 'name' => 'Saint-Germain-des-Pr_s', 'lat' => '47.9538', 'lng' => '2.8485'),
      array('postal_code' => '45211 CEDEX', 'name' => 'Montargis', 'lat' => '48.0000', 'lng' => '2.7500'),
      array('postal_code' => '45240', 'name' => 'Marcilly-en-Villette', 'lat' => '47.7650', 'lng' => '2.0227'),
      array('postal_code' => '45230', 'name' => 'Dammarie-sur-Loing', 'lat' => '47.7833', 'lng' => '2.8812'),
      array('postal_code' => '45230', 'name' => 'Le Charme', 'lat' => '47.8001', 'lng' => '2.9936'),
      array('postal_code' => '45230', 'name' => 'Sainte-Genevi�ve-des-Bois', 'lat' => '47.8178', 'lng' => '2.8165'),
      array('postal_code' => '45240', 'name' => 'Ligny-le-Ribault', 'lat' => '47.6842', 'lng' => '1.7815'),
      array('postal_code' => '45210', 'name' => 'Saint-Loup-de-Gonois', 'lat' => '48.0577', 'lng' => '2.9311'),
      array('postal_code' => '45212 CEDEX', 'name' => 'Montargis', 'lat' => '48.0000', 'lng' => '2.7500'),
      array('postal_code' => '45214 CEDEX', 'name' => 'Montargis', 'lat' => '48.0000', 'lng' => '2.7500'),
      array('postal_code' => '45220', 'name' => 'Saint-Firmin-des-Bois', 'lat' => '47.9652', 'lng' => '2.9119'),
      array('postal_code' => '45250', 'name' => 'Ouzouer-sur-Tr_z_e', 'lat' => '47.6727', 'lng' => '2.8080'),
      array('postal_code' => '45260', 'name' => 'Lorris', 'lat' => '47.8895', 'lng' => '2.5148'),
      array('postal_code' => '45250', 'name' => 'Ousson-sur-Loire', 'lat' => '47.5902', 'lng' => '2.7873'),
      array('postal_code' => '45250', 'name' => 'Breteau', 'lat' => '47.6829', 'lng' => '2.8934'),
      array('postal_code' => '45250', 'name' => 'Briare', 'lat' => '47.6334', 'lng' => '2.7438'),
      array('postal_code' => '45230', 'name' => 'Saint-Maurice-sur-Aveyron', 'lat' => '47.8509', 'lng' => '2.9266'),
      array('postal_code' => '45250', 'name' => 'Escrignelles', 'lat' => '47.7150', 'lng' => '2.8223'),
      array('postal_code' => '45240', 'name' => 'M_nestreau-en-Villette', 'lat' => '47.6996', 'lng' => '2.0233'),
      array('postal_code' => '45260', 'name' => 'Chailly-en-G_tinais', 'lat' => '47.9469', 'lng' => '2.5434'),
      array('postal_code' => '45210', 'name' => 'Bazoches-sur-le-Betz', 'lat' => '48.1330', 'lng' => '2.9883'),
      array('postal_code' => '45230', 'name' => 'Montbouy', 'lat' => '47.8608', 'lng' => '2.8198'),
      array('postal_code' => '45260', 'name' => 'Ch_tenoy', 'lat' => '47.9181', 'lng' => '2.3987'),
      array('postal_code' => '45210', 'name' => 'Le Bignon-Mirabeau', 'lat' => '48.1481', 'lng' => '2.9234'),
      array('postal_code' => '45260', 'name' => 'Presnoy', 'lat' => '47.9569', 'lng' => '2.5557'),
      array('postal_code' => '45260', 'name' => 'Coudroy', 'lat' => '47.9067', 'lng' => '2.4674'),
      array('postal_code' => '45230', 'name' => 'La Chapelle-sur-Aveyron', 'lat' => '47.8661', 'lng' => '2.8621'),
      array('postal_code' => '45220', 'name' => 'Chuelles', 'lat' => '48.0026', 'lng' => '2.9661'),
      array('postal_code' => '45220', 'name' => 'Trigu�res', 'lat' => '47.9397', 'lng' => '2.9857'),
      array('postal_code' => '45220', 'name' => 'Gy-les-Nonains', 'lat' => '47.9470', 'lng' => '2.8505'),
      array('postal_code' => '45230', 'name' => 'Ch_tillon-Coligny', 'lat' => '47.8227', 'lng' => '2.8456'),
      array('postal_code' => '45230', 'name' => 'La Bussi�re', 'lat' => '47.7461', 'lng' => '2.7515'),
      array('postal_code' => '45260', 'name' => 'La Cour-Marigny', 'lat' => '47.8940', 'lng' => '2.5949'),
      array('postal_code' => '45260', 'name' => 'Noyers', 'lat' => '47.9142', 'lng' => '2.5240'),
      array('postal_code' => '45260', 'name' => 'Vieilles-Maisons-sur-Joudry', 'lat' => '47.8868', 'lng' => '2.4443'),
      array('postal_code' => '45260', 'name' => 'Thimory', 'lat' => '47.9225', 'lng' => '2.6014'),
      array('postal_code' => '45260', 'name' => 'Montereau', 'lat' => '47.8563', 'lng' => '2.5734'),
      array('postal_code' => '45270', 'name' => 'Villemoutiers', 'lat' => '47.9953', 'lng' => '2.5596'),
      array('postal_code' => '45270', 'name' => 'Ladon', 'lat' => '48.0026', 'lng' => '2.5372'),
      array('postal_code' => '45270', 'name' => 'Fr_ville-du-G_tinais', 'lat' => '48.0240', 'lng' => '2.4431'),
      array('postal_code' => '45290', 'name' => 'Langesse', 'lat' => '47.8189', 'lng' => '2.6579'),
      array('postal_code' => '45290', 'name' => 'Boismorand', 'lat' => '47.7859', 'lng' => '2.7188'),
      array('postal_code' => '45290', 'name' => 'Ouzouer-des-Champs', 'lat' => '47.8821', 'lng' => '2.7074'),
      array('postal_code' => '45270', 'name' => 'Ouzouer-sous-Bellegarde', 'lat' => '47.9931', 'lng' => '2.4655'),
      array('postal_code' => '45270', 'name' => 'Beauchamps-sur-Huillard', 'lat' => '47.9378', 'lng' => '2.4543'),
      array('postal_code' => '45270', 'name' => 'Chapelon', 'lat' => '48.0370', 'lng' => '2.5787'),
      array('postal_code' => '45300', 'name' => 'Y�vre-la-Ville', 'lat' => '48.1449', 'lng' => '2.3260'),
      array('postal_code' => '45290', 'name' => 'Nogent-sur-Vernisson', 'lat' => '47.8460', 'lng' => '2.7427'),
      array('postal_code' => '45270', 'name' => 'M_zi�res-en-G_tinais', 'lat' => '48.0360', 'lng' => '2.4906'),
      array('postal_code' => '45270', 'name' => 'Moulon', 'lat' => '48.0209', 'lng' => '2.5912'),
      array('postal_code' => '45300', 'name' => 'Sermaises', 'lat' => '48.2965', 'lng' => '2.2055'),
      array('postal_code' => '45290', 'name' => 'Pressigny-les-Pins', 'lat' => '47.8833', 'lng' => '2.7500'),
      array('postal_code' => '45270', 'name' => 'Bellegarde', 'lat' => '47.9833', 'lng' => '2.4333'),
      array('postal_code' => '45270', 'name' => 'Quiers-sur-B_zonde', 'lat' => '47.9962', 'lng' => '2.4414'),
      array('postal_code' => '45290', 'name' => 'Varennes-Changy', 'lat' => '47.8667', 'lng' => '2.6500'),
      array('postal_code' => '45290', 'name' => 'Oussoy-en-G_tinais', 'lat' => '47.9071', 'lng' => '2.6429'),
      array('postal_code' => '45270', 'name' => 'Nesploy', 'lat' => '47.9975', 'lng' => '2.3609'),
      array('postal_code' => '45300', 'name' => 'C_sarville-Dossainville', 'lat' => '48.2667', 'lng' => '2.2667'),
      array('postal_code' => '45290', 'name' => 'Le Moulinet-sur-Solin', 'lat' => '47.8333', 'lng' => '2.6167'),
      array('postal_code' => '45270', 'name' => 'Auvilliers-en-G_tinais', 'lat' => '47.9631', 'lng' => '2.4997'),
      array('postal_code' => '45290', 'name' => 'Les Choux', 'lat' => '47.7977', 'lng' => '2.6754'),
      array('postal_code' => '45300', 'name' => 'Le Malesherbois', 'lat' => '48.2964', 'lng' => '2.4053'),
      array('postal_code' => '45300', 'name' => 'Morville-en-Beauce', 'lat' => '48.2508', 'lng' => '2.1737'),
      array('postal_code' => '45300', 'name' => 'Boynes', 'lat' => '48.1182', 'lng' => '2.3601'),
      array('postal_code' => '45300', 'name' => 'Estouy', 'lat' => '48.1871', 'lng' => '2.3297'),
      array('postal_code' => '45300', 'name' => 'Escrennes', 'lat' => '48.1329', 'lng' => '2.1883'),
      array('postal_code' => '45300', 'name' => 'Ramoulu', 'lat' => '48.2260', 'lng' => '2.2918'),
      array('postal_code' => '45300', 'name' => 'Intville-la-Gu_tard', 'lat' => '48.2608', 'lng' => '2.2137'),
      array('postal_code' => '45300', 'name' => 'Pithiviers', 'lat' => '48.1667', 'lng' => '2.2500'),
      array('postal_code' => '45300', 'name' => 'Laas', 'lat' => '48.1202', 'lng' => '2.2221'),
      array('postal_code' => '45300', 'name' => 'Marsainvilliers', 'lat' => '48.2198', 'lng' => '2.2818'),
      array('postal_code' => '45300', 'name' => 'Rouvres-Saint-Jean', 'lat' => '48.3228', 'lng' => '2.2117'),
      array('postal_code' => '45300', 'name' => 'Givraines', 'lat' => '48.1477', 'lng' => '2.3680'),
      array('postal_code' => '45300', 'name' => 'Courcelles-Le-Roi', 'lat' => '48.0973', 'lng' => '2.3173'),
      array('postal_code' => '45300', 'name' => 'Panneci�res', 'lat' => '48.2927', 'lng' => '2.1465'),
      array('postal_code' => '45300', 'name' => 'Ascoux', 'lat' => '48.1286', 'lng' => '2.2541'),
      array('postal_code' => '45300', 'name' => 'Dadonville', 'lat' => '48.1578', 'lng' => '2.2715'),
      array('postal_code' => '45300', 'name' => 'Guigneville', 'lat' => '48.2060', 'lng' => '2.1770'),
      array('postal_code' => '45300', 'name' => 'Courcy-aux-Loges', 'lat' => '48.0647', 'lng' => '2.2136'),
      array('postal_code' => '45300', 'name' => 'Bondaroy', 'lat' => '48.1770', 'lng' => '2.2789'),
      array('postal_code' => '45300', 'name' => 'Engenville', 'lat' => '48.2384', 'lng' => '2.2469'),
      array('postal_code' => '45300', 'name' => 'Manchecourt', 'lat' => '48.2384', 'lng' => '2.3429'),
      array('postal_code' => '45300', 'name' => 'Audeville', 'lat' => '48.2789', 'lng' => '2.2383'),
      array('postal_code' => '45300', 'name' => 'Thignonville', 'lat' => '48.2800', 'lng' => '2.1734'),
      array('postal_code' => '45300', 'name' => 'Bouilly-en-G_tinais', 'lat' => '48.0949', 'lng' => '2.2844'),
      array('postal_code' => '45300', 'name' => 'Mareau-aux-Bois', 'lat' => '48.1035', 'lng' => '2.1885'),
      array('postal_code' => '45300', 'name' => 'Pithiviers-le-Vieil', 'lat' => '48.1631', 'lng' => '2.2092'),
      array('postal_code' => '45300', 'name' => 'Vrigny', 'lat' => '48.0798', 'lng' => '2.2502'),
      array('postal_code' => '45303 CEDEX', 'name' => 'Pithiviers', 'lat' => '48.1667', 'lng' => '2.2500'),
      array('postal_code' => '45304 CEDEX', 'name' => 'Pithiviers', 'lat' => '48.1667', 'lng' => '2.2500'),
      array('postal_code' => '45310', 'name' => 'Coinces', 'lat' => '48.0110', 'lng' => '1.7388'),
      array('postal_code' => '45307 CEDEX', 'name' => 'Pithiviers', 'lat' => '48.1667', 'lng' => '2.2500'),
      array('postal_code' => '45310', 'name' => 'Villeneuve-sur-Conie', 'lat' => '48.0442', 'lng' => '1.6519'),
      array('postal_code' => '45320', 'name' => 'Ervauville', 'lat' => '48.0902', 'lng' => '2.9851'),
      array('postal_code' => '45302 CEDEX', 'name' => 'Pithiviers', 'lat' => '48.1667', 'lng' => '2.2500'),
      array('postal_code' => '45306 CEDEX', 'name' => 'Pithiviers', 'lat' => '48.1667', 'lng' => '2.2500'),
      array('postal_code' => '45320', 'name' => 'Courtenay', 'lat' => '48.0390', 'lng' => '3.0585'),
      array('postal_code' => '45330', 'name' => 'Malesherbes', 'lat' => '48.2957', 'lng' => '2.4093'),
      array('postal_code' => '45310', 'name' => 'Bricy', 'lat' => '47.9985', 'lng' => '1.7794'),
      array('postal_code' => '45300', 'name' => 'Bouzonville-aux-Bois', 'lat' => '48.1000', 'lng' => '2.2333'),
      array('postal_code' => '45310', 'name' => 'Tournoisis', 'lat' => '48.0078', 'lng' => '1.6311'),
      array('postal_code' => '45310', 'name' => 'Saint-Sigismond', 'lat' => '47.9808', 'lng' => '1.6791'),
      array('postal_code' => '45310', 'name' => 'Patay', 'lat' => '48.0483', 'lng' => '1.6950'),
      array('postal_code' => '45320', 'name' => 'Chantecoq', 'lat' => '48.0537', 'lng' => '2.9615'),
      array('postal_code' => '45310', 'name' => 'Saint-P_ravy-la-Colombe', 'lat' => '47.9987', 'lng' => '1.7014'),
      array('postal_code' => '45310', 'name' => 'Villamblain', 'lat' => '48.0111', 'lng' => '1.5523'),
      array('postal_code' => '45310', 'name' => 'G_migny', 'lat' => '47.9646', 'lng' => '1.6950'),
      array('postal_code' => '45308 CEDEX', 'name' => 'Pithiviers', 'lat' => '48.1667', 'lng' => '2.2500'),
      array('postal_code' => '45310', 'name' => 'Rouvray-Sainte-Croix', 'lat' => '48.0589', 'lng' => '1.7324'),
      array('postal_code' => '45305 CEDEX', 'name' => 'Pithiviers', 'lat' => '48.1667', 'lng' => '2.2500'),
      array('postal_code' => '45310', 'name' => 'La Chapelle-Onzerain', 'lat' => '48.0332', 'lng' => '1.6122'),
      array('postal_code' => '45320', 'name' => 'Foucherolles', 'lat' => '48.0938', 'lng' => '3.0117'),
      array('postal_code' => '45320', 'name' => 'Saint-Hilaire-les-Andr_sis', 'lat' => '48.0525', 'lng' => '3.0131'),
      array('postal_code' => '45340', 'name' => '�gry', 'lat' => '48.1030', 'lng' => '2.4380'),
      array('postal_code' => '45330', 'name' => 'Coudray', 'lat' => '48.2720', 'lng' => '2.3679'),
      array('postal_code' => '45330', 'name' => 'Mainvilliers', 'lat' => '48.3006', 'lng' => '2.2816'),
      array('postal_code' => '45330', 'name' => 'Augerville-la-Rivi�re', 'lat' => '48.2514', 'lng' => '2.4372'),
      array('postal_code' => '45340', 'name' => 'Barville-en-G_tinais', 'lat' => '48.1126', 'lng' => '2.4028'),
      array('postal_code' => '45340', 'name' => 'Gaubertin', 'lat' => '48.1234', 'lng' => '2.4203'),
      array('postal_code' => '45331 CEDEX', 'name' => 'Malesherbes', 'lat' => '48.2957', 'lng' => '2.4093'),
      array('postal_code' => '45340', 'name' => 'Montbarrois', 'lat' => '48.0460', 'lng' => '2.4024'),
      array('postal_code' => '45320', 'name' => 'Courtemaux', 'lat' => '48.0510', 'lng' => '2.9364'),
      array('postal_code' => '45312 CEDEX', 'name' => 'Pithiviers', 'lat' => '48.1667', 'lng' => '2.2500'),
      array('postal_code' => '45330', 'name' => 'Le Malesherbois', 'lat' => '48.2964', 'lng' => '2.4053'),
      array('postal_code' => '45340', 'name' => 'Batilly-en-G_tinais', 'lat' => '48.0735', 'lng' => '2.3812'),
      array('postal_code' => '45330', 'name' => 'Nangeville', 'lat' => '48.3094', 'lng' => '2.3240'),
      array('postal_code' => '45330', 'name' => 'Orveau-Bellesauve', 'lat' => '48.2825', 'lng' => '2.3283'),
      array('postal_code' => '45340', 'name' => 'Saint-Loup-des-Vignes', 'lat' => '48.0409', 'lng' => '2.4295'),
      array('postal_code' => '45330', 'name' => 'Labrosse', 'lat' => '48.2429', 'lng' => '2.3926'),
      array('postal_code' => '45340', 'name' => 'Saint-Michel', 'lat' => '48.0691', 'lng' => '2.3781'),
      array('postal_code' => '45340', 'name' => 'Boiscommun', 'lat' => '48.0358', 'lng' => '2.3833'),
      array('postal_code' => '45340', 'name' => 'Beaune-la-Rolande', 'lat' => '48.0712', 'lng' => '2.4314'),
      array('postal_code' => '45340', 'name' => 'Montliard', 'lat' => '48.0230', 'lng' => '2.3991'),
      array('postal_code' => '45340', 'name' => 'Nancray-sur-Rimarde', 'lat' => '48.0683', 'lng' => '2.3324'),
      array('postal_code' => '45340', 'name' => 'Juranville', 'lat' => '48.0544', 'lng' => '2.4957'),
      array('postal_code' => '45360', 'name' => 'Pierrefitte-�s-Bois', 'lat' => '47.5074', 'lng' => '2.7164'),
      array('postal_code' => '45340', 'name' => 'Chambon-la-For�t', 'lat' => '48.0565', 'lng' => '2.2951'),
      array('postal_code' => '45340', 'name' => 'Bordeaux-en-G_tinais', 'lat' => '48.0987', 'lng' => '2.5269'),
      array('postal_code' => '45380', 'name' => 'La Chapelle-Saint-Mesmin', 'lat' => '47.8865', 'lng' => '1.8345'),
      array('postal_code' => '45360', 'name' => 'Saint-Firmin-sur-Loire', 'lat' => '47.6256', 'lng' => '2.7327'),
      array('postal_code' => '45370', 'name' => 'M_zi�res-lez-Cl_ry', 'lat' => '47.8163', 'lng' => '1.8040'),
      array('postal_code' => '45370', 'name' => 'Jouy-le-Potier', 'lat' => '47.7455', 'lng' => '1.8111'),
      array('postal_code' => '45340', 'name' => 'Auxy', 'lat' => '48.1183', 'lng' => '2.4742'),
      array('postal_code' => '45360', 'name' => 'Ch_tillon-sur-Loire', 'lat' => '47.5911', 'lng' => '2.7521'),
      array('postal_code' => '45370', 'name' => 'Mareau-aux-Pr_s', 'lat' => '47.8667', 'lng' => '1.7833'),
      array('postal_code' => '45340', 'name' => 'Nibelle', 'lat' => '48.0221', 'lng' => '2.3278'),
      array('postal_code' => '45360', 'name' => 'Cernoy-en-Berry', 'lat' => '47.5405', 'lng' => '2.6607'),
      array('postal_code' => '45370', 'name' => 'Cl_ry-Saint-Andr_', 'lat' => '47.8222', 'lng' => '1.7509'),
      array('postal_code' => '45370', 'name' => 'Dry', 'lat' => '47.7961', 'lng' => '1.7133'),
      array('postal_code' => '45390', 'name' => 'Desmonts', 'lat' => '48.2273', 'lng' => '2.4963'),
      array('postal_code' => '45380', 'name' => 'Chaingy', 'lat' => '47.8833', 'lng' => '1.7706'),
      array('postal_code' => '45390', 'name' => 'Ondreville-sur-Essonne', 'lat' => '48.2007', 'lng' => '2.4073'),
      array('postal_code' => '45390', 'name' => 'Puiseaux', 'lat' => '48.2048', 'lng' => '2.4715'),
      array('postal_code' => '45390', 'name' => 'Orville', 'lat' => '48.2435', 'lng' => '2.4380'),
      array('postal_code' => '45390', 'name' => 'Bo�sses', 'lat' => '48.1500', 'lng' => '2.4500'),
      array('postal_code' => '45390', 'name' => 'Aulnay-la-Rivi�re', 'lat' => '48.1905', 'lng' => '2.3675'),
      array('postal_code' => '45390', 'name' => 'Grangermont', 'lat' => '48.1893', 'lng' => '2.4249'),
      array('postal_code' => '45390', 'name' => 'Bromeilles', 'lat' => '48.1866', 'lng' => '2.4970'),
      array('postal_code' => '45390', 'name' => 'La Neuville-sur-Essonne', 'lat' => '48.1873', 'lng' => '2.3764'),
      array('postal_code' => '45390', 'name' => 'Briarres-sur-Essonne', 'lat' => '48.2333', 'lng' => '2.4167'),
      array('postal_code' => '45390', 'name' => 'Dimancheville', 'lat' => '48.2361', 'lng' => '2.4318'),
      array('postal_code' => '45390', 'name' => '�chilleuses', 'lat' => '48.1643', 'lng' => '2.4431'),
      array('postal_code' => '45401 CEDEX', 'name' => 'Fleury-les-Aubrais', 'lat' => '47.9333', 'lng' => '1.9181'),
      array('postal_code' => '45403 CEDEX', 'name' => 'Fleury-les-Aubrais', 'lat' => '47.9333', 'lng' => '1.9181'),
      array('postal_code' => '45400', 'name' => 'Semoy', 'lat' => '47.9333', 'lng' => '1.9500'),
      array('postal_code' => '45404 CEDEX', 'name' => 'Fleury-les-Aubrais', 'lat' => '47.9333', 'lng' => '1.9181'),
      array('postal_code' => '45400', 'name' => 'Chanteau', 'lat' => '47.9665', 'lng' => '1.9713'),
      array('postal_code' => '45410', 'name' => 'Trinay', 'lat' => '48.0854', 'lng' => '1.9546'),
      array('postal_code' => '45420', 'name' => 'Faverelles', 'lat' => '47.5757', 'lng' => '2.9301'),
      array('postal_code' => '45409 CEDEX', 'name' => 'Fleury-les-Aubrais', 'lat' => '47.9333', 'lng' => '1.9181'),
      array('postal_code' => '45406 CEDEX', 'name' => 'Fleury-les-Aubrais', 'lat' => '47.9333', 'lng' => '1.9181'),
      array('postal_code' => '45402 CEDEX', 'name' => 'Fleury-les-Aubrais', 'lat' => '47.9333', 'lng' => '1.9181'),
      array('postal_code' => '45410', 'name' => 'Ruan', 'lat' => '48.1120', 'lng' => '1.9390'),
      array('postal_code' => '45420', 'name' => 'Thou', 'lat' => '47.5801', 'lng' => '2.9085'),
      array('postal_code' => '45420', 'name' => 'Batilly-en-Puisaye', 'lat' => '47.6121', 'lng' => '2.8837'),
      array('postal_code' => '45410', 'name' => 'Lion-en-Beauce', 'lat' => '48.1351', 'lng' => '1.9350'),
      array('postal_code' => '45420', 'name' => 'Dammarie-en-Puisaye', 'lat' => '47.6264', 'lng' => '2.8725'),
      array('postal_code' => '45410', 'name' => 'Bucy-le-Roi', 'lat' => '48.0610', 'lng' => '1.9150'),
      array('postal_code' => '45430', 'name' => 'Mardi_', 'lat' => '47.8862', 'lng' => '2.0575'),
      array('postal_code' => '45410', 'name' => 'Artenay', 'lat' => '48.0825', 'lng' => '1.8810'),
      array('postal_code' => '45450', 'name' => 'Donnery', 'lat' => '47.9149', 'lng' => '2.1030'),
      array('postal_code' => '45400', 'name' => 'Fleury-les-Aubrais', 'lat' => '47.9333', 'lng' => '1.9181'),
      array('postal_code' => '45430', 'name' => 'Bou', 'lat' => '47.8743', 'lng' => '2.0475'),
      array('postal_code' => '45420', 'name' => 'Champoulet', 'lat' => '47.6580', 'lng' => '2.9192'),
      array('postal_code' => '45410', 'name' => 'Sougy', 'lat' => '48.0533', 'lng' => '1.7870'),
      array('postal_code' => '45420', 'name' => 'Bonny-sur-Loire', 'lat' => '47.5617', 'lng' => '2.8393'),
      array('postal_code' => '45460', 'name' => 'Bonn_e', 'lat' => '47.7962', 'lng' => '2.3838'),
      array('postal_code' => '45431 CEDEX', 'name' => 'Ch_cy', 'lat' => '47.8940', 'lng' => '2.0230'),
      array('postal_code' => '45470', 'name' => 'Rebr_chien', 'lat' => '47.9873', 'lng' => '2.0443'),
      array('postal_code' => '45460', 'name' => 'Les Bordes', 'lat' => '47.8118', 'lng' => '2.4028'),
      array('postal_code' => '45450', 'name' => 'Fay-aux-Loges', 'lat' => '47.9272', 'lng' => '2.1401'),
      array('postal_code' => '45432 CEDEX', 'name' => 'Ch_cy', 'lat' => '47.8940', 'lng' => '2.0230'),
      array('postal_code' => '45450', 'name' => 'Ingrannes', 'lat' => '47.9910', 'lng' => '2.2113'),
      array('postal_code' => '45470', 'name' => 'Loury', 'lat' => '47.9994', 'lng' => '2.0847'),
      array('postal_code' => '45430', 'name' => 'Ch_cy', 'lat' => '47.8940', 'lng' => '2.0230'),
      array('postal_code' => '45433 CEDEX', 'name' => 'Ch_cy', 'lat' => '47.8940', 'lng' => '2.0230'),
      array('postal_code' => '45460', 'name' => 'Bouzy-la-For�t', 'lat' => '47.8512', 'lng' => '2.3777'),
      array('postal_code' => '45450', 'name' => 'Sully-la-Chapelle', 'lat' => '47.9756', 'lng' => '2.1815'),
      array('postal_code' => '45480', 'name' => 'Erceville', 'lat' => '48.2411', 'lng' => '2.0360'),
      array('postal_code' => '45460', 'name' => 'Saint-Aignan-des-Gu_s', 'lat' => '47.8409', 'lng' => '2.3184'),
      array('postal_code' => '45500', 'name' => 'Saint-Martin-sur-Ocre', 'lat' => '47.6594', 'lng' => '2.6581'),
      array('postal_code' => '45480', 'name' => 'Autruy-sur-Juine', 'lat' => '48.2764', 'lng' => '2.1011'),
      array('postal_code' => '45500', 'name' => 'Saint-Gondon', 'lat' => '47.6979', 'lng' => '2.5422'),
      array('postal_code' => '45480', 'name' => 'Bazoches-les-Gallerandes', 'lat' => '48.1654', 'lng' => '2.0432'),
      array('postal_code' => '45480', 'name' => 'Chaussy', 'lat' => '48.1703', 'lng' => '1.9809'),
      array('postal_code' => '45480', 'name' => 'Andonville', 'lat' => '48.2708', 'lng' => '2.0311'),
      array('postal_code' => '45490', 'name' => 'Mign�res', 'lat' => '48.0474', 'lng' => '2.6269'),
      array('postal_code' => '45500', 'name' => 'Poilly-lez-Gien', 'lat' => '47.6772', 'lng' => '2.5974'),
      array('postal_code' => '45480', 'name' => 'Outarville', 'lat' => '48.2139', 'lng' => '2.0220'),
      array('postal_code' => '45480', 'name' => 'Boisseaux', 'lat' => '48.2561', 'lng' => '1.9864'),
      array('postal_code' => '45480', 'name' => 'Jouy-en-Pithiverais', 'lat' => '48.1417', 'lng' => '2.1125'),
      array('postal_code' => '45480', 'name' => 'Ch_tillon-le-Roi', 'lat' => '48.1618', 'lng' => '2.1035'),
      array('postal_code' => '45490', 'name' => 'Lorcy', 'lat' => '48.0543', 'lng' => '2.5316'),
      array('postal_code' => '45480', 'name' => 'L_ouville', 'lat' => '48.2239', 'lng' => '2.0880'),
      array('postal_code' => '45500', 'name' => 'Autry-le-Ch_tel', 'lat' => '47.5989', 'lng' => '2.6020'),
      array('postal_code' => '45500', 'name' => 'Nevoy', 'lat' => '47.7159', 'lng' => '2.5779'),
      array('postal_code' => '45490', 'name' => 'Treilles-en-G_tinais', 'lat' => '48.0788', 'lng' => '2.6611'),
      array('postal_code' => '45480', 'name' => 'Charmont-en-Beauce', 'lat' => '48.2319', 'lng' => '2.1057'),
      array('postal_code' => '45470', 'name' => 'Tra�nou', 'lat' => '47.9735', 'lng' => '2.1040'),
      array('postal_code' => '45490', 'name' => 'Courtempierre', 'lat' => '48.1039', 'lng' => '2.6154'),
      array('postal_code' => '45480', 'name' => 'Greneville-en-Beauce', 'lat' => '48.1822', 'lng' => '2.1108'),
      array('postal_code' => '45460', 'name' => 'Bray-en-Val', 'lat' => '47.8286', 'lng' => '2.3664'),
      array('postal_code' => '45500', 'name' => 'Saint-Brisson-sur-Loire', 'lat' => '47.6469', 'lng' => '2.6823'),
      array('postal_code' => '45503 CEDEX', 'name' => 'Gien', 'lat' => '47.6933', 'lng' => '2.6309'),
      array('postal_code' => '45490', 'name' => 'Gondreville', 'lat' => '48.0504', 'lng' => '2.6543'),
      array('postal_code' => '45490', 'name' => 'Mignerette', 'lat' => '48.0561', 'lng' => '2.6012'),
      array('postal_code' => '45490', 'name' => 'Corbeilles', 'lat' => '48.0720', 'lng' => '2.5503'),
      array('postal_code' => '45490', 'name' => 'Pr_fontaines', 'lat' => '48.1095', 'lng' => '2.6900'),
      array('postal_code' => '45502 CEDEX', 'name' => 'Gien', 'lat' => '47.6933', 'lng' => '2.6309'),
      array('postal_code' => '45490', 'name' => 'Sceaux-du-G_tinais', 'lat' => '48.1059', 'lng' => '2.5957'),
      array('postal_code' => '45500', 'name' => 'Gien', 'lat' => '47.6933', 'lng' => '2.6309'),
      array('postal_code' => '45501 CEDEX', 'name' => 'Gien', 'lat' => '47.6933', 'lng' => '2.6309'),
      array('postal_code' => '45504 CEDEX', 'name' => 'Gien', 'lat' => '47.6933', 'lng' => '2.6309'),
      array('postal_code' => '45510', 'name' => 'Neuvy-en-Sullias', 'lat' => '47.7947', 'lng' => '2.2444'),
      array('postal_code' => '45510', 'name' => 'Vienne-en-Val', 'lat' => '47.8004', 'lng' => '2.1346'),
      array('postal_code' => '45530', 'name' => 'Sury-aux-Bois', 'lat' => '47.9668', 'lng' => '2.3414'),
      array('postal_code' => '45520', 'name' => 'Gidy', 'lat' => '47.9854', 'lng' => '1.8382'),
      array('postal_code' => '45530', 'name' => 'Vitry-aux-Loges', 'lat' => '47.9333', 'lng' => '2.2667'),
      array('postal_code' => '45520', 'name' => 'Hu�tre', 'lat' => '48.0190', 'lng' => '1.7961'),
      array('postal_code' => '45510', 'name' => 'Vannes-sur-Cosson', 'lat' => '47.7133', 'lng' => '2.2122'),
      array('postal_code' => '45510', 'name' => 'Tigy', 'lat' => '47.7937', 'lng' => '2.1977'),
      array('postal_code' => '45520', 'name' => 'Chevilly', 'lat' => '48.0297', 'lng' => '1.8740'),
      array('postal_code' => '45520', 'name' => 'Cercottes', 'lat' => '47.9864', 'lng' => '1.8830'),
      array('postal_code' => '45590', 'name' => 'Saint-Cyr-en-Val', 'lat' => '47.8318', 'lng' => '1.9667'),
      array('postal_code' => '45550', 'name' => 'Saint-Denis-de-l\'H�tel', 'lat' => '47.8667', 'lng' => '2.1167'),
      array('postal_code' => '45530', 'name' => 'Seichebri�res', 'lat' => '47.9692', 'lng' => '2.2686'),
      array('postal_code' => '45530', 'name' => 'Combreux', 'lat' => '47.9552', 'lng' => '2.3023'),
      array('postal_code' => '45570', 'name' => 'Ouzouer-sur-Loire', 'lat' => '47.7664', 'lng' => '2.4804'),
      array('postal_code' => '45560', 'name' => 'Saint-Denis-en-Val', 'lat' => '47.8732', 'lng' => '1.9660'),
      array('postal_code' => '45600', 'name' => 'Lion-en-Sullias', 'lat' => '47.7262', 'lng' => '2.4896'),
      array('postal_code' => '45600', 'name' => 'Guilly', 'lat' => '47.8042', 'lng' => '2.2761'),
      array('postal_code' => '45570', 'name' => 'Dampierre-en-Burly', 'lat' => '47.7614', 'lng' => '2.5196'),
      array('postal_code' => '45600', 'name' => 'Saint-P�re-sur-Loire', 'lat' => '47.7667', 'lng' => '2.3667'),
      array('postal_code' => '45640', 'name' => 'Sandillon', 'lat' => '47.8451', 'lng' => '2.0316'),
      array('postal_code' => '45700', 'name' => 'Chevillon-sur-Huillard', 'lat' => '47.9620', 'lng' => '2.6260'),
      array('postal_code' => '45702 CEDEX', 'name' => 'Villemandeur', 'lat' => '47.9870', 'lng' => '2.7180'),
      array('postal_code' => '45771 CEDEX', 'name' => 'Saran', 'lat' => '47.9501', 'lng' => '1.8760'),
      array('postal_code' => '45600', 'name' => 'Sully-sur-Loire', 'lat' => '47.7637', 'lng' => '2.3724'),
      array('postal_code' => '45700', 'name' => 'Saint-Hilaire-sur-Puiseaux', 'lat' => '47.9040', 'lng' => '2.7039'),
      array('postal_code' => '45600', 'name' => 'Saint-Florent', 'lat' => '47.6833', 'lng' => '2.4833'),
      array('postal_code' => '45680', 'name' => 'Dordives', 'lat' => '48.1425', 'lng' => '2.7678'),
      array('postal_code' => '45620', 'name' => 'Cerdon', 'lat' => '47.6357', 'lng' => '2.3628'),
      array('postal_code' => '45651 CEDEX', 'name' => 'Saint-Jean-le-Blanc', 'lat' => '47.8933', 'lng' => '1.9154'),
      array('postal_code' => '45600', 'name' => 'Villemurlin', 'lat' => '47.6857', 'lng' => '2.3347'),
      array('postal_code' => '45600', 'name' => 'Saint-Aignan-le-Jaillard', 'lat' => '47.7431', 'lng' => '2.4367'),
      array('postal_code' => '45700', 'name' => 'Saint-Maurice-sur-Fessard', 'lat' => '47.9923', 'lng' => '2.6216'),
      array('postal_code' => '45700', 'name' => 'Pannes', 'lat' => '48.0194', 'lng' => '2.6676'),
      array('postal_code' => '45700', 'name' => 'Conflans-sur-Loing', 'lat' => '47.9528', 'lng' => '2.7886'),
      array('postal_code' => '45650', 'name' => 'Saint-Jean-le-Blanc', 'lat' => '47.8933', 'lng' => '1.9154'),
      array('postal_code' => '45700', 'name' => 'Lombreuil', 'lat' => '47.9407', 'lng' => '2.6311'),
      array('postal_code' => '45750', 'name' => 'Saint-Pryv_-Saint-Mesmin', 'lat' => '47.8818', 'lng' => '1.8695'),
      array('postal_code' => '45630', 'name' => 'Beaulieu-sur-Loire', 'lat' => '47.5432', 'lng' => '2.8162'),
      array('postal_code' => '45655 CEDEX', 'name' => 'Saint-Jean-le-Blanc', 'lat' => '47.8933', 'lng' => '1.9154'),
      array('postal_code' => '45760', 'name' => 'Marigny-les-Usages', 'lat' => '47.9580', 'lng' => '2.0146'),
      array('postal_code' => '45700', 'name' => 'Montcresson', 'lat' => '47.9056', 'lng' => '2.8080'),
      array('postal_code' => '45700', 'name' => 'Solterre', 'lat' => '47.9051', 'lng' => '2.7416'),
      array('postal_code' => '45700', 'name' => 'Cortrat', 'lat' => '47.8968', 'lng' => '2.7645'),
      array('postal_code' => '45700', 'name' => 'Villemandeur', 'lat' => '47.9870', 'lng' => '2.7180'),
      array('postal_code' => '45700', 'name' => 'Mormant-sur-Vernisson', 'lat' => '47.9482', 'lng' => '2.7372'),
      array('postal_code' => '45600', 'name' => 'Viglain', 'lat' => '47.7283', 'lng' => '2.3026'),
      array('postal_code' => '45701 CEDEX', 'name' => 'Villemandeur', 'lat' => '47.9870', 'lng' => '2.7180'),
      array('postal_code' => '45760', 'name' => 'Boigny-sur-Bionne', 'lat' => '47.9333', 'lng' => '2.0167'),
      array('postal_code' => '45656 CEDEX', 'name' => 'Saint-Jean-le-Blanc', 'lat' => '47.8933', 'lng' => '1.9154'),
      array('postal_code' => '45709 CEDEX', 'name' => 'Villemandeur', 'lat' => '47.9870', 'lng' => '2.7180'),
      array('postal_code' => '45777 CEDEX', 'name' => 'Saran', 'lat' => '47.9501', 'lng' => '1.8760'),
      array('postal_code' => '45730', 'name' => 'Saint-Beno�t-sur-Loire', 'lat' => '47.8056', 'lng' => '2.3127'),
      array('postal_code' => '45620', 'name' => 'Isdes', 'lat' => '47.6713', 'lng' => '2.2556'),
      array('postal_code' => '45760', 'name' => 'Vennecy', 'lat' => '47.9546', 'lng' => '2.0546'),
      array('postal_code' => '45774 CEDEX', 'name' => 'Saran', 'lat' => '47.9501', 'lng' => '1.8760'),
      array('postal_code' => '45700', 'name' => 'Villevoques', 'lat' => '48.0300', 'lng' => '2.6274'),
      array('postal_code' => '45720', 'name' => 'Coullons', 'lat' => '47.6210', 'lng' => '2.4926'),
      array('postal_code' => '45700', 'name' => 'Vimory', 'lat' => '47.9479', 'lng' => '2.6870'),
      array('postal_code' => '45805 CEDEX', 'name' => 'Saint-Jean-de-Braye', 'lat' => '47.9130', 'lng' => '1.9770'),
      array('postal_code' => '45803 CEDEX', 'name' => 'Saint-Jean-de-Braye', 'lat' => '47.9130', 'lng' => '1.9770'),
      array('postal_code' => '45800', 'name' => 'Combleux', 'lat' => '47.9000', 'lng' => '1.9920'),
      array('postal_code' => '45806 CEDEX', 'name' => 'Saint-Jean-de-Braye', 'lat' => '47.9130', 'lng' => '1.9770'),
      array('postal_code' => '45740', 'name' => 'Lailly-en-Val', 'lat' => '47.7696', 'lng' => '1.6866'),
      array('postal_code' => '45801 CEDEX', 'name' => 'Saint-Jean-de-Braye', 'lat' => '47.9130', 'lng' => '1.9770'),
      array('postal_code' => '45800', 'name' => 'Saint-Jean-de-Braye', 'lat' => '47.9130', 'lng' => '1.9770'),
      array('postal_code' => '45770', 'name' => 'Saran', 'lat' => '47.9501', 'lng' => '1.8760'),
      array('postal_code' => '45775 CEDEX', 'name' => 'Saran', 'lat' => '47.9501', 'lng' => '1.8760'),
      array('postal_code' => '45900 CEDEX 9', 'name' => 'La Source', 'lat' => '47.8295', 'lng' => '1.9272'),
      array('postal_code' => '45808 CEDEX', 'name' => 'Saint-Jean-de-Braye', 'lat' => '47.9130', 'lng' => '1.9770'),
      array('postal_code' => '45811 CEDEX', 'name' => 'Saint-Jean-de-Braye', 'lat' => '47.9130', 'lng' => '1.9770'),
      array('pos