<?php $__env->startSection('content'); ?>

<?php
    $formattedDate = \Carbon\Carbon::parse($quote->quote_date)->format('d/m/Y');
?>

<!-- Client Info Section -->
<section class="py-6 flex justify-end">
    <div class="grid grid-cols-2 gap-x-6 gap-y-1.5 text-sm">
        <span class="font-bold text-primary text-right">Client:</span>
        <span class="font-bold text-gray-900"><?php echo e($quote->client_name); ?></span>
        <span class="font-bold text-primary text-right">Téléphone:</span>
        <span class="font-bold text-gray-900"><?php echo e($project->user->phone ?? '+212 X XX XX XX XX'); ?></span>
        <span class="font-bold text-primary text-right">Date:</span>
        <span class="font-bold text-gray-900"><?php echo e($formattedDate); ?></span>
    </div>
</section>

<!-- Project Title -->
<div class="bg-accent py-3 px-6 rounded mb-6">
    <h2 class="text-primary font-extrabold text-base uppercase leading-tight">
        Développement d'un site <?php echo e($project->project_type->name); ?> : <?php echo e($project->title ?? $quote->client_name); ?>

    </h2>
</div>

<!-- Main Table -->
<div class="border-2 border-primary rounded overflow-hidden mb-6">
    <table class="w-full text-left border-collapse">
        <thead class="bg-primary text-white">
            <tr>
                <th class="py-2.5 px-4 w-10 text-center font-bold text-sm">N°</th>
                <th class="py-2.5 px-5 font-bold text-sm">DESIGNATION</th>
                <th class="py-2.5 px-5 w-32 text-right font-bold text-sm">PRIX</th>
            </tr>
        </thead>
        <tbody class="text-gray-800 bg-white">
            <tr>
                <td class="py-5 px-4 align-top text-center border-r border-primary font-bold text-lg text-primary">
                    1
                </td>
                <td class="py-5 px-5 align-top border-r border-primary">
                    <div class="space-y-4">
                        <!-- Main Title -->
                        <h3 class="text-primary font-extrabold text-base leading-tight">
                            1. Développement d'un site <?php echo e($project->project_type->name); ?> : <?php echo e($project->title ?? $quote->client_name); ?>

                        </h3>

                        <!-- Section 1.1 -->
                        <div>
                            <h4 class="font-bold text-gray-900 mb-1.5 text-sm">1.1 Installation et configuration du CMS <?php echo e($cms_name); ?></h4>
                            <ul class="list-none space-y-0.5 pl-4 text-xs leading-relaxed">
                                <li class="list-bullet">Installation complète de <?php echo e($cms_name); ?> sur l'hébergement du client.</li>
                                <li class="list-bullet">Installation et personnalisation d'un thème premium adapté au secteur <?php echo e($project->project_type->name); ?>.</li>
                                <li class="list-bullet">Configuration générale du site en langue <?php echo e(is_array($project->languages) ? implode(', ', $project->languages) : $project->languages); ?>.</li>
                                <li class="list-bullet">Intégration du contenu fourni : textes, images, logo, photos.</li>
                            </ul>
                        </div>

                        <!-- Section 1.2 -->
                        <div>
                            <h4 class="font-bold text-gray-900 mb-1.5 text-sm">1.2 Design et intégration</h4>
                            <ul class="list-none space-y-0.5 pl-4 text-xs leading-relaxed">
                                <li class="list-bullet">Personnalisation visuelle (charte graphique, couleurs, typographies) en cohérence avec l'identité - <?php echo e($front_design->name); ?>.</li>
                                <li class="list-bullet">Création et intégration des pages / sections suivantes :
                                    <ul class="list-none pl-5 mt-1 space-y-1 italic text-xs">
                                        <?php $__currentLoopData = $pagesGrouped; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoryName => $categoryPages): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="list-bullet">
                                                <strong><?php echo e($categoryName); ?> :</strong>
                                                <ul class="list-none pl-5 mt-0.5 space-y-0.5 text-[11px] not-italic text-gray-700">
                                                    <?php $__currentLoopData = $categoryPages->unique('id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li>▪ <?php echo e($page->name); ?><?php echo e($page->description ? ' : ' . $page->description : ''); ?></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </li>
                                <li class="list-bullet">Mise en page responsive (ordinateur, tablette, mobile).</li>
                                <li class="list-bullet">Intégration d'un formulaire d'acquisition (Nom, Email, Téléphone, Message).</li>
                                <li class="list-bullet">Wireframe inclus.</li>
                                <li class="list-bullet">Bibliothèque d'images libres de droits incluse (Freepik).</li>
                                <li class="list-bullet">Licence d'icônes FontAwesome incluse.</li>
                                <li class="list-bullet">Installation des systèmes antispam et captchas.</li>
                                <li class="list-bullet">Création de bannières et carrousels (sliders) si nécessaire.</li>
                                <li class="list-bullet">Nombre de retours inclus : 3 allers-retours.</li>
                            </ul>
                        </div>

                        <?php if(count($features) > 0): ?>
                        <!-- Section 1.3 -->
                        <div>
                            <h4 class="font-bold text-gray-900 mb-1.5 text-sm">1.3 Fonctionnalités spécifiques</h4>
                            <ul class="list-none space-y-0.5 pl-4 text-xs leading-relaxed">
                                <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="list-bullet"><?php echo e($feature->title); ?><?php echo e($feature->description ? ' : ' . $feature->description : ''); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <?php endif; ?>

                        <!-- Section 2 -->
                        <div>
                            <h4 class="font-bold text-gray-900 mb-1.5 text-sm">2. Modules complémentaires</h4>

                            <!-- 2.1 SEO -->
                            <div class="mb-2 ml-3">
                                <h5 class="font-bold text-gray-800 text-xs mb-1">2.1 Optimisations SEO</h5>
                                <ul class="list-none space-y-0.5 pl-4 text-xs leading-relaxed">
                                    <li class="list-bullet">Création d'une architecture de pages optimisée pour le référencement naturel.</li>
                                    <li class="list-bullet">Intégration d'un plan de site (sitemap) pour un meilleur crawl.</li>
                                    <li class="list-bullet">Installation d'un module d'optimisation générale du site.</li>
                                    <li class="list-bullet">Installation d'un module d'optimisation du poids des images.</li>
                                    <li class="list-bullet">Installation et configuration de Google Analytics, Google Search Console et Google My Business.</li>
                                    <li class="list-bullet">Optimisation du maillage interne.</li>
                                    <li class="list-bullet">Hiérarchisation du contenu.</li>
                                </ul>
                            </div>

                            <!-- 2.2 Marketing -->
                            <div class="mb-2 ml-3">
                                <h5 class="font-bold text-gray-800 text-xs mb-1">2.2 Optimisations marketing</h5>
                                <ul class="list-none space-y-0.5 pl-4 text-xs leading-relaxed">
                                    <?php if($project->type_id == 1): ?>
                                        <li class="list-bullet">Mise en avant des appels à l'action (contact, demande de devis, panier).</li>
                                        <li class="list-bullet">Mise en avant des arguments commerciaux et des valeurs de la société.</li>
                                        <li class="list-bullet">Mise en avant des coordonnées téléphoniques.</li>
                                        <li class="list-bullet">Configuration des moyens de paiement en ligne.</li>
                                        <li class="list-bullet">Configuration des modes de livraison.</li>
                                    <?php else: ?>
                                        <li class="list-bullet">Mise en avant des appels à l'action (contact, demande de devis).</li>
                                        <li class="list-bullet">Mise en avant des arguments commerciaux et des valeurs de la société.</li>
                                        <li class="list-bullet">Mise en avant des coordonnées téléphoniques.</li>
                                    <?php endif; ?>
                                </ul>
                            </div>

                            <!-- 2.3 Security -->
                            <div class="mb-2 ml-3">
                                <h5 class="font-bold text-gray-800 text-xs mb-1">2.3 Sécurité et sauvegarde</h5>
                                <ul class="list-none space-y-0.5 pl-4 text-xs leading-relaxed">
                                    <li class="list-bullet">Installation d'un certificat HTTPS.</li>
                                    <li class="list-bullet">Installation et configuration d'un pare-feu et antivirus.</li>
                                    <li class="list-bullet">Installation d'un système de sauvegarde automatique.</li>
                                    <li class="list-bullet">Mise en place d'un système de cache.</li>
                                </ul>
                            </div>

                            <!-- 2.4 Compatibility -->
                            <div class="ml-3">
                                <h5 class="font-bold text-gray-800 text-xs mb-1">2.4 Compatibilité et administration</h5>
                                <ul class="list-none space-y-0.5 pl-4 text-xs leading-relaxed">
                                    <li class="list-bullet">Site compatible avec Chrome, Firefox, Safari, Edge et mobile.</li>
                                    <li class="list-bullet">Création des comptes administrateurs et contributeurs.</li>
                                    <li class="list-bullet">Assistance utilisateur pour la prise en main de <?php echo e($cms_name); ?>.</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </td>
                <td class="py-5 px-5 align-top text-right font-black text-xl text-primary">
                    <?php echo e(number_format($pricing['total_ht'], 0, '', ' ')); ?> DHS
                </td>
            </tr>
        </tbody>
    </table>
</div>

<!-- Pricing Summary -->
<div class="flex justify-end mb-6">
    <div class="bg-white border-2 border-primary rounded overflow-hidden shadow-md w-80">
        <div class="grid grid-cols-2">
            <div class="bg-primary text-white px-5 py-2.5 font-bold text-sm">Total HT</div>
            <div class="bg-accent px-5 py-2.5 text-right font-black text-base text-primary"><?php echo e(number_format($pricing['total_ht'], 0, '', ' ')); ?> DHS</div>

            <div class="bg-primary text-white px-5 py-2.5 font-bold text-sm">TVA <?php echo e($pricing['tva_rate']); ?>%</div>
            <div class="bg-accent px-5 py-2.5 text-right font-black text-base text-primary"><?php echo e(number_format($pricing['tva'], 0, '', ' ')); ?> DHS</div>

            <div class="bg-primary text-white px-5 py-3 font-bold text-base">Total TTC</div>
            <div class="bg-accent px-5 py-3 text-right font-black text-xl text-primary"><?php echo e(number_format($pricing['total_ttc'], 0, '', ' ')); ?> DHS</div>
        </div>
    </div>
</div>

<!-- Payment Terms -->
<div class="mb-4">
    <p class="text-primary font-bold text-base leading-tight">
        Arrêté le présent devis sous le montant de <?php echo e(number_format($pricing['total_ttc'], 0, '', ' ')); ?> DHS TTC
    </p>
</div>

<div class="mb-5">
    <p class="text-gray-800 font-semibold text-sm">
        <span class="text-primary font-bold">Modalité de paiement :</span> 50%-25%-25%
    </p>
</div>

<!-- Payment Information -->
<div class="bg-gray-50 border-l-4 border-primary p-5 rounded mb-6">
    <h3 class="font-bold text-primary mb-2.5 text-sm">Informations de paiement :</h3>
    <p class="text-xs mb-1.5 leading-relaxed"><strong class="text-gray-900">Bank Name:</strong> <span class="text-gray-700"><?php echo e($company['bank_name']); ?></span></p>
    <p class="text-xs mb-1.5 leading-relaxed"><strong class="text-gray-900">Titulaire du compte :</strong> <span class="text-gray-700"><?php echo e($company['bank_account']); ?></span></p>
    <p class="text-xs leading-relaxed"><strong class="text-gray-900">RIB :</strong> <span class="text-gray-700"><?php echo e($company['rib']); ?></span></p>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('majormedia.project::quote.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/chimatchapp81/public_html/majorweb-tunnel/plugins/majormedia/project/views/quote/quote.blade.php ENDPATH**/ ?>