<?php $__env->startSection('content'); ?>

<?php
    $formattedDate = \Carbon\Carbon::parse($quote->quote_date)->format('d/m/Y');
?>

<!-- Client Information -->
<div style="margin: 15px 0;">
    <p style="margin: 5px 0; font-size: 11px;">
        <span style="color: #3E16A9; font-weight: 700; display: inline-block; width: 100px;">Client:</span>
        <span style="color: #000; font-weight: 600;"><?php echo e($quote->client_name); ?></span>
    </p>
    <p style="margin: 5px 0; font-size: 11px;">
        <span style="color: #3E16A9; font-weight: 700; display: inline-block; width: 100px;">Téléphone:</span>
        <span style="color: #000; font-weight: 600;"><?php echo e($quote->client_phone ?? '+212 X XX XX XX XX'); ?></span>
    </p>
    <p style="margin: 5px 0; font-size: 11px;">
        <span style="color: #3E16A9; font-weight: 700; display: inline-block; width: 100px;">Date:</span>
        <span style="color: #000; font-weight: 600;"><?php echo e($formattedDate); ?></span>
    </p>
</div>

<!-- Project Title Banner -->
<div style="background-color: #12E8D8; color: #3E16A9; padding: 12px 15px; font-size: 14px; font-weight: 700; margin: 15px 0;">
    Développement d'un site <?php echo e($project->project_type->name); ?> : <?php echo e($project->title ?? $quote->client_name); ?>

</div>

<!-- Items Table -->
<table style="width: 100%; border-collapse: collapse; margin: 15px 0;">
    <thead>
        <tr>
            <th style="background-color: #3E16A9; color: white; padding: 8px; text-align: center; font-weight: 700; font-size: 11px; width: 40px;">N°</th>
            <th style="background-color: #3E16A9; color: white; padding: 8px; text-align: left; font-weight: 700; font-size: 11px;">DESIGNATION</th>
            <th style="background-color: #3E16A9; color: white; padding: 8px; text-align: right; font-weight: 700; font-size: 11px; width: 110px;">PRIX</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td style="padding: 12px 10px; border: 2px solid #3E16A9; text-align: center; font-weight: 700; font-size: 18px; color: #3E16A9; vertical-align: top;">1</td>
            <td style="padding: 12px 10px; border: 2px solid #3E16A9; vertical-align: top;">
                <div style="color: #3E16A9; font-weight: 700; font-size: 13px; margin: 0 0 8px 0;">
                    Développement d'un site <?php echo e($project->project_type->name); ?>

                </div>

                <!-- Section 1.1 -->
                <div style="margin: 8px 0;">
                    <div style="font-weight: 700; font-size: 11px; margin: 0 0 4px 0;">1.1 Installation et configuration du CMS <?php echo e($cms_name); ?></div>
                    <ul style="margin: 3px 0 8px 0; padding-left: 18px;">
                        <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Installation complète de <?php echo e($cms_name); ?> sur l'hébergement du client.</li>
                        <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Installation et personnalisation d'un thème premium adapté.</li>
                        <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Configuration générale du site en langue: <?php echo e(is_array($project->languages) ? implode(', ', $project->languages) : $project->languages); ?>.</li>
                        <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Intégration du contenu fourni : textes, images, logo.</li>
                    </ul>
                </div>

                <!-- Section 1.2 -->
                <div style="margin: 8px 0;">
                    <div style="font-weight: 700; font-size: 11px; margin: 0 0 4px 0;">1.2 Design et intégration</div>
                    <ul style="margin: 3px 0 8px 0; padding-left: 18px;">
                        <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Personnalisation visuelle (charte graphique, couleurs, typographies) - <?php echo e($front_design->name); ?>.</li>
                        <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Création et intégration des pages / sections suivantes :
                            <ul style="margin-left: 15px; margin-top: 3px;">
                                <?php $__currentLoopData = $pages->unique('id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;"><?php echo e($page->name); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </li>
                        <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Mise en page responsive (ordinateur, tablette, mobile).</li>
                        <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Intégration d'un formulaire d'acquisition (Nom, Email, Téléphone, Message).</li>
                        <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Wireframe inclus.</li>
                        <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Bibliothèque d'images libres de droits incluse (Freepik).</li>
                        <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Licence d'icônes FontAwesome incluse.</li>
                        <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Installation des systèmes antispam et captchas.</li>
                        <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Création de bannières et carrousels (sliders) si nécessaire.</li>
                        <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Nombre de retours inclus : 3 allers-retours.</li>
                    </ul>
                </div>

                <?php if(count($features) > 0): ?>
                <!-- Section 1.3 -->
                <div style="margin: 8px 0;">
                    <div style="font-weight: 700; font-size: 11px; margin: 0 0 4px 0;">1.3 Fonctionnalités</div>
                    <ul style="margin: 3px 0 8px 0; padding-left: 18px;">
                        <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;"><?php echo e($feature->title); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endif; ?>

                <!-- Section 2 -->
                <div style="margin: 8px 0;">
                    <div style="font-weight: 700; font-size: 11px; margin: 0 0 4px 0;">2. Modules complémentaires</div>

                    <div style="margin-left: 15px; margin-top: 8px;">
                        <div style="font-weight: 700; font-size: 11px; margin: 0 0 4px 0;">2.1 Optimisations SEO</div>
                        <ul style="margin: 3px 0 8px 0; padding-left: 18px;">
                            <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Création d'une architecture de pages optimisée pour le référencement naturel.</li>
                            <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Intégration d'un plan de site (sitemap) pour un meilleur crawl.</li>
                            <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Installation d'un module d'optimisation générale du site.</li>
                            <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Installation d'un module d'optimisation du poids des images.</li>
                            <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Installation et configuration de Google Analytics, Google Search Console.</li>
                            <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Optimisation du maillage interne.</li>
                        </ul>
                    </div>

                    <div style="margin-left: 15px; margin-top: 8px;">
                        <div style="font-weight: 700; font-size: 11px; margin: 0 0 4px 0;">2.2 Sécurité et sauvegarde</div>
                        <ul style="margin: 3px 0 8px 0; padding-left: 18px;">
                            <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Installation d'un certificat HTTPS.</li>
                            <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Installation et configuration d'un pare-feu et antivirus.</li>
                            <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Installation d'un système de sauvegarde automatique.</li>
                            <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Mise en place d'un système de cache.</li>
                        </ul>
                    </div>

                    <div style="margin-left: 15px; margin-top: 8px;">
                        <div style="font-weight: 700; font-size: 11px; margin: 0 0 4px 0;">2.3 Compatibilité et administration</div>
                        <ul style="margin: 3px 0 8px 0; padding-left: 18px;">
                            <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Site compatible avec Chrome, Firefox, Safari, Edge et mobile.</li>
                            <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Création des comptes administrateurs et contributeurs.</li>
                            <li style="margin: 2px 0; font-size: 10px; line-height: 1.4;">Assistance utilisateur pour la prise en main de <?php echo e($cms_name); ?>.</li>
                        </ul>
                    </div>
                </div>
            </td>
            <td style="padding: 12px 10px; border: 2px solid #3E16A9; text-align: right; font-weight: 700; font-size: 15px; color: #3E16A9; vertical-align: middle;"><?php echo e(number_format($pricing['total_ht'], 0, '', ' ')); ?> DHS</td>
        </tr>
    </tbody>
</table>

<!-- Pricing Summary -->
<table style="width: 230px; float: right; margin: 20px 0; border-collapse: collapse;">
    <tr>
        <td style="background-color: #3E16A9; color: white; font-size: 11px; padding: 8px 14px; font-weight: 700; text-align: left; border: none;">Total HT</td>
        <td style="background-color: #3E16A9; color: white; font-size: 11px; padding: 8px 14px; font-weight: 700; text-align: right; border: none;"><?php echo e(number_format($pricing['total_ht'], 0, '', ' ')); ?> DHS</td>
    </tr>
    <tr>
        <td style="background-color: #3E16A9; color: #12E8D8; font-size: 11px; padding: 8px 14px; font-weight: 700; text-align: left; border: none;">TVA <?php echo e($pricing['tva_rate']); ?>%</td>
        <td style="background-color: #3E16A9; color: #12E8D8; font-size: 11px; padding: 8px 14px; font-weight: 700; text-align: right; border: none;"><?php echo e(number_format($pricing['tva'], 0, '', ' ')); ?> DHS</td>
    </tr>
    <tr>
        <td style="background-color: #12E8D8; color: #3E16A9; font-size: 13px; padding: 8px 14px; font-weight: 700; text-align: left; border: none;">Total TTC</td>
        <td style="background-color: #12E8D8; color: #3E16A9; font-size: 13px; padding: 8px 14px; font-weight: 700; text-align: right; border: none;"><?php echo e(number_format($pricing['total_ttc'], 0, '', ' ')); ?> DHS</td>
    </tr>
</table>

<div style="clear: both;"></div>

<!-- Payment Terms -->
<div style="margin: 20px 0 15px 0;">
    <p style="font-size: 12px; font-weight: 700; color: #3E16A9; margin: 5px 0;">
        Arrêté le présent devis sous le montant de <?php echo e(number_format($pricing['total_ttc'], 0, '', ' ')); ?> DHS TTC
    </p>
    <p style="font-size: 11px; margin-top: 5px;">
        <span style="font-weight: 700;">Modalité de paiement :</span> 50%-25%-25%
    </p>
</div>

<!-- Payment Information -->
<div style="margin: 16px 0; padding: 11px 14px; background-color: #F5F5F5; border-left: 3px solid #3E16A9;">
    <div style="font-weight: 700; font-size: 11px; color: #3E16A9; margin-bottom: 9px;">Informations de paiement :</div>
    <p style="margin: 4px 0; font-size: 10px;"><strong>Bank Name:</strong> BANK OF AFRICA</p>
    <p style="margin: 4px 0; font-size: 10px;"><strong>Titulaire du compte :</strong> MAJOR MEDIA SARL AU</p>
    <p style="margin: 4px 0; font-size: 10px;"><strong>RIB :</strong> 0110 1000 0026 2100 0013 3087</p>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('majormedia.project::quote.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/chimatchapp81/public_html/majorweb-tunnel/plugins/majormedia/project/views/quote/quote.blade.php ENDPATH**/ ?>